#include "xanim.h"

static int xanim_codecs_initialized = 0;

#define CENTERJSAMPLE 128
#define MAXJSAMPLE 255

extern void JPG_Setup_Samp_Limit_Table(void *anim_hdr);

void init_xanimcodecs()
  {
  int i;

  if(xanim_codecs_initialized)
    return;
  xanim_codecs_initialized = 1;

  /* We make no gamma correction */
  
  for(i = 0; i < 256; i++)
    {
    xa_gamma_adj[i] = i | i << 8;
    }
  
  for(i = 0; i < 32; i++)
    {
    qt_gamma_adj[i] = xa_gamma_adj[ ((i<<3)|(i>>2)) ];
    }

  JPG_Setup_Samp_Limit_Table((void*)0);
  }
