#include <quicktime/lqt.h>
#include <quicktime/colormodels.h>
#include <funcprotos.h>
#include "lqt_xanim.h"

xaULONG QT_Decode_RLE1(xaUBYTE *image, xaUBYTE *delta, xaULONG dsize,
                       XA_DEC_INFO *dec_info);
xaULONG QT_Decode_RLE2(xaUBYTE *image, xaUBYTE *delta, xaULONG dsize,
                       XA_DEC_INFO *dec_info);
xaULONG QT_Decode_RLE4(xaUBYTE *image, xaUBYTE *delta, xaULONG dsize,
                       XA_DEC_INFO *dec_info);

xaULONG QT_Decode_RLE8(xaUBYTE *image, xaUBYTE *delta, xaULONG dsize,
                       XA_DEC_INFO *dec_info);
xaULONG QT_Decode_RLE16(xaUBYTE *image, xaUBYTE *delta, xaULONG dsize,
                        XA_DEC_INFO *dec_info);
xaULONG QT_Decode_RLE24(xaUBYTE *image, xaUBYTE *delta, xaULONG dsize,
                        XA_DEC_INFO *dec_info);
xaULONG QT_Decode_RLE32(xaUBYTE *image, xaUBYTE *delta, xaULONG dsize,
                        XA_DEC_INFO *dec_info);

static int decode_rle(quicktime_t *file, unsigned char **row_pointers, int track)
  {
  quicktime_video_map_t *vtrack = &(file->vtracks[track]);
  lqt_xanim_codec_1_t *codec = (lqt_xanim_codec_1_t*)(((quicktime_codec_t*)vtrack->codec)->priv);

  xaULONG (*decode_func)(xaUBYTE *, xaUBYTE *, xaULONG, XA_DEC_INFO *) =
    (xaULONG (*)(xaUBYTE *, xaUBYTE *, xaULONG, XA_DEC_INFO *))0;
    
  if(!codec->initialized)
    {
    lqt_xanim_init_vcodec_1(file, track);

    switch(quicktime_video_depth(file, track))
      {
      case 40:
      case 8:
        codec->decode_func = QT_Decode_RLE8;
        codec->info.imagex = 4 * ((codec->info.imagex + 3)/4); 
        codec->info.imaged = 8; 
        break;
      case 16:
        codec->decode_func = QT_Decode_RLE16;
        break;
      case 24:
        codec->decode_func = QT_Decode_RLE24;
        break;
      case 32:
        codec->decode_func = QT_Decode_RLE32;
        break;
      case 33:
      case  1:
        codec->decode_func = QT_Decode_RLE1;
        codec->info.imagex = 16 * ((codec->info.imagex + 15)/16);
        codec->info.imaged = 1;
        break;
      case 34:
      case  2:
        codec->decode_func = QT_Decode_RLE2;
        codec->info.imagex = 16 * ((codec->info.imagex + 15)/16);
        codec->info.imaged = 4;
        break;
      case 36:
      case  4:
        codec->decode_func = QT_Decode_RLE4;
        codec->info.imagex = 8 * ((codec->info.imagex + 7)/8);
        codec->info.imaged = 4;
        break;
      }
    lqt_xanim_alloc_temp_frame_1(file, track);
    codec->initialized = 1;
    }
  return lqt_xanim_decode_video_1(file, row_pointers, track);
  }

void lqt_xanim_init_codec_rle(quicktime_video_map_t *vtrack)
  {
  lqt_xanim_codec_1_t *codec;

  /* Init public items */
  ((quicktime_codec_t*)vtrack->codec)->priv = calloc(1, sizeof(lqt_xanim_codec_1_t));
  ((quicktime_codec_t*)vtrack->codec)->delete_vcodec = lqt_xanim_delete_vcodec_1;
  ((quicktime_codec_t*)vtrack->codec)->decode_video = decode_rle;
  ((quicktime_codec_t*)vtrack->codec)->encode_video = 0;
  ((quicktime_codec_t*)vtrack->codec)->set_parameter = 0;
  ((quicktime_codec_t*)vtrack->codec)->decode_audio = 0;
  ((quicktime_codec_t*)vtrack->codec)->encode_audio = 0;
  ((quicktime_codec_t*)vtrack->codec)->reads_colormodel = lqt_xanim_reads_colormodel;
  }
