#include <quicktime/lqt.h>
#include <quicktime/lqt_codecapi.h>
#include <quicktime/colormodels.h>

#include "lqt_xanim.h"

static char * fourccs_rle[]  = { LQT_rle, (char*)0 };

static char * fourccs_raw[]  = { LQT_raw, LQT_raw3, (char*)0 };

static char * fourccs_rpza[] = { LQT_azpr, LQT_rpza, (char*)0 };

static char * fourccs_cram[] = { LQT_cram, LQT_CRAM, LQT_wham, LQT_WHAM, LQT_msvc, LQT_MSVC,
                                 (char*)0 };

static char * fourccs_smc[] = { LQT_smc, (char*)0 };

static char * fourccs_8BPS[]  = { LQT_8BPS, (char*)0 };


/* Generic colormodel function, used by all codecs */

int lqt_xanim_reads_colormodel(quicktime_t * file,
                               int colormodel,
                               int track)
  {
  if((colormodel == XANIM_COLORMODEL) || (colormodel == BC_RGB888))
    return 1;
  return 0;
  }

static lqt_codec_info_static_t codec_info_rle =
  {
  name:        "xa_rle",
  long_name:   "RLE (Xanim)",
  description: "Apple Animation (RLE)",
  fourccs:     fourccs_rle,
  type:        LQT_CODEC_VIDEO,
  direction:   LQT_DIRECTION_DECODE,
  encoding_parameters: (lqt_parameter_info_static_t*)0,
  decoding_parameters: (lqt_parameter_info_static_t*)0,
  encoding_colormodels: (int*)0,
  decoding_colormodel: XANIM_COLORMODEL
  };

static lqt_codec_info_static_t codec_info_cram =
  {
  name:        "xa_cram",
  long_name:   "CRAM (Xanim)",
  description: "Microsoft Video 1 (CRAM)",
  fourccs:     fourccs_cram,
  type:        LQT_CODEC_VIDEO,
  direction:   LQT_DIRECTION_DECODE,
  encoding_parameters: (lqt_parameter_info_static_t*)0,
  decoding_parameters: (lqt_parameter_info_static_t*)0,
  encoding_colormodels: (int*)0,
  decoding_colormodel: XANIM_COLORMODEL
  };

static lqt_codec_info_static_t codec_info_raw =
  {
  name:        "xa_raw",
  long_name:   "raw (Xanim)",
  description: "Apple Uncompressed",
  fourccs:     fourccs_raw,
  type:        LQT_CODEC_VIDEO,
  direction:   LQT_DIRECTION_DECODE,
  encoding_parameters: (lqt_parameter_info_static_t*)0,
  decoding_parameters: (lqt_parameter_info_static_t*)0,
  encoding_colormodels: (int*)0,
  decoding_colormodel: XANIM_COLORMODEL
  };

static lqt_codec_info_static_t codec_info_rpza =
  {
  name:        "xa_rpza",
  long_name:   "RPZA (Xanim)",
  description: "Apple Video (RPZA)",
  fourccs:     fourccs_rpza,
  type:        LQT_CODEC_VIDEO,
  direction:   LQT_DIRECTION_DECODE,
  encoding_parameters: (lqt_parameter_info_static_t*)0,
  decoding_parameters: (lqt_parameter_info_static_t*)0,
  encoding_colormodels: (int*)0,
  decoding_colormodel: XANIM_COLORMODEL
  };

static lqt_codec_info_static_t codec_info_smc =
  {
  name:        "xa_smc",
  long_name:   "SMC (Xanim)",
  description: "Apple Graphics (SMC)",
  fourccs:     fourccs_smc,
  type:        LQT_CODEC_VIDEO,
  direction:   LQT_DIRECTION_DECODE,
  encoding_parameters: (lqt_parameter_info_static_t*)0,
  decoding_parameters: (lqt_parameter_info_static_t*)0,
  encoding_colormodels: (int*)0,
  decoding_colormodel: XANIM_COLORMODEL
  };

static lqt_codec_info_static_t codec_info_8bps =
  {
  name:        "xa_8bps",
  long_name:   "8BPS (Xanim)",
  description: "Photoshop",
  fourccs:     fourccs_8BPS,
  type:        LQT_CODEC_VIDEO,
  direction:   LQT_DIRECTION_DECODE,
  encoding_parameters: (lqt_parameter_info_static_t*)0,
  decoding_parameters: (lqt_parameter_info_static_t*)0,
  encoding_colormodels: (int*)0,
  decoding_colormodel: XANIM_COLORMODEL
  };

/* These are called from the plugin loader */

extern int get_num_codecs() { return 4; }

extern lqt_codec_info_static_t * get_codec_info(int index)
  {
  switch(index)
    {
    case 0:
      return &codec_info_rle;
      break;
    case 1:
      return &codec_info_raw;
      break;
    case 2:
      return &codec_info_rpza;
      break;
    case 3:
      return &codec_info_smc;
      break;
    case 4:
      return &codec_info_cram;
      break;
    case 5:
      return &codec_info_8bps;
      break;
    }
  return (lqt_codec_info_static_t*)0;
  }

/*
 *   Return the actual codec constructor
 */

extern lqt_init_video_codec_func_t get_video_codec(int index)
  {
  switch(index)
    {
    case 0:
      return lqt_xanim_init_codec_rle;
    case 1:
      return lqt_xanim_init_codec_raw;
    case 2:
      return lqt_xanim_init_codec_rpza;
    case 3:
      return lqt_xanim_init_codec_smc;
    case 4:
      return lqt_xanim_init_codec_cram;
    case 5:
      return lqt_xanim_init_codec_8bps;
    }
  return (lqt_init_video_codec_func_t)0;
  }
