#include <stdlib.h>
#include <qtimer.h>
#include "randomplot.h"

const unsigned int c_rangeMax = 1000;

RandomPlot::RandomPlot(QWidget *parent):
	ZoomPlot(parent),
	_curveId(0),
	_timer(0),
	_timerCount(0)
	
{
    setFrameStyle(NoFrame);
    setLineWidth(0);
    setCanvasLineWidth(2);

    enableGridX(TRUE);
    enableGridY(TRUE);
    setGridMajPen(QPen(gray, 0, DotLine));

    enableGridXMin(FALSE);
    enableGridYMin(FALSE);
    setGridMinPen(QPen(gray, 0, DotLine));

    setCanvasBackground(QColor(29, 100, 141)); // nice blue

	setAxisScale(xBottom, 0, c_rangeMax);
	setAxisScale(yLeft, 0, c_rangeMax);

	initCurve();
}

QSize RandomPlot::sizeHint() const
{
	return QSize(540,400);
}

void RandomPlot::initCurve()
{
	if ( _curveId > 0 )
	{
		removeCurveData(_curveId);
		removeCurve(_curveId);
	}

	_curveId = insertCurve("Test Curve");
	setCurveStyle(_curveId, QwtCurve::NoCurve);

	const QColor &c = white;
	setCurveSymbol(_curveId, QwtSymbol(QwtSymbol::XCross,
		QBrush(c), QPen(c), QSize(5, 5)) );
}

void RandomPlot::appendPoint()
{
	double x = rand() % c_rangeMax;
	x += ( rand() % 100 ) / 100;

	double y = rand() % c_rangeMax;
	y += ( rand() % 100 ) / 100;

	appendCurvePoint(_curveId, x, y);

	if ( --_timerCount <= 0 )
		stop();
}

void RandomPlot::append(int timeout, int count)
{
	if ( !_timer )
	{
		_timer = new QTimer(this);
		connect(_timer, SIGNAL(timeout()), SLOT(appendPoint()));
	}

	_timerCount = count;

	emit running(TRUE);
	_timer->start(timeout);
}

void RandomPlot::stop()
{
	if ( _timer )
	{
		_timer->stop();
		emit running(FALSE);
	}
}

void RandomPlot::clear()
{
	initCurve();
	replot();
}
