#include <math.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qwt_slider.h>
#include "sliders.h"

//------------------------------------------------------------
//      curvdemo1
//
//  This example program features some of the different
//  display styles of the QwtCurve class
//------------------------------------------------------------


SliderDemo::SliderDemo(QWidget *p): QWidget(p)
{
    QwtSlider *sldV1 = new QwtSlider(this, 0,
        QwtSlider::Vertical, QwtSlider::Left, QwtSlider::BgSlot);
    QwtSlider *sldV2 = new QwtSlider(this, 0, 
        QwtSlider::Vertical, QwtSlider::None, QwtSlider::BgTrough);
    QwtSlider *sldV3 = new QwtSlider(this, 0, 
        QwtSlider::Vertical, QwtSlider::Right,
        QwtSlider::BgSlot|QwtSlider::BgTrough);
    
    QwtSlider *sldH1 = new QwtSlider(this, 0, 
        QwtSlider::Horizontal, QwtSlider::Top, QwtSlider::BgTrough);
    QwtSlider *sldH2 = new QwtSlider(this, 0, 
        QwtSlider::Horizontal, QwtSlider::None, 
        QwtSlider::BgSlot|QwtSlider::BgTrough);
    QwtSlider *sldH3 = new QwtSlider(this, 0, 
        QwtSlider::Horizontal, QwtSlider::Bottom, QwtSlider::BgSlot);

    //
    //  Slider Properties
    //
    sldV1->setRange(0.0, 100.0, 1.0, 5);
    sldV1->setScaleMaxMinor(5);
    
    sldV2->setRange(0.0,100.0,1.0, 10);

    sldV3->setThumbWidth(20);
    sldV3->setBorderWidth(1);
    sldV3->setRange(0.0, 4.0, 0.01);
    sldV3->setScale(1.0, 1.0e4, TRUE);
    sldV3->setScaleMaxMinor(10);
    
    sldH1->setThumbWidth(10);
    sldH1->setRange(-10.0, 10.0, 1.0, 0); // paging disabled

    sldH2->setRange(0.0, 1.0, 0.01, 5);
    sldH3->setRange(1000.0, 3000.0, 10.0, 10);

    sldH3->setThumbWidth(25);
    sldH3->setThumbLength(12);
    
    QLabel *lblV1 = new QLabel("0.0",this);
    QLabel *lblV2 = new QLabel("0.0",this);
    lblV3 = new QLabel("0.0",this);
    QLabel *lblH1 = new QLabel("0.0",this);
    QLabel *lblH2 = new QLabel("0.0",this);
    QLabel *lblH3 = new QLabel("0.0",this);

    QLabel *lblHTitle = new QLabel("Horizontal Sliders", this);
    QLabel *lblVTitle = new QLabel("Vertical Sliders", this);
    lblHTitle->setFont(QFont("Helvetica", 14, QFont::Bold));
    lblHTitle->setAlignment(Qt::AlignHCenter);
    lblVTitle->setFont(lblHTitle->font());
    lblVTitle->setAlignment(Qt::AlignHCenter);
    
    QGridLayout *lytGrid = new QGridLayout(this, 5,5,10,10);
    
    lytGrid->addMultiCellWidget(lblVTitle, 0,0,0,2);
    lytGrid->addMultiCellWidget(lblHTitle, 0,0,3,4);

    lytGrid->addMultiCellWidget(sldV1, 1,3,0,0, AlignRight);
    lytGrid->addMultiCellWidget(sldV2, 1,3,1,1, AlignHCenter);
    lytGrid->addMultiCellWidget(sldV3, 1,3, 2, 2, AlignLeft);
    
    lytGrid->addWidget(sldH1, 1, 3, AlignTop);
    lytGrid->addWidget(sldH2, 2, 3, AlignVCenter);
    lytGrid->addWidget(sldH3, 3, 3, AlignBottom);

    lblV1->setFixedSize(60,30);
    lblV1->setAlignment(AlignHCenter);
    lblV2->setFixedSize(60,30);
    lblV2->setAlignment(AlignHCenter);
    lblV3->setFixedSize(60,30);
    lblV3->setAlignment(AlignLeft);
    
    lytGrid->addWidget(lblV1, 4, 0, AlignRight);
    lytGrid->addWidget(lblV2, 4, 1, AlignHCenter);
    lytGrid->addWidget(lblV3, 4, 2, AlignLeft);

    lblH1->setFixedWidth(30);
    lblH2->setFixedWidth(30);
    lblH3->setFixedWidth(30);
    lblH1->setAlignment(AlignVCenter);
    lblH2->setAlignment(AlignVCenter);
    lblH3->setAlignment(AlignVCenter);

    lytGrid->addWidget(lblH1, 1, 4, AlignVCenter);
    lytGrid->addWidget(lblH2, 2, 4, AlignVCenter);
    lytGrid->addWidget(lblH3, 3, 4, AlignVCenter);

    lytGrid->setColStretch(0,1);
    lytGrid->setColStretch(1,3);
    lytGrid->setColStretch(2,1);
    lytGrid->setColStretch(3,10);
    lytGrid->setColStretch(4,0);

    lytGrid->setRowStretch(0,1);
    lytGrid->setRowStretch(1,3);
    lytGrid->setRowStretch(2,10);
    lytGrid->setRowStretch(3,3);
    lytGrid->setRowStretch(4,0);

    connect(sldH1, SIGNAL(valueChanged(double)), lblH1, SLOT(setNum(double)));
    connect(sldH2, SIGNAL(valueChanged(double)), lblH2, SLOT(setNum(double)));
    connect(sldH3, SIGNAL(valueChanged(double)), lblH3, SLOT(setNum(double)));
    connect(sldV1, SIGNAL(valueChanged(double)), lblV1, SLOT(setNum(double)));
    connect(sldV2, SIGNAL(valueChanged(double)), lblV2, SLOT(setNum(double)));
    connect(sldV3, SIGNAL(valueChanged(double)), SLOT(setV3(double)));
        
}

void SliderDemo::setV3(double value)
{
    lblV3->setNum(pow(10.0, value));
}

int main (int argc, char **argv)
{
    QApplication a(argc, argv);
    QApplication::setFont(QFont("Helvetica",10));

    SliderDemo w(0);

    a.setMainWidget(&w);
    w.show();

    return a.exec();
}
