/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_RECT_H
#define QWT_RECT_H

#include <qrect.h>
#include "qwt_global.h"

/*!
  \brief Some extensions for QRect
*/

class QWT_EXPORT QwtRect : public QRect
{
public:
    QwtRect();
    QwtRect(const QRect &r);

    QRect cutTop(int h , int distTop = 0, int distBottom = 0);
    QRect cutBottom(int h, int distTop = 0, int distBottom = 0);
    QRect cutLeft(int w, int distLeft = 0, int distRight = 0);
    QRect cutRight(int w, int distLeft = 0, int distRight = 0);
    const QwtRect &cutMargin(int mLeft, int mRight, int Top, int mBottom);
};

#endif
