/*-*- c++ -*-******************************************************************
 * Qwt Widget Library
 * Copyright (C) 1997   Josef Wilgen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_SLIDER_H
#define QWT_SLIDER_H

#include "qwt_global.h"
#include "qwt_sclif.h"
#include "qwt_sldbase.h"

/*!
  \brief The Slider Widget

  QwtSlider is a slider widget which operates on an interval
  of type double. QwtSlider supports different layouts as
  well as a scale.
  \sa QwtSliderBase and QwtScaleIf for the descriptions
      of the inherited members.
*/

class QWT_EXPORT QwtSlider : public QwtSliderBase, public QwtScaleIf
{
public:

    /*! 
        Position of the scale
        \sa QwtSlider::QwtSlider
     */
    enum ScalePos { None, Left, Right, Top, Bottom };

    /*! 
        Background style
        \sa QwtSlider::QwtSlider
     */
    enum { BgTrough = 0x1, BgSlot = 0x2 };

    QwtSlider(QWidget *parent, const char *name = 0,
          Orientation orient = Horizontal,
          ScalePos scalePos = None,
          int bgStyle = BgTrough);
    
    void setThumbLength(int l);
    void setThumbWidth(int w);
    void setBorderWidth(int bw);
    void setMargins(int x, int y);

    virtual QSize sizeHint() const;
    virtual QSize minimumSizeHint() const;
    virtual QSizePolicy sizePolicy() const;
    
protected:
    virtual double getValue(const QPoint &p);
    virtual void getScrollMode(const QPoint &p, 
        int &scrollMode, int &direction);

    void draw(QPainter *p, const QRect& update_rect);
    virtual void drawSlider (QPainter *p, const QRect &r);
    virtual void drawThumb(QPainter *p, const QRect &, int pos);

    virtual void resizeEvent(QResizeEvent *e);
    virtual void paintEvent (QPaintEvent *e);

    virtual void valueChange();
    virtual void rangeChange();
    virtual void scaleChange();
    virtual void fontChange(const QFont &oldFont);

    void layoutSlider( bool update = TRUE );
    int xyPosition(double v) const;

private:
    QRect d_sliderRect;

    int d_thumbLength;
    int d_thumbWidth;
    int d_borderWidth;
    int d_scaleDist;
    int d_xMargin;
    int d_yMargin;
    
    Qt::Orientation d_orient;
    ScalePos d_scalePos;
    int d_bgStyle;
};

#endif
