##############################################
# pro file for building the makefile for qwt
#
# Qt <  3.x: tmake qwt.pro -o Makefile
# Qt >= 3.x: qmake qwt.pro -o Makefile
#
# HEADERS/SOURCES are separated into plot
# relevant files and others. If you are 
# interested in QwtPlot only, you can remove
# the lists at the end of this file.
##############################################

TARGET            = qwt
TEMPLATE          = lib
VERSION           = 0.4.1
CONFIG           += qt warn_on release thread
MOC_DIR           = src/moc
OBJECTS_DIR       = src/obj
INCLUDEPATH       = include
DEPENDPATH        = include src

unix:DESTDIR      = lib
unix:CLEAN_FILES += lib/libqwt.so*

win32:TEMPLATE	  = vclib
win32:CONFIG     += dll 
win32:DEFINES    += QT_DLL QWT_DLL QWT_MAKEDLL

linux-g++:TMAKE_CXXFLAGS +=-fno-exceptions 

HEADERS = \
          include/qwt_global.h \
          include/qwt.h \
		  include/qwt_autoscl.h \
		  include/qwt_curve.h \
		  include/qwt_dimap.h \
		  include/qwt_grid.h \
		  include/qwt_legend.h \
		  include/qwt_marker.h \
		  include/qwt_math.h \
		  include/qwt_plot.h \
		  include/qwt_plot_printfilter.h \
		  include/qwt_plot_classes.h \
		  include/qwt_plot_item.h \
		  include/qwt_plot_dict.h \
		  include/qwt_plot_canvas.h \
		  include/qwt_rect.h \
		  include/qwt_scale.h \
		  include/qwt_scldiv.h \
		  include/qwt_scldraw.h \
		  include/qwt_spline.h \
		  include/qwt_symbol.h

SOURCES = \
		  src/qwt_autoscl.cpp \
		  src/qwt_curve.cpp \
		  src/qwt_dimap.cpp \
		  src/qwt_grid.cpp \
		  src/qwt_legend.cpp \
		  src/qwt_marker.cpp \
		  src/qwt_math.cpp \
		  src/qwt_plot.cpp \
		  src/qwt_plot_axis.cpp \
		  src/qwt_plot_curve.cpp \
		  src/qwt_plot_grid.cpp \
		  src/qwt_plot_item.cpp \
		  src/qwt_plot_print.cpp \
		  src/qwt_plot_marker.cpp \
		  src/qwt_plot_printfilter.cpp \
		  src/qwt_plot_canvas.cpp \
		  src/qwt_rect.cpp \
		  src/qwt_scale.cpp \
		  src/qwt_scldiv.cpp \
		  src/qwt_scldraw.cpp \
		  src/qwt_spline.cpp \
		  src/qwt_symbol.cpp 
 
##############################################
# If you are interested in the plot widget
# only, you can remove the following 
# HEADERS/SOURCES lists.
##############################################

HEADERS += \
		  include/qwt_arrbtn.h \
		  include/qwt_counter.h \
		  include/qwt_drange.h \
		  include/qwt_knob.h \
		  include/qwt_sclif.h \
		  include/qwt_sldbase.h \
		  include/qwt_slider.h \
		  include/qwt_thermo.h \
		  include/qwt_wheel.h

SOURCES += \
          src/qwt_arrbtn.cpp \
		  src/qwt_counter.cpp \
		  src/qwt_drange.cpp \
		  src/qwt_knob.cpp \
		  src/qwt_sclif.cpp \
		  src/qwt_sldbase.cpp \
		  src/qwt_slider.cpp \
		  src/qwt_thermo.cpp \
		  src/qwt_wheel.cpp
