/* 
/ rasterlite.h
/
/ public RasterLite declarations
/
/ version 1.0, 2009 June 1
/
/ Author: Sandro Furieri a.furieri@lqt.it
/
/ Copyright (C) 2009  Alessandro Furieri
/
/    This program is free software: you can redistribute it and/or modify
/    it under the terms of the GNU General Public License as published by
/    the Free Software Foundation, either version 3 of the License, or
/    (at your option) any later version.
/
/    This program is distributed in the hope that it will be useful,
/    but WITHOUT ANY WARRANTY; without even the implied warranty of
/    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/    GNU General Public License for more details.
/
/    You should have received a copy of the GNU General Public License
/    along with this program.  If not, see <http://www.gnu.org/licenses/>.
/
*/

#ifdef DLL_EXPORT
#define RASTERLITE_DECLARE __declspec(dllexport)
#else
#define RASTERLITE_DECLARE extern
#endif

#ifndef _RASTERLITE_H
#define _RASTERLITE_H

#ifdef __cplusplus
extern "C"
{
#endif

#define GAIA_RGB_ARRAY	1001

#define RASTERLITE_OK	0
#define RASTERLITE_ERROR	1

    RASTERLITE_DECLARE void *rasterliteOpen (const char *path,
					     const char *table_prefix);
    RASTERLITE_DECLARE void rasterliteClose (void *handle);
    RASTERLITE_DECLARE int rasterliteHasTransparentColor (void *handle);
    RASTERLITE_DECLARE void rasterliteSetTransparentColor (void *handle,
							   unsigned char red,
							   unsigned char green,
							   unsigned char blue);
    RASTERLITE_DECLARE int rasterliteGetTransparentColor (void *handle,
							  unsigned char *red,
							  unsigned char *green,
							  unsigned char *blue);
    RASTERLITE_DECLARE void rasterliteSetBackgroundColor (void *handle,
							  unsigned char red,
							  unsigned char green,
							  unsigned char blue);
    RASTERLITE_DECLARE int rasterliteGetBackgroundColor (void *handle,
							 unsigned char *red,
							 unsigned char *green,
							 unsigned char *blue);
    RASTERLITE_DECLARE int rasterliteGetRaster (void *handle, double cx,
						double cy, double pixel_size,
						int width, int height,
						int image_type,
						int quality_factor,
						void **raster, int *size);
    RASTERLITE_DECLARE int rasterliteGetRaster2 (void *handle, double cx,
						 double cy, double pixel_x_size,
						 double pixel_y_size, int width,
						 int height, int image_type,
						 int quality_factor,
						 void **raster, int *size);
    RASTERLITE_DECLARE int rasterliteGetRasterByRect (void *handle, double x1,
						      double y1, double x2,
						      double y2,
						      double pixel_size,
						      int width, int height,
						      int image_type,
						      int quality_factor,
						      void **raster, int *size);
    RASTERLITE_DECLARE int rasterliteGetRasterByRect2 (void *handle, double x1,
						       double y1, double x2,
						       double y2,
						       double pixel_x_size,
						       double pixel_y_size,
						       int width, int height,
						       int image_type,
						       int quality_factor,
						       void **raster,
						       int *size);
    RASTERLITE_DECLARE int rasterliteIsError (void *handle);
    RASTERLITE_DECLARE const char *rasterliteGetPath (void *handle);
    RASTERLITE_DECLARE const char *rasterliteGetTablePrefix (void *handle);
    RASTERLITE_DECLARE const char *rasterliteGetLastError (void *handle);
    RASTERLITE_DECLARE const char *rasterliteGetSqliteVersion (void *handle);
    RASTERLITE_DECLARE const char *rasterliteGetSpatialiteVersion (void
								   *handle);
    RASTERLITE_DECLARE int rasterliteGetLevels (void *handle);
    RASTERLITE_DECLARE int rasterliteGetResolution (void *handle, int level,
						    double *pixel_x_size,
						    double *pixel_y_size,
						    int *tile_count);
    RASTERLITE_DECLARE int rasterliteGetSrid (void *handle, int *srid,
					      const char **auth_name,
					      int *auth_srid,
					      const char **ref_sys_name,
					      const char **proj4text);
    RASTERLITE_DECLARE int rasterliteGetExtent (void *handle, double *min_x,
						double *min_y, double *max_x,
						double *max_y);
    RASTERLITE_DECLARE int rasterliteWaveletToPng (const void *blob,
						   int blob_size,
						   void **png_blob,
						   int *png_size);
    RASTERLITE_DECLARE int rasterliteExportGeoTiff (void *handle,
						    const char *img_path,
						    void *raster, int size,
						    double cx, double cy,
						    double pixel_x_size,
						    double pixel_y_size,
						    int width, int height);
    RASTERLITE_DECLARE int rasterliteGetBestAccess (void *handle,
						    double pixel_size,
						    double *pixel_x_size,
						    double *pixel_y_size,
						    sqlite3_stmt ** stmt,
						    int *use_rtree);

#ifdef __cplusplus
}
#endif

#endif				/* _RASTERLITE_H */
