/****************************************************************************
**
** This file is part of the LibreCAD project, a 2D CAD program
**
** Copyright (C) 2010 R. van Twisk (librecad@rvt.dds.nl)
** Copyright (C) 2001-2003 RibbonSoft. All rights reserved.
**
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** This copyright notice MUST APPEAR in all copies of the script!  
**
**********************************************************************/
#ifndef QG_COMMANDWIDGET_H
#define QG_COMMANDWIDGET_H

#include <qvariant.h>


#include <Qt3Support/Q3TextEdit>
#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QButtonGroup>
#include <QtGui/QFrame>
#include <QtGui/QHBoxLayout>
#include <QtGui/QHeaderView>
#include <QtGui/QLabel>
#include <QtGui/QVBoxLayout>
#include <QtGui/QWidget>
#include "qg_actionhandler.h"
#include "qg_commandedit.h"
#include "rs_commands.h"

QT_BEGIN_NAMESPACE

class Ui_QG_CommandWidget
{
public:
    QVBoxLayout *vboxLayout;
    Q3TextEdit *teHistory;
    QFrame *line1;
    QHBoxLayout *hboxLayout;
    QLabel *lCommand;
    QG_CommandEdit *leCommand;

    void setupUi(QWidget *QG_CommandWidget)
    {
        if (QG_CommandWidget->objectName().isEmpty())
            QG_CommandWidget->setObjectName(QString::fromUtf8("QG_CommandWidget"));
        QG_CommandWidget->resize(639, 102);
        vboxLayout = new QVBoxLayout(QG_CommandWidget);
        vboxLayout->setSpacing(0);
        vboxLayout->setContentsMargins(0, 0, 0, 0);
        vboxLayout->setObjectName(QString::fromUtf8("vboxLayout"));
        teHistory = new Q3TextEdit(QG_CommandWidget);
        teHistory->setObjectName(QString::fromUtf8("teHistory"));
        teHistory->setMinimumSize(QSize(0, 23));
        teHistory->setFocusPolicy(Qt::NoFocus);
        teHistory->setLineWidth(0);
        teHistory->setHScrollBarMode(Q3ScrollView::AlwaysOff);
        teHistory->setTextFormat(Qt::PlainText);
        teHistory->setLinkUnderline(false);
        teHistory->setReadOnly(true);
        teHistory->setUndoRedoEnabled(false);

        vboxLayout->addWidget(teHistory);

        line1 = new QFrame(QG_CommandWidget);
        line1->setObjectName(QString::fromUtf8("line1"));
        QSizePolicy sizePolicy(static_cast<QSizePolicy::Policy>(1), static_cast<QSizePolicy::Policy>(0));
        sizePolicy.setHorizontalStretch(0);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(line1->sizePolicy().hasHeightForWidth());
        line1->setSizePolicy(sizePolicy);
        line1->setFrameShape(QFrame::HLine);
        line1->setFrameShadow(QFrame::Sunken);

        vboxLayout->addWidget(line1);

        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(6);
        hboxLayout->setObjectName(QString::fromUtf8("hboxLayout"));
        lCommand = new QLabel(QG_CommandWidget);
        lCommand->setObjectName(QString::fromUtf8("lCommand"));
        lCommand->setWordWrap(false);

        hboxLayout->addWidget(lCommand);

        leCommand = new QG_CommandEdit(QG_CommandWidget);
        leCommand->setObjectName(QString::fromUtf8("leCommand"));
        QSizePolicy sizePolicy1(static_cast<QSizePolicy::Policy>(3), static_cast<QSizePolicy::Policy>(5));
        sizePolicy1.setHorizontalStretch(0);
        sizePolicy1.setVerticalStretch(0);
        sizePolicy1.setHeightForWidth(leCommand->sizePolicy().hasHeightForWidth());
        leCommand->setSizePolicy(sizePolicy1);

        hboxLayout->addWidget(leCommand);


        vboxLayout->addLayout(hboxLayout);


        retranslateUi(QG_CommandWidget);
        QObject::connect(leCommand, SIGNAL(returnPressed()), QG_CommandWidget, SLOT(trigger()));
        QObject::connect(leCommand, SIGNAL(tabPressed()), QG_CommandWidget, SLOT(tabPressed()));
        QObject::connect(leCommand, SIGNAL(escape()), QG_CommandWidget, SLOT(escape()));
        QObject::connect(leCommand, SIGNAL(focusIn()), QG_CommandWidget, SLOT(setCommandMode()));
        QObject::connect(leCommand, SIGNAL(focusOut()), QG_CommandWidget, SLOT(setNormalMode()));

        QMetaObject::connectSlotsByName(QG_CommandWidget);
    } // setupUi

    void retranslateUi(QWidget *QG_CommandWidget)
    {
        QG_CommandWidget->setWindowTitle(QApplication::translate("QG_CommandWidget", "Command Line", 0, QApplication::UnicodeUTF8));
        lCommand->setText(QApplication::translate("QG_CommandWidget", "Command:", 0, QApplication::UnicodeUTF8));
    } // retranslateUi


protected:
    enum IconID
    {
        image0_ID,
        unknown_ID
    };
    static QPixmap qt_get_icon(IconID id)
    {
    static const char* const image0_data[] = { 
"22 22 114 2",
"Qt c None",
".# c #000000",
".J c #000008",
".g c #000400",
".2 c #000408",
"#J c #080408",
"#y c #080808",
".P c #080c10",
"#c c #101010",
"#z c #101408",
"#h c #101410",
"#V c #101800",
"## c #101810",
"#M c #101c08",
"#p c #101c10",
"#q c #181810",
".S c #181c10",
"#r c #182010",
"#L c #182410",
"#v c #202410",
".K c #202810",
".5 c #292c10",
"#R c #293000",
"#U c #293008",
".I c #293010",
"#e c #293018",
".Q c #293418",
".R c #313818",
".s c #314008",
".f c #393839",
"#t c #393c18",
".W c #414c18",
".F c #4a5908",
".T c #4a5918",
"#I c #525918",
"#S c #525d08",
"#j c #525d18",
".N c #526108",
"#T c #526110",
".9 c #526118",
"#n c #526120",
"#b c #526508",
"#F c #526520",
".e c #5a5d5a",
"#g c #5a6908",
"#k c #5a6910",
".O c #5a6918",
".1 c #5a6920",
"#A c #5a6d08",
"#o c #5a6d10",
"#K c #627110",
".3 c #627120",
".z c #627518",
".A c #627520",
".L c #627920",
".d c #6a6d6a",
"#B c #6a7520",
".H c #6a7d20",
"#P c #738529",
".y c #738920",
"#u c #738929",
".a c #7b797b",
"#x c #7b8920",
".X c #8b9d20",
".G c #8ba110",
".v c #8ba118",
".u c #8ba120",
"#E c #8ba131",
".x c #8ba518",
".8 c #8ba520",
"#s c #8ba531",
".c c #949194",
"#l c #94a529",
".r c #94a539",
".w c #94aa10",
".B c #94aa18",
"#d c #94aa20",
"#N c #94aa29",
"#Q c #94ae18",
".D c #94b218",
".0 c #94b229",
".E c #9cb218",
".Y c #9cb220",
"#a c #9cb229",
".t c #9cb241",
".6 c #9cb610",
".C c #9cb618",
".7 c #9cba10",
".Z c #9cba18",
".M c #9cba20",
"#w c #9cba29",
".b c #a4a1a4",
"#H c #a4b620",
".V c #a4ba18",
".U c #a4ba20",
"#. c #a4ba29",
"#f c #a4be29",
".k c #acbe62",
"#O c #acc220",
".4 c #acc629",
"#C c #acca20",
"#i c #acce20",
".l c #b4be62",
".m c #b4c262",
".j c #b4c273",
".i c #b4c28b",
".q c #b4c65a",
".n c #b4c662",
".p c #b4ca62",
"#D c #b4d618",
"#m c #b4d620",
".h c #bdbea4",
".o c #bdca62",
"#G c #bdde20",
"QtQtQt.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#Qt",
"QtQt.a.b.c.a.d.d.d.d.d.d.d.d.d.d.e.f.g.#.#.#",
"Qt.#.b.h.i.j.k.l.m.n.n.o.o.n.n.p.q.r.s.#.#.#",
"Qt.#.c.i.t.u.v.w.x.y.z.A.y.B.C.D.D.E.F.#.#.#",
"Qt.#.a.j.u.G.B.H.I.J.#.#.J.K.L.M.C.C.N.#.#.#",
"Qt.#.d.k.G.B.O.J.J.P.Q.R.S.J.J.T.U.V.N.#.#.#",
"Qt.#.d.l.w.H.J.#.W.X.Y.Z.0.1.2.#.3.4.N.#.#.#",
"Qt.#.d.m.x.5.#.W.Y.6.7.8.9#..3.J###a#b.#.#.#",
"Qt.#.d.n.y.J#c.X.6.7#d#e.J.W#f.5.#.y#g.#.#.#",
"Qt.#.d.n.z.##e.Y.7#d.I.J#h.y#i#j.#.O#k.#.#.#",
"Qt.#.d.o.A.#.R.Z.u#e.J.#.S#l#m#n.#.1#o.#.#.#",
"Qt.#.d.o.y.J#p.0#n.J#c#q.##r#s#t.##u#o.#.#.#",
"Qt.#.d.n.B#v.J.1#w.W#x#l#r.##c#y#z.U#A.#.#.#",
"Qt.#.d.n.C#B.J.2.A#f#C#D#E##.#.g#F#G#A.#.#.#",
"Qt.#.d.n.D#H#I.#.J.I#I.9#t#J.g.g#v#a#K.#.#.#",
"Qt.#.e.q.D.C.U.3.S.#.#.#.##z#F#L#M#N.N.#.#.#",
"Qt.#.f.r.D.C.Z#O#a.y.1.1#P.U#G.0#N#Q#R.#.#.#",
"Qt.#.g.s.F.N#S.N#b#g#k#o#o#o#A#K#T#U#V.#.#.#",
"Qt.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#",
"Qt.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#",
"QtQt.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#",
"QtQtQt.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#Qt"};


    switch (id) {
        case image0_ID: return QPixmap((const char**)image0_data);
        default: return QPixmap();
    } // switch
    } // icon

};

namespace Ui {
    class QG_CommandWidget: public Ui_QG_CommandWidget {};
} // namespace Ui

QT_END_NAMESPACE

class QG_CommandWidget : public QWidget, public Ui::QG_CommandWidget
{
    Q_OBJECT

public:
    QG_CommandWidget(QWidget* parent = 0, const char* name = 0, Qt::WindowFlags fl = 0);
    ~QG_CommandWidget();

    virtual bool checkFocus();

public slots:
    virtual void setFocus();
    virtual void setCommand( const QString & cmd );
    virtual void appendHistory( const QString & msg );
    virtual void trigger();
    virtual void tabPressed();
    virtual void escape();
    virtual void setActionHandler( QG_ActionHandler * ah );
    virtual void setCommandMode();
    virtual void setNormalMode();
    virtual void redirectStderr();
    virtual void processStderr();

protected slots:
    virtual void languageChange();

private:
    QG_ActionHandler* actionHandler;

    void init();

};

#endif // QG_COMMANDWIDGET_H
