#!/usr/local/bin/pike

/*
creditcheck.pike - library


Version .50 
Author - Allen Bolderoff 
(with copious amounts of code stolen shamelessly from 
Henrik Grubbstrm <grubba@infovav.se>) 

and based entirely on the algorithm supplied 
with CREDIT_CARD_VALIDATION_LIB.PL v1.0 
by Doug Miles dmiles@primenet.com




USAGE
This is called by doing an 

inherit "creditcheck.pike";

if(creditcheck(cardnumber, cardtype))
  card_is_bad() //any subroutine you wish when card is no good
else
  card_is_good() // or vice versa



LICENSE - GPL-2.0 and or later
WARRANTY - NONE WHAT SO EVER - implied or otherwise.

I have used this to check many cards successfully to weed out bad numbers (most of the time.) - this just stops someone from putting in Random numbers and trying to get an Obviously false number into your system. I do not guarentee that it will help you in any way whatsoever - USE at your own risk!
*/


/*
This is some constants for number of digits per card
*/
constant hash_function = ({ 0, 2, 4, 6, 8, 1, 3, 5, 7, 9 });
constant card_digits =([ "VISA":16, "AMEX":15, "MasterCard":16 ]);

import String;
import Array;
import Stdio;

// subroutine creditcheck() starts here
int creditcheck(string ccn, string card_type)
{

// clear spaces & non numeric characters here
string number = replace(ccn, ({ " ", "-" }), ({ "", "" }));

// Check if any non numeric characters exist, and exit with  1 if no good
string validnumbers = replace(number,
                ({ "0","1","2","3","4","5","6","7","8","9" }),
                ({ "","","","","","","","","","" }));

if (validnumbers != "") {
   return(1);
}

//verify card number length and exit with 1 if bad
if (card_digits[card_type] != sizeof(number)) {
 return(1);
}

// reverse digits here
array digits = map(reverse(number/""), lambda(string n) { return (int)n; });

/* 
double every second digit of the reversed number.

ceck whether it is more than 9 when doubled.
if it is more than 9, the we minus 9 from the doubled figure, or if it
is below 9, then we just double it. 

*/ 
int sum=0;
for(int i=1; i<sizeof(digits); i+=2) {
  if((digits[i]*2) > 9) 
    { 
    (digits[i]*=2); 
    (digits[i]-=9); 
    } else { 
    digits[i]*=2; 
    }
}

/*
add all digits (including double values & non doubled figures) together
and put in value of "sum"
*/
for(int i=0; i<sizeof(digits); i+=1) {
  sum += digits[i];
}

/*
is sum divided by 10 equal to 0?
if so, then the card should be good(exit with 0), 
if not, then card is bad (exit with 1)
*/  
sum %= 10;
if (sum != 0) 
{ 
return(1); 
}
return(0); 
}
