// Copyright (c) 1999-2002 David Muse
// See the COPYING file for more information

#include <rudiments/commandline.h>

#include <string.h>
#ifdef HAVE_STRINGS_H
	#include <strings.h>
#endif

#include <stdio.h>

commandline::commandline(int argc, const char **argv) {
	this->argc=argc;
	this->argv=(char **)argv;
}

commandline::~commandline() {
}

char *commandline::value(const char *arg) const {

	if (arg && arg[0]) {
		for (int i=1; i<argc-1; i++) {
			if (!strcmp(arg,argv[i])) {
				return argv[i+1];
			}
		}
	}
	return "";
}

bool commandline::found(const char *arg) const {

	if (arg && arg[0]) {
		for (int i=1; i<argc; i++) {
			if (!strcmp(arg,argv[i])) {
				return true;
			}
		}
	}
	return false;
}
