////////////////////////////////////////////////////////////////////////
// A test & demo app for s11n[lite].
// Author: stephan@s11n.net
// License: Do As You Damned Well Please
////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
#  undef NDEBUG // we always want assert() to work
#endif

#include <cassert>
#include <iostream>
#include <string>
#include <sstream>
#include <vector>


////////////////////////////////////////////////////////////////////////
#include <S11N_NS/s11nlite.h> // s11n & s11nlite frameworks
////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
// misc util stuff
#include <S11N_NS/debuggering_macros.h> // CERR
#include <S11N_NS/argv_parser.h> // argv_parser class
////////////////////////////////////////////////////////////////////////

struct AType {
        AType()
        {
                CERR << "AType::AType\n";
                for( int i = 0; i < 5; ++i )
                {
                        this->m_vec.push_back( i * i );
                }

        }
        virtual ~AType(){}

        virtual bool operator()( s11nlite::node_type & dest ) const
        {
                CERR << "AType::serialize\n";
                dest.impl_class( "AType" );
                s11nlite::serialize_subnode( dest, "vec", this->m_vec );
                return true;
        }

        virtual bool operator()( const s11nlite::node_type & src )
        {
                this->m_vec.clear();
                CERR << "AType::deserialize\n";
                s11nlite::deserialize_subnode( src, "vec", this->m_vec );
                return true;
        }

private:
        std::vector<int> m_vec;
};

struct BType : public AType {
        BType()
        {
                CERR << "BType::BType\n";
        }
        virtual ~BType(){}
        virtual bool operator()( s11nlite::node_type & dest ) const
        {
                this->AType::operator()( dest );
                CERR << "BType::serialize\n";
                dest.impl_class( "BType" );
                return true;
        }

        virtual bool operator()( const s11nlite::node_type & src )
        {
                this->AType::operator()( src );
                CERR << "BType::deserialize\n";
                return true;
        }

};

struct X : public BType {
        X()
        {
                CERR << "X::X\n";
        }
        virtual ~X(){}

        virtual bool operator()( s11nlite::node_type & dest ) const
        {
                this->BType::operator()( dest );
                CERR << "X::serialize\n";
                dest.impl_class( "X" );
                return true;
        }

        virtual bool operator()( const s11nlite::node_type & src )
        {
                this->BType::operator()( src );
                CERR << "X::deserialize\n";
                return true;
        }
};

#define S11N_TYPE AType
#define S11N_NAME "AType"
#include <S11N_NS/reg_serializable.h>

#define S11N_TYPE BType
#define S11N_BASE_TYPE AType
#define S11N_NAME "BType"
#include <S11N_NS/reg_serializable.h>

#define S11N_TYPE X
#define S11N_BASE_TYPE AType
#define S11N_NAME "X"
#include <S11N_NS/reg_serializable.h>

void test_hier();

int
main( int argc, char **argv )
{
        typedef S11N_NS::argv_parser ARGV;
        ARGV & args = ARGV::args( argc, argv );

        if( args.is_set( "d" ) ) // either -d or --d
        {
                S11N_NS::class_loader_debug_level(1);
        }
        else
        {
                CERR << "tip: use -d to enable classloader debug output.\n";
        }

//         // set the Serializer we want using -s=classname
//         s11nlite::serializer_class( args.get( "s", "parens" ) );
//         s11nlite::serializer_class( "funtxt" );
        s11nlite::serializer_class( "parens" );


        test_hier();

        return 0;
}

void test_hier()
{
        AType * c = new X;

        using namespace s11nlite;

        std::ostringstream os; // simulate a file
        save( c, os );
        CERR << "Data=[\n"<<os.str()<<"]\n";
        delete( c );

        std::istringstream is( os.str() );
        c = load_serializable<AType>( is );
        save( c, std::cout );
        delete( c );
}
