#ifndef PACKAGE_NAMESPACE_CLASSNAME_TRANSFORMER_H
#define PACKAGE_NAMESPACE_CLASSNAME_TRANSFORMER_H
//    License: Do As You Damned Well Please
//    Author: stephan@s11n.net

#include <string>

namespace PACKAGE_NAMESPACE {
        /**
           An interface for transforming class names into
           filesystem-friendly strings, for doing class-to-DLL
           lookups.

           It is intended for use by DLL-aware classloaders
           used in the libclass_loader framework.
        */
        class classname_transformer
        {
        public:
                classname_transformer() {};
                virtual ~classname_transformer() {};

                /**
                   Default implementation simply strips the namespace part
                   from classname and returns the rest.

                   e.g.:

                   foo::Foo == Foo
                   foo::bar::Foo == Foo
                   Foo == Foo
                */
                virtual std::string translate( const std::string & classname );
        };



} // namespace PACKAGE_NAMESPACE
#endif // PACKAGE_NAMESPACE_CLASSNAME_TRANSFORMER_H

