# toc_run_description = looking for GNU C/C++ compiler/linker tools.
# toc_begin_help =
#  It takes the following configure arguments:
#  --enable-debug    causes stuff to be built -g instead of -02.  This is a
#                    little weird, but you can control the optimization level
#                    with --enable-debug="-O3 -fno-inline" etc.
#  --enable-warn     causes stuff to be built -Wall.  To turn on -Werror, do: --enable-warn="-Wall -Werror" etc.
#   --enable-werror  same as --enable-warn="-Wall -Werror"
#
#  It calls toc_add_make for the following:
#  - CC         /path/to/gcc?
#  - LD         /path/to/ld
#  - LDD        /path/to/ldd
#  - CXX        /path/to/g++
#  - AR         /path/to/ar
#  - NM         /path/to/nm (optional component)
#  - STRIP      /path/to/strip (optional component)
#  - INCLUDES   probably empty
#  - CPPFLAGS   probably empty
#  - OPT        -g or -O2 (or some other value specified by --enable-debug)
#  - CFLAGS_OPT same as OPT (prefered for naming's sake)
#  - WARN       -Wall (or some other value specified by --enable-warn or --enable-werror)
#  - CFLAGS     probably empty (or maybe -pipe)
#  - CXXFLAGS   probably empty (or maybe -pipe)
#  - LDFLAGS    probably empty
# = toc_end_help

CC=

for foo in \
    ar-AR gcc-CC g++-CXX ld-LD ldd-LDD \
    ; do
    key=${foo%%-*}
    var=${foo##*-}
    toc_find $key || {
        echo "Couldn't find required app: $key in PATH [$PATH]"
        return 1
    }
    toc_add_make $var=${TOC_FIND_RESULT}
done

for foo in \
    nm-NM strip-STRIP \
    ; do
    key=${foo%%-*}
    var=${foo##*-}
    toc_find $key
    toc_add_make $var="${TOC_FIND_RESULT}"
done


toc_add_make INCLUDES="$INCLUDES"
toc_add_make CPPFLAGS="$CPPFLAGS"
if test "$configure_enable_debug" = 1; then
    OPT="-g $OPT"
elif test "${configure_enable_debug:-0}" = 0; then
    #  What's a sensible default here?  -O2?  Put it first in the hopes
    #  that any values already in $OPT will take precedence.
    OPT="-O2 $OPT -DNDEBUG=1"
else
    #  They specified some flags.
    OPT="$configure_enable_debug"
fi

toc_add_make OPT="$OPT"
toc_add_make CFLAGS_OPT="$OPT"

if test "$configure_enable_warn" = 1; then
    WARN="-Wall $WARN"
elif test "${configure_enable_warn:-0}" = 0; then
	WARN=
else
    #  They specified some flags.
    WARN="$configure_enable_warn"
fi

if test "x$configure_enable_werror" != x0; then
    if test "x$configure_enable_werror" = x1; then
        WARN="-Wall -Werror $WARN"
    else
        WARN="$WARN $configure_enable_werror"
    fi
fi
    


toc_add_make WARN="$WARN"

#  Presumably we could determine whether -pipe works instead of assuming
#  it does...
CFLAGS="-pipe $CFLAGS"
CXXFLAGS="-pipe $CXXFLAGS"
toc_add_make CFLAGS="$CFLAGS"
toc_add_make CXXFLAGS="$CXXFLAGS"
toc_add_make LDFLAGS="$LDFLAGS"
