#!/do/not/bash
# toc_run_description = looking for libs11n under ${1-${s11n_prefix-${prefix}}}
#
# toc_begin_help =
# Looks for libs11n (available from s11n.net). Use --s11n-prefix
# to set the prefix under which s11n should be found. e.g.:
#
#   ./configure --s11n-prefix=/usr/local
#
# Optionally, pass the prefix as $1. The default prefix is ${prefix}.
#
# Only works with libs11n 0.5.3 or higher.
#
# It expects the s11n libs to be under prefix/lib, the headers
# to be under include/s11n, and s11n-config in prefix/bin.
#
# This test exports the following config vars:
#
# - LIBS11N_PREFIX: an empty value if the test fails or s11n's
# installation prefix if the test passes.
#
# - LIBS11N_CLIENT_LDADD: an empty value or:
#	-L${LIBS11N_PREFIX}/lib -ls11n [possibly also -lz -lbz]
#	(This should arguably contain -export-dynamic, but clients are expected
#	to use that, anyway.)
#
# - LIBS11N_CLIENT_INCLUDES: an INCLUDES-compatible entry, like -I${LIBS11N_PREFIX}/include
#
# - LIBS11N_LIBRARY_VERSION: the string which is returned by s11n::library_version().
#
# - LIBS11N_CONFIG=/path/to/s11n-config
#
#
# = toc_end_help


for i in LIBS11N_PREFIX LIBS11N_CLIENT_LDADD LIBS11N_CLIENT_INCLUDES LIBS11N_CONFIG; do
    toc_export $i=
done

s11n_prefix=${1-${s11n_prefix-${prefix}}}

incdir=include/s11n
libdir=lib
bindir=bin
verh=$incdir/s11n_version.h
s11nconfig=$bindir/s11n-config
for i in \
        $s11nconfig \
        $libdir/libs11n.so \
    ; do
    toc_find $i ${s11n_prefix} || {
        err=$?
        echo "$i: not found under ${s11n_prefix}. Try --s11n-prefix=/prefix/under/which/s11n/is/installed"
        return $err;
    }
done
s11nconfig=${s11n_prefix}/$s11nconfig

toc_export LIBS11N_PREFIX=${s11n_prefix}
toc_export LIBS11N_CONFIG=$s11nconfig

eval $($s11nconfig --toc-config | sed -e 's/$/; /')

return 0


