using System;
using System.Runtime.InteropServices;
 
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html XML-level errors, warnings and other diagnostics.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * LibSBML can be configured to use any of a number of XML parsers; at the
 * time of this writing, libSBML supports Xerces versions 2.4 through 3.1,
 * Expat version 1.95.x and higher, and libxml2 version 2.6.16 and higher.
 * These parsers each report different status codes for the various
 * exceptions that can occur during XML processing.  The XMLError object
 * class abstracts away from the particular diagnostics reported by the
 * different parsers and presents a single uniform interface and set of
 * status codes, along with operations for manipulating the error objects.
 *
 * When the libSBML XML parser layer encounters an error in the XML content
 * being processed, or when there is something else wrong (such as an
 * out-of-memory condition), the problems are reported as XMLError objects.
 * Each XMLError object instance has an identification number that
 * identifies the nature of the problem.
 * @if clike This error identifier will be up to five digits 
 * long and drawn from the enumeration <a class='el'
 * href='#error-codes'>XMLErrorCode_t</a>.  Applications can use the
 * error identifiers as a means of recognizing the error encountered and
 * changing their behavior if desired. @else This
 * error identifier is one of the constants listed in the next section below.
 * Applications can use the error identifiers as a means of recognizing the
 * error encountered and changing their behavior if desired.  @endif
 *
 * Integer error codes are useful for software, but not so much for telling
 * humans what happened.  For this reason, XMLError also provides two text
 * messages describing the nature of the error.  These messages are
 * accessible by means of the methods XMLError::getShortMessage() and
 * XMLError::getMessage().  The method XMLError::getShortMessage() returns
 * a very brief synopsis of the warning or error condition, whereas
 * XMLError::getMessage() returns a longer explanation.  These text strings
 * are suitable for displaying to human users.
 *
 * Each XMLError object also contains a category code; its value may be
 * retrieved using the method XMLError::getCategory().  Category values
 * are drawn from @if clike the enumeration <a class='el' href='#XMLErrorCategory_t'>XMLErrorCategory_t</a> described below.@else a
 * set of constants whose names begin with the characters @c LIBSBML_CAT_, described below.@endif &nbsp;Categories
 * are used by libSBML to provide more information to calling programs about
 * the nature of a given error.  
 *
 * In addition to category codes, each XMLError object also has a severity
 * code; its value may be retrieved using the method
 * XMLError::getSeverity().  Severity code values are drawn from
 * @if clike the enumeration <a class='el' href='#XMLErrorSeverity_t'>XMLErrorSeverity_t</a>@else a
 * set of constants whose names begin with the characters @c LIBSBML_SEV_@endif,
 * described below. Severity levels range from informational
 * (@link libsbml#LIBSBML_SEV_INFO LIBSBML_SEV_INFO@endlink) to
 * fatal errors (@link libsbml#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL@endlink).
 *
 * Finally, XMLError objects record the line and column near where the
 * problem occurred in the XML content.  The values can be retrieved using
 * the methods XMLError::getLine() and XMLError::getColumn().  We say 'near
 * where the problem occurred', because many factors affect how accurate
 * the line/column information ultimately is.  For example, sometimes, the
 * underlying XML parsers can only report such information for the parent
 * XML element where an error occurs, and not for the specific point where
 * the problem occurs.  In other situations, some parsers report invalid
 * line and/or column numbers altogether.  If this occurs, libSBML sets the
 * line and/or column number in the XMLError object to either
 * <code>0</code> or the value of the maximum unsigned long integer
 * representable on the platform where libSBML is running.  The probability
 * that a true line or column number in an SBML model would equal this
 * value is vanishingly small; thus, if an application encounters these
 * values in an XMLError object, it can assume no valid line/column number
 * could be provided by libSBML in that situation.
 * 
 * @if clike
 * <h3><a class='anchor' name='error-codes'>XMLErrorCode_t</a></h3>
 *
 * This is an enumeration of all the error and warning codes returned by
 * the XML layer in libSBML.  Each code is an integer with a 4-digit value
 * less than 10000.  The following table lists each possible value and a
 * brief description of its meaning.
 * @endif@if java <h3><a class='anchor' 
 * name='error-codes'>Error codes associated with XMLError objects</a></h3>
 * 
 * The error and warning codes returned by the XML layer in libSBML are
 * listed in the table below.  In the libSBML Java language interface,
 * these error identifiers are currently implemented as static integer
 * constants defined in the interface class <code><a
 * href='libsbml.libsbml.html'>libsbmlConstants</a></code>.  This is
 * admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the error
 * identifiers. @endif@if csharp <h3><a class='anchor' 
 * name='error-codes'>Error codes associated with XMLError objects</a></h3>
 * 
 * The error and warning codes returned by the XML layer in libSBML are
 * listed in the table below.  In the libSBML C# language interface,
 * these error identifiers are currently implemented as static integer
 * constants defined in the interface class @link libsbmlcs.libsbml@endlink.@endif
 *
 * <center>
 * <table cellspacing='1' cellpadding='1' border='0' width='95%'
          class='text-table normal-font alt-row-colors'>
 * <caption>Possible XMLError error codes.  Depending on the programming
 * language in use, the <em>Enumerator</em> values will be defined either
 * as a value from an enumeration type @if clike (XMLErrorCode_t)@endif
 * or as integer constants.
 * To make this table more compact, we have shortened the identifiers for
 * the category and severity codes to their essential parts.  To get the
 * actual names of the constants, prepend <code>LIBSBML_CAT_</code> to the
 * category names and <code>LIBSBML_SEV_</code> to the severity names
 * shown in the two right-hand columns.
 * </caption>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th style='text-align: left'>Enumerator</th>
 *      <th>Meaning</th>
 *      <th width='90' style='text-align: left'>Category</th>
 *      <th width='90' style='text-align: left'>Severity</th>
 *  </tr>
 * <tr><td>@link libsbml#XMLUnknownError XMLUnknownError@endlink</td><td>Unrecognized error encountered internally</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td>@link libsbml#XMLOutOfMemory XMLOutOfMemory@endlink</td> <td>Out of memory</td><td>SYSTEM</td><td>FATAL</td></tr>
 * <tr><td>@link libsbml#XMLFileUnreadable XMLFileUnreadable@endlink</td> <td>File unreadable</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLFileUnwritable XMLFileUnwritable@endlink</td> <td>File unwritable</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLFileOperationError XMLFileOperationError@endlink</td><td>Error encountered while attempting file operation</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLNetworkAccessError XMLNetworkAccessError@endlink</td><td>Network access error</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#InternalXMLParserError InternalXMLParserError@endlink</td><td>Internal XML parser state error</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td>@link libsbml#UnrecognizedXMLParserCode UnrecognizedXMLParserCode@endlink</td><td>XML parser returned an unrecognized error code</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td>@link libsbml#XMLTranscoderError XMLTranscoderError@endlink</td><td>Character transcoder error</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td>@link libsbml#MissingXMLDecl MissingXMLDecl@endlink</td><td>Missing XML declaration at beginning of XML input</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#MissingXMLEncoding MissingXMLEncoding@endlink</td><td>Missing encoding attribute in XML declaration</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLDecl BadXMLDecl@endlink</td><td>Invalid or unrecognized XML declaration or XML encoding</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLDOCTYPE BadXMLDOCTYPE@endlink</td><td>Invalid, malformed or unrecognized XML DOCTYPE declaration</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#InvalidCharInXML InvalidCharInXML@endlink</td><td>Invalid character in XML content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadlyFormedXML BadlyFormedXML@endlink</td><td>XML content is not well-formed</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#UnclosedXMLToken UnclosedXMLToken@endlink</td><td>Unclosed XML token</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#InvalidXMLConstruct InvalidXMLConstruct@endlink</td><td>XML construct is invalid or not permitted</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLTagMismatch XMLTagMismatch@endlink</td><td>Element tag mismatch or missing tag</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#DuplicateXMLAttribute DuplicateXMLAttribute@endlink</td><td>Duplicate XML attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#UndefinedXMLEntity UndefinedXMLEntity@endlink</td><td>Undefined XML entity</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadProcessingInstruction BadProcessingInstruction@endlink</td><td>Invalid, malformed or unrecognized XML processing instruction</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLPrefix BadXMLPrefix@endlink</td><td>Invalid or undefined XML namespace prefix</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLPrefixValue BadXMLPrefixValue@endlink</td><td>Invalid XML namespace prefix value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#MissingXMLRequiredAttribute MissingXMLRequiredAttribute@endlink</td><td>Missing a required XML attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLAttributeTypeMismatch XMLAttributeTypeMismatch@endlink</td><td>Data type mismatch for the value of an attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLBadUTF8Content XMLBadUTF8Content@endlink</td><td>Invalid UTF8 content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#MissingXMLAttributeValue MissingXMLAttributeValue@endlink</td><td>Missing or improperly formed attribute value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLAttributeValue BadXMLAttributeValue@endlink</td><td>Invalid or unrecognizable attribute value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLAttribute BadXMLAttribute@endlink</td><td>Invalid, unrecognized or malformed attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#UnrecognizedXMLElement UnrecognizedXMLElement@endlink</td><td>Element either not recognized or not permitted</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLComment BadXMLComment@endlink</td><td>Badly formed XML comment</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLDeclLocation BadXMLDeclLocation@endlink</td><td>XML declaration not permitted in this location</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLUnexpectedEOF XMLUnexpectedEOF@endlink</td><td>Reached end of input unexpectedly</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLIDValue BadXMLIDValue@endlink</td><td>Value is invalid for XML ID, or has already been used</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLIDRef BadXMLIDRef@endlink</td><td>XML ID value was never declared</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#UninterpretableXMLContent UninterpretableXMLContent@endlink</td><td>Unable to interpret content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#BadXMLDocumentStructure BadXMLDocumentStructure@endlink</td><td>Bad XML document structure</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#InvalidAfterXMLContent InvalidAfterXMLContent@endlink</td><td>Encountered invalid content after expected content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLExpectedQuotedString XMLExpectedQuotedString@endlink</td><td>Expected to find a quoted string</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLEmptyValueNotPermitted XMLEmptyValueNotPermitted@endlink</td><td>An empty value is not permitted in this context</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLBadNumber XMLBadNumber@endlink</td><td>Invalid or unrecognized number</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLBadColon XMLBadColon@endlink</td><td>Colon characters are invalid in this context</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#MissingXMLElements MissingXMLElements@endlink</td><td>One or more expected elements are missing</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td>@link libsbml#XMLContentEmpty XMLContentEmpty@endlink</td><td>Main XML content is empty</td><td>XML</td><td>ERROR</td></tr>
 * </table>
 * </center>
 *
 *
 * @if clike
 * <h3><a class='anchor' name='error-categories'>XMLErrorCategory_t</a></h3>
 *
 * As discussed above, each XMLError object contains a value for a category
 * identifier, describing the type of issue that the XMLError object
 * represents.  The category can be retrieved from an XMLError object using
 * the method XMLError::getCategory().  The value is chosen from the
 * enumeration of category codes <a class='el' href='#XMLErrorCategory_t'>
 * XMLErrorCategory_t</a>.  The following table
 * lists each possible value and a brief description of its meaning.
 * @endif@if java <h3><a class='anchor'
 * name='error-categories'>Category codes associated with XMLError objects</a></h3>
 *
 * As discussed above, each XMLError object contains a value for a category
 * identifier, describing the type of issue that the XMLError object represents.
 * The category can be retrieved from an XMLError object using the method
 * XMLError::getCategory(). The following table lists each possible value
 * and a brief description of its meaning.
 * 
 * As is the case with the error codes, in the libSBML Java language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * <code>libsbmlConstants</code> in the file '<a
 * href='libsbml.libsbml.html'>libsbml.libsbml.java</a>'.
 * @endif@if csharp <h3><a class='anchor'
 * name='error-categories'>Category codes associated with XMLError objects</a></h3>
 *
 * As discussed above, each XMLError object contains a value for a category
 * identifier, describing the type of issue that the XMLError object represents.
 * The category can be retrieved from an XMLError object using the method
 * XMLError::getCategory(). The following table lists each possible value
 * and a brief description of its meaning.
 * 
 * As is the case with the error codes, in the libSBML C# language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface
 * class @link libsbmlcs.libsbml@endlink. @endif
 *
 * <center>
 * <table width='95%' cellspacing='1' cellpadding='1' border='0'
 *        class='text-table normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th style='text-align: left'>Enumerator</th>
 *      <th>Meaning</th>
 *  </tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_INTERNAL LIBSBML_CAT_INTERNAL@endlink</td>
 * <td>A problem involving the libSBML
 * software itself or the underlying XML parser.  This almost certainly
 * indicates a software defect (i.e., bug) in libSBML.  Please report
 * instances of this to the libSBML developers.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SYSTEM LIBSBML_CAT_SYSTEM@endlink</td>
 * <td>A problem reported by the operating
 * system, such as an inability to read or write a file.  This indicates
 * something that is not a program error but is outside of the control of
 * libSBML.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_XML LIBSBML_CAT_XML@endlink</td>
 * <td>A problem in the XML content itself.  This
 * usually arises from malformed XML or the use of
 * constructs not permitted in SBML.</td></tr>
 * </table>
 * </center>
 *
 *
 * @if clike
 * <h3><a class='anchor' name='error-severities'>XMLErrorSeverity_t</a></h3>
 *
 * As described above, each XMLError object contains a value for a severity
 * code, describing how critical is the issue that the XMLError object
 * represents.  The severity can be retrieved from an XMLError object using
 * the method XMLError::getSeverity().  The value is chosen from the
 * enumeration of category codes <a class='el' href='#XMLErrorSeverity_t'>
 * XMLErrorSeverity_t</a>.  The following table
 * lists each possible value and a brief description of its meaning.
 * @endif@if java <h3><a class='anchor'
 * name='error-severities'>Severity codes associated with XMLError objects</a></h3>
 * 
 * As described above, each XMLError object contains a value for a severity
 * code, describing how severe is the issue that the XMLError object
 * represents.  The severity be retrieved from an XMLError object using the
 * method XMLError::getSeverity(). The following table lists each possible
 * value and a brief description of its meaning.
 * 
 * As is the case with the category codes, in the libSBML Java language
 * interface, these severity codes are currently
 * implemented as static integer constants defined in the interface class
 * <code>libsbmlConstants</code> in the file '<a
 * href='libsbml.libsbml.html'>libsbml.libsbml.java</a>'.  This
 * is admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the severity
 * codes. @endif@if csharp <h3><a class='anchor'
 * name='error-severities'>Severity codes associated with XMLError objects</a></h3>
 * 
 * As described above, each XMLError object contains a value for a severity
 * code, describing how severe is the issue that the XMLError object
 * represents.  The severity be retrieved from an XMLError object using the
 * method XMLError::getSeverity(). The following table lists each possible
 * value and a brief description of its meaning.
 * 
 * As is the case with the category codes, in the libSBML C# language
 * interface, these severity codes are currently
 * implemented as static integer constants defined in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif
 *
 * <center>
 * <table width='95%' cellspacing='1' cellpadding='1' border='0'
 *        class='text-table normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th style='text-align: left'>Enumerator</th>
 *      <th>Meaning</th>
 *  </tr>
 * <tr><td>@link libsbml#LIBSBML_SEV_INFO LIBSBML_SEV_INFO@endlink</td>
 * <td>The error is actually informational and
 * not necessarily a serious problem.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_SEV_WARNING LIBSBML_SEV_WARNING@endlink</td>
 * <td>The error object represents a problem
 * that is not serious enough to necessarily stop the problem, but
 * applications should take note of the problem and evaluate what its
 * implications may be.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_SEV_ERROR LIBSBML_SEV_ERROR@endlink</td>
 * <td>The error object represents a serious
 * error.  The application may continue running but it is unlikely to be
 * able to continue processing the same XML file or data stream.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL@endlink</td>
 * <td>A serious error occurred, such as an
 * out-of-memory condition, and the software should terminate
 * immediately.</td></tr>
 * </table>
 * </center>
 */

public class XMLError : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal XMLError(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(XMLError obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (XMLError obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~XMLError() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_XMLError(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(XMLError lhs, XMLError rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(XMLError lhs, XMLError rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is XMLError) )
    {
      return false;
    }

    return this == (XMLError)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
/**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   *
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>.
   * @else These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbml.libsbml.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings. @endif The argument @p
   * errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it is a value
   * from <a class='el' href='#error-codes'>XMLErrorCode_t</a>, the
   * XMLError class assumes the error is a low-level system or XML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el' href='#error-codes'>XMLErrorCode_t</a>
   * errors have associated values for the @p severity and @p category
   * codes, and these fields are filled-in as well from the enumerations <a
   * class='el' href='#error-severities'>XMLErrorSeverity_t</a> and <a
   * class='el' href='#error-categories'>XMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the @p
   * severity and @p category codes, and these fields are filled-in as
   * well. @endif
   *
   * If the error identifier @p errorId is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined XMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#error-codes'>XMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, but their own
   * special values) for @p severity and @p
   * category. @else As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * XML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * @param errorId a long integer, the identification number of the error.
   * 
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by XMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * 
   * @param line a long integer, the line number at which the error occured.
   * 
   * @param column a long integer, the column number at which the error occured.
   * 
   * @param severity an integer indicating severity of the error.
   * 
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLError(int errorId, string details, long line, long column, long severity, long category) : this(libsbmlPINVOKE.new_XMLError__SWIG_0(errorId, details, line, column, severity, category), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   *
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>.
   * @else These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbml.libsbml.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings. @endif The argument @p
   * errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it is a value
   * from <a class='el' href='#error-codes'>XMLErrorCode_t</a>, the
   * XMLError class assumes the error is a low-level system or XML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el' href='#error-codes'>XMLErrorCode_t</a>
   * errors have associated values for the @p severity and @p category
   * codes, and these fields are filled-in as well from the enumerations <a
   * class='el' href='#error-severities'>XMLErrorSeverity_t</a> and <a
   * class='el' href='#error-categories'>XMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the @p
   * severity and @p category codes, and these fields are filled-in as
   * well. @endif
   *
   * If the error identifier @p errorId is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined XMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#error-codes'>XMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, but their own
   * special values) for @p severity and @p
   * category. @else As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * XML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * @param errorId a long integer, the identification number of the error.
   * 
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by XMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * 
   * @param line a long integer, the line number at which the error occured.
   * 
   * @param column a long integer, the column number at which the error occured.
   * 
   * @param severity an integer indicating severity of the error.
   * 
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLError(int errorId, string details, long line, long column, long severity) : this(libsbmlPINVOKE.new_XMLError__SWIG_1(errorId, details, line, column, severity), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   *
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>.
   * @else These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbml.libsbml.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings. @endif The argument @p
   * errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it is a value
   * from <a class='el' href='#error-codes'>XMLErrorCode_t</a>, the
   * XMLError class assumes the error is a low-level system or XML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el' href='#error-codes'>XMLErrorCode_t</a>
   * errors have associated values for the @p severity and @p category
   * codes, and these fields are filled-in as well from the enumerations <a
   * class='el' href='#error-severities'>XMLErrorSeverity_t</a> and <a
   * class='el' href='#error-categories'>XMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the @p
   * severity and @p category codes, and these fields are filled-in as
   * well. @endif
   *
   * If the error identifier @p errorId is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined XMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#error-codes'>XMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, but their own
   * special values) for @p severity and @p
   * category. @else As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * XML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * @param errorId a long integer, the identification number of the error.
   * 
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by XMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * 
   * @param line a long integer, the line number at which the error occured.
   * 
   * @param column a long integer, the column number at which the error occured.
   * 
   * @param severity an integer indicating severity of the error.
   * 
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLError(int errorId, string details, long line, long column) : this(libsbmlPINVOKE.new_XMLError__SWIG_2(errorId, details, line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   *
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>.
   * @else These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbml.libsbml.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings. @endif The argument @p
   * errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it is a value
   * from <a class='el' href='#error-codes'>XMLErrorCode_t</a>, the
   * XMLError class assumes the error is a low-level system or XML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el' href='#error-codes'>XMLErrorCode_t</a>
   * errors have associated values for the @p severity and @p category
   * codes, and these fields are filled-in as well from the enumerations <a
   * class='el' href='#error-severities'>XMLErrorSeverity_t</a> and <a
   * class='el' href='#error-categories'>XMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the @p
   * severity and @p category codes, and these fields are filled-in as
   * well. @endif
   *
   * If the error identifier @p errorId is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined XMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#error-codes'>XMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, but their own
   * special values) for @p severity and @p
   * category. @else As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * XML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * @param errorId a long integer, the identification number of the error.
   * 
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by XMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * 
   * @param line a long integer, the line number at which the error occured.
   * 
   * @param column a long integer, the column number at which the error occured.
   * 
   * @param severity an integer indicating severity of the error.
   * 
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLError(int errorId, string details, long line) : this(libsbmlPINVOKE.new_XMLError__SWIG_3(errorId, details, line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   *
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>.
   * @else These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbml.libsbml.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings. @endif The argument @p
   * errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it is a value
   * from <a class='el' href='#error-codes'>XMLErrorCode_t</a>, the
   * XMLError class assumes the error is a low-level system or XML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el' href='#error-codes'>XMLErrorCode_t</a>
   * errors have associated values for the @p severity and @p category
   * codes, and these fields are filled-in as well from the enumerations <a
   * class='el' href='#error-severities'>XMLErrorSeverity_t</a> and <a
   * class='el' href='#error-categories'>XMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the @p
   * severity and @p category codes, and these fields are filled-in as
   * well. @endif
   *
   * If the error identifier @p errorId is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined XMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#error-codes'>XMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, but their own
   * special values) for @p severity and @p
   * category. @else As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * XML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * @param errorId a long integer, the identification number of the error.
   * 
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by XMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * 
   * @param line a long integer, the line number at which the error occured.
   * 
   * @param column a long integer, the column number at which the error occured.
   * 
   * @param severity an integer indicating severity of the error.
   * 
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLError(int errorId, string details) : this(libsbmlPINVOKE.new_XMLError__SWIG_4(errorId, details), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   *
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>.
   * @else These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbml.libsbml.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings. @endif The argument @p
   * errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it is a value
   * from <a class='el' href='#error-codes'>XMLErrorCode_t</a>, the
   * XMLError class assumes the error is a low-level system or XML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el' href='#error-codes'>XMLErrorCode_t</a>
   * errors have associated values for the @p severity and @p category
   * codes, and these fields are filled-in as well from the enumerations <a
   * class='el' href='#error-severities'>XMLErrorSeverity_t</a> and <a
   * class='el' href='#error-categories'>XMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the @p
   * severity and @p category codes, and these fields are filled-in as
   * well. @endif
   *
   * If the error identifier @p errorId is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined XMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#error-codes'>XMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, but their own
   * special values) for @p severity and @p
   * category. @else As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * XML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * @param errorId a long integer, the identification number of the error.
   * 
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by XMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * 
   * @param line a long integer, the line number at which the error occured.
   * 
   * @param column a long integer, the column number at which the error occured.
   * 
   * @param severity an integer indicating severity of the error.
   * 
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLError(int errorId) : this(libsbmlPINVOKE.new_XMLError__SWIG_5(errorId), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   *
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>.
   * @else These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbml.libsbml.java'.  See the <a class='el'
   * href='#error-codes'>top of this documentation</a> for a table
   * listing the possible values and their meanings. @endif The argument @p
   * errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it is a value
   * from <a class='el' href='#error-codes'>XMLErrorCode_t</a>, the
   * XMLError class assumes the error is a low-level system or XML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el' href='#error-codes'>XMLErrorCode_t</a>
   * errors have associated values for the @p severity and @p category
   * codes, and these fields are filled-in as well from the enumerations <a
   * class='el' href='#error-severities'>XMLErrorSeverity_t</a> and <a
   * class='el' href='#error-categories'>XMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the @p
   * severity and @p category codes, and these fields are filled-in as
   * well. @endif
   *
   * If the error identifier @p errorId is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined XMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#error-codes'>XMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#error-codes'>XMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#error-severities'>XMLErrorSeverity_t</a> and <a class='el'
   * href='#error-categories'>XMLErrorCategory_t</a>, but their own
   * special values) for @p severity and @p
   * category. @else As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#error-severities'>standard severity</a> and <a class='el'
   * href='#error-categories'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * XML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * @param errorId a long integer, the identification number of the error.
   * 
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by XMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * 
   * @param line a long integer, the line number at which the error occured.
   * 
   * @param column a long integer, the column number at which the error occured.
   * 
   * @param severity an integer indicating severity of the error.
   * 
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLError() : this(libsbmlPINVOKE.new_XMLError__SWIG_6(), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this XMLError.
   *
   * @p orig the XMLError object to copy.
   */ public
 XMLError(XMLError orig) : this(libsbmlPINVOKE.new_XMLError__SWIG_7(XMLError.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Returns the identifier of this error.
   *
   * @return the error code for this error.
   * 
   * @see getMessage()
   * @see getShortMessage()
   * @see getCategory()
   * @see getSeverity()
   */ public
 long getErrorId() { return (long)libsbmlPINVOKE.XMLError_getErrorId(swigCPtr); }

  
/**
   * Returns the message text of this error.
   *
   * The message associated with an error object describes the nature of
   * the problem.  The message returned by this method is generally longer
   * and clearer than the message returned by XMLError::getShortMessage(),
   * but not in all cases.
   *
   * Callers may use XMLError::getCategory() and XMLError::getSeverity() to
   * obtain additional information about the nature and severity of the
   * problem.
   *
   * @return the message text
   *
   * @see getErrorId()
   * @see getShortMessage()
   * @see getCategory()
   * @see getSeverity()
   */ public
 string getMessage() {
    string ret = libsbmlPINVOKE.XMLError_getMessage(swigCPtr);
    return ret;
  }

  
/**
   * Returns a brief message for this error.
   *
   * This is an alternative error message that, in general, is as short as
   * the authors could make it.  However, brevity is often inversely
   * proportional to clarity, so this short message may not be sufficiently
   * informative to understand the nature of the error.  Calling
   * applications may wish to check XMLError::getMessage() in addition or
   * instead.
   *
   * @return the short error message text
   * 
   * @see getErrorId()
   * @see getMessage()
   * @see getCategory()
   * @see getSeverity()
   */ public
 string getShortMessage() {
    string ret = libsbmlPINVOKE.XMLError_getShortMessage(swigCPtr);
    return ret;
  }

  
/**
   * Returns the line number in the XML input near where the error, warning
   * or other diagnostic occurred.
   *
   * We say 'near where the problem occurred', because many factors affect
   * how accurate the line/column information ultimately is.  For example,
   * sometimes, the underlying XML parsers can only report such information
   * for the parent XML element where an error occurs, and not for the
   * specific point where the problem occurs.  In other situations, some
   * parsers report invalid line and/or column numbers altogether.  If this
   * occurs, libSBML sets the line and/or column number in the XMLError
   * object to either <code>0</code> or the value of the maximum unsigned
   * long integer representable on the platform where libSBML is running.
   * The probability that a true line or column number in an SBML model
   * would equal this value is vanishingly small; thus, if an application
   * encounters these values in an XMLError object, it can assume no valid
   * line/column number could be provided by libSBML in that situation.
   *
   * @return the line number
   *
   * @see getColumn()
   */ public
 long getLine() { return (long)libsbmlPINVOKE.XMLError_getLine(swigCPtr); }

  
/**
   * Returns the column number in the XML input near where the error,
   * warning or other diagnostic occurred.
   *
   * We say 'near where the problem occurred', because many factors affect
   * how accurate the line/column information ultimately is.  For example,
   * sometimes, the underlying XML parsers can only report such information
   * for the parent XML element where an error occurs, and not for the
   * specific point where the problem occurs.  In other situations, some
   * parsers report invalid line and/or column numbers altogether.  If this
   * occurs, libSBML sets the line and/or column number in the XMLError
   * object to either <code>0</code> or the value of the maximum unsigned
   * long integer representable on the platform where libSBML is running.
   * The probability that a true line or column number in an SBML model
   * would equal this value is vanishingly small; thus, if an application
   * encounters these values in an XMLError object, it can assume no valid
   * line/column number could be provided by libSBML in that situation.
   *
   * @return the column number
   *
   * @see getLine()
   */ public
 long getColumn() { return (long)libsbmlPINVOKE.XMLError_getColumn(swigCPtr); }

  
/**
   * Returns the severity of this error.
   *
   * XMLError defines an enumeration of severity codes for the XML layer.
   * Applications that build on XMLError by subclassing it may add their
   * own severity codes with numbers higher than those in the predefined
   * set of severity codes.
   *
   * @return the severity of this XMLError.
   *
   * @see getSeverityAsString()
   * @see getCategory()
   */ public
 long getSeverity() { return (long)libsbmlPINVOKE.XMLError_getSeverity(swigCPtr); }

  
/**
   * Returns a string describing the severity level of this error.
   *
   * XMLError defines an enumeration of severity codes for the XML layer.
   * Applications that build on XMLError by subclassing it may add their
   * own severity codes with numbers higher than those in the predefined
   * set of severity codes.
   *
   * @return string representing the severity of this XMLError.
   *
   * @see getSeverity()
   * @see getCategoryAsString()
   */ public
 string getSeverityAsString() {
    string ret = libsbmlPINVOKE.XMLError_getSeverityAsString(swigCPtr);
    return ret;
  }

  
/**
   * Returns the category of this error.
   *
   * XMLError defines an enumeration of category codes for the XML layer.
   * Applications that build on XMLError by subclassing it may add their
   * own categories with numbers higher than those in the predefined
   * set of category codes.
   *
   * Categories can be used to partition errors into distinct groups.
   * Among other things, this can be used to prevent id conflicts by
   * uniquely identifying an XMLError by both id and category.
   *
   * @return the category of this XMLError.
   *
   * @see getSeverity()
   * @see getCategoryAsString()
   */ public
 long getCategory() { return (long)libsbmlPINVOKE.XMLError_getCategory(swigCPtr); }

  
/**
   * Returns a string describing the category of this error.
   *
   * XMLError defines an enumeration of category codes for the XML layer.
   * Applications that build on XMLError by subclassing it may add their
   * own categories with numbers higher than those in the predefined
   * set of category codes.
   *
   * Categories can be used to partition errors into distinct groups.
   * Among other things, this can be used to prevent id conflicts by
   * uniquely identifying an XMLError by both id and category.
   *
   * @return string representing the category of this XMLError.
   *
   * @see getCategory()
   * @see getSeverityAsString()
   */ public
 string getCategoryAsString() {
    string ret = libsbmlPINVOKE.XMLError_getCategoryAsString(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true or @c false depending on whether this
   * error object is for information purposes only.
   *
   * This is equivalent to obtaining the severity code from an XMLError
   * object (via XMLError::getSeverity()) and then comparing it to the
   * value @link libsbml#LIBSBML_SEV_INFO LIBSBML_SEV_INFO@endlink from the
   * @if clike enumeration #XMLErrorSeverity_t. @else set of predefined
   * severity codes.@endif
   *
   * @return @c true if this XMLError is for informational purposes only,
   * @c false otherwise.
   *
   * @see isWarning()
   * @see isError()
   * @see isFatal()
   */ public
 bool isInfo() {
    bool ret = libsbmlPINVOKE.XMLError_isInfo(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true or @c false depending on whether 
   * this error object is a warning.
   *
   * This is equivalent to obtaining the severity code from an XMLError
   * object (via XMLError::getSeverity()) and then comparing it to the
   * value @link libsbml#LIBSBML_SEV_WARNING LIBSBML_SEV_WARNING@endlink from the
   * @if clike enumeration #XMLErrorSeverity_t. @else set of predefined
   * severity codes.@endif
   *
   * @return @c true if this error is a warning, @c false otherwise.
   *
   * @see isInfo()
   * @see isError()
   * @see isFatal()
   */ public
 bool isWarning() {
    bool ret = libsbmlPINVOKE.XMLError_isWarning(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true or @c false depending on whether this
   * error is a significant error.
   *
   * This is equivalent to obtaining the severity code from an XMLError
   * object (via XMLError::getSeverity()) and then comparing it to the
   * value @link libsbml#LIBSBML_SEV_ERROR LIBSBML_SEV_ERROR@endlink from the
   * @if clike enumeration #XMLErrorSeverity_t. @else set of predefined
   * severity codes.@endif
   *
   * @return @c true if this error is an error, @c false otherwise.
   *
   * @see isInfo()
   * @see isWarning()
   * @see isFatal()
   */ public
 bool isError() {
    bool ret = libsbmlPINVOKE.XMLError_isError(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true or @c false depending on whether this
   * error is a fatal run-time error.
   *
   * This is equivalent to obtaining the severity code from an XMLError
   * object (via XMLError::getSeverity()) and then comparing it to the
   * value @link libsbml#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL@endlink from the
   * @if clike enumeration #XMLErrorSeverity_t. @else set of predefined severity codes.@endif
   *
   * @return @c true if this error is a fatal error, @c false otherwise.
   *
   * @see isInfo()
   * @see isWarning()
   * @see isError()
   */ public
 bool isFatal() {
    bool ret = libsbmlPINVOKE.XMLError_isFatal(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true or @c false depending on whether this
   * error resulted from an internal program error.
   *
   * This is equivalent to obtaining the category identifier from an
   * XMLError object (via XMLError::getCategory()) and then comparing it to
   * the value @link libsbml#LIBSBML_CAT_INTERNAL LIBSBML_CAT_INTERNAL@endlink from the
   * @if clike enumeration #XMLErrorCategory_t. @else set of predefined category codes.@endif
   *
   * @return @c true or @c false
   *
   * @see isSystem()
   * @see isXML()
   */ public
 bool isInternal() {
    bool ret = libsbmlPINVOKE.XMLError_isInternal(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true or @c false depending on whether this
   * error was generated by the operating system.
   *
   * This is equivalent to obtaining the category identifier from an
   * XMLError object (via XMLError::getCategory()) and then comparing it to
   * the value @link libsbml#LIBSBML_CAT_SYSTEM LIBSBML_CAT_SYSTEM@endlink from the
   * @if clike enumeration #XMLErrorCategory_t. @else set of predefined category codes.@endif
   *
   * @return @c true or @c false
   *
   * @see isInternal()
   * @see isXML()
   */ public
 bool isSystem() {
    bool ret = libsbmlPINVOKE.XMLError_isSystem(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true or @c false depending on whether this
   * error resulted from a problem in the XML input (e.g., an XML syntax
   * error).
   *
   * This is equivalent to obtaining the category identifier from an
   * XMLError object (via XMLError::getCategory()) and then comparing it to
   * the value @link libsbml#LIBSBML_CAT_XML LIBSBML_CAT_XML@endlink from the
   * @if clike enumeration #XMLErrorCategory_t. @else set of predefined category codes.@endif
   *
   * @return @c true or @c false
   *
   * @see isInternal()
   * @see isSystem()
   */ public
 bool isXML() {
    bool ret = libsbmlPINVOKE.XMLError_isXML(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true or @c false depending on whether this
   * error resulted from a problem or whether it was logged as an unknown
   * error.
   *
   * This is equivalent to obtaining the error identifier from an
   * XMLError object (via XMLError::getErrorId()) and then comparing it to
   * the value XMLUnknownError or UnknownError from the
   * @if clike enumeration #XMLErrorCode_t. @else set of predefined error codes.@endif
   *
   * @return @c true or @c false
   */ public
 bool isValid() {
    bool ret = libsbmlPINVOKE.XMLError_isValid(swigCPtr);
    return ret;
  }

  
/**
   * Sets the line number where this error occurred.
   * 
   * @param line a long integer, the line number to set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see setColumn(unsigned int column)
   */ public
 int setLine(long line) {
    int ret = libsbmlPINVOKE.XMLError_setLine(swigCPtr, line);
    return ret;
  }

  
/**
   * Sets the column number where this error occurred.
   * 
   * @param column a long integer, the column number to set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see setLine(unsigned int line)
   */ public
 int setColumn(long column) {
    int ret = libsbmlPINVOKE.XMLError_setColumn(swigCPtr, column);
    return ret;
  }

  
/**
   * Returns a copy of the message string associated with the given
   * predefined XMLError code.
   *
   * @param code the error code whose message is sought; it must be a
   * predefined value from @if clike <a class='el' href='#error-codes'>
   * XMLErrorCode_t</a>. @else <a class='el' href='#error-codes'>the set
   * of predefined error identifiers</a>.@endif
   */ public
 static string getStandardMessage(int code) {
    string ret = libsbmlPINVOKE.XMLError_getStandardMessage(code);
    return ret;
  }

  
/**
   * Returns the SBML Level&nbsp;3 package extension (if any) that logged
   * this error.
   *
   * Each error logged by an libSBML extension for SBML Level&nbsp;3 packages
   * includes a record of the package that logged it.  The field is a simple
   * text string.  If the string is empty or has the value @c 'core', then
   * the error came from libSBML core; otherwise, the string will be the
   * short-form name of the package (e.g., @c 'comp' for the Hierarchical
   * Model Composition package).
   *
   * @return a string representing the name of the package that logged this
   * error.  If the error did not come from a package extension, the value
   * will be the empty string or @c 'core'.
   */ public
 string getPackage() {
    string ret = libsbmlPINVOKE.XMLError_getPackage(swigCPtr);
    return ret;
  }

  
/**
   * Returns libSBML's internal numerical offset for the error code
   * associated with this error.
   *
   * In the SBML Level&nbsp;3 package specifications, package validation
   * rules are identified by 5-digit numbers prefixed with the nickname of
   * the package itself---e.g., &ldquo;comp-10101&rdquo;,
   * &ldquo;fbc-20301&rdquo;, etc.  Historically, libSBML reported error
   * codes as pure integers, and some application software systems make
   * decisions based on the numerical values of the error codes.  To permit
   * these applications to continue to function in this fashion, libSBML
   * internally continues to maintain error identifiers as pure integers.  To
   * handle the possibility that errors may come from package extensions,
   * libSBML uses numerical offsets added to the internal error codes.  These
   * offsets add two leading digits to the regular 5-digit error codes; for
   * example, &ldquo;comp&rdquo; error codes are stored as 1010101, 1020102,
   * etc.  The offset in this case is 1000000.  Another package will have the
   * offset 2000000, yet another will have 3000000, etc.
   *
   * This method returns the integer offset in this error's error code.
   * Calling applications can get the 5-digit package-specific number for a
   * given error code by subtracting the offset from the value reported by
   * getErrorId():
   * @verbatim
 getErrorId() - getErrorIdOffset()
 @endverbatim
   * When libSBML produces error messages, it combines the text string
   * returned by getPackage() with the subtracted value of the error code,
   * to produce a text string of the form &ldquo;comp-10101&rdquo;.
   *
   * @see getErrorId()
   * @see getPackage()
   */ public
 long getErrorIdOffset() { return (long)libsbmlPINVOKE.XMLError_getErrorIdOffset(swigCPtr); }

}

}
