/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html A token in an XML stream.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * The libSBML XML parser interface can read an XML file or data stream and
 * convert the contents into tokens.  The tokens represent items in the XML
 * stream, either XML elements (start or end tags) or text that appears as
 * content inside an element.  The XMLToken class is libSBML's low-level
 * representation of these entities.
 *
 * Each XMLToken has the following information associated with it:
 * <ol>
 * <li> <em>Qualified name</em>: every XML element or XML attribute has a
 * name (e.g., for the element <code>&lt;mytag&gt;</code>, the name is
 * <code>'mytag'</code>), but this name may be qualified with a namespace
 * (e.g., it may appear as <code>&lt;someNamespace:mytag&gt;</code> in the
 * input).  An XMLToken stores the name of a token, along with any namespace
 * qualification present, through the use of an XMLTriple object.  This
 * object stores the bare name of the element, its XML namespace prefix (if
 * any), and the XML namespace with which that prefix is associated.
 * <li> @em Namespaces: An XML token can have one or more XML namespaces
 * associated with it.  These namespaces may be specified explicitly on the
 * element or inherited from parent elements.  In libSBML, a list of
 * namespaces is stored in an XMLNamespaces object.  An XMLToken possesses a
 * field for storing an XMLNamespaces object.
 * <li> @em Attributes: XML elements can have attributes associated with
 * them, and these attributes can have values assigned to them.  The set of
 * attribute-value pairs is stored in an XMLAttributes object stored in an
 * XMLToken object.  (Note: only elements can have attributes&mdash;text
 * blocks cannot have them in XML.)
 * <li> @em Line number: the line number in the input where the token appears.
 * <li> @em Column number: the column number in the input where the token appears.
 * </ol>
 *
 * The XMLToken class serves as base class for XMLNode.  XML lends itself to
 * a tree-structured representation, and in libSBML, the nodes in an XML
 * document tree are XMLNode objects.  Most higher-level libSBML classes and
 * methods that offer XML-level functionality (such as the methods on SBase
 * for interacting with annotations) work with XMLNode objects rather than
 * XMLToken objects directly.
 *
 * @see XMLNode
 * @see XMLTriple
 * @see XMLAttributes
 * @see XMLNamespaces
 */

public class XMLToken : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal XMLToken(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(XMLToken obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (XMLToken obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~XMLToken() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_XMLToken(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(XMLToken lhs, XMLToken rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(XMLToken lhs, XMLToken rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is XMLToken) )
    {
      return false;
    }

    return this == (XMLToken)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
/**
   * Creates a new empty XMLToken object.
   */ public
 XMLToken() : this(libsbmlPINVOKE.new_XMLToken__SWIG_0(), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML start element with attributes and namespace declarations.
   *
   * @param triple an XMLTriple object describing the start tag.
   *
   * @param attributes XMLAttributes, the attributes to set on the element to
   * be created.
   *
   * @param namespaces XMLNamespaces, the namespaces to set on the element to
   * be created.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, long line, long column) : this(libsbmlPINVOKE.new_XMLToken__SWIG_1(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), XMLNamespaces.getCPtr(namespaces), line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML start element with attributes and namespace declarations.
   *
   * @param triple an XMLTriple object describing the start tag.
   *
   * @param attributes XMLAttributes, the attributes to set on the element to
   * be created.
   *
   * @param namespaces XMLNamespaces, the namespaces to set on the element to
   * be created.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, long line) : this(libsbmlPINVOKE.new_XMLToken__SWIG_2(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), XMLNamespaces.getCPtr(namespaces), line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML start element with attributes and namespace declarations.
   *
   * @param triple an XMLTriple object describing the start tag.
   *
   * @param attributes XMLAttributes, the attributes to set on the element to
   * be created.
   *
   * @param namespaces XMLNamespaces, the namespaces to set on the element to
   * be created.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces) : this(libsbmlPINVOKE.new_XMLToken__SWIG_3(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), XMLNamespaces.getCPtr(namespaces)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML start element with attributes.
   *
   * @param triple an XMLTriple object describing the start tag.
   *
   * @param attributes XMLAttributes, the attributes to set on the element to
   * be created.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * The XML namespace component of this XMLToken object will be left empty.
   * See the other variants of the XMLToken constructors for versions that
   * take namespace arguments.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, long line, long column) : this(libsbmlPINVOKE.new_XMLToken__SWIG_4(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML start element with attributes.
   *
   * @param triple an XMLTriple object describing the start tag.
   *
   * @param attributes XMLAttributes, the attributes to set on the element to
   * be created.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * The XML namespace component of this XMLToken object will be left empty.
   * See the other variants of the XMLToken constructors for versions that
   * take namespace arguments.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, long line) : this(libsbmlPINVOKE.new_XMLToken__SWIG_5(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML start element with attributes.
   *
   * @param triple an XMLTriple object describing the start tag.
   *
   * @param attributes XMLAttributes, the attributes to set on the element to
   * be created.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * The XML namespace component of this XMLToken object will be left empty.
   * See the other variants of the XMLToken constructors for versions that
   * take namespace arguments.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes) : this(libsbmlPINVOKE.new_XMLToken__SWIG_6(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML end element.
   *
   * @param triple an XMLTriple object describing the end tag.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple, long line, long column) : this(libsbmlPINVOKE.new_XMLToken__SWIG_7(XMLTriple.getCPtr(triple), line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML end element.
   *
   * @param triple an XMLTriple object describing the end tag.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple, long line) : this(libsbmlPINVOKE.new_XMLToken__SWIG_8(XMLTriple.getCPtr(triple), line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates an XML end element.
   *
   * @param triple an XMLTriple object describing the end tag.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(XMLTriple triple) : this(libsbmlPINVOKE.new_XMLToken__SWIG_9(XMLTriple.getCPtr(triple)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a text object.
   *
   * @param chars a string, the text to be added to the XMLToken object.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(string chars, long line, long column) : this(libsbmlPINVOKE.new_XMLToken__SWIG_10(chars, line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a text object.
   *
   * @param chars a string, the text to be added to the XMLToken object.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(string chars, long line) : this(libsbmlPINVOKE.new_XMLToken__SWIG_11(chars, line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a text object.
   *
   * @param chars a string, the text to be added to the XMLToken object.
   *
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   *
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 XMLToken(string chars) : this(libsbmlPINVOKE.new_XMLToken__SWIG_12(chars), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this XMLToken object.
   *
   * @param orig the XMLToken object to copy.
   */ public
 XMLToken(XMLToken orig) : this(libsbmlPINVOKE.new_XMLToken__SWIG_13(XMLToken.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this XMLToken object.
   *
   * @return the (deep) copy of this XMLToken object.
   */ public
 XMLToken clone() {
    IntPtr cPtr = libsbmlPINVOKE.XMLToken_clone(swigCPtr);
    XMLToken ret = (cPtr == IntPtr.Zero) ? null : new XMLToken(cPtr, true);
    return ret;
  }

  
/**
   * Returns the attributes of the XML element represented by this token.
   *
   * @return the attributes of this XML element, stored in an XMLAttributes
   * object.
   */ public
 XMLAttributes getAttributes() {
    XMLAttributes ret = new XMLAttributes(libsbmlPINVOKE.XMLToken_getAttributes(swigCPtr), false);
    return ret;
  }

  
/**
   * Sets the attributes on the XML element represented by this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param attributes an XMLAttributes object to be assigned to this
   * XMLToken object, thereby setting the XML attributes associated with this
   * token.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @note This function replaces any existing XMLAttributes object
   * on this XMLToken object with the one given by @p attributes.
   */ public
 int setAttributes(XMLAttributes attributes) {
    int ret = libsbmlPINVOKE.XMLToken_setAttributes(swigCPtr, XMLAttributes.getCPtr(attributes));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Adds an attribute to the XML element represented by this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param name a string, the so-called 'local part' of the attribute name;
   * that is, the attribute name without any namespace qualifier or prefix.
   *
   * @param value a string, the value assigned to the attribute.
   *
   * @param namespaceURI a string, the XML namespace URI of the attribute.
   *
   * @param prefix a string, the prefix for the XML namespace.
   *
   * Recall that in XML, the complete form of an attribute on an XML element
   * is the following:
   * <center>
   * <code>prefix:name='value'</code>
   * </center>
   * The <code>name</code> part is the name of the attribute, the
   * <code>'value'</code> part is the value assigned to the attribute (and
   * it is always a quoted string), and the <code>prefix</code> part is
   * an optional XML namespace prefix.  Internally in libSBML, this data
   * is stored in an XMLAttributes object associated with this XMLToken.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   *
   *
 * @note If an attribute with the same name and XML namespace URI already
 * exists on this XMLToken object, then the previous value will be replaced
 * with the new value provided to this method.
 *
 *
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int addAttr(string name, string value, string namespaceURI, string prefix) {
    int ret = libsbmlPINVOKE.XMLToken_addAttr__SWIG_0(swigCPtr, name, value, namespaceURI, prefix);
    return ret;
  }

  
/**
   * Adds an attribute to the XML element represented by this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param name a string, the so-called 'local part' of the attribute name;
   * that is, the attribute name without any namespace qualifier or prefix.
   *
   * @param value a string, the value assigned to the attribute.
   *
   * @param namespaceURI a string, the XML namespace URI of the attribute.
   *
   * @param prefix a string, the prefix for the XML namespace.
   *
   * Recall that in XML, the complete form of an attribute on an XML element
   * is the following:
   * <center>
   * <code>prefix:name='value'</code>
   * </center>
   * The <code>name</code> part is the name of the attribute, the
   * <code>'value'</code> part is the value assigned to the attribute (and
   * it is always a quoted string), and the <code>prefix</code> part is
   * an optional XML namespace prefix.  Internally in libSBML, this data
   * is stored in an XMLAttributes object associated with this XMLToken.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   *
   *
 * @note If an attribute with the same name and XML namespace URI already
 * exists on this XMLToken object, then the previous value will be replaced
 * with the new value provided to this method.
 *
 *
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int addAttr(string name, string value, string namespaceURI) {
    int ret = libsbmlPINVOKE.XMLToken_addAttr__SWIG_1(swigCPtr, name, value, namespaceURI);
    return ret;
  }

  
/**
   * Adds an attribute to the XML element represented by this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param name a string, the so-called 'local part' of the attribute name;
   * that is, the attribute name without any namespace qualifier or prefix.
   *
   * @param value a string, the value assigned to the attribute.
   *
   * @param namespaceURI a string, the XML namespace URI of the attribute.
   *
   * @param prefix a string, the prefix for the XML namespace.
   *
   * Recall that in XML, the complete form of an attribute on an XML element
   * is the following:
   * <center>
   * <code>prefix:name='value'</code>
   * </center>
   * The <code>name</code> part is the name of the attribute, the
   * <code>'value'</code> part is the value assigned to the attribute (and
   * it is always a quoted string), and the <code>prefix</code> part is
   * an optional XML namespace prefix.  Internally in libSBML, this data
   * is stored in an XMLAttributes object associated with this XMLToken.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   *
   *
 * @note If an attribute with the same name and XML namespace URI already
 * exists on this XMLToken object, then the previous value will be replaced
 * with the new value provided to this method.
 *
 *
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int addAttr(string name, string value) {
    int ret = libsbmlPINVOKE.XMLToken_addAttr__SWIG_2(swigCPtr, name, value);
    return ret;
  }

  
/**
   * Adds an attribute to the XML element represented by this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param triple an XMLTriple object defining the attribute, its value,
   * and optionally its XML namespace (if any is provided).
   *
   * @param value a string, the value assigned to the attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   *
   *
 * @note If an attribute with the same name and XML namespace URI already
 * exists on this XMLToken object, then the previous value will be replaced
 * with the new value provided to this method.
 *
 *
   */ public
 int addAttr(XMLTriple triple, string value) {
    int ret = libsbmlPINVOKE.XMLToken_addAttr__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple), value);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Removes the <em>n</em>th attribute from the XML element represented by
   * this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param n an integer the index of the resource to be deleted.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute on this
   * element at the given index @p n.
   *
   * @see getAttrIndex(XMLTriple triple) 
   * @see getAttrIndex(string name, string uri) 
   * @see getAttributesLength()
   */ public
 int removeAttr(int n) {
    int ret = libsbmlPINVOKE.XMLToken_removeAttr__SWIG_0(swigCPtr, n);
    return ret;
  }

  
/**
   * Removes an attribute from the XML element represented by this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param name   a string, the name of the attribute to be removed.
   * @param uri    a string, the XML namespace URI of the attribute to be removed.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute on this
   * element with the given @p name (and @p uri if specified).
   *
   * @see hasAttr(string name, string uri) 
   */ public
 int removeAttr(string name, string uri) {
    int ret = libsbmlPINVOKE.XMLToken_removeAttr__SWIG_1(swigCPtr, name, uri);
    return ret;
  }

  
/**
   * Removes an attribute from the XML element represented by this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param name   a string, the name of the attribute to be removed.
   * @param uri    a string, the XML namespace URI of the attribute to be removed.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute on this
   * element with the given @p name (and @p uri if specified).
   *
   * @see hasAttr(string name, string uri) 
   */ public
 int removeAttr(string name) {
    int ret = libsbmlPINVOKE.XMLToken_removeAttr__SWIG_2(swigCPtr, name);
    return ret;
  }

  
/**
   * Removes an attribute from the XML element represented by this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param triple an XMLTriple describing the attribute to be removed.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute on this
   * element matching the properties of the given @p triple.
   *
   * @see hasAttr(XMLTriple triple) 
   */ public
 int removeAttr(XMLTriple triple) {
    int ret = libsbmlPINVOKE.XMLToken_removeAttr__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Removes all attributes of this XMLToken object.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   */ public
 int clearAttributes() {
    int ret = libsbmlPINVOKE.XMLToken_clearAttributes(swigCPtr);
    return ret;
  }

  
/**
   * Returns the index of the attribute with the given name and namespace
   * URI.
   *
   * @param name a string, the name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   *
   * @return the index of an attribute with the given local name and
   * namespace URI, or <code>-1</code> if it is not present on this token.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int getAttrIndex(string name, string uri) {
    int ret = libsbmlPINVOKE.XMLToken_getAttrIndex__SWIG_0(swigCPtr, name, uri);
    return ret;
  }

  
/**
   * Returns the index of the attribute with the given name and namespace
   * URI.
   *
   * @param name a string, the name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   *
   * @return the index of an attribute with the given local name and
   * namespace URI, or <code>-1</code> if it is not present on this token.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int getAttrIndex(string name) {
    int ret = libsbmlPINVOKE.XMLToken_getAttrIndex__SWIG_1(swigCPtr, name);
    return ret;
  }

  
/**
   * Returns the index of the attribute defined by the given XMLTriple
   * object.
   *
   * @param triple the XMLTriple object that defines the attribute whose
   * index is being sought.
   *
   * @return the index of an attribute with the given XMLTriple object, or
   * <code>-1</code> if no such attribute is present on this token.
   */ public
 int getAttrIndex(XMLTriple triple) {
    int ret = libsbmlPINVOKE.XMLToken_getAttrIndex__SWIG_2(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the number of attributes on this XMLToken object.
   *
   * @return the number of attributes possessed by this token.
   *
   * @see hasAttr(@if java int@endif)
   */ public
 int getAttributesLength() {
    int ret = libsbmlPINVOKE.XMLToken_getAttributesLength(swigCPtr);
    return ret;
  }

  
/**
   * Returns the name of the <em>n</em>th attribute in this token's list of
   * attributes.
   *
   * @param index an integer, the position of the attribute whose name
   * is being sought.
   *
   * @return the name of the attribute located at position @p n in the list
   * of attributes possessed by this XMLToken object.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  XMLToken::hasAttr(@if java int@endif) can be used to test for an
 * attribute's existence explicitly, and XMLToken::getAttributesLength() can
 * be used to find out the number of attributes possessed by this token. 
   *
   * @see hasAttr(@if java int@endif)
   * @see getAttributesLength()
   */ public
 string getAttrName(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrName(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the prefix of the <em>n</em>th attribute in this token's list of
   * attributes.
   *
   * @param index an integer, the position of the attribute whose prefix is
   * being sought.
   *
   * @return the XML namespace prefix of the attribute located at position @p
   * n in the list of attributes possessed by this XMLToken object.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  XMLToken::hasAttr(@if java int@endif) can be used to test for an
 * attribute's existence explicitly, and XMLToken::getAttributesLength() can
 * be used to find out the number of attributes possessed by this token.
   *
   * @see hasAttr(@if java int@endif)
   * @see getAttributesLength()
   */ public
 string getAttrPrefix(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrPrefix(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the prefixed name of the <em>n</em>th attribute in this token's
   * list of attributes.
   *
   * In this context, <em>prefixed name</em> means the name of the attribute
   * prefixed with the XML namespace prefix assigned to the attribute.  This
   * will be a string of the form <code>prefix:name</code>.
   *
   * @param index an integer, the position of the attribute whose prefixed
   * name is being sought.
   *
   * @return the prefixed name of the attribute located at position @p
   * n in the list of attributes possessed by this XMLToken object.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  XMLToken::hasAttr(@if java int@endif) can be used to test for an
 * attribute's existence explicitly, and XMLToken::getAttributesLength() can
 * be used to find out the number of attributes possessed by this token.
   */ public
 string getAttrPrefixedName(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrPrefixedName(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the XML namespace URI of the <em>n</em>th attribute in this
   * token's list of attributes.
   *
   * @param index an integer, the position of the attribute whose namespace
   * URI is being sought.
   *
   * @return the XML namespace URI of the attribute located at position @p n
   * in the list of attributes possessed by this XMLToken object.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  XMLToken::hasAttr(@if java int@endif) can be used to test for an
 * attribute's existence explicitly, and XMLToken::getAttributesLength() can
 * be used to find out the number of attributes possessed by this token.
   */ public
 string getAttrURI(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrURI(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the value of the <em>n</em>th attribute in this token's list of
   * attributes.
   *
   * @param index an integer, the position of the attribute whose value is
   * required.
   *
   * @return the value of the attribute located at position @p n in the list
   * of attributes possessed by this XMLToken object.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  XMLToken::hasAttr(@if java int@endif) can be used to test for an
 * attribute's existence explicitly, and XMLToken::getAttributesLength() can
 * be used to find out the number of attributes possessed by this token.
   */ public
 string getAttrValue(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrValue__SWIG_0(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the value of the attribute with a given name and XML namespace URI.
   *
   * @param name a string, the name of the attribute whose value is being
   * sought.
   *
   * @param uri a string, the XML namespace URI of the attribute.
   *
   * @return The value of the attribute, as a string.
   *
   * @note If an attribute with the given @p name and @p uri does not exist
   * on this token object, this method will return an empty string.
   * XMLToken::hasAttr(@if java String, String@endif) can be used to test
   * explicitly for the presence of an attribute with a given name and
   * namespace.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 string getAttrValue(string name, string uri) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrValue__SWIG_1(swigCPtr, name, uri);
    return ret;
  }

  
/**
   * Returns the value of the attribute with a given name and XML namespace URI.
   *
   * @param name a string, the name of the attribute whose value is being
   * sought.
   *
   * @param uri a string, the XML namespace URI of the attribute.
   *
   * @return The value of the attribute, as a string.
   *
   * @note If an attribute with the given @p name and @p uri does not exist
   * on this token object, this method will return an empty string.
   * XMLToken::hasAttr(@if java String, String@endif) can be used to test
   * explicitly for the presence of an attribute with a given name and
   * namespace.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 string getAttrValue(string name) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrValue__SWIG_2(swigCPtr, name);
    return ret;
  }

  
/**
   * Returns the value of the attribute specified by a given XMLTriple object.
   *
   * @param triple an XMLTriple describing the attribute whose value is being
   * sought.
   *
   * @return The value of the attribute, as a string.
   *
   * @note If an attribute defined by the given @p triple does not exist on
   * this token object, this method will return an empty string.
   * XMLToken::hasAttr(@if java XMLTriple@endif) can be used to test
   * explicitly for the existence of an attribute with the properties of
   * a given triple.
   */ public
 string getAttrValue(XMLTriple triple) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrValue__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns @c true if an attribute with the given index exists.
   *
   * @param index an integer, the position of the attribute.
   *
   * @return @c true if this token object possesses an attribute with the
   * given index, @c false otherwise.
   */ public
 bool hasAttr(int index) {
    bool ret = libsbmlPINVOKE.XMLToken_hasAttr__SWIG_0(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns @c true if an attribute with a given name and namespace URI
   * exists.
   *
   * @param name a string, the name of the attribute being sought.
   *
   * @param uri a string, the XML namespace URI of the attribute being
   * sought.
   *
   * @return @c true if an attribute with the given local name and namespace
   * URI exists in the list of attributes on this token object, @c false
   * otherwise.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 bool hasAttr(string name, string uri) {
    bool ret = libsbmlPINVOKE.XMLToken_hasAttr__SWIG_1(swigCPtr, name, uri);
    return ret;
  }

  
/**
   * Returns @c true if an attribute with a given name and namespace URI
   * exists.
   *
   * @param name a string, the name of the attribute being sought.
   *
   * @param uri a string, the XML namespace URI of the attribute being
   * sought.
   *
   * @return @c true if an attribute with the given local name and namespace
   * URI exists in the list of attributes on this token object, @c false
   * otherwise.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 bool hasAttr(string name) {
    bool ret = libsbmlPINVOKE.XMLToken_hasAttr__SWIG_2(swigCPtr, name);
    return ret;
  }

  
/**
   * Returns @c true if an attribute defined by a given XMLTriple object
   * exists.
   *
   * @param triple an XMLTriple object describing the attribute being sought.
   *
   * @return @c true if an attribute matching the properties of the given
   * XMLTriple object exists in the list of attributes on this token, @c
   * false otherwise.
   */ public
 bool hasAttr(XMLTriple triple) {
    bool ret = libsbmlPINVOKE.XMLToken_hasAttr__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns @c true if this token has no attributes.
   *
   * @return @c true if the list of attributes on XMLToken object is empty,
   * @c false otherwise.
   */ public
 bool isAttributesEmpty() {
    bool ret = libsbmlPINVOKE.XMLToken_isAttributesEmpty(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML namespaces declared for this token.
   *
   * @return the XML namespace declarations for this XML element.
   */ public
 XMLNamespaces getNamespaces() {
    XMLNamespaces ret = new XMLNamespaces(libsbmlPINVOKE.XMLToken_getNamespaces(swigCPtr), false);
    return ret;
  }

  
/**
   * Sets the XML namespaces on this XML element.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param namespaces the XMLNamespaces object to be assigned to this XMLToken object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @note This function replaces any existing XMLNamespaces object on this
   * XMLToken object with the new one given by @p namespaces.
   */ public
 int setNamespaces(XMLNamespaces namespaces) {
    int ret = libsbmlPINVOKE.XMLToken_setNamespaces(swigCPtr, XMLNamespaces.getCPtr(namespaces));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Appends an XML namespace declaration to this token.
   *
   * The namespace added will be defined by the given XML namespace URI and
   * an optional prefix.  If this XMLToken object already possesses an XML
   * namespace declaration with the given @p prefix, then the existing XML
   * namespace URI will be overwritten by the new one given by @p uri.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param uri a string, the XML namespace URI for the namespace.
   * 
   * @param prefix a string, the namespace prefix to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int addNamespace(string uri, string prefix) {
    int ret = libsbmlPINVOKE.XMLToken_addNamespace__SWIG_0(swigCPtr, uri, prefix);
    return ret;
  }

  
/**
   * Appends an XML namespace declaration to this token.
   *
   * The namespace added will be defined by the given XML namespace URI and
   * an optional prefix.  If this XMLToken object already possesses an XML
   * namespace declaration with the given @p prefix, then the existing XML
   * namespace URI will be overwritten by the new one given by @p uri.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param uri a string, the XML namespace URI for the namespace.
   * 
   * @param prefix a string, the namespace prefix to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int addNamespace(string uri) {
    int ret = libsbmlPINVOKE.XMLToken_addNamespace__SWIG_1(swigCPtr, uri);
    return ret;
  }

  
/**
   * Removes the <em>n</em>th XML namespace declaration.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param index an integer, the position of the namespace to be removed.
   * The position in this context refers to the position of the namespace in
   * the XMLNamespaces object stored in this XMLToken object.  Callers can
   * use one of the <code>getNamespace___()</code> methods to find the index
   * number of a given namespace.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * @see getNamespaceIndex(@if java String uri@endif)
   * @see getNamespaceIndexByPrefix(@if java String prefix@endif)
   * @see getNamespacesLength()
   */ public
 int removeNamespace(int index) {
    int ret = libsbmlPINVOKE.XMLToken_removeNamespace__SWIG_0(swigCPtr, index);
    return ret;
  }

  
/**
   * Removes an XML namespace declaration having a given prefix.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param prefix a string, the prefix of the namespace to be removed.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   * is returned if there is no namespace with the given @p prefix on this
   * element.
   *
   * @see getNamespaceIndexByPrefix(@if java String prefix@endif)
   */ public
 int removeNamespace(string prefix) {
    int ret = libsbmlPINVOKE.XMLToken_removeNamespace__SWIG_1(swigCPtr, prefix);
    return ret;
  }

  
/**
   * Removes all XML namespace declarations from this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 * 
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int clearNamespaces() {
    int ret = libsbmlPINVOKE.XMLToken_clearNamespaces(swigCPtr);
    return ret;
  }

  
/**
   * Returns the index of an XML namespace declaration based on its URI.
   *
   * @param uri a string, the XML namespace URI of the sought-after namespace.
   *
   * @return the index of the given declaration, or <code>-1</code> if
   * no such namespace URI is present on this XMLToken object.
   */ public
 int getNamespaceIndex(string uri) {
    int ret = libsbmlPINVOKE.XMLToken_getNamespaceIndex(swigCPtr, uri);
    return ret;
  }

  
/**
   * Returns the index of an XML namespace declaration based on its prefix.
   *
   * @param prefix a string, the prefix of the sought-after XML namespace.
   *
   * @return the index of the given declaration, or <code>-1</code> if
   * no such namespace URI is present on this XMLToken object.
   */ public
 int getNamespaceIndexByPrefix(string prefix) {
    int ret = libsbmlPINVOKE.XMLToken_getNamespaceIndexByPrefix(swigCPtr, prefix);
    return ret;
  }

  
/**
   * Returns the number of XML namespaces declared on this token.
   *
   * @return the number of XML namespaces stored in the XMLNamespaces
   * object of this XMLToken object.
   */ public
 int getNamespacesLength() {
    int ret = libsbmlPINVOKE.XMLToken_getNamespacesLength(swigCPtr);
    return ret;
  }

  
/**
   * Returns the prefix of the <em>n</em>th XML namespace declaration.
   *
   * @param index an integer, position of the required prefix.
   *
   * @return the prefix of an XML namespace declaration in the XMLNamespaces
   * (by position).
   *
   * @note If @p index is out of range, this method will return an empty
   * string.  XMLToken::getNamespacesLength() can be used to find out how
   * many namespaces are defined on this XMLToken object.
   *
   * @see getNamespacesLength()
   */ public
 string getNamespacePrefix(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getNamespacePrefix__SWIG_0(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the prefix associated with a given XML namespace URI on this
   * token.
   *
   * @param uri a string, the URI of the namespace whose prefix is being
   * sought.
   *
   * @return the prefix of an XML namespace declaration on this XMLToken object.
   *
   * @note If there is no XML namespace with the given @p uri declared on
   * this XMLToken object, this method will return an empty string.
   */ public
 string getNamespacePrefix(string uri) {
    string ret = libsbmlPINVOKE.XMLToken_getNamespacePrefix__SWIG_1(swigCPtr, uri);
    return ret;
  }

  
/**
   * Returns the URI of the <em>n</em>th XML namespace declared on this token. 
   *
   * @param index an integer, the position of the sought-after XML namespace URI.
   *
   * @return the URI of the <em>n</em>th XML namespace stored in the
   * XMLNamespaces object in this XMLToken object.
   *
   * @note If @p index is out of range, this method will return an empty string.
   *
   * @see getNamespacesLength()
   */ public
 string getNamespaceURI(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getNamespaceURI__SWIG_0(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the URI of an XML namespace with a given prefix.
   *
   * @param prefix a string, the prefix of the sought-after XML namespace URI.
   *
   * @return the URI of an XML namespace declaration given its prefix.
   *
   * @note If there is no XML namespace with the given @p prefix stored in
   * the XMLNamespaces object of this XMLToken object, this method will
   * return an empty string.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 string getNamespaceURI(string prefix) {
    string ret = libsbmlPINVOKE.XMLToken_getNamespaceURI__SWIG_1(swigCPtr, prefix);
    return ret;
  }

  
/**
   * Returns the URI of an XML namespace with a given prefix.
   *
   * @param prefix a string, the prefix of the sought-after XML namespace URI.
   *
   * @return the URI of an XML namespace declaration given its prefix.
   *
   * @note If there is no XML namespace with the given @p prefix stored in
   * the XMLNamespaces object of this XMLToken object, this method will
   * return an empty string.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 string getNamespaceURI() {
    string ret = libsbmlPINVOKE.XMLToken_getNamespaceURI__SWIG_2(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if there are no namespaces declared on this token.
   *
   * @return @c true if the XMLNamespaces object stored in this XMLToken
   * token is empty, @c false otherwise.
   */ public
 bool isNamespacesEmpty() {
    bool ret = libsbmlPINVOKE.XMLToken_isNamespacesEmpty(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this token has an XML namespace with a given URI.
   *
   * @param uri a string, the URI of the XML namespace.
   *
   * @return @c true if an XML namespace with the given URI is contained in
   * the XMLNamespaces object of this XMLToken object, @c false otherwise.
   */ public
 bool hasNamespaceURI(string uri) {
    bool ret = libsbmlPINVOKE.XMLToken_hasNamespaceURI(swigCPtr, uri);
    return ret;
  }

  
/**
   * Returns @c true if this token has an XML namespace with a given prefix.
   *
   * @param prefix a string, the prefix for the XML namespace.
   *
   * @return @c true if an XML Namespace with the given URI is contained in the
   * XMLNamespaces of this XMLToken, @c false otherwise.
   */ public
 bool hasNamespacePrefix(string prefix) {
    bool ret = libsbmlPINVOKE.XMLToken_hasNamespacePrefix(swigCPtr, prefix);
    return ret;
  }

  
/**
   * Returns @c true if this token has an XML namespace with a given prefix
   * and URI combination.
   *
   * @param uri a string, the URI for the namespace.
   * @param prefix a string, the prefix for the namespace.
   *
   * @return @c true if an XML namespace with the given URI/prefix pair is
   * contained in the XMLNamespaces object of this XMLToken object, @c false
   * otherwise.
   */ public
 bool hasNamespaceNS(string uri, string prefix) {
    bool ret = libsbmlPINVOKE.XMLToken_hasNamespaceNS(swigCPtr, uri, prefix);
    return ret;
  }

  
/**
   * Sets the name, namespace prefix and namespace URI of this token.
   *
   *
 * 
 * This operation only makes sense for XML start elements.  This
 * method will return @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink if this XMLToken object is not an XML start
 * element.
 *
 *
   *
   * @param triple the new XMLTriple to use for this XMLToken object.  If
   * this XMLToken already had an XMLTriple object stored within it, that
   * object will be replaced.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   */ public
 int setTriple(XMLTriple triple) {
    int ret = libsbmlPINVOKE.XMLToken_setTriple(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the (unqualified) name of token.
   *
   * @return the (unqualified) name of token.
   */ public
 string getName() {
    string ret = libsbmlPINVOKE.XMLToken_getName(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML namespace prefix of token.
   *
   * @return the XML namespace prefix of token.
   *
   * @note If no XML namespace prefix has been assigned to this token, this
   * method will return an empty string.
   */ public
 string getPrefix() {
    string ret = libsbmlPINVOKE.XMLToken_getPrefix(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML namespace URI of token.
   *
   * @return the XML namespace URI of token.
   */ public
 string getURI() {
    string ret = libsbmlPINVOKE.XMLToken_getURI(swigCPtr);
    return ret;
  }

  
/**
   * Returns the character text of token.
   *
   * @return the characters of this XML token.  If this token is not a
   * text token (i.e., it's an XML element and not character content),
   * then this will return an empty string.
   *
   * @see isText()
   * @see isElement()
   */ public
 string getCharacters() {
    string ret = libsbmlPINVOKE.XMLToken_getCharacters(swigCPtr);
    return ret;
  }

  
/**
  * Sets the characters for this XMLToken
  *
  * This method only makes sense for XMLToken objects that contains text.
  * If this method is called on a token that represents an XML start or end
  * tag, it will return the code @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink.
  *
  * @param chars string, characters to append to the text of this token.
  *
  *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
  * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
  *
  * @see isText()
  * @see isElement()
  */ public
 int setCharacters(string chars) {
    int ret = libsbmlPINVOKE.XMLToken_setCharacters(swigCPtr, chars);
    return ret;
  }

  
/**
   * Appends characters to the text content of token.
   *
   * This method only makes sense for XMLToken objects that contains text.
   * If this method is called on a token that represents an XML start or end
   * tag, it will return the code @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink.
   *
   * @param chars string, characters to append to the text of this token.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see isText()
   * @see isElement()
   */ public
 int append(string chars) {
    int ret = libsbmlPINVOKE.XMLToken_append(swigCPtr, chars);
    return ret;
  }

  
/**
   * Returns the column number at which this token occurs in the input.
   *
   * @return the column at which this XMLToken occurred.
   */ public
 long getColumn() { return (long)libsbmlPINVOKE.XMLToken_getColumn(swigCPtr); }

  
/**
   * Returns the line number at which this token occurs in the input.
   *
   * @return the line at which this XMLToken occurred.
   */ public
 long getLine() { return (long)libsbmlPINVOKE.XMLToken_getLine(swigCPtr); }

  
/**
   * Returns @c true if this token represents an XML element.
   *
   * This generic predicate returns @c true if the element is either a start
   * or end tag, and @c false if it's a text object.  The related methods
   * XMLToken:isStart(), XMLToken::isEnd() and XMLToken::isText() are more
   * specific predicates.
   *
   * @return @c true if this XMLToken object represents an XML element, @c
   * false otherwise.
   *
   * @see isStart()
   * @see isEnd()
   * @see isText()
   */ public
 bool isElement() {
    bool ret = libsbmlPINVOKE.XMLToken_isElement(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this token represents an XML end element.
   *
   * @return @c true if this XMLToken object represents an XML end element,
   * @c false otherwise.
   *
   * @see isStart()
   * @see isElement()
   * @see isText()
   */ public
 bool isEnd() {
    bool ret = libsbmlPINVOKE.XMLToken_isEnd(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this token represents an XML end element for a
   * particular start element.
   *
   * @param element XMLToken, the element with which the current object
   * should be compared to determined whether the current object is a
   * start element for the given one.
   *
   * @return @c true if this XMLToken object represents an XML end tag for
   * the start tag given by @p element, @c false otherwise.
   *
   * @see isElement()
   * @see isStart()
   * @see isEnd()
   * @see isText()
   */ public
 bool isEndFor(XMLToken element) {
    bool ret = libsbmlPINVOKE.XMLToken_isEndFor(swigCPtr, XMLToken.getCPtr(element));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns @c true if this token is an end of file marker.
   *
   * @return @c true if this XMLToken object represents the end of the input,
   * @c false otherwise.
   *
   * @see setEOF()
   */ public
 bool isEOF() {
    bool ret = libsbmlPINVOKE.XMLToken_isEOF(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this token represents an XML start element.
   *
   * @return @c true if this XMLToken is an XML start element, @c false otherwise.
   *
   * @see isElement()
   * @see isEnd()
   * @see isText()
   */ public
 bool isStart() {
    bool ret = libsbmlPINVOKE.XMLToken_isStart(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this token represents an XML text element.
   *
   * @return @c true if this XMLToken is an XML text element, @c false otherwise.
   *
   * @see isElement()
   * @see isStart()
   * @see isEnd()
   */ public
 bool isText() {
    bool ret = libsbmlPINVOKE.XMLToken_isText(swigCPtr);
    return ret;
  }

  
/**
   * Declares that this token represents an XML element end tag.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see isStart()
   * @see isEnd()
   */ public
 int setEnd() {
    int ret = libsbmlPINVOKE.XMLToken_setEnd(swigCPtr);
    return ret;
  }

  
/**
   * Declares that this token is an end-of-file/input marker.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see isEOF()
   */ public
 int setEOF() {
    int ret = libsbmlPINVOKE.XMLToken_setEOF(swigCPtr);
    return ret;
  }

  
/**
   * Declares that this token no longer represents an XML start/end element.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetEnd() {
    int ret = libsbmlPINVOKE.XMLToken_unsetEnd(swigCPtr);
    return ret;
  }

  
/**
   * Prints a string representation of the underlying token stream.
   *
   * This method is intended for debugging purposes.
   *
   * @return a text string representing this XMLToken object.
   */ public
 string toString() {
    string ret = libsbmlPINVOKE.XMLToken_toString(swigCPtr);
    return ret;
  }

}

}
