/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  A MIRIAM-compliant controlled vocabulary term.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled vocabulary
 * terms and database identifiers that define and describe biological and
 * biochemical entities, and (b) describing the creator of a model and the
 * model's modification history.  This SBML format is a concrete syntax that
 * conforms to the guidelines of MIRIAM (<a target='_blank'
 * href='http://www.nature.com/nbt/journal/v23/n12/abs/nbt1156.html'>'Minimum
 * Information Requested in the Annotation of biochemical Models'</a>,
 * <i>Nature Biotechnology</i>, vol. 23, no. 12, Dec. 2005).  The format uses
 * a subset of W3C RDF (<a target='_blank'
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  In order
 * to help application developers work with annotations in this format,
 * libSBML provides several helper classes that provide higher-level
 * interfaces to the data elements; these classes include {@link CVTerm},
 * {@link ModelCreator}, {@link ModelHistory}, {@link RDFAnnotationParser}, and {@link Date}.
 <p>
 * <h2>Components of an SBML annotation</h2>
 <p>
 * The SBML annotation format consists of RDF-based content placed inside an
 * <code>&lt;annotation&gt;</code> element attached to an SBML component such
 * as {@link Species}, {@link Compartment}, etc.  A small change was introduced in SBML
 * Level&nbsp;2 Version&nbsp;5 and SBML Level&nbsp;3 Version&nbsp;2 to permit
 * nested annotations: lower Versions of the SBML specifications did not
 * explicitly allow this.  We first describe the different parts of SBML
 * annotations in XML form for SBML Level&nbsp;2 below Version&nbsp;5 and
 * SBML Level&nbsp;3 below Version&nbsp;2:
 <p>
 <pre class='fragment'>
 &lt;<span style='background-color: #bbb'>SBML_ELEMENT</span> <span style='background-color: #d0eed0'>+++</span> metaid=&quot;<span style='border-bottom: 1px solid black'>meta id</span>&quot; <span style='background-color: #d0eed0'>+++</span>&gt;
   <span style='background-color: #d0eed0'>+++</span>
   &lt;annotation&gt;
     <span style='background-color: #d0eed0'>+++</span>
     &lt;rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
              xmlns:dcterm='http://purl.org/dc/terms/'
              xmlns:vcard='http://www.w3.org/2001/vcard-rdf/3.0#'
              xmlns:bqbiol='http://biomodels.net/biology-qualifiers/'
              xmlns:bqmodel='http://biomodels.net/model-qualifiers/' &gt;
       &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
         <span style='background-color: #e0e0e0; border-bottom: 2px dotted #888'>HISTORY</span>
         &lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
           &lt;rdf:Bag&gt;
             &lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>URI</span>&quot; /&gt;
             <span style='background-color: #edd'>...</span>
           &lt;/rdf:Bag&gt;
         &lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
         <span style='background-color: #edd'>...</span>
       &lt;/rdf:Description&gt;
       <span style='background-color: #d0eed0'>+++</span>
     &lt;/rdf:RDF&gt;
     <span style='background-color: #d0eed0'>+++</span>
   &lt;/annotation&gt;
   <span style='background-color: #d0eed0'>+++</span>
 &lt;/<span style='background-color: #bbb'>SBML_ELEMENT</span>&gt;
 </pre>
 <p>
 * In the template above, the placeholder
 * <span class='code' style='background-color: #bbb'>SBML_ELEMENT</span> stands for
 * the XML tag name of an SBML model component (e.g., <code>model</code>,
 * <code>reaction</code>, etc.) and the placeholder 
 * <span class='code' style='border-bottom: 1px solid black'>meta id</span>
 * stands for the element's meta identifier, which is a field available
 * on all SBML components derived from the {@link SBase} base object class.
 * The <span style='border-bottom: 2px dotted #888'>dotted</span>
 * portions are optional, the symbol
 * <span class='code' style='background-color: #d0eed0'>+++</span> is a placeholder
 * for either no content or valid XML content that is not defined by
 * this annotation scheme, and the ellipses
 * <span class='code' style='background-color: #edd'>...</span>
 * are placeholders for zero or more elements of the same form as the
 * immediately preceding element.  The optional content
 * <span class='code' style='background-color: #e0e0e0; border-bottom: 2px dotted #888'>HISTORY</span>
 * is a creation and modification history; in libSBML, this is stored
 * using {@link ModelHistory} objects.
 <p>
 * The placeholder <span class='code' style='background-color:
 * #bbb'>RELATION_ELEMENT</span> refers to a BioModels.net qualifier element
 * name.  This is an element in either the XML namespace
 * <code>'http://biomodels.net/model-qualifiers'</code> (for model
 * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code> (for
 * biological qualifier).  Note that these namespace URIs are only labels,
 * and not actual Web locations, which means you cannot visit an address such
 * as <code>'http://biomodels.net/model-qualifiers'</code> in your browser or
 * try to have your application access it.  
 <p>
 * The <span class='code' style='background-color: #d0d0ee'>URI</span> is a
 * required data value that uniquely identifies a resource and data within
 * that resource to which the annotation refers.  Again, being URIs, these do
 * not refer to physical Web locations; nevertheless, applications will often
 * want a means of finding the resource to which a given <span class='code'
 * style='background-color: #d0d0ee'>URI</span> refers.  Providing the
 * facilities for this task is the purpose of MIRIAM Resources, described in
 * detail online at <a target='_blank'
 * href='http://biomodels.net/miriam'>http://biomodels.net/miriam</a>) and
 * also in the paper <a target='_blank'
 * href='http://www.biomedcentral.com/1752-0509/1/58'>'MIRIAM Resources: tools to generate and
 * resolve robust cross-references in Systems Biology'</a>, <i>BMC Systems
 * Biology</i>, 58(1), 2007.
 <p>
 * Finally, the following is the same template as above, but this time
 * showing the nested content permitted by the most recent SBML
 * specifications (SBML Level&nbsp;2 Version&nbsp;5 and Level&nbsp;3
 * Version&nbsp;2):
 <pre class='fragment'>
 &lt;<span style='background-color: #bbb'>SBML_ELEMENT</span> <span style='background-color: #d0eed0'>+++</span> metaid=&quot;<span style='border-bottom: 1px solid black'>meta id</span>&quot; <span style='background-color: #d0eed0'>+++</span>&gt;
   <span style='background-color: #d0eed0'>+++</span>
   &lt;annotation&gt;
     <span style='background-color: #d0eed0'>+++</span>
     &lt;rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
              xmlns:dcterm='http://purl.org/dc/terms/'
              xmlns:vcard='http://www.w3.org/2001/vcard-rdf/3.0#'
              xmlns:bqbiol='http://biomodels.net/biology-qualifiers/'
              xmlns:bqmodel='http://biomodels.net/model-qualifiers/' &gt;
       &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
         <span style='background-color: #e0e0e0; border-bottom: 2px dotted #888'>HISTORY</span>
         &lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
           &lt;rdf:Bag&gt;
             &lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>URI</span>&quot; /&gt;
             <span style='background-color: #fef'>NESTED_CONTENT</span>
             <span style='background-color: #edd'>...</span>
           &lt;/rdf:Bag&gt;
         &lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
         <span style='background-color: #edd'>...</span>
       &lt;/rdf:Description&gt;
       <span style='background-color: #d0eed0'>+++</span>
     &lt;/rdf:RDF&gt;
     <span style='background-color: #d0eed0'>+++</span>
   &lt;/annotation&gt;
   <span style='background-color: #d0eed0'>+++</span>
 &lt;/<span style='background-color: #bbb'>SBML_ELEMENT</span>&gt;
 </pre>
 <p>
 * The placeholder
 * <span class='code' style='background-color: #fef'>NESTED_CONTENT</span>
 * refers to other optional RDF elements such as
 * <code>'bqbiol:isDescribedBy'</code> that describe a clarification or
 * another annotation about the
 * <span class='code' style='background-color: #bbb'>RELATION_ELEMENT</span>
 * in which it appears.  Nested content allows one to, for example, describe
 * protein modifications on species, or to add evidence codes for an
 * annotation.  Nested content relates to its containing
 * <span class='code' style='background-color: #bbb'>RELATION_ELEMENT</span>,
 * not the other way around.  It qualifies it, but does not change its
 * meaning.  As such, ignoring a
 * <span class='code' style='background-color: #fef'>NESTED_CONTENT</span>
 * does not affect the information provided by the containing
 * <span class='code' style='background-color: #bbb'>RELATION_ELEMENT</span>.
 <p>
 * For more information about SBML annotations in general, please refer to
 * Section&nbsp;6 in the SBML Level&nbsp;2 (Versions 2&ndash;4) or
 * Level&nbsp;3 specification documents.
 <p>
 * <h2>The parts of a {@link CVTerm}</h2>
 <p>
 * Annotations that refer to controlled vocabularies are managed in libSBML
 * using {@link CVTerm} objects.  The relation-resource pairs discussed in the
 * previous section are the 'controlled vocabulary' terms that {@link CVTerm} is
 * designed to store and manipulate.  A set of RDF-based annotations attached
 * to a given SBML <code>&lt;annotation&gt;</code> element are read by
 * {@link RDFAnnotationParser} and converted into a list of these {@link CVTerm} objects.
 * Each {@link CVTerm} object instance stores the following components of an
 * annotation:
 <p>
 * <ul>
 <p>
 * <li>The <em>qualifier</em>, which can be a BioModels.net 'biological
 * qualifier', a BioModels.net 'model qualifier', or an unknown qualifier
 * (as far as the {@link CVTerm} class is concerned).  Qualifiers are used in
 * MIRIAM to indicate the nature of the relationship between the object
 * being annotated and the resource.  In {@link CVTerm}, the qualifiers can be
 * manipulated using the methods {@link CVTerm#getQualifierType()},
 * {@link CVTerm#setQualifierType(int)}, and related methods.
 <p>
 * <li>The <em>resource</em>, represented by a URI (which, we must remind
 * developers, is not the same as a URL).  In the {@link CVTerm} class, the
 * resource component can be manipulated using the methods
 * {@link CVTerm#addResource(String)} and
 * {@link CVTerm#removeResource(String)}.
 <p>
 * </ul>
 <p>
 * Note that a {@link CVTerm} contains a single qualifier, but possibly more than
 * one resource.  This corresponds to the possibility of an annotation that
 * points to multiple resources, all of which are qualified by the same
 * BioModels.net qualifier.  The {@link CVTerm} object class supports this by
 * supporting a list of resources.
 <p>
 * Detailed explanations of the qualifiers defined by BioModels.net can be
 * found at <a target='_blank'
 * href='http://co.mbine.org/standards/qualifiers'>http://co.mbine.org/standards/qualifiers</a>.
 */

public class CVTerm {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected CVTerm(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(CVTerm obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (CVTerm obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_CVTerm(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for CVTerm.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((CVTerm)(sb));
  }

  /**
   * Returns a hashcode for this CVTerm object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
/**
   * Creates an empty {@link CVTerm}, optionally with the given
   * qualifier <code>type</code>.
   <p>
   * <p>
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled
 * vocabulary terms and database identifiers that define and describe
 * biological and other entities, and (b) describing the creator of a
 * model and the model's modification history.  The annotation content is
 * stored in <code>&lt;annotation&gt;</code> elements attached to
 * individual SBML elements.  The format for storing the content inside
 * SBML <code>&lt;annotation&gt;</code> elements is a subset of W3C RDF
 * (<a target='_blank' href='http://www.w3.org/RDF/'>Resource Description
 * Format</a>) expressed in XML.  The {@link CVTerm} class provides a programming
 * interface for working directly with controlled vocabulary term ('CV
 * term') objects without having to deal directly with the XML form.
 * When libSBML reads in an SBML model containing RDF annotations, it
 * parses those annotations into a list of {@link CVTerm} objects, and when
 * writing a model, it parses the {@link CVTerm} objects back into the
 * appropriate SBML <code>&lt;annotation&gt;</code> structure. 
   <p>
   * This method creates an empty {@link CVTerm} object.  The possible qualifier
   * types usable as values of <code>type</code> are {@link libsbmlConstants#MODEL_QUALIFIER MODEL_QUALIFIER} and {@link libsbmlConstants#BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER}.  If an explicit value for <code>type</code> is not given, this
   * method defaults to using {@link libsbmlConstants#UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER}.  The qualifier
   * type can be set later using the
   * {@link CVTerm#setQualifierType(int)} method.
   <p>
   * Different BioModels.net qualifier elements encode different types of
   * relationships.  Please refer to the SBML specification or the <a
   * target='_blank' href='http://co.mbine.org/standards/qualifiers/'>BioModels.net
   * qualifiers web page</a> for an explanation of the meaning of these
   * different qualifiers.
   <p>
   * @param type a qualifier type.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 CVTerm(int type) {
    this(libsbmlJNI.new_CVTerm__SWIG_0(type), true);
  }

  
/**
   * Creates an empty {@link CVTerm}, optionally with the given
   * qualifier <code>type</code>.
   <p>
   * <p>
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled
 * vocabulary terms and database identifiers that define and describe
 * biological and other entities, and (b) describing the creator of a
 * model and the model's modification history.  The annotation content is
 * stored in <code>&lt;annotation&gt;</code> elements attached to
 * individual SBML elements.  The format for storing the content inside
 * SBML <code>&lt;annotation&gt;</code> elements is a subset of W3C RDF
 * (<a target='_blank' href='http://www.w3.org/RDF/'>Resource Description
 * Format</a>) expressed in XML.  The {@link CVTerm} class provides a programming
 * interface for working directly with controlled vocabulary term ('CV
 * term') objects without having to deal directly with the XML form.
 * When libSBML reads in an SBML model containing RDF annotations, it
 * parses those annotations into a list of {@link CVTerm} objects, and when
 * writing a model, it parses the {@link CVTerm} objects back into the
 * appropriate SBML <code>&lt;annotation&gt;</code> structure. 
   <p>
   * This method creates an empty {@link CVTerm} object.  The possible qualifier
   * types usable as values of <code>type</code> are {@link libsbmlConstants#MODEL_QUALIFIER MODEL_QUALIFIER} and {@link libsbmlConstants#BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER}.  If an explicit value for <code>type</code> is not given, this
   * method defaults to using {@link libsbmlConstants#UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER}.  The qualifier
   * type can be set later using the
   * {@link CVTerm#setQualifierType(int)} method.
   <p>
   * Different BioModels.net qualifier elements encode different types of
   * relationships.  Please refer to the SBML specification or the <a
   * target='_blank' href='http://co.mbine.org/standards/qualifiers/'>BioModels.net
   * qualifiers web page</a> for an explanation of the meaning of these
   * different qualifiers.
   <p>
   * @param type a qualifier type.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 CVTerm() {
    this(libsbmlJNI.new_CVTerm__SWIG_1(), true);
  }

  
/**
   * Creates a new {@link CVTerm} from the given {@link XMLNode}.
   <p>
   * <p>
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled
 * vocabulary terms and database identifiers that define and describe
 * biological and other entities, and (b) describing the creator of a
 * model and the model's modification history.  The annotation content is
 * stored in <code>&lt;annotation&gt;</code> elements attached to
 * individual SBML elements.  The format for storing the content inside
 * SBML <code>&lt;annotation&gt;</code> elements is a subset of W3C RDF
 * (<a target='_blank' href='http://www.w3.org/RDF/'>Resource Description
 * Format</a>) expressed in XML.  The {@link CVTerm} class provides a programming
 * interface for working directly with controlled vocabulary term ('CV
 * term') objects without having to deal directly with the XML form.
 * When libSBML reads in an SBML model containing RDF annotations, it
 * parses those annotations into a list of {@link CVTerm} objects, and when
 * writing a model, it parses the {@link CVTerm} objects back into the
 * appropriate SBML <code>&lt;annotation&gt;</code> structure.
   <p>
   * This method creates a {@link CVTerm} object from the given {@link XMLNode} object 
   * <code>node</code>.  {@link XMLNode} is libSBML's representation of a node in an XML tree of
   * elements, and each such element can be placed in a namespace.  This
   * constructor looks for the element to be in the XML namespaces
   * <code>'http://biomodels.net/model-qualifiers'</code> (for
   * model qualifiers) and
   * <code>'http://biomodels.net/biology-qualifiers'</code> (for
   * biological qualifier), and if they are, creates {@link CVTerm} objects for
   * the result.
   <p>
   * @param node an XMLNode representing a {@link CVTerm}.
   <p>
   * @note This method assumes that the given {@link XMLNode} object <code>node</code> is of
   * the correct structural form.
   */ public
 CVTerm(XMLNode node) {
    this(libsbmlJNI.new_CVTerm__SWIG_2(XMLNode.getCPtr(node), node), true);
  }

  
/**
   * Copy constructor; creates a copy of a {@link CVTerm} object.
   <p>
   * @param orig the {@link CVTerm} instance to copy.
   */ public
 CVTerm(CVTerm orig) {
    this(libsbmlJNI.new_CVTerm__SWIG_3(CVTerm.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link CVTerm} object.
   <p>
   * @return the (deep) copy of this {@link CVTerm} object.
   */ public
 CVTerm cloneObject() {
    long cPtr = libsbmlJNI.CVTerm_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new CVTerm(cPtr, true);
  }

  
/**
   * Returns the qualifier type of this {@link CVTerm} object.
   <p>
   * <p>
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the {@link SBase} base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
   <p>
   * The placeholder <span class='code' style='background-color: #bbb'>
   * RELATION_ELEMENT</span> refers to a BioModels.net qualifier
   * element name.  This is an element in either the XML namespace
   * <code>'http://biomodels.net/model-qualifiers'</code> (for model
   * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code>
   * (for biological qualifier).  The present method returns a code
   * identifying which one of these two relationship namespaces is being
   * used; any other qualifier in libSBML is considered unknown (as far as
   * the {@link CVTerm} class is concerned).  Consequently, this method will return
   * one of the following values:
   <p>
   * <ul>
   * <li> {@link libsbmlConstants#MODEL_QUALIFIER MODEL_QUALIFIER}
   * <li> {@link libsbmlConstants#BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER}
   * <li> {@link libsbmlConstants#UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER}
   *
   * </ul> <p>
   * The specific relationship of this {@link CVTerm} to the enclosing SBML object
   * can be determined using the {@link CVTerm} methods such as
   * {@link CVTerm#getModelQualifierType()} and
   * {@link CVTerm#getBiologicalQualifierType()}.  Callers will typically want to
   * use the present method to find out which one of the <em>other</em> two
   * methods to call to find out the specific relationship.
   <p>
   * @return the qualifier type
   * of this object or {@link libsbmlConstants#UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER}
   * (the default).
   <p>
   * @see #getResources()
   * @see #getModelQualifierType()
   * @see #getBiologicalQualifierType()
   */ public
 int getQualifierType() {
    return libsbmlJNI.CVTerm_getQualifierType__SWIG_0(swigCPtr, this);
  }

  
/**
   * Returns the model qualifier type of this {@link CVTerm} object.
   <p>
   * <p>
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the {@link SBase} base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
   <p>
   * The placeholder <span class='code' style='background-color: #bbb'>
   * RELATION_ELEMENT</span> refers to a BioModels.net qualifier
   * element name.  This is an element in either the XML namespace
   * <code>'http://biomodels.net/model-qualifiers'</code> (for model
   * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code>
   * (for biological qualifier).  Callers will typically use
   * {@link CVTerm#getQualifierType()} to find out the type of qualifier relevant to this
   * particular {@link CVTerm} object, then if it is a <em>model</em> qualifier, use the
   * present method to determine the specific qualifier.
   <p>
   * Annotations with model qualifiers express a relationship between an
   * annotation resource and the <em>modeling concept</em> represented by a
   * given object in the model.  The diagram below illustrates the
   * relationship in this case:
   <p>
   * <center class='image'><img src='model-qualifiers.png'></center>
   * 
   <p>
   * <br> The set of known model qualifiers is, at the time of this libSBML
   * release, the following:
   <p>
   * <ul>
   * <li> {@link libsbmlConstants#BQM_IS BQM_IS}
   * <li> {@link libsbmlConstants#BQM_IS_DESCRIBED_BY BQM_IS_DESCRIBED_BY}
   * <li> {@link libsbmlConstants#BQM_IS_DERIVED_FROM BQM_IS_DERIVED_FROM}
   * <li> {@link libsbmlConstants#BQM_IS_INSTANCE_OF BQM_IS_INSTANCE_OF}
   * <li> {@link libsbmlConstants#BQM_HAS_INSTANCE BQM_HAS_INSTANCE}
   *
   * </ul> <p>
   * Any other BioModels.net qualifier found in the model is considered
   * unknown by libSBML and reported as
   * {@link libsbmlConstants#BQM_UNKNOWN BQM_UNKNOWN}.
   <p>
   * @return the model qualifier type
   * of this object or {@link libsbmlConstants#BQM_UNKNOWN BQM_UNKNOWN}
   * (the default).
   */ public
 int getModelQualifierType() {
    return libsbmlJNI.CVTerm_getModelQualifierType__SWIG_0(swigCPtr, this);
  }

  
/**
   * Returns the biological qualifier type of this {@link CVTerm} object.
   <p>
   * <p>
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the {@link SBase} base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
   <p>
   * The placeholder <span class='code' style='background-color: #bbb'>
   * RELATION_ELEMENT</span> refers to a BioModels.net qualifier element
   * name.  This is an element in either the XML namespace
   * <code>'http://biomodels.net/model-qualifiers'</code> (for model
   * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code>
   * (for biological qualifier).  Callers will typically use
   * {@link CVTerm#getQualifierType()} to find out the type of qualifier relevant to
   * this particular {@link CVTerm} object, then if it is a <em>biological</em> qualifier,
   * use the present method to determine the specific qualifier.
   <p>
   * Annotations with biological qualifiers express a relationship between an
   * annotation resource and the <em>biological concept</em> represented by a
   * given object in the model.    The diagram
   * below illustrates the relationship in this case:
   <p>
   * <center class='image'><img src='biology-qualifiers.png'></center>
   * 
   <p>
   * <br> The set of known biological qualifiers is, at the time of this
   * libSBML release, the following:
   <p>
   * <ul>
   * <li> {@link libsbmlConstants#BQB_IS BQB_IS}
   * <li> {@link libsbmlConstants#BQB_HAS_PART BQB_HAS_PART}
   * <li> {@link libsbmlConstants#BQB_IS_PART_OF BQB_IS_PART_OF}
   * <li> {@link libsbmlConstants#BQB_IS_VERSION_OF BQB_IS_VERSION_OF}
   * <li> {@link libsbmlConstants#BQB_HAS_VERSION BQB_HAS_VERSION}
   * <li> {@link libsbmlConstants#BQB_IS_HOMOLOG_TO BQB_IS_HOMOLOG_TO}
   * <li> {@link libsbmlConstants#BQB_IS_DESCRIBED_BY BQB_IS_DESCRIBED_BY}
   * <li> {@link libsbmlConstants#BQB_IS_ENCODED_BY BQB_IS_ENCODED_BY}
   * <li> {@link libsbmlConstants#BQB_ENCODES BQB_ENCODES}
   * <li> {@link libsbmlConstants#BQB_OCCURS_IN BQB_OCCURS_IN}
   * <li> {@link libsbmlConstants#BQB_HAS_PROPERTY BQB_HAS_PROPERTY}
   * <li> {@link libsbmlConstants#BQB_IS_PROPERTY_OF BQB_IS_PROPERTY_OF}
   * <li> {@link libsbmlConstants#BQB_HAS_TAXON BQB_HAS_TAXON}
   *
   * </ul> <p>
   * Any other BioModels.net qualifier found in the model is considered
   * unknown by libSBML and reported as
   * {@link libsbmlConstants#BQB_UNKNOWN BQB_UNKNOWN}.
   <p>
   * @return the biology qualifier type
   * of this object or {@link libsbmlConstants#BQB_UNKNOWN BQB_UNKNOWN}
   * (the default).
   */ public
 int getBiologicalQualifierType() {
    return libsbmlJNI.CVTerm_getBiologicalQualifierType__SWIG_0(swigCPtr, this);
  }

  
/**
   * Returns the resource references for this {@link CVTerm} object.
   <p>
   * <p>
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the {@link SBase} base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
   <p>
   * The <span class='code' style='background-color: #d0d0ee'>resource
   * URI</span> values shown in the template above are stored internally in
   * {@link CVTerm} objects using an {@link XMLAttributes} object.  Each attribute stored
   * inside the {@link XMLAttributes} will have the same name (specifically,
   * &quot;<code>rdf:resource</code>&quot;) but a different value, and the
   * value will be a <span class='code' style='background-color: #d0d0ee'>
   * resource URI</span> shown in the XML template above.
   <p>
   * A valid {@link CVTerm} entity must always have at least one resource and
   * a value for the relationship qualifier.
   <p>
   * @return the {@link XMLAttributes} that store the resources of this {@link CVTerm}.
   <p>
   * @see #getQualifierType()
   * @see #addResource(String resource)
   * @see #getResourceURI(long n)
   */ public
 XMLAttributes getResources() {
    long cPtr = libsbmlJNI.CVTerm_getResources__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLAttributes(cPtr, false);
  }

  
/**
   * Returns the number of resources for this {@link CVTerm} object.
   <p>
   * <p>
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the {@link SBase} base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
   <p>
   * The fragment above illustrates that there can be more than one
   * resource referenced by a given relationship annotation (i.e., the
   * <span class='code' style='background-color: #d0d0ee'>resource
   * URI</span> values associated with a particular <span class='code'
   * style='background-color: #bbb'>RELATION_ELEMENT</span>).  The present
   * method returns a count of the resources stored in this {@link CVTerm} object.
   <p>
   * @return the number of resources in the set of {@link XMLAttributes}
   * of this {@link CVTerm}.
   <p>
   * @see #getResources()
   * @see #getResourceURI(long n)
   */ public
 long getNumResources() {
    return libsbmlJNI.CVTerm_getNumResources__SWIG_0(swigCPtr, this);
  }

  
/**
   * Returns the value of the <em>n</em>th resource for this {@link CVTerm} object.
   <p>
   * <p>
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the {@link SBase} base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
   <p>
   * The fragment above illustrates that there can be more than one resource
   * referenced by a given relationship annotation (i.e., the <span
   * class='code' style='background-color: #d0d0ee'>resource URI</span>
   * values associated with a particular <span class='code'
   * style='background-color: #bbb'>RELATION_ELEMENT</span>).  LibSBML stores
   * all resource URIs in a single {@link CVTerm} object for a given relationship.
   * Callers can use {@link CVTerm#getNumResources()} to find out how many resources
   * are stored in this {@link CVTerm} object, then call this method to retrieve the
   * <em>n</em>th resource URI.
   <p>
   * @param n the index of the resource to query.
   <p>
   * @return string representing the value of the nth resource
   * in the set of {@link XMLAttributes} of this {@link CVTerm}.
   <p>
   * @see #getNumResources()
   * @see #getQualifierType()
   */ public
 String getResourceURI(long n) {
    return libsbmlJNI.CVTerm_getResourceURI__SWIG_0(swigCPtr, this, n);
  }

  
/**
   * Sets the qualifier code of this
   * {@link CVTerm} object.
   <p>
   * @param type the qualifier type.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #getQualifierType()
   */ public
 int setQualifierType(int type) {
    return libsbmlJNI.CVTerm_setQualifierType(swigCPtr, this, type);
  }

  
/**
   * Sets the model qualifier type
   * of this {@link CVTerm} object.
   <p>
   * @param type the model qualifier type.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note If the Qualifier Type of this object is not
   * {@link libsbmlConstants#MODEL_QUALIFIER MODEL_QUALIFIER}, then the
   * then the model qualifier type
   * will default to {@link libsbmlConstants#BQM_UNKNOWN BQM_UNKNOWN}.
   <p>
   * @see #getQualifierType()
   * @see #setQualifierType(int)
   */ public
 int setModelQualifierType(int type) {
    return libsbmlJNI.CVTerm_setModelQualifierType__SWIG_0(swigCPtr, this, type);
  }

  
/**
   * Sets the biology qualifier
   * type of this {@link CVTerm} object.
   <p>
   * @param type the biology
   * qualifier type.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note If the Qualifier Type of this object is not
   * {@link libsbmlConstants#BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER},
   * then the biology qualifier type
   * will default to {@link libsbmlConstants#BQB_UNKNOWN BQB_UNKNOWN}.
   <p>
   * @see #getQualifierType()
   * @see #setQualifierType(int)
   */ public
 int setBiologicalQualifierType(int type) {
    return libsbmlJNI.CVTerm_setBiologicalQualifierType__SWIG_0(swigCPtr, this, type);
  }

  
/**
   * Sets the model qualifier
   * type value of this {@link CVTerm} object.
   <p>
   * @param qualifier the string representing a model qualifier.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note If the Qualifier Type of this object is not
   * {@link libsbmlConstants#MODEL_QUALIFIER MODEL_QUALIFIER}, 
   * then the model qualifier type
   * will default to {@link libsbmlConstants#BQM_UNKNOWN BQM_UNKNOWN}.
   <p>
   * @see #getQualifierType()
   * @see #setQualifierType(int)
   */ public
 int setModelQualifierType(String qualifier) {
    return libsbmlJNI.CVTerm_setModelQualifierType__SWIG_1(swigCPtr, this, qualifier);
  }

  
/**
   * Sets the biology qualifier
   * type code of this {@link CVTerm} object.
   <p>
   * @param qualifier the string representing a biology qualifier.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note If the Qualifier Type of this object is not
   * {@link libsbmlConstants#BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER},
   * then the biology qualifier type code
   * will default to {@link libsbmlConstants#BQB_UNKNOWN BQB_UNKNOWN}.
   <p>
   * @see #getQualifierType()
   * @see #setQualifierType(int)
   */ public
 int setBiologicalQualifierType(String qualifier) {
    return libsbmlJNI.CVTerm_setBiologicalQualifierType__SWIG_1(swigCPtr, this, qualifier);
  }

  
/**
   * Adds a resource reference to this {@link CVTerm} object.
   <p>
   * <p>
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled
 * vocabulary terms and database identifiers that define and describe
 * biological and other entities, and (b) describing the creator of a
 * model and the model's modification history.  The annotation content is
 * stored in <code>&lt;annotation&gt;</code> elements attached to
 * individual SBML elements.  The format for storing the content inside
 * SBML <code>&lt;annotation&gt;</code> elements is a subset of W3C RDF
 * (<a target='_blank' href='http://www.w3.org/RDF/'>Resource Description
 * Format</a>) expressed in XML.  The {@link CVTerm} class provides a programming
 * interface for working directly with controlled vocabulary term ('CV
 * term') objects without having to deal directly with the XML form.
 * When libSBML reads in an SBML model containing RDF annotations, it
 * parses those annotations into a list of {@link CVTerm} objects, and when
 * writing a model, it parses the {@link CVTerm} objects back into the
 * appropriate SBML <code>&lt;annotation&gt;</code> structure. 
   <p>
   * The specific RDF element used in this SBML format for referring to
   * external entities is <code>&lt;rdf:Description&gt;</code>, with a
   * <code>&lt;rdf:Bag&gt;</code> element containing one or more
   * <code>&lt;rdf:li&gt;</code> elements.  Each such element refers to a
   * data item in an external resource; the resource and data item are
   * together identified uniquely using a URI.  The following template
   * illustrates the structure:
   <p>
   <pre class='fragment'>
   &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
     <span style='background-color: #e0e0e0; border-bottom: 2px dotted #888'>HISTORY</span>
     &lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
       &lt;rdf:Bag&gt;
         &lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
         <span style='background-color: #edd'>...</span>
       &lt;/rdf:Bag&gt;
     &lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
     <span style='background-color: #edd'>...</span>
   &lt;/rdf:Description&gt;
   </pre>
   <p>
   * In the template above, the placeholder <span class='code'
   * style='border-bottom: 1px solid black'>meta id</span> stands for the
   * element's meta identifier, which is a field available on all SBML
   * components derived from the {@link SBase} base object class.  The <span
   * style='border-bottom: 2px dotted #888'>dotted</span> portions are
   * optional, and the ellipses <span class='code'
   * style='background-color: #edd'>...</span> are placeholders for zero or
   * more elements of the same form as the immediately preceding element.
   * The placeholder <span class='code' style='background-color: #bbb'>
   * RELATION_ELEMENT</span> refers to a BioModels.net qualifier element
   * name.  This is an element in either the XML namespace
   * <code>'http://biomodels.net/model-qualifiers'</code> (for model
   * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code>
   * (for biological qualifier).
   <p>
   * The <span class='code' style='background-color: #d0d0ee'>resource
   * URI</span> is a required data value that uniquely identifies a
   * resource and data within that resource to which the annotation refers.
   * The present method allows callers to add a reference to a resource URI
   * with the same relationship to the enclosing SBML object.  (In other
   * words, the argument to this method is a <span class='code'
   * style='background-color: #d0d0ee'>resource URI</span> as shown in the
   * XML fragment above.)  Resources are stored in this {@link CVTerm} object
   * within an {@link XMLAttributes} object.
   <p>
   * The relationship of this {@link CVTerm} to the enclosing SBML object can be
   * determined using the {@link CVTerm} methods such as
   * {@link CVTerm#getModelQualifierType()} and {@link CVTerm#getBiologicalQualifierType()}.
   <p>
   * @param resource a string representing the URI of the resource and data
   * item being referenced; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #getResources()
   * @see #removeResource(String resource)
   * @see #getQualifierType()
   * @see #getModelQualifierType()
   * @see #getBiologicalQualifierType()
   */ public
 int addResource(String resource) {
    return libsbmlJNI.CVTerm_addResource(swigCPtr, this, resource);
  }

  
/**
   * Removes a resource URI from the set of resources stored in this {@link CVTerm}
   * object.
   <p>
   * @param resource a string representing the resource URI to remove;
   * e.g., <code>'http://www.geneontology.org/#GO:0005892'</code>.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @see #addResource(String resource)
   */ public
 int removeResource(String resource) {
    return libsbmlJNI.CVTerm_removeResource(swigCPtr, this, resource);
  }

  
/**
   * Predicate returning <code>true</code> if all the required elements for this
   * {@link CVTerm} object have been set.
   <p>
   * @note The required attributes for a {@link CVTerm} are:
   * <ul>
   * <li> a <em>qualifier type</em>, which can be either a model qualifier or a biological qualifier
   * <li> at least one resource
   * </ul>
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.CVTerm_hasRequiredAttributes__SWIG_0(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean hasBeenModified() {
    return libsbmlJNI.CVTerm_hasBeenModified(swigCPtr, this);
  }

  
/** * @internal */ public
 void resetModifiedFlags() {
    libsbmlJNI.CVTerm_resetModifiedFlags(swigCPtr, this);
  }

  
/**
   * Returns the number of {@link CVTerm} objects nested within this {@link CVTerm}
   * object.
   <p>
   * @return the number of CVTerms nested within this {@link CVTerm} object.
   <p>
   * @note this does not recurse through potentially nested {@link CVTerm} objects
   * within a given nested {@link CVTerm}. It returns the number of terms immediately
   * nested within this {@link CVTerm}.
   */ public
 long getNumNestedCVTerms() {
    return libsbmlJNI.CVTerm_getNumNestedCVTerms(swigCPtr, this);
  }

  
/**
   * Returns the nth {@link CVTerm} in the list of CVTerms of this {@link CVTerm}
   * object.
   <p>
   * @param n long the index of the {@link CVTerm} to retrieve.
   <p>
   * @return the nth {@link CVTerm} in the list of CVTerms for this {@link CVTerm} object.
   */ public
 CVTerm getNestedCVTerm(long n) {
    long cPtr = libsbmlJNI.CVTerm_getNestedCVTerm__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new CVTerm(cPtr, false);
  }

  
/**
   * Returns a list of {@link CVTerm} objects contained within this {@link CVTerm}
   * object.
   <p>
   * @return the list of CVTerms for this {@link CVTerm} object.
   */ public
 SWIGTYPE_p_List getListNestedCVTerms() {
    long cPtr = libsbmlJNI.CVTerm_getListNestedCVTerms__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new SWIGTYPE_p_List(cPtr, false);
  }

  
/**
   * Adds a copy of the given {@link CVTerm} object to the list of nested {@link CVTerm}
   * objects within this {@link CVTerm} object.
   <p>
   * @param term the {@link CVTerm} to assign.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * </ul>
   */ public
 int addNestedCVTerm(CVTerm term) {
    return libsbmlJNI.CVTerm_addNestedCVTerm(swigCPtr, this, CVTerm.getCPtr(term), term);
  }

  
/**
   * Removes the nth {@link CVTerm} in the list of CVTerms of this {@link CVTerm}
   * object and returns a pointer to it.
   <p>
   * @param n long the index of the {@link CVTerm} to retrieve.
   <p>
   * @return a pointer to the nth {@link CVTerm} in the list of CVTerms for this 
   * {@link CVTerm} object.
   */ public
 CVTerm removeNestedCVTerm(long n) {
    long cPtr = libsbmlJNI.CVTerm_removeNestedCVTerm(swigCPtr, this, n);
    return (cPtr == 0) ? null : new CVTerm(cPtr, false);
  }

}
