/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  An SBML model.
 <p>
 * In an SBML model definition, a single object of class {@link Model} serves as
 * the overall container for the lists of the various model components.
 * All of the lists are optional, but if a given list container is present
 * within the model, the list must not be empty; that is, it must have
 * length one or more.  The following are the components and lists
 * permitted in different Levels and Versions of SBML in
 * version 5.15.2
 * of libSBML:
 * <ul>
 * <li> In SBML Level 1, the components are: {@link UnitDefinition}, {@link Compartment},
 * {@link Species}, {@link Parameter}, {@link Rule}, and {@link Reaction}.  Instances of the classes are
 * placed inside instances of classes {@link ListOfUnitDefinitions},
 * {@link ListOfCompartments}, {@link ListOfSpecies}, {@link ListOfParameters}, {@link ListOfRules}, and
 * {@link ListOfReactions}.
 <p>
 * <li> In SBML Level 2 Version 1, the components are: {@link FunctionDefinition},
 * {@link UnitDefinition}, {@link Compartment}, {@link Species}, {@link Parameter}, {@link Rule}, {@link Reaction} and
 * {@link Event}.  Instances of the classes are placed inside instances of classes
 * {@link ListOfFunctionDefinitions}, {@link ListOfUnitDefinitions}, {@link ListOfCompartments},
 * {@link ListOfSpecies}, {@link ListOfParameters}, {@link ListOfRules}, {@link ListOfReactions}, and
 * {@link ListOfEvents}.
 <p>
 * <li> In SBML Level 2 Versions 2, 3 and 4, the components are:
 * {@link FunctionDefinition}, {@link UnitDefinition}, {@link CompartmentType}, {@link SpeciesType},
 * {@link Compartment}, {@link Species}, {@link Parameter}, {@link InitialAssignment}, {@link Rule}, {@link Constraint},
 * {@link Reaction} and {@link Event}.  Instances of the classes are placed inside
 * instances of classes {@link ListOfFunctionDefinitions}, {@link ListOfUnitDefinitions},
 * {@link ListOfCompartmentTypes}, {@link ListOfSpeciesTypes}, {@link ListOfCompartments},
 * {@link ListOfSpecies}, {@link ListOfParameters}, {@link ListOfInitialAssignments}, {@link ListOfRules},
 * {@link ListOfConstraints}, {@link ListOfReactions}, and {@link ListOfEvents}.
 <p>
 * <li> In SBML Level 3 Version 1, the components are: {@link FunctionDefinition},
 * {@link UnitDefinition}, {@link Compartment}, {@link Species}, {@link Parameter}, {@link InitialAssignment},
 * {@link Rule}, {@link Constraint}, {@link Reaction} and {@link Event}.  Instances of the classes are
 * placed inside instances of classes {@link ListOfFunctionDefinitions},
 * {@link ListOfUnitDefinitions}, {@link ListOfCompartments}, {@link ListOfSpecies},
 * {@link ListOfParameters}, {@link ListOfInitialAssignments}, {@link ListOfRules},
 * {@link ListOfConstraints}, {@link ListOfReactions}, and {@link ListOfEvents}.  
 * </ul>
 <p>
 * Although all the lists are optional, there are dependencies between SBML
 * components such that defining some components requires defining others.
 * An example is that defining a species requires defining a compartment,
 * and defining a reaction requires defining a species.  The dependencies
 * are explained in more detail in the SBML specifications.
 <p>
 * In addition to the above lists and attributes, the {@link Model} class in both
 * SBML Level&nbsp;2 and Level&nbsp;3 has the usual two attributes of 'id'
 * and 'name', and both are optional.  As is the case for other SBML
 * components with 'id' and 'name' attributes, they must be used according
 * to the guidelines described in the SBML specifications.  (Within the
 * frameworks of SBML Level&nbsp;2 and Level&nbsp;3, a
 * {@link Model} object identifier has no assigned meaning, but extension packages
 * planned for SBML Level&nbsp;3 are likely to make use of this
 * identifier.)
 <p>
 * Finally, SBML Level&nbsp;3 has introduced a number of additional {@link Model}
 * attributes.  They are discussed in a separate section below.
 <p>
 * <h2>Approaches to creating objects using the libSBML API</h2>
 <p>
 * LibSBML provides two main mechanisms for creating objects: class
 * constructors
 * (e.g., <a href='org/sbml/libsbml/{@link Species}.html'>Species()</a> ), 
 * and <code>create<span class='placeholder-nospace'><em>Object</em></span>()</code>
 * methods (such as {@link Model#createSpecies()}) provided by certain <span
 * class='placeholder-nospace'><em>Object</em></span> classes such as {@link Model}.  These
 * multiple mechanisms are provided by libSBML for flexibility and to
 * support different use-cases, but they also have different implications
 * for the overall model structure.
 <p>
 * In general, the recommended approach is to use the <code>create<span
 * class='placeholder-nospace'><em>Object</em></span>()</code> methods.  These
 * methods both create an object <em>and</em> link it to the parent in one step.
 * Here is an example:<pre class='fragment'>
// Create an {@link SBMLDocument} object in Level 3 Version 1 format:

{@link SBMLDocument} sbmlDoc = new {@link SBMLDocument}(3, 1);

// Create a {@link Model} object inside the {@link SBMLDocument} object and set
// its identifier.  The call returns a pointer to the {@link Model} object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).  Note that
// the call to setId() returns a status code, and a real program
// should check this status code to make sure everything went okay.

{@link Model} model = sbmlDoc.createModel();
model.setId(&#34;BestModelEver&#34;);

// Create a {@link Species} object inside the {@link Model} and set its identifier.
// Similar to the lines above, this call returns a pointer to the {@link Species}
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).  Note that, like
// with {@link Model}, the call to setId() returns a status code, and a real program
// should check this status code to make sure everything went okay.

{@link Species} sp = model.createSpecies();
sp.setId(&#34;BestSpeciesEver&#34;);
</pre>
 <p>
 * The <code>create<span
 * class='placeholder-nospace'><em>Object</em></span>()</code> methods return a
 * pointer to the object created, but they also add the object to the
 * relevant list of object instances contained in the parent.  (These lists
 * become the <code>&lt;listOf<span
 * class='placeholder-nospace'><em>Object</em></span>s&gt;</code> elements in the
 * finished XML rendition of SBML.)  In the example above,
 * {@link Model#createSpecies()} adds the created species directly to the
 * <code>&lt;listOfSpeciesgt;</code> list in the model.  Subsequently,
 * methods called on the species change the species in the model (which is
 * what is expected in most situations).
 <p>
 * <h2>Consistency and adherence to SBML specifications</h2>
 <p>
 * To make it easier for applications to do whatever they need,
 * libSBML version 5.15.2
 * is relatively lax when it comes to enforcing correctness and
 * completeness of models <em>during</em> model construction and editing.
 * Essentially, libSBML <em>will</em> <em>not</em> in most cases check automatically
 * that a model's components have valid attribute values, or that the
 * overall model is consistent and free of errors&mdash;even obvious errors
 * such as duplication of identifiers.  This allows applications great
 * leeway in how they build their models, but it means that software
 * authors must take deliberate steps to ensure that the model will be, in
 * the end, valid SBML.  These steps include such things as keeping track
 * of the identifiers used in a model, manually performing updates in
 * certain situations where an entity is referenced in more than one place
 * (e.g., a species that is referenced by multiple {@link SpeciesReference}
 * objects), and so on.
 <p>
 * That said, libSBML does provide powerful features for deliberately
 * performing validation of SBML when an application decides it is time to
 * do so.  The interfaces to these facilities are on the {@link SBMLDocument}
 * class, in the form of {@link SBMLDocument#checkInternalConsistency()} and
 * {@link SBMLDocument#checkConsistency()}.  Please refer to the documentation for
 * {@link SBMLDocument} for more information about this.
 <p>
 * While applications may play fast and loose and live like free spirits
 * during the construction and editing of SBML models, they should always
 * make sure to call {@link SBMLDocument#checkInternalConsistency()} and/or
 * {@link SBMLDocument#checkConsistency()} before writing out the final version of
 * an SBML model.
 <p>
 * <h2>Model attributes introduced in SBML Level&nbsp;3</h2>
 <p>
 * As mentioned above, the {@link Model} class has a number of optional attributes
 * in SBML Level&nbsp;3.  These are 'substanceUnits',
 * 'timeUnits', 'volumeUnits', 'areaUnits', 'lengthUnits', 'extentUnits',
 * and 'conversionFactor.  The following provide more information about
 * them.
 <p>
 * <h3>The 'substanceUnits' attribute</h3>
 <p>
 * The 'substanceUnits' attribute is used to specify the unit of
 * measurement associated with substance quantities of {@link Species} objects that
 * do not specify units explicitly.  If a given {@link Species} object definition
 * does not specify its unit of substance quantity via the 'substanceUnits'
 * attribute on the {@link Species} object instance, then that species inherits the
 * value of the {@link Model} 'substanceUnits' attribute.  If the {@link Model} does not
 * define a value for this attribute, then there is no unit to inherit, and
 * all species that do not specify individual 'substanceUnits' attribute
 * values then have <em>no</em> declared units for their quantities.  The
 * SBML Level&nbsp;3 specifications provide more details.
 <p>
 * Note that when the identifier of a species appears in a model's
 * mathematical expressions, the unit of measurement associated with that
 * identifier is <em>not solely determined</em> by setting 'substanceUnits'
 * on {@link Model} or {@link Species}.  Please see the discussion about units given in
 * the documentation for the {@link Species} class.
 <p>
 * <h3>The 'timeUnits' attribute</h3>
 <p>
 * The 'timeUnits' attribute on SBML Level&nbsp;3's {@link Model} object is used to
 * specify the unit in which time is measured in the model.  This attribute
 * on {@link Model} is the <em>only</em> way to specify a unit for time in a model.
 * It is a global attribute; time is measured in the model everywhere in
 * the same way.  This is particularly relevant to {@link Reaction} and {@link RateRule}
 * objects in a model: all {@link Reaction} and {@link RateRule} objects in SBML define
 * per-time values, and the unit of time is given by the 'timeUnits'
 * attribute on the {@link Model} object instance.  If the {@link Model} 'timeUnits'
 * attribute has no value, it means that the unit of time is not defined
 * for the model's reactions and rate rules.  Leaving it unspecified in an
 * SBML model does not result in an invalid model in SBML Level&nbsp;3;
 * however, as a matter of best practice, we strongly recommend that all
 * models specify units of measurement for time.
 <p>
 * <h3>The 'volumeUnits', 'areaUnits', and 'lengthUnits' attributes</h3>
 <p>
 * The attributes 'volumeUnits', 'areaUnits' and 'lengthUnits' together are
 * used to set the units of measurements for the sizes of {@link Compartment}
 * objects in an SBML Level&nbsp;3 model when those objects do not
 * otherwise specify units.  The three attributes correspond to the most
 * common cases of compartment dimensions: 'volumeUnits' for compartments
 * having a 'spatialDimensions' attribute value of <code>'3'</code>, 'areaUnits' for
 * compartments having a 'spatialDimensions' attribute value of <code>'2'</code>, and
 * 'lengthUnits' for compartments having a 'spatialDimensions' attribute
 * value of <code>'1'.</code>  The attributes are not applicable to compartments
 * whose 'spatialDimensions' attribute values are <em>not</em> one of <code>'1'</code>, 
 * <code>'2'</code> or <code>'3'.</code>
 <p>
 * If a given {@link Compartment} object instance does not provide a value for its
 * 'units' attribute, then the unit of measurement of that compartment's
 * size is inherited from the value specified by the {@link Model} 'volumeUnits',
 * 'areaUnits' or 'lengthUnits' attribute, as appropriate based on the
 * {@link Compartment} object's 'spatialDimensions' attribute value.  If the {@link Model}
 * object does not define the relevant attribute, then there are no units
 * to inherit, and all {@link Compartment} objects that do not set a value for
 * their 'units' attribute then have <em>no</em> units associated with
 * their compartment sizes.
 <p>
 * The use of three separate attributes is a carry-over from SBML
 * Level&nbsp;2.  Note that it is entirely possible for a model to define a
 * value for two or more of the attributes 'volumeUnits', 'areaUnits' and
 * 'lengthUnits' simultaneously, because SBML models may contain
 * compartments with different numbers of dimensions.
 <p>
 * <h3>The 'extentUnits' attribute</h3>
 <p>
 * Reactions are processes that occur over time.  These processes involve
 * events of some sort, where a single ``reaction event'' is one in which
 * some set of entities (known as reactants, products and modifiers in
 * SBML) interact, once.  The <em>extent</em> of a reaction is a measure of
 * how many times the reaction has occurred, while the time derivative of
 * the extent gives the instantaneous rate at which the reaction is
 * occurring.  Thus, what is colloquially referred to as the 'rate of the
 * reaction' is in fact equal to the rate of change of reaction extent.
 <p>
 * In SBML Level&nbsp;3, the combination of 'extentUnits' and 'timeUnits'
 * defines the units of kinetic laws in SBML and establishes how the
 * numerical value of each {@link KineticLaw} object's mathematical formula is
 * meant to be interpreted in a model.  The units of the kinetic laws are
 * taken to be 'extentUnits' divided by 'timeUnits'.
 <p>
 * Note that this embodies an important principle in SBML Level&nbsp;3
 * models: <em>all reactions in an SBML model must have the same units</em>
 * for the rate of change of extent.  In other words, the units of all
 * reaction rates in the model <em>must be the same</em>.  There is only
 * one global value for 'extentUnits' and one global value for 'timeUnits'.
 <p>
 * <h3>The 'conversionFactor' attribute</h3>
 <p>
 * The attribute 'conversionFactor' in SBML Level&nbsp;3's {@link Model} object
 * defines a global value inherited by all {@link Species} object instances that do
 * not define separate values for their 'conversionFactor' attributes.  The
 * value of this attribute must refer to a {@link Parameter} object instance
 * defined in the model.  The {@link Parameter} object in question must be a
 * constant; ie it must have its 'constant' attribute value set to 
 * <code>'true'.</code>
 <p>
 * If a given {@link Species} object definition does not specify a conversion
 * factor via the 'conversionFactor' attribute on {@link Species}, then the species
 * inherits the conversion factor specified by the {@link Model} 'conversionFactor'
 * attribute.  If the {@link Model} does not define a value for this attribute,
 * then there is no conversion factor to inherit.  More information about
 * conversion factors is provided in the SBML Level&nbsp;3
 * specifications.
 */

public class Model extends SBase {
   private long swigCPtr;

   protected Model(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.Model_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Model obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Model obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Model(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link Model} using the given SBML <code>level</code> and <code>version</code>
   * values.
   <p>
   * @param level a long integer, the SBML Level to assign to this {@link Model}.
   <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Model}.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 Model(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Model__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link Model} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments.
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>sbmlns</code> is inconsistent or incompatible
 * with this object.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 Model(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Model__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a (deep) copy of the given {@link Model} object.
   <p>
   * @param orig the object to copy.
   */ public
 Model(Model orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Model__SWIG_2(Model.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link Model} object.
   <p>
   * @return the (deep) copy of this {@link Model} object.
   */ public
 Model cloneObject() {
    long cPtr = libsbmlJNI.Model_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, true);
  }

  
/**
   * Returns the first child element found that has the given <code>id</code>.
   <p>
   * This operation searches the model-wide <code>SId</code> identifier
   * type namespace
   <p>
   * @param id string representing the id of the object to find.
   <p>
   * @return pointer to the first element found with the given <code>id</code>, or 
   * <code>null</code> if no such object is found.
   */ public
 SBase getElementBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.Model_getElementBySId(swigCPtr, this, id), false);
}

  
/**
   * Returns the first child element it can find with the given <code>metaid</code>.
   <p>
   * @param metaid string representing the meta-identifier of the object to
   * find.
   <p>
   * @return pointer to the first element found with the given <code>metaid</code>, or
   * null if no such object is found.
   */ public
 SBase getElementByMetaId(String metaid) {
  return libsbml.DowncastSBase(libsbmlJNI.Model_getElementByMetaId(swigCPtr, this, metaid), false);
}

  
/**
   * Returns the value of the 'id' attribute of this {@link Model}.
   <p>
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
   <p>
   * @return the id of this {@link Model}.
   <p>
   * @see #getIdAttribute()
   * @see #setIdAttribute(String sid)
   * @see #isSetIdAttribute()
   * @see #unsetIdAttribute()
   */ public
 String getId() {
    return libsbmlJNI.Model_getId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'name' attribute of this {@link Model} object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 <p>
 * @see #getIdAttribute()
 * @see #isSetName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 String getName() {
    return libsbmlJNI.Model_getName(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'substanceUnits' attribute of this {@link Model}.
   <p>
   * @return the substanceUnits of this {@link Model}.
   <p>
   * @note The 'substanceUnits' attribute is available in
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 String getSubstanceUnits() {
    return libsbmlJNI.Model_getSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'timeUnits' attribute of this {@link Model}.
   <p>
   * @return the timeUnits of this {@link Model}.
   <p>
   * @note The 'timeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 String getTimeUnits() {
    return libsbmlJNI.Model_getTimeUnits(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'volumeUnits' attribute of this {@link Model}.
   <p>
   * @return the volumeUnits of this {@link Model}.
   <p>
   * @note The 'volumeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 String getVolumeUnits() {
    return libsbmlJNI.Model_getVolumeUnits(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'areaUnits' attribute of this {@link Model}.
   <p>
   * @return the areaUnits of this {@link Model}.
   <p>
   * @note The 'areaUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 String getAreaUnits() {
    return libsbmlJNI.Model_getAreaUnits(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'lengthUnits' attribute of this {@link Model}.
   <p>
   * @return the lengthUnits of this {@link Model}.
   <p>
   * @note The 'lengthUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 String getLengthUnits() {
    return libsbmlJNI.Model_getLengthUnits(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'extentUnits' attribute of this {@link Model}.
   <p>
   * @return the extentUnits of this {@link Model}.
   <p>
   * @note The 'extentUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 String getExtentUnits() {
    return libsbmlJNI.Model_getExtentUnits(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'conversionFactor' attribute of this {@link Model}.
   <p>
   * @return the conversionFactor of this {@link Model}.
   <p>
   * @note The 'conversionFactor' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 String getConversionFactor() {
    return libsbmlJNI.Model_getConversionFactor(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'id' attribute is set.
   <p>
   * <p>
 * @note Because of the inconsistent behavior of this function with 
 * respect to assignments and rules, it is now recommended to
 * use the isSetIdAttribute() function instead.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'id' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #unsetIdAttribute()
 * @see #isSetIdAttribute()
   */ public
 boolean isSetId() {
    return libsbmlJNI.Model_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'name' attribute is set.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'name' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 boolean isSetName() {
    return libsbmlJNI.Model_isSetName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'substanceUnits' attribute is set.
   <p>
   * @return <code>true</code> if the 'substanceUnits' attribute of this {@link Model} is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'substanceUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 boolean isSetSubstanceUnits() {
    return libsbmlJNI.Model_isSetSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'timeUnits' attribute is set.
   <p>
   * @return <code>true</code> if the 'timeUnits' attribute of this {@link Model} is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'substanceUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 boolean isSetTimeUnits() {
    return libsbmlJNI.Model_isSetTimeUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'volumeUnits' attribute is set.
   <p>
   * @return <code>true</code> if the 'volumeUnits' attribute of this {@link Model} is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'volumeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 boolean isSetVolumeUnits() {
    return libsbmlJNI.Model_isSetVolumeUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'areaUnits' attribute is set.
   <p>
   * @return <code>true</code> if the 'areaUnits' attribute of this {@link Model} is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'areaUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 boolean isSetAreaUnits() {
    return libsbmlJNI.Model_isSetAreaUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'lengthUnits' attribute is set.
   <p>
   * @return <code>true</code> if the 'lengthUnits' attribute of this {@link Model} is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'lengthUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 boolean isSetLengthUnits() {
    return libsbmlJNI.Model_isSetLengthUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'extentUnits' attribute is set.
   <p>
   * @return <code>true</code> if the 'extentUnits' attribute of this {@link Model} is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'extentUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 boolean isSetExtentUnits() {
    return libsbmlJNI.Model_isSetExtentUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Model}'s 'conversionFactor' attribute is set.
   <p>
   * @return <code>true</code> if the 'conversionFactor' attribute of this {@link Model} is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'conversionFactor' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 boolean isSetConversionFactor() {
    return libsbmlJNI.Model_isSetConversionFactor(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'id' attribute of this {@link Model}.
   <p>
   * <p>
 * The string <code>sid</code> is copied.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 <p>
 * @param sid the string to use as the identifier of this object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
 *
 * </ul> <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #isSetIdAttribute()
 * @see #unsetIdAttribute()
   */ public
 int setId(String sid) {
    return libsbmlJNI.Model_setId(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'name' attribute of this {@link Model}.
   <p>
   * <p>
 * The string in <code>name</code> is copied.
 <p>
 * @param name the new name for the SBML object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 *
 * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.Model_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the value of the 'substanceUnits' attribute of this {@link Model}.
   <p>
   * The string in <code>units</code> is copied.
   <p>
   * @param units the new substanceUnits for the {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'substanceUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int setSubstanceUnits(String units) {
    return libsbmlJNI.Model_setSubstanceUnits(swigCPtr, this, units);
  }

  
/**
   * Sets the value of the 'timeUnits' attribute of this {@link Model}.
   <p>
   * The string in <code>units</code> is copied.
   <p>
   * @param units the new timeUnits for the {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'timeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int setTimeUnits(String units) {
    return libsbmlJNI.Model_setTimeUnits(swigCPtr, this, units);
  }

  
/**
   * Sets the value of the 'volumeUnits' attribute of this {@link Model}.
   <p>
   * The string in <code>units</code> is copied.
   <p>
   * @param units the new volumeUnits for the {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'volumeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int setVolumeUnits(String units) {
    return libsbmlJNI.Model_setVolumeUnits(swigCPtr, this, units);
  }

  
/**
   * Sets the value of the 'areaUnits' attribute of this {@link Model}.
   <p>
   * The string in <code>units</code> is copied.
   <p>
   * @param units the new areaUnits for the {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'areaUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int setAreaUnits(String units) {
    return libsbmlJNI.Model_setAreaUnits(swigCPtr, this, units);
  }

  
/**
   * Sets the value of the 'lengthUnits' attribute of this {@link Model}.
   <p>
   * The string in <code>units</code> is copied.
   <p>
   * @param units the new lengthUnits for the {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'lengthUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int setLengthUnits(String units) {
    return libsbmlJNI.Model_setLengthUnits(swigCPtr, this, units);
  }

  
/**
   * Sets the value of the 'extentUnits' attribute of this {@link Model}.
   <p>
   * The string in <code>units</code> is copied.
   <p>
   * @param units the new extentUnits for the {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'extentUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int setExtentUnits(String units) {
    return libsbmlJNI.Model_setExtentUnits(swigCPtr, this, units);
  }

  
/**
   * Sets the value of the 'conversionFactor' attribute of this {@link Model}.
   <p>
   * The string in <code>units</code> is copied.
   <p>
   * @param units the new conversionFactor for the {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'conversionFactor' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int setConversionFactor(String units) {
    return libsbmlJNI.Model_setConversionFactor(swigCPtr, this, units);
  }

  
/**
   * Unsets the value of the 'id' attribute of this {@link Model}.
   <p>
   * <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
 *
 * </ul> <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #isSetIdAttribute()
 * @see #unsetIdAttribute()
   */ public
 int unsetId() {
    return libsbmlJNI.Model_unsetId(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'name' attribute of this {@link Model}.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
 *
 * </ul> <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #isSetName()
   */ public
 int unsetName() {
    return libsbmlJNI.Model_unsetName(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'substanceUnits' attribute of this {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'substanceUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int unsetSubstanceUnits() {
    return libsbmlJNI.Model_unsetSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'timeUnits' attribute of this {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'timeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int unsetTimeUnits() {
    return libsbmlJNI.Model_unsetTimeUnits(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'volumeUnits' attribute of this {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'volumeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int unsetVolumeUnits() {
    return libsbmlJNI.Model_unsetVolumeUnits(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'areaUnits' attribute of this {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'areaUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int unsetAreaUnits() {
    return libsbmlJNI.Model_unsetAreaUnits(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'lengthUnits' attribute of this {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'lengthUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int unsetLengthUnits() {
    return libsbmlJNI.Model_unsetLengthUnits(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'extentUnits' attribute of this {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'extentUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int unsetExtentUnits() {
    return libsbmlJNI.Model_unsetExtentUnits(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'conversionFactor' attribute of this {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'conversionFactor' attribute is available in 
   * SBML Level&nbsp;3 but is not present on {@link Model} in lower Levels of SBML.
   */ public
 int unsetConversionFactor() {
    return libsbmlJNI.Model_unsetConversionFactor(swigCPtr, this);
  }

  
/**
   * Adds a copy of the given {@link FunctionDefinition} object to this {@link Model}.
   <p>
   * @param fd the {@link FunctionDefinition} to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createFunctionDefinition()
   */ public
 int addFunctionDefinition(FunctionDefinition fd) {
    return libsbmlJNI.Model_addFunctionDefinition(swigCPtr, this, FunctionDefinition.getCPtr(fd), fd);
  }

  
/**
   * Adds a copy of the given {@link UnitDefinition} object to this {@link Model}.
   <p>
   * @param ud the {@link UnitDefinition} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createUnitDefinition()
   */ public
 int addUnitDefinition(UnitDefinition ud) {
    return libsbmlJNI.Model_addUnitDefinition(swigCPtr, this, UnitDefinition.getCPtr(ud), ud);
  }

  
/**
   * Adds a copy of the given {@link CompartmentType} object to this {@link Model}.
   <p>
   * @param ct the {@link CompartmentType} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @note The {@link CompartmentType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   <p>
   * @see #createCompartmentType()
   */ public
 int addCompartmentType(CompartmentType ct) {
    return libsbmlJNI.Model_addCompartmentType(swigCPtr, this, CompartmentType.getCPtr(ct), ct);
  }

  
/**
   * Adds a copy of the given {@link SpeciesType} object to this {@link Model}.
   <p>
   * @param st the {@link SpeciesType} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @note The {@link SpeciesType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   <p>
   * @see #createSpeciesType()
   */ public
 int addSpeciesType(SpeciesType st) {
    return libsbmlJNI.Model_addSpeciesType(swigCPtr, this, SpeciesType.getCPtr(st), st);
  }

  
/**
   * Adds a copy of the given {@link Compartment} object to this {@link Model}.
   <p>
   * @param c the {@link Compartment} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createCompartment()
   */ public
 int addCompartment(Compartment c) {
    return libsbmlJNI.Model_addCompartment(swigCPtr, this, Compartment.getCPtr(c), c);
  }

  
/**
   * Adds a copy of the given {@link Species} object to this {@link Model}.
   <p>
   * @param s the {@link Species} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createSpecies()
   */ public
 int addSpecies(Species s) {
    return libsbmlJNI.Model_addSpecies(swigCPtr, this, Species.getCPtr(s), s);
  }

  
/**
   * Adds a copy of the given {@link Parameter} object to this {@link Model}.
   <p>
   * @param p the {@link Parameter} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createParameter()
   */ public
 int addParameter(Parameter p) {
    return libsbmlJNI.Model_addParameter(swigCPtr, this, Parameter.getCPtr(p), p);
  }

  
/**
   * Adds a copy of the given {@link InitialAssignment} object to this {@link Model}.
   <p>
   * @param ia the {@link InitialAssignment} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createInitialAssignment()
   */ public
 int addInitialAssignment(InitialAssignment ia) {
    return libsbmlJNI.Model_addInitialAssignment(swigCPtr, this, InitialAssignment.getCPtr(ia), ia);
  }

  
/**
   * Adds a copy of the given {@link Rule} object to this {@link Model}.
   <p>
   * @param r the {@link Rule} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createAlgebraicRule()
   * @see #createAssignmentRule()
   * @see #createRateRule()
   */ public
 int addRule(Rule r) {
    return libsbmlJNI.Model_addRule(swigCPtr, this, Rule.getCPtr(r), r);
  }

  
/**
   * Adds a copy of the given {@link Constraint} object to this {@link Model}.
   <p>
   * @param c the {@link Constraint} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createConstraint()
   */ public
 int addConstraint(Constraint c) {
    return libsbmlJNI.Model_addConstraint(swigCPtr, this, Constraint.getCPtr(c), c);
  }

  
/**
   * Adds a copy of the given {@link Reaction} object to this {@link Model}.
   <p>
   * @param r the {@link Reaction} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createReaction()
   */ public
 int addReaction(Reaction r) {
    return libsbmlJNI.Model_addReaction(swigCPtr, this, Reaction.getCPtr(r), r);
  }

  
/**
   * Adds a copy of the given {@link Event} object to this {@link Model}.
   <p>
   * @param e the {@link Event} object to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createEvent()
   */ public
 int addEvent(Event e) {
    return libsbmlJNI.Model_addEvent(swigCPtr, this, Event.getCPtr(e), e);
  }

  
/**
   * Creates a new {@link FunctionDefinition} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link FunctionDefinition} object created.
   <p>
   * @see #addFunctionDefinition(FunctionDefinition fd)
   */ public
 FunctionDefinition createFunctionDefinition() {
    long cPtr = libsbmlJNI.Model_createFunctionDefinition(swigCPtr, this);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, false);
  }

  
/**
   * Creates a new {@link UnitDefinition} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link UnitDefinition} object created.
   <p>
   * @see #addUnitDefinition(UnitDefinition ud)
   */ public
 UnitDefinition createUnitDefinition() {
    long cPtr = libsbmlJNI.Model_createUnitDefinition(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
/**
   * Creates a new {@link Unit} object within the last {@link UnitDefinition} object
   * created in this model and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * The mechanism by which the {@link UnitDefinition} was created is not
   * significant.  If a {@link UnitDefinition} object does not exist in this model,
   * a new {@link Unit} is <em>not</em> created and <code>null</code> is returned instead.
   <p>
   * @return the {@link Unit} object created.
   <p>
   * @see #addUnitDefinition(UnitDefinition ud)
   */ public
 Unit createUnit() {
    long cPtr = libsbmlJNI.Model_createUnit(swigCPtr, this);
    return (cPtr == 0) ? null : new Unit(cPtr, false);
  }

  
/**
   * Creates a new {@link CompartmentType} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link CompartmentType} object created.
   <p>
   * @note The {@link CompartmentType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   <p>
   * @see #addCompartmentType(CompartmentType ct)
   */ public
 CompartmentType createCompartmentType() {
    long cPtr = libsbmlJNI.Model_createCompartmentType(swigCPtr, this);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, false);
  }

  
/**
   * Creates a new {@link SpeciesType} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link SpeciesType} object created.
   <p>
   * @note The {@link SpeciesType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   <p>
   * @see #addSpeciesType(SpeciesType st)
   */ public
 SpeciesType createSpeciesType() {
    long cPtr = libsbmlJNI.Model_createSpeciesType(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, false);
  }

  
/**
   * Creates a new {@link Compartment} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link Compartment} object created.
   <p>
   * @see #addCompartment(Compartment c)
   */ public
 Compartment createCompartment() {
    long cPtr = libsbmlJNI.Model_createCompartment(swigCPtr, this);
    return (cPtr == 0) ? null : new Compartment(cPtr, false);
  }

  
/**
   * Creates a new {@link Species} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link Species} object created.
   <p>
   * @see #addSpecies(Species s)
   */ public
 Species createSpecies() {
    long cPtr = libsbmlJNI.Model_createSpecies(swigCPtr, this);
    return (cPtr == 0) ? null : new Species(cPtr, false);
  }

  
/**
   * Creates a new {@link Parameter} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link Parameter} object created.
   <p>
   * @see #addParameter(Parameter p)
   */ public
 Parameter createParameter() {
    long cPtr = libsbmlJNI.Model_createParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
/**
   * Creates a new {@link InitialAssignment} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link InitialAssignment} object created.
   <p>
   * @see #addInitialAssignment(InitialAssignment ia)
   */ public
 InitialAssignment createInitialAssignment() {
    long cPtr = libsbmlJNI.Model_createInitialAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, false);
  }

  
/**
   * Creates a new {@link AlgebraicRule} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link AlgebraicRule} object created.
   <p>
   * @see #addRule(Rule r)
   */ public
 AlgebraicRule createAlgebraicRule() {
    long cPtr = libsbmlJNI.Model_createAlgebraicRule(swigCPtr, this);
    return (cPtr == 0) ? null : new AlgebraicRule(cPtr, false);
  }

  
/**
   * Creates a new {@link AssignmentRule} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link AssignmentRule} object created.
   <p>
   * @see #addRule(Rule r)
   */ public
 AssignmentRule createAssignmentRule() {
    long cPtr = libsbmlJNI.Model_createAssignmentRule(swigCPtr, this);
    return (cPtr == 0) ? null : new AssignmentRule(cPtr, false);
  }

  
/**
   * Creates a new {@link RateRule} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link RateRule} object created.
   <p>
   * @see #addRule(Rule r)
   */ public
 RateRule createRateRule() {
    long cPtr = libsbmlJNI.Model_createRateRule(swigCPtr, this);
    return (cPtr == 0) ? null : new RateRule(cPtr, false);
  }

  
/**
   * Creates a new {@link Constraint} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link Constraint} object created.
   <p>
   * @see #addConstraint(Constraint c)
   */ public
 Constraint createConstraint() {
    long cPtr = libsbmlJNI.Model_createConstraint(swigCPtr, this);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  
/**
   * Creates a new {@link Reaction} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link Reaction} object created.
   <p>
   * @see #addReaction(Reaction r)
   */ public
 Reaction createReaction() {
  return (Reaction) libsbml.DowncastSBase(libsbmlJNI.Model_createReaction(swigCPtr, this), false);
}

  
/**
   * Creates a new {@link SpeciesReference} object for a reactant inside the last
   * {@link Reaction} object in this {@link Model}, and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The mechanism by which the last {@link Reaction} object was created and added
 * to this {@link Model} is not significant.  It could have been created in a
 * variety of ways, for example using createReaction().  If a {@link Reaction}
 * does not exist for this model, a new {@link SpeciesReference} is <em>not</em>
 * created and <code>null</code> is returned instead.
   <p>
   * @return the {@link SpeciesReference} object created.  If a {@link Reaction} does not
   * exist for this model, a new {@link SpeciesReference} is <em>not</em> created and 
   * <code>null</code> is returned.
   */ public
 SpeciesReference createReactant() {
    long cPtr = libsbmlJNI.Model_createReactant(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Creates a new {@link SpeciesReference} object for a product inside the last
   * {@link Reaction} object in this {@link Model}, and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The mechanism by which the last {@link Reaction} object was created and added
 * to this {@link Model} is not significant.  It could have been created in a
 * variety of ways, for example using createReaction().  If a {@link Reaction}
 * does not exist for this model, a new {@link SpeciesReference} is <em>not</em>
 * created and <code>null</code> is returned instead.
   <p>
   * @return the {@link SpeciesReference} object created. If a {@link Reaction} does not
   * exist for this model, a new {@link SpeciesReference} is <em>not</em> created and 
   * <code>null</code> is returned.
   */ public
 SpeciesReference createProduct() {
    long cPtr = libsbmlJNI.Model_createProduct(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Creates a new {@link ModifierSpeciesReference} object for a modifier species
   * inside the last {@link Reaction} object in this {@link Model}, and returns a pointer
   * to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The mechanism by which the last {@link Reaction} object was created and added
 * to this {@link Model} is not significant.  It could have been created in a
 * variety of ways, for example using createReaction().  If a {@link Reaction}
 * does not exist for this model, a new {@link SpeciesReference} is <em>not</em>
 * created and <code>null</code> is returned instead.
   <p>
   * @return the {@link SpeciesReference} object created.  If a {@link Reaction} does not
   * exist for this model, a new {@link SpeciesReference} is <em>not</em> created and 
   * <code>null</code> is returned.
   */ public
 ModifierSpeciesReference createModifier() {
    long cPtr = libsbmlJNI.Model_createModifier(swigCPtr, this);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
/**
   * Creates a new {@link KineticLaw} inside the last {@link Reaction} object created in
   * this {@link Model}, and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The mechanism by which the last {@link Reaction} object was created and added
 * to this {@link Model} is not significant.  It could have been created in a
 * variety of ways, for example using createReaction().  If a {@link Reaction}
 * does not exist for this model, a new {@link SpeciesReference} is <em>not</em>
 * created and <code>null</code> is returned instead.
   <p>
   * @return the {@link KineticLaw} object created.  If a {@link Reaction} does not exist for
   * this model, or a {@link Reaction} does exist but already has a {@link KineticLaw}, a new
   * {@link KineticLaw} is <em>not</em> created and <code>null</code> is returned.
   */ public
 KineticLaw createKineticLaw() {
    long cPtr = libsbmlJNI.Model_createKineticLaw(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, false);
  }

  
/**
   * Creates a new local {@link Parameter} inside the {@link KineticLaw} object of the last
   * {@link Reaction} created inside this {@link Model}, and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The last {@link KineticLaw} object in this {@link Model} could have been created in a
 * variety of ways.  For example, it could have been added using
 * createKineticLaw(), or it could be the result of using
 * {@link Reaction#createKineticLaw()} on the {@link Reaction} object created by a
 * createReaction().  If a {@link Reaction} does not exist for this model, or the
 * last {@link Reaction} does not contain a {@link KineticLaw} object, a new {@link Parameter} is
 * <em>not</em> created and <code>null</code> is returned instead.
   <p>
   * @return the {@link Parameter} object created.  If a {@link Reaction} does not exist for
   * this model, or a {@link KineticLaw} for the {@link Reaction} does not exist, a new
   * {@link Parameter} is <em>not</em> created and <code>null</code> is returned.
   */ public
 Parameter createKineticLawParameter() {
    long cPtr = libsbmlJNI.Model_createKineticLawParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
/**
   * Creates a new {@link LocalParameter} inside the {@link KineticLaw} object of the last
   * {@link Reaction} created inside this {@link Model}, and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The last {@link KineticLaw} object in this {@link Model} could have been created in a
 * variety of ways.  For example, it could have been added using
 * createKineticLaw(), or it could be the result of using
 * {@link Reaction#createKineticLaw()} on the {@link Reaction} object created by a
 * createReaction().  If a {@link Reaction} does not exist for this model, or the
 * last {@link Reaction} does not contain a {@link KineticLaw} object, a new {@link Parameter} is
 * <em>not</em> created and <code>null</code> is returned instead.
   <p>
   * @return the {@link Parameter} object created.  If a {@link Reaction} does not exist for
   * this model, or a {@link KineticLaw} for the {@link Reaction} does not exist, a new
   * {@link Parameter} is <em>not</em> created and <code>null</code> is returned.
   */ public
 LocalParameter createKineticLawLocalParameter() {
    long cPtr = libsbmlJNI.Model_createKineticLawLocalParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
/**
   * Creates a new {@link Event} inside this {@link Model} and returns it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * @return the {@link Event} object created.
   */ public
 Event createEvent() {
    long cPtr = libsbmlJNI.Model_createEvent(swigCPtr, this);
    return (cPtr == 0) ? null : new Event(cPtr, false);
  }

  
/**
   * Creates a new {@link EventAssignment} inside the last {@link Event} object created in
   * this {@link Model}, and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The mechanism by which the last {@link Event} object in this model was created
 * is not significant.  It could have been created in a variety of ways,
 * for example by using createEvent().  If no {@link Event} object exists in this
 * {@link Model} object, a new {@link EventAssignment} is <em>not</em> created and <code>null</code> is
 * returned instead.
   <p>
   * @return the {@link EventAssignment} object created.
   */ public
 EventAssignment createEventAssignment() {
    long cPtr = libsbmlJNI.Model_createEventAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
/**
   * Creates a new {@link Trigger} inside the last {@link Event} object created in
   * this {@link Model}, and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The mechanism by which the last {@link Event} object in this model was created
 * is not significant.  It could have been created in a variety of ways,
 * for example by using createEvent().  If no {@link Event} object exists in this
 * {@link Model} object, a new {@link EventAssignment} is <em>not</em> created and <code>null</code> is
 * returned instead.
   <p>
   * @return the {@link Trigger} object created.
   */ public
 Trigger createTrigger() {
    long cPtr = libsbmlJNI.Model_createTrigger(swigCPtr, this);
    return (cPtr == 0) ? null : new Trigger(cPtr, false);
  }

  
/**
   * Creates a new {@link Delay} inside the last {@link Event} object created in
   * this {@link Model}, and returns a pointer to it.
   <p>
   * The SBML Level and Version of the enclosing {@link Model} object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   <p>
   * <p>
 * The mechanism by which the last {@link Event} object in this model was created
 * is not significant.  It could have been created in a variety of ways,
 * for example by using createEvent().  If no {@link Event} object exists in this
 * {@link Model} object, a new {@link EventAssignment} is <em>not</em> created and <code>null</code> is
 * returned instead.
   <p>
   * @return the {@link Delay} object created.
   */ public
 Delay createDelay() {
    long cPtr = libsbmlJNI.Model_createDelay(swigCPtr, this);
    return (cPtr == 0) ? null : new Delay(cPtr, false);
  }

  
/**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   <p>
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the <code>annotation</code> that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   <p>
   * @param annotation an XML structure that is to be used as the content
   * of the 'annotation' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #appendAnnotation(XMLNode annotation)
   */ public
 int setAnnotation(XMLNode annotation) {
    return libsbmlJNI.Model_setAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
/**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   <p>
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the <code>annotation</code> that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   <p>
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #appendAnnotation(String annotation)
   */ public
 int setAnnotation(String annotation) {
    return libsbmlJNI.Model_setAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
/**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   <p>
   * The content in <code>annotation</code> is copied.  Unlike setAnnotation(), this
   * method allows other annotations to be preserved when an application
   * adds its own data.
   <p>
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #setAnnotation(XMLNode annotation)
   */ public
 int appendAnnotation(XMLNode annotation) {
    return libsbmlJNI.Model_appendAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
/**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   <p>
   * The content in <code>annotation</code> is copied.  Unlike setAnnotation(), this 
   * method allows other annotations to be preserved when an application
   * adds its own data.
   <p>
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #setAnnotation(String annotation)
   */ public
 int appendAnnotation(String annotation) {
    return libsbmlJNI.Model_appendAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
/**
   * Get the {@link ListOfFunctionDefinitions} object in this {@link Model}.
   <p>
   * @return the list of FunctionDefinitions for this {@link Model}.
   */ public
 ListOfFunctionDefinitions getListOfFunctionDefinitions() {
    long cPtr = libsbmlJNI.Model_getListOfFunctionDefinitions__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfFunctionDefinitions(cPtr, false);
  }

  
/**
   * Get the {@link ListOfUnitDefinitions} object in this {@link Model}.
   <p>
   * @return the list of UnitDefinitions for this {@link Model}.
   */ public
 ListOfUnitDefinitions getListOfUnitDefinitions() {
    long cPtr = libsbmlJNI.Model_getListOfUnitDefinitions__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfUnitDefinitions(cPtr, false);
  }

  
/**
   * Get the {@link ListOfCompartmentTypes} object in this {@link Model}.
   <p>
   * @return the list of CompartmentTypes for this {@link Model}.
   <p>
   * @note The {@link CompartmentType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 ListOfCompartmentTypes getListOfCompartmentTypes() {
    long cPtr = libsbmlJNI.Model_getListOfCompartmentTypes__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfCompartmentTypes(cPtr, false);
  }

  
/**
   * Get the {@link ListOfSpeciesTypes} object in this {@link Model}.
   <p>
   * @return the list of SpeciesTypes for this {@link Model}.
   <p>
   * @note The {@link SpeciesType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 ListOfSpeciesTypes getListOfSpeciesTypes() {
    long cPtr = libsbmlJNI.Model_getListOfSpeciesTypes__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpeciesTypes(cPtr, false);
  }

  
/**
   * Get the {@link ListOfCompartments} object in this {@link Model}.
   <p>
   * @return the list of Compartments for this {@link Model}.
   */ public
 ListOfCompartments getListOfCompartments() {
    long cPtr = libsbmlJNI.Model_getListOfCompartments__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfCompartments(cPtr, false);
  }

  
/**
   * Get the {@link ListOfSpecies} object in this {@link Model}.
   <p>
   * @return the list of {@link Species} for this {@link Model}.
   */ public
 ListOfSpecies getListOfSpecies() {
    long cPtr = libsbmlJNI.Model_getListOfSpecies__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpecies(cPtr, false);
  }

  
/**
   * Get the {@link ListOfParameters} object in this {@link Model}.
   <p>
   * @return the list of Parameters for this {@link Model}.
   */ public
 ListOfParameters getListOfParameters() {
    long cPtr = libsbmlJNI.Model_getListOfParameters__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfParameters(cPtr, false);
  }

  
/**
   * Get the {@link ListOfInitialAssignments} object in this {@link Model}.
   <p>
   * @return the list of InitialAssignments for this {@link Model}.
   */ public
 ListOfInitialAssignments getListOfInitialAssignments() {
    long cPtr = libsbmlJNI.Model_getListOfInitialAssignments__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfInitialAssignments(cPtr, false);
  }

  
/**
   * Get the {@link ListOfRules} object in this {@link Model}.
   <p>
   * @return the list of Rules for this {@link Model}.
   */ public
 ListOfRules getListOfRules() {
    long cPtr = libsbmlJNI.Model_getListOfRules__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfRules(cPtr, false);
  }

  
/**
   * Get the {@link ListOfConstraints} object in this {@link Model}.
   <p>
   * @return the list of Constraints for this {@link Model}.
   */ public
 ListOfConstraints getListOfConstraints() {
    long cPtr = libsbmlJNI.Model_getListOfConstraints__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfConstraints(cPtr, false);
  }

  
/**
   * Get the {@link ListOfReactions} object in this {@link Model}.
   <p>
   * @return the list of Reactions for this {@link Model}.
   */ public
 ListOfReactions getListOfReactions() {
    long cPtr = libsbmlJNI.Model_getListOfReactions__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfReactions(cPtr, false);
  }

  
/**
   * Get the {@link ListOfEvents} object in this {@link Model}.
   <p>
   * @return the list of Events for this {@link Model}.
   */ public
 ListOfEvents getListOfEvents() {
    long cPtr = libsbmlJNI.Model_getListOfEvents__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfEvents(cPtr, false);
  }

  
/**
   * Get the nth FunctionDefinitions object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link FunctionDefinition} of this {@link Model}.
   */ public
 FunctionDefinition getFunctionDefinition(long n) {
    long cPtr = libsbmlJNI.Model_getFunctionDefinition__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, false);
  }

  
/**
   * Get a {@link FunctionDefinition} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link FunctionDefinition} in this {@link Model} with the identifier
   * <code>sid</code> or <code>null</code> if no such {@link FunctionDefinition} exists.
   */ public
 FunctionDefinition getFunctionDefinition(String sid) {
    long cPtr = libsbmlJNI.Model_getFunctionDefinition__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, false);
  }

  
/**
   * Get the nth {@link UnitDefinition} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link UnitDefinition} of this {@link Model}.
   */ public
 UnitDefinition getUnitDefinition(long n) {
    long cPtr = libsbmlJNI.Model_getUnitDefinition__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
/**
   * Get a {@link UnitDefinition} based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link UnitDefinition} in this {@link Model} with the identifier <code>sid</code> or
   * <code>null</code> if no such {@link UnitDefinition} exists.
   */ public
 UnitDefinition getUnitDefinition(String sid) {
    long cPtr = libsbmlJNI.Model_getUnitDefinition__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
/**
   * Get the nth {@link CompartmentType} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link CompartmentType} of this {@link Model}.
   <p>
   * @note The {@link CompartmentType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 CompartmentType getCompartmentType(long n) {
    long cPtr = libsbmlJNI.Model_getCompartmentType__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, false);
  }

  
/**
   * Get a {@link CompartmentType} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link CompartmentType} in this {@link Model} with the identifier <code>sid</code>
   * or <code>null</code> if no such {@link CompartmentType} exists.
   <p>
   * @note The {@link CompartmentType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 CompartmentType getCompartmentType(String sid) {
    long cPtr = libsbmlJNI.Model_getCompartmentType__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, false);
  }

  
/**
   * Get the nth {@link SpeciesType} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link SpeciesType} of this {@link Model}.
   <p>
   * @note The {@link SpeciesType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 SpeciesType getSpeciesType(long n) {
    long cPtr = libsbmlJNI.Model_getSpeciesType__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, false);
  }

  
/**
   * Get a {@link SpeciesType} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link SpeciesType} in this {@link Model} with the identifier <code>sid</code> or
   * <code>null</code> if no such {@link SpeciesType} exists.
   <p>
   * @note The {@link SpeciesType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 SpeciesType getSpeciesType(String sid) {
    long cPtr = libsbmlJNI.Model_getSpeciesType__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, false);
  }

  
/**
   * Get the nth {@link Compartment} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link Compartment} of this {@link Model}.
   */ public
 Compartment getCompartment(long n) {
    long cPtr = libsbmlJNI.Model_getCompartment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Compartment(cPtr, false);
  }

  
/**
   * Get a {@link Compartment} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link Compartment} in this {@link Model} with the identifier <code>sid</code> or
   * <code>null</code> if no such {@link Compartment} exists.
   */ public
 Compartment getCompartment(String sid) {
    long cPtr = libsbmlJNI.Model_getCompartment__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Compartment(cPtr, false);
  }

  
/**
   * Get the nth {@link Species} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link Species} of this {@link Model}.
   */ public
 Species getSpecies(long n) {
    long cPtr = libsbmlJNI.Model_getSpecies__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Species(cPtr, false);
  }

  
/**
   * Get a {@link Species} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link Species} in this {@link Model} with the identifier <code>sid</code> or <code>null</code>
   * if no such {@link Species} exists.
   */ public
 Species getSpecies(String sid) {
    long cPtr = libsbmlJNI.Model_getSpecies__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Species(cPtr, false);
  }

  
/**
   * Get the nth {@link Parameter} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link Parameter} of this {@link Model}.
   */ public
 Parameter getParameter(long n) {
    long cPtr = libsbmlJNI.Model_getParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
/**
   * Get a {@link Parameter} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link Parameter} in this {@link Model} with the identifier <code>sid</code> or <code>null</code>
   * if no such {@link Parameter} exists.
   */ public
 Parameter getParameter(String sid) {
    long cPtr = libsbmlJNI.Model_getParameter__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
/**
   * Get the nth {@link InitialAssignment} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link InitialAssignment} of this {@link Model}.
   */ public
 InitialAssignment getInitialAssignment(long n) {
    long cPtr = libsbmlJNI.Model_getInitialAssignment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, false);
  }

  
/**
   * Get an {@link InitialAssignment} object based on the symbol to which it
   * assigns a value.
   <p>
   * @param symbol the symbol to search for.
   <p>
   * @return the {@link InitialAssignment} in this {@link Model} with the given 'symbol'
   * attribute value or <code>null</code> if no such {@link InitialAssignment} exists.
   */ public
 InitialAssignment getInitialAssignment(String symbol) {
    long cPtr = libsbmlJNI.Model_getInitialAssignment__SWIG_2(swigCPtr, this, symbol);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, false);
  }

  
/**
   * Get an {@link InitialAssignment} object based on the symbol to which it
   * assigns a value.
   <p>
   * @param symbol the symbol to search for.
   <p>
   * @return the {@link InitialAssignment} in this {@link Model} with the given 'symbol'
   * attribute value or <code>null</code> if no such {@link InitialAssignment} exists.
   */ public
 InitialAssignment getInitialAssignmentBySymbol(String symbol) {
    long cPtr = libsbmlJNI.Model_getInitialAssignmentBySymbol__SWIG_0(swigCPtr, this, symbol);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, false);
  }

  
/**
   * Get the nth {@link Rule} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link Rule} of this {@link Model}.
   */ public
 Rule getRule(long n) {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Model_getRule__SWIG_0(swigCPtr, this, n), false);
}

  
/**
   * Get a {@link Rule} object based on the variable to which it assigns a value.
   <p>
   * @param variable the variable to search for.
   <p>
   * @return the {@link Rule} in this {@link Model} with the given 'variable' attribute
   * value or <code>null</code> if no such {@link Rule} exists.
   */ public
 Rule getRule(String variable) {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Model_getRule__SWIG_2(swigCPtr, this, variable), false);
}

  
/**
   * Get a {@link Rule} object based on the variable to which it assigns a value.
   <p>
   * @param variable the variable to search for.
   <p>
   * @return the {@link Rule} in this {@link Model} with the given 'variable' attribute
   * value or <code>null</code> if no such {@link Rule} exists.
   */ public
 Rule getRuleByVariable(String variable) {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Model_getRuleByVariable__SWIG_0(swigCPtr, this, variable), false);
}

  
/**
   * Get a {@link Rule} object based on the variable to which it assigns a value.
   <p>
   * @param variable the variable to search for.
   <p>
   * @return the {@link Rule} in this {@link Model} with the given 'variable' attribute
   * value or <code>null</code> if no such {@link Rule} exists.
   */ public
 AssignmentRule getAssignmentRule(String variable) {
    long cPtr = libsbmlJNI.Model_getAssignmentRule__SWIG_0(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new AssignmentRule(cPtr, false);
  }

  
/**
   * Get a {@link Rule} object based on the variable to which it assigns a value.
   <p>
   * @param variable the symbol to search for.
   <p>
   * @return the {@link Rule} in this {@link Model} with the given 'variable' attribute
   * value or <code>null</code> if no such {@link Rule} exists.
   */ public
 RateRule getRateRule(String variable) {
    long cPtr = libsbmlJNI.Model_getRateRule__SWIG_0(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new RateRule(cPtr, false);
  }

  
/**
   * Get a {@link Rule} object based on the variable to which it assigns a value.
   <p>
   * @param variable the variable to search for.
   <p>
   * @return the {@link Rule} in this {@link Model} with the given 'variable' attribute
   * value or <code>null</code> if no such {@link Rule} exists.
   */ public
 AssignmentRule getAssignmentRuleByVariable(String variable) {
    long cPtr = libsbmlJNI.Model_getAssignmentRuleByVariable__SWIG_0(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new AssignmentRule(cPtr, false);
  }

  
/**
   * Get a {@link Rule} object based on the variable to which it assigns a value.
   <p>
   * @param variable the variable to search for.
   <p>
   * @return the {@link Rule} in this {@link Model} with the given 'variable' attribute
   * value or <code>null</code> if no such {@link Rule} exists.
   */ public
 RateRule getRateRuleByVariable(String variable) {
    long cPtr = libsbmlJNI.Model_getRateRuleByVariable__SWIG_0(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new RateRule(cPtr, false);
  }

  
/**
   * Get the nth {@link Constraint} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link Constraint} of this {@link Model}.
   */ public
 Constraint getConstraint(long n) {
    long cPtr = libsbmlJNI.Model_getConstraint__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  
/**
   * Get the nth {@link Reaction} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link Reaction} of this {@link Model}.
   */ public
 Reaction getReaction(long n) {
  return (Reaction) libsbml.DowncastSBase(libsbmlJNI.Model_getReaction__SWIG_0(swigCPtr, this, n), false);
}

  
/**
   * Get a {@link Reaction} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link Reaction} in this {@link Model} with the identifier <code>sid</code> or <code>null</code>
   * if no such {@link Reaction} exists.
   */ public
 Reaction getReaction(String sid) {
  return (Reaction) libsbml.DowncastSBase(libsbmlJNI.Model_getReaction__SWIG_2(swigCPtr, this, sid), false);
}

  
/**
   * Get a {@link SpeciesReference} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link SpeciesReference} in this {@link Model} with the identifier <code>sid</code> or <code>null</code>
   * if no such {@link SpeciesReference} exists.
   */ public
 SpeciesReference getSpeciesReference(String sid) {
    long cPtr = libsbmlJNI.Model_getSpeciesReference__SWIG_0(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Get a {@link ModifierSpeciesReference} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link ModifierSpeciesReference} in this {@link Model} with the 
   * identifier <code>sid</code> or <code>null</code>
   * if no such {@link ModifierSpeciesReference} exists.
   */ public
 ModifierSpeciesReference getModifierSpeciesReference(String sid) {
    long cPtr = libsbmlJNI.Model_getModifierSpeciesReference__SWIG_0(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
/**
   * Get the nth {@link Event} object in this {@link Model}.
   <p>
   * @param n the index of the object to return.
   <p>
   * @return the nth {@link Event} of this {@link Model}.
   */ public
 Event getEvent(long n) {
    long cPtr = libsbmlJNI.Model_getEvent__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Event(cPtr, false);
  }

  
/**
   * Get an {@link Event} object based on its identifier.
   <p>
   * @param sid the identifier to search for.
   <p>
   * @return the {@link Event} in this {@link Model} with the identifier <code>sid</code> or <code>null</code> if
   * no such {@link Event} exists.
   */ public
 Event getEvent(String sid) {
    long cPtr = libsbmlJNI.Model_getEvent__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Event(cPtr, false);
  }

  
/**
   * Get the number of {@link FunctionDefinition} objects in this {@link Model}.
   <p>
   * @return the number of FunctionDefinitions in this {@link Model}.
   */ public
 long getNumFunctionDefinitions() {
    return libsbmlJNI.Model_getNumFunctionDefinitions(swigCPtr, this);
  }

  
/**
   * Get the number of {@link UnitDefinition} objects in this {@link Model}.
   <p>
   * @return the number of UnitDefinitions in this {@link Model}.
   */ public
 long getNumUnitDefinitions() {
    return libsbmlJNI.Model_getNumUnitDefinitions(swigCPtr, this);
  }

  
/**
   * Get the number of {@link CompartmentType} objects in this {@link Model}.
   <p>
   * @return the number of CompartmentTypes in this {@link Model}.
   <p>
   * @note The {@link CompartmentType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 long getNumCompartmentTypes() {
    return libsbmlJNI.Model_getNumCompartmentTypes(swigCPtr, this);
  }

  
/**
   * Get the number of {@link SpeciesType} objects in this {@link Model}.
   <p>
   * @return the number of SpeciesTypes in this {@link Model}.
   <p>
   * @note The {@link SpeciesType} object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 long getNumSpeciesTypes() {
    return libsbmlJNI.Model_getNumSpeciesTypes(swigCPtr, this);
  }

  
/**
   * Get the number of {@link Compartment} objects in this {@link Model}.
   <p>
   * @return the number of Compartments in this {@link Model}.
   */ public
 long getNumCompartments() {
    return libsbmlJNI.Model_getNumCompartments(swigCPtr, this);
  }

  
/**
   * Get the number of {@link Species} objects in this {@link Model}.
   <p>
   * @return the number of {@link Species} in this {@link Model}.
   */ public
 long getNumSpecies() {
    return libsbmlJNI.Model_getNumSpecies(swigCPtr, this);
  }

  
/**
   * Get the number of {@link Species} in this {@link Model} having their
   * 'boundaryCondition' attribute value set to <code>true.</code>
   <p>
   * @return the number of {@link Species} in this {@link Model} with boundaryCondition set
   * to true.
   */ public
 long getNumSpeciesWithBoundaryCondition() {
    return libsbmlJNI.Model_getNumSpeciesWithBoundaryCondition(swigCPtr, this);
  }

  
/**
   * Get the number of {@link Parameter} objects in this {@link Model}.
   <p>
   * @return the number of Parameters in this {@link Model}.  Parameters defined in
   * KineticLaws are not included.
   */ public
 long getNumParameters() {
    return libsbmlJNI.Model_getNumParameters(swigCPtr, this);
  }

  
/**
   * Get the number of {@link InitialAssignment} objects in this {@link Model}.
   <p>
   * @return the number of InitialAssignments in this {@link Model}.
   */ public
 long getNumInitialAssignments() {
    return libsbmlJNI.Model_getNumInitialAssignments(swigCPtr, this);
  }

  
/**
   * Get the number of {@link Rule} objects in this {@link Model}.
   <p>
   * @return the number of Rules in this {@link Model}.
   */ public
 long getNumRules() {
    return libsbmlJNI.Model_getNumRules(swigCPtr, this);
  }

  
/**
   * Get the number of {@link Constraint} objects in this {@link Model}.
   <p>
   * @return the number of Constraints in this {@link Model}.
   */ public
 long getNumConstraints() {
    return libsbmlJNI.Model_getNumConstraints(swigCPtr, this);
  }

  
/**
   * Get the number of {@link Reaction} objects in this {@link Model}.
   <p>
   * @return the number of Reactions in this {@link Model}.
   */ public
 long getNumReactions() {
    return libsbmlJNI.Model_getNumReactions(swigCPtr, this);
  }

  
/**
   * Get the number of {@link Event} objects in this {@link Model}.
   <p>
   * @return the number of Events in this {@link Model}.
   */ public
 long getNumEvents() {
    return libsbmlJNI.Model_getNumEvents(swigCPtr, this);
  }

  
/**
   * Remove this {@link Model} from its parent {@link SBMLDocument} object.
   <p>
   * This works by finding this {@link Model}'s parent {@link SBMLDocument} and then calling
   * <code>setModel(null)</code> on it, indirectly deleting itself.
   * Overridden from the {@link SBase} function since the parent is not a {@link ListOf}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int removeFromParentAndDelete() {
    return libsbmlJNI.Model_removeFromParentAndDelete(swigCPtr, this);
  }

  
/** * @internal */ public
 int renameAllIds(IdentifierTransformer idTransformer, ElementFilter filter) {
    return libsbmlJNI.Model_renameAllIds__SWIG_0(swigCPtr, this, IdentifierTransformer.getCPtr(idTransformer), idTransformer, ElementFilter.getCPtr(filter), filter);
  }

  
/** * @internal */ public
 int renameAllIds(IdentifierTransformer idTransformer) {
    return libsbmlJNI.Model_renameAllIds__SWIG_1(swigCPtr, this, IdentifierTransformer.getCPtr(idTransformer), idTransformer);
  }

  
/**
   * <p>
 * Replaces all uses of a given <code>SIdRef</code> type attribute value with another
 * value.
 <p>
 * <p>
 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of <code>oldid</code>.  If any matches are found, the
 * matching values are replaced with <code>newid</code>.  The method does <em>not</em>
 * descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.Model_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * <p>
 * Replaces all uses of a given <code>UnitSIdRef</code> type attribute value with
 * another value.
 <p>
 * <p>
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of <code>oldid</code>.  If any matches
 * are found, the matching values are replaced with <code>newid</code>.  The method
 * does <em>not</em> descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.Model_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/** * @internal */ public
 void convertL1ToL2() {
    libsbmlJNI.Model_convertL1ToL2(swigCPtr, this);
  }

  
/** * @internal */ public
 void convertL1ToL3(boolean addDefaultUnits) {
    libsbmlJNI.Model_convertL1ToL3__SWIG_0(swigCPtr, this, addDefaultUnits);
  }

  
/** * @internal */ public
 void convertL1ToL3() {
    libsbmlJNI.Model_convertL1ToL3__SWIG_1(swigCPtr, this);
  }

  
/** * @internal */ public
 void convertL2ToL3(boolean strict, boolean addDefaultUnits) {
    libsbmlJNI.Model_convertL2ToL3__SWIG_0(swigCPtr, this, strict, addDefaultUnits);
  }

  
/** * @internal */ public
 void convertL2ToL3(boolean strict) {
    libsbmlJNI.Model_convertL2ToL3__SWIG_1(swigCPtr, this, strict);
  }

  
/** * @internal */ public
 void convertL2ToL3() {
    libsbmlJNI.Model_convertL2ToL3__SWIG_2(swigCPtr, this);
  }

  
/** * @internal */ public
 void convertL2ToL1(boolean strict) {
    libsbmlJNI.Model_convertL2ToL1__SWIG_0(swigCPtr, this, strict);
  }

  
/** * @internal */ public
 void convertL2ToL1() {
    libsbmlJNI.Model_convertL2ToL1__SWIG_1(swigCPtr, this);
  }

  
/** * @internal */ public
 void convertL3ToL1(boolean strict) {
    libsbmlJNI.Model_convertL3ToL1__SWIG_0(swigCPtr, this, strict);
  }

  
/** * @internal */ public
 void convertL3ToL1() {
    libsbmlJNI.Model_convertL3ToL1__SWIG_1(swigCPtr, this);
  }

  
/** * @internal */ public
 void convertL3ToL2(boolean strict) {
    libsbmlJNI.Model_convertL3ToL2__SWIG_0(swigCPtr, this, strict);
  }

  
/** * @internal */ public
 void convertL3ToL2() {
    libsbmlJNI.Model_convertL3ToL2__SWIG_1(swigCPtr, this);
  }

  
/** * @internal */ public
 void convertFromL3V2(boolean strict) {
    libsbmlJNI.Model_convertFromL3V2__SWIG_0(swigCPtr, this, strict);
  }

  
/** * @internal */ public
 void convertFromL3V2() {
    libsbmlJNI.Model_convertFromL3V2__SWIG_1(swigCPtr, this);
  }

  
/** * @internal */ public
 void dealWithFast() {
    libsbmlJNI.Model_dealWithFast(swigCPtr, this);
  }

  
/** * @internal */ public
 void addModifiers() {
    libsbmlJNI.Model_addModifiers(swigCPtr, this);
  }

  
/** * @internal */ public
 void addConstantAttribute() {
    libsbmlJNI.Model_addConstantAttribute(swigCPtr, this);
  }

  
/** * @internal */ public
 void setSpatialDimensions(double dims) {
    libsbmlJNI.Model_setSpatialDimensions__SWIG_0(swigCPtr, this, dims);
  }

  
/** * @internal */ public
 void setSpatialDimensions() {
    libsbmlJNI.Model_setSpatialDimensions__SWIG_1(swigCPtr, this);
  }

  
/** * @internal */ public
 void addDefinitionsForDefaultUnits() {
    libsbmlJNI.Model_addDefinitionsForDefaultUnits(swigCPtr, this);
  }

  
/** * @internal */ public
 void dealWithDefaultValues() {
    libsbmlJNI.Model_dealWithDefaultValues(swigCPtr, this);
  }

  
/** * @internal */ public
 void convertParametersToLocals(long level, long version) {
    libsbmlJNI.Model_convertParametersToLocals(swigCPtr, this, level, version);
  }

  
/** * @internal */ public
 void setSpeciesReferenceConstantValueAndStoichiometry() {
    libsbmlJNI.Model_setSpeciesReferenceConstantValueAndStoichiometry(swigCPtr, this);
  }

  
/** * @internal */ public
 void removeParameterRuleUnits(boolean strict) {
    libsbmlJNI.Model_removeParameterRuleUnits(swigCPtr, this, strict);
  }

  
/** * @internal */ public
 void convertStoichiometryMath() {
    libsbmlJNI.Model_convertStoichiometryMath(swigCPtr, this);
  }

  
/** * @internal */ public
 void assignRequiredValues() {
    libsbmlJNI.Model_assignRequiredValues(swigCPtr, this);
  }

  
/** * @internal */ public
 void dealWithModelUnits(boolean strict) {
    libsbmlJNI.Model_dealWithModelUnits__SWIG_0(swigCPtr, this, strict);
  }

  
/** * @internal */ public
 void dealWithModelUnits() {
    libsbmlJNI.Model_dealWithModelUnits__SWIG_1(swigCPtr, this);
  }

  
/** * @internal */ public
 void dealWithStoichiometry() {
    libsbmlJNI.Model_dealWithStoichiometry(swigCPtr, this);
  }

  
/** * @internal */ public
 void dealWithEvents(boolean strict) {
    libsbmlJNI.Model_dealWithEvents(swigCPtr, this, strict);
  }

  
/** * @internal */ public
 void removeSpeciesTypes() {
    libsbmlJNI.Model_removeSpeciesTypes(swigCPtr, this);
  }

  
/** * @internal */ public
 void removeCompartmentTypes() {
    libsbmlJNI.Model_removeCompartmentTypes(swigCPtr, this);
  }

  public void connectToChild() {
    libsbmlJNI.Model_connectToChild(swigCPtr, this);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the <code>getPackageName()</code>
 * method on the object.
   <p>
   * @return the SBML type code for this object:
   * {@link libsbmlConstants#SBML_MODEL SBML_MODEL} (default).
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
   <p>
   * @see #getElementName()
   * @see #getPackageName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.Model_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object, which for {@link Model}, is
   * always <code>'model'.</code>
   <p>
   * @return the name of this element, i.e., <code>'model'.</code>
   */ public
 String getElementName() {
    return libsbmlJNI.Model_getElementName(swigCPtr, this);
  }

  
/**
   * Populates the internal list of derived units for this {@link Model} object.
   <p>
   * This method tells libSBML to (re)calculate all units for all components
   * of the enclosing {@link Model} object.  The result is stored in an internal list
   * of unit data.  Users can access the resulting data by calling the method
   * {@link SBase#getDerivedUnitDefinition()} available on most objects.  (The name
   * 'formula units data' is drawn from the name of the internal objects
   * libSBML uses to store the data; note that these internal objects are not
   * exposed to callers, because callers can interact with the results using
   * the ordinary SBML unit objects.)
   <p>
   * This method is used by libSBML itself in the validator concerned with
   * unit consistency.  The unit consistency validator (like all other
   * validators in libSBML) is invoked by using
   * {@link SBMLDocument#checkConsistency()}, with the consistency checks for the
   * category {@link libsbmlConstants#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY} turned on.  The method
   * populateListFormulaUnitsData() does not need to be called prior to
   * invoking the validator if unit consistency checking has not been turned
   * off.  This method is only provided for cases when callers have a special
   * need to force the unit data to be recalculated.  For instance, during
   * construction of a model, a caller may want to interrogate libSBML's
   * inferred units without invoking full-blown model validation; this is a
   * scenario in which calling populateListFormulaUnitsData() may be useful.
   <p>
   * @warning Computing and inferring units is a time-consuming operation.
   * Callers may want to call isPopulatedListFormulaUnitsData() to determine
   * whether the units may already have been computed, to save themselves the
   * need of invoking unit inference unnecessarily.
   <p>
   * @see #isPopulatedListFormulaUnitsData()
   */ public
 void populateListFormulaUnitsData() {
    libsbmlJNI.Model_populateListFormulaUnitsData(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if libSBML has derived units for the
   * components of this model.
   <p>
   * LibSBML can infer the units of measurement associated with different
   * elements of a model.  When libSBML does that, it builds a complex
   * internal structure during a resource-intensive operation.  This is done
   * automatically only when callers invoke validation (via
   * {@link SBMLDocument#checkConsistency()}) and have not turned off the unit
   * validation option.
   <p>
   * Callers can force units to be recalculated by calling
   * populateListFormulaUnitsData().  To avoid calling that method
   * unnecessarily, calling programs may first want to invoke this method
   * (isPopulatedListFormulaUnitsData()) to determine whether it is even
   * necessary.
   <p>
   * @return <code>true</code> if the units have already been computed, <code>false</code>
   * otherwise.
   */ public
 boolean isPopulatedListFormulaUnitsData() {
    return libsbmlJNI.Model_isPopulatedListFormulaUnitsData(swigCPtr, this);
  }

  
/** * @internal */ public
 SWIGTYPE_p_FormulaUnitsData getFormulaUnitsDataForVariable(String sid) {
    long cPtr = libsbmlJNI.Model_getFormulaUnitsDataForVariable(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new SWIGTYPE_p_FormulaUnitsData(cPtr, false);
  }

  
/** * @internal */ public
 SWIGTYPE_p_FormulaUnitsData getFormulaUnitsDataForAssignment(String sid) {
    long cPtr = libsbmlJNI.Model_getFormulaUnitsDataForAssignment(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new SWIGTYPE_p_FormulaUnitsData(cPtr, false);
  }

  
/**
   * Populates the internal list of the identifiers of all elements within this {@link Model} object.
   <p>
   * This method tells libSBML to retrieve the identifiers of all elements
   * of the enclosing {@link Model} object.  The result is stored in an internal list
   * of ids.  Users can access the resulting data by calling the method
   * getAllElementIdList().
   <p>
   * @warning Retrieving all elements within a model is a time-consuming operation.
   * Callers may want to call isPopulatedAllElementIdList() to determine
   * whether the id list may already have been populated.
   <p>
   * @see #isPopulatedAllElementIdList()
   */ public
 void populateAllElementIdList() {
    libsbmlJNI.Model_populateAllElementIdList(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if libSBML has a list of the ids of all 
   * components of this model.
   <p>
   * @return <code>true</code> if the id list has already been populated, <code>false</code>
   * otherwise.
   */ public
 boolean isPopulatedAllElementIdList() {
    return libsbmlJNI.Model_isPopulatedAllElementIdList(swigCPtr, this);
  }

  
/**
   * Returns the internal list of the identifiers of all elements within this {@link Model} object.
   <p>
   * @return an IdList of all the identifiers in the model.
   <p>
   * @see #populateAllElementIdList()
   * @see #isPopulatedAllElementIdList()
   */ public
 IdList getAllElementIdList() {
    return new IdList(libsbmlJNI.Model_getAllElementIdList(swigCPtr, this), true);
  }

  
/**
   * Clears the internal list of the identifiers of all elements within this {@link Model} object.
   <p>
   * @see #populateAllElementIdList()
   * @see #isPopulatedAllElementIdList()
   */ public
 void clearAllElementIdList() {
    libsbmlJNI.Model_clearAllElementIdList(swigCPtr, this);
  }

  
/**
   * Populates the internal list of the metaids of all elements within this {@link Model} object.
   <p>
   * This method tells libSBML to retrieve the identifiers of all elements
   * of the enclosing {@link Model} object.  The result is stored in an internal list
   * of metaids.  Users can access the resulting data by calling the method
   * getAllElementMetaIdList().
   <p>
   * @warning Retrieving all elements within a model is a time-consuming operation.
   * Callers may want to call isPopulatedAllElementMetaIdList() to determine
   * whether the metaid list may already have been populated.
   <p>
   * @see #isPopulatedAllElementMetaIdList()
   */ public
 void populateAllElementMetaIdList() {
    libsbmlJNI.Model_populateAllElementMetaIdList(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if libSBML has a list of the metaids of all 
   * components of this model.
   <p>
   * @return <code>true</code> if the metaid list has already been populated, <code>false</code>
   * otherwise.
   */ public
 boolean isPopulatedAllElementMetaIdList() {
    return libsbmlJNI.Model_isPopulatedAllElementMetaIdList(swigCPtr, this);
  }

  
/**
   * Returns the internal list of the metaids of all elements within this {@link Model} object.
   <p>
   * @return an IdList of all the metaids in the model.
   <p>
   * @see #populateAllElementMetaIdList()
   * @see #isPopulatedAllElementMetaIdList()
   */ public
 IdList getAllElementMetaIdList() {
    return new IdList(libsbmlJNI.Model_getAllElementMetaIdList(swigCPtr, this), true);
  }

  
/**
   * Clears the internal list of the metaids of all elements within this {@link Model} object.
   <p>
   * @see #populateAllElementMetaIdList()
   * @see #isPopulatedAllElementMetaIdList()
   */ public
 void clearAllElementMetaIdList() {
    libsbmlJNI.Model_clearAllElementMetaIdList(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required elements for this {@link Model}
   * object have been set.
   <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */ public
 boolean hasRequiredElements() {
    return libsbmlJNI.Model_hasRequiredElements(swigCPtr, this);
  }

  
/**
   * Removes the nth {@link FunctionDefinition} object from this {@link Model} object and 
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link FunctionDefinition} object to remove.
   <p>
   * @return the {@link FunctionDefinition} object removed, or <code>null</code> if the given
   * index is out of range.
   */ public
 FunctionDefinition removeFunctionDefinition(long n) {
    long cPtr = libsbmlJNI.Model_removeFunctionDefinition__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, true);
  }

  
/**
   * Removes the {@link FunctionDefinition} object with the given identifier from this {@link Model} 
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link FunctionDefinition} object to remove.
   <p>
   * @return the {@link FunctionDefinition} object removed, or <code>null</code> if no
   * {@link FunctionDefinition} object with the identifier exists in this {@link Model}
   * object.
   */ public
 FunctionDefinition removeFunctionDefinition(String sid) {
    long cPtr = libsbmlJNI.Model_removeFunctionDefinition__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, true);
  }

  
/**
   * Removes the nth {@link UnitDefinition} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link UnitDefinition} object to remove.
   <p>
   * @return the {@link UnitDefinition} object removed., or <code>null</code> if the given
   * index is out of range.
   */ public
 UnitDefinition removeUnitDefinition(long n) {
    long cPtr = libsbmlJNI.Model_removeUnitDefinition__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, true);
  }

  
/**
   * Removes the {@link UnitDefinition} object with the given identifier from this {@link Model}
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link UnitDefinition} object to remove.
   <p>
   * @return the {@link UnitDefinition} object removed, or <code>null</code> if no
   * {@link UnitDefinition} object with the identifier exists in this {@link Model} object.
   */ public
 UnitDefinition removeUnitDefinition(String sid) {
    long cPtr = libsbmlJNI.Model_removeUnitDefinition__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, true);
  }

  
/**
   * Removes the nth {@link CompartmentType} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link CompartmentType} object to remove.
   <p>
   * @return the ComapartmentType object removed, or <code>null</code> if the given
   * index is out of range.
   */ public
 CompartmentType removeCompartmentType(long n) {
    long cPtr = libsbmlJNI.Model_removeCompartmentType__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, true);
  }

  
/**
   * Removes the {@link CompartmentType} object with the given identifier from this {@link Model}
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the object to remove.
   <p>
   * @return the {@link CompartmentType} object removed, or <code>null</code> if no
   * {@link CompartmentType} object with the identifier exists in this {@link Model} object.
   */ public
 CompartmentType removeCompartmentType(String sid) {
    long cPtr = libsbmlJNI.Model_removeCompartmentType__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, true);
  }

  
/**
   * Removes the nth {@link SpeciesType} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link SpeciesType} object to remove.
   <p>
   * @return the {@link SpeciesType} object removed, or <code>null</code> if the given index is
   * out of range.
   */ public
 SpeciesType removeSpeciesType(long n) {
    long cPtr = libsbmlJNI.Model_removeSpeciesType__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, true);
  }

  
/**
   * Removes the {@link SpeciesType} object with the given identifier from this {@link Model}
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link SpeciesType} object to remove.
   <p>
   * @return the {@link SpeciesType} object removed, or <code>null</code> if no {@link SpeciesType}
   * object with the identifier exists in this {@link Model} object.
   */ public
 SpeciesType removeSpeciesType(String sid) {
    long cPtr = libsbmlJNI.Model_removeSpeciesType__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, true);
  }

  
/**
   * Removes the nth {@link Compartment} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link Compartment} object to remove.
   <p>
   * @return the {@link Compartment} object removed, or <code>null</code> if the given index is
   * out of range.
   */ public
 Compartment removeCompartment(long n) {
    long cPtr = libsbmlJNI.Model_removeCompartment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Compartment(cPtr, true);
  }

  
/**
   * Removes the {@link Compartment} object with the given identifier from this {@link Model}
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link Compartment} object to remove.
   <p>
   * @return the {@link Compartment} object removed, or <code>null</code> if no {@link Compartment}
   * object with the identifier exists in this {@link Model} object.
   */ public
 Compartment removeCompartment(String sid) {
    long cPtr = libsbmlJNI.Model_removeCompartment__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Compartment(cPtr, true);
  }

  
/**
   * Removes the nth {@link Species} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link Species} object to remove.
   <p>
   * @return the {@link Species} object removed, or <code>null</code> if the given index is out
   * of range.
   */ public
 Species removeSpecies(long n) {
    long cPtr = libsbmlJNI.Model_removeSpecies__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Species(cPtr, true);
  }

  
/**
   * Removes the {@link Species} object with the given identifier from this {@link Model}
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link Species} object to remove.
   <p>
   * @return the {@link Species} object removed, or <code>null</code> if no {@link Species} object with
   * the identifier exists in this {@link Model} object.
   */ public
 Species removeSpecies(String sid) {
    long cPtr = libsbmlJNI.Model_removeSpecies__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Species(cPtr, true);
  }

  
/**
   * Removes the nth {@link Parameter} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link Parameter} object to remove.
   <p>
   * @return the {@link Parameter} object removed, or <code>null</code> if the given index is
   * out of range.
   */ public
 Parameter removeParameter(long n) {
    long cPtr = libsbmlJNI.Model_removeParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Parameter(cPtr, true);
  }

  
/**
   * Removes the {@link Parameter} object with the given identifier from this {@link Model}
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link Parameter} object to remove.
   <p>
   * @return the {@link Parameter} object removed, or <code>null</code> if no {@link Parameter} object
   * with the identifier exists in this {@link Model} object.
   */ public
 Parameter removeParameter(String sid) {
    long cPtr = libsbmlJNI.Model_removeParameter__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Parameter(cPtr, true);
  }

  
/**
   * Removes the nth {@link InitialAssignment} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link InitialAssignment} object to remove.
   <p>
   * @return the {@link InitialAssignment} object removed, or <code>null</code> if the given
   * index is out of range.
   */ public
 InitialAssignment removeInitialAssignment(long n) {
    long cPtr = libsbmlJNI.Model_removeInitialAssignment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, true);
  }

  
/**
   * Removes the {@link InitialAssignment} object with the given 'symbol' attribute 
   * from this {@link Model} object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param symbol the 'symbol' attribute of the {@link InitialAssignment} object to remove.
   <p>
   * @return the {@link InitialAssignment} object removed, or <code>null</code> if no
   * {@link InitialAssignment} object with the 'symbol' attribute exists in this
   * {@link Model} object.
   */ public
 InitialAssignment removeInitialAssignment(String symbol) {
    long cPtr = libsbmlJNI.Model_removeInitialAssignment__SWIG_1(swigCPtr, this, symbol);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, true);
  }

  
/**
   * Removes the nth {@link Rule} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link Rule} object to remove.
   <p>
   * @return the {@link Rule} object removed, or <code>null</code> if the given index is out of
   * range.
   */ public
 Rule removeRule(long n) {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Model_removeRule__SWIG_0(swigCPtr, this, n), true);
}

  
/**
   * Removes the {@link Rule} object with the given 'variable' attribute from this {@link Model} 
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param variable the 'variable' attribute of the {@link Rule} object to remove.
   <p>
   * @return the {@link Rule} object removed, or <code>null</code> if no {@link Rule} object with the
   * 'variable' attribute exists in this {@link Model} object.
   */ public
 Rule removeRule(String variable) {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Model_removeRule__SWIG_1(swigCPtr, this, variable), true);
}

  
/**
   * Removes the {@link Rule} object with the given 'variable' attribute from this {@link Model} 
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param variable the 'variable' attribute of the {@link Rule} object to remove.
   <p>
   * @return the {@link Rule} object removed, or <code>null</code> if no {@link Rule} object with the
   * 'variable' attribute exists in this {@link Model} object.
   */ public
 Rule removeRuleByVariable(String variable) {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Model_removeRuleByVariable(swigCPtr, this, variable), false);
}

  
/**
   * Removes the nth {@link Constraint} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link Constraint} object to remove.
   <p>
   * @return the {@link Constraint} object removed, or <code>null</code> if the given index is
   * out of range.
   */ public
 Constraint removeConstraint(long n) {
    long cPtr = libsbmlJNI.Model_removeConstraint(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Constraint(cPtr, true);
  }

  
/**
   * Removes the nth {@link Reaction} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link Reaction} object to remove.
   <p>
   * @return the {@link Reaction} object removed, or <code>null</code> if the given index is
   * out of range.
   */ public
 Reaction removeReaction(long n) {
  return (Reaction) libsbml.DowncastSBase(libsbmlJNI.Model_removeReaction__SWIG_0(swigCPtr, this, n), true);
}

  
/**
   * Removes the {@link Reaction} object with the given identifier from this {@link Model}
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link Reaction} object to remove.
   <p>
   * @return the {@link Reaction} object removed, or <code>null</code> if no {@link Reaction} object
   * with the identifier exists in this {@link Model} object.
   */ public
 Reaction removeReaction(String sid) {
  return (Reaction) libsbml.DowncastSBase(libsbmlJNI.Model_removeReaction__SWIG_1(swigCPtr, this, sid), true);
}

  
/**
   * Removes the nth {@link Event} object from this {@link Model} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link Event} object to remove.
   <p>
   * @return the {@link Event} object removed, or <code>null</code> if the given index is out
   * of range.
   */ public
 Event removeEvent(long n) {
    long cPtr = libsbmlJNI.Model_removeEvent__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Event(cPtr, true);
  }

  
/**
   * Removes the {@link Event} object with the given identifier from this {@link Model}
   * object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link Event} object to remove.
   <p>
   * @return the {@link Event} object removed, or <code>null</code> if no {@link Event} object with the
   * identifier exists in this {@link Model} object.
   */ public
 Event removeEvent(String sid) {
    long cPtr = libsbmlJNI.Model_removeEvent__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Event(cPtr, true);
  }

  
/**
   * Copies a given {@link Model} object's subcomponents and appends the copies to
   * the appropriate places in this {@link Model}.
   <p>
   * This method also calls the <code>appendFrom</code> method on all libSBML
   * plug-in objects.
   <p>
   * <p>
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
   <p>
   * @param model the {@link Model} to merge with this one.
   */ public
 int appendFrom(Model model) {
    return libsbmlJNI.Model_appendFrom(swigCPtr, this, Model.getCPtr(model), model);
  }

  
/** * @internal */ public
 void enablePackageInternal(String pkgURI, String pkgPrefix, boolean flag) {
    libsbmlJNI.Model_enablePackageInternal(swigCPtr, this, pkgURI, pkgPrefix, flag);
  }

  public void renameIDs(SBaseList elements, IdentifierTransformer idTransformer) {
    libsbmlJNI.Model_renameIDs(swigCPtr, this, SBaseList.getCPtr(elements), elements, IdentifierTransformer.getCPtr(idTransformer), idTransformer);
  }

}
