///  @file    TestL3LocalParameter.cs
///  @brief   L3 Local Parameter unit tests
///  @author  Frank Bergmann (Csharp conversion)
///  @author  Akiya Jouraku (Csharp conversion)
///  @author  Sarah Keating 
/// 
/// 
///  ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
/// 
///  DO NOT EDIT THIS FILE.
/// 
///  This file was generated automatically by converting the file located at
///  src/sbml/test/TestL3LocalParameter.c
///  using the conversion program dev/utilities/translateTests/translateTests.pl.
///  Any changes made here will be lost the next time the file is regenerated.
/// 
///  -----------------------------------------------------------------------------
///  This file is part of libSBML.  Please visit http://sbml.org for more
///  information about SBML, and the latest version of libSBML.
/// 
///  Copyright 2005-2010 California Institute of Technology.
///  Copyright 2002-2005 California Institute of Technology and
///                      Japan Science and Technology Corporation.
///  
///  This library is free software; you can redistribute it and/or modify it
///  under the terms of the GNU Lesser General Public License as published by
///  the Free Software Foundation.  A copy of the license agreement is provided
///  in the file named "LICENSE.txt" included with this software distribution
///  and also available online as http://sbml.org/software/libsbml/license.html
///  -----------------------------------------------------------------------------


namespace LibSBMLCSTest.sbml {

  using libsbmlcs;

  using System;

  using System.IO;

  public class TestL3LocalParameter {
    public class AssertionError : System.Exception 
    {
      public AssertionError() : base()
      {
        
      }
    }


    static void assertTrue(bool condition)
    {
      if (condition == true)
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        return;
      }
      else if ( (a == null) || (b == null) )
      {
        throw new AssertionError();
      }
      else if (a.Equals(b))
      {
        return;
      }
  
      throw new AssertionError();
    }

    static void assertNotEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        throw new AssertionError();
      }
      else if ( (a == null) || (b == null) )
      {
        return;
      }
      else if (a.Equals(b))
      {
        throw new AssertionError();
      }
    }

    static void assertEquals(bool a, bool b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(bool a, bool b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(int a, int b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(int a, int b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }

    private LocalParameter P;

    public void setUp()
    {
      P = new  LocalParameter(3,1);
      if (P == null);
      {
      }
    }

    public void tearDown()
    {
      P = null;
    }

    public void test_L3_LocalParameter_NS()
    {
      assertTrue( P.getNamespaces() != null );
      assertTrue( P.getNamespaces().getLength() == 1 );
      assertTrue((     "http://www.sbml.org/sbml/level3/version1/core" == P.getNamespaces().getURI(0) ));
    }

    public void test_L3_LocalParameter_create()
    {
      assertTrue( P.getTypeCode() == libsbml.SBML_LOCAL_PARAMETER );
      assertTrue( P.getMetaId() == "" );
      assertTrue( P.getNotes() == null );
      assertTrue( P.getAnnotation() == null );
      assertTrue( P.getId() == "" );
      assertTrue( P.getName() == "" );
      assertTrue( P.getUnits() == "" );
      assertEquals( true, double.IsNaN(P.getValue()) );
      assertEquals( false, P.isSetId() );
      assertEquals( false, P.isSetName() );
      assertEquals( false, P.isSetValue() );
      assertEquals( false, P.isSetUnits() );
    }

    public void test_L3_LocalParameter_createWithNS()
    {
      XMLNamespaces xmlns = new  XMLNamespaces();
      xmlns.add( "http://www.sbml.org", "testsbml");
      SBMLNamespaces sbmlns = new  SBMLNamespaces(3,1);
      sbmlns.addNamespaces(xmlns);
      LocalParameter p = new  LocalParameter(sbmlns);
      assertTrue( p.getTypeCode() == libsbml.SBML_LOCAL_PARAMETER );
      assertTrue( p.getMetaId() == "" );
      assertTrue( p.getNotes() == null );
      assertTrue( p.getAnnotation() == null );
      assertTrue( p.getLevel() == 3 );
      assertTrue( p.getVersion() == 1 );
      assertTrue( p.getNamespaces() != null );
      assertTrue( p.getNamespaces().getLength() == 2 );
      assertTrue( p.getId() == "" );
      assertTrue( p.getName() == "" );
      assertTrue( p.getUnits() == "" );
      assertEquals( true, double.IsNaN(p.getValue()) );
      assertEquals( false, p.isSetId() );
      assertEquals( false, p.isSetName() );
      assertEquals( false, p.isSetValue() );
      assertEquals( false, p.isSetUnits() );
      p = null;
    }

    public void test_L3_LocalParameter_free_NULL()
    {
    }

    public void test_L3_LocalParameter_hasRequiredAttributes()
    {
      LocalParameter p = new  LocalParameter(3,1);
      assertEquals( false, p.hasRequiredAttributes() );
      p.setId( "id");
      assertEquals( true, p.hasRequiredAttributes() );
      p = null;
    }

    public void test_L3_LocalParameter_id()
    {
      string id =  "mitochondria";
      assertEquals( false, P.isSetId() );
      P.setId(id);
      assertTrue(( id == P.getId() ));
      assertEquals( true, P.isSetId() );
      if (P.getId() == id);
      {
      }
    }

    public void test_L3_LocalParameter_name()
    {
      string name =  "My_Favorite_Factory";
      assertEquals( false, P.isSetName() );
      P.setName(name);
      assertTrue(( name == P.getName() ));
      assertEquals( true, P.isSetName() );
      if (P.getName() == name);
      {
      }
      P.unsetName();
      assertEquals( false, P.isSetName() );
      if (P.getName() != null);
      {
      }
    }

    public void test_L3_LocalParameter_units()
    {
      string units =  "volume";
      assertEquals( false, P.isSetUnits() );
      P.setUnits(units);
      assertTrue(( units == P.getUnits() ));
      assertEquals( true, P.isSetUnits() );
      if (P.getUnits() == units);
      {
      }
      P.unsetUnits();
      assertEquals( false, P.isSetUnits() );
      if (P.getUnits() != null);
      {
      }
    }

    public void test_L3_LocalParameter_value()
    {
      assertEquals( false, P.isSetValue() );
      assertEquals( true, double.IsNaN(P.getValue()) );
      P.setValue(1.5);
      assertEquals( true, P.isSetValue() );
      assertTrue( P.getValue() == 1.5 );
      P.unsetValue();
      assertEquals( false, P.isSetValue() );
      assertEquals( true, double.IsNaN(P.getValue()) );
    }

  }
}
