/*
 * @file    TestL3Trigger.java
 * @brief   SBML Trigger unit tests
 *
 * @author  Akiya Jouraku (Java conversion)
 * @author  Sarah Keating 
 * 
 * ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
 *
 * DO NOT EDIT THIS FILE.
 *
 * This file was generated automatically by converting the file located at
 * src/sbml/test/TestL3Trigger.c
 * using the conversion program dev/utilities/translateTests/translateTests.pl.
 * Any changes made here will be lost the next time the file is regenerated.
 *
 * -----------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright (C) 2020 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. University of Heidelberg, Heidelberg, Germany
 *     3. University College London, London, UK
 *
 * Copyright 2005-2010 California Institute of Technology.
 * Copyright 2002-2005 California Institute of Technology and
 *                     Japan Science and Technology Corporation.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * -----------------------------------------------------------------------------
 */

package org.sbml.libsbml.test.sbml;

import org.sbml.libsbml.*;

import java.io.File;
import java.lang.AssertionError;

public class TestL3Trigger {

  static void assertTrue(boolean condition) throws AssertionError
  {
    if (condition == true)
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      return;
    }
    else if ( (a == null) || (b == null) )
    {
      throw new AssertionError();
    }
    else if (a.equals(b))
    {
      return;
    }

    throw new AssertionError();
  }

  static void assertNotEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      throw new AssertionError();
    }
    else if ( (a == null) || (b == null) )
    {
      return;
    }
    else if (a.equals(b))
    {
      throw new AssertionError();
    }
  }

  static void assertEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(int a, int b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(int a, int b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }
  private Trigger T;

  protected void setUp() throws Exception
  {
    T = new  Trigger(3,1);
    if (T == null);
    {
    }
  }

  protected void tearDown() throws Exception
  {
    T = null;
  }

  public void test_L3Trigger_create()
  {
    assertTrue( T.getTypeCode() == libsbml.SBML_TRIGGER );
    assertTrue( T.getMetaId().equals("") == true );
    assertTrue( T.getNotes() == null );
    assertTrue( T.getAnnotation() == null );
    assertTrue( T.getMath() == null );
      assertTrue( T.getInitialValue() == true );
      assertTrue( T.getPersistent() == true );
      assertTrue( T.isSetInitialValue() == false );
      assertTrue( T.isSetPersistent() == false );
  }

  public void test_L3Trigger_setInitialValue()
  {
      int i = T.setInitialValue(false);
    assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( T.getInitialValue() == false );
      assertTrue( T.isSetInitialValue() == true );
      i = T.setInitialValue(true);
    assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( T.getInitialValue() == true );
      assertTrue( T.isSetInitialValue() == true );
  }

  public void test_L3Trigger_setInitialValue1()
  {
    Trigger t = new  Trigger(2,4);
      int i = t.setInitialValue(false);
      assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE );
      assertTrue( T.getInitialValue() == true );
      assertTrue( T.isSetInitialValue() == false );
    t = null;
  }

  public void test_L3Trigger_setPersistent()
  {
      int i = T.setPersistent(false);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( T.getPersistent() == false );
      assertTrue( T.isSetPersistent() == true );
      i = T.setPersistent(true);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( T.getPersistent() == true );
      assertTrue( T.isSetPersistent() == true );
  }

  public void test_L3Trigger_setPersistent1()
  {
    Trigger t = new  Trigger(2,4);
      int i = t.setPersistent(false);
      assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE );
      assertTrue( T.getPersistent() == true );
      assertTrue( T.isSetPersistent() == false );
    t = null;
  }

  /**
   * Loads the SWIG-generated libSBML Java module when this class is
   * loaded, or reports a sensible diagnostic message about why it failed.
   */
  static
  {
    String varname;
    String shlibname;

    if (System.getProperty("mrj.version") != null)
    {
      varname = "DYLD_LIBRARY_PATH";    // We're on a Mac.
      shlibname = "libsbmlj.jnilib and/or libsbml.dylib";
    }
    else
    {
      varname = "LD_LIBRARY_PATH";      // We're not on a Mac.
      shlibname = "libsbmlj.so and/or libsbml.so";
    }

    try
    {
      System.loadLibrary("sbmlj");
      // For extra safety, check that the jar file is in the classpath.
      Class.forName("org.sbml.libsbml.libsbml");
    }
    catch (SecurityException e)
    {
      e.printStackTrace();
      System.err.println("Could not load the libSBML library files due to a"+
                         " security exception.\n");
      System.exit(1);
    }
    catch (UnsatisfiedLinkError e)
    {
      e.printStackTrace();
      System.err.println("Error: could not link with the libSBML library files."+
                         " It is likely\nyour " + varname +
                         " environment variable does not include the directories\n"+
                         "containing the " + shlibname + " library files.\n");
      System.exit(1);
    }
    catch (ClassNotFoundException e)
    {
      e.printStackTrace();
      System.err.println("Error: unable to load the file libsbmlj.jar."+
                         " It is likely\nyour -classpath option and CLASSPATH" +
                         " environment variable\n"+
                         "do not include the path to libsbmlj.jar.\n");
      System.exit(1);
    }
  }
}

