#
# @file    TestListOf.py
# @brief   ListOf unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestListOf.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestListOf(unittest.TestCase):


  def test_ListOf_append(self):
    m = libsbml.Model(2,4)
    m.createCompartment()
    loc = m.getListOfCompartments()
    self.assertTrue( loc.size() == 1 )
    c = libsbml.Compartment(2,4)
    i = loc.append(c)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( loc.size() == 2 )
    sp = libsbml.Species(2,4)
    i = loc.append(sp)
    self.assertTrue( i == libsbml.LIBSBML_INVALID_OBJECT )
    self.assertTrue( loc.size() == 2 )
    _dummyList = [ m ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ sp ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ListOf_clear(self):
    lo = libsbml.ListOf(2,4)
    sp = libsbml.Species(2,4)
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    self.assertTrue( lo.size() == 5 )
    lo.clear(True)
    self.assertTrue( lo.size() == 0 )
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    lo.appendAndOwn(sp)
    self.assertTrue( lo.size() == 5 )
    elem = lo.get(0)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    elem = lo.get(1)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    elem = lo.get(2)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    elem = lo.get(3)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    elem = lo.get(4)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    lo.clear(False)
    self.assertTrue( lo.size() == 0 )
    _dummyList = [ lo ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ListOf_create(self):
    lo = libsbml.ListOf(2,4)
    self.assertTrue( lo.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( lo.getNotes() == None )
    self.assertTrue( lo.getAnnotation() == None )
    self.assertTrue( lo.getMetaId() == "" )
    self.assertTrue( lo.size() == 0 )
    _dummyList = [ lo ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ListOf_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ListOf_remove(self):
    lo = libsbml.ListOf(2,4)
    sp = libsbml.Species(2,4)
    self.assertTrue( lo.size() == 0 )
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    self.assertTrue( lo.size() == 5 )
    elem = lo.remove(0)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    elem = lo.remove(0)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    elem = lo.remove(0)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    elem = lo.remove(0)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    elem = lo.remove(0)
    _dummyList = [ elem ]; _dummyList[:] = []; del _dummyList
    self.assertTrue( lo.size() == 0 )
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    lo.append(sp)
    lo.appendAndOwn(sp)
    self.assertTrue( lo.size() == 5 )
    _dummyList = [ lo ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestListOf))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
