/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Class of object that encapsulates the properties of an SBML converter.
 * <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  It is a class used in
the implementation of extra functionality provided by libSBML.
</p>

 * <p>
 * The properties of SBML converters are communicated using objects of
 * class {@link ConversionProperties}, and within such objects, individual options
 * are encapsulated using {@link ConversionOption} objects.  The {@link ConversionProperties}
 * class provides numerous methods for setting and getting options.
 * <p>
 * {@link ConversionProperties} objects are also used to determine the target SBML
 * namespace when an SBML converter's behavior depends on the intended
 * Level+Version combination of SBML.  In addition, it is conceivable that
 * conversions may be affected by SBML Level&nbsp;3 packages being used
 * by an SBML document.  These, too, are communicated by the values of
 * the SBML namespaces set on a {@link ConversionProperties} object.
 * <p>
 * @see ConversionOption
 * @see SBMLNamespaces
 */

public class ConversionProperties {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected ConversionProperties(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(ConversionProperties obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (ConversionProperties obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_ConversionProperties(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  
/** 
   * Constructor that initializes the conversion properties
   * with a specific SBML target namespace.
   * <p>
   * @param targetNS the target namespace to convert to
   */ public
 ConversionProperties(SBMLNamespaces targetNS) {
    this(libsbmlJNI.new_ConversionProperties__SWIG_0(SBMLNamespaces.getCPtr(targetNS), targetNS), true);
  }

  
/** 
   * Constructor that initializes the conversion properties
   * with a specific SBML target namespace.
   * <p>
   * @param targetNS the target namespace to convert to
   */ public
 ConversionProperties() {
    this(libsbmlJNI.new_ConversionProperties__SWIG_1(), true);
  }

  
/** 
   * Copy constructor.
   * <p>
   * @param orig the object to copy.
   * <p>
   * @throws SBMLConstructorException 
   * Thrown if the argument <code>orig</code> is <code>null.</code>
   */ public
 ConversionProperties(ConversionProperties orig) {
    this(libsbmlJNI.new_ConversionProperties__SWIG_2(ConversionProperties.getCPtr(orig), orig), true);
  }

  
/** 
   * Creates and returns a deep copy of this {@link ConversionProperties} object.
   * <p>
   * @return a (deep) copy of this {@link ConversionProperties} object.
   */ public
 ConversionProperties cloneObject() {
    long cPtr = libsbmlJNI.ConversionProperties_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new ConversionProperties(cPtr, true);
  }

  
/**
   * Returns the current target SBML namespace.
   * <p>
   * @return the SBMLNamepaces object expressing the target namespace.
   */ public
 SBMLNamespaces getTargetNamespaces() {
  return libsbml.DowncastSBMLNamespaces(libsbmlJNI.ConversionProperties_getTargetNamespaces(swigCPtr, this), false);
}

  
/**
   * Returns <code>true</code> if the target SBML namespace has been set.
   * <p>
   * @return <code>true</code> if the target namespace has been set, <code>false</code>
   * otherwise.
   */ public
 boolean hasTargetNamespaces() {
    return libsbmlJNI.ConversionProperties_hasTargetNamespaces(swigCPtr, this);
  }

  
/** 
   * Sets the target namespace.
   * <p>
   * @param targetNS the target namespace to use.
   */ public
 void setTargetNamespaces(SBMLNamespaces targetNS) {
    libsbmlJNI.ConversionProperties_setTargetNamespaces(swigCPtr, this, SBMLNamespaces.getCPtr(targetNS), targetNS);
  }

  
/**
   * Returns the description string for a given option in this properties
   * object.
   * <p>
   * @param key the key for the option.
   * <p>
   * @return the description text of the option with the given key.
   */ public
 String getDescription(String key) {
    return libsbmlJNI.ConversionProperties_getDescription(swigCPtr, this, key);
  }

  
/**
   * Returns the type of a given option in this properties object.
   * <p>
   * @param key the key for the option.
   * <p>
   * @return the type of the option with the given key.
   */ public
 int getType(String key) {
    return libsbmlJNI.ConversionProperties_getType(swigCPtr, this, key);
  }

  
/**
   * Returns the {@link ConversionOption} object for a given key.
   * <p>
   * @param key the key for the option.
   * <p>
   * @return the option with the given key.
   */ public
 ConversionOption getOption(String key) {
    long cPtr = libsbmlJNI.ConversionProperties_getOption(swigCPtr, this, key);
    return (cPtr == 0) ? null : new ConversionOption(cPtr, false);
  }

  
/**
   * Adds a copy of the given option to this properties object.
   * <p>
   * @param option the option to add
   */ public
 void addOption(ConversionOption option) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_0(swigCPtr, this, ConversionOption.getCPtr(option), option);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value (optional) the value of that option
   * @param type (optional) the type of the option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, String value, int type, String description) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_1(swigCPtr, this, key, value, type, description);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value (optional) the value of that option
   * @param type (optional) the type of the option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, String value, int type) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_2(swigCPtr, this, key, value, type);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value (optional) the value of that option
   * @param type (optional) the type of the option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, String value) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_3(swigCPtr, this, key, value);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value (optional) the value of that option
   * @param type (optional) the type of the option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_4(swigCPtr, this, key);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the string value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, String value, String description) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_5(swigCPtr, this, key, value, description);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the boolean value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, boolean value, String description) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_7(swigCPtr, this, key, value, description);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the boolean value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, boolean value) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_8(swigCPtr, this, key, value);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the double value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, double value, String description) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_9(swigCPtr, this, key, value, description);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the double value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, double value) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_10(swigCPtr, this, key, value);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the float value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, float value, String description) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_11(swigCPtr, this, key, value, description);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the float value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, float value) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_12(swigCPtr, this, key, value);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the integer value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, int value, String description) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_13(swigCPtr, this, key, value, description);
  }

  
/**
   * Adds a new {@link ConversionOption} object with the given parameters.
   * <p>
   * @param key the key for the new option
   * @param value the integer value of that option
   * @param description (optional) the description for the option
   */ public
 void addOption(String key, int value) {
    libsbmlJNI.ConversionProperties_addOption__SWIG_14(swigCPtr, this, key, value);
  }

  
/**
   * Removes the option with the given key from this properties object.
   * <p>
   * @param key the key for the new option to remove
   * @return the removed option
   */ public
 ConversionOption removeOption(String key) {
    long cPtr = libsbmlJNI.ConversionProperties_removeOption(swigCPtr, this, key);
    return (cPtr == 0) ? null : new ConversionOption(cPtr, false);
  }

  
/** 
   * Returns <code>true</code> if this properties object contains an option with
   * the given key.
   * <p>
   * @param key the key of the option to find.
   * <p>
   * @return <code>true</code> if an option with the given <code>key</code> exists in
   * this properties object, <code>false</code> otherwise.
   */ public
 boolean hasOption(String key) {
    return libsbmlJNI.ConversionProperties_hasOption(swigCPtr, this, key);
  }

  
/**
   * Returns the value of the given option as a string.
   * <p>
   * @param key the key for the option.
   * <p>
   * @return the string value of the option with the given key.
   */ public
 String getValue(String key) {
    return libsbmlJNI.ConversionProperties_getValue(swigCPtr, this, key);
  }

  
/**
   * Sets the value of the given option to a string.
   * <p>
   * @param key the key for the option
   * @param value the new value
   */ public
 void setValue(String key, String value) {
    libsbmlJNI.ConversionProperties_setValue(swigCPtr, this, key, value);
  }

  
/**
   * Returns the value of the given option as a Boolean.
   * <p>
   * @param key the key for the option.
   * <p>
   * @return the boolean value of the option with the given key.
   */ public
 boolean getBoolValue(String key) {
    return libsbmlJNI.ConversionProperties_getBoolValue(swigCPtr, this, key);
  }

  
/**
   * Sets the value of the given option to a Boolean.
   * <p>
   * @param key the key for the option.
   * <p>
   * @param value the new Boolean value.
   */ public
 void setBoolValue(String key, boolean value) {
    libsbmlJNI.ConversionProperties_setBoolValue(swigCPtr, this, key, value);
  }

  
/**
   * Returns the value of the given option as a <code>double.</code>
   * <p>
   * @param key the key for the option.
   * <p>
   * @return the double value of the option with the given key.
   */ public
 double getDoubleValue(String key) {
    return libsbmlJNI.ConversionProperties_getDoubleValue(swigCPtr, this, key);
  }

  
/**
   * Sets the value of the given option to a <code>double.</code>
   * <p>
   * @param key the key for the option.
   * <p>
   * @param value the new double value.
   */ public
 void setDoubleValue(String key, double value) {
    libsbmlJNI.ConversionProperties_setDoubleValue(swigCPtr, this, key, value);
  }

  
/**
   * Returns the value of the given option as a <code>float.</code>
   * <p>
   * @param key the key for the option.
   * <p>
   * @return the float value of the option with the given key.
   */ public
 float getFloatValue(String key) {
    return libsbmlJNI.ConversionProperties_getFloatValue(swigCPtr, this, key);
  }

  
/**
   * Sets the value of the given option to a <code>float.</code>
   * <p>
   * @param key the key for the option.
   * <p>
   * @param value the new float value.
   */ public
 void setFloatValue(String key, float value) {
    libsbmlJNI.ConversionProperties_setFloatValue(swigCPtr, this, key, value);
  }

  
/**
   * Returns the value of the given option as an integer.
   * <p>
   * @param key the key for the option.
   * <p>
   * @return the int value of the option with the given key.
   */ public
 int getIntValue(String key) {
    return libsbmlJNI.ConversionProperties_getIntValue(swigCPtr, this, key);
  }

  
/**
   * Sets the value of the given option to an integer.
   * <p>
   * @param key the key for the option.
   * <p>
   * @param value the new integer value.
   */ public
 void setIntValue(String key, int value) {
    libsbmlJNI.ConversionProperties_setIntValue(swigCPtr, this, key, value);
  }

}
