/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Representation of MIRIAM-compliant model creator data used
 * in {@link ModelHistory}. 
 * <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 * <p>
 * The SBML specification beginning with Level&nbsp;2 Version&nbsp;2
 * defines a standard approach to recording model history and model creator
 * information in a form that complies with MIRIAM ('Minimum Information
 * Requested in the Annotation of biochemical Models', <i>Nature
 * Biotechnology</i>, vol. 23, no. 12, Dec. 2005).  For the model creator,
 * this form involves the use of parts of the <a target='_blank'
 * href='http://en.wikipedia.org/wiki/VCard'>vCard</a> representation.
 * LibSBML provides the {@link ModelCreator} class as a convenience high-level
 * interface for working with model creator data.  Objects of class
 * {@link ModelCreator} can be used to store and carry around creator data within a
 * program, and the various methods in this object class let callers
 * manipulate the different parts of the model creator representation.
 * <p>
 * <h2>The different parts of a model creator definition</h2>
 * <p>
 * The {@link ModelCreator} class mirrors the structure of the MIRIAM model creator
 * annotations in SBML.  The following template illustrates these different
 * fields when they are written in XML form:
 * <p>
 <pre class='fragment'>
 &lt;vCard:N rdf:parseType='Resource'&gt;
   &lt;vCard:Family&gt;<span style='background-color: #bbb'>family name</span>&lt;/vCard:Family&gt;
   &lt;vCard:Given&gt;<span style='background-color: #bbb'>given name</span>&lt;/vCard:Given&gt;
 &lt;/vCard:N&gt;
 ...
 &lt;vCard:EMAIL&gt;<span style='background-color: #bbb'>email address</span>&lt;/vCard:EMAIL&gt;
 ...
 &lt;vCard:ORG rdf:parseType='Resource'&gt;
   &lt;vCard:Orgname&gt;<span style='background-color: #bbb'>organization</span>&lt;/vCard:Orgname&gt;
 &lt;/vCard:ORG&gt;
 </pre>
 * <p>
 * Each of the separate data values
 * <span class='code' style='background-color: #bbb'>family name</span>,
 * <span class='code' style='background-color: #bbb'>given name</span>,
 * <span class='code' style='background-color: #bbb'>email address</span>, and
 * <span class='code' style='background-color: #bbb'>organization</span> can
 * be set and retrieved via corresponding methods in the {@link ModelCreator} 
 * class.  These methods are documented in more detail below.
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class ModelCreator {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected ModelCreator(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(ModelCreator obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (ModelCreator obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_ModelCreator(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for ModelCreator.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((ModelCreator)(sb));
  }

  /**
   * Returns a hashcode for this ModelCreator object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
/**
   * Creates a new {@link ModelCreator} object.
   */ public
 ModelCreator() {
    this(libsbmlJNI.new_ModelCreator__SWIG_0(), true);
  }

  
/**
   * Creates a new {@link ModelCreator} from an {@link XMLNode}.
   * <p>
   * @param creator the {@link XMLNode} from which to create the {@link ModelCreator}.
   */ public
 ModelCreator(XMLNode creator) {
    this(libsbmlJNI.new_ModelCreator__SWIG_1(XMLNode.getCPtr(creator), creator), true);
  }

  
/**
   * Copy constructor; creates a copy of the {@link ModelCreator}.
   * <p>
   * @param orig the object to copy.
   * <p>
   * @throws SBMLConstructorException 
   * Thrown if the argument <code>orig</code> is <code>null.</code>
   */ public
 ModelCreator(ModelCreator orig) {
    this(libsbmlJNI.new_ModelCreator__SWIG_2(ModelCreator.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a copy of this {@link ModelCreator}.
   * <p>
   * @return a (deep) copy of this {@link ModelCreator}.
   */ public
 ModelCreator cloneObject() {
    long cPtr = libsbmlJNI.ModelCreator_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelCreator(cPtr, true);
  }

  
/**
   * Returns the 'family name' stored in this {@link ModelCreator} object.
   * <p>
   * @return the 'family name' portion of the {@link ModelCreator} object.
   */ public
 String getFamilyName() {
    return libsbmlJNI.ModelCreator_getFamilyName(swigCPtr, this);
  }

  
/**
   * Returns the 'given name' stored in this {@link ModelCreator} object.
   * <p>
   * @return the 'given name' portion of the {@link ModelCreator} object.
   */ public
 String getGivenName() {
    return libsbmlJNI.ModelCreator_getGivenName(swigCPtr, this);
  }

  
/**
   * Returns the 'email' stored in this {@link ModelCreator} object.
   * <p>
   * @return email from the {@link ModelCreator}.
   */ public
 String getEmail() {
    return libsbmlJNI.ModelCreator_getEmail(swigCPtr, this);
  }

  
/**
   * Returns the 'organization' stored in this {@link ModelCreator} object.
   * <p>
   * @return organization from the {@link ModelCreator}.
   */ public
 String getOrganization() {
    return libsbmlJNI.ModelCreator_getOrganization(swigCPtr, this);
  }

  
/**
   * (Alternate spelling) Returns the 'organization' stored in this
   * {@link ModelCreator} object.
   * <p>
   * @note This function is an alias of getOrganization().
   * <p>
   * @return organization from the {@link ModelCreator}.
   * <p>
   * @see #getOrganization()
   */ public
 String getOrganisation() {
    return libsbmlJNI.ModelCreator_getOrganisation(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s 'family name' part is set.
   * <p>
   * @return <code>true</code> if the familyName of this {@link ModelCreator} is set, <code>false</code> otherwise.
   */ public
 boolean isSetFamilyName() {
    return libsbmlJNI.ModelCreator_isSetFamilyName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s 'given name' part is set.
   * <p>
   * @return <code>true</code> if the givenName of this {@link ModelCreator} is set, <code>false</code> otherwise.
   */ public
 boolean isSetGivenName() {
    return libsbmlJNI.ModelCreator_isSetGivenName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s 'email' part is set.
   * <p>
   * @return <code>true</code> if the email of this {@link ModelCreator} is set, <code>false</code> otherwise.
   */ public
 boolean isSetEmail() {
    return libsbmlJNI.ModelCreator_isSetEmail(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s 'organization' part is set.
   * <p>
   * @return <code>true</code> if the organization of this {@link ModelCreator} is set, <code>false</code> otherwise.
   */ public
 boolean isSetOrganization() {
    return libsbmlJNI.ModelCreator_isSetOrganization(swigCPtr, this);
  }

  
/**
   * (Alternate spelling) Predicate returning <code>true</code> or <code>false</code> depending
   * on whether this {@link ModelCreator}'s 'organization' part is set.
   * <p>
   * @note This function is an alias of isSetOrganization().
   * <p>
   * @return <code>true</code> if the organization of this {@link ModelCreator} is set, <code>false</code> otherwise.
   * <p>
   * @see #isSetOrganization()
   */ public
 boolean isSetOrganisation() {
    return libsbmlJNI.ModelCreator_isSetOrganisation(swigCPtr, this);
  }

  
/**
   * Sets the 'family name' portion of this {@link ModelCreator} object.
   * <p>
   * @param familyName a string representing the familyName of the {@link ModelCreator}. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setFamilyName(String familyName) {
    return libsbmlJNI.ModelCreator_setFamilyName(swigCPtr, this, familyName);
  }

  
/**
   * Sets the 'given name' portion of this {@link ModelCreator} object.
   * <p>
   * @param givenName a string representing the givenName of the {@link ModelCreator}. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setGivenName(String givenName) {
    return libsbmlJNI.ModelCreator_setGivenName(swigCPtr, this, givenName);
  }

  
/**
   * Sets the 'email' portion of this {@link ModelCreator} object.
   * <p>
   * @param email a string representing the email of the {@link ModelCreator}. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setEmail(String email) {
    return libsbmlJNI.ModelCreator_setEmail(swigCPtr, this, email);
  }

  
/**
   * Sets the 'organization' portion of this {@link ModelCreator} object.
   * <p>
   * @param organization a string representing the organization of the 
   * {@link ModelCreator}. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */ public
 int setOrganization(String organization) {
    return libsbmlJNI.ModelCreator_setOrganization(swigCPtr, this, organization);
  }

  
/**
   * (Alternate spelling) Sets the 'organization' portion of this
   * {@link ModelCreator} object.
   * <p>
   * @param organization a string representing the organization of the
   * {@link ModelCreator}.
   * <p>
   * @note This function is an alias of setOrganization(String organization).
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   * <p>
   * @see #setOrganization(String organization)
   */ public
 int setOrganisation(String organization) {
    return libsbmlJNI.ModelCreator_setOrganisation(swigCPtr, this, organization);
  }

  
/**
   * Unsets the 'family name' portion of this {@link ModelCreator} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetFamilyName() {
    return libsbmlJNI.ModelCreator_unsetFamilyName(swigCPtr, this);
  }

  
/**
   * Unsets the 'given name' portion of this {@link ModelCreator} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetGivenName() {
    return libsbmlJNI.ModelCreator_unsetGivenName(swigCPtr, this);
  }

  
/**
   * Unsets the 'email' portion of this {@link ModelCreator} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetEmail() {
    return libsbmlJNI.ModelCreator_unsetEmail(swigCPtr, this);
  }

  
/**
   * Unsets the 'organization' portion of this {@link ModelCreator} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetOrganization() {
    return libsbmlJNI.ModelCreator_unsetOrganization(swigCPtr, this);
  }

  
/**
   * (Alternate spelling) Unsets the 'organization' portion of this {@link ModelCreator} object.
   * <p>
   * @note This function is an alias of unsetOrganization().
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @see #unsetOrganization()
   */ public
 int unsetOrganisation() {
    return libsbmlJNI.ModelCreator_unsetOrganisation(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required elements for this
   * {@link ModelCreator} object have been set.
   * <p>
   * The only required elements for a {@link ModelCreator} object are the 'family
   * name' and 'given name'.
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.ModelCreator_hasRequiredAttributes(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required elements for this
   * {@link ModelCreator} object have been set.
   * <p>
   * The only required elements for a {@link ModelCreator} object are the 'family
   * name' and 'given name'.
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   * @internal
   */ public
 boolean hasBeenModified() {
    return libsbmlJNI.ModelCreator_hasBeenModified(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required elements for this
   * {@link ModelCreator} object have been set.
   * <p>
   * The only required elements for a {@link ModelCreator} object are the 'family
   * name' and 'given name'.
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   * @internal
   */ public
 void resetModifiedFlags() {
    libsbmlJNI.ModelCreator_resetModifiedFlags(swigCPtr, this);
  }

}
