# @file    TestL3FormulaParserC.rb
# @brief   L3FormulaParser unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Ben Bornstein
 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestL3FormulaParserC.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestL3FormulaParserC < Test::Unit::TestCase

  def test_SBML_C_parseL3Formula_1
    r = LibSBML::parseL3Formula("1")
    assert( r.getType() == LibSBML::AST_INTEGER )
    assert( r.getInteger() == 1 )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_10
    r = LibSBML::parseL3Formula("1 + -2e100 / 3")
    assert( r.getType() == LibSBML::AST_PLUS )
    assert( r.getCharacter() == '+' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_DIVIDE )
    assert( c.getCharacter() == '/' )
    assert( c.getNumChildren() == 2 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getCharacter() == '-' )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL_E )
    assert( c.getMantissa() == 2 )
    assert( c.getExponent() == 100 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_11
    r = LibSBML::parseL3Formula("1 - -foo / 3")
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getCharacter() == '-' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_DIVIDE )
    assert( c.getCharacter() == '/' )
    assert( c.getNumChildren() == 2 )
    c = r.getRightChild().getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getCharacter() == '-' )
    assert( c.getNumChildren() == 1 )
    c = r.getRightChild().getLeftChild().getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "foo" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_12
    r = LibSBML::parseL3Formula("2 * foo^bar + 3.0")
    assert( r.getType() == LibSBML::AST_PLUS )
    assert( r.getCharacter() == '+' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_TIMES )
    assert( c.getCharacter() == '*' )
    assert( c.getNumChildren() == 2 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 3.0 )
    assert( c.getNumChildren() == 0 )
    c = r.getLeftChild().getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    c = r.getLeftChild().getRightChild()
    assert( c.getType() == LibSBML::AST_POWER )
    assert( c.getCharacter() == '^' )
    assert( c.getNumChildren() == 2 )
    c = r.getLeftChild().getRightChild().getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "foo" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getLeftChild().getRightChild().getRightChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "bar" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_13
    r = LibSBML::parseL3Formula("foo()")
    assert( r.getType() == LibSBML::AST_FUNCTION )
    assert ((  "foo" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_14
    r = LibSBML::parseL3Formula("foo(1)")
    assert( r.getType() == LibSBML::AST_FUNCTION )
    assert ((  "foo" == r.getName() ))
    assert( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_15
    r = LibSBML::parseL3Formula("foo(1, bar)")
    assert( r.getType() == LibSBML::AST_FUNCTION )
    assert ((  "foo" == r.getName() ))
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "bar" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_16
    r = LibSBML::parseL3Formula("foo(1, bar, 2^-3)")
    assert( r.getType() == LibSBML::AST_FUNCTION )
    assert ((  "foo" == r.getName() ))
    assert( r.getNumChildren() == 3 )
    c = r.getChild(0)
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getChild(1)
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "bar" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getChild(2)
    assert( c.getType() == LibSBML::AST_POWER )
    assert( c.getCharacter() == '^' )
    assert( c.getNumChildren() == 2 )
    c = r.getChild(2).getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    c = r.getChild(2).getRightChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getCharacter() == '-' )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_17
    r = LibSBML::parseL3Formula("1//1")
    assert( r == nil )
    assert ((  "Error when parsing input '1//1' at position 3:  syntax error, unexpected '/'" == LibSBML::getLastParseL3Error() ))
  end

  def test_SBML_C_parseL3Formula_18
    r = LibSBML::parseL3Formula("1+2*3 4")
    assert( r == nil )
    assert ((  "Error when parsing input '1+2*3 4' at position 7:  syntax error, unexpected integer" == LibSBML::getLastParseL3Error() ))
  end

  def test_SBML_C_parseL3Formula_2
    r = LibSBML::parseL3Formula("2.1")
    assert( r.getType() == LibSBML::AST_REAL )
    assert( r.getReal() == 2.1 )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_3
    r = LibSBML::parseL3Formula("2.1e5")
    assert( r.getType() == LibSBML::AST_REAL_E )
    assert( r.getMantissa() == 2.1 )
    assert( r.getExponent() == 5 )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_4
    r = LibSBML::parseL3Formula("foo")
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "foo" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_5
    r = LibSBML::parseL3Formula("1 + foo")
    assert( r.getType() == LibSBML::AST_PLUS )
    assert( r.getCharacter() == '+' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "foo" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_6
    r = LibSBML::parseL3Formula("1 + 2")
    assert( r.getType() == LibSBML::AST_PLUS )
    assert( r.getCharacter() == '+' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_7
    r = LibSBML::parseL3Formula("1 + 2 * 3")
    assert( r.getType() == LibSBML::AST_PLUS )
    assert( r.getCharacter() == '+' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_TIMES )
    assert( c.getCharacter() == '*' )
    assert( c.getNumChildren() == 2 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_8
    r = LibSBML::parseL3Formula("(1 - 2) * 3")
    assert( r.getType() == LibSBML::AST_TIMES )
    assert( r.getCharacter() == '*' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getCharacter() == '-' )
    assert( c.getNumChildren() == 2 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    c = r.getLeftChild().getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getLeftChild().getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_9
    r = LibSBML::parseL3Formula("1 + -2 / 3")
    assert( r.getType() == LibSBML::AST_PLUS )
    assert( r.getCharacter() == '+' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_DIVIDE )
    assert( c.getCharacter() == '/' )
    assert( c.getNumChildren() == 2 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getCharacter() == '-' )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_arguments
    r = LibSBML::parseL3Formula("sin(x,y)")
    assert( r == nil )
    assert ((  "Error when parsing input 'sin(x,y)' at position 8:  The function 'sin' takes exactly one argument, but 2 were found." == LibSBML::getLastParseL3Error() ))
    r = LibSBML::parseL3Formula("delay(x)")
    assert( r == nil )
    assert ((  "Error when parsing input 'delay(x)' at position 8:  The function 'delay' takes exactly two arguments, but 1 were found." == LibSBML::getLastParseL3Error() ))
    r = LibSBML::parseL3Formula("piecewise()")
    assert( r == nil )
    assert ((  "Error when parsing input 'piecewise()' at position 11:  The function 'piecewise' takes at least one argument, but none were found." == LibSBML::getLastParseL3Error() ))
    r = LibSBML::parseL3Formula("gt(x)")
    assert( r == nil )
    assert ((  "Error when parsing input 'gt(x)' at position 5:  The function 'gt' takes at least two arguments, but 1 were found." == LibSBML::getLastParseL3Error() ))
    r = LibSBML::parseL3Formula("minus()")
    assert( r == nil )
    assert ((  "Error when parsing input 'minus()' at position 7:  The function 'minus' takes exactly one or two arguments, but 0 were found." == LibSBML::getLastParseL3Error() ))
    r = LibSBML::parseL3Formula("root(x, y, z)")
    assert( r == nil )
    assert ((  "Error when parsing input 'root(x, y, z)' at position 13:  The function 'root' takes exactly one or two arguments, but 3 were found." == LibSBML::getLastParseL3Error() ))
    r = LibSBML::parseL3Formula("power()")
    assert( r == nil )
    assert ((  "Error when parsing input 'power()' at position 7:  The function 'power' takes exactly two arguments, but 0 were found." == LibSBML::getLastParseL3Error() ))
  end

  def test_SBML_C_parseL3Formula_avogadrosettings
    r = LibSBML::parseL3Formula("avogadro")
    assert( r.getType() == LibSBML::AST_NAME_AVOGADRO )
    assert( r.getNumChildren() == 0 )
    r = nil
    settings = LibSBML::getDefaultL3ParserSettings()
    settings.setParseAvogadroCsymbol(0)    
    assert_equal false, settings.getParseAvogadroCsymbol()
    r = LibSBML::parseL3FormulaWithSettings("avogadro", settings)
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "avogadro" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
    settings.setParseAvogadroCsymbol(1)
    assert_equal true, settings.getParseAvogadroCsymbol()
    r = LibSBML::parseL3FormulaWithSettings("avogadro", settings)
    assert( r.getType() == LibSBML::AST_NAME_AVOGADRO )
    assert( r.getNumChildren() == 0 )
    r = nil
    settings = nil
  end

  def test_SBML_C_parseL3Formula_collapseminussettings1
    r = LibSBML::parseL3Formula("--4.4")
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = LibSBML::getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    assert_equal true, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("--4.4", settings)
    assert( r.getType() == LibSBML::AST_REAL )
    assert( r.getReal() == 4.4 )
    assert( r.getNumChildren() == 0 )
    r = nil
    settings.setParseCollapseMinus(0)
    assert_equal false, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("--4.4", settings)
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = nil
  end

  def test_SBML_C_parseL3Formula_collapseminussettings2
    r = LibSBML::parseL3Formula("--x")
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = LibSBML::getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    assert_equal true, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("--x", settings)
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "x" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
    settings.setParseCollapseMinus(0)
    assert_equal false, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("--x", settings)
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = nil
  end

  def test_SBML_C_parseL3Formula_collapseminussettings3
    r = LibSBML::parseL3Formula("x---4.4")
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = LibSBML::getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    assert_equal true, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("x---4.4", settings)
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
    settings.setParseCollapseMinus(0)
    assert_equal false, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("x---4.4", settings)
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = nil
  end

  def test_SBML_C_parseL3Formula_collapseminussettings4
    r = LibSBML::parseL3Formula("x---y")
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "y" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = LibSBML::getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    assert_equal true, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("x---y", settings)
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "y" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
    settings.setParseCollapseMinus(0)
    assert_equal false, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("x---y", settings)
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_MINUS )
    assert( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "y" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = nil
  end

  def test_SBML_C_parseL3Formula_collapseminussettings5
    settings = LibSBML::getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    assert_equal true, settings.getParseCollapseMinus()
    r = LibSBML::parseL3FormulaWithSettings("---4", settings)
    assert( r.getType() == LibSBML::AST_INTEGER )
    assert( r.getInteger() == -4 )
    assert( r.getNumChildren() == 0 )
    r = nil
    r = LibSBML::parseL3FormulaWithSettings("---(3/8)", settings)
    assert( r.getType() == LibSBML::AST_RATIONAL )
    assert( r.getNumerator() == -3 )
    assert( r.getDenominator() == 8 )
    assert( r.getNumChildren() == 0 )
    r = nil
    r = LibSBML::parseL3FormulaWithSettings("---(-3/8)", settings)
    assert( r.getType() == LibSBML::AST_RATIONAL )
    assert( r.getNumerator() == 3 )
    assert( r.getDenominator() == 8 )
    assert( r.getNumChildren() == 0 )
    r = nil
    r = LibSBML::parseL3FormulaWithSettings("---4.4", settings)
    assert( r.getType() == LibSBML::AST_REAL )
    assert( r.getReal() == -4.4 )
    assert( r.getNumChildren() == 0 )
    r = nil
    r = LibSBML::parseL3FormulaWithSettings("---4e-3", settings)
    assert( r.getType() == LibSBML::AST_REAL_E )
    assert( r.getMantissa() == -4 )
    assert( r.getExponent() == -3 )
    assert( r.getNumChildren() == 0 )
    r = nil
    r = LibSBML::parseL3FormulaWithSettings("---.4", settings)
    assert( r.getType() == LibSBML::AST_REAL )
    assert( r.getReal() == -0.4 )
    assert( r.getNumChildren() == 0 )
    r = nil
    settings = nil
  end

  def test_SBML_C_parseL3Formula_constants1
    r = LibSBML::parseL3Formula("true")
    assert( r.getType() == LibSBML::AST_CONSTANT_TRUE )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants10
    r = LibSBML::parseL3Formula("notanumber")
    assert( r.getType() == LibSBML::AST_REAL )
    assert_equal true, (r.getReal().nan?)
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants11
    r = LibSBML::parseL3Formula("nan")
    assert( r.getType() == LibSBML::AST_REAL )
    assert_equal true,(r.getReal().nan?)
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants12
    r = LibSBML::parseL3Formula("NaN")
    assert( r.getType() == LibSBML::AST_REAL )
    assert_equal true,(r.getReal().nan?)
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants2
    r = LibSBML::parseL3Formula("false")
    assert( r.getType() == LibSBML::AST_CONSTANT_FALSE )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants3
    r = LibSBML::parseL3Formula("pi")
    assert( r.getType() == LibSBML::AST_CONSTANT_PI )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants4
    r = LibSBML::parseL3Formula("exponentiale")
    assert( r.getType() == LibSBML::AST_CONSTANT_E )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants5
    r = LibSBML::parseL3Formula("avogadro")
    assert( r.getType() == LibSBML::AST_NAME_AVOGADRO )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants6
    r = LibSBML::parseL3Formula("time")
    assert( r.getType() == LibSBML::AST_NAME_TIME )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants7
    r = LibSBML::parseL3Formula("inf")
    assert( r.getType() == LibSBML::AST_REAL )
    assert((r.getReal().finite?) == false )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants8
    r = LibSBML::parseL3Formula("infinity")
    assert( r.getType() == LibSBML::AST_REAL )
    assert((r.getReal().finite?) == false )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_constants9
    r = LibSBML::parseL3Formula("INF")
    assert( r.getType() == LibSBML::AST_REAL )
    assert((r.getReal().finite?) == false )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_e1
    r = LibSBML::parseL3Formula("2.001e+5")
    assert( r.getType() == LibSBML::AST_REAL_E )
    assert( r.getMantissa() == 2.001 )
    assert( r.getExponent() == 5 )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_e2
    r = LibSBML::parseL3Formula(".001e+5")
    assert( r.getType() == LibSBML::AST_REAL_E )
    assert( r.getMantissa() == 0.001 )
    assert( r.getExponent() == 5 )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_e3
    r = LibSBML::parseL3Formula(".001e-5")
    assert( r.getType() == LibSBML::AST_REAL_E )
    assert( r.getMantissa() == 0.001 )
    assert( r.getExponent() == -5 )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_e4
    r = LibSBML::parseL3Formula("2.e-005")
    assert( r.getType() == LibSBML::AST_REAL_E )
    assert( r.getMantissa() == 2 )
    assert( r.getExponent() == -5 )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_e5
    r = LibSBML::parseL3Formula(".e+5")
    assert( r == nil )
    assert ((  "Error when parsing input '.e+5' at position 1:  syntax error, unexpected $undefined" == LibSBML::getLastParseL3Error() ))
    r = nil
  end

  def test_SBML_C_parseL3Formula_logic1
    r = LibSBML::parseL3Formula("1 && 2 == 3")
    assert( r.getType() == LibSBML::AST_LOGICAL_AND )
    assert ((  "and" == r.getName() ))
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_RELATIONAL_EQ )
    assert ((  "eq" == c.getName() ))
    assert( c.getNumChildren() == 2 )
    c = c.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_logic2
    r = LibSBML::parseL3Formula("(1 && 2) == 3")
    assert( r.getType() == LibSBML::AST_RELATIONAL_EQ )
    assert ((  "eq" == r.getName() ))
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_LOGICAL_AND )
    assert ((  "and" == c.getName() ))
    assert( c.getNumChildren() == 2 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    c = r.getLeftChild().getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 1 )
    assert( c.getNumChildren() == 0 )
    c = r.getLeftChild().getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_modelPresent1
    model = LibSBML::Model.new(3,1)
    p = model.createParameter()
    p.setId( "infinity")
    r = LibSBML::parseL3FormulaWithModel("infinity", model)
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "infinity" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_modelPresent2
    model = LibSBML::Model.new(3,1)
    p = model.createSpecies()
    p.setId( "true")
    r = LibSBML::parseL3FormulaWithModel("true", model)
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "true" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_modelPresent3
    model = LibSBML::Model.new(3,1)
    p = model.createCompartment()
    p.setId( "NaN")
    r = LibSBML::parseL3FormulaWithModel("NaN", model)
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "NaN" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_modelPresent4
    model = LibSBML::Model.new(3,1)
    p = model.createReaction()
    p.setId( "pi")
    r = LibSBML::parseL3FormulaWithModel("pi", model)
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "pi" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_modelPresent5
    model = LibSBML::Model.new(3,1)
    p = model.createReaction()
    sr = p.createProduct()
    sr.setId( "avogadro")
    r = LibSBML::parseL3FormulaWithModel("avogadro", model)
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "avogadro" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_modelPresent6
    model = LibSBML::Model.new(3,1)
    p = model.createReaction()
    sr = p.createProduct()
    sr.setId( "AVOGADRO")
    r = LibSBML::parseL3FormulaWithModel("avogadro", model)
    assert( r.getType() == LibSBML::AST_NAME_AVOGADRO )
    assert ((  "avogadro" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_modelPresent7
    model = LibSBML::Model.new(3,1)
    p = model.createFunctionDefinition()
    p.setId( "sin")
    r = LibSBML::parseL3FormulaWithModel("sin(x, y)", model)
    assert( r.getType() == LibSBML::AST_FUNCTION )
    assert ((  "sin" == r.getName() ))
    assert( r.getNumChildren() == 2 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_modulo
    r = LibSBML::parseL3Formula("x % y")
    assert ((  "piecewise(x - y * ceil(x / y), xor(lt(x, 0), lt(y, 0)), x - y * floor(x / y))" == LibSBML::formulaToString(r) ))
    r = nil
  end

  def test_SBML_C_parseL3Formula_negInf
    r = LibSBML::parseL3Formula("-inf")
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getCharacter() == '-' )
    assert( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert((c.getReal().finite?) == false )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_negZero
    r = LibSBML::parseL3Formula("-0.0")
    assert( r.getType() == LibSBML::AST_MINUS )
    assert( r.getCharacter() == '-' )
    assert( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 0 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_oddMathML1
    r = LibSBML::parseL3Formula("sqrt(3)")
    assert( r.getType() == LibSBML::AST_FUNCTION_ROOT )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_oddMathML2
    r = LibSBML::parseL3Formula("sqr(3)")
    assert( r.getType() == LibSBML::AST_FUNCTION_POWER )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 2 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_oddMathML3
    r = LibSBML::parseL3Formula("log10(3)")
    assert( r.getType() == LibSBML::AST_FUNCTION_LOG )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 10 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_oddMathML4
    r = LibSBML::parseL3Formula("log(4.4, 3)")
    assert( r.getType() == LibSBML::AST_FUNCTION_LOG )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_oddMathML5
    r = LibSBML::parseL3Formula("root(1.1, 3)")
    assert( r.getType() == LibSBML::AST_FUNCTION_ROOT )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 1.1 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_parselogsettings
    r = LibSBML::parseL3Formula("log(4.4)")
    assert( r.getType() == LibSBML::AST_FUNCTION_LOG )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 10 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
    settings = LibSBML::L3ParserSettings.new()
    settings.setParseLog(LibSBML::L3P_PARSE_LOG_AS_LN)
    assert( settings.getParseLog() == LibSBML::L3P_PARSE_LOG_AS_LN )
    r = LibSBML::parseL3FormulaWithSettings("log(4.4)", settings)
    assert( r.getType() == LibSBML::AST_FUNCTION_LN )
    assert( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
    settings.setParseLog(LibSBML::L3P_PARSE_LOG_AS_LOG10)
    assert( settings.getParseLog() == LibSBML::L3P_PARSE_LOG_AS_LOG10 )
    r = LibSBML::parseL3FormulaWithSettings("log(4.4)", settings)
    assert( r.getType() == LibSBML::AST_FUNCTION_LOG )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 10 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
    settings.setParseLog(LibSBML::L3P_PARSE_LOG_AS_ERROR)
    assert( settings.getParseLog() == LibSBML::L3P_PARSE_LOG_AS_ERROR )
    r = LibSBML::parseL3FormulaWithSettings("log(4.4)", settings)
    assert( r == nil )
    assert ((  "Error when parsing input 'log(4.4)' at position 8:  Writing a function as 'log(x)' was legal in the L1 parser, but translated as the natural log, not the base-10 log.  This construct is disallowed entirely as being ambiguous, and you are encouraged instead to use 'ln(x)', 'log10(x)', or 'log(base, x)'." == LibSBML::getLastParseL3Error() ))
    settings = nil
  end

  def test_SBML_C_parseL3Formula_precedence
    root = LibSBML::parseL3Formula("a && b == !c - d * e^-f ")
    assert( root.getType() == LibSBML::AST_LOGICAL_AND )
    assert ((  "and" == root.getName() ))
    assert( root.getNumChildren() == 2 )
    left = root.getLeftChild()
    assert( left.getType() == LibSBML::AST_NAME )
    assert ((  "a" == left.getName() ))
    assert( left.getNumChildren() == 0 )
    right = root.getRightChild()
    assert( right.getType() == LibSBML::AST_RELATIONAL_EQ )
    assert ((  "eq" == right.getName() ))
    assert( right.getNumChildren() == 2 )
    left = right.getLeftChild()
    assert( left.getType() == LibSBML::AST_NAME )
    assert ((  "b" == left.getName() ))
    assert( left.getNumChildren() == 0 )
    right = right.getRightChild()
    assert( right.getType() == LibSBML::AST_LOGICAL_NOT )
    assert ((  "not" == right.getName() ))
    assert( right.getNumChildren() == 1 )
    right = right.getLeftChild()
    assert( right.getType() == LibSBML::AST_MINUS )
    assert( right.getCharacter() == '-' )
    assert( right.getNumChildren() == 2 )
    left = right.getLeftChild()
    assert( left.getType() == LibSBML::AST_NAME )
    assert ((  "c" == left.getName() ))
    assert( left.getNumChildren() == 0 )
    right = right.getRightChild()
    assert( right.getType() == LibSBML::AST_TIMES )
    assert( right.getCharacter() == '*' )
    assert( right.getNumChildren() == 2 )
    left = right.getLeftChild()
    assert( left.getType() == LibSBML::AST_NAME )
    assert ((  "d" == left.getName() ))
    assert( left.getNumChildren() == 0 )
    right = right.getRightChild()
    assert( right.getType() == LibSBML::AST_POWER )
    assert( right.getCharacter() == '^' )
    assert( right.getNumChildren() == 2 )
    left = right.getLeftChild()
    assert( left.getType() == LibSBML::AST_NAME )
    assert ((  "e" == left.getName() ))
    assert( left.getNumChildren() == 0 )
    right = right.getRightChild()
    assert( right.getType() == LibSBML::AST_MINUS )
    assert( right.getCharacter() == '-' )
    assert( right.getNumChildren() == 1 )
    left = right.getLeftChild()
    assert( left.getType() == LibSBML::AST_NAME )
    assert ((  "f" == left.getName() ))
    assert( left.getNumChildren() == 0 )
    root = nil
  end

  def test_SBML_C_parseL3Formula_rational1
    r = LibSBML::parseL3Formula("(3/4)")
    assert( r.getType() == LibSBML::AST_RATIONAL )
    assert( r.getNumerator() == 3 )
    assert( r.getDenominator() == 4 )
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_rational2
    r = LibSBML::parseL3Formula("(3/4) mL")
    assert( r.getType() == LibSBML::AST_RATIONAL )
    assert( r.getNumerator() == 3 )
    assert( r.getDenominator() == 4 )
    assert ((  "mL" == r.getUnits() ))
    assert( r.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_rational3
    r = LibSBML::parseL3Formula("3/4")
    assert( r.getType() == LibSBML::AST_DIVIDE )
    assert( r.getCharacter() == '/' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 4 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_rational4
    r = LibSBML::parseL3Formula("(3/x)")
    assert( r.getType() == LibSBML::AST_DIVIDE )
    assert( r.getCharacter() == '/' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_NAME )
    assert ((  "x" == c.getName() ))
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_rational5
    r = LibSBML::parseL3Formula("(3/4.4)")
    assert( r.getType() == LibSBML::AST_DIVIDE )
    assert( r.getCharacter() == '/' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_REAL )
    assert( c.getReal() == 4.4 )
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_rational6
    r = LibSBML::parseL3Formula("3/4 ml")
    assert( r.getType() == LibSBML::AST_DIVIDE )
    assert( r.getCharacter() == '/' )
    assert( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 3 )
    assert( c.getNumChildren() == 0 )
    c = r.getRightChild()
    assert( c.getType() == LibSBML::AST_INTEGER )
    assert( c.getInteger() == 4 )
    assert ((  "ml" == c.getUnits() ))
    assert( c.getNumChildren() == 0 )
    r = nil
  end

  def test_SBML_C_parseL3Formula_rational7
    r = LibSBML::parseL3Formula("(3/4.4) ml")
    assert( r == nil )
    assert ((  "Error when parsing input '(3/4.4) ml' at position 10:  syntax error, unexpected element name" == LibSBML::getLastParseL3Error() ))
  end

  def test_SBML_C_parseL3Formula_targetl2settings
    r = LibSBML::parseL3Formula("4 mL")
    assert( r.getType() == LibSBML::AST_INTEGER )
    assert( r.getInteger() == 4 )
    assert ((  "mL" == r.getUnits() ))
    assert( r.getNumChildren() == 0 )
    r = nil
    r = LibSBML::parseL3Formula("avogadro")
    assert( r.getType() == LibSBML::AST_NAME_AVOGADRO )
    assert( r.getNumChildren() == 0 )
    r = nil
    settings = LibSBML::getDefaultL3ParserSettings()
    settings.setParseUnits(0)
    settings.setParseAvogadroCsymbol(0)
    assert_equal false, settings.getParseUnits()
    assert_equal false, settings.getParseAvogadroCsymbol()
    r = LibSBML::parseL3FormulaWithSettings("4 mL", settings)
    assert( r == nil )
    assert ((  "Error when parsing input '4 mL' at position 4:  The ability to associate units with numbers has been disabled." == LibSBML::getLastParseL3Error() ))
    r = LibSBML::parseL3FormulaWithSettings("avogadro", settings)
    assert( r.getType() == LibSBML::AST_NAME )
    assert ((  "avogadro" == r.getName() ))
    assert( r.getNumChildren() == 0 )
    r = nil
    settings.setParseUnits(1)
    settings.setParseAvogadroCsymbol(1)
    assert_equal true, settings.getParseUnits()
    assert_equal true, settings.getParseAvogadroCsymbol()
    r = LibSBML::parseL3FormulaWithSettings("4 mL", settings)
    assert( r.getType() == LibSBML::AST_INTEGER )
    assert( r.getInteger() == 4 )
    assert ((  "mL" == r.getUnits() ))
    assert( r.getNumChildren() == 0 )
    r = nil
    r = LibSBML::parseL3FormulaWithSettings("avogadro", settings)
    assert( r.getType() == LibSBML::AST_NAME_AVOGADRO )
    assert( r.getNumChildren() == 0 )
    r = nil
    settings = nil
  end

  def test_SBML_C_parseL3Formula_unitssettings
    r = LibSBML::parseL3Formula("4 mL")
    assert( r.getType() == LibSBML::AST_INTEGER )
    assert( r.getInteger() == 4 )
    assert ((  "mL" == r.getUnits() ))
    assert( r.getNumChildren() == 0 )
    r = nil
    settings = LibSBML::getDefaultL3ParserSettings()
    settings.setParseUnits(0)
    assert_equal false, settings.getParseUnits()
    r = LibSBML::parseL3FormulaWithSettings("4 mL", settings)
    assert( r == nil )
    assert ((  "Error when parsing input '4 mL' at position 4:  The ability to associate units with numbers has been disabled." == LibSBML::getLastParseL3Error() ))
    settings.setParseUnits(1)
    assert_equal true, settings.getParseUnits()
    r = LibSBML::parseL3FormulaWithSettings("4 mL", settings)
    assert( r.getType() == LibSBML::AST_INTEGER )
    assert( r.getInteger() == 4 )
    assert ((  "mL" == r.getUnits() ))
    assert( r.getNumChildren() == 0 )
    r = nil
    settings = nil
  end

end
