# $DUH: PMilter.pm,v 1.21.2.1 2003/01/22 22:19:35 tv Exp $
#
# Copyright (c) 2002 Todd Vierling <tv@pobox.com> <tv@duh.org>.
# All rights reserved.
# Please see the COPYRIGHT file, part of the PMilter distribution,
# for full copyright and license terms.

=pod

=head1 NAME

PMilter - a Perl implementation of the Sendmail Milter protocol

=head1 SYNOPSIS

For a description of the interface compatible with the "real"
Sendmail::Milter implementation:

    perldoc Sendmail::Milter

For a description of PMilter's own native, extended interface:

    perldoc PMilter::Server
    perldoc PMilter::Session
    perldoc PMilter::Callbacks

For the objects that represent DNSBL lookups:

    perldoc PMilter::DNSBL

=head1 BUNDLED MODULES

Several prefabricated modules are included.  These may be provided by name
to PMilter::Callbacks->new (see L<PMilter::Callbacks>). All these modules
optionally take arguments, which are described below.

In the list, the optional arguments ERRMSG and EXTERRMSG may exist.  ERRMSG
is the default error message for the module; if not set or undef, a default
for that module is used.  EXTERRMSG, if set, is appended to ERRMSG (whether
set or the default) with a dash.

Error messages may have positional parameters, which are substituted
automatically by the module as needed.  These are of the form %DIGIT, and if
used, are listed below the module's syntax below.

=over 4

=item 'connect_dnsbl_ip', DNSBL[, ERRMSG[, EXTERRMSG[, TEMPFAILMSG[, FILTER]]]]

    %1 - IP address of connecting host
    %2 - DNSBL that responded

Calls a DNSBL->query() on the connecting host's IPv4 address (with the four
octets reversed) and rejects the connection if a match is found.  If the
DNSBL returns a temporary failure rather than a successful lookup,
TEMPFAILMSG (with a generic default) is used, with EXTERRMSG (if set)
appended, and a 451 SMTP reply code.

If the DNSBL returns an extended message, it will be used instead of ERRMSG.
(TEMPFAILMSG will not be affected.)

Finally, FILTER is an optional filter subroutine that will be called after
the supplied DNSBL, and passed two arguments:  $ctx and the return value of
the DNSBL.  It should return a DNSBL return value.  (This subroutine makes
it possible to stash some value in $ctx for later use.)

=item 'connect_dnsbl_rdns', DNSBL[, ERRMSG[, EXTERRMSG[, TEMPFAILMSG[, FILTER]]]]

    %1 - reverse-DNS hostname of connecting host
    %2 - DNSBL that responded

Same as 'connect_dnsbl_ip' above, except that the rDNS hostname is checked
against the given DNSBL.  If the rDNS did not resolve for some reason (that
is, the MTA reported the hostname as an [address literal]), the check is
skipped.

=item 'connect_regex', REGEX[, ERRMSG[, EXTERRMSG]]

Rejects connections whose hostname (or [address literal]) matches REGEX.  
REGEX is a regular expression (or arrayref of regular expressions), matched
case-insensitively.

As a special case, if ERMSG is 'BREAK', returns SMFIS_BREAK to the parent
container, rather than rejecting the connection.

=item 'header_nofrom'[, ERRMSG[, EXTERRMSG]]

Rejects messages at the DATA phase that are missing a From: header.

=item 'header_regex', REGEX[, ERRMSG[, EXTERRMSG]]

Rejects headers that match one of a list of regexes.  LISTREF is an arrayref
containing strings that are regular expressions (NOT C<qr//> references).  
Each header is matched against supplied headers as "Name: Value".  REGEX is
a regular expression (or arrayref of regular expressions), matched
case-insensitively.

To make expressions simpler (by avoiding many C<\s+> instances), each span
of whitespace in the header is folded to one physical space character.

=item 'helo_ipmismatch'[, ERRMSG[, EXTERRMSG]]

    %1 - HELO argument, without [square brackets]
    %2 - Actual connecting address

Rejects a "HELO [address]" command if it does not match the address of the
connecting host.

=item 'helo_rawliteral'[, ERRMSG[, EXTERRMSG]]

    %1 - HELO argument

Rejects a "HELO address" command where "address" is a raw IP address that is
missing the RFC-mandated [square brackets].

=item 'helo_regex', REGEX[, ERRMSG[, EXTERRMSG]]

    %1 - HELO argument that matched the list

Rejects a HELO command if it matches a specific list of regular expressions.  
REGEX is a regular expression (or arrayref of regular expressions), matched
case-insensitively.

=item 'helo_unqualified'[, ERRMSG[, EXTERRMSG]]

    %1 - HELO argument

Rejects a HELO command that does not contain at least one dot (.), and is
not an address literal.

This should only appear B<after> a 'connect_regex' entry with a 'BREAK' flag
in a PMilter::Callbacks list, so that localhost (and possibly local
networks) are allowed to bypass the block.  Recommended usage:

    ...
    [ 'connect_regex', '^(\[127\.|localhost\z)', 'BREAK' ],
    [ 'helo_unqualified', ... ],
    ...

=item 'received_dnsbl_ip', DNSBL[, MATCH[, ERRMSG[, EXTERRMSG[, TEMPFAILMSG[, FILTER]]]]]

    %1 - IP address of connecting host
    %2 - DNSBL that responded

Same as 'connect_dnsbl_ip' above, but rather than using the IP address of
the connecting host, uses a regex match against Received: headers to find
the IP address.

MATCH, if supplied, is a subroutine reference that will be passed the value
of the Received: header as its first argument, and a subroutine reference to
the default matching algorithm as its second argument.  It should return a
list of one or more possible IP addresses, which will be further sanity
checked by this module before being passed to the DNSBL.

If MATCH is undef, only the default matching subroutine is used.  In this
release, this algorithm is capable of parsing Postfix and standard Sendmail
Received: headers.  Be warned that checking all headers without matching on
particular patterns is dangerous; this should only be used for very obvious
things that should B<never> appear in Received: headers (like the addresses
of open relay inputs or open proxies).

The sanity checker will filter out addresses that are not dotted quads, as
well as valid addresses in any of the IP ranges listed for C<match_bad> in
L<PMilter::Match::CIDR>.

The optional FILTER (further described under 'connect_dnsbl_ip') is also
passed a third argument, the value of the Received: header.

=back

=cut

package PMilter;

our $VERSION = '0.4.0';

1;
