////////////////////////////////////////////////////////////
//
// SFML - Simple and Fast Multimedia Library
// Copyright (C) 2007 Laurent Gomila (laurent.gom@gmail.com)
//
// This software is provided 'as-is', without any express or implied warranty.
// In no event will the authors be held liable for any damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it freely,
// subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented;
//    you must not claim that you wrote the original software.
//    If you use this software in a product, an acknowledgment
//    in the product documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such,
//    and must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include <SFML/Audio/Listener.hpp>
#include <SFML/Audio/OpenAL.hpp>


namespace sf
{
////////////////////////////////////////////////////////////
/// Change the global volume of all the sounds
////////////////////////////////////////////////////////////
void Listener::SetGlobalVolume(float Volume)
{
    ALCheck(alListenerf(AL_GAIN, Volume * 0.01f));
}


////////////////////////////////////////////////////////////
/// Get the current value of the global volume of all the sounds
////////////////////////////////////////////////////////////
float Listener::GetGlobalVolume()
{
    float Volume = 0.f;
    ALCheck(alGetListenerf(AL_GAIN, &Volume));

    return Volume;
}


////////////////////////////////////////////////////////////
/// Change the position of the listener
////////////////////////////////////////////////////////////
void Listener::SetPosition(float PosX, float PosY, float PosZ)
{
    ALCheck(alListener3f(AL_POSITION, PosX, PosY, PosZ));
}


////////////////////////////////////////////////////////////
/// Get the current position of the listener
////////////////////////////////////////////////////////////
void Listener::GetPosition(float& PosX, float& PosY, float& PosZ)
{
    ALCheck(alGetListener3f(AL_POSITION, &PosX, &PosY, &PosZ));
}


////////////////////////////////////////////////////////////
/// Change the orientation of the listener (the point
/// he must look at)
////////////////////////////////////////////////////////////
void Listener::SetTarget(float TargetX, float TargetY, float TargetZ)
{
    float Orientation[] = {TargetX, TargetY, TargetZ, 0.f, 1.f, 0.f};
    ALCheck(alListenerfv(AL_ORIENTATION, Orientation));
}


////////////////////////////////////////////////////////////
/// Get the current orientation of the listener (the point
/// he's looking at)
////////////////////////////////////////////////////////////
void Listener::GetTarget(float& TargetX, float& TargetY, float& TargetZ)
{
    float Orientation[6];
    ALCheck(alGetListenerfv(AL_ORIENTATION, Orientation));

    TargetX = Orientation[0];
    TargetY = Orientation[1];
    TargetZ = Orientation[2];
}

} // namespace sf
