
#define TEST_NAME "box2"
#include "cmptest.h"

static unsigned char bobsk[32] = { 0x5d, 0xab, 0x08, 0x7e, 0x62, 0x4a, 0x8a,
                                   0x4b, 0x79, 0xe1, 0x7f, 0x8b, 0x83, 0x80,
                                   0x0e, 0xe6, 0x6f, 0x3b, 0xb1, 0x29, 0x26,
                                   0x18, 0xb6, 0xfd, 0x1c, 0x2f, 0x8b, 0x27,
                                   0xff, 0x88, 0xe0, 0xeb };

static unsigned char alicepk[32] = { 0x85, 0x20, 0xf0, 0x09, 0x89, 0x30, 0xa7,
                                     0x54, 0x74, 0x8b, 0x7d, 0xdc, 0xb4, 0x3e,
                                     0xf7, 0x5a, 0x0d, 0xbf, 0x3a, 0x0d, 0x26,
                                     0x38, 0x1a, 0xf4, 0xeb, 0xa4, 0xa9, 0x8e,
                                     0xaa, 0x9b, 0x4e, 0x6a };

static const unsigned char small_order_p[crypto_box_PUBLICKEYBYTES] = {
    0xe0, 0xeb, 0x7a, 0x7c, 0x3b, 0x41, 0xb8, 0xae, 0x16, 0x56, 0xe3,
    0xfa, 0xf1, 0x9f, 0xc4, 0x6a, 0xda, 0x09, 0x8d, 0xeb, 0x9c, 0x32,
    0xb1, 0xfd, 0x86, 0x62, 0x05, 0x16, 0x5f, 0x49, 0xb8, 0x00
};

static unsigned char nonce[24] = { 0x69, 0x69, 0x6e, 0xe9, 0x55, 0xb6,
                                   0x2b, 0x73, 0xcd, 0x62, 0xbd, 0xa8,
                                   0x75, 0xfc, 0x73, 0xd6, 0x82, 0x19,
                                   0xe0, 0x03, 0x6b, 0x7a, 0x0b, 0x37 };

/* API requires first 16 bytes to be 0 */
static unsigned char c[163] = {
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0xf3, 0xff, 0xc7, 0x70, 0x3f, 0x94, 0x00, 0xe5,
    0x2a, 0x7d, 0xfb, 0x4b, 0x3d, 0x33, 0x05, 0xd9, 0x8e, 0x99, 0x3b, 0x9f,
    0x48, 0x68, 0x12, 0x73, 0xc2, 0x96, 0x50, 0xba, 0x32, 0xfc, 0x76, 0xce,
    0x48, 0x33, 0x2e, 0xa7, 0x16, 0x4d, 0x96, 0xa4, 0x47, 0x6f, 0xb8, 0xc5,
    0x31, 0xa1, 0x18, 0x6a, 0xc0, 0xdf, 0xc1, 0x7c, 0x98, 0xdc, 0xe8, 0x7b,
    0x4d, 0xa7, 0xf0, 0x11, 0xec, 0x48, 0xc9, 0x72, 0x71, 0xd2, 0xc2, 0x0f,
    0x9b, 0x92, 0x8f, 0xe2, 0x27, 0x0d, 0x6f, 0xb8, 0x63, 0xd5, 0x17, 0x38,
    0xb4, 0x8e, 0xee, 0xe3, 0x14, 0xa7, 0xcc, 0x8a, 0xb9, 0x32, 0x16, 0x45,
    0x48, 0xe5, 0x26, 0xae, 0x90, 0x22, 0x43, 0x68, 0x51, 0x7a, 0xcf, 0xea,
    0xbd, 0x6b, 0xb3, 0x73, 0x2b, 0xc0, 0xe9, 0xda, 0x99, 0x83, 0x2b, 0x61,
    0xca, 0x01, 0xb6, 0xde, 0x56, 0x24, 0x4a, 0x9e, 0x88, 0xd5, 0xf9, 0xb3,
    0x79, 0x73, 0xf6, 0x22, 0xa4, 0x3d, 0x14, 0xa6, 0x59, 0x9b, 0x1f, 0x65,
    0x4c, 0xb4, 0x5a, 0x74, 0xe3, 0x55, 0xa5
};

static unsigned char m[163];

int
main(void)
{
    unsigned char k[crypto_box_BEFORENMBYTES];
    int           i;
    int           ret;

    if (crypto_box_open(m, c, 163, nonce, alicepk, bobsk) == 0) {
        for (i = 32; i < 163; ++i) {
            printf(",0x%02x", (unsigned int) m[i]);
            if (i % 8 == 7)
                printf("\n");
        }
        printf("\n");
    }
    ret = crypto_box_open(m, c, 163, nonce, small_order_p, bobsk);
    assert(ret == -1);

    memset(m, 0, sizeof m);
    ret = crypto_box_beforenm(k, alicepk, bobsk);
    assert(ret == 0);
    if (crypto_box_open_afternm(m, c, 163, nonce, k) == 0) {
        for (i = 32; i < 163; ++i) {
            printf(",0x%02x", (unsigned int) m[i]);
            if (i % 8 == 7)
                printf("\n");
        }
        printf("\n");
    }
    return 0;
}
