/*
 * libSpiff - XSPF playlist handling library
 *
 * Copyright (C) 2007, Sebastian Pipping / Xiph.Org Foundation
 * All rights reserved.
 *
 * Redistribution  and use in source and binary forms, with or without
 * modification,  are permitted provided that the following conditions
 * are met:
 *
 *     * Redistributions   of  source  code  must  retain  the   above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer.
 *
 *     * Redistributions  in  binary  form must  reproduce  the  above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer   in  the  documentation  and/or  other  materials
 *       provided with the distribution.
 *
 *     * Neither  the name of the Xiph.Org Foundation nor the names of
 *       its  contributors may be used to endorse or promote  products
 *       derived  from  this software without specific  prior  written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT  NOT
 * LIMITED  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS
 * FOR  A  PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT  SHALL  THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,    SPECIAL,   EXEMPLARY,   OR   CONSEQUENTIAL   DAMAGES
 * (INCLUDING,  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES;  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT  LIABILITY,  OR  TORT (INCLUDING  NEGLIGENCE  OR  OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Sebastian Pipping, sping@xiph.org
 */

/**
 * @file SpiffDateTime.cpp
 * Implementation of SpiffDateTime.
 */

#include <spiff/SpiffDateTime.h>

namespace Spiff {



/// @cond DOXYGEN_NON_API

/**
 * D object for SpiffDateTime.
 */
class SpiffDateTimePrivate {

	friend class SpiffDateTime;

	int year; ///< Year [-9999..+9999] but not zero
	int month; ///< Month [1..12]
	int day; ///< Day [1..31]
	int hour; ///< Hour [0..23]
	int minutes; ///< Minutes [0..59]
	int seconds; ///< Seconds [0..59]
	int distHours; ///< Time shift hours [-14..+14]
	int distMinutes; ///< Time shift minutes [-59..+59]

	/**
	 * Creates a new D object.
	 *
	 * @param year			Year [-9999..+9999] but not zero
	 * @param month			Month [1..12]
	 * @param day			Day [1..31]
	 * @param hour			Hour [0..23]
	 * @param minutes		Minutes [0..59]
	 * @param seconds		Seconds [0..59]
	 * @param distHours		Time shift hours [-14..+14]
	 * @param distMinutes	Time shift minutes [-59..+59]
	 */
	SpiffDateTimePrivate(int year, int month, int day, int hour,
			int minutes, int seconds, int distHours, int distMinutes)
			: year(year),
			month(month),
			day(day),
			hour(hour),
			minutes(minutes),
			seconds(seconds),
			distHours(distHours),
			distMinutes(distMinutes) {

	}

	/**
	 * Destroys this D object.
	 */
	~SpiffDateTimePrivate() {

	}

};

/// @endcond



SpiffDateTime::SpiffDateTime(int year, int month, int day,
		int hour, int minutes, int seconds, int distHours,
		int distMinutes)
		: d(new SpiffDateTimePrivate(year, month, day, hour,
			minutes, seconds, distHours, distMinutes)) {

}



SpiffDateTime::SpiffDateTime()
		: d(new SpiffDateTimePrivate(0, 0, 0, -1, -1, -1, 0, 0)) {

}



SpiffDateTime::SpiffDateTime(const SpiffDateTime & source)
		: d(new SpiffDateTimePrivate(*(source.d))) {

}



SpiffDateTime & SpiffDateTime::operator=(const SpiffDateTime & source) {
	if (this != &source) {
		*(this->d) = *(source.d);
	}
	return *this;
}



SpiffDateTime::~SpiffDateTime() {
	delete this->d;
}



SpiffDateTime * SpiffDateTime::clone() const {
	return new SpiffDateTime(this->d->year, this->d->month, this->d->day,
			this->d->hour, this->d->minutes, this->d->seconds, this->d->distHours,
			this->d->distMinutes);
}



int SpiffDateTime::getYear() const {
	return this->d->year;
}



int SpiffDateTime::getMonth() const {
	return this->d->month;
}



int SpiffDateTime::getDay() const {
	return this->d->day;
}



int SpiffDateTime::getHour() const {
	return this->d->hour;
}



int SpiffDateTime::getMinutes() const {
	return this->d->minutes;
}



int SpiffDateTime::getSeconds() const {
	return this->d->seconds;
}



int SpiffDateTime::getDistHours() const {
	return this->d->distHours;
}



int SpiffDateTime::getDistMinutes() const {
	return this->d->distMinutes;
}



void SpiffDateTime::setYear(int year) {
	this->d->year = year;
}



void SpiffDateTime::setMonth(int month) {
	this->d->month = month;
}



void SpiffDateTime::setDay(int day) {
	this->d->day = day;
}



void SpiffDateTime::setHour(int hour) {
	this->d->hour = hour;
}



void SpiffDateTime::setMinutes(int minutes) {
	this->d->minutes = minutes;
}



void SpiffDateTime::setSeconds(int seconds) {
	this->d->seconds = seconds;
}



void SpiffDateTime::setDistHours(int distHours) {
	this->d->distHours = distHours;
}



void SpiffDateTime::setDistMinutes(int distMinutes) {
	this->d->distMinutes = distMinutes;
}



}
