=begin
= strscan user manual

== What is this library?

strscan is a lexical scan library.
Here is the simplest usage example of this library:

    s = StringScanner.new('This is an example string')
    s.eos?            #=> false

    p s.scan(/\w+/)   #=> "This"
    p s.scan(/\w+/)   #=> nil
    p s.scan(/\s+/)   #=> " "
    p s.scan(/\s+/)   #=> nil
    p s.scan(/\w+/)   #=> "is"
    s.eos?            #=> false

    p s.scan(/\s+/)   #=> " "
    p s.scan(/\w+/)   #=> "an"
    p s.scan(/\s+/)   #=> " "
    p s.scan(/\w+/)   #=> "example"
    p s.scan(/\s+/)   #=> " "
    p s.scan(/\w+/)   #=> "string"
    s.eos?            #=> true

    p s.scan(/\s+/)   #=> nil
    p s.scan(/\w+/)   #=> nil

In a word, StringScanner is a set of "scan pointer" and
a string. "scan pointer" is, in another word, an index.

    ## a string and a scan pointer   ("_" = scan pointer)

    s = StringScanner.new('This is an example string')
    _This is an example string     s.eos? = false
    s.scan(/\w+/)
    This_ is an example string     s.eos? = false
    s.scan(/\s+/)
    This _is an example string     s.eos? = false
    s.scan(/\w+/)
    This is_ an example string     s.eos? = false
    s.scan(/\s+/)
    This is _an example string     s.eos? = false
    s.scan(/\w+/)
    This is an_ example string     s.eos? = false
    s.scan(/\s+/)
    This is an _example string     s.eos? = false
    s.scan(/\w+/)
    This is an example_ string     s.eos? = false
    s.scan(/\s+/)
    This is an example _string     s.eos? = false
    s.scan(/\w+/)
    This is an example string_     s.eos? = true

== WARNING!!!!!

StringScanner DOES NOT set regexp variables like $~, $&, $1, $2, etc.
Use StringScanner's methods instead (e.g. scanner[n], scanner.matched?).

== class StringScanner

=== Class Methods

: new( str: String, dup: bool = true )  ->  StringScanner
    creates a new StringScanner object. STR is a string to scan.
    If DUP is true, duplicates STR and use freeze it.
    If DUP is false, does not duplicate and freeze it.

=== Instance Methods

: scan( pattern: Regexp )  ->  String
    tries matching with PATTERN only on the scan pointer.
    If matched, the scanner advances "scan pointer" and
    returns a matched string. Else, the scanner returns nil.

        s = StringScanner.new('test string')
        p s.scan(/\w+/)   #=> "test"
        p s.scan(/\w+/)   #=> nil
        p s.scan(/\s+/)   #=> " "
        p s.scan(/\w+/)   #=> "string"
        p s.scan(/./)     #=> nil

: skip( pattern: Regexp )  ->  Integer
    tries matching with PATTERN, only on the scan pointer.
    If matched, the scanner advances "scan pointer" and
    returns length of matched string. Else, the scanner
    returns nil.

        s = StringScanner.new('test string')
        p s.skip(/\w+/)   #=> 4
        p s.skip(/\w+/)   #=> nil
        p s.skip(/\s+/)   #=> 1
        p s.skip(/\w+/)   #=> 6
        p s.skip(/./)     #=> nil

: match?( pattern: Regexp )  ->  Integer
    tries matching with PATTERN, only on the scan pointer.
    If matched, the scanner keep "scan pointer" un-touched
    and returns the length of the matched string. Else, the
    scanner returns nil.

        s = StringScanner.new('test string')
        p s.match?(/\w+/)   #=> 4
        p s.match?(/\w+/)   #=> 4
        p s.match?(/\s+/)   #=> nil

: getch  ->  String
    scans one character and returns it.

: get_byte  ->  String
    scans one byte and returns it.

: peek( len: Integer )  ->  String
    extracts a string which is corresponding to string[pos, len]

: eos?  ->  bool
    returns true if the scan pointer is on the end of the string.

: string  ->  String
    returns the scanning string itself.

: matched?  ->  bool
    returns true if last matching had been successed.

: pre_match  ->  String

: post_match  ->  String

: self[ n: Integer ]  ->  String
    returns N-th content of regexp register (indecated by paren in regexp).
    If previous scanning had been failed, the scanner raises ScanError.

: matched  ->  String
    returns the entire matched string.

: reset
    reset scan pointer (index 0) and clear matching data.

: terminate
    set scan pointer the end of the string and clear matching data.

: unscan
    set scan pointer the previous position.
    This method is valid only once for one scanning method call.
=end
