/*
 * Decompiled with CFR 0.152.
 */
package libsvm;

import libsvm.Cache;
import libsvm.Kernel;
import libsvm.svm_parameter;
import libsvm.svm_problem;

class SVC_Q
extends Kernel {
    private final byte[] y;
    private final Cache cache;
    private final float[] QD;

    SVC_Q(svm_problem svm_problem2, svm_parameter svm_parameter2, byte[] byArray) {
        super(svm_problem2.l, svm_problem2.x, svm_parameter2);
        this.y = (byte[])byArray.clone();
        this.cache = new Cache(svm_problem2.l, (int)(svm_parameter2.cache_size * 1048576.0));
        this.QD = new float[svm_problem2.l];
        for (int i = 0; i < svm_problem2.l; ++i) {
            this.QD[i] = (float)this.kernel_function(i, i);
        }
    }

    float[] get_Q(int n, int n2) {
        float[][] fArrayArray = new float[1][];
        int n3 = this.cache.get_data(n, fArrayArray, n2);
        if (n3 < n2) {
            for (int i = n3; i < n2; ++i) {
                fArrayArray[0][i] = (float)((double)(this.y[n] * this.y[i]) * this.kernel_function(n, i));
            }
        }
        return fArrayArray[0];
    }

    float[] get_QD() {
        return this.QD;
    }

    void swap_index(int n, int n2) {
        this.cache.swap_index(n, n2);
        super.swap_index(n, n2);
        byte by = this.y[n];
        this.y[n] = this.y[n2];
        this.y[n2] = by;
        float f = this.QD[n];
        this.QD[n] = this.QD[n2];
        this.QD[n2] = f;
    }
}

