/* package-info.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

/**
 * Provides internationalization of actions and buttons through 
 * {@link be.ugent.caagt.swirl.actions.Description} objects.<p>
 * A description object combines caption, mnemonic and accelerator key of a button
 * into a single string. For example, the description string
 * <pre>
 *     Javadoc inde&amp;x search [shift F1]
 * </pre>
 * can be used to provide a button with the caption 
 * '<code>Javadoc index search</code>', the mnemonic '<code>x</code>' and the 
 * accelerator key shift-F1.<p>
 *
 * Description strings are typically retrieved from resource
 * bundles, making internationalization of buttons and actions fairly
 * straightforward.<p>
 *
 * In most cases buttons and menu
 * items can most easily be internationalized using actions that 
 * extend {@link be.ugent.caagt.swirl.actions.SimpleAction} or through one of
 * the class methods of {@link be.ugent.caagt.swirl.actions.ButtonFactory}.<p>
 * 
 * This package also provides support for alternative icons for
 * tool bar buttons through the classes {@link be.ugent.caagt.swirl.actions.ToolBarButton}
 * and {@link be.ugent.caagt.swirl.actions.ToolBarToggleButton}.
 */
package be.ugent.caagt.swirl.actions;

