/* package-info.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

/**
 * Provides a simple framework for registering and activating undoable 
 * (and redoable) actions with a central <i>undo manager</i>.<p>
 * <ul>
 * <li>
 * Typically a set of windows will be associated with a single undo manager
 * (of type {@link be.ugent.caagt.swirl.undoredo.UndoManager}) which keeps track
 * of all actions performed on objects in these windows.</li>
 * <li>Such 'actions' must satisfy the interface {@link be.ugent.caagt.swirl.undoredo.UndoableChange}.
 *  </li>
 * <li>{@link be.ugent.caagt.swirl.undoredo.UndoAction}
 * and {@link be.ugent.caagt.swirl.undoredo.RedoAction} can then be used to 
 * create undo and redo buttons (or menu items) 
 * which allow the user to undo the last change
 * (or several changes) and then optionally 
 * redo the actions which were just undone.
 * </li>
 * <li>Other components can be notified of changes in the current undo/redo-state
 * by registering an {@link be.ugent.caagt.swirl.undoredo.UndoListener} with
 * the undo manager.</li>
 * </ul>
 *
 * <p><b>Important note:</b> some of the classes in this package
 * make use of the <a href="http://pietschy.org/products/gui-commands/index.html">GUI commands</a> 
 * framework (version 1.1.42). Work on these classes will be 
 * discontinued because unfortunately newer versions
 * of the <i>GUI commands</i> framework will no longer be available as <i>open source</i>.
 * In due course these classes will become deprecated and will eventually be
 * removed from the library.
 */
package be.ugent.caagt.swirl.undoredo;

