/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_ELEMENTS_INTERNALS_H_
#define _SML_ELEMENTS_INTERNALS_H_

#include <libxml/xmlreader.h>

struct SmlAnchor {
	char *next;
	char *last;
};

struct SmlLocation {
	gint refCount;
	char *locURI;
	char *locName;
};

struct SmlItem {
	gint refCount;
	
	SmlLocation *source;
	SmlLocation *target;
	SmlAnchor *anchor;
	
	xmlBuffer *buffer;
	
	unsigned int size;
	
	char *contenttype;
	SmlBool moreData;
	
	SmlBool disabled;
	/** If set to true, libsyncml will omit the cdata tags */
	SmlBool raw;
};

struct SmlMapItem {
	gint refCount;
	SmlLocation *source;
	SmlLocation *target;
};

struct SmlHeader {
	char *sessionID;
	SmlProtocolVersion version;
	SmlProtocolType protocol;
	SmlLocation *source;
	SmlLocation *target;
	unsigned int messageID;
	unsigned int maxmsgsize;
	unsigned int maxobjsize;
};

struct SmlCred {
	SmlFormatType format;
	SmlAuthType type;
	char *data;
};

#endif //_SML_ELEMENTS_INTERNALS_H_
