/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

#include <libsysactivity/libsysactivity.h>

void* stress_get_network_interfaces(void* arg) {
	int ret, i;
#ifdef SA_OPEN_NETWORK
	ret = sa_open_network();
	if (ret != 0) {
		printf("sa_open_network(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	uint16_t number, written;

	ret = sa_count_network_interfaces(&number);
	if (ret != 0) {
		printf("sa_count_network_interfaces(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}

	struct sa_network_interface* interfaces = (struct sa_network_interface*) malloc(number
			* sizeof(struct sa_network_interface));

	for (i = 0; i < 150000; i++) {
		ret = sa_get_network_interfaces(interfaces, number, &written);
		if (ret != 0) {
			printf("sa_get_network_interfaces(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}
	}

	free(interfaces);

#ifdef SA_CLOSE_NETWORK
	ret = sa_close_network();
	if (ret != 0) {
		printf("sa_close_network(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return NULL;
}

int main() {
	pthread_t thread1;
	struct timespec delay;
	delay.tv_sec = 0;
	delay.tv_nsec = 1000000;

	pthread_create(&thread1, NULL, stress_get_network_interfaces, NULL);
	nanosleep(&delay, NULL);
	stress_get_network_interfaces(NULL);

	return EXIT_SUCCESS;
}
