/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2010-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>
#include <ctype.h>
#include "utils.h"

static void __attribute__ ((constructor)) set_kernel_version(void) {
	struct utsname uts;
	if (uname(&uts) != 0) {
		kernel_version = -1;
		return;
	}
	if (strncmp(uts.release, "3.", sizeof "3." - 1) == 0)
		kernel_version = atoi(uts.release + sizeof "3." - 1) + 40;
	else if (strncmp(uts.release, "2.6.", sizeof "2.6." - 1) == 0)
		kernel_version = atoi(uts.release + sizeof "2.6." - 1);
	else
		kernel_version = -1;
}

char* skip_values(char* pos, int number) {
	while (number--)
		pos = skip_value(pos);

	return pos;
}

char* skip_value(char* pos) {
	while (isgraph(*pos))
		++pos;
	while (isblank(*pos))
		++pos;
	return pos;
}

SA_INLINE void strlcpy(char* __restrict__ dest, const char* __restrict__ src, const size_t n) {
	strncpy(dest, src, n);
	if (strlen(src) >= n)
		dest[n] = '\0';
}
