#ifndef TAGCOLL_TAG_TO_STRING_H
#define TAGCOLL_TAG_TO_STRING_H

/*
 * 2-way conversion between a collection tagged with strings to a collection
 * tagged with Tagcoll::Tag
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <tagcoll/TagcollConsumer.h>
#include <tagcoll/OpSet.h>
#include <tagcoll/Tag.h>

namespace Tagcoll
{

template<class T>
class StringsToTags : public TagcollConsumer<T, std::string>
{
protected:
	FacetSet& vocab;
	TagcollConsumer<T, Tag>* consumer;

public:
	StringsToTags(FacetSet& vocab) throw () : vocab(vocab), consumer(0) {}
	StringsToTags(FacetSet& vocab, TagcollConsumer<T, Tag>* consumer) throw ()
		: vocab(vocab), consumer(consumer) {}
	virtual ~StringsToTags() throw () {}

	TagcollConsumer<T, Tag>* getConsumer() throw () { return consumer; }
	void setConsumer(TagcollConsumer<T, Tag>* consumer) throw () { this->consumer = consumer; }

	// Consume data to be filtered
	virtual void consume(const T& item) throw ();
	virtual void consume(const T& item, const OpSet<std::string>& tags) throw ();
	virtual void consume(const OpSet<T>& items) throw ();
	virtual void consume(const OpSet<T>& items, const OpSet<std::string>& tags) throw ();
};

template<class T>
class TagsToStrings : public TagcollConsumer<T, Tag>
{
protected:
	TagcollConsumer<T, std::string>* consumer;

public:
	TagsToStrings() throw () : consumer(0) {}
	TagsToStrings(TagcollConsumer<T, std::string>* consumer) throw () : consumer(consumer) {}
	virtual ~TagsToStrings() throw () {}

	TagcollConsumer<T, std::string>* getConsumer() throw () { return consumer; }
	void setConsumer(TagcollConsumer<T, std::string>* consumer) throw () { this->consumer = consumer; }

	// Consume data to be filtered
	virtual void consume(const T& item) throw ();
	virtual void consume(const T& item, const OpSet<Tag>& tags) throw ();
	virtual void consume(const OpSet<T>& items) throw ();
	virtual void consume(const OpSet<T>& items, const OpSet<Tag>& tags) throw ();
};

};

// vim:set ts=4 sw=4:
#endif
