module tango.sys.win32.Types;

/*
 Module:  Windows Types
 Author:  Trevor Parscal, Frank Benoit
*/

/+ Aliases, Types, and Constants +/
const void* NULL = null;
alias int SCODE;
alias void VOID;
alias void* POINTER;
alias ushort ATOM;
alias int WINBOOL;
alias WINBOOL BOOL;
alias uint CALTYPE;
alias uint CALID;
alias char CCHAR;
alias char* PCHAR;
alias uint COLORREF;
alias uint TCOLORREF;
alias char CHAR;
alias ubyte BYTE;
alias short INT16;
alias ushort UINT16;
alias short SHORT;
alias int INT;
alias int WINT;
alias int LONG;
alias ushort WORD;
alias uint DWORD;
alias int INT_PTR;
alias uint UINT_PTR;
alias int LONG_PTR;
alias uint ULONG_PTR;
alias DWORD DWORD_PTR;
alias uint PROPID;
const BOOL FALSE = 0;
const BOOL TRUE = -1;
alias char* PANSICHAR;
alias wchar* PWIDECHAR;
alias int* PINTEGER;
alias long LONGLONG;
alias LONGLONG* PLONGLONG;
alias ulong DWORDLONG;
alias DWORDLONG* PDWORDLONG;
alias float FLOAT;
alias void* HANDLE;
alias HANDLE HACCEL;
alias HANDLE HBITMAP;
alias HANDLE HBRUSH;
alias HANDLE HCOLORSPACE;
alias HANDLE HCONV;
alias HANDLE HCONVLIST;
alias HANDLE HCURSOR;
alias HANDLE HDBC;
alias HANDLE HDC;
alias HANDLE HDDEDATA;
alias HANDLE HDESK;
alias HANDLE HDROP;
alias HANDLE HDWP;
alias HANDLE HENHMETAFILE;
alias HANDLE HENV;
alias HANDLE HFILE;
alias HANDLE HFONT;
alias HANDLE HGDIOBJ;
alias HANDLE HGLOBAL;
alias HANDLE HGLRC;
alias HANDLE HHOOK;
alias HANDLE HICON;
alias HANDLE HIMAGELIST;
alias HANDLE HINST;
alias HINST HINSTANCE;
alias HANDLE HKEY;
alias HANDLE HKL;
alias HANDLE HLOCAL;
alias HANDLE HMENU;
alias HANDLE HMETAFILE;
alias HANDLE HMODULE;
alias HANDLE HPALETTE;
alias HANDLE HPEN;
alias HANDLE HRASCONN;
alias int HRESULT;
alias HANDLE HRGN;
alias HANDLE HRSRC;
alias HANDLE HSTMT;
alias HANDLE HSZ;
alias HANDLE HWINSTA;
alias HANDLE HWND;
alias ushort LANGID;
alias DWORD LCID;
alias DWORD LCTYPE;
alias int LPARAM;
alias ushort* LP;
alias WINBOOL* LPBOOL;
alias ubyte* LPBYTE;
alias PCHAR LPCCH;
alias PCHAR LPCH;
alias COLORREF* LPCOLORREF;
alias PCHAR LPCSTR;
alias TCHAR* LPCTSTR;
alias wchar* LPCWCH;
alias wchar* LPCWSTR;
alias DWORD* LPDWORD;
alias HANDLE* LPHANDLE;
alias int* LPINT;
alias int* LPLONG;
alias PCHAR LPSTR;
alias PCHAR LPTCH;
alias TCHAR* LPTSTR;
alias int LRESULT;
alias POINTER LPVOID;
alias POINTER LPCVOID;
alias wchar* LPWCH;
alias wchar* LPWORD;
alias wchar* LPWSTR;
alias wchar* NWPSTR;
alias WINBOOL* PWINBOOL;
alias ubyte BOOLEAN;
alias ubyte* PBOOLEAN;
alias ubyte* PBYTE;
alias PCHAR PCCH;
alias PCHAR PCH;
alias PCHAR PCSTR;
alias wchar* PCWCH;
alias wchar* PCWSTR;
alias DWORD* PDWORD;
alias float* PFLOAT;
alias HANDLE* PHANDLE;
alias HKEY* PHKEY;
alias int* PINT;
alias int* PLONG;
alias int* PSHORT;
alias PCHAR PSTR;
alias PCHAR PSZ;
alias ubyte* PTBYTE;
alias PCHAR PTCH;
alias PCHAR PTCHAR;
alias PCHAR PTSTR;
alias ubyte* PUCHAR;
alias wchar* PWCH;
alias wchar* PWCHAR;
alias ushort* PWORD;
alias uint* PUINT;
alias uint* PULONG;
alias ushort* PUSHORT;
alias POINTER PVOID;
// NOTE: This is defined in sqltypes.  Probably shouldn't be here.  Commenting for now.
//alias int RETCODE;
alias HANDLE SC_HANDLE;
alias LPVOID SC_LOCK;
alias SC_HANDLE* LPSC_HANDLE;
alias DWORD SERVICE_STATUS_HANDLE;
alias ubyte TBYTE;

version(Win32SansUnicode){
 // Strictly speaking this should be ubyte since char is UTF-8, but that
 // fills code with so many casts that it's just not sensible.
 // (See also DMD Issue 2193.)
 alias  char TCHAR;
}else{
 alias wchar TCHAR;
}

alias ubyte BCHAR;
alias ubyte UCHAR;
alias wchar WCHAR;
alias uint UINT;
alias uint ULONG;
alias ushort USHORT;
alias uint WPARAM;
alias int ACL_INFORMATION_CLASS;

alias GUID IID;
alias IID* REFIID;

// Cast a string literal to a ubyte*=PCHAR
template _PCHAR( char[] a ){
 const PCHAR _PCHAR = cast(PCHAR)a.ptr;
}

enum { AclRevisionInformation = 1, AclSizeInformation,  };
alias ACL_INFORMATION_CLASS _ACL_INFORMATION_CLASS;
alias int MEDIA_TYPE;
enum { Unknown, F5_1Pt2_512, F3_1Pt44_512, F3_2Pt88_512, F3_20Pt8_512, F3_720_512, F5_360_512, F5_320_512, F5_320_1024, F5_180_512, F5_160_512, RemovableMedia, FixedMedia,  };
alias MEDIA_TYPE _MEDIA_TYPE;
const int RASCS_DONE = (0x2000);
const int RASCS_PAUSED = (0x1000);
alias int RASCONNSTATE;
enum { RASCS_OpenPort = 0, RASCS_PortOpened, RASCS_ConnectDevice, RASCS_DeviceConnected, RASCS_AllDevicesConnected, RASCS_Authenticate, RASCS_AuthNotify, RASCS_AuthRetry, RASCS_AuthCallback, RASCS_AuthChangePassword, RASCS_AuthProject, RASCS_AuthLinkSpeed, RASCS_AuthAck, RASCS_ReAuthenticate, RASCS_Authenticated, RASCS_PrepareForCallback, RASCS_WaitForModemReset, RASCS_WaitForCallback, RASCS_Projected, RASCS_StartAuthentication, RASCS_CallbackComplete, RASCS_LogonNetwork, RASCS_Interactive = RASCS_PAUSED, RASCS_RetryAuthentication, RASCS_CallbackSetByCaller, RASCS_PasswordExpired, RASCS_Connected = RASCS_DONE, RASCS_Disconnected,  };
alias RASCONNSTATE _RASCONNSTATE;
alias int RASPROJECTION;
enum { RASP_Amb = 0x10000, RASP_PppNbf = 0x803F, RASP_PppIpx = 0x802B, RASP_PppIp = 0x8021,  };
alias RASPROJECTION _RASPROJECTION;
alias int SECURITY_IMPERSONATION_LEVEL;
enum { SecurityAnonymous, SecurityIdentification, SecurityImpersonation, SecurityDelegation,  };
alias SECURITY_IMPERSONATION_LEVEL _SECURITY_IMPERSONATION_LEVEL;
alias int SID_NAME_USE;
enum { SidTypeUser = 1, SidTypeGroup, SidTypeDomain, SidTypeAlias, SidTypeWellKnownGroup, SidTypeDeletedAccount, SidTypeInvalid, SidTypeUnknown,  };
alias SID_NAME_USE* PSID_NAME_USE;
alias SID_NAME_USE _SID_NAME_USE;
alias int TOKEN_INFORMATION_CLASS;
enum { TokenUser = 1, TokenGroups, TokenPrivileges, TokenOwner, TokenPrimaryGroup, TokenDefaultDacl, TokenSource, TokenType, TokenImpersonationLevel, TokenStatistics,  };
alias TOKEN_INFORMATION_CLASS _TOKEN_INFORMATION_CLASS;
alias int TOKEN_TYPE;
enum { TokenPrimary = 1, TokenImpersonation,  };
alias TOKEN_TYPE TAGTOKEN_TYPE;

extern(Windows){
alias int (*BFFCALLBACK)(HWND, UINT, LPARAM, LPARAM);
alias UINT (*LPCCHOOKPROC)(HWND, UINT, WPARAM, LPARAM);
alias UINT (*LPCFHOOKPROC)(HWND, UINT, WPARAM, LPARAM);
alias POINTER PTHREAD_START_ROUTINE;
alias PTHREAD_START_ROUTINE LPTHREAD_START_ROUTINE;
alias DWORD (*EDITSTREAMCALLBACK)(DWORD, LPBYTE, LONG, LONG);
alias UINT (*LPFRHOOKPROC)(HWND, UINT, WPARAM, LPARAM);
alias UINT (*LPOFNHOOKPROC)(HWND, UINT, WPARAM, LPARAM);
alias UINT (*LPPRINTHOOKPROC)(HWND, UINT, WPARAM, LPARAM);
alias UINT (*LPSETUPHOOKPROC)(HWND, UINT, WPARAM, LPARAM);
alias LRESULT (*DLGPROC)(HWND, UINT, WPARAM, LPARAM);
alias int (*PFNPROPSHEETCALLBACK)(HWND, UINT, LPARAM);
alias void (*LPSERVICE_MAIN_FUNCTION)(DWORD, LPTSTR);
alias int (*PFNTVCOMPARE)(LPARAM, LPARAM, LPARAM);
alias LRESULT (*WNDPROC)(HWND, UINT, WPARAM, LPARAM);
alias POINTER FARPROC;
alias FARPROC PROC;
alias WINBOOL (*ENUMRESTYPEPROC)(HANDLE, LPTSTR, LONG);
alias WINBOOL (*ENUMRESNAMEPROC)(HANDLE, LPCTSTR, LPTSTR, LONG);
alias WINBOOL (*ENUMRESLANGPROC)(HANDLE, LPCTSTR, LPCTSTR, ushort, LONG);
alias FARPROC DESKTOPENUMPROC;
alias WINBOOL (*ENUMWINDOWSPROC)(HWND, LPARAM);
alias WINBOOL (*ENUMWINDOWSTATIONPROC)(LPTSTR, LPARAM);
alias void (*SENDASYNCPROC)(HWND, UINT, DWORD);
alias void (*TIMERPROC)(HWND, UINT, UINT, DWORD);
alias BOOL(*MONITORENUMPROC)(HMONITOR, HDC, RECT*, LPARAM);
alias FARPROC GRAYSTRINGPROC;
alias WINBOOL (*DRAWSTATEPROC)(HDC, LPARAM, WPARAM, int, int);
alias WINBOOL (*PROPENUMPROCEX)(HWND, LPCTSTR, HANDLE, DWORD);
alias WINBOOL (*PROPENUMPROC)(HWND, LPCTSTR, HANDLE);
alias LRESULT (*HOOKPROC)(int, WPARAM, LPARAM);
alias void (*ENUMOBJECTSPROC)(LPVOID);
alias void (*LINEDDAPROC)(int, int);
alias WINBOOL (*TABORTPROC)(HDC, int);
alias UINT (*LPPAGEPAINTHOOK)(HWND, UINT, WPARAM, LPARAM);
alias UINT (*LPPAGESETUPHOOK)(HWND, UINT, WPARAM, LPARAM);
alias int (*ICMENUMPROC)(LPTSTR, LPARAM);
alias LONG (*EDITWORDBREAKPROCEX)(PCHAR, LONG, ubyte, INT);
alias int (*PFNLVCOMPARE)(LPARAM, LPARAM, LPARAM);
alias WINBOOL (*LOCALE_ENUMPROC)(LPTSTR);
alias WINBOOL (*CODEPAGE_ENUMPROC)(LPTSTR);
alias WINBOOL (*DATEFMT_ENUMPROC)(LPTSTR);
alias WINBOOL (*TIMEFMT_ENUMPROC)(LPTSTR);
alias WINBOOL (*CALINFO_ENUMPROC)(LPTSTR);
alias WINBOOL (*PHANDLER_ROUTINE)(DWORD);
alias WINBOOL (*LPHANDLER_FUNCTION)(DWORD);
alias void (*PTIMERAPCROUTINE)(LPVOID, DWORD, DWORD);
alias UINT (*PFNGETPROFILEPATH)(LPCTSTR, LPSTR, UINT);
alias UINT (*PFNRECONCILEPROFILE)(LPCTSTR, LPCTSTR, DWORD);
alias WINBOOL (*PFNPROCESSPOLICIES)(HWND, LPCTSTR, LPCTSTR, LPCTSTR, DWORD);
}

const 
{
 LPCTSTR SE_CREATE_TOKEN_NAME = ("SeCreateTokenPrivilege");
 LPCTSTR SE_ASSIGNPRIMARYTOKEN_NAME = ("SeAssignPrimaryTokenPrivilege");
 LPCTSTR SE_LOCK_MEMORY_NAME = ("SeLockMemoryPrivilege");
 LPCTSTR SE_INCREASE_QUOTA_NAME = ("SeIncreaseQuotaPrivilege");
 LPCTSTR SE_UNSOLICITED_INPUT_NAME = ("SeUnsolicitedInputPrivilege");
 LPCTSTR SE_MACHINE_ACCOUNT_NAME = ("SeMachineAccountPrivilege");
 LPCTSTR SE_TCB_NAME = ("SeTcbPrivilege");
 LPCTSTR SE_SECURITY_NAME = ("SeSecurityPrivilege");
 LPCTSTR SE_TAKE_OWNERSHIP_NAME = ("SeTakeOwnershipPrivilege");
 LPCTSTR SE_LOAD_DRIVER_NAME = ("SeLoadDriverPrivilege");
 LPCTSTR SE_SYSTEM_PROFILE_NAME = ("SeSystemProfilePrivilege");
 LPCTSTR SE_SYSTEMTIME_NAME = ("SeSystemtimePrivilege");
 LPCTSTR SE_PROF_SINGLE_PROCESS_NAME = ("SeProfileSingleProcessPrivilege");
 LPCTSTR SE_INC_BASE_PRIORITY_NAME = ("SeIncreaseBasePriorityPrivilege");
 LPCTSTR SE_CREATE_PAGEFILE_NAME = ("SeCreatePagefilePrivilege");
 LPCTSTR SE_CREATE_PERMANENT_NAME = ("SeCreatePermanentPrivilege");
 LPCTSTR SE_BACKUP_NAME = ("SeBackupPrivilege");
 LPCTSTR SE_RESTORE_NAME = ("SeRestorePrivilege");
 LPCTSTR SE_SHUTDOWN_NAME = ("SeShutdownPrivilege");
 LPCTSTR SE_DEBUG_NAME = ("SeDebugPrivilege");
 LPCTSTR SE_AUDIT_NAME = ("SeAuditPrivilege");
 LPCTSTR SE_SYSTEM_ENVIRONMENT_NAME = ("SeSystemEnvironmentPrivilege");
 LPCTSTR SE_CHANGE_NOTIFY_NAME = ("SeChangeNotifyPrivilege");
 LPCTSTR SE_REMOTE_SHUTDOWN_NAME = ("SeRemoteShutdownPrivilege");

 LPCSTR  SERVICES_ACTIVE_DATABASEA = _PCHAR!("ServicesActive");
 LPCWSTR SERVICES_ACTIVE_DATABASEW = ("ServicesActive");
 LPCSTR  SERVICES_FAILED_DATABASEA = _PCHAR!("ServicesFailed");
 LPCWSTR SERVICES_FAILED_DATABASEW = ("ServicesFailed");
 LPCSTR  SC_GROUP_IDENTIFIERA = _PCHAR!("+");
 LPCWSTR SC_GROUP_IDENTIFIERW = ("+");
 version(Win32SansUnicode){
  alias SERVICES_ACTIVE_DATABASEA SERVICES_ACTIVE_DATABASE;
  alias SERVICES_FAILED_DATABASEA SERVICES_FAILED_DATABASE;
  alias SC_GROUP_IDENTIFIERA SC_GROUP_IDENTIFIER;
 }
 else{
  alias SERVICES_ACTIVE_DATABASEW SERVICES_ACTIVE_DATABASE;
  alias SERVICES_FAILED_DATABASEW SERVICES_FAILED_DATABASE;
  alias SC_GROUP_IDENTIFIERW SC_GROUP_IDENTIFIER;
 }
}

extern(Windows){
alias HDDEDATA (*PFNCALLBACK)(UINT, UINT, HCONV, HSZ, HSZ, HDDEDATA, DWORD, DWORD);
}
alias PFNCALLBACK CALLB;
alias WINBOOL SECURITY___FILE___TRACKING_MODE;
alias FARPROC WNDENUMPROC;
alias FARPROC ENHMFENUMPROC;
alias DWORD CCSTYLE;
alias CCSTYLE* PCCSTYLE;
alias CCSTYLE* LPCCSTYLE;
alias DWORD CCSTYLEFLAGA;
alias CCSTYLEFLAGA* PCCSTYLEFLAGA;
alias CCSTYLEFLAGA* LPCCSTYLEFLAGA;

const HANDLE INVALID_HANDLE_VALUE = cast(HANDLE) -1;


enum : DWORD 
{
 SM_XVIRTUALSCREEN = (76),
 SM_YVIRTUALSCREEN = (77),
 SM_CXVIRTUALSCREEN = (78),
 SM_CYVIRTUALSCREEN = (79),
 MONITORINFOF_PRIMARY = (1),
 LZERROR_UNKNOWNALG = -((8)),
 LZERROR_BADVALUE = -((7)),
 LZERROR_GLOBLOCK = -((6)),
 LZERROR_GLOBALLOC = -((5)),
 LZERROR_WRITE = -((4)),
 LZERROR_READ = -((3)),
 LZERROR_BADOUTHANDLE = -((2)),
 LZERROR_BADINHANDLE = -((1)),
 NO_ERROR = (0),
 ERROR_SUCCESS = (0),
 ERROR_INVALID_FUNCTION = (1),
 ERROR_FILE_NOT_FOUND = (2),
 ERROR_PATH_NOT_FOUND = (3),
 ERROR_TOO_MANY_OPEN_FILES = (4),
 ERROR_ACCESS_DENIED = (5),
 ERROR_INVALID_HANDLE = (6),
 ERROR_ARENA_TRASHED = (7),
 ERROR_NOT_ENOUGH_MEMORY = (8),
 ERROR_INVALID_BLOCK = (9),
 ERROR_BAD_ENVIRONMENT = (10),
 ERROR_BAD_FORMAT = (11),
 ERROR_INVALID_ACCESS = (12),
 ERROR_INVALID_DATA = (13),
 ERROR_OUTOFMEMORY = (14),
 ERROR_INVALID_DRIVE = (15),
 ERROR_CURRENT_DIRECTORY = (16),
 ERROR_NOT_SAME_DEVICE = (17),
 ERROR_NO_MORE_FILES = (18),
 ERROR_WRITE_PROTECT = (19),
 ERROR_BAD_UNIT = (20),
 ERROR_NOT_READY = (21),
 ERROR_BAD_COMMAND = (22),
 ERROR_CRC = (23),
 ERROR_BAD_LENGTH = (24),
 ERROR_SEEK = (25),
 ERROR_NOT_DOS_DISK = (26),
 ERROR_SECTOR_NOT_FOUND = (27),
 ERROR_OUT_OF_PAPER = (28),
 ERROR_WRITE_FAULT = (29),
 ERROR_READ_FAULT = (30),
 ERROR_GEN_FAILURE = (31),
 ERROR_SHARING_VIOLATION = (32),
 ERROR_LOCK_VIOLATION = (33),
 ERROR_WRONG_DISK = (34),
 ERROR_SHARING_BUFFER_EXCEEDED = (36),
 ERROR_HANDLE_EOF = (38),
 ERROR_HANDLE_DISK_FULL = (39),
 ERROR_NOT_SUPPORTED = (50),
 ERROR_REM_NOT_LIST = (51),
 ERROR_DUP_NAME = (52),
 ERROR_BAD_NETPATH = (53),
 ERROR_NETWORK_BUSY = (54),
 ERROR_DEV_NOT_EXIST = (55),
 ERROR_TOO_MANY_CMDS = (56),
 ERROR_ADAP_HDW_ERR = (57),
 ERROR_BAD_NET_RESP = (58),
 ERROR_UNEXP_NET_ERR = (59),
 ERROR_BAD_REM_ADAP = (60),
 ERROR_PRINTQ_FULL = (61),
 ERROR_NO_SPOOL_SPACE = (62),
 ERROR_PRINT_CANCELLED = (63),
 ERROR_NETNAME_DELETED = (64),
 ERROR_NETWORK_ACCESS_DENIED = (65),
 ERROR_BAD_DEV_TYPE = (66),
 ERROR_BAD_NET_NAME = (67),
 ERROR_TOO_MANY_NAMES = (68),
 ERROR_TOO_MANY_SESS = (69),
 ERROR_SHARING_PAUSED = (70),
 ERROR_REQ_NOT_ACCEP = (71),
 ERROR_REDIR_PAUSED = (72),
 ERROR_FILE_EXISTS = (80),
 ERROR_CANNOT_MAKE = (82),
 ERROR_FAIL_I24 = (83),
 ERROR_OUT_OF_STRUCTURES = (84),
 ERROR_ALREADY_ASSIGNED = (85),
 ERROR_INVALID_PASSWORD = (86),
 ERROR_INVALID_PARAMETER = (87),
 ERROR_NET_WRITE_FAULT = (88),
 ERROR_NO_PROC_SLOTS = (89),
 ERROR_TOO_MANY_SEMAPHORES = (100),
 ERROR_EXCL_SEM_ALREADY_OWNED = (101),
 ERROR_SEM_IS_SET = (102),
 ERROR_TOO_MANY_SEM_REQUESTS = (103),
 ERROR_INVALID_AT_INTERRUPT_TIME = (104),
 ERROR_SEM_OWNER_DIED = (105),
 ERROR_SEM_USER_LIMIT = (106),
 ERROR_DISK_CHANGE = (107),
 ERROR_DRIVE_LOCKED = (108),
 ERROR_BROKEN_PIPE = (109),
 ERROR_OPEN_FAILED = (110),
 ERROR_BUFFER_OVERFLOW = (111),
 ERROR_DISK_FULL = (112),
 ERROR_NO_MORE_SEARCH_HANDLES = (113),
 ERROR_INVALID_TARGET_HANDLE = (114),
 ERROR_INVALID_CATEGORY = (117),
 ERROR_INVALID_VERIFY_SWITCH = (118),
 ERROR_BAD_DRIVER_LEVEL = (119),
 ERROR_CALL_NOT_IMPLEMENTED = (120),
 ERROR_SEM_TIMEOUT = (121),
 ERROR_INSUFFICIENT_BUFFER = (122),
 ERROR_INVALID_NAME = (123),
 ERROR_INVALID_LEVEL = (124),
 ERROR_NO_VOLUME_LABEL = (125),
 ERROR_MOD_NOT_FOUND = (126),
 ERROR_PROC_NOT_FOUND = (127),
 ERROR_WAIT_NO_CHILDREN = (128),
 ERROR_CHILD_NOT_COMPLETE = (129),
 ERROR_DIRECT_ACCESS_HANDLE = (130),
 ERROR_NEGATIVE_SEEK = (131),
 ERROR_SEEK_ON_DEVICE = (132),
 ERROR_IS_JOIN_TARGET = (133),
 ERROR_IS_JOINED = (134),
 ERROR_IS_SUBSTED = (135),
 ERROR_NOT_JOINED = (136),
 ERROR_NOT_SUBSTED = (137),
 ERROR_JOIN_TO_JOIN = (138),
 ERROR_SUBST_TO_SUBST = (139),
 ERROR_JOIN_TO_SUBST = (140),
 ERROR_SUBST_TO_JOIN = (141),
 ERROR_BUSY_DRIVE = (142),
 ERROR_SAME_DRIVE = (143),
 ERROR_DIR_NOT_ROOT = (144),
 ERROR_DIR_NOT_EMPTY = (145),
 ERROR_IS_SUBST_PATH = (146),
 ERROR_IS_JOIN_PATH = (147),
 ERROR_PATH_BUSY = (148),
 ERROR_IS_SUBST_TARGET = (149),
 ERROR_SYSTEM_TRACE = (150),
 ERROR_INVALID_EVENT_COUNT = (151),
 ERROR_TOO_MANY_MUXWAITERS = (152),
 ERROR_INVALID_LIST_FORMAT = (153),
 ERROR_LABEL_TOO_LONG = (154),
 ERROR_TOO_MANY_TCBS = (155),
 ERROR_SIGNAL_REFUSED = (156),
 ERROR_DISCARDED = (157),
 ERROR_NOT_LOCKED = (158),
 ERROR_BAD_THREADID_ADDR = (159),
 ERROR_BAD_ARGUMENTS = (160),
 ERROR_BAD_PATHNAME = (161),
 ERROR_SIGNAL_PENDING = (162),
 ERROR_MAX_THRDS_REACHED = (164),
 ERROR_LOCK_FAILED = (167),
 ERROR_BUSY = (170),
 ERROR_CANCEL_VIOLATION = (173),
 ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = (174),
 ERROR_INVALID_SEGMENT_NUMBER = (180),
 ERROR_INVALID_ORDINAL = (182),
 ERROR_ALREADY_EXISTS = (183),
 ERROR_INVALID_FLAG_NUMBER = (186),
 ERROR_SEM_NOT_FOUND = (187),
 ERROR_INVALID_STARTING_CODESEG = (188),
 ERROR_INVALID_STACKSEG = (189),
 ERROR_INVALID_MODULETYPE = (190),
 ERROR_INVALID_EXE_SIGNATURE = (191),
 ERROR_EXE_MARKED_INVALID = (192),
 ERROR_BAD_EXE_FORMAT = (193),
 ERROR_ITERATED_DATA_EXCEEDS_64k = (194),
 ERROR_INVALID_MINALLOCSIZE = (195),
 ERROR_DYNLINK_FROM_INVALID_RING = (196),
 ERROR_IOPL_NOT_ENABLED = (197),
 ERROR_INVALID_SEGDPL = (198),
 ERROR_AUTODATASEG_EXCEEDS_64k = (199),
 ERROR_RING2SEG_MUST_BE_MOVABLE = (200),
 ERROR_RELOC_CHAIN_XEEDS_SEGLIM = (201),
 ERROR_INFLOOP_IN_RELOC_CHAIN = (202),
 ERROR_ENVVAR_NOT_FOUND = (203),
 ERROR_NO_SIGNAL_SENT = (205),
 ERROR_FILENAME_EXCED_RANGE = (206),
 ERROR_RING2_STACK_IN_USE = (207),
 ERROR_META_EXPANSION_TOO_LONG = (208),
 ERROR_INVALID_SIGNAL_NUMBER = (209),
 ERROR_THREAD_1_INACTIVE = (210),
 ERROR_LOCKED = (212),
 ERROR_TOO_MANY_MODULES = (214),
 ERROR_NESTING_NOT_ALLOWED = (215),
 ERROR_BAD_PIPE = (230),
 ERROR_PIPE_BUSY = (231),
 ERROR_NO_DATA = (232),
 ERROR_PIPE_NOT_CONNECTED = (233),
 ERROR_MORE_DATA = (234),
 ERROR_VC_DISCONNECTED = (240),
 ERROR_INVALID_EA_NAME = (254),
 ERROR_EA_LIST_INCONSISTENT = (255),
 ERROR_NO_MORE_ITEMS = (259),
 ERROR_CANNOT_COPY = (266),
 ERROR_DIRECTORY = (267),
 ERROR_EAS_DIDNT_FIT = (275),
 ERROR_EA_FILE_CORRUPT = (276),
 ERROR_EA_TABLE_FULL = (277),
 ERROR_INVALID_EA_HANDLE = (278),
 ERROR_EAS_NOT_SUPPORTED = (282),
 ERROR_NOT_OWNER = (288),
 ERROR_TOO_MANY_POSTS = (298),
 ERROR_PARTIAL_COPY = (299),
 ERROR_MR_MID_NOT_FOUND = (317),
 ERROR_INVALID_ADDRESS = (487),
 ERROR_ARITHMETIC_OVERFLOW = (534),
 ERROR_PIPE_CONNECTED = (535),
 ERROR_PIPE_LISTENING = (536),
 ERROR_EA_ACCESS_DENIED = (994),
 ERROR_OPERATION_ABORTED = (995),
 ERROR_IO_INCOMPLETE = (996),
 ERROR_IO_PENDING = (997),
 ERROR_NOACCESS = (998),
 ERROR_SWAPERROR = (999),
 ERROR_STACK_OVERFLOW = (1001),
 ERROR_INVALID_MESSAGE = (1002),
 ERROR_CAN_NOT_COMPLETE = (1003),
 ERROR_INVALID_FLAGS = (1004),
 ERROR_UNRECOGNIZED_VOLUME = (1005),
 ERROR_FILE_INVALID = (1006),
 ERROR_FULLSCREEN_MODE = (1007),
 ERROR_NO_TOKEN = (1008),
 ERROR_BADDB = (1009),
 ERROR_BADKEY = (1010),
 ERROR_CANTOPEN = (1011),
 ERROR_CANTREAD = (1012),
 ERROR_CANTWRITE = (1013),
 ERROR_REGISTRY_RECOVERED = (1014),
 ERROR_REGISTRY_CORRUPT = (1015),
 ERROR_REGISTRY_IO_FAILED = (1016),
 ERROR_NOT_REGISTRY_FILE = (1017),
 ERROR_KEY_DELETED = (1018),
 ERROR_NO_LOG_SPACE = (1019),
 ERROR_KEY_HAS_CHILDREN = (1020),
 ERROR_CHILD_MUST_BE_VOLATILE = (1021),
 ERROR_NOTIFY_ENUM_DIR = (1022),
 ERROR_DEPENDENT_SERVICES_RUNNING = (1051),
 ERROR_INVALID_SERVICE_CONTROL = (1052),
 ERROR_SERVICE_REQUEST_TIMEOUT = (1053),
 ERROR_SERVICE_NO_THREAD = (1054),
 ERROR_SERVICE_DATABASE_LOCKED = (1055),
 ERROR_SERVICE_ALREADY_RUNNING = (1056),
 ERROR_INVALID_SERVICE_ACCOUNT = (1057),
 ERROR_SERVICE_DISABLED = (1058),
 ERROR_CIRCULAR_DEPENDENCY = (1059),
 ERROR_SERVICE_DOES_NOT_EXIST = (1060),
 ERROR_SERVICE_CANNOT_ACCEPT_CTRL = (1061),
 ERROR_SERVICE_NOT_ACTIVE = (1062),
 ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = (1063),
 ERROR_EXCEPTION_IN_SERVICE = (1064),
 ERROR_DATABASE_DOES_NOT_EXIST = (1065),
 ERROR_SERVICE_SPECIFIC_ERROR = (1066),
 ERROR_PROCESS_ABORTED = (1067),
 ERROR_SERVICE_DEPENDENCY_FAIL = (1068),
 ERROR_SERVICE_LOGON_FAILED = (1069),
 ERROR_SERVICE_START_HANG = (1070),
 ERROR_INVALID_SERVICE_LOCK = (1071),
 ERROR_SERVICE_MARKED_FOR_DELETE = (1072),
 ERROR_SERVICE_EXISTS = (1073),
 ERROR_ALREADY_RUNNING_LKG = (1074),
 ERROR_SERVICE_DEPENDENCY_DELETED = (1075),
 ERROR_BOOT_ALREADY_ACCEPTED = (1076),
 ERROR_SERVICE_NEVER_STARTED = (1077),
 ERROR_DUPLICATE_SERVICE_NAME = (1078),
 ERROR_END_OF_MEDIA = (1100),
 ERROR_FILEMARK_DETECTED = (1101),
 ERROR_BEGINNING_OF_MEDIA = (1102),
 ERROR_SETMARK_DETECTED = (1103),
 ERROR_NO_DATA_DETECTED = (1104),
 ERROR_PARTITION_FAILURE = (1105),
 ERROR_INVALID_BLOCK_LENGTH = (1106),
 ERROR_DEVICE_NOT_PARTITIONED = (1107),
 ERROR_UNABLE_TO_LOCK_MEDIA = (1108),
 ERROR_UNABLE_TO_UNLOAD_MEDIA = (1109),
 ERROR_MEDIA_CHANGED = (1110),
 ERROR_BUS_RESET = (1111),
 ERROR_NO_MEDIA_IN_DRIVE = (1112),
 ERROR_NO_UNICODE_TRANSLATION = (1113),
 ERROR_DLL_INIT_FAILED = (1114),
 ERROR_SHUTDOWN_IN_PROGRESS = (1115),
 ERROR_NO_SHUTDOWN_IN_PROGRESS = (1116),
 ERROR_IO_DEVICE = (1117),
 ERROR_SERIAL_NO_DEVICE = (1118),
 ERROR_IRQ_BUSY = (1119),
 ERROR_MORE_WRITES = (1120),
 ERROR_COUNTER_TIMEOUT = (1121),
 ERROR_FLOPPY_ID_MARK_NOT_FOUND = (1122),
 ERROR_FLOPPY_WRONG_CYLINDER = (1123),
 ERROR_FLOPPY_UNKNOWN_ERROR = (1124),
 ERROR_FLOPPY_BAD_REGISTERS = (1125),
 ERROR_DISK_RECALIBRATE_FAILED = (1126),
 ERROR_DISK_OPERATION_FAILED = (1127),
 ERROR_DISK_RESET_FAILED = (1128),
 ERROR_EOM_OVERFLOW = (1129),
 ERROR_NOT_ENOUGH_SERVER_MEMORY = (1130),
 ERROR_POSSIBLE_DEADLOCK = (1131),
 ERROR_MAPPED_ALIGNMENT = (1132),
 ERROR_SET_POWER_STATE_VETOED = (1140),
 ERROR_SET_POWER_STATE_FAILED = (1141),
 ERROR_OLD_WIN_VERSION = (1150),
 ERROR_APP_WRONG_OS = (1151),
 ERROR_SINGLE_INSTANCE_APP = (1152),
 ERROR_RMODE_APP = (1153),
 ERROR_INVALID_DLL = (1154),
 ERROR_NO_ASSOCIATION = (1155),
 ERROR_DDE_FAIL = (1156),
 ERROR_DLL_NOT_FOUND = (1157),
 ERROR_BAD_USERNAME = (2202),
 ERROR_NOT_CONNECTED = (2250),
 ERROR_OPEN_FILES = (2401),
 ERROR_ACTIVE_CONNECTIONS = (2402),
 ERROR_DEVICE_IN_USE = (2404),
 ERROR_BAD_DEVICE = (1200),
 ERROR_CONNECTION_UNAVAIL = (1201),
 ERROR_DEVICE_ALREADY_REMEMBERED = (1202),
 ERROR_NO_NET_OR_BAD_PATH = (1203),
 ERROR_BAD_PROVIDER = (1204),
 ERROR_CANNOT_OPEN_PROFILE = (1205),
 ERROR_BAD_PROFILE = (1206),
 ERROR_NOT_CONTAINER = (1207),
 ERROR_EXTENDED_ERROR = (1208),
 ERROR_INVALID_GROUPNAME = (1209),
 ERROR_INVALID_COMPUTERNAME = (1210),
 ERROR_INVALID_EVENTNAME = (1211),
 ERROR_INVALID_DOMAINNAME = (1212),
 ERROR_INVALID_SERVICENAME = (1213),
 ERROR_INVALID_NETNAME = (1214),
 ERROR_INVALID_SHARENAME = (1215),
 ERROR_INVALID_PASSWORDNAME = (1216),
 ERROR_INVALID_MESSAGENAME = (1217),
 ERROR_INVALID_MESSAGEDEST = (1218),
 ERROR_SESSION_CREDENTIAL_CONFLICT = (1219),
 ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = (1220),
 ERROR_DUP_DOMAINNAME = (1221),
 ERROR_NO_NETWORK = (1222),
 ERROR_CANCELLED = (1223),
 ERROR_USER_MAPPED_FILE = (1224),
 ERROR_CONNECTION_REFUSED = (1225),
 ERROR_GRACEFUL_DISCONNECT = (1226),
 ERROR_ADDRESS_ALREADY_ASSOCIATED = (1227),
 ERROR_ADDRESS_NOT_ASSOCIATED = (1228),
 ERROR_CONNECTION_INVALID = (1229),
 ERROR_CONNECTION_ACTIVE = (1230),
 ERROR_NETWORK_UNREACHABLE = (1231),
 ERROR_HOST_UNREACHABLE = (1232),
 ERROR_PROTOCOL_UNREACHABLE = (1233),
 ERROR_PORT_UNREACHABLE = (1234),
 ERROR_REQUEST_ABORTED = (1235),
 ERROR_CONNECTION_ABORTED = (1236),
 ERROR_RETRY = (1237),
 ERROR_CONNECTION_COUNT_LIMIT = (1238),
 ERROR_LOGIN_TIME_RESTRICTION = (1239),
 ERROR_LOGIN_WKSTA_RESTRICTION = (1240),
 ERROR_INCORRECT_ADDRESS = (1241),
 ERROR_ALREADY_REGISTERED = (1242),
 ERROR_SERVICE_NOT_FOUND = (1243),
 ERROR_NOT_AUTHENTICATED = (1244),
 ERROR_NOT_LOGGED_ON = (1245),
 ERROR_CONTINUE = (1246),
 ERROR_ALREADY_INITIALIZED = (1247),
 ERROR_NO_MORE_DEVICES = (1248),
 ERROR_NOT_ALL_ASSIGNED = (1300),
 ERROR_SOME_NOT_MAPPED = (1301),
 ERROR_NO_QUOTAS_FOR_ACCOUNT = (1302),
 ERROR_LOCAL_USER_SESSION_KEY = (1303),
 ERROR_NULL_LM_PASSWORD = (1304),
 ERROR_UNKNOWN_REVISION = (1305),
 ERROR_REVISION_MISMATCH = (1306),
 ERROR_INVALID_OWNER = (1307),
 ERROR_INVALID_PRIMARY_GROUP = (1308),
 ERROR_NO_IMPERSONATION_TOKEN = (1309),
 ERROR_CANT_DISABLE_MANDATORY = (1310),
 ERROR_NO_LOGON_SERVERS = (1311),
 ERROR_NO_SUCH_LOGON_SESSION = (1312),
 ERROR_NO_SUCH_PRIVILEGE = (1313),
 ERROR_PRIVILEGE_NOT_HELD = (1314),
 ERROR_INVALID_ACCOUNT_NAME = (1315),
 ERROR_USER_EXISTS = (1316),
 ERROR_NO_SUCH_USER = (1317),
 ERROR_GROUP_EXISTS = (1318),
 ERROR_NO_SUCH_GROUP = (1319),
 ERROR_MEMBER_IN_GROUP = (1320),
 ERROR_MEMBER_NOT_IN_GROUP = (1321),
 ERROR_LAST_ADMIN = (1322),
 ERROR_WRONG_PASSWORD = (1323),
 ERROR_ILL_FORMED_PASSWORD = (1324),
 ERROR_PASSWORD_RESTRICTION = (1325),
 ERROR_LOGON_FAILURE = (1326),
 ERROR_ACCOUNT_RESTRICTION = (1327),
 ERROR_INVALID_LOGON_HOURS = (1328),
 ERROR_INVALID_WORKSTATION = (1329),
 ERROR_PASSWORD_EXPIRED = (1330),
 ERROR_ACCOUNT_DISABLED = (1331),
 ERROR_NONE_MAPPED = (1332),
 ERROR_TOO_MANY_LUIDS_REQUESTED = (1333),
 ERROR_LUIDS_EXHAUSTED = (1334),
 ERROR_INVALID_SUB_AUTHORITY = (1335),
 ERROR_INVALID_ACL = (1336),
 ERROR_INVALID_SID = (1337),
 ERROR_INVALID_SECURITY_DESCR = (1338),
 ERROR_BAD_INHERITANCE_ACL = (1340),
 ERROR_SERVER_DISABLED = (1341),
 ERROR_SERVER_NOT_DISABLED = (1342),
 ERROR_INVALID_ID_AUTHORITY = (1343),
 ERROR_ALLOTTED_SPACE_EXCEEDED = (1344),
 ERROR_INVALID_GROUP_ATTRIBUTES = (1345),
 ERROR_BAD_IMPERSONATION_LEVEL = (1346),
 ERROR_CANT_OPEN_ANONYMOUS = (1347),
 ERROR_BAD_VALIDATION_CLASS = (1348),
 ERROR_BAD_TOKEN_TYPE = (1349),
 ERROR_NO_SECURITY_ON_OBJECT = (1350),
 ERROR_CANT_ACCESS_DOMAIN_INFO = (1351),
 ERROR_INVALID_SERVER_STATE = (1352),
 ERROR_INVALID_DOMAIN_STATE = (1353),
 ERROR_INVALID_DOMAIN_ROLE = (1354),
 ERROR_NO_SUCH_DOMAIN = (1355),
 ERROR_DOMAIN_EXISTS = (1356),
 ERROR_DOMAIN_LIMIT_EXCEEDED = (1357),
 ERROR_INTERNAL_DB_CORRUPTION = (1358),
 ERROR_INTERNAL_ERROR = (1359),
 ERROR_GENERIC_NOT_MAPPED = (1360),
 ERROR_BAD_DESCRIPTOR_FORMAT = (1361),
 ERROR_NOT_LOGON_PROCESS = (1362),
 ERROR_LOGON_SESSION_EXISTS = (1363),
 ERROR_NO_SUCH_PACKAGE = (1364),
 ERROR_BAD_LOGON_SESSION_STATE = (1365),
 ERROR_LOGON_SESSION_COLLISION = (1366),
 ERROR_INVALID_LOGON_TYPE = (1367),
 ERROR_CANNOT_IMPERSONATE = (1368),
 ERROR_RXACT_INVALID_STATE = (1369),
 ERROR_RXACT_COMMIT_FAILURE = (1370),
 ERROR_SPECIAL_ACCOUNT = (1371),
 ERROR_SPECIAL_GROUP = (1372),
 ERROR_SPECIAL_USER = (1373),
 ERROR_MEMBERS_PRIMARY_GROUP = (1374),
 ERROR_TOKEN_ALREADY_IN_USE = (1375),
 ERROR_NO_SUCH_ALIAS = (1376),
 ERROR_MEMBER_NOT_IN_ALIAS = (1377),
 ERROR_MEMBER_IN_ALIAS = (1378),
 ERROR_ALIAS_EXISTS = (1379),
 ERROR_LOGON_NOT_GRANTED = (1380),
 ERROR_TOO_MANY_SECRETS = (1381),
 ERROR_SECRET_TOO_LONG = (1382),
 ERROR_INTERNAL_DB_ERROR = (1383),
 ERROR_TOO_MANY___FILE___IDS = (1384),
 ERROR_LOGON_TYPE_NOT_GRANTED = (1385),
 ERROR_NT_CROSS_ENCRYPTION_REQUIRED = (1386),
 ERROR_NO_SUCH_MEMBER = (1387),
 ERROR_INVALID_MEMBER = (1388),
 ERROR_TOO_MANY_SIDS = (1389),
 ERROR_LM_CROSS_ENCRYPTION_REQUIRED = (1390),
 ERROR_NO_INHERITANCE = (1391),
 ERROR_FILE_CORRUPT = (1392),
 ERROR_DISK_CORRUPT = (1393),
 ERROR_NO_USER_SESSION_KEY = (1394),
 ERROR_LICENSE_QUOTA_EXCEEDED = (1395),
 ERROR_INVALID_WINDOW_HANDLE = (1400),
 ERROR_INVALID_MENU_HANDLE = (1401),
 ERROR_INVALID_CURSOR_HANDLE = (1402),
 ERROR_INVALID_ACCEL_HANDLE = (1403),
 ERROR_INVALID_HOOK_HANDLE = (1404),
 ERROR_INVALID_DWP_HANDLE = (1405),
 ERROR_TLW_WITH_WSCHILD = (1406),
 ERROR_CANNOT_FIND_WND_CLASS = (1407),
 ERROR_WINDOW_OF_OTHER_THREAD = (1408),
 ERROR_HOTKEY_ALREADY_REGISTERED = (1409),
 ERROR_CLASS_ALREADY_EXISTS = (1410),
 ERROR_CLASS_DOES_NOT_EXIST = (1411),
 ERROR_CLASS_HAS_WINDOWS = (1412),
 ERROR_INVALID_INDEX = (1413),
 ERROR_INVALID_ICON_HANDLE = (1414),
 ERROR_PRIVATE_DIALOG_INDEX = (1415),
 ERROR_LISTBOX_ID_NOT_FOUND = (1416),
 ERROR_NO_WILDCARD_CHARACTERS = (1417),
 ERROR_CLIPBOARD_NOT_OPEN = (1418),
 ERROR_HOTKEY_NOT_REGISTERED = (1419),
 ERROR_WINDOW_NOT_DIALOG = (1420),
 ERROR_CONTROL_ID_NOT_FOUND = (1421),
 ERROR_INVALID_COMBOBOX_MESSAGE = (1422),
 ERROR_WINDOW_NOT_COMBOBOX = (1423),
 ERROR_INVALID_EDIT_HEIGHT = (1424),
 ERROR_DC_NOT_FOUND = (1425),
 ERROR_INVALID_HOOK_FILTER = (1426),
 ERROR_INVALID_FILTER_PROC = (1427),
 ERROR_HOOK_NEEDS_HMOD = (1428),
 ERROR_GLOBAL_ONLY_HOOK = (1429),
 ERROR_JOURNAL_HOOK_SET = (1430),
 ERROR_HOOK_NOT_INSTALLED = (1431),
 ERROR_INVALID_LB_MESSAGE = (1432),
 ERROR_SETCOUNT_ON_BAD_LB = (1433),
 ERROR_LB_WITHOUT_TABSTOPS = (1434),
 ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = (1435),
 ERROR_CHILD_WINDOW_MENU = (1436),
 ERROR_NO_SYSTEM_MENU = (1437),
 ERROR_INVALID_MSGBOX_STYLE = (1438),
 ERROR_INVALID_SPI_VALUE = (1439),
 ERROR_SCREEN_ALREADY_LOCKED = (1440),
 ERROR_HWNDS_HAVE_DIFF_PARENT = (1441),
 ERROR_NOT_CHILD_WINDOW = (1442),
 ERROR_INVALID_GW_COMMAND = (1443),
 ERROR_INVALID_THREAD_ID = (1444),
 ERROR_NON_MDICHILD_WINDOW = (1445),
 ERROR_POPUP_ALREADY_ACTIVE = (1446),
 ERROR_NO_SCROLLBARS = (1447),
 ERROR_INVALID_SCROLLBAR_RANGE = (1448),
 ERROR_INVALID_SHOWWIN_COMMAND = (1449),
 ERROR_NO_SYSTEM_RESOURCES = (1450),
 ERROR_NONPAGED_SYSTEM_RESOURCES = (1451),
 ERROR_PAGED_SYSTEM_RESOURCES = (1452),
 ERROR_WORKING_SET_QUOTA = (1453),
 ERROR_PAGEFILE_QUOTA = (1454),
 ERROR_COMMITMENT_LIMIT = (1455),
 ERROR_MENU_ITEM_NOT_FOUND = (1456),
 ERROR_EVENTLOG_FILE_CORRUPT = (1500),
 ERROR_EVENTLOG_CANT_START = (1501),
 ERROR_LOG_FILE_FULL = (1502),
 ERROR_EVENTLOG_FILE_CHANGED = (1503),
 RPC_S_INVALID_STRING_BINDING = (1700),
 RPC_S_WRONG_KIND_OF_BINDING = (1701),
 RPC_S_INVALID_BINDING = (1702),
 RPC_S_PROTSEQ_NOT_SUPPORTED = (1703),
 RPC_S_INVALID_RPC_PROTSEQ = (1704),
 RPC_S_INVALID_STRING_UUID = (1705),
 RPC_S_INVALID_ENDPOINT_FORMAT = (1706),
 RPC_S_INVALID_NET_ADDR = (1707),
 RPC_S_NO_ENDPOINT_FOUND = (1708),
 RPC_S_INVALID_TIMEOUT = (1709),
 RPC_S_OBJECT_NOT_FOUND = (1710),
 RPC_S_ALREADY_REGISTERED = (1711),
 RPC_S_TYPE_ALREADY_REGISTERED = (1712),
 RPC_S_ALREADY_LISTENING = (1713),
 RPC_S_NO_PROTSEQS_REGISTERED = (1714),
 RPC_S_NOT_LISTENING = (1715),
 RPC_S_UNKNOWN_MGR_TYPE = (1716),
 RPC_S_UNKNOWN_IF = (1717),
 RPC_S_NO_BINDINGS = (1718),
 RPC_S_NO_PROTSEQS = (1719),
 RPC_S_CANT_CREATE_ENDPOINT = (1720),
 RPC_S_OUT_OF_RESOURCES = (1721),
 RPC_S_SERVER_UNAVAILABLE = (1722),
 RPC_S_SERVER_TOO_BUSY = (1723),
 RPC_S_INVALID_NETWORK_OPTIONS = (1724),
 RPC_S_NO_CALL_ACTIVE = (1725),
 RPC_S_CALL_FAILED = (1726),
 RPC_S_CALL_FAILED_DNE = (1727),
 RPC_S_PROTOCOL_ERROR = (1728),
 RPC_S_UNSUPPORTED_TRANS_SYN = (1730),
 RPC_S_UNSUPPORTED_TYPE = (1732),
 RPC_S_INVALID_TAG = (1733),
 RPC_S_INVALID_BOUND = (1734),
 RPC_S_NO_ENTRY_NAME = (1735),
 RPC_S_INVALID_NAME_SYNTAX = (1736),
 RPC_S_UNSUPPORTED_NAME_SYNTAX = (1737),
 RPC_S_UUID_NO_ADDRESS = (1739),
 RPC_S_DUPLICATE_ENDPOINT = (1740),
 RPC_S_UNKNOWN_AUTHN_TYPE = (1741),
 RPC_S_MAX_CALLS_TOO_SMALL = (1742),
 RPC_S_STRING_TOO_LONG = (1743),
 RPC_S_PROTSEQ_NOT_FOUND = (1744),
 RPC_S_PROCNUM_OUT_OF_RANGE = (1745),
 RPC_S_BINDING_HAS_NO_AUTH = (1746),
 RPC_S_UNKNOWN_AUTHN_SERVICE = (1747),
 RPC_S_UNKNOWN_AUTHN_LEVEL = (1748),
 RPC_S_INVALID_AUTH_IDENTITY = (1749),
 RPC_S_UNKNOWN_AUTHZ_SERVICE = (1750),
 EPT_S_INVALID_ENTRY = (1751),
 EPT_S_CANT_PERFORM_OP = (1752),
 EPT_S_NOT_REGISTERED = (1753),
 RPC_S_NOTHING_TO_EXPORT = (1754),
 RPC_S_INCOMPLETE_NAME = (1755),
 RPC_S_INVALID_VERS_OPTION = (1756),
 RPC_S_NO_MORE_MEMBERS = (1757),
 RPC_S_NOT_ALL_OBJS_UNEXPORTED = (1758),
 RPC_S_INTERFACE_NOT_FOUND = (1759),
 RPC_S_ENTRY_ALREADY_EXISTS = (1760),
 RPC_S_ENTRY_NOT_FOUND = (1761),
 RPC_S_NAME_SERVICE_UNAVAILABLE = (1762),
 RPC_S_INVALID_NAF_ID = (1763),
 RPC_S_CANNOT_SUPPORT = (1764),
 RPC_S_NO___FILE___AVAILABLE = (1765),
 RPC_S_INTERNAL_ERROR = (1766),
 RPC_S_ZERO_DIVIDE = (1767),
 RPC_S_ADDRESS_ERROR = (1768),
 RPC_S_FP_DIV_ZERO = (1769),
 RPC_S_FP_UNDERFLOW = (1770),
 RPC_S_FP_OVERFLOW = (1771),
 RPC_X_NO_MORE_ENTRIES = (1772),
 RPC_X_SS_CHAR_TRANS_OPEN_FAIL = (1773),
 RPC_X_SS_CHAR_TRANS_SHORT_FILE = (1774),
 RPC_X_SS_IN_NULL___FILE__ = (1775),
 RPC_X_SS___FILE___DAMAGED = (1777),
 RPC_X_SS_HANDLES_MISMATCH = (1778),
 RPC_X_SS_CANNOT_GET_CALL_HANDLE = (1779),
 RPC_X_NULL_REF_POINTER = (1780),
 RPC_X_ENUM_VALUE_OUT_OF_RANGE = (1781),
 RPC_X_BYTE_COUNT_TOO_SMALL = (1782),
 RPC_X_BAD_STUB_DATA = (1783),
 ERROR_INVALID_USER_BUFFER = (1784),
 ERROR_UNRECOGNIZED_MEDIA = (1785),
 ERROR_NO_TRUST_LSA_SECRET = (1786),
 ERROR_NO_TRUST_SAM_ACCOUNT = (1787),
 ERROR_TRUSTED_DOMAIN_FAILURE = (1788),
 ERROR_TRUSTED_RELATIONSHIP_FAILURE = (1789),
 ERROR_TRUST_FAILURE = (1790),
 RPC_S_CALL_IN_PROGRESS = (1791),
 ERROR_NETLOGON_NOT_STARTED = (1792),
 ERROR_ACCOUNT_EXPIRED = (1793),
 ERROR_REDIRECTOR_HAS_OPEN_HANDLES = (1794),
 ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = (1795),
 ERROR_UNKNOWN_PORT = (1796),
 ERROR_UNKNOWN_PRINTER_DRIVER = (1797),
 ERROR_UNKNOWN_PRINTPROCESSOR = (1798),
 ERROR_INVALID_SEPARATOR_FILE = (1799),
 ERROR_INVALID_PRIORITY = (1800),
 ERROR_INVALID_PRINTER_NAME = (1801),
 ERROR_PRINTER_ALREADY_EXISTS = (1802),
 ERROR_INVALID_PRINTER_COMMAND = (1803),
 ERROR_INVALID_DATATYPE = (1804),
 ERROR_INVALID_ENVIRONMENT = (1805),
 RPC_S_NO_MORE_BINDINGS = (1806),
 ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = (1807),
 ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = (1808),
 ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = (1809),
 ERROR_DOMAIN_TRUST_INCONSISTENT = (1810),
 ERROR_SERVER_HAS_OPEN_HANDLES = (1811),
 ERROR_RESOURCE_DATA_NOT_FOUND = (1812),
 ERROR_RESOURCE_TYPE_NOT_FOUND = (1813),
 ERROR_RESOURCE_NAME_NOT_FOUND = (1814),
 ERROR_RESOURCE_LANG_NOT_FOUND = (1815),
 ERROR_NOT_ENOUGH_QUOTA = (1816),
 RPC_S_NO_INTERFACES = (1817),
 RPC_S_CALL_CANCELLED = (1818),
 RPC_S_BINDING_INCOMPLETE = (1819),
 RPC_S_COMM_FAILURE = (1820),
 RPC_S_UNSUPPORTED_AUTHN_LEVEL = (1821),
 RPC_S_NO_PRINC_NAME = (1822),
 RPC_S_NOT_RPC_ERROR = (1823),
 RPC_S_UUID_LOCAL_ONLY = (1824),
 RPC_S_SEC_PKG_ERROR = (1825),
 RPC_S_NOT_CANCELLED = (1826),
 RPC_X_INVALID_ES_ACTION = (1827),
 RPC_X_WRONG_ES_VERSION = (1828),
 RPC_X_WRONG_STUB_VERSION = (1829),
 RPC_S_GROUP_MEMBER_NOT_FOUND = (1898),
 EPT_S_CANT_CREATE = (1899),
 RPC_S_INVALID_OBJECT = (1900),
 ERROR_INVALID_TIME = (1901),
 ERROR_INVALID_FORM_NAME = (1902),
 ERROR_INVALID_FORM_SIZE = (1903),
 ERROR_ALREADY_WAITING = (1904),
 ERROR_PRINTER_DELETED = (1905),
 ERROR_INVALID_PRINTER_STATE = (1906),
 ERROR_PASSWORD_MUST_CHANGE = (1907),
 ERROR_DOMAIN_CONTROLLER_NOT_FOUND = (1908),
 ERROR_ACCOUNT_LOCKED_OUT = (1909),
 ERROR_NO_BROWSER_SERVERS_FOUND = (6118),
 ERROR_INVALID_PIXEL_FORMAT = (2000),
 ERROR_BAD_DRIVER = (2001),
 ERROR_INVALID_WINDOW_STYLE = (2002),
 ERROR_METAFILE_NOT_SUPPORTED = (2003),
 ERROR_TRANSFORM_NOT_SUPPORTED = (2004),
 ERROR_CLIPPING_NOT_SUPPORTED = (2005),
 ERROR_UNKNOWN_PRINT_MONITOR = (3000),
 ERROR_PRINTER_DRIVER_IN_USE = (3001),
 ERROR_SPOOL_FILE_NOT_FOUND = (3002),
 ERROR_SPL_NO_STARTDOC = (3003),
 ERROR_SPL_NO_ADDJOB = (3004),
 ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = (3005),
 ERROR_PRINT_MONITOR_ALREADY_INSTALLED = (3006),
 ERROR_WINS_INTERNAL = (4000),
 ERROR_CAN_NOT_DEL_LOCAL_WINS = (4001),
 ERROR_STATIC_INIT = (4002),
 ERROR_INC_BACKUP = (4003),
 ERROR_FULL_BACKUP = (4004),
 ERROR_REC_NON_EXISTENT = (4005),
 ERROR_RPL_NOT_ALLOWED = (4006),
 MAX_PATH = (260),
 LF_FACESIZE = (32),
 LF_FULLFACESIZE = (64),
 ELF_VENDOR_SIZE = (4),
 SECURITY_STATIC_TRACKING = (0),
 SECURITY_DYNAMIC_TRACKING = (1),
 MAX_DEFAULTCHAR = (2),
 MAX_LEADBYTES = (12),
 EXCEPTION_MAXIMUM_PARAMETERS = (15),
 CCHDEVICENAME = (32),
 CCHFORMNAME = (32),
 MENU_TEXT_LEN = (40),
 MAX_LANA = (254),
 NCBNAMSZ = (16),
 NETBIOS_NAME_LEN = (16),
 OFS_MAXPATHNAME = (128),
 MAX_TAB_STOPS = (32),
 ANYSIZE_ARRAY = (1),
 RAS_MaxCallbackNumber = (128),
 RAS_MaxDeviceName = (128),
 RAS_MaxDeviceType = (16),
 RAS_MaxEntryName = (256),
 RAS_MaxIpAddress = (15),
 RAS_MaxIpxAddress = (21),
 RAS_MaxPhoneNumber = (128),
 UNLEN = (256),
 PWLEN = (256),
 CNLEN = (15),
 DNLEN = (15),
 MAXDWORD = (0xFFFFFFFF),
 MAXWORD = (0xFFFF),
 MAXBYTE = (0xFF),
 MINCHAR = (0x80),
 MAXCHAR = (0x7F),
 MINSHORT = (0x8000),
 MAXSHORT = (0x7FFF),
 MINLONG = (0x80000000),
 MAXLONG = (0x7FFFFFFF),
 FILE_BEGIN = (0),
 FILE_CURRENT = (1),
 FILE_END = (2),
 OF_READ = (0),
 OF_READWRITE = (2),
 OF_WRITE = (1),
 OF_SHARE_COMPAT = (0),
 OF_SHARE_DENY_NONE = (64),
 OF_SHARE_DENY_READ = (48),
 OF_SHARE_DENY_WRITE = (32),
 OF_SHARE_EXCLUSIVE = (16),
 OF_CANCEL = (2048),
 OF_CREATE = (4096),
 OF_DELETE = (512),
 OF_EXIST = (16384),
 OF_PARSE = (256),
 OF_PROMPT = (8192),
 OF_REOPEN = (32768),
 OF_VERIFY = (1024),
 HKL_NEXT = (1),
 HKL_PREV = (0),
 KLF_REORDER = (8),
 KLF_UNLOADPREVIOUS = (4),
 KLF_ACTIVATE = (1),
 KLF_NOTELLSHELL = (128),
 KLF_REPLACELANG = (16),
 KLF_SUBSTITUTE_OK = (2),
 MF_BITMAP = (0x4),
 MF_DISABLED = (0x2),
 MF_ENABLED = (0),
 MF_GRAYED = (0x1),
 MF_HELP = (0x4000),
 MF_MENUBARBREAK = (0x20),
 MF_MENUBREAK = (0x40),
 MF_MOUSESELECT = (0x8000),
 MF_OWNERDRAW = (0x100),
 MF_POPUP = (0x10),
 MF_SEPARATOR = (0x800),
 MF_STRING = (0),
 MF_SYSMENU = (0x2000),
 MF_USECHECKBITMAPS = (0x200),
 BLACKNESS = (0x00000042),
 NOTSRCERASE = (0x001100A6),
 NOTSRCCOPY = (0x00330008),
 SRCERASE = (0x00440328),
 DSTINVERT = (0x00550009),
 PATINVERT = (0x005A0049),
 SRCINVERT = (0x00660046),
 SRCAND = (0x008800C6),
 MERGEPAINT = (0x00BB0226),
 MERGECOPY = (0x00C000CA),
 SRCCOPY = (0x00CC0020),
 SRCPAINT = (0x00EE0086),
 PATCOPY = (0x00F00021),
 PATPAINT = (0x00FB0A09),
 WHITENESS = (0x00FF0062),
 R2_BLACK = (1),
 R2_COPYPEN = (13),
 R2_MASKNOTPEN = (3),
 R2_MASKPEN = (9),
 R2_MASKPENNOT = (5),
 R2_MERGENOTPEN = (12),
 R2_MERGEPEN = (15),
 R2_MERGEPENNOT = (14),
 R2_NOP = (11),
 R2_NOT = (6),
 R2_NOTCOPYPEN = (4),
 R2_NOTMASKPEN = (8),
 R2_NOTMERGEPEN = (2),
 R2_NOTXORPEN = (10),
 R2_WHITE = (16),
 R2_XORPEN = (7),
 BSF_FLUSHDISK = (4),
 BSF_FORCEIFHUNG = (32),
 BSF_IGNORECURRENTTASK = (2),
 BSF_NOHANG = (8),
 BSF_POSTMESSAGE = (16),
 BSF_QUERY = (1),
 BSM_ALLCOMPONENTS = (0),
 BSM_APPLICATIONS = (8),
 BSM_INSTALLABLEDRIVERS = (4),
 BSM_NETDRIVER = (2),
 BSM_VXDS = (1),
 BROADCAST_QUERY_DENY = (1112363332),
 NMPWAIT_NOWAIT = (1),
 NMPWAIT_WAIT_FOREVER = -((1)),
 NMPWAIT_USE_DEFAULT_WAIT = (0),
 MDITILE_SKIPDISABLED = (2),
 MDITILE_HORIZONTAL = (1),
 MDITILE_VERTICAL = (0),
 HCBT_ACTIVATE = (5),
 HCBT_CLICKSKIPPED = (6),
 HCBT_CREATEWND = (3),
 HCBT_DESTROYWND = (4),
 HCBT_KEYSKIPPED = (7),
 HCBT_MINMAX = (1),
 HCBT_MOVESIZE = (0),
 HCBT_QS = (2),
 HCBT_SETFOCUS = (9),
 HCBT_SYSCOMMAND = (8),
 DM_BITSPERPEL = (0x40000),
 DM_PELSWIDTH = (0x80000),
 DM_PELSHEIGHT = (0x100000),
 DM_DISPLAYFLAGS = (0x200000),
 DM_DISPLAYFREQUENCY = (0x400000),
 CDS_UPDATEREGISTRY = (1),
 CDS_TEST = (2),
 DISP_CHANGE_SUCCESSFUL = (0),
 DISP_CHANGE_RESTART = (1),
 DISP_CHANGE_BADFLAGS = -((4)),
 DISP_CHANGE_FAILED = -((1)),
 DISP_CHANGE_BADMODE = -((2)),
 DISP_CHANGE_NOTUPDATED = -((3)),
 SERVICE_NO_CHANGE = -((1)),
 SERVICE_WIN32_OWN_PROCESS = (16),
 SERVICE_WIN32_SHARE_PROCESS = (32),
 SERVICE_KERNEL_DRIVER = (1),
 SERVICE_FILE_SYSTEM_DRIVER = (2),
 SERVICE_INTERACTIVE_PROCESS = (256),
 SERVICE_BOOT_START = (0),
 SERVICE_SYSTEM_START = (1),
 SERVICE_AUTO_START = (2),
 SERVICE_DEMAND_START = (3),
 SERVICE_DISABLED = (4),
 SERVICE_STOPPED = (1),
 SERVICE_START_PENDING = (2),
 SERVICE_STOP_PENDING = (3),
 SERVICE_RUNNING = (4),
 SERVICE_CONTINUE_PENDING = (5),
 SERVICE_PAUSE_PENDING = (6),
 SERVICE_PAUSED = (7),
 SERVICE_ACCEPT_STOP = (1),
 SERVICE_ACCEPT_PAUSE_CONTINUE = (2),
 SERVICE_ACCEPT_SHUTDOWN = (4),
 BST_CHECKED = (1),
 BST_INDETERMINATE = (2),
 BST_UNCHECKED = (0),
 BST_FOCUS = (8),
 BST_PUSHED = (4),
 MF_BYCOMMAND = (0),
 MF_BYPOSITION = (0x400),
 MF_CHECKED = (0x8),
 MF_UNCHECKED = (0),
 MF_HILITE = (0x80),
 MF_UNHILITE = (0),
 CWP_ALL = (0),
 CWP_SKIPINVISIBLE = (1),
 CWP_SKIPDISABLED = (2),
 CWP_SKIPTRANSPARENT = (4),
 CE_BREAK = (16),
 CE_DNS = (2048),
 CE_FRAME = (8),
 CE_IOE = (1024),
 CE_MODE = (32768),
 CE_OOP = (4096),
 CE_OVERRUN = (2),
 CE_PTO = (512),
 CE_RXOVER = (1),
 CE_RXPARITY = (4),
 CE_TXFULL = (256),
 RGN_AND = (1),
 RGN_COPY = (5),
 RGN_DIFF = (4),
 RGN_OR = (2),
 RGN_XOR = (3),
 NULLREGION = (1),
 SIMPLEREGION = (2),
 COMPLEXREGION = (3),
 ERROR = (0),
 CDERR_DIALOGFAILURE = (0xffff),
 CDERR_FINDRESFAILURE = (6),
 CDERR_INITIALIZATION = (2),
 CDERR_LOADRESFAILURE = (7),
 CDERR_LOADSTRFAILURE = (5),
 CDERR_LOCKRESFAILURE = (8),
 CDERR_MEMALLOCFAILURE = (9),
 CDERR_MEMLOCKFAILURE = (10),
 CDERR_NOHINSTANCE = (4),
 CDERR_NOHOOK = (11),
 CDERR_NOTEMPLATE = (3),
 CDERR_REGISTERMSGFAIL = (12),
 CDERR_STRUCTSIZE = (1),
 PDERR_CREATEICFAILURE = (0x1000)+(10),
 PDERR_DEFAULTDIFFERENT = (0x1000)+(12),
 PDERR_DNDMMISMATCH = (0x1000)+(9),
 PDERR_GETDEVMODEFAIL = (0x1000)+(5),
 PDERR_INITFAILURE = (0x1000)+(6),
 PDERR_LOADDRVFAILURE = (0x1000)+(4),
 PDERR_NODEFAULTPRN = (0x1000)+(8),
 PDERR_NODEVICES = (0x1000)+(7),
 PDERR_PARSEFAILURE = (0x1000)+(2),
 PDERR_PRINTERNOTFOUND = (0x1000)+(11),
 PDERR_RETDEFFAILURE = (0x1000)+(3),
 PDERR_SETUPFAILURE = (0x1000)+(1),
 CFERR_MAXLESSTHANMIN = (0x2000)+(2),
 CFERR_NOFONTS = (0x2000)+(1),
 FNERR_BUFFERTOOSMALL = (0x3000)+(3),
 FNERR_INVALIDFILENAME = (0x3000)+(2),
 FNERR_SUBCLASSFAILURE = (0x3000)+(1),
 FRERR_BUFFERLENGTHZERO = (0x4000)+(1),
 LOCALE_SYSTEM_DEFAULT = (0x800),
 LOCALE_USER_DEFAULT = (0x400),
 NORM_IGNORECASE = (1),
 NORM_IGNOREKANATYPE = (65536),
 NORM_IGNORENONSPACE = (2),
 NORM_IGNORESYMBOLS = (4),
 NORM_IGNOREWIDTH = (131072),
 SORT_STRINGSORT = (4096),
 LCMAP_BYTEREV = (2048),
 LCMAP_FULLWIDTH = (8388608),
 LCMAP_HALFWIDTH = (4194304),
 LCMAP_HIRAGANA = (1048576),
 LCMAP_KATAKANA = (2097152),
 LCMAP_LOWERCASE = (256),
 LCMAP_SORTKEY = (1024),
 LCMAP_UPPERCASE = (512),
 DBG_CONTINUE = (0x10002),
 DBG_CONTROL_BREAK = (0x40010008),
 DBG_CONTROL_C = (0x40010005),
 DBG_EXCEPTION_NOT_HANDLED = (0x80010001),
 DBG_TERMINATE_THREAD = (0x40010003),
 DBG_TERMINATE_PROCESS = (0x40010004),
 SERVICE_CONTROL_STOP = (1),
 SERVICE_CONTROL_PAUSE = (2),
 SERVICE_CONTROL_CONTINUE = (3),
 SERVICE_CONTROL_INTERROGATE = (4),
 SERVICE_CONTROL_SHUTDOWN = (5),
 IMAGE_BITMAP = (0),
 IMAGE_CURSOR = (2),
 IMAGE_ENHMETAFILE = (1),
 IMAGE_ICON = (1),
 LR_COPYDELETEORG = (8),
 LR_COPYRETURNORG = (4),
 LR_MONOCHROME = (1),
 LR_CREATEDIBSECTION = (8192),
 LR_DEFAULTSIZE = (64),
 DF_ALLOWOTHERACCOUNTHOOK = (0x1),
 DESKTOP_CREATEMENU = (0x4),
 DESKTOP_CREATEWINDOW = (0x2),
 DESKTOP_ENUMERATE = (0x40),
 DESKTOP_HOOKCONTROL = (0x8),
 DESKTOP_JOURNALPLAYBACK = (0x20),
 DESKTOP_JOURNALRECORD = (0x10),
 DESKTOP_READOBJECTS = (0x1),
 DESKTOP_SWITCHDESKTOP = (0x100),
 DESKTOP_WRITEOBJECTS = (0x80),
 WSF_VISIBLE = (0x1),
 CBM_INIT = (0x4),
 DIB_PAL_COLORS = (1),
 DIB_RGB_COLORS = (0),
 GENERIC_READ = (0x80000000),
 GENERIC_WRITE = (0x40000000),
 GENERIC_EXECUTE = (0x20000000),
 FILE_READ_DATA = (0x0001),
 FILE_LIST_DIRECTORY = (0x0001),
 FILE_WRITE_DATA = (0x0002),
 FILE_ADD_FILE = (0x0002),
 FILE_APPEND_DATA = (0x0004),
 FILE_ADD_SUBDIRECTORY = (0x0004),
 FILE_CREATE_PIPE_INSTANCE = (0x0004),
 FILE_READ_EA = (0x0008),
 FILE_READ_PROPERTIES = (FILE_READ_EA),
 FILE_WRITE_EA = (0x0010),
 FILE_WRITE_PROPERTIES = (FILE_WRITE_EA),
 FILE_EXECUTE = (0x0020),
 FILE_TRAVERSE = (0x0020),
 FILE_DELETE_CHILD = (0x0040),
 FILE_READ_ATTRIBUTES = (0x0080),
 FILE_WRITE_ATTRIBUTES = (0x0100),
 FILE_SHARE_DELETE = (4),
 FILE_SHARE_READ = (1),
 FILE_SHARE_WRITE = (2),
 CONSOLE_TEXTMODE_BUFFER = (1),
 CREATE_NEW = (1),
 CREATE_ALWAYS = (2),
 OPEN_EXISTING = (3),
 OPEN_ALWAYS = (4),
 TRUNCATE_EXISTING = (5),
 INVALID_FILE_ATTRIBUTE = (-1),
 FILE_ATTRIBUTE_ARCHIVE = (32),
 FILE_ATTRIBUTE_COMPRESSED = (2048),
 FILE_ATTRIBUTE_NORMAL = (128),
 FILE_ATTRIBUTE_DIRECTORY = (16),
 FILE_ATTRIBUTE_HIDDEN = (2),
 FILE_ATTRIBUTE_READONLY = (1),
 FILE_ATTRIBUTE_SYSTEM = (4),
 FILE_ATTRIBUTE_TEMPORARY = (256),
 FILE_FLAG_WRITE_THROUGH = (2147483648),
 FILE_FLAG_OVERLAPPED = (1073741824),
 FILE_FLAG_NO_BUFFERING = (536870912),
 FILE_FLAG_RANDOM_ACCESS = (268435456),
 FILE_FLAG_SEQUENTIAL_SCAN = (134217728),
 FILE_FLAG_DELETE_ON_CLOSE = (67108864),
 FILE_FLAG_BACKUP_SEMANTICS = (33554432),
 FILE_FLAG_POSIX_SEMANTICS = (16777216),
 SECURITY_ANONYMOUS = (0),
 SECURITY_IDENTIFICATION = (65536),
 SECURITY_IMPERSONATION = (131072),
 SECURITY_DELEGATION = (196608),
 SECURITY___FILE___TRACKING = (262144),
 SECURITY_EFFECTIVE_ONLY = (524288),
 SECURITY_SQOS_PRESENT = (1048576),
 SEC_COMMIT = (134217728),
 SEC_IMAGE = (16777216),
 SEC_NOCACHE = (268435456),
 SEC_RESERVE = (67108864),
 PAGE_READONLY = (2),
 PAGE_READWRITE = (4),
 PAGE_WRITECOPY = (8),
 PAGE_EXECUTE = (16),
 PAGE_EXECUTE_READ = (32),
 PAGE_EXECUTE_READWRITE = (64),
 PAGE_EXECUTE_WRITECOPY = (128),
 PAGE_GUARD = (256),
 PAGE_NOACCESS = (1),
 PAGE_NOCACHE = (512),
 MEM_COMMIT = (4096),
 MEM_FREE = (65536),
 MEM_RESERVE = (8192),
 MEM_IMAGE = (16777216),
 MEM_MAPPED = (262144),
 MEM_PRIVATE = (131072),
 MEM_DECOMMIT = (16384),
 MEM_RELEASE = (32768),
 MEM_TOP_DOWN = (1048576),
 EXCEPTION_GUARD_PAGE = (0x80000001),
 SECTION_EXTEND_SIZE = (0x10),
 SECTION_MAP_READ = (0x4),
 SECTION_MAP_WRITE = (0x2),
 SECTION_QUERY = (0x1),
 SECTION_ALL_ACCESS = (0xf001f),
 FW_DONTCARE = (0),
 FW_THIN = (100),
 FW_EXTRALIGHT = (200),
 FW_LIGHT = (300),
 FW_NORMAL = (400),
 FW_REGULAR = (FW_NORMAL),
 FW_MEDIUM = (500),
 FW_SEMIBOLD = (600),
 FW_BOLD = (700),
 FW_EXTRABOLD = (800),
 FW_HEAVY = (900),
 ANSI_CHARSET = (0),
 DEFAULT_CHARSET = (1),
 SYMBOL_CHARSET = (2),
 SHIFTJIS_CHARSET = (128),
 HANGEUL_CHARSET = (129),
 GB2312_CHARSET = (134),
 CHINESEBIG5_CHARSET = (136),
 GREEK_CHARSET = (161),
 TURKISH_CHARSET = (162),
 HEBREW_CHARSET = (177),
 ARABIC_CHARSET = (178),
 BALTIC_CHARSET = (186),
 RUSSIAN_CHARSET = (204),
 THAI_CHARSET = (222),
 EASTEUROPE_CHARSET = (238),
 OEM_CHARSET = (255),
 OUT_DEFAULT_PRECIS = (0),
 OUT_STRING_PRECIS = (1),
 OUT_CHARACTER_PRECIS = (2),
 OUT_STROKE_PRECIS = (3),
 OUT_TT_PRECIS = (4),
 OUT_DEVICE_PRECIS = (5),
 OUT_RASTER_PRECIS = (6),
 OUT_TT_ONLY_PRECIS = (7),
 OUT_OUTLINE_PRECIS = (8),
 CLIP_DEFAULT_PRECIS = (0),
 CLIP_CHARACTER_PRECIS = (1),
 CLIP_STROKE_PRECIS = (2),
 CLIP_MASK = (15),
 CLIP_LH_ANGLES = (16),
 CLIP_TT_ALWAYS = (32),
 CLIP_EMBEDDED = (128),
 DEFAULT_QUALITY = (0),
 DRAFT_QUALITY = (1),
 PROOF_QUALITY = (2),
 DEFAULT_PITCH = (0),
 FIXED_PITCH = (1),
 VARIABLE_PITCH = (2),
 FF_DECORATIVE = (80),
 FF_DONTCARE = (0),
 FF_MODERN = (48),
 FF_ROMAN = (16),
 FF_SCRIPT = (64),
 FF_SWISS = (32),
 HS_BDIAGONAL = (3),
 HS_CROSS = (4),
 HS_DIAGCROSS = (5),
 HS_FDIAGONAL = (2),
 HS_HORIZONTAL = (0),
 HS_VERTICAL = (1),
 LR_DEFAULTCOLOR = (0),
 LR_LOADREALSIZE = (128),
 MAILSLOT_WAIT_FOREVER = (0xffffffff),
 MAILSLOT_NO_MESSAGE = (0xffffffff),
 CMB_MASKED = (2),
 PIPE_ACCESS_DUPLEX = (3),
 PIPE_ACCESS_INBOUND = (1),
 PIPE_ACCESS_OUTBOUND = (2),
 WRITE_DAC = (0x40000),
 WRITE_OWNER = (0x80000),
 ACCESS_SYSTEM_SECURITY = (0x1000000),
 PIPE_TYPE_BYTE = (0),
 PIPE_TYPE_MESSAGE = (4),
 PIPE_READMODE_BYTE = (0),
 PIPE_READMODE_MESSAGE = (2),
 PIPE_WAIT = (0),
 PIPE_NOWAIT = (1),
 PS_GEOMETRIC = (65536),
 PS_COSMETIC = (0),
 PS_ALTERNATE = (8),
 PS_SOLID = (0),
 PS_DASH = (1),
 PS_DOT = (2),
 PS_DASHDOT = (3),
 PS_DASHDOTDOT = (4),
 PS_NULL = (5),
 PS_USERSTYLE = (7),
 PS_INSIDEFRAME = (6),
 PS_ENDCAP_ROUND = (0),
 PS_ENDCAP_SQUARE = (256),
 PS_ENDCAP_FLAT = (512),
 PS_JOIN_BEVEL = (4096),
 PS_JOIN_MITER = (8192),
 PS_JOIN_ROUND = (0),
 PS_STYLE_MASK = (15),
 PS_ENDCAP_MASK = (3840),
 PS_TYPE_MASK = (983040),
 ALTERNATE = (1),
 WINDING = (2),
 CREATE_DEFAULT_ERROR_MODE = (67108864),
 CREATE_NEW_CONSOLE = (16),
 CREATE_NEW_PROCESS_GROUP = (512),
 CREATE_NO_WINDOW = (0x8000000),
 CREATE_SEPARATE_WOW_VDM = (2048),
 CREATE_SUSPENDED = (4),
 CREATE_UNICODE_ENVIRONMENT = (1024),
 DEBUG_PROCESS = (1),
 DEBUG_ONLY_THIS_PROCESS = (2),
 DETACHED_PROCESS = (8),
 HIGH_PRIORITY_CLASS = (128),
 IDLE_PRIORITY_CLASS = (64),
 NORMAL_PRIORITY_CLASS = (32),
 REALTIME_PRIORITY_CLASS = (256),
 SERVICE_ALL_ACCESS = (0xf01ff),
 SERVICE_CHANGE_CONFIG = (2),
 SERVICE_ENUMERATE_DEPENDENTS = (8),
 SERVICE_INTERROGATE = (128),
 SERVICE_PAUSE_CONTINUE = (64),
 SERVICE_QUERY_CONFIG = (1),
 SERVICE_QUERY_STATUS = (4),
 SERVICE_START = (16),
 SERVICE_STOP = (32),
 SERVICE_USER_DEFINED_CONTROL = (256),
 SERVICE_DELETE = (0x10000),
 SERVICE_READ_CONTROL = (0x20000),
 SERVICE_GENERIC_EXECUTE = (0x20000000),
 SERVICE_ERROR_IGNORE = (0),
 SERVICE_ERROR_NORMAL = (1),
 SERVICE_ERROR_SEVERE = (2),
 SERVICE_ERROR_CRITICAL = (3),
 TAPE_FIXED_PARTITIONS = (0),
 TAPE_INITIATOR_PARTITIONS = (0x2),
 TAPE_SELECT_PARTITIONS = (0x1),
 TAPE_FILEMARKS = (0x1),
 TAPE_LONG_FILEMARKS = (0x3),
 TAPE_SETMARKS = (0),
 TAPE_SHORT_FILEMARKS = (0x2),
 CW_USEDEFAULT = (0x80000000),
 WS_BORDER = (0x800000),
 WS_CAPTION = (0xc00000),
 WS_CHILD = (0x40000000),
 WS_CHILDWINDOW = (0x40000000),
 WS_CLIPCHILDREN = (0x2000000),
 WS_CLIPSIBLINGS = (0x4000000),
 WS_DISABLED = (0x8000000),
 WS_DLGFRAME = (0x400000),
 WS_GROUP = (0x20000),
 WS_HSCROLL = (0x100000),
 WS_ICONIC = (0x20000000),
 WS_MAXIMIZE = (0x1000000),
 WS_MAXIMIZEBOX = (0x10000),
 WS_MINIMIZE = (0x20000000),
 WS_MINIMIZEBOX = (0x20000),
 WS_OVERLAPPED = (0),
 WS_OVERLAPPEDWINDOW = (0xcf0000),
 WS_POPUP = (0x80000000),
 WS_POPUPWINDOW = (0x80880000),
 WS_SIZEBOX = (0x40000),
 WS_SYSMENU = (0x80000),
 WS_TABSTOP = (0x10000),
 WS_THICKFRAME = (0x40000),
 WS_TILED = (0),
 WS_TILEDWINDOW = (0xcf0000),
 WS_VISIBLE = (0x10000000),
 WS_VSCROLL = (0x200000),
 MDIS_ALLCHILDSTYLES = (0x1),
 BS_3STATE = (0x5),
 BS_AUTO3STATE = (0x6),
 BS_AUTOCHECKBOX = (0x3),
 BS_AUTORADIOBUTTON = (0x9),
 BS_BITMAP = (0x80),
 BS_BOTTOM = (0x800),
 BS_CENTER = (0x300),
 BS_CHECKBOX = (0x2),
 BS_DEFPUSHBUTTON = (0x1),
 BS_GROUPBOX = (0x7),
 BS_ICON = (0x40),
 BS_LEFT = (0x100),
 BS_LEFTTEXT = (0x20),
 BS_MULTILINE = (0x2000),
 BS_NOTIFY = (0x4000),
 BS_OWNERDRAW = (0xb),
 BS_PUSHBUTTON = (0),
 BS_PUSHLIKE = (0x1000),
 BS_RADIOBUTTON = (0x4),
 BS_RIGHT = (0x200),
 BS_RIGHTBUTTON = (0x20),
 BS_TEXT = (0),
 BS_TOP = (0x400),
 BS_USERBUTTON = (0x8),
 BS_VCENTER = (0xc00),
 CBS_AUTOHSCROLL = (0x40),
 CBS_DISABLENOSCROLL = (0x800),
 CBS_DROPDOWN = (0x2),
 CBS_DROPDOWNLIST = (0x3),
 CBS_HASSTRINGS = (0x200),
 CBS_LOWERCASE = (0x4000),
 CBS_NOINTEGRALHEIGHT = (0x400),
 CBS_OEMCONVERT = (0x80),
 CBS_OWNERDRAWFIXED = (0x10),
 CBS_OWNERDRAWVARIABLE = (0x20),
 CBS_SIMPLE = (0x1),
 CBS_SORT = (0x100),
 CBS_UPPERCASE = (0x2000),
 ES_AUTOHSCROLL = (0x80),
 ES_AUTOVSCROLL = (0x40),
 ES_CENTER = (0x1),
 ES_LEFT = (0),
 ES_LOWERCASE = (0x10),
 ES_MULTILINE = (0x4),
 ES_NOHIDESEL = (0x100),
 ES_NUMBER = (0x2000),
 ES_OEMCONVERT = (0x400),
 ES_PASSWORD = (0x20),
 ES_READONLY = (0x800),
 ES_RIGHT = (0x2),
 ES_UPPERCASE = (0x8),
 ES_WANTRETURN = (0x1000),
 LBS_DISABLENOSCROLL = (0x1000),
 LBS_EXTENDEDSEL = (0x800),
 LBS_HASSTRINGS = (0x40),
 LBS_MULTICOLUMN = (0x200),
 LBS_MULTIPLESEL = (0x8),
 LBS_NODATA = (0x2000),
 LBS_NOINTEGRALHEIGHT = (0x100),
 LBS_NOREDRAW = (0x4),
 LBS_NOSEL = (0x4000),
 LBS_NOTIFY = (0x1),
 LBS_OWNERDRAWFIXED = (0x10),
 LBS_OWNERDRAWVARIABLE = (0x20),
 LBS_SORT = (0x2),
 LBS_STANDARD = (0xa00003),
 LBS_USETABSTOPS = (0x80),
 LBS_WANTKEYBOARDINPUT = (0x400),
 SBS_BOTTOMALIGN = (0x4),
 SBS_HORZ = (0),
 SBS_LEFTALIGN = (0x2),
 SBS_RIGHTALIGN = (0x4),
 SBS_SIZEBOX = (0x8),
 SBS_SIZEBOXBOTTOMRIGHTALIGN = (0x4),
 SBS_SIZEBOXTOPLEFTALIGN = (0x2),
 SBS_SIZEGRIP = (0x10),
 SBS_TOPALIGN = (0x2),
 SBS_VERT = (0x1),
 SS_BITMAP = (0xe),
 SS_BLACKFRAME = (0x7),
 SS_BLACKRECT = (0x4),
 SS_CENTER = (0x1),
 SS_CENTERIMAGE = (0x200),
 SS_ENHMETAFILE = (0xf),
 SS_ETCHEDFRAME = (0x12),
 SS_ETCHEDHORZ = (0x10),
 SS_ETCHEDVERT = (0x11),
 SS_GRAYFRAME = (0x8),
 SS_GRAYRECT = (0x5),
 SS_ICON = (0x3),
 SS_LEFT = (0),
 SS_LEFTNOWORDWRAP = (0xc),
 SS_NOPREFIX = (0x80),
 SS_NOTIFY = (0x100),
 SS_OWNERDRAW = (0xd),
 SS_REALSIZEIMAGE = (0x800),
 SS_RIGHT = (0x2),
 SS_RIGHTJUST = (0x400),
 SS_SIMPLE = (0xb),
 SS_SUNKEN = (0x1000),
 SS_USERITEM = (0xa),
 SS_WHITEFRAME = (0x9),
 SS_WHITERECT = (0x6),
 DS_3DLOOK = (0x4),
 DS_ABSALIGN = (0x1),
 DS_CENTER = (0x800),
 DS_CENTERMOUSE = (0x1000),
 DS___FILE__HELP = (0x2000),
 DS_CONTROL = (0x400),
 DS_FIXEDSYS = (0x8),
 DS_LOCALEDIT = (0x20),
 DS_MODALFRAME = (0x80),
 DS_NOFAILCREATE = (0x10),
 DS_NOIDLEMSG = (0x100),
 DS_SETFONT = (0x40),
 DS_SETFOREGROUND = (0x200),
 DS_SYSMODAL = (0x2),
 WS_EX_ACCEPTFILES = (0x10),
 WS_EX_APPWINDOW = (0x40000),
 WS_EX_CLIENTEDGE = (0x200),
 WS_EX___FILE__HELP = (0x400),
 WS_EX_CONTROLPARENT = (0x10000),
 WS_EX_DLGMODALFRAME = (0x1),
 WS_EX_LEFT = (0),
 WS_EX_LEFTSCROLLBAR = (0x4000),
 WS_EX_LTRREADING = (0),
 WS_EX_MDICHILD = (0x40),
 WS_EX_NOPARENTNOTIFY = (0x4),
 WS_EX_OVERLAPPEDWINDOW = (0x300),
 WS_EX_PALETTEWINDOW = (0x188),
 WS_EX_RIGHT = (0x1000),
 WS_EX_RIGHTSCROLLBAR = (0),
 WS_EX_RTLREADING = (0x2000),
 WS_EX_STATICEDGE = (0x20000),
 WS_EX_TOOLWINDOW = (0x80),
 WS_EX_TOPMOST = (0x8),
 WS_EX_TRANSPARENT = (0x20),
 WS_EX_WINDOWEDGE = (0x100),
 WINSTA_ACCESSCLIPBOARD = (0x4),
 WINSTA_ACCESSGLOBALATOMS = (0x20),
 WINSTA_CREATEDESKTOP = (0x8),
 WINSTA_ENUMDESKTOPS = (0x1),
 WINSTA_ENUMERATE = (0x100),
 WINSTA_EXITWINDOWS = (0x40),
 WINSTA_READATTRIBUTES = (0x2),
 WINSTA_READSCREEN = (0x200),
 WINSTA_WRITEATTRIBUTES = (0x10),
 WH_CALLWNDPROC = (4),
 WH_CALLWNDPROCRET = (12),
 WH_CBT = (5),
 WH_DEBUG = (9),
 WH_GETMESSAGE = (3),
 WH_JOURNALPLAYBACK = (1),
 WH_JOURNALRECORD = (0),
 WH_KEYBOARD = (2),
 WH_MOUSE = (7),
 WH_MSGFILTER = -((1)),
 WH_SHELL = (10),
 WH_SYSMSGFILTER = (6),
 WH_FOREGROUNDIDLE = (11),
 DDD_RAW_TARGET_PATH = (1),
 DDD_REMOVE_DEFINITION = (2),
 DDD_EXACT_MATCH_ON_REMOVE = (4),
 DC_BINNAMES = (12),
 DC_BINS = (6),
 DC_COPIES = (18),
 DC_DRIVER = (11),
 DC_DATATYPE_PRODUCED = (21),
 DC_DUPLEX = (7),
 DC_EMF_COMPLIANT = (20),
 DC_ENUMRESOLUTIONS = (13),
 DC_EXTRA = (9),
 DC_FIELDS = (1),
 DC_FILEDEPENDENCIES = (14),
 DC_MAXEXTENT = (5),
 DC_MINEXTENT = (4),
 DC_ORIENTATION = (17),
 DC_PAPERNAMES = (16),
 DC_PAPERS = (2),
 DC_PAPERSIZE = (3),
 DC_SIZE = (8),
 DC_TRUETYPE = (15),
 DCTT_BITMAP = (0x1),
 DCTT_DOWNLOAD = (0x2),
 DCTT_SUBDEV = (0x4),
 DC_VERSION = (10),
 DC_BINADJUST = (19),
 DDL_ARCHIVE = (32),
 DDL_DIRECTORY = (16),
 DDL_DRIVES = (16384),
 DDL_EXCLUSIVE = (32768),
 DDL_HIDDEN = (2),
 DDL_READONLY = (1),
 DDL_READWRITE = (0),
 DDL_SYSTEM = (4),
 DDL_POSTMSGS = (8192),
 DLL_PROCESS_ATTACH = (1),
 DLL_THREAD_ATTACH = (2),
 DLL_PROCESS_DETACH = (0),
 DLL_THREAD_DETACH = (3),
 DM_IN_BUFFER = (8),
 DM_MODIFY = (8),
 DM_IN_PROMPT = (4),
 DM_PROMPT = (4),
 DM_OUT_BUFFER = (2),
 DM_COPY = (2),
 DM_UPDATE = (1),
 IDANI_OPEN = (1),
 IDANI_CLOSE = (2),
 DC_ACTIVE = (1),
 DC_SMALLCAP = (2),
 BDR_RAISEDINNER = (4),
 BDR_SUNKENINNER = (8),
 BDR_RAISEDOUTER = (1),
 BDR_SUNKENOUTER = (1),
 EDGE_BUMP = (9),
 EDGE_ETCHED = (6),
 EDGE_RAISED = (5),
 EDGE_SUNKEN = (10),
 BF_ADJUST = (8192),
 BF_BOTTOM = (8),
 BF_BOTTOMLEFT = (9),
 BF_BOTTOMRIGHT = (12),
 BF_DIAGONAL = (16),
 BF_DIAGONAL_ENDBOTTOMLEFT = (25),
 BF_DIAGONAL_ENDBOTTOMRIGHT = (28),
 BF_DIAGONAL_ENDTOPLEFT = (19),
 BF_DIAGONAL_ENDTOPRIGHT = (22),
 BF_FLAT = (16384),
 BF_LEFT = (1),
 BF_MIDDLE = (2048),
 BF_MONO = (32768),
 BF_RECT = (15),
 BF_RIGHT = (4),
 BF_SOFT = (4096),
 BF_TOP = (2),
 BF_TOPLEFT = (3),
 BF_TOPRIGHT = (6),
 DFC_BUTTON = (4),
 DFC_CAPTION = (1),
 DFC_MENU = (2),
 DFC_SCROLL = (3),
 DFCS_BUTTON3STATE = (8),
 DFCS_BUTTONCHECK = (0),
 DFCS_BUTTONPUSH = (16),
 DFCS_BUTTONRADIO = (4),
 DFCS_BUTTONRADIOIMAGE = (1),
 DFCS_BUTTONRADIOMASK = (2),
 DFCS_CAPTIONCLOSE = (0),
 DFCS_CAPTIONHELP = (4),
 DFCS_CAPTIONMAX = (2),
 DFCS_CAPTIONMIN = (1),
 DFCS_CAPTIONRESTORE = (3),
 DFCS_MENUARROW = (0),
 DFCS_MENUBULLET = (2),
 DFCS_MENUCHECK = (1),
 DFCS_SCROLLCOMBOBOX = (5),
 DFCS_SCROLLDOWN = (1),
 DFCS_SCROLLLEFT = (2),
 DFCS_SCROLLRIGHT = (3),
 DFCS_SCROLLSIZEGRIP = (8),
 DFCS_SCROLLUP = (0),
 DFCS_ADJUSTRECT = (8192),
 DFCS_CHECKED = (1024),
 DFCS_FLAT = (16384),
 DFCS_INACTIVE = (256),
 DFCS_MONO = (32768),
 DFCS_PUSHED = (512),
 DI_COMPAT = (4),
 DI_DEFAULTSIZE = (8),
 DI_IMAGE = (2),
 DI_MASK = (1),
 DI_NORMAL = (3),
 DST_BITMAP = (4),
 DST_COMPLEX = (0),
 DST_ICON = (3),
 DST_PREFIXTEXT = (2),
 DST_TEXT = (1),
 DSS_NORMAL = (0),
 DSS_UNION = (16),
 DSS_DISABLED = (32),
 DSS_MONO = (128),
 SBT_NOBORDERS = (256),
 SBT_OWNERDRAW = (4096),
 SBT_POPOUT = (512),
 SBT_RTLREADING = (1024),
 DT_BOTTOM = (8),
 DT_CALCRECT = (1024),
 DT_CENTER = (1),
 DT_EDITCONTROL = (8192),
 DT_END_ELLIPSIS = (32768),
 DT_PATH_ELLIPSIS = (16384),
 DT_EXPANDTABS = (64),
 DT_EXTERNALLEADING = (512),
 DT_LEFT = (0),
 DT_MODIFYSTRING = (65536),
 DT_NOCLIP = (256),
 DT_NOPREFIX = (2048),
 DT_RIGHT = (2),
 DT_RTLREADING = (131072),
 DT_SINGLELINE = (32),
 DT_TABSTOP = (128),
 DT_TOP = (0),
 DT_VCENTER = (4),
 DT_WORDBREAK = (16),
 DT_INTERNAL = (4096),
 DUPLICATE_CLOSE_SOURCE = (1),
 DUPLICATE_SAME_ACCESS = (2),
 FILE_MAP_ALL_ACCESS = (0xf001f),
 FILE_MAP_READ = (4),
 FILE_MAP_WRITE = (2),
 FILE_MAP_COPY = (1),
 FILE_MAP_EXECUTE = (0x20),
 MUTEX_ALL_ACCESS = (0x1f0001),
 MUTEX_MODIFY_STATE = (1),
 SYNCHRONIZE = (0x100000),
 SEMAPHORE_ALL_ACCESS = (0x1f0003),
 SEMAPHORE_MODIFY_STATE = (2),
 EVENT_ALL_ACCESS = (0x1f0003),
 EVENT_MODIFY_STATE = (2),
 KEY_ALL_ACCESS = (0xf003f),
 KEY_CREATE_LINK = (32),
 KEY_CREATE_SUB_KEY = (4),
 KEY_ENUMERATE_SUB_KEYS = (8),
 KEY_EXECUTE = (0x20019),
 KEY_NOTIFY = (16),
 KEY_QUERY_VALUE = (1),
 KEY_READ = (0x20019),
 KEY_SET_VALUE = (2),
 KEY_WRITE = (0x20006),
 PROCESS_ALL_ACCESS = (0x1f0fff),
 PROCESS_CREATE_PROCESS = (128),
 PROCESS_CREATE_THREAD = (2),
 PROCESS_DUP_HANDLE = (64),
 PROCESS_QUERY_INFORMATION = (1024),
 PROCESS_SET_INFORMATION = (512),
 PROCESS_TERMINATE = (1),
 PROCESS_VM_OPERATION = (8),
 PROCESS_VM_READ = (16),
 PROCESS_VM_WRITE = (32),
 THREAD_ALL_ACCESS = (0x1f03ff),
 THREAD_DIRECT_IMPERSONATION = (512),
 THREAD_GET___FILE__ = (8),
 THREAD_IMPERSONATE = (256),
 THREAD_QUERY_INFORMATION = (64),
 THREAD_SET___FILE__ = (16),
 THREAD_SET_INFORMATION = (32),
 THREAD_SET_THREAD_TOKEN = (128),
 THREAD_SUSPEND_RESUME = (2),
 THREAD_TERMINATE = (1),
 WB_ISDELIMITER = (2),
 WB_LEFT = (0),
 WB_RIGHT = (1),
 SB_BOTH = (3),
 SB_CTL = (2),
 SB_HORZ = (0),
 SB_VERT = (1),
 ESB_DISABLE_BOTH = (3),
 ESB_DISABLE_DOWN = (2),
 ESB_DISABLE_LEFT = (1),
 ESB_DISABLE_LTUP = (1),
 ESB_DISABLE_RIGHT = (2),
 ESB_DISABLE_RTDN = (2),
 ESB_DISABLE_UP = (1),
 ESB_ENABLE_BOTH = (0),
 SB_LINEUP = (0),
 SB_LINEDOWN = (1),
 SB_LINELEFT = (0),
 SB_LINERIGHT = (1),
 SB_PAGEUP = (2),
 SB_PAGEDOWN = (3),
 SB_PAGELEFT = (2),
 SB_PAGERIGHT = (3),
 SB_THUMBPOSITION = (4),
 SB_THUMBTRACK = (5),
 SB_ENDSCROLL = (8),
 SB_LEFT = (6),
 SB_RIGHT = (7),
 SB_BOTTOM = (7),
 SB_TOP = (6),
 ENUM_ALL_CALENDARS = -((1)),
 DATE_SHORTDATE = (1),
 DATE_LONGDATE = (2),
 SERVICE_ACTIVE = (1),
 SERVICE_INACTIVE = (2),
 DEVICE_FONTTYPE = (2),
 RASTER_FONTTYPE = (1),
 TRUETYPE_FONTTYPE = (4),
 OBJ_BRUSH = (2),
 OBJ_PEN = (1),
 OBJ_PAL = (5),
 OBJ_FONT = (6),
 OBJ_BITMAP = (7),
 OBJ_EXTPEN = (11),
 OBJ_REGION = (8),
 OBJ_DC = (3),
 OBJ_MEMDC = (10),
 OBJ_METAFILE = (9),
 OBJ_METADC = (4),
 OBJ_ENHMETAFILE = (13),
 OBJ_ENHMETADC = (12),
 SERVICE_WIN32 = (48),
 SERVICE_DRIVER = (11),
 CP_INSTALLED = (1),
 CP_SUPPORTED = (2),
 LCID_INSTALLED = (1),
 LCID_SUPPORTED = (2),
 TAPE_ERASE_LONG = (0x1),
 TAPE_ERASE_SHORT = (0),
 SP_ERROR = -((1)),
 SP_OUTOFDISK = -((4)),
 SP_OUTOFMEMORY = -((5)),
 SP_USERABORT = -((3)),
 PHYSICALWIDTH = (110),
 PHYSICALHEIGHT = (111),
 PHYSICALOFFSETX = (112),
 PHYSICALOFFSETY = (113),
 SCALINGFACTORX = (114),
 SCALINGFACTORY = (115),
 QUERYESCSUPPORT = (8),
 cABORTDOC = (2),
 cENDDOC = (11),
 GETPHYSPAGESIZE = (12),
 GETPRINTINGOFFSET = (13),
 GETSCALINGFACTOR = (14),
 NEWFRAME = (1),
 NEXTBAND = (3),
 PASSTHROUGH = (19),
 cSETABORTPROC = (9),
 cSTARTDOC = (10),
 CLRDTR = (6),
 CLRRTS = (4),
 SETDTR = (5),
 SETRTS = (3),
 SETXOFF = (1),
 SETXON = (2),
 SETBREAK = (8),
 CLRBREAK = (9),
 EWX_FORCE = (4),
 EWX_LOGOFF = (0),
 EWX_POWEROFF = (8),
 EWX_REBOOT = (2),
 EWX_SHUTDOWN = (1),
 FLOODFILLBORDER = (0),
 FLOODFILLSURFACE = (1),
 ETO_CLIPPED = (4),
 ETO_GLYPH_INDEX = (16),
 ETO_OPAQUE = (2),
 ETO_RTLREADING = (128),
 FOREGROUND_BLUE = (1),
 FOREGROUND_GREEN = (2),
 FOREGROUND_RED = (4),
 FOREGROUND_INTENSITY = (8),
 BACKGROUND_BLUE = (16),
 BACKGROUND_GREEN = (32),
 BACKGROUND_RED = (64),
 BACKGROUND_INTENSITY = (128),
 FILE_NOTIFY_CHANGE_FILE_NAME = (1),
 FILE_NOTIFY_CHANGE_DIR_NAME = (2),
 FILE_NOTIFY_CHANGE_ATTRIBUTES = (4),
 FILE_NOTIFY_CHANGE_SIZE = (8),
 FILE_NOTIFY_CHANGE_LAST_WRITE = (16),
 FILE_NOTIFY_CHANGE_SECURITY = (256),
 MAP_FOLDCZONE = (16),
 MAP_FOLDDIGITS = (128),
 MAP_PRECOMPOSED = (32),
 MAP_COMPOSITE = (64),
 HC_ACTION = (0),
 FORMAT_MESSAGE_ALLOCATE_BUFFER = (256),
 FORMAT_MESSAGE_IGNORE_INSERTS = (512),
 FORMAT_MESSAGE_FROM_STRING = (1024),
 FORMAT_MESSAGE_FROM_HMODULE = (2048),
 FORMAT_MESSAGE_FROM_SYSTEM = (4096),
 FORMAT_MESSAGE_ARGUMENT_ARRAY = (8192),
 FORMAT_MESSAGE_MAX_WIDTH_MASK = (255),
 GDICOMMENT_WINDOWS_METAFILE = -((2147483647)),
 GDICOMMENT_BEGINGROUP = (2),
 GDICOMMENT_ENDGROUP = (3),
 GDICOMMENT_MULTIFORMATS = (1073741828),
 GDICOMMENT_IDENTIFIER = (1128875079),
 CTRL_C_EVENT = (0),
 CTRL_BREAK_EVENT = (1),
 CTRL_CLOSE_EVENT = (2),
 CTRL_LOGOFF_EVENT = (5),
 CTRL_SHUTDOWN_EVENT = (6),
 AD_COUNTERCLOCKWISE = (1),
 AD_CLOCKWISE = (2),
 SCS_32BIT_BINARY = (0),
 SCS_DOS_BINARY = (1),
 SCS_OS216_BINARY = (5),
 SCS_PIF_BINARY = (3),
 SCS_POSIX_BINARY = (4),
 SCS_WOW_BINARY = (2),
 DCB_DISABLE = (8),
 DCB_ENABLE = (4),
 DCB_RESET = (1),
 DCB_SET = (3),
 DCB_ACCUMULATE = (2),
 GCP_DBCS = (1),
 GCP_ERROR = (0x8000),
 GCP_CLASSIN = (0x80000),
 GCP_DIACRITIC = (256),
 GCP_DISPLAYZWG = (0x400000),
 GCP_GLYPHSHAPE = (16),
 GCP_JUSTIFY = (0x10000),
 GCP_JUSTIFYIN = (0x200000),
 GCP_KASHIDA = (1024),
 GCP_LIGATE = (32),
 GCP_MAXEXTENT = (0x100000),
 GCP_NEUTRALOVERRIDE = (0x2000000),
 GCP_NUMERICOVERRIDE = (0x1000000),
 GCP_NUMERICSLATIN = (0x4000000),
 GCP_NUMERICSLOCAL = (0x8000000),
 GCP_REORDER = (2),
 GCP_SYMSWAPOFF = (0x800000),
 GCP_USEKERNING = (8),
 FLI_GLYPHS = (0x40000),
 FLI_MASK = (0x103b),
 GCW_ATOM = -((32)),
 GCL_CBCLSEXTRA = -((20)),
 GCL_CBWNDEXTRA = -((18)),
 GCL_HBRBACKGROUND = -((10)),
 GCL_HCURSOR = -((12)),
 GCL_HICON = -((14)),
 GCL_HICONSM = -((34)),
 GCL_HMODULE = -((16)),
 GCL_MENUNAME = -((8)),
 GCL_STYLE = -((26)),
 GCL_WNDPROC = -((24)),
 CF_BITMAP = (2),
 CF_DIB = (8),
 CF_PALETTE = (9),
 CF_ENHMETAFILE = (14),
 CF_METAFILEPICT = (3),
 CF_OEMTEXT = (7),
 CF_TEXT = (1),
 CF_UNICODETEXT = (13),
 CF_DIF = (5),
 CF_DSPBITMAP = (130),
 CF_DSPENHMETAFILE = (142),
 CF_DSPMETAFILEPICT = (131),
 CF_DSPTEXT = (129),
 CF_GDIOBJFIRST = (768),
 CF_GDIOBJLAST = (1023),
 CF_HDROP = (15),
 CF_LOCALE = (16),
 CF_OWNERDISPLAY = (128),
 CF_PENDATA = (10),
 CF_PRIVATEFIRST = (512),
 CF_PRIVATELAST = (767),
 CF_RIFF = (11),
 CF_SYLK = (4),
 CF_WAVE = (12),
 CF_TIFF = (6),
 EV_BREAK = (64),
 EV_CTS = (8),
 EV_DSR = (16),
 EV_ERR = (128),
 EV_EVENT1 = (2048),
 EV_EVENT2 = (4096),
 EV_PERR = (512),
 EV_RING = (256),
 EV_RLSD = (32),
 EV_RX80FULL = (1024),
 EV_RXCHAR = (1),
 EV_RXFLAG = (2),
 EV_TXEMPTY = (4),
 MS_CTS_ON = (0x10),
 MS_DSR_ON = (0x20),
 MS_RING_ON = (0x40),
 MS_RLSD_ON = (0x80),
 MAX_COMPUTERNAME_LENGTH = (15),
 ENABLE_LINE_INPUT = (2),
 ENABLE_ECHO_INPUT = (4),
 ENABLE_PROCESSED_INPUT = (1),
 ENABLE_WINDOW_INPUT = (8),
 ENABLE_MOUSE_INPUT = (16),
 ENABLE_PROCESSED_OUTPUT = (1),
 ENABLE_WRAP_AT_EOL_OUTPUT = (2),
 CP_ACP = (0),
 CP_MACCP = (2),
 CP_OEMCP = (1),
 CP_UTF8 = 65001,
 DATE_USE_ALT_CALENDAR = (4),
 DCX_WINDOW = (0x1),
 DCX_CACHE = (0x2),
 DCX_PARENTCLIP = (0x20),
 DCX_CLIPSIBLINGS = (0x10),
 DCX_CLIPCHILDREN = (0x8),
 DCX_NORESETATTRS = (0x4),
 DCX_LOCKWINDOWUPDATE = (0x400),
 DCX_EXCLUDERGN = (0x40),
 DCX_INTERSECTRGN = (0x80),
 DCX_VALIDATE = (0x200000),
 DRIVERVERSION = (0),
 TECHNOLOGY = (2),
 DT_PLOTTER = (0),
 DT_RASDISPLAY = (1),
 DT_RASPRINTER = (2),
 DT_RASCAMERA = (3),
 DT_CHARSTREAM = (4),
 DT_METAFILE = (5),
 DT_DISPFILE = (6),
 HORZSIZE = (4),
 VERTSIZE = (6),
 HORZRES = (8),
 VERTRES = (10),
 LOGPIXELSX = (88),
 LOGPIXELSY = (90),
 BITSPIXEL = (12),
 PLANES = (14),
 NUMBRUSHES = (16),
 NUMPENS = (18),
 NUMFONTS = (22),
 NUMCOLORS = (24),
 ASPECTX = (40),
 ASPECTY = (42),
 ASPECTXY = (44),
 PDEVICESIZE = (26),
 CLIPCAPS = (36),
 SIZEPALETTE = (104),
 NUMRESERVED = (106),
 COLORRES = (108),
 VREFRESH = (116),
 DESKTOPHORZRES = (118),
 DESKTOPVERTRES = (117),
 BLTALIGNMENT = (119),
 RASTERCAPS = (38),
 RC_BANDING = (2),
 RC_BITBLT = (1),
 RC_BITMAP64 = (8),
 RC_DI_BITMAP = (128),
 RC_DIBTODEV = (512),
 RC_FLOODFILL = (4096),
 RC_GDI20_OUTPUT = (16),
 RC_PALETTE = (256),
 RC_SCALING = (4),
 RC_STRETCHBLT = (2048),
 RC_STRETCHDIB = (8192),
 CURVECAPS = (28),
 CC_NONE = (0),
 CC_CIRCLES = (1),
 CC_PIE = (2),
 CC_CHORD = (4),
 CC_ELLIPSES = (8),
 CC_WIDE = (16),
 CC_STYLED = (32),
 CC_WIDESTYLED = (64),
 CC_INTERIORS = (128),
 CC_ROUNDRECT = (256),
 LINECAPS = (30),
 LC_NONE = (0),
 LC_POLYLINE = (2),
 LC_MARKER = (4),
 LC_POLYMARKER = (8),
 LC_WIDE = (16),
 LC_STYLED = (32),
 LC_WIDESTYLED = (64),
 LC_INTERIORS = (128),
 POLYGONALCAPS = (32),
 PC_NONE = (0),
 PC_POLYGON = (1),
 PC_RECTANGLE = (2),
 PC_WINDPOLYGON = (4),
 PC_SCANLINE = (8),
 PC_WIDE = (16),
 PC_STYLED = (32),
 PC_WIDESTYLED = (64),
 PC_INTERIORS = (128),
 TEXTCAPS = (34),
 TC_OP_CHARACTER = (1),
 TC_OP_STROKE = (2),
 TC_CP_STROKE = (4),
 TC_CR_90 = (8),
 TC_CR_ANY = (16),
 TC_SF_X_YINDEP = (32),
 TC_SA_DOUBLE = (64),
 TC_SA_INTEGER = (128),
 TC_SA_CONTIN = (256),
 TC_EA_DOUBLE = (512),
 TC_IA_ABLE = (1024),
 TC_UA_ABLE = (2048),
 TC_SO_ABLE = (4096),
 TC_RA_ABLE = (8192),
 TC_VA_ABLE = (16384),
 TC_RESERVED = (32768),
 TC_SCROLLBLT = (65536),
 PC_PATHS = (512),
 DRIVE_REMOVABLE = (2),
 DRIVE_FIXED = (3),
 DRIVE_REMOTE = (4),
 DRIVE_CDROM = (5),
 DRIVE_RAMDISK = (6),
 DRIVE_UNKNOWN = (0),
 DRIVE_NO_ROOT_DIR = (1),
 EXCEPTION_ACCESS_VIOLATION = (0xc0000005),
 EXCEPTION_BREAKPOINT = (0x80000003),
 EXCEPTION_DATATYPE_MISALIGNMENT = (0x80000002),
 EXCEPTION_SINGLE_STEP = (0x80000004),
 EXCEPTION_ARRAY_BOUNDS_EXCEEDED = (0xc000008c),
 EXCEPTION_FLT_DENORMAL_OPERAND = (0xc000008d),
 EXCEPTION_FLT_DIVIDE_BY_ZERO = (0xc000008e),
 EXCEPTION_FLT_INEXACT_RESULT = (0xc000008f),
 EXCEPTION_FLT_INVALID_OPERATION = (0xc0000090),
 EXCEPTION_FLT_OVERFLOW = (0xc0000091),
 EXCEPTION_FLT_STACK_CHECK = (0xc0000092),
 EXCEPTION_FLT_UNDERFLOW = (0xc0000093),
 EXCEPTION_INT_DIVIDE_BY_ZERO = (0xc0000094),
 EXCEPTION_INT_OVERFLOW = (0xc0000095),
 EXCEPTION_INVALID_HANDLE = (0xc0000008),
 EXCEPTION_PRIV_INSTRUCTION = (0xc0000096),
 EXCEPTION_NONCONTINUABLE_EXCEPTION = (0xc0000025),
 EXCEPTION_NONCONTINUABLE = (0x1),
 EXCEPTION_STACK_OVERFLOW = (0xc00000fd),
 EXCEPTION_INVALID_DISPOSITION = (0xc0000026),
 FILE_TYPE_UNKNOWN = (0),
 FILE_TYPE_DISK = (1),
 FILE_TYPE_CHAR = (2),
 FILE_TYPE_PIPE = (3),
 GGO_BITMAP = (1),
 GGO_NATIVE = (2),
 GGO_METRICS = (0),
 GGO_GRAY2_BITMAP = (4),
 GGO_GRAY4_BITMAP = (5),
 GGO_GRAY8_BITMAP = (6),
 GDI_ERROR = (0xffffffff),
 GM_COMPATIBLE = (1),
 GM_ADVANCED = (2),
 HANDLE_FLAG_INHERIT = (1),
 HANDLE_FLAG_PROTECT_FROM_CLOSE = (2),
}

char* RT_ACCELERATOR = cast(char*) ((9));
char* RT_BITMAP = cast(char*) ((2));
char* RT_DIALOG = cast(char*) ((5));
char* RT_FONT = cast(char*) ((8));
char* RT_FONTDIR = cast(char*) ((7));
char* RT_MENU = cast(char*) ((4));
char* RT_RCDATA = cast(char*) ((10));
char* RT_STRING = cast(char*) ((6));
char* RT_MESSAGETABLE = cast(char*) ((11));
char* RT_CURSOR = cast(char*) ((1));
char* RT_GROUP_CURSOR = cast(char*) ((12));
char* RT_ICON = cast(char*) ((3));
char* RT_GROUP_ICON = cast(char*) ((13));
char* RT_VERSION = cast(char*) ((16));
char* IDC_ARROW = cast(char*) ((32512));
char* IDC_IBEAM = cast(char*) ((32513));
char* IDC_WAIT = cast(char*) ((32514));
char* IDC_CROSS = cast(char*) ((32515));
char* IDC_UPARROW = cast(char*) ((32516));
char* IDC_SIZENWSE = cast(char*) ((32642));
char* IDC_SIZENESW = cast(char*) ((32643));
char* IDC_SIZEWE = cast(char*) ((32644));
char* IDC_SIZENS = cast(char*) ((32645));
char* IDC_SIZEALL = cast(char*) ((32646));
char* IDC_NO = cast(char*) ((32648));
char* IDC_APPSTARTING = cast(char*) ((32650));
char* IDC_HELP = cast(char*) ((32651));
char* IDI_APPLICATION = cast(char*) ((32512));
char* IDI_HAND = cast(char*) ((32513));
char* IDI_QUESTION = cast(char*) ((32514));
char* IDI_EXCLAMATION = cast(char*) ((32515));
char* IDI_ASTERISK = cast(char*) ((32516));
char* IDI_WINLOGO = cast(char*) ((32517));
char* IDC_SIZE = cast(char*) ((32640));
char* IDC_ICON = cast(char*) ((32641));

enum : DWORD 
{
 MM_ANISOTROPIC = (8),
 MM_HIENGLISH = (5),
 MM_HIMETRIC = (3),
 MM_ISOTROPIC = (7),
 MM_LOENGLISH = (4),
 MM_LOMETRIC = (2),
 MM_TEXT = (1),
 MM_TWIPS = (6),
 GMDI_GOINTOPOPUPS = (0x2),
 GMDI_USEDISABLED = (0x1),
 PM_NOREMOVE = (0),
 PM_REMOVE = (1),
 PM_NOYIELD = (2),
 PIPE_CLIENT_END = (0),
 PIPE_SERVER_END = (1),
 GW_HWNDNEXT = (2),
 GW_HWNDPREV = (3),
 GW_CHILD = (5),
 GW_HWNDFIRST = (0),
 GW_HWNDLAST = (1),
 GW_OWNER = (4),
 PT_MOVETO = (6),
 PT_LINETO = (2),
 PT_BEZIERTO = (4),
 PT_CLOSEFIGURE = (1),
 SHUTDOWN_NORETRY = (1),
 QS_ALLEVENTS = (191),
 QS_ALLINPUT = (255),
 QS_HOTKEY = (128),
 QS_INPUT = (7),
 QS_KEY = (1),
 QS_MOUSE = (6),
 QS_MOUSEBUTTON = (4),
 QS_MOUSEMOVE = (2),
 QS_PAINT = (32),
 QS_POSTMESSAGE = (8),
 QS_SENDMESSAGE = (64),
 QS_TIMER = (16),
 SIF_ALL = (23),
 SIF_PAGE = (2),
 SIF_POS = (4),
 SIF_RANGE = (1),
 SIF_DISABLENOSCROLL = (8),
 STD_INPUT_HANDLE = -(10),
 STD_OUTPUT_HANDLE = -(11),
 STD_ERROR_HANDLE = -(12),
 BLACK_BRUSH = (4),
 DKGRAY_BRUSH = (3),
 GRAY_BRUSH = (2),
 HOLLOW_BRUSH = (5),
 LTGRAY_BRUSH = (1),
 NULL_BRUSH = (5),
 WHITE_BRUSH = (0),
 BLACK_PEN = (7),
 NULL_PEN = (8),
 WHITE_PEN = (6),
 ANSI_FIXED_FONT = (11),
 ANSI_VAR_FONT = (12),
 DEVICE_DEFAULT_FONT = (14),
 DEFAULT_GUI_FONT = (17),
 OEM_FIXED_FONT = (10),
 SYSTEM_FONT = (13),
 SYSTEM_FIXED_FONT = (16),
 DEFAULT_PALETTE = (15),
 CT_CTYPE1 = (1),
 CT_CTYPE2 = (2),
 CT_CTYPE3 = (4),
 C1_UPPER = (1),
 C1_LOWER = (2),
 C1_DIGIT = (4),
 C1_SPACE = (8),
 C1_PUNCT = (16),
 C1_CNTRL = (32),
 C1_BLANK = (64),
 C1_XDIGIT = (128),
 C1_ALPHA = (256),
 C2_LEFTTORIGHT = (1),
 C2_RIGHTTOLEFT = (2),
 C2_EUROPENUMBER = (3),
 C2_EUROPESEPARATOR = (4),
 C2_EUROPETERMINATOR = (5),
 C2_ARABICNUMBER = (6),
 C2_COMMONSEPARATOR = (7),
 C2_BLOCKSEPARATOR = (8),
 C2_SEGMENTSEPARATOR = (9),
 C2_WHITESPACE = (10),
 C2_OTHERNEUTRAL = (11),
 C2_NOTAPPLICABLE = (0),
 C3_NONSPACING = (1),
 C3_DIACRITIC = (2),
 C3_VOWELMARK = (4),
 C3_SYMBOL = (8),
 C3_KATAKANA = (16),
 C3_HIRAGANA = (32),
 C3_HALFWIDTH = (64),
 C3_FULLWIDTH = (128),
 C3_IDEOGRAPH = (256),
 C3_KASHIDA = (512),
 C3_ALPHA = (32768),
 C3_NOTAPPLICABLE = (0),
 COLOR_3DDKSHADOW = (21),
 COLOR_3DFACE = (15),
 COLOR_3DHILIGHT = (20),
 COLOR_3DLIGHT = (22),
 COLOR_BTNHILIGHT = (20),
 COLOR_3DSHADOW = (16),
 COLOR_ACTIVEBORDER = (10),
 COLOR_ACTIVECAPTION = (2),
 COLOR_APPWORKSPACE = (12),
 COLOR_BACKGROUND = (1),
 COLOR_DESKTOP = (1),
 COLOR_BTNFACE = (15),
 COLOR_BTNHIGHLIGHT = (20),
 COLOR_BTNSHADOW = (16),
 COLOR_BTNTEXT = (18),
 COLOR_CAPTIONTEXT = (9),
 COLOR_GRAYTEXT = (17),
 COLOR_HIGHLIGHT = (13),
 COLOR_HIGHLIGHTTEXT = (14),
 COLOR_INACTIVEBORDER = (11),
 COLOR_INACTIVECAPTION = (3),
 COLOR_INACTIVECAPTIONTEXT = (19),
 COLOR_INFOBK = (24),
 COLOR_INFOTEXT = (23),
 COLOR_MENU = (4),
 COLOR_MENUTEXT = (7),
 COLOR_SCROLLBAR = (0),
 COLOR_WINDOW = (5),
 COLOR_WINDOWFRAME = (6),
 COLOR_WINDOWTEXT = (8),
 SM_CYMIN = (29),
 SM_CXMIN = (28),
 SM_ARRANGE = (56),
 SM_CLEANBOOT = (67),
 SM_CMETRICS = (76),
 SM_CMOUSEBUTTONS = (43),
 SM_CXBORDER = (5),
 SM_CYBORDER = (6),
 SM_CXCURSOR = (13),
 SM_CYCURSOR = (14),
 SM_CXDLGFRAME = (7),
 SM_CYDLGFRAME = (8),
 SM_CXDOUBLECLK = (36),
 SM_CYDOUBLECLK = (37),
 SM_CXDRAG = (68),
 SM_CYDRAG = (69),
 SM_CXEDGE = (45),
 SM_CYEDGE = (46),
 SM_CXFIXEDFRAME = (7),
 SM_CYFIXEDFRAME = (8),
 SM_CXFRAME = (32),
 SM_CYFRAME = (33),
 SM_CXFULLSCREEN = (16),
 SM_CYFULLSCREEN = (17),
 SM_CXHSCROLL = (21),
 SM_CYHSCROLL = (3),
 SM_CXHTHUMB = (10),
 SM_CXICON = (11),
 SM_CYICON = (12),
 SM_CXICONSPACING = (38),
 SM_CYICONSPACING = (39),
 SM_CXMAXIMIZED = (61),
 SM_CYMAXIMIZED = (62),
 SM_CXMAXTRACK = (59),
 SM_CYMAXTRACK = (60),
 SM_CXMENUCHECK = (71),
 SM_CYMENUCHECK = (72),
 SM_CXMENUSIZE = (54),
 SM_CYMENUSIZE = (55),
 SM_CXMINIMIZED = (57),
 SM_CYMINIMIZED = (58),
 SM_CXMINSPACING = (47),
 SM_CYMINSPACING = (48),
 SM_CXMINTRACK = (34),
 SM_CYMINTRACK = (35),
 SM_CXSCREEN = (0),
 SM_CYSCREEN = (1),
 SM_CXSIZE = (30),
 SM_CYSIZE = (31),
 SM_CXSIZEFRAME = (32),
 SM_CYSIZEFRAME = (33),
 SM_CXSMICON = (49),
 SM_CYSMICON = (50),
 SM_CXSMSIZE = (52),
 SM_CYSMSIZE = (53),
 SM_CXVSCROLL = (2),
 SM_CYVSCROLL = (20),
 SM_CYVTHUMB = (9),
 SM_CYCAPTION = (4),
 SM_CYKANJIWINDOW = (18),
 SM_CYMENU = (15),
 SM_CYSMCAPTION = (51),
 SM_DBCSENABLED = (42),
 SM_DEBUG = (22),
 SM_MENUDROPALIGNMENT = (40),
 SM_MIDEASTENABLED = (74),
 SM_MOUSEPRESENT = (19),
 SM_MOUSEWHEELPRESENT = (75),
 SM_NETWORK = (63),
 SM_PENWINDOWS = (41),
 SM_SECURE = (44),
 SM_SHOWSOUNDS = (70),
 SM_SLOWMACHINE = (73),
 SM_SWAPBUTTON = (23),
 ARW_BOTTOMLEFT = (0),
 ARW_BOTTOMRIGHT = (0x1),
 ARW_HIDE = (0x8),
 ARW_TOPLEFT = (0x2),
 ARW_TOPRIGHT = (0x3),
 ARW_DOWN = (0x4),
 ARW_LEFT = (0),
 ARW_RIGHT = (0),
 ARW_UP = (0x4),
 SYSPAL_NOSTATIC = (2),
 SYSPAL_STATIC = (1),
 SYSPAL_ERROR = (0),
 GET_TAPE_MEDIA_INFORMATION = (0),
 GET_TAPE_DRIVE_INFORMATION = (1),
 SET_TAPE_MEDIA_INFORMATION = (0),
 SET_TAPE_DRIVE_INFORMATION = (1),
 TAPE_ABSOLUTE_POSITION = (0),
 TAPE_LOGICAL_POSITION = (0x1),
 TA_BASELINE = (24),
 TA_BOTTOM = (8),
 TA_TOP = (0),
 TA_CENTER = (6),
 TA_LEFT = (0),
 TA_RIGHT = (2),
 TA_RTLREADING = (256),
 TA_NOUPDATECP = (0),
 TA_UPDATECP = (1),
 VTA_BASELINE = (24),
 VTA_CENTER = (6),
 THREAD_PRIORITY_ABOVE_NORMAL = (1),
 THREAD_PRIORITY_BELOW_NORMAL = -((1)),
 THREAD_PRIORITY_HIGHEST = (2),
 THREAD_PRIORITY_IDLE = -((15)),
 THREAD_PRIORITY_LOWEST = -((2)),
 THREAD_PRIORITY_NORMAL = (0),
 THREAD_PRIORITY_TIME_CRITICAL = (15),
 THREAD_PRIORITY_ERROR_RETURN = (2147483647),
 TLS_MINIMUM_AVAILABLE = (64),
 TIME_NOMINUTESORSECONDS = (1),
 TIME_NOSECONDS = (2),
 TIME_NOTIMEMARKER = (4),
 TIME_FORCE24HOURFORMAT = (8),
 TIME_ZONE_ID_INVALID = -(1),
 TIME_ZONE_ID_UNKNOWN = (0),
 TIME_ZONE_ID_STANDARD = (1),
 TIME_ZONE_ID_DAYLIGHT = (2),
 UOI_FLAGS = (1),
 UOI_NAME = (2),
 UOI_TYPE = (3),
 FS_CASE_IS_PRESERVED = (2),
 FS_CASE_SENSITIVE = (1),
 FS_UNICODE_STORED_ON_DISK = (4),
 FS_PERSISTENT_ACLS = (8),
 FS_FILE_COMPRESSION = (16),
 FS_VOL_IS_COMPRESSED = (32768),
 GWL_EXSTYLE = -((20)),
 GWL_STYLE = -((16)),
 GWL_WNDPROC = -((4)),
 GWL_HINSTANCE = -((6)),
 GWL_HWNDPARENT = -((8)),
 GWL_ID = -((12)),
 GWL_USERDATA = -((21)),
 DWL_DLGPROC = (4),
 DWL_MSGRESULT = (0),
 DWL_USER = (8),
 GMEM_FIXED = (0),
 GMEM_MOVEABLE = (2),
 GPTR = (64),
 GHND = (66),
 GMEM_DDESHARE = (8192),
 GMEM_DISCARDABLE = (256),
 GMEM_LOWER = (4096),
 GMEM_NOCOMPACT = (16),
 GMEM_NODISCARD = (32),
 GMEM_NOT_BANKED = (4096),
 GMEM_NOTIFY = (16384),
 GMEM_SHARE = (8192),
 GMEM_ZEROINIT = (64),
 GMEM_DISCARDED = (16384),
 GMEM_INVALID_HANDLE = (32768),
 GMEM_LOCKCOUNT = (255),
 HEAP_GENERATE_EXCEPTIONS = (4),
 HEAP_NO_SERIALIZE = (1),
 HEAP_ZERO_MEMORY = (8),
 STATUS_NO_MEMORY = (0xc0000017),
 STATUS_ACCESS_VIOLATION = (0xc0000005),
 HEAP_REALLOC_IN_PLACE_ONLY = (16),
 ILC_COLOR = (0),
 ILC_COLOR4 = (4),
 ILC_COLOR8 = (8),
 ILC_COLOR16 = (16),
 ILC_COLOR24 = (24),
 ILC_COLOR32 = (32),
 ILC_COLORDDB = (254),
 ILC_MASK = (1),
 ILC_PALETTE = (2048),
 ILD_BLEND25 = (2),
 ILD_BLEND50 = (4),
 ILD_SELECTED = (4),
 ILD_BLEND = (4),
 ILD_FOCUS = (2),
 ILD_MASK = (16),
 ILD_NORMAL = (0),
 ILD_TRANSPARENT = (1),
 CLR_NONE = (0xffffffff),
 CLR_DEFAULT = (0xff000000),
 CLR_INVALID = (0xFFFFFFFF),
 LR_LOADFROMFILE = (16),
 LR_LOADMAP3DCOLORS = (4096),
 LR_LOADTRANSPARENT = (32),
 IME_CONFIG_GENERAL = (1),
 IME_CONFIG_REGISTERWORD = (2),
 IME_CONFIG_SELECTDICTIONARY = (3),
 GCL_CONVERSION = (1),
 GCL_REVERSECONVERSION = (2),
 GCL_REVERSE_LENGTH = (3),
 GGL_LEVEL = (1),
 GGL_INDEX = (2),
 GGL_STRING = (3),
 GGL_PRIVATE = (4),
 GL_LEVEL_ERROR = (2),
 GL_LEVEL_FATAL = (1),
 GL_LEVEL_INFORMATION = (4),
 GL_LEVEL_NOGUIDELINE = (0),
 GL_LEVEL_WARNING = (3),
 GL_ID_CANNOTSAVE = (17),
 GL_ID_NOCONVERT = (32),
 GL_ID_NODICTIONARY = (16),
 GL_ID_NOMODULE = (1),
 GL_ID_READINGCONFLICT = (35),
 GL_ID_TOOMANYSTROKE = (34),
 GL_ID_TYPINGERROR = (33),
 GL_ID_UNKNOWN = (0),
 GL_ID_INPUTREADING = (36),
 GL_ID_INPUTRADICAL = (37),
 GL_ID_INPUTCODE = (38),
 GL_ID_CHOOSECANDIDATE = (40),
 GL_ID_REVERSECONVERSION = (41),
 IGP_PROPERTY = (4),
 IGP_CONVERSION = (8),
 IGP_SENTENCE = (12),
 IGP_UI = (16),
 IGP_SETCOMPSTR = (20),
 IGP_SELECT = (24),
 IME_PROP_AT_CARET = (65536),
 IME_PROP_SPECIAL_UI = (131072),
 IME_PROP_CANDLIST_START_FROM_1 = (262144),
 IME_PROP_UNICODE = (524288),
 UI_CAP_2700 = (1),
 UI_CAP_ROT90 = (2),
 UI_CAP_ROTANY = (4),
 SCS_CAP_COMPSTR = (1),
 SCS_CAP_MAKEREAD = (2),
 SELECT_CAP_CONVERSION = (1),
 SELECT_CAP_SENTENCE = (2),
 NI_CHANGECANDIDATELIST = (19),
 NI_CLOSECANDIDATE = (17),
 NI_COMPOSITIONSTR = (21),
 NI_OPENCANDIDATE = (16),
 NI_SELECTCANDIDATESTR = (18),
 NI_SETCANDIDATE_PAGESIZE = (23),
 NI_SETCANDIDATE_PAGESTART = (22),
 CPS_CANCEL = (4),
 CPS_COMPLETE = (1),
 CPS_CONVERT = (2),
 CPS_REVERT = (3),
 SCS_SETSTR = (9),
 SCS_CHANGEATTR = (18),
 SCS_CHANGECLAUSE = (36),
 IME_REGWORD_STYLE_EUDC = (1),
 IME_REGWORD_STYLE_USER_FIRST = (0x80000000),
 IME_REGWORD_STYLE_USER_LAST = -((1)),
 SECURITY_DESCRIPTOR_REVISION = (1),
 IS_TEXT_UNICODE_ASCII16 = (1),
 IS_TEXT_UNICODE_REVERSE_ASCII16 = (16),
 IS_TEXT_UNICODE_STATISTICS = (2),
 IS_TEXT_UNICODE_REVERSE_STATISTICS = (32),
 IS_TEXT_UNICODE_CONTROLS = (4),
 IS_TEXT_UNICODE_REVERSE_CONTROLS = (64),
 IS_TEXT_UNICODE_SIGNATURE = (8),
 IS_TEXT_UNICODE_REVERSE_SIGNATURE = (128),
 IS_TEXT_UNICODE_ILLEGAL_CHARS = (256),
 IS_TEXT_UNICODE_ODD_LENGTH = (512),
 IS_TEXT_UNICODE_NULL_BYTES = (4096),
 IS_TEXT_UNICODE_UNICODE_MASK = (15),
 IS_TEXT_UNICODE_REVERSE_MASK = (240),
 IS_TEXT_UNICODE_NOT_UNICODE_MASK = (3840),
 IS_TEXT_UNICODE_NOT_ASCII_MASK = (61440),
 HC_GETNEXT = (1),
 HC_SKIP = (2),
 HC_SYSMODALOFF = (5),
 HC_SYSMODALON = (4),
 HC_NOREMOVE = (3),
 KEYEVENTF_EXTENDEDKEY = (1),
 KEYEVENTF_KEYUP = (2),
 OBM_BTNCORNERS = (32758),
 OBM_BTSIZE = (32761),
 OBM_CHECK = (32760),
 OBM_CHECKBOXES = (32759),
 OBM_CLOSE = (32754),
 OBM_COMBO = (32738),
 OBM_DNARROW = (32752),
 OBM_DNARROWD = (32742),
 OBM_DNARROWI = (32736),
 OBM_LFARROW = (32750),
 OBM_LFARROWI = (32734),
 OBM_LFARROWD = (32740),
 OBM_MNARROW = (32739),
 OBM_OLD_CLOSE = (32767),
 OBM_OLD_DNARROW = (32764),
 OBM_OLD_LFARROW = (32762),
 OBM_OLD_REDUCE = (32757),
 OBM_OLD_RESTORE = (32755),
 OBM_OLD_RGARROW = (32763),
 OBM_OLD_UPARROW = (32765),
 OBM_OLD_ZOOM = (32756),
 OBM_REDUCE = (32749),
 OBM_REDUCED = (32746),
 OBM_RESTORE = (32747),
 OBM_RESTORED = (32744),
 OBM_RGARROW = (32751),
 OBM_RGARROWD = (32741),
 OBM_RGARROWI = (32735),
 OBM_SIZE = (32766),
 OBM_UPARROW = (32753),
 OBM_UPARROWD = (32743),
 OBM_UPARROWI = (32737),
 OBM_ZOOM = (32748),
 OBM_ZOOMD = (32745),
 DONT_RESOLVE_DLL_REFERENCES = (1),
 LOAD_LIBRARY_AS_DATAFILE = (2),
 LOAD_WITH_ALTERED_SEARCH_PATH = (8),
 LPTR = (64),
 LHND = (66),
 NONZEROLHND = (2),
 NONZEROLPTR = (0),
 LMEM_NONZEROLHND = (2),
 LMEM_NONZEROLPTR = (0),
 LMEM_FIXED = (0),
 LMEM_MOVEABLE = (2),
 LMEM_NOCOMPACT = (16),
 LMEM_NODISCARD = (32),
 LMEM_ZEROINIT = (64),
 LMEM_MODIFY = (128),
 LMEM_LOCKCOUNT = (255),
 LMEM_DISCARDABLE = (3840),
 LMEM_DISCARDED = (16384),
 LMEM_INVALID_HANDLE = (32768),
 LOCKFILE_FAIL_IMMEDIATELY = (1),
 LOCKFILE_EXCLUSIVE_LOCK = (2),
 MB_USERICON = (0x80),
 MB_ICONASTERISK = (0x40),
 MB_ICONEXCLAMATION = (0x30),
 MB_ICONWARNING = (0x30),
 MB_ICONERROR = (0x10),
 MB_ICONHAND = (0x10),
 MB_ICONQUESTION = (0x20),
 MB_OK = (0),
 MB_ABORTRETRYIGNORE = (0x2),
 MB_APPLMODAL = (0),
 MB_DEFAULT_DESKTOP_ONLY = (0x20000),
 MB_HELP = (0x4000),
 MB_RIGHT = (0x80000),
 MB_RTLREADING = (0x100000),
 MB_TOPMOST = (0x40000),
 MB_DEFBUTTON1 = (0),
 MB_DEFBUTTON2 = (0x100),
 MB_DEFBUTTON3 = (0x200),
 MB_DEFBUTTON4 = (0x300),
 MB_ICONINFORMATION = (0x40),
 MB_ICONSTOP = (0x10),
 MB_OKCANCEL = (0x1),
 MB_RETRYCANCEL = (0x5),
 MB_SERVICE_NOTIFICATION = (0x40000),
 MB_SETFOREGROUND = (0x10000),
 MB_SYSTEMMODAL = (0x1000),
 MB_TASKMODAL = (0x2000),
 MB_YESNO = (0x4),
 MB_YESNOCANCEL = (0x3),
 IDABORT = (3),
 IDCANCEL = (2),
 IDCLOSE = (8),
 IDHELP = (9),
 IDIGNORE = (5),
 IDNO = (7),
 IDOK = (1),
 IDRETRY = (4),
 IDYES = (6),
 MSGF_DIALOGBOX = (0),
 MSGF_MENU = (2),
 MSGF_NEXTWINDOW = (6),
 MSGF_SCROLLBAR = (5),
 MSGF_MAINLOOP = (8),
 MSGF_USER = (4096),
 MWT_IDENTITY = (1),
 MWT_LEFTMULTIPLY = (2),
 MWT_RIGHTMULTIPLY = (3),
 MOUSEEVENTF_ABSOLUTE = (32768),
 MOUSEEVENTF_MOVE = (1),
 MOUSEEVENTF_LEFTDOWN = (2),
 MOUSEEVENTF_LEFTUP = (4),
 MOUSEEVENTF_RIGHTDOWN = (8),
 MOUSEEVENTF_RIGHTUP = (16),
 MOUSEEVENTF_MIDDLEDOWN = (32),
 MOUSEEVENTF_MIDDLEUP = (64),
 MOVEFILE_REPLACE_EXISTING = (1),
 MOVEFILE_COPY_ALLOWED = (2),
 MOVEFILE_DELAY_UNTIL_REBOOT = (4),
 MOVEFILE_WRITE_THROUGH = (8),
 WAIT_OBJECT_0 = (0),
 WAIT_ABANDONED_0 = (0x80),
 WAIT_TIMEOUT = (0x102),
 WAIT_IO_COMPLETION = (0xc0),
 WAIT_ABANDONED = (0x80),
 WAIT_FAILED = (0xffffffff),
 MAXIMUM_WAIT_OBJECTS = (0x40),
 MAXIMUM_SUSPEND_COUNT = (0x7f),
 MB_PRECOMPOSED = (1),
 MB_COMPOSITE = (2),
 MB_ERR_INVALID_CHARS = (8),
 MB_USEGLYPHCHARS = (4),
 TOKEN_ADJUST_DEFAULT = (128),
 TOKEN_ADJUST_GROUPS = (64),
 TOKEN_ADJUST_PRIVILEGES = (32),
 TOKEN_ALL_ACCESS = (0xf00ff),
 TOKEN_ASSIGN_PRIMARY = (1),
 TOKEN_DUPLICATE = (2),
 TOKEN_EXECUTE = (0x20000),
 TOKEN_IMPERSONATE = (4),
 TOKEN_QUERY = (8),
 TOKEN_QUERY_SOURCE = (16),
 TOKEN_READ = (0x20008),
 TOKEN_WRITE = (0x200e0),
 SC_MANAGER_ALL_ACCESS = (0xf003f),
 SC_MANAGER_CONNECT = (1),
 SC_MANAGER_CREATE_SERVICE = (2),
 SC_MANAGER_ENUMERATE_SERVICE = (4),
 SC_MANAGER_LOCK = (8),
 SC_MANAGER_QUERY_LOCK_STATUS = (16),
 SC_MANAGER_MODIFY_BOOT_CONFIG = (32),
 TAPE_FORMAT = (0x5),
 TAPE_LOAD = (0),
 TAPE_LOCK = (0x3),
 TAPE_TENSION = (0x2),
 TAPE_UNLOAD = (0x1),
 TAPE_UNLOCK = (0x4),
 IS_PSREBOOTSYSTEM = (3),
 IS_PSRESTARTWINDOWS = (2),
 PSPCB_CREATE = (2),
 PSPCB_RELEASE = (1),
 PURGE_TXABORT = (1),
 PURGE_RXABORT = (2),
 PURGE_TXCLEAR = (4),
 PURGE_RXCLEAR = (8),
 OWNER_SECURITY_INFORMATION = (0x1),
 GROUP_SECURITY_INFORMATION = (0x2),
 DACL_SECURITY_INFORMATION = (0x4),
 SACL_SECURITY_INFORMATION = (0x8),
 EVENTLOG_FORWARDS_READ = (4),
 EVENTLOG_BACKWARDS_READ = (8),
 EVENTLOG_SEEK_READ = (2),
 EVENTLOG_SEQUENTIAL_READ = (1),
 EVENTLOG_ERROR_TYPE = (1),
 EVENTLOG_WARNING_TYPE = (2),
 EVENTLOG_INFORMATION_TYPE = (4),
 EVENTLOG_AUDIT_SUCCESS = (8),
 EVENTLOG_AUDIT_FAILURE = (16),
 RDW_ERASE = (4),
 RDW_FRAME = (1024),
 RDW_INTERNALPAINT = (2),
 RDW_INVALIDATE = (1),
 RDW_NOERASE = (32),
 RDW_NOFRAME = (2048),
 RDW_NOINTERNALPAINT = (16),
 RDW_VALIDATE = (8),
 RDW_ERASENOW = (512),
 RDW_UPDATENOW = (256),
 RDW_ALLCHILDREN = (128),
 RDW_NOCHILDREN = (64),
/*
 //
 HKEY_CLASSES_ROOT = (0x80000000),
 HKEY_CURRENT_USER = (0x80000001),
 HKEY_LOCAL_MACHINE = (0x80000002),
 HKEY_USERS = (0x80000003),
 HKEY_PERFORMANCE_DATA = (0x80000004),
 HKEY_CURRENT_CONFIG = (0x80000005),
 HKEY_DYN_DATA = (0x80000006),
*/
 REG_OPTION_VOLATILE = (0x1),
 REG_OPTION_NON_VOLATILE = (0),
 REG_CREATED_NEW_KEY = (0x1),
 REG_OPENED_EXISTING_KEY = (0x2),
 REG_BINARY = (3),
 REG_DWORD = (4),
 REG_DWORD_LITTLE_ENDIAN = (4),
 REG_DWORD_BIG_ENDIAN = (5),
 REG_EXPAND_SZ = (2),
 REG_FULL_RESOURCE_DESCRIPTOR = (9),
 REG_LINK = (6),
 REG_MULTI_SZ = (7),
 REG_NONE = (0),
 REG_RESOURCE_LIST = (8),
 REG_RESOURCE_REQUIREMENTS_LIST = (10),
 REG_SZ = (1),
 MOD_ALT = (1),
 MOD_CONTROL = (2),
 MOD_SHIFT = (4),
 MOD_WIN = (8),
 IDHOT_SNAPDESKTOP = -((2)),
 IDHOT_SNAPWINDOW = -((1)),
 REG_NOTIFY_CHANGE_NAME = (0x1),
 REG_NOTIFY_CHANGE_ATTRIBUTES = (0x2),
 REG_NOTIFY_CHANGE_LAST_SET = (0x4),
 REG_NOTIFY_CHANGE_SECURITY = (0x8),
 SW_ERASE = (4),
 SW_INVALIDATE = (2),
 SW_SCROLLCHILDREN = (1),
 SMTO_ABORTIFHUNG = (2),
 SMTO_BLOCK = (1),
 SMTO_NORMAL = (0),
 OPAQUE = (2),
 TRANSPARENT = (1),
 SLE_ERROR = (1),
 SLE_MINORERROR = (2),
 SLE_WARNING = (3),
 SEM_FAILCRITICALERRORS = (1),
 SEM_NOALIGNMENTFAULTEXCEPT = (4),
 SEM_NOGPFAULTERRORBOX = (2),
 SEM_NOOPENFILEERRORBOX = (32768),
 ICM_ON = (2),
 ICM_OFF = (1),
 ICM_QUERY = (3),
 LOCALE_ILANGUAGE = (1),
 LOCALE_SLANGUAGE = (2),
 LOCALE_SENGLANGUAGE = (4097),
 LOCALE_SABBREVLANGNAME = (3),
 LOCALE_SNATIVELANGNAME = (4),
 LOCALE_ICOUNTRY = (5),
 LOCALE_SCOUNTRY = (6),
 LOCALE_SENGCOUNTRY = (4098),
 LOCALE_SABBREVCTRYNAME = (7),
 LOCALE_SNATIVECTRYNAME = (8),
 LOCALE_IDEFAULTLANGUAGE = (9),
 LOCALE_IDEFAULTCOUNTRY = (10),
 LOCALE_IDEFAULTANSICODEPAGE = (4100),
 LOCALE_IDEFAULTCODEPAGE = (11),
 LOCALE_SLIST = (12),
 LOCALE_IMEASURE = (13),
 LOCALE_SDECIMAL = (14),
 LOCALE_STHOUSAND = (15),
 LOCALE_SGROUPING = (16),
 LOCALE_IDIGITS = (17),
 LOCALE_ILZERO = (18),
 LOCALE_INEGNUMBER = (4112),
 LOCALE_SCURRENCY = (20),
 LOCALE_SMONDECIMALSEP = (22),
 LOCALE_SMONTHOUSANDSEP = (23),
 LOCALE_SMONGROUPING = (24),
 LOCALE_ICURRDIGITS = (25),
 LOCALE_ICURRENCY = (27),
 LOCALE_INEGCURR = (28),
 LOCALE_SDATE = (29),
 LOCALE_STIME = (30),
 LOCALE_STIMEFORMAT = (4099),
 LOCALE_SSHORTDATE = (31),
 LOCALE_SLONGDATE = (32),
 LOCALE_SYEARMONTH = (0x00001006),
 LOCALE_IDATE = (33),
 LOCALE_ILDATE = (34),
 LOCALE_ITIME = (35),
 LOCALE_ITLZERO = (37),
 LOCALE_IDAYLZERO = (38),
 LOCALE_IMONLZERO = (39),
 LOCALE_S1159 = (40),
 LOCALE_S2359 = (41),
 LOCALE_ICALENDARTYPE = (4105),
 LOCALE_IOPTIONALCALENDAR = (4107),
 LOCALE_IFIRSTDAYOFWEEK = (4108),
 LOCALE_IFIRSTWEEKOFYEAR = (4109),
 LOCALE_SDAYNAME1 = (42),
 LOCALE_SDAYNAME2 = (43),
 LOCALE_SDAYNAME3 = (44),
 LOCALE_SDAYNAME4 = (45),
 LOCALE_SDAYNAME5 = (46),
 LOCALE_SDAYNAME6 = (47),
 LOCALE_SDAYNAME7 = (48),
 LOCALE_SABBREVDAYNAME1 = (49),
 LOCALE_SABBREVDAYNAME2 = (50),
 LOCALE_SABBREVDAYNAME3 = (51),
 LOCALE_SABBREVDAYNAME4 = (52),
 LOCALE_SABBREVDAYNAME5 = (53),
 LOCALE_SABBREVDAYNAME6 = (54),
 LOCALE_SABBREVDAYNAME7 = (55),
 LOCALE_SMONTHNAME1 = (56),
 LOCALE_SMONTHNAME2 = (57),
 LOCALE_SMONTHNAME3 = (58),
 LOCALE_SMONTHNAME4 = (59),
 LOCALE_SMONTHNAME5 = (60),
 LOCALE_SMONTHNAME6 = (61),
 LOCALE_SMONTHNAME7 = (62),
 LOCALE_SMONTHNAME8 = (63),
 LOCALE_SMONTHNAME9 = (64),
 LOCALE_SMONTHNAME10 = (65),
 LOCALE_SMONTHNAME11 = (66),
 LOCALE_SMONTHNAME12 = (67),
 LOCALE_SMONTHNAME13 = (4110),
 LOCALE_SABBREVMONTHNAME1 = (68),
 LOCALE_SABBREVMONTHNAME2 = (69),
 LOCALE_SABBREVMONTHNAME3 = (70),
 LOCALE_SABBREVMONTHNAME4 = (71),
 LOCALE_SABBREVMONTHNAME5 = (72),
 LOCALE_SABBREVMONTHNAME6 = (73),
 LOCALE_SABBREVMONTHNAME7 = (74),
 LOCALE_SABBREVMONTHNAME8 = (75),
 LOCALE_SABBREVMONTHNAME9 = (76),
 LOCALE_SABBREVMONTHNAME10 = (77),
 LOCALE_SABBREVMONTHNAME11 = (78),
 LOCALE_SABBREVMONTHNAME12 = (79),
 LOCALE_SABBREVMONTHNAME13 = (4111),
 LOCALE_SPOSITIVESIGN = (80),
 LOCALE_SNEGATIVESIGN = (81),
 LOCALE_IPOSSIGNPOSN = (82),
 LOCALE_INEGSIGNPOSN = (83),
 LOCALE_IPOSSYMPRECEDES = (84),
 LOCALE_IPOSSEPBYSPACE = (85),
 LOCALE_INEGSYMPRECEDES = (86),
 LOCALE_INEGSEPBYSPACE = (87),
 LOCALE_NOUSEROVERRIDE = (0x80000000),
 CAL_ICALINTVALUE = (1),
 CAL_IYEAROFFSETRANGE = (3),
 CAL_SABBREVDAYNAME1 = (14),
 CAL_SABBREVDAYNAME2 = (15),
 CAL_SABBREVDAYNAME3 = (16),
 CAL_SABBREVDAYNAME4 = (17),
 CAL_SABBREVDAYNAME5 = (18),
 CAL_SABBREVDAYNAME6 = (19),
 CAL_SABBREVDAYNAME7 = (20),
 CAL_SABBREVMONTHNAME1 = (34),
 CAL_SABBREVMONTHNAME2 = (35),
 CAL_SABBREVMONTHNAME3 = (36),
 CAL_SABBREVMONTHNAME4 = (37),
 CAL_SABBREVMONTHNAME5 = (38),
 CAL_SABBREVMONTHNAME6 = (39),
 CAL_SABBREVMONTHNAME7 = (40),
 CAL_SABBREVMONTHNAME8 = (41),
 CAL_SABBREVMONTHNAME9 = (42),
 CAL_SABBREVMONTHNAME10 = (43),
 CAL_SABBREVMONTHNAME11 = (44),
 CAL_SABBREVMONTHNAME12 = (45),
 CAL_SABBREVMONTHNAME13 = (46),
 CAL_SCALNAME = (2),
 CAL_SDAYNAME1 = (7),
 CAL_SDAYNAME2 = (8),
 CAL_SDAYNAME3 = (9),
 CAL_SDAYNAME4 = (10),
 CAL_SDAYNAME5 = (11),
 CAL_SDAYNAME6 = (12),
 CAL_SDAYNAME7 = (13),
 CAL_SERASTRING = (4),
 CAL_SLONGDATE = (6),
 CAL_SMONTHNAME1 = (21),
 CAL_SMONTHNAME2 = (22),
 CAL_SMONTHNAME3 = (23),
 CAL_SMONTHNAME4 = (24),
 CAL_SMONTHNAME5 = (25),
 CAL_SMONTHNAME6 = (26),
 CAL_SMONTHNAME7 = (27),
 CAL_SMONTHNAME8 = (28),
 CAL_SMONTHNAME9 = (29),
 CAL_SMONTHNAME10 = (30),
 CAL_SMONTHNAME11 = (31),
 CAL_SMONTHNAME12 = (32),
 CAL_SMONTHNAME13 = (33),
 CAL_SSHORTDATE = (5),
 PROCESS_SET_QUOTA = (256),
 BLACKONWHITE = (1),
 COLORONCOLOR = (3),
 HALFTONE = (4),
 STRETCH_ANDSCANS = (1),
 STRETCH_DELETESCANS = (3),
 STRETCH_HALFTONE = (4),
 STRETCH_ORSCANS = (2),
 WHITEONBLACK = (2),
 OCR_NORMAL = (32512),
 OCR_IBEAM = (32513),
 OCR_WAIT = (32514),
 OCR_CROSS = (32515),
 OCR_UP = (32516),
 OCR_SIZE = (32640),
 OCR_ICON = (32641),
 OCR_SIZENWSE = (32642),
 OCR_SIZENESW = (32643),
 OCR_SIZEWE = (32644),
 OCR_SIZENS = (32645),
 OCR_SIZEALL = (32646),
 OCR_NO = (32648),
 OCR_APPSTARTING = (32650),
 TAPE_ABSOLUTE_BLOCK = (0x1),
 TAPE_LOGICAL_BLOCK = (0x2),
 TAPE_REWIND = (0),
 TAPE_SPACE_END_OF_DATA = (0x4),
 TAPE_SPACE_FILEMARKS = (0x6),
 TAPE_SPACE_RELATIVE_BLOCKS = (0x5),
 TAPE_SPACE_SEQUENTIAL_FMKS = (0x7),
 TAPE_SPACE_SEQUENTIAL_SMKS = (0x9),
 TAPE_SPACE_SETMARKS = (0x8),
 EXCEPTION_EXECUTE_HANDLER = (1),
 EXCEPTION_CONTINUE_EXECUTION = -((1)),
 EXCEPTION_CONTINUE_SEARCH = (0),
 SWP_DRAWFRAME = (32),
 SWP_FRAMECHANGED = (32),
 SWP_HIDEWINDOW = (128),
 SWP_NOACTIVATE = (16),
 SWP_NOCOPYBITS = (256),
 SWP_NOMOVE = (2),
 SWP_NOSIZE = (1),
 SWP_NOREDRAW = (8),
 SWP_NOZORDER = (4),
 SWP_SHOWWINDOW = (64),
 SWP_NOOWNERZORDER = (512),
 SWP_NOREPOSITION = (512),
 SWP_NOSENDCHANGING = (1024),
 HSHELL_ACTIVATESHELLWINDOW = (3),
 HSHELL_GETMINRECT = (5),
 HSHELL_LANGUAGE = (8),
 HSHELL_REDRAW = (6),
 HSHELL_TASKMAN = (7),
 HSHELL_WINDOWACTIVATED = (4),
 HSHELL_WINDOWCREATED = (1),
 HSHELL_WINDOWDESTROYED = (2),
 SW_HIDE = (0),
 SW_MAXIMIZE = (3),
 SW_MINIMIZE = (6),
 SW_NORMAL = (1),
 SW_RESTORE = (9),
 SW_SHOW = (5),
 SW_SHOWDEFAULT = (10),
 SW_SHOWMAXIMIZED = (3),
 SW_SHOWMINIMIZED = (2),
 SW_SHOWMINNOACTIVE = (7),
 SW_SHOWNA = (8),
 SW_SHOWNOACTIVATE = (4),
 SW_SHOWNORMAL = (1),
 WPF_RESTORETOMAXIMIZED = (2),
 WPF_SETMINPOSITION = (1),
 INFINITE = (0xFFFFFFFF),
 SPI_GETACCESSTIMEOUT = (60),
 SPI_GETANIMATION = (72),
 SPI_GETBEEP = (1),
 SPI_GETBORDER = (5),
 SPI_GETDEFAULTINPUTLANG = (89),
 SPI_GETDRAGFULLWINDOWS = (38),
 SPI_GETFASTTASKSWITCH = (35),
 SPI_GETFILTERKEYS = (50),
 SPI_GETFONTSMOOTHING = (74),
 SPI_GETGRIDGRANULARITY = (18),
 SPI_GETHIGHCONTRAST = (66),
 SPI_GETICONMETRICS = (45),
 SPI_GETICONTITLELOGFONT = (31),
 SPI_GETICONTITLEWRAP = (25),
 SPI_GETKEYBOARDDELAY = (22),
 SPI_GETKEYBOARDPREF = (68),
 SPI_GETKEYBOARDSPEED = (10),
 SPI_GETLOWPOWERACTIVE = (83),
 SPI_GETLOWPOWERTIMEOUT = (79),
 SPI_GETMENUDROPALIGNMENT = (27),
 SPI_GETMINIMIZEDMETRICS = (43),
 SPI_GETMOUSE = (3),
 SPI_GETMOUSEKEYS = (54),
 SPI_GETMOUSETRAILS = (94),
 SPI_GETNONCLIENTMETRICS = (41),
 SPI_GETPOWEROFFACTIVE = (84),
 SPI_GETPOWEROFFTIMEOUT = (80),
 SPI_GETSCREENREADER = (70),
 SPI_GETSCREENSAVEACTIVE = (16),
 SPI_GETSCREENSAVETIMEOUT = (14),
 SPI_GETSERIALKEYS = (62),
 SPI_GETSHOWSOUNDS = (56),
 SPI_GETSOUNDSENTRY = (64),
 SPI_GETSTICKYKEYS = (58),
 SPI_GETTOGGLEKEYS = (52),
 SPI_GETWINDOWSEXTENSION = (92),
 SPI_GETWORKAREA = (48),
 SPI_ICONHORIZONTALSPACING = (13),
 SPI_ICONVERTICALSPACING = (24),
 SPI_LANGDRIVER = (12),
 SPI_SCREENSAVERRUNNING = (97),
 SPI_SETACCESSTIMEOUT = (61),
 SPI_SETANIMATION = (73),
 SPI_SETBEEP = (2),
 SPI_SETBORDER = (6),
 SPI_SETDEFAULTINPUTLANG = (90),
 SPI_SETDESKPATTERN = (21),
 SPI_SETDESKWALLPAPER = (20),
 SPI_SETDOUBLECLICKTIME = (32),
 SPI_SETDOUBLECLKHEIGHT = (30),
 SPI_SETDOUBLECLKWIDTH = (29),
 SPI_SETDRAGFULLWINDOWS = (37),
 SPI_SETDRAGHEIGHT = (77),
 SPI_SETDRAGWIDTH = (76),
 SPI_SETFASTTASKSWITCH = (36),
 SPI_SETFILTERKEYS = (51),
 SPI_SETFONTSMOOTHING = (75),
 SPI_SETGRIDGRANULARITY = (19),
 SPI_SETHANDHELD = (78),
 SPI_SETHIGHCONTRAST = (67),
 SPI_SETICONMETRICS = (46),
 SPI_SETICONTITLELOGFONT = (34),
 SPI_SETICONTITLEWRAP = (26),
 SPI_SETKEYBOARDDELAY = (23),
 SPI_SETKEYBOARDPREF = (69),
 SPI_SETKEYBOARDSPEED = (11),
 SPI_SETLANGTOGGLE = (91),
 SPI_SETLOWPOWERACTIVE = (85),
 SPI_SETLOWPOWERTIMEOUT = (81),
 SPI_SETMENUDROPALIGNMENT = (28),
 SPI_SETMINIMIZEDMETRICS = (44),
 SPI_SETMOUSE = (4),
 SPI_SETMOUSEBUTTONSWAP = (33),
 SPI_SETMOUSEKEYS = (55),
 SPI_SETMOUSETRAILS = (93),
 SPI_SETNONCLIENTMETRICS = (42),
 SPI_SETPENWINDOWS = (49),
 SPI_SETPOWEROFFACTIVE = (86),
 SPI_SETPOWEROFFTIMEOUT = (82),
 SPI_SETSCREENREADER = (71),
 SPI_SETSCREENSAVEACTIVE = (17),
 SPI_SETSCREENSAVETIMEOUT = (15),
 SPI_SETSERIALKEYS = (63),
 SPI_SETSHOWSOUNDS = (57),
 SPI_SETSOUNDSENTRY = (65),
 SPI_SETSTICKYKEYS = (59),
 SPI_SETTOGGLEKEYS = (53),
 SPI_SETWORKAREA = (47),
 SPIF_UPDATEINIFILE = (1),
 SPIF_SENDWININICHANGE = (2),
 SPIF_SENDCHANGE = (2),
 TPM_CENTERALIGN = (0x4),
 TPM_LEFTALIGN = (0),
 TPM_RIGHTALIGN = (0x8),
 TPM_LEFTBUTTON = (0),
 TPM_RIGHTBUTTON = (0x2),
 TPM_HORIZONTAL = (0),
 TPM_VERTICAL = (0x40),
 TCI_SRCCHARSET = (1),
 TCI_SRCCODEPAGE = (2),
 TCI_SRCFONTSIG = (3),
 VFFF_ISSHAREDFILE = (1),
 VFF_CURNEDEST = (1),
 VFF_FILEINUSE = (2),
 VFF_BUFFTOOSMALL = (4),
 VIFF_FORCEINSTALL = (1),
 VIFF_DONTDELETEOLD = (2),
 VIF_TEMPFILE = (0x1),
 VIF_MISMATCH = (0x2),
 VIF_SRCOLD = (0x4),
 VIF_DIFFLANG = (0x8),
 VIF_DIFFCODEPG = (0x10),
 VIF_DIFFTYPE = (0x20),
 VIF_WRITEPROT = (0x40),
 VIF_FILEINUSE = (0x80),
 VIF_OUTOFSPACE = (0x100),
 VIF_ACCESSVIOLATION = (0x200),
 VIF_SHARINGVIOLATION = (0x400),
 VIF_CANNOTCREATE = (0x800),
 VIF_CANNOTDELETE = (0x1000),
 VIF_CANNOTDELETECUR = (0x4000),
 VIF_CANNOTRENAME = (0x2000),
 VIF_OUTOFMEMORY = (0x8000),
 VIF_CANNOTREADSRC = (0x10000),
 VIF_CANNOTREADDST = (0x20000),
 VIF_BUFFTOOSMALL = (0x40000),
 WC_COMPOSITECHECK = (512),
 WC_DISCARDNS = (16),
 WC_SEPCHARS = (32),
 WC_DEFAULTCHAR = (64),
 HELP_COMMAND = (0x102),
 HELP_CONTENTS = (0x3),
 HELP___FILE__ = (0x1),
 HELP___FILE__POPUP = (0x8),
 HELP_FORCEFILE = (0x9),
 HELP_HELPONHELP = (0x4),
 HELP_INDEX = (0x3),
 HELP_KEY = (0x101),
 HELP_MULTIKEY = (0x201),
 HELP_PARTIALKEY = (0x105),
 HELP_QUIT = (0x2),
 HELP_SETCONTENTS = (0x5),
 HELP_SETINDEX = (0x5),
 HELP___FILE__MENU = (0xa),
 HELP_FINDER = (0xb),
 HELP_WM_HELP = (0xc),
 HELP_TCARD = (0x8000),
 HELP_TCARD_DATA = (0x10),
 HELP_TCARD_OTHER_CALLER = (0x11),
 CONNECT_UPDATE_PROFILE = (1),
 RESOURCETYPE_DISK = (1),
 RESOURCETYPE_PRINT = (2),
 RESOURCETYPE_ANY = (0),
 RESOURCE_CONNECTED = (1),
 RESOURCE_GLOBALNET = (2),
 RESOURCE_REMEMBERED = (3),
 RESOURCEUSAGE_CONNECTABLE = (1),
 RESOURCEUSAGE_CONTAINER = (2),
 WN_BAD_NETNAME = (0x43),
 WN_EXTENDED_ERROR = (0x4b8),
 WN_MORE_DATA = (0xea),
 WN_NO_NETWORK = (0x4c6),
 WN_SUCCESS = (0),
 WN_ACCESS_DENIED = (0x5),
 WN_BAD_PROVIDER = (0x4b4),
 WN_NOT_AUTHENTICATED = (0x4dc),
 UNIVERSAL_NAME_INFO_LEVEL = (1),
 REMOTE_NAME_INFO_LEVEL = (2),
 STILL_ACTIVE = (0x103),
 SP_SERIALCOMM = (0x1),
 BAUD_075 = (0x1),
 BAUD_110 = (0x2),
 BAUD_134_5 = (0x4),
 BAUD_150 = (0x8),
 BAUD_300 = (0x10),
 BAUD_600 = (0x20),
 BAUD_1200 = (0x40),
 BAUD_1800 = (0x80),
 BAUD_2400 = (0x100),
 BAUD_4800 = (0x200),
 BAUD_7200 = (0x400),
 BAUD_9600 = (0x800),
 BAUD_14400 = (0x1000),
 BAUD_19200 = (0x2000),
 BAUD_38400 = (0x4000),
 BAUD_56K = (0x8000),
 BAUD_57600 = (0x40000),
 BAUD_115200 = (0x20000),
 BAUD_128K = (0x10000),
 BAUD_USER = (0x10000000),
 PST_FAX = (0x21),
 PST_LAT = (0x101),
 PST_MODEM = (0x6),
 PST_NETWORK_BRIDGE = (0x100),
 PST_PARALLELPORT = (0x2),
 PST_RS232 = (0x1),
 PST_RS422 = (0x3),
 PST_RS423 = (0x4),
 PST_RS449 = (0x5),
 PST_SCANNER = (0x22),
 PST_TCPIP_TELNET = (0x102),
 PST_UNSPECIFIED = (0),
 PST_X25 = (0x103),
 PCF_16BITMODE = (0x200),
 PCF_DTRDSR = (0x1),
 PCF_INTTIMEOUTS = (0x80),
 PCF_PARITY_CHECK = (0x8),
 PCF_RLSD = (0x4),
 PCF_RTSCTS = (0x2),
 PCF_SETXCHAR = (0x20),
 PCF_SPECIALCHARS = (0x100),
 PCF_TOTALTIMEOUTS = (0x40),
 PCF_XONXOFF = (0x10),
 SP_BAUD = (0x2),
 SP_DATABITS = (0x4),
 SP_HANDSHAKING = (0x10),
 SP_PARITY = (0x1),
 SP_PARITY_CHECK = (0x20),
 SP_RLSD = (0x40),
 SP_STOPBITS = (0x8),
 DATABITS_5 = (1),
 DATABITS_6 = (2),
 DATABITS_7 = (4),
 DATABITS_8 = (8),
 DATABITS_16 = (16),
 DATABITS_16X = (32),
 STOPBITS_10 = (1),
 STOPBITS_15 = (2),
 STOPBITS_20 = (4),
 PARITY_NONE = (256),
 PARITY_ODD = (512),
 PARITY_EVEN = (1024),
 PARITY_MARK = (2048),
 PARITY_SPACE = (4096),
 COMMPROP_INITIALIZED = (0xe73cf52e),
 CBR_110 = (110),
 CBR_300 = (300),
 CBR_600 = (600),
 CBR_1200 = (1200),
 CBR_2400 = (2400),
 CBR_4800 = (4800),
 CBR_9600 = (9600),
 CBR_14400 = (14400),
 CBR_19200 = (19200),
 CBR_38400 = (38400),
 CBR_56000 = (56000),
 CBR_57600 = (57600),
 CBR_115200 = (115200),
 CBR_128000 = (128000),
 CBR_256000 = (256000),
 DTR_CONTROL_DISABLE = (0),
 DTR_CONTROL_ENABLE = (1),
 DTR_CONTROL_HANDSHAKE = (2),
 RTS_CONTROL_DISABLE = (0),
 RTS_CONTROL_ENABLE = (1),
 RTS_CONTROL_HANDSHAKE = (2),
 RTS_CONTROL_TOGGLE = (3),
 EVENPARITY = (2),
 MARKPARITY = (3),
 NOPARITY = (0),
 ODDPARITY = (1),
 SPACEPARITY = (4),
 ONESTOPBIT = (0),
 ONE5STOPBITS = (1),
 TWOSTOPBITS = (2),
 CREATE_PROCESS_DEBUG_EVENT = (3),
 CREATE_THREAD_DEBUG_EVENT = (2),
 EXCEPTION_DEBUG_EVENT = (1),
 EXIT_PROCESS_DEBUG_EVENT = (5),
 EXIT_THREAD_DEBUG_EVENT = (4),
 LOAD_DLL_DEBUG_EVENT = (6),
 OUTPUT_DEBUG_STRING_EVENT = (8),
 UNLOAD_DLL_DEBUG_EVENT = (7),
 RIP_EVENT = (9),
 PROCESS_HEAP_REGION = (1),
 PROCESS_HEAP_UNCOMMITTED_RANGE = (2),
 PROCESS_HEAP_ENTRY_BUSY = (4),
 PROCESS_HEAP_ENTRY_MOVEABLE = (16),
 PROCESS_HEAP_ENTRY_DDESHARE = (32),
 HINSTANCE_ERROR = (32),
 BACKUP_DATA = (1),
 BACKUP_EA_DATA = (2),
 BACKUP_SECURITY_DATA = (3),
 BACKUP_ALTERNATE_DATA = (4),
 BACKUP_LINK = (5),
 STREAM_MODIFIED_WHEN_READ = (1),
 STREAM_CONTAINS_SECURITY = (2),
 STARTF_USESHOWWINDOW = (1),
 STARTF_USEPOSITION = (4),
 STARTF_USESIZE = (2),
 STARTF_USECOUNTCHARS = (8),
 STARTF_USEFILLATTRIBUTE = (16),
 STARTF_RUNFULLSCREEN = (32),
 STARTF_FORCEONFEEDBACK = (64),
 STARTF_FORCEOFFFEEDBACK = (128),
 STARTF_USESTDHANDLES = (256),
 STARTF_USEHOTKEY = (512),
 VER_PLATFORM_WIN32s = (0),
 VER_PLATFORM_WIN32_WINDOWS = (1),
 VER_PLATFORM_WIN32_NT = (2),
 MAXPROPPAGES = (100),
 PSP_DEFAULT = (0),
 PSP_DLGINDIRECT = (1),
 PSP_HASHELP = (32),
 PSP_USECALLBACK = (128),
 PSP_USEHICON = (2),
 PSP_USEICONID = (4),
 PSP_USEREFPARENT = (64),
 PSP_USETITLE = (8),
 PSP_RTLREADING = (16),
 PSH_DEFAULT = (0),
 PSH_HASHELP = (512),
 PSH_MODELESS = (1024),
 PSH_NOAPPLYNOW = (128),
 PSH_PROPSHEETPAGE = (8),
 PSH_PROPTITLE = (1),
 PSH_USECALLBACK = (256),
 PSH_USEHICON = (2),
 PSH_USEICONID = (4),
 PSH_USEPSTARTPAGE = (64),
 PSH_WIZARD = (32),
 PSH_RTLREADING = (2048),
 PSCB_INITIALIZED = (1),
 PSCB_PRECREATE = (2),
 PSNRET_NOERROR = (0),
 PSNRET_INVALID_NOCHANGEPAGE = (2),
 PSBTN_APPLYNOW = (4),
 PSBTN_BACK = (0),
 PSBTN_CANCEL = (5),
 PSBTN_FINISH = (2),
 PSBTN_HELP = (6),
 PSBTN_NEXT = (1),
 PSBTN_OK = (3),
 PSWIZB_BACK = (1),
 PSWIZB_NEXT = (2),
 PSWIZB_FINISH = (4),
 PSWIZB_DISABLEDFINISH = (8),
 ID_PSREBOOTSYSTEM = (3),
 ID_PSRESTARTWINDOWS = (2),
 WIZ_BODYCX = (184),
 WIZ_BODYX = (92),
 WIZ_CXBMP = (80),
 WIZ_CXDLG = (276),
 WIZ_CYDLG = (140),
}

char* VS_FILE_INFO = cast(char*) ((16));

enum : DWORD 
{
 VS_VERSION_INFO = (1),
 VS_FF_DEBUG = (0x1),
 VS_FF_INFOINFERRED = (0x10),
 VS_FF_PATCHED = (0x4),
 VS_FF_PRERELEASE = (0x2),
 VS_FF_PRIVATEBUILD = (0x8),
 VS_FF_SPECIALBUILD = (0x20),
 VOS_UNKNOWN = (0),
 VOS_DOS = (0x10000),
 VOS_OS216 = (0x20000),
 VOS_OS232 = (0x30000),
 VOS_NT = (0x40000),
 VOS_DOS_WINDOWS16 = (0x10001),
 VOS_DOS_WINDOWS32 = (0x10004),
 VOS_OS216_PM16 = (0x20002),
 VOS_OS232_PM32 = (0x30003),
 VOS_NT_WINDOWS32 = (0x40004),
 VFT_UNKNOWN = (0),
 VFT_APP = (0x1),
 VFT_DLL = (0x2),
 VFT_DRV = (0x3),
 VFT_FONT = (0x4),
 VFT_VXD = (0x5),
 VFT_STATIC_LIB = (0x7),
 VFT2_UNKNOWN = (0),
 VFT2_DRV_PRINTER = (0x1),
 VFT2_DRV_KEYBOARD = (0x2),
 VFT2_DRV_LANGUAGE = (0x3),
 VFT2_DRV_DISPLAY = (0x4),
 VFT2_DRV_MOUSE = (0x5),
 VFT2_DRV_NETWORK = (0x6),
 VFT2_DRV_SYSTEM = (0x7),
 VFT2_DRV_INSTALLABLE = (0x8),
 VFT2_DRV_SOUND = (0x9),
 VFT2_FONT_RASTER = (0x1),
 VFT2_FONT_VECTOR = (0x2),
 VFT2_FONT_TRUETYPE = (0x3),
 PAN_ANY = (0),
 PAN_NO_FIT = (1),
 PAN_FAMILY_TEXT_DISPLAY = (2),
 PAN_FAMILY_SCRIPT = (3),
 PAN_FAMILY_DECORATIVE = (4),
 PAN_FAMILY_PICTORIAL = (5),
 PAN_SERIF_COVE = (2),
 PAN_SERIF_OBTUSE_COVE = (3),
 PAN_SERIF_SQUARE_COVE = (4),
 PAN_SERIF_OBTUSE_SQUARE_COVE = (5),
 PAN_SERIF_SQUARE = (6),
 PAN_SERIF_THIN = (7),
 PAN_SERIF_BONE = (8),
 PAN_SERIF_EXAGGERATED = (9),
 PAN_SERIF_TRIANGLE = (10),
 PAN_SERIF_NORMAL_SANS = (11),
 PAN_SERIF_OBTUSE_SANS = (12),
 PAN_SERIF_PERP_SANS = (13),
 PAN_SERIF_FLARED = (14),
 PAN_SERIF_ROUNDED = (15),
 PAN_WEIGHT_VERY_LIGHT = (2),
 PAN_WEIGHT_LIGHT = (3),
 PAN_WEIGHT_THIN = (4),
 PAN_WEIGHT_BOOK = (5),
 PAN_WEIGHT_MEDIUM = (6),
 PAN_WEIGHT_DEMI = (7),
 PAN_WEIGHT_BOLD = (8),
 PAN_WEIGHT_HEAVY = (9),
 PAN_WEIGHT_BLACK = (10),
 PAN_WEIGHT_NORD = (11),
 PAN_PROP_OLD_STYLE = (2),
 PAN_PROP_MODERN = (3),
 PAN_PROP_EVEN_WIDTH = (4),
 PAN_PROP_EXPANDED = (5),
 PAN_PROP_CONDENSED = (6),
 PAN_PROP_VERY_EXPANDED = (7),
 PAN_PROP_VERY_CONDENSED = (8),
 PAN_PROP_MONOSPACED = (9),
 PAN_CONTRAST_NONE = (2),
 PAN_CONTRAST_VERY_LOW = (3),
 PAN_CONTRAST_LOW = (4),
 PAN_CONTRAST_MEDIUM_LOW = (5),
 PAN_CONTRAST_MEDIUM = (6),
 PAN_CONTRAST_MEDIUM_HIGH = (7),
 PAN_CONTRAST_HIGH = (8),
 PAN_CONTRAST_VERY_HIGH = (9),
 PAN_STROKE_GRADUAL_DIAG = (2),
 PAN_STROKE_GRADUAL_TRAN = (3),
 PAN_STROKE_GRADUAL_VERT = (4),
 PAN_STROKE_GRADUAL_HORZ = (5),
 PAN_STROKE_RAPID_VERT = (6),
 PAN_STROKE_RAPID_HORZ = (7),
 PAN_STROKE_INSTANT_VERT = (8),
 PAN_STRAIGHT_ARMS_HORZ = (2),
 PAN_STRAIGHT_ARMS_WEDGE = (3),
 PAN_STRAIGHT_ARMS_VERT = (4),
 PAN_STRAIGHT_ARMS_SINGLE_SERIF = (5),
 PAN_STRAIGHT_ARMS_DOUBLE_SERIF = (6),
 PAN_BENT_ARMS_HORZ = (7),
 PAN_BENT_ARMS_VERT = (9),
 PAN_BENT_ARMS_WEDGE = (8),
 PAN_BENT_ARMS_SINGLE_SERIF = (10),
 PAN_BENT_ARMS_DOUBLE_SERIF = (11),
 PAN_LETT_NORMAL_CONTACT = (2),
 PAN_LETT_NORMAL_WEIGHTED = (3),
 PAN_LETT_NORMAL_BOXED = (4),
 PAN_LETT_NORMAL_FLATTENED = (5),
 PAN_LETT_NORMAL_ROUNDED = (6),
 PAN_LETT_NORMAL_OFF_CENTER = (7),
 PAN_LETT_NORMAL_SQUARE = (8),
 PAN_LETT_OBLIQUE_CONTACT = (9),
 PAN_LETT_OBLIQUE_WEIGHTED = (10),
 PAN_LETT_OBLIQUE_BOXED = (11),
 PAN_LETT_OBLIQUE_FLATTENED = (12),
 PAN_LETT_OBLIQUE_ROUNDED = (13),
 PAN_LETT_OBLIQUE_OFF_CENTER = (14),
 PAN_LETT_OBLIQUE_SQUARE = (15),
 PAN_MIDLINE_STANDARD_TRIMMED = (2),
 PAN_MIDLINE_STANDARD_POINTED = (3),
 PAN_MIDLINE_STANDARD_SERIFED = (4),
 PAN_MIDLINE_HIGH_TRIMMED = (5),
 PAN_MIDLINE_HIGH_POINTED = (6),
 PAN_MIDLINE_HIGH_SERIFED = (7),
 PAN_MIDLINE_CONSTANT_TRIMMED = (8),
 PAN_MIDLINE_CONSTANT_POINTED = (9),
 PAN_MIDLINE_CONSTANT_SERIFED = (10),
 PAN_MIDLINE_LOW_TRIMMED = (11),
 PAN_MIDLINE_LOW_POINTED = (12),
 PAN_MIDLINE_LOW_SERIFED = (13),
 PAN_XHEIGHT_CONSTANT_SMALL = (2),
 PAN_XHEIGHT_CONSTANT_STD = (3),
 PAN_XHEIGHT_CONSTANT_LARGE = (4),
 PAN_XHEIGHT_DUCKING_SMALL = (5),
 PAN_XHEIGHT_DUCKING_STD = (6),
 PAN_XHEIGHT_DUCKING_LARGE = (7),
 PC_EXPLICIT = (2),
 PC_NOCOLLAPSE = (4),
 PC_RESERVED = (1),
 BS_DIBPATTERN = (5),
 BS_DIBPATTERN8X8 = (8),
 BS_DIBPATTERNPT = (6),
 BS_HATCHED = (2),
 BS_HOLLOW = (1),
 BS_NULL = (1),
 BS_PATTERN = (3),
 BS_PATTERN8X8 = (7),
 BS_SOLID = (0),
 DM_ORIENTATION = (0x1),
 DM_PAPERSIZE = (0x2),
 DM_PAPERLENGTH = (0x4),
 DM_PAPERWIDTH = (0x8),
 DM_SCALE = (0x10),
 DM_COPIES = (0x100),
 DM_DEFAULTSOURCE = (0x200),
 DM_PRINTQUALITY = (0x400),
 DM_COLOR = (0x800),
 DM_DUPLEX = (0x1000),
 DM_YRESOLUTION = (0x2000),
 DM_TTOPTION = (0x4000),
 DM_COLLATE = (0x8000),
 DM_FORMNAME = (0x10000),
 DM_LOGPIXELS = (0x20000),
 DM_ICMMETHOD = (0x800000),
 DM_ICMINTENT = (0x1000000),
 DM_MEDIATYPE = (0x2000000),
 DM_DITHERTYPE = (0x4000000),
 DMORIENT_LANDSCAPE = (2),
 DMORIENT_PORTRAIT = (1),
 DMPAPER_LETTER = (1),
 DMPAPER_LEGAL = (5),
 DMPAPER_A4 = (9),
 DMPAPER_CSHEET = (24),
 DMPAPER_DSHEET = (25),
 DMPAPER_ESHEET = (26),
 DMPAPER_LETTERSMALL = (2),
 DMPAPER_TABLOID = (3),
 DMPAPER_LEDGER = (4),
 DMPAPER_STATEMENT = (6),
 DMPAPER_EXECUTIVE = (7),
 DMPAPER_A3 = (8),
 DMPAPER_A4SMALL = (10),
 DMPAPER_A5 = (11),
 DMPAPER_B4 = (12),
 DMPAPER_B5 = (13),
 DMPAPER_FOLIO = (14),
 DMPAPER_QUARTO = (15),
 DMPAPER_10X14 = (16),
 DMPAPER_11X17 = (17),
 DMPAPER_NOTE = (18),
 DMPAPER_ENV_9 = (19),
 DMPAPER_ENV_10 = (20),
 DMPAPER_ENV_11 = (21),
 DMPAPER_ENV_12 = (22),
 DMPAPER_ENV_14 = (23),
 DMPAPER_ENV_DL = (27),
 DMPAPER_ENV_C5 = (28),
 DMPAPER_ENV_C3 = (29),
 DMPAPER_ENV_C4 = (30),
 DMPAPER_ENV_C6 = (31),
 DMPAPER_ENV_C65 = (32),
 DMPAPER_ENV_B4 = (33),
 DMPAPER_ENV_B5 = (34),
 DMPAPER_ENV_B6 = (35),
 DMPAPER_ENV_ITALY = (36),
 DMPAPER_ENV_MONARCH = (37),
 DMPAPER_ENV_PERSONAL = (38),
 DMPAPER_FANFOLD_US = (39),
 DMPAPER_FANFOLD_STD_GERMAN = (40),
 DMPAPER_FANFOLD_LGL_GERMAN = (41),
 DMRES_HIGH = -((4)),
 DMRES_MEDIUM = -((3)),
 DMRES_LOW = -((2)),
 DMRES_DRAFT = -((1)),
 DMCOLOR_COLOR = (2),
 DMCOLOR_MONOCHROME = (1),
 DMDUP_SIMPLEX = (1),
 DMDUP_HORIZONTAL = (3),
 DMDUP_VERTICAL = (2),
 DMTT_BITMAP = (1),
 DMTT_DOWNLOAD = (2),
 DMTT_SUBDEV = (3),
 DMCOLLATE_TRUE = (1),
 DMCOLLATE_FALSE = (0),
 DM_GRAYSCALE = (1),
 DM_INTERLACED = (2),
 DMICMMETHOD_NONE = (1),
 DMICMMETHOD_SYSTEM = (2),
 DMICMMETHOD_DRIVER = (3),
 DMICMMETHOD_DEVICE = (4),
 DMICMMETHOD_USER = (256),
 DMICM_SATURATE = (1),
 DMICM_CONTRAST = (2),
 DMICM_COLORMETRIC = (3),
 DMICM_USER = (256),
 DMMEDIA_STANDARD = (1),
 DMMEDIA_GLOSSY = (3),
 DMMEDIA_TRANSPARENCY = (2),
 DMMEDIA_USER = (256),
 DMDITHER_NONE = (1),
 DMDITHER_COARSE = (2),
 DMDITHER_FINE = (3),
 DMDITHER_LINEART = (4),
 DMDITHER_GRAYSCALE = (10),
 DMDITHER_USER = (256),
 RDH_RECTANGLES = (1),
 TT_POLYGON_TYPE = (24),
 TT_PRIM_LINE = (1),
 TT_PRIM_QSPLINE = (2),
 GCPCLASS_ARABIC = (2),
 GCPCLASS_HEBREW = (2),
 GCPCLASS_LATIN = (1),
 GCPCLASS_LATINNUMBER = (5),
 GCPCLASS_LOCALNUMBER = (4),
 GCPCLASS_LATINNUMERICSEPARATOR = (7),
 GCPCLASS_LATINNUMERICTERMINATOR = (6),
 GCPCLASS_NEUTRAL = (3),
 GCPCLASS_NUMERICSEPARATOR = (8),
 GCPCLASS_PREBOUNDLTR = (128),
 GCPCLASS_PREBOUNDRTL = (64),
 GCPCLASS_POSTBOUNDLTR = (32),
 GCPCLASS_POSTBOUNDRTL = (16),
 GCPGLYPH_LINKBEFORE = (32768),
 GCPGLYPH_LINKAFTER = (16384),
 TT_AVAILABLE = (1),
 TT_ENABLED = (2),
 CA_NEGATIVE = (1),
 CA_LOG_FILTER = (2),
 ILLUMINANT_DEVICE_DEFAULT = (0),
 ILLUMINANT_A = (1),
 ILLUMINANT_B = (2),
 ILLUMINANT_C = (3),
 ILLUMINANT_D50 = (4),
 ILLUMINANT_D55 = (5),
 ILLUMINANT_D65 = (6),
 ILLUMINANT_D75 = (7),
 ILLUMINANT_F2 = (8),
 ILLUMINANT_TUNGSTEN = (1),
 ILLUMINANT_DAYLIGHT = (3),
 ILLUMINANT_FLUORESCENT = (8),
 ILLUMINANT_NTSC = (3),
 DI_APPBANDING = (1),
 EMR_HEADER = (1),
 ENHMETA_SIGNATURE = (1179469088),
 ENM_CHANGE = (1),
 ENM_CORRECTTEXT = (4194304),
 ENM_DROPFILES = (1048576),
 ENM_KEYEVENTS = (65536),
 ENM_MOUSEEVENTS = (131072),
 ENM_PROTECTED = (2097152),
 ENM_REQUESTRESIZE = (262144),
 ENM_SCROLL = (4),
 ENM_SELCHANGE = (524288),
 ENM_UPDATE = (2),
 ENM_NONE = (0),
 ES_DISABLENOSCROLL = (8192),
 ES_EX_NOCALLOLEINIT = (16777216),
 ES_NOIME = (524288),
 ES_SAVESEL = (32768),
 ES_SELFIME = (262144),
 ES_SUNKEN = (16384),
 ES_VERTICAL = (4194304),
 ES_SELECTIONBAR = (16777216),
 ECOOP_SET = (1),
 ECOOP_OR = (2),
 ECOOP_AND = (3),
 ECOOP_XOR = (4),
 ECO_AUTOWORDSELECTION = (1),
 ECO_AUTOVSCROLL = (64),
 ECO_AUTOHSCROLL = (128),
 ECO_NOHIDESEL = (256),
 ECO_READONLY = (2048),
 ECO_WANTRETURN = (4096),
 ECO_SAVESEL = (32768),
 ECO_SELECTIONBAR = (16777216),
 ECO_VERTICAL = (4194304),
 SCF_WORD = (2),
 SCF_SELECTION = (1),
 SF_TEXT = (1),
 SF_RTF = (2),
 SF_RTFNOOBJS = (3),
 SF_TEXTIZED = (4),
 SFF_SELECTION = (32768),
 SFF_PLAINRTF = (16384),
 WB_CLASSIFY = (3),
 WB_LEFTBREAK = (6),
 WB_PREVBREAK = (6),
 WB_MOVEWORDLEFT = (4),
 WB_MOVEWORDPREV = (4),
 WB_MOVEWORDRIGHT = (5),
 WB_MOVEWORDNEXT = (5),
 WB_RIGHTBREAK = (7),
 WB_NEXTBREAK = (7),
 PC_LEADING = (2),
 PC_FOLLOWING = (1),
 PC_DELIMITER = (4),
 PC_OVERFLOW = (3),
 WBF_WORDWRAP = (16),
 WBF_WORDBREAK = (32),
 WBF_OVERFLOW = (64),
 WBF_LEVEL1 = (128),
 WBF_LEVEL2 = (256),
 WBF_CUSTOM = (512),
 WBF_BREAKAFTER = (64),
 WBF_BREAKLINE = (32),
 WBF_ISWHITE = (16),
 CFM_BOLD = (1),
 CFM_COLOR = (1073741824),
 CFM_FACE = (536870912),
 CFM_ITALIC = (2),
 CFM_OFFSET = (268435456),
 CFM_PROTECTED = (16),
 CFM_SIZE = (0x80000000),
 CFM_STRIKEOUT = (8),
 CFM_UNDERLINE = (4),
 CFE_AUTOCOLOR = (1073741824),
 CFE_BOLD = (1),
 CFE_ITALIC = (2),
 CFE_STRIKEOUT = (8),
 CFE_UNDERLINE = (4),
 CFE_PROTECTED = (16),
 PFM_ALIGNMENT = (8),
 PFM_NUMBERING = (32),
 PFM_OFFSET = (4),
 PFM_OFFSETINDENT = (0x80000000),
 PFM_RIGHTINDENT = (2),
 PFM_STARTINDENT = (1),
 PFM_TABSTOPS = (16),
 PFN_BULLET = (1),
 PFA_LEFT = (1),
 PFA_RIGHT = (2),
 PFA_CENTER = (3),
 SEL_EMPTY = (0),
 SEL_TEXT = (1),
 SEL_OBJECT = (2),
 SEL_MULTICHAR = (4),
 SEL_MULTIOBJECT = (8),
}

const 
{
char* CF_RTF = ("Rich Text Format");
char* CF_RETEXTOBJ = ("RichEdit Text and Objects");
}

enum : DWORD 
{
 ODT_BUTTON = (4),
 ODT_COMBOBOX = (3),
 ODT_LISTBOX = (2),
 ODT_LISTVIEW = (102),
 ODT_MENU = (1),
 ODT_STATIC = (5),
 ODT_TAB = (101),
 ODT_HEADER = (100),
 ODA_DRAWENTIRE = (1),
 ODA_FOCUS = (4),
 ODA_SELECT = (2),
 ODS_CHECKED = (8),
 ODS_COMBOBOXEDIT = (4096),
 ODS_DEFAULT = (32),
 ODS_DISABLED = (4),
 ODS_FOCUS = (16),
 ODS_GRAYED = (2),
 ODS_SELECTED = (1),
}
const 
{
char* ANIMATE_CLASSW = ("SysAnimate32");
char* HOTKEY_CLASSW = ("msctls_hotkey32");
char* PROGRESS_CLASSW = ("msctls_progress32");
char* STATUSCLASSNAMEW = ("msctls_statusbar32");
char* TOOLBARCLASSNAMEW = ("ToolbarWindow32");
char* TOOLTIPS_CLASSW = ("tooltips_class32");
char* TRACKBAR_CLASSW = ("msctls_trackbar32");
char* UPDOWN_CLASSW = ("msctls_updown32");
char* WC_HEADERW = ("SysHeader32");
char* WC_LISTVIEWW = ("SysListView32");
char* WC_TABCONTROLW = ("SysTabControl32");
char* WC_TREEVIEWW = ("SysTreeView32");
}

enum : DWORD 
{
 CCS_ADJUSTABLE = (0x20),
 CCS_BOTTOM = (0x3),
 CCS_NODIVIDER = (0x40),
 CCS_NOMOVEY = (0x2),
 CCS_NOPARENTALIGN = (0x8),
 CCS_NORESIZE = (0x4),
 CCS_TOP = (0x1),
}

const 
{
char* ANIMATE_CLASSA = ("SysAnimate32");
char* HOTKEY_CLASSA = ("msctls_hotkey32");
char* PROGRESS_CLASSA = ("msctls_progress32");
char* STATUSCLASSNAMEA = ("msctls_statusbar32");
char* TOOLBARCLASSNAMEA = ("ToolbarWindow32");
char* TOOLTIPS_CLASSA = ("tooltips_class32");
char* TRACKBAR_CLASSA = ("msctls_trackbar32");
char* UPDOWN_CLASSA = ("msctls_updown32");
char* WC_HEADERA = ("SysHeader32");
char* WC_LISTVIEWA = ("SysListView32");
char* WC_TABCONTROLA = ("SysTabControl32");
char* WC_TREEVIEWA = ("SysTreeView32");
char* ANIMATE_CLASS = (ANIMATE_CLASSA);
char* HOTKEY_CLASS = (HOTKEY_CLASSA);
char* PROGRESS_CLASS = (PROGRESS_CLASSA);
char* STATUSCLASSNAME = (STATUSCLASSNAMEA);
char* TOOLBARCLASSNAME = (TOOLBARCLASSNAMEA);
char* TOOLTIPS_CLASS = (TOOLTIPS_CLASSA);
char* TRACKBAR_CLASS = (TRACKBAR_CLASSA);
char* UPDOWN_CLASS = (UPDOWN_CLASSA);
char* WC_HEADER = (WC_HEADERA);
char* WC_LISTVIEW = (WC_LISTVIEWA);
char* WC_TABCONTROL = (WC_TABCONTROLA);
char* WC_TREEVIEW = (WC_TREEVIEWA);
}

enum : DWORD 
{
 HDS_BUTTONS = (2),
 HDS_HIDDEN = (8),
 HDS_HORZ = (0),
 HDI_BITMAP = (16),
 HDI_FORMAT = (4),
 HDI_HEIGHT = (1),
 HDI_LPARAM = (8),
 HDI_TEXT = (2),
 HDI_WIDTH = (1),
 HDF_CENTER = (2),
 HDF_LEFT = (0),
 HDF_RIGHT = (1),
 HDF_RTLREADING = (4),
 HDF_BITMAP = (8192),
 HDF_OWNERDRAW = (32768),
 HDF_STRING = (16384),
 HDF_JUSTIFYMASK = (3),
 HHT_NOWHERE = (1),
 HHT_ONDIVIDER = (4),
 HHT_ONDIVOPEN = (8),
 HHT_ONHEADER = (2),
 HHT_TOLEFT = (2048),
 HHT_TORIGHT = (1024),
 HINST_COMMCTRL = -(1),
 IDB_STD_LARGE_COLOR = (1),
 IDB_STD_SMALL_COLOR = (0),
 IDB_VIEW_LARGE_COLOR = (5),
 IDB_VIEW_SMALL_COLOR = (4),
 STD_COPY = (1),
 STD_CUT = (0),
 STD_DELETE = (5),
 STD_FILENEW = (6),
 STD_FILEOPEN = (7),
 STD_FILESAVE = (8),
 STD_FIND = (12),
 STD_HELP = (11),
 STD_PASTE = (2),
 STD_PRINT = (14),
 STD_PRINTPRE = (9),
 STD_PROPERTIES = (10),
 STD_REDOW = (4),
 STD_REPLACE = (13),
 STD_UNDO = (3),
 VIEW_LARGEICONS = (0),
 VIEW_SMALLICONS = (1),
 VIEW_LIST = (2),
 VIEW_DETAILS = (3),
 VIEW_SORTNAME = (4),
 VIEW_SORTSIZE = (5),
 VIEW_SORTDATE = (6),
 VIEW_SORTTYPE = (7),
 TBSTYLE_ALTDRAG = (1024),
 TBSTYLE_TOOLTIPS = (256),
 TBSTYLE_WRAPABLE = (512),
 TBSTYLE_BUTTON = (0),
 TBSTYLE_CHECK = (2),
 TBSTYLE_CHECKGROUP = (6),
 TBSTYLE_GROUP = (4),
 TBSTYLE_SEP = (1),
 TBSTATE_CHECKED = (1),
 TBSTATE_ENABLED = (4),
 TBSTATE_HIDDEN = (8),
 TBSTATE_INDETERMINATE = (16),
 TBSTATE_PRESSED = (2),
 TBSTATE_WRAP = (32),
 TTS_ALWAYSTIP = (1),
 TTS_NOPREFIX = (2),
 TTF_IDISHWND = (1),
 TTF_CENTERTIP = (2),
 TTF_RTLREADING = (4),
 TTF_SUBCLASS = (16),
 TTDT_AUTOMATIC = (0),
 TTDT_AUTOPOP = (2),
 TTDT_INITIAL = (3),
 TTDT_RESHOW = (1),
 SBARS_SIZEGRIP = (256),
 DL_MOVECURSOR = (3),
 DL_COPYCURSOR = (2),
 DL_STOPCURSOR = (1),
 UDS_ALIGNLEFT = (8),
 UDS_ALIGNRIGHT = (4),
 UDS_ARROWKEYS = (32),
 UDS_AUTOBUDDY = (16),
 UDS_HORZ = (64),
 UDS_NOTHOUSANDS = (128),
 UDS_SETBUDDYINT = (2),
 UDS_WRAP = (1),
 UD_MAXVAL = (32767),
 UD_MINVAL = -((32767)),
 HOTKEYF_ALT = (4),
 HOTKEYF_CONTROL = (2),
 HOTKEYF_EXT = (8),
 HOTKEYF_SHIFT = (1),
 HKCOMB_A = (8),
 HKCOMB_C = (4),
 HKCOMB_CA = (64),
 HKCOMB_NONE = (1),
 HKCOMB_S = (2),
 HKCOMB_SA = (32),
 HKCOMB_SC = (16),
 HKCOMB_SCA = (128),
 TBS_HORZ = (0),
 TBS_VERT = (2),
 TBS_AUTOTICKS = (1),
 TBS_NOTICKS = (16),
 TBS_TOP = (4),
 TBS_BOTTOM = (0),
 TBS_LEFT = (4),
 TBS_RIGHT = (0),
 TBS_BOTH = (8),
 TBS_ENABLESELRANGE = (32),
 TBS_FIXEDLENGTH = (64),
 TBS_NOTHUMB = (128),
 TB_BOTTOM = (7),
 TB_ENDTRACK = (8),
 TB_LINEDOWN = (1),
 TB_LINEUP = (0),
 TB_PAGEDOWN = (3),
 TB_PAGEUP = (2),
 TB_THUMBPOSITION = (4),
 TB_THUMBTRACK = (5),
 TB_TOP = (6),
 LVS_ALIGNLEFT = (2048),
 LVS_ALIGNTOP = (0),
 LVS_AUTOARRANGE = (256),
 LVS_EDITLABELS = (512),
 LVS_ICON = (0),
 LVS_LIST = (3),
 LVS_NOCOLUMNHEADER = (16384),
 LVS_NOLABELWRAP = (128),
 LVS_NOSCROLL = (8192),
 LVS_NOSORTHEADER = (32768),
 LVS_OWNERDRAWFIXED = (1024),
 LVS_REPORT = (1),
 LVS_SHAREIMAGELISTS = (64),
 LVS_SHOWSELALWAYS = (8),
 LVS_SINGLESEL = (4),
 LVS_SMALLICON = (2),
 LVS_SORTASCENDING = (16),
 LVS_SORTDESCENDING = (32),
 LVS_TYPESTYLEMASK = (64512),
 LVSIL_NORMAL = (0),
 LVSIL_SMALL = (1),
 LVSIL_STATE = (2),
 LVIS_CUT = (4),
 LVIS_DROPHILITED = (8),
 LVIS_FOCUSED = (1),
 LVIS_SELECTED = (2),
 LVIS_OVERLAYMASK = (3840),
 LVIS_STATEIMAGEMASK = (61440),
}

const 
{
 LPWSTR LPSTR_TEXTCALLBACKW = cast(LPWSTR)(-(1));
 LPSTR  LPSTR_TEXTCALLBACKA = cast(LPSTR)(-(1));
 version(Win32SansUnicode){
  alias LPSTR_TEXTCALLBACKA LPSTR_TEXTCALLBACK;
 }
 else{
  alias LPSTR_TEXTCALLBACKW LPSTR_TEXTCALLBACK;
 }
}

enum : DWORD 
{
 LVIF_TEXT = (1),
 LVIF_IMAGE = (2),
 LVIF_PARAM = (4),
 LVIF_STATE = (8),
 LVIF_DI_SETITEM = (4096),
 LVNI_ABOVE = (256),
 LVNI_ALL = (0),
 LVNI_BELOW = (512),
 LVNI_TOLEFT = (1024),
 LVNI_TORIGHT = (2048),
 LVNI_CUT = (4),
 LVNI_DROPHILITED = (8),
 LVNI_FOCUSED = (1),
 LVNI_SELECTED = (2),
 LVFI_PARAM = (1),
 LVFI_PARTIAL = (8),
 LVFI_STRING = (2),
 LVFI_WRAP = (32),
 LVFI_NEARESTXY = (64),
 LVHT_ABOVE = (8),
 LVHT_BELOW = (16),
 LVHT_NOWHERE = (1),
 LVHT_ONITEMICON = (2),
 LVHT_ONITEMLABEL = (4),
 LVHT_ONITEMSTATEICON = (8),
 LVHT_TOLEFT = (64),
 LVHT_TORIGHT = (32),
 LVCF_FMT = (1),
 LVCF_SUBITEM = (8),
 LVCF_TEXT = (4),
 LVCF_WIDTH = (2),
 LVCFMT_CENTER = (2),
 LVCFMT_LEFT = (0),
 LVCFMT_RIGHT = (1),
 LVIR_BOUNDS = (0),
 LVIR_ICON = (1),
 LVIR_LABEL = (2),
 LVIR_SELECTBOUNDS = (3),
 LVA_ALIGNLEFT = (1),
 LVA_ALIGNTOP = (2),
 LVA_DEFAULT = (0),
 LVA_SNAPTOGRID = (5),
 LVSCW_AUTOSIZE = -((1)),
 LVSCW_AUTOSIZE_USEHEADER = -((2)),
 TVS_DISABLEDRAGDROP = (16),
 TVS_EDITLABELS = (8),
 TVS_HASBUTTONS = (1),
 TVS_HASLINES = (2),
 TVS_LINESATROOT = (4),
 TVS_SHOWSELALWAYS = (32),
 TVIS_BOLD = (16),
 TVIS_CUT = (4),
 TVIS_DROPHILITED = (8),
 TVIS_EXPANDED = (32),
 TVIS_EXPANDEDONCE = (64),
 TVIS_FOCUSED = (1),
 TVIS_OVERLAYMASK = (3840),
 TVIS_SELECTED = (2),
 TVIS_STATEIMAGEMASK = (61440),
 TVIS_USERMASK = (61440),
 TVIF_CHILDREN = (64),
 TVIF_HANDLE = (16),
 TVIF_IMAGE = (2),
 TVIF_PARAM = (4),
 TVIF_SELECTEDIMAGE = (32),
 TVIF_STATE = (8),
 TVIF_TEXT = (1),
 I_CHILDRENCALLBACK = -((1)),
 I_IMAGECALLBACK = -((1)),
}

struct TREEITEM
{
}

alias TREEITEM* HTREEITEM;
alias TREEITEM TTREEITEM;
alias TREEITEM* PTREEITEM;

enum : DWORD 
{
 TVI_ROOT = (0xFFFF0000),
 TVI_FIRST = (0xFFFF0001),
 TVI_LAST = (0xFFFF0002),
 TVI_SORT = (0xFFFF0003),
 TVHT_ABOVE = (256),
 TVHT_BELOW = (512),
 TVHT_NOWHERE = (1),
 TVHT_ONITEM = (70),
 TVHT_ONITEMBUTTON = (16),
 TVHT_ONITEMICON = (2),
 TVHT_ONITEMINDENT = (8),
 TVHT_ONITEMLABEL = (4),
 TVHT_ONITEMRIGHT = (32),
 TVHT_ONITEMSTATEICON = (64),
 TVHT_TOLEFT = (2048),
 TVHT_TORIGHT = (1024),
 TVE_COLLAPSE = (1),
 TVE_COLLAPSERESET = (32768),
 TVE_EXPAND = (2),
 TVE_TOGGLE = (3),
 TVSIL_NORMAL = (0),
 TVSIL_STATE = (2),
 TVGN_CARET = (9),
 TVGN_CHILD = (4),
 TVGN_DROPHILITE = (8),
 TVGN_FIRSTVISIBLE = (5),
 TVGN_NEXT = (1),
 TVGN_NEXTVISIBLE = (6),
 TVGN_PARENT = (3),
 TVGN_PREVIOUS = (2),
 TVGN_PREVIOUSVISIBLE = (7),
 TVGN_ROOT = (0),
 TVC_BYKEYBOARD = (2),
 TVC_BYMOUSE = (1),
 TVC_UNKNOWN = (0),
 TCS_BUTTONS = (256),
 TCS_FIXEDWIDTH = (1024),
 TCS_FOCUSNEVER = (32768),
 TCS_FOCUSONBUTTONDOWN = (4096),
 TCS_FORCEICONLEFT = (16),
 TCS_FORCELABELLEFT = (32),
 TCS_MULTILINE = (512),
 TCS_OWNERDRAWFIXED = (8192),
 TCS_RAGGEDRIGHT = (2048),
 TCS_RIGHTJUSTIFY = (0),
 TCS_SINGLELINE = (0),
 TCS_TABS = (0),
 TCS_TOOLTIPS = (16384),
 TCIF_TEXT = (1),
 TCIF_IMAGE = (2),
 TCIF_PARAM = (8),
 TCIF_RTLREADING = (4),
 TCHT_NOWHERE = (1),
 TCHT_ONITEM = (6),
 TCHT_ONITEMICON = (2),
 TCHT_ONITEMLABEL = (4),
 ACS_AUTOPLAY = (4),
 ACS_CENTER = (1),
 ACS_TRANSPARENT = (2),
 DIALOPTION_BILLING = (64),
 DIALOPTION_QUIET = (128),
 DIALOPTION_DIALTONE = (256),
 MDMVOLFLAG_LOW = (1),
 MDMVOLFLAG_MEDIUM = (2),
 MDMVOLFLAG_HIGH = (4),
 MDMVOL_LOW = (0),
 MDMVOL_MEDIUM = (1),
 MDMVOL_HIGH = (2),
 MDMSPKRFLAG_OFF = (1),
 MDMSPKRFLAG_DIAL = (2),
 MDMSPKRFLAG_ON = (4),
 MDMSPKRFLAG_CALLSETUP = (8),
 MDMSPKR_OFF = (0),
 MDMSPKR_DIAL = (1),
 MDMSPKR_ON = (2),
 MDMSPKR_CALLSETUP = (3),
 MDM_BLIND_DIAL = (512),
 MDM_CCITT_OVERRIDE = (64),
 MDM_CELLULAR = (8),
 MDM_COMPRESSION = (1),
 MDM_ERROR_CONTROL = (2),
 MDM_FLOWCONTROL_HARD = (16),
 MDM_FLOWCONTROL_SOFT = (32),
 MDM_FORCED_EC = (4),
 MDM_SPEED_ADJUST = (128),
 MDM_TONE_DIAL = (256),
 MDM_V23_OVERRIDE = (1024),
 LANG_BULGARIAN = (2),
 LANG_CHINESE = (4),
 LANG_CROATIAN = (26),
 LANG_CZECH = (5),
 LANG_DANISH = (6),
 LANG_DUTCH = (19),
 LANG_ENGLISH = (9),
 LANG_FINNISH = (11),
 LANG_FRENCH = (12),
 LANG_GERMAN = (7),
 LANG_GREEK = (8),
 LANG_HUNGARIAN = (14),
 LANG_ICELANDIC = (15),
 LANG_ITALIAN = (16),
 LANG_JAPANESE = (17),
 LANG_KOREAN = (18),
 LANG_NEUTRAL = (0),
 LANG_NORWEGIAN = (20),
 LANG_POLISH = (21),
 LANG_PORTUGUESE = (22),
 LANG_ROMANIAN = (24),
 LANG_RUSSIAN = (25),
 LANG_SLOVAK = (27),
 LANG_SLOVENIAN = (36),
 LANG_SPANISH = (10),
 LANG_SWEDISH = (29),
 LANG_TURKISH = (31),
 SUBLANG_CHINESE_SIMPLIFIED = (2),
 SUBLANG_CHINESE_TRADITIONAL = (1),
 SUBLANG_CHINESE_HONGKONG = (3),
 SUBLANG_CHINESE_SINGAPORE = (4),
 SUBLANG_DEFAULT = (1),
 SUBLANG_DUTCH = (1),
 SUBLANG_DUTCH_BELGIAN = (2),
 SUBLANG_ENGLISH_AUS = (3),
 SUBLANG_ENGLISH_CAN = (4),
 SUBLANG_ENGLISH_EIRE = (6),
 SUBLANG_ENGLISH_NZ = (5),
 SUBLANG_ENGLISH_UK = (2),
 SUBLANG_ENGLISH_US = (1),
 SUBLANG_FRENCH = (1),
 SUBLANG_FRENCH_BELGIAN = (2),
 SUBLANG_FRENCH_CANADIAN = (3),
 SUBLANG_FRENCH_SWISS = (4),
 SUBLANG_GERMAN = (1),
 SUBLANG_GERMAN_AUSTRIAN = (3),
 SUBLANG_GERMAN_SWISS = (2),
 SUBLANG_ITALIAN = (1),
 SUBLANG_ITALIAN_SWISS = (2),
 SUBLANG_NEUTRAL = (0),
 SUBLANG_NORWEGIAN_BOKMAL = (1),
 SUBLANG_NORWEGIAN_NYNORSK = (2),
 SUBLANG_PORTUGUESE = (2),
 SUBLANG_PORTUGUESE_BRAZILIAN = (1),
 SUBLANG_SPANISH = (1),
 SUBLANG_SPANISH_MEXICAN = (2),
 SUBLANG_SPANISH_MODERN = (3),
 SUBLANG_SYS_DEFAULT = (2),
 NLS_VALID_LOCALE_MASK = (1048575),
 SORT_DEFAULT = (0),
 SORT_JAPANESE_XJIS = (0),
 SORT_JAPANESE_UNICODE = (1),
 SORT_CHINESE_BIG5 = (0),
 SORT_CHINESE_UNICODE = (1),
 SORT_KOREAN_KSC = (0),
 SORT_KOREAN_UNICODE = (1),
 PROCESSOR_INTEL_386 = (386),
 PROCESSOR_INTEL_486 = (486),
 PROCESSOR_INTEL_PENTIUM = (586),
 PROCESSOR_MIPS_R4000 = (4000),
 PROCESSOR_ALPHA_21064 = (21064),
 COMPRESSION_FORMAT_NONE = (0),
 COMPRESSION_FORMAT_DEFAULT = (1),
 COMPRESSION_FORMAT_LZNT1 = (2),
 TAPE_DRIVE_COMPRESSION = (131072),
 TAPE_DRIVE_ECC = (65536),
 TAPE_DRIVE_ERASE_BOP_ONLY = (64),
 TAPE_DRIVE_ERASE_LONG = (32),
 TAPE_DRIVE_ERASE_IMMEDIATE = (128),
 TAPE_DRIVE_ERASE_SHORT = (16),
 TAPE_DRIVE_FIXED = (1),
 TAPE_DRIVE_FIXED_BLOCK = (1024),
 TAPE_DRIVE_INITIATOR = (4),
 TAPE_DRIVE_PADDING = (262144),
 TAPE_DRIVE_GET_ABSOLUTE_BLK = (1048576),
 TAPE_DRIVE_GET_LOGICAL_BLK = (2097152),
 TAPE_DRIVE_REPORT_SMKS = (524288),
 TAPE_DRIVE_SELECT = (2),
 TAPE_DRIVE_SET_EOT_WZ_SIZE = (4194304),
 TAPE_DRIVE_TAPE_CAPACITY = (256),
 TAPE_DRIVE_TAPE_REMAINING = (512),
 TAPE_DRIVE_VARIABLE_BLOCK = (2048),
 TAPE_DRIVE_WRITE_PROTECT = (4096),
 TAPE_DRIVE_ABS_BLK_IMMED = -((2147475456)),
 TAPE_DRIVE_ABSOLUTE_BLK = -((2147479552)),
 TAPE_DRIVE_END_OF_DATA = -((2147418112)),
 TAPE_DRIVE_FILEMARKS = -((2147221504)),
 TAPE_DRIVE_LOAD_UNLOAD = -((2147483647)),
 TAPE_DRIVE_LOAD_UNLD_IMMED = -((2147483616)),
 TAPE_DRIVE_LOCK_UNLOCK = -((2147483644)),
 TAPE_DRIVE_LOCK_UNLK_IMMED = -((2147483520)),
 TAPE_DRIVE_LOG_BLK_IMMED = -((2147450880)),
 TAPE_DRIVE_LOGICAL_BLK = -((2147467264)),
 TAPE_DRIVE_RELATIVE_BLKS = -((2147352576)),
 TAPE_DRIVE_REVERSE_POSITION = -((2143289344)),
 TAPE_DRIVE_REWIND_IMMEDIATE = -((2147483640)),
 TAPE_DRIVE_SEQUENTIAL_FMKS = -((2146959360)),
 TAPE_DRIVE_SEQUENTIAL_SMKS = -((2145386496)),
 TAPE_DRIVE_SET_BLOCK_SIZE = -((2147483632)),
 TAPE_DRIVE_SET_COMPRESSION = -((2147483136)),
 TAPE_DRIVE_SET_ECC = -((2147483392)),
 TAPE_DRIVE_SET_PADDING = -((2147482624)),
 TAPE_DRIVE_SET_REPORT_SMKS = -((2147481600)),
 TAPE_DRIVE_SETMARKS = -((2146435072)),
 TAPE_DRIVE_SPACE_IMMEDIATE = -((2139095040)),
 TAPE_DRIVE_TENSION = -((2147483646)),
 TAPE_DRIVE_TENSION_IMMED = -((2147483584)),
 TAPE_DRIVE_WRITE_FILEMARKS = -((2113929216)),
 TAPE_DRIVE_WRITE_LONG_FMKS = -((2013265920)),
 TAPE_DRIVE_WRITE_MARK_IMMED = -((1879048192)),
 TAPE_DRIVE_WRITE_SETMARKS = -((2130706432)),
 TAPE_DRIVE_WRITE_SHORT_FMKS = -((2080374784)),
 STANDARD_RIGHTS_REQUIRED = (0xf0000),
 STANDARD_RIGHTS_WRITE = (0x20000),
 STANDARD_RIGHTS_READ = (0x20000),
 STANDARD_RIGHTS_EXECUTE = (0x20000),
 STANDARD_RIGHTS_ALL = (0x1f0000),
 SPECIFIC_RIGHTS_ALL = (0xffff),
 MAXIMUM_ALLOWED = (0x2000000),
 GENERIC_ALL = (0x10000000),
 SECURITY_NULL_RID = (0),
 SECURITY_WORLD_RID = (0),
 SECURITY_LOCAL_RID = (0),
 SECURITY_CREATOR_OWNER_RID = (0),
 SECURITY_CREATOR_GROUP_RID = (0x1),
 SECURITY_DIALUP_RID = (0x1),
 SECURITY_NETWORK_RID = (0x2),
 SECURITY_BATCH_RID = (0x3),
 SECURITY_INTERACTIVE_RID = (0x4),
 SECURITY_LOGON_IDS_RID = (0x5),
 SECURITY_LOGON_IDS_RID_COUNT = (0x3),
 SECURITY_SERVICE_RID = (0x6),
 SECURITY_LOCAL_SYSTEM_RID = (0x12),
 SECURITY_BUILTIN_DOMAIN_RID = (0x20),
 DOMAIN_USER_RID_ADMIN = (0x1f4),
 DOMAIN_USER_RID_GUEST = (0x1f5),
 DOMAIN_GROUP_RID_ADMINS = (0x200),
 DOMAIN_GROUP_RID_USERS = (0x201),
 DOMAIN_ALIAS_RID_ADMINS = (0x220),
 DOMAIN_ALIAS_RID_USERS = (0x221),
 DOMAIN_ALIAS_RID_GUESTS = (0x222),
 DOMAIN_ALIAS_RID_POWER_USERS = (0x223),
 DOMAIN_ALIAS_RID_ACCOUNT_OPS = (0x224),
 DOMAIN_ALIAS_RID_SYSTEM_OPS = (0x225),
 DOMAIN_ALIAS_RID_PRINT_OPS = (0x226),
 DOMAIN_ALIAS_RID_BACKUP_OPS = (0x227),
 DOMAIN_ALIAS_RID_REPLICATOR = (0x228),
 SE_GROUP_MANDATORY = (0x1),
 SE_GROUP_ENABLED_BY_DEFAULT = (0x2),
 SE_GROUP_ENABLED = (0x4),
 SE_GROUP_OWNER = (0x8),
 SE_GROUP_LOGON_ID = (0xc0000000),
 ACL_REVISION = (2),
 ACCESS_ALLOWED_ACE_TYPE = (0x0),
 ACCESS_DENIED_ACE_TYPE = (0x1),
 SYSTEM_AUDIT_ACE_TYPE = (0x2),
 SYSTEM_ALARM_ACE_TYPE = (0x3),
 OBJECT_INHERIT_ACE = (0x1),
 CONTAINER_INHERIT_ACE = (0x2),
 NO_PROPAGATE_INHERIT_ACE = (0x4),
 INHERIT_ONLY_ACE = (0x8),
 SUCCESSFUL_ACCESS_ACE_FLAG = (0x40),
 FAILED_ACCESS_ACE_FLAG = (0x80),
 SECURITY_DESCRIPTOR_MIN_LENGTH = (20),
 SE_OWNER_DEFAULTED = (1),
 SE_GROUP_DEFAULTED = (2),
 SE_DACL_PRESENT = (4),
 SE_DACL_DEFAULTED = (8),
 SE_SACL_PRESENT = (16),
 SE_SACL_DEFAULTED = (32),
 SE_SELF_RELATIVE = (32768),
 SE_PRIVILEGE_ENABLED_BY_DEFAULT = (0x1),
 SE_PRIVILEGE_ENABLED = (0x2),
 SE_PRIVILEGE_USED_FOR_ACCESS = (0x80000000),
 PRIVILEGE_SET_ALL_NECESSARY = (0x1),
 OFN_ALLOWMULTISELECT = (0x200),
 OFN_CREATEPROMPT = (0x2000),
 OFN_ENABLEHOOK = (0x20),
 OFN_ENABLETEMPLATE = (0x40),
 OFN_ENABLETEMPLATEHANDLE = (0x80),
 OFN_EXPLORER = (0x80000),
 OFN_EXTENSIONDIFFERENT = (0x400),
 OFN_FILEMUSTEXIST = (0x1000),
 OFN_HIDEREADONLY = (0x4),
 OFN_LONGNAMES = (0x200000),
 OFN_NOCHANGEDIR = (0x8),
 OFN_NODEREFERENCELINKS = (0x100000),
 OFN_NOLONGNAMES = (0x40000),
 OFN_NONETWORKBUTTON = (0x20000),
 OFN_NOREADONLYRETURN = (0x8000),
 OFN_NOTESTFILECREATE = (0x10000),
 OFN_NOVALIDATE = (0x100),
 OFN_OVERWRITEPROMPT = (0x2),
 OFN_PATHMUSTEXIST = (0x800),
 OFN_READONLY = (0x1),
 OFN_SHAREAWARE = (0x4000),
 OFN_SHOWHELP = (0x10),
 OFN_SHAREFALLTHROUGH = (0x2),
 OFN_SHARENOWARN = (0x1),
 OFN_SHAREWARN = (0),
 CDN_INITDONE = (0xfffffda7),
 CDN_SELCHANGE = (0xfffffda6),
 CDN_FOLDERCHANGE = (0xfffffda5),
 CDN_SHAREVIOLATION = (0xfffffda4),
 CDN_HELP = (0xfffffda3),
 CDN_FILEOK = (0xfffffda2),
 CDN_TYPECHANGE = (0xfffffda1),
 CDM_GETFILEPATH = (0x465),
 CDM_GETFOLDERIDLIST = (0x467),
 CDM_GETFOLDERPATH = (0x466),
 CDM_GETSPEC = (0x464),
 CDM_HIDECONTROL = (0x469),
 CDM_SETCONTROLTEXT = (0x468),
 CDM_SETDEFEXT = (0x46a),
 CC_ENABLEHOOK = (0x10),
 CC_ENABLETEMPLATE = (0x20),
 CC_ENABLETEMPLATEHANDLE = (0x40),
 CC_FULLOPEN = (0x2),
 CC_PREVENTFULLOPEN = (0x4),
 CC_RGBINIT = (0x1),
 CC_SHOWHELP = (0x8),
 CC_SOLIDCOLOR = (0x80),
 FR_DIALOGTERM = (0x40),
 FR_DOWN = (0x1),
 FR_ENABLEHOOK = (0x100),
 FR_ENABLETEMPLATE = (0x200),
 FR_ENABLETEMPLATEHANDLE = (0x2000),
 FR_FINDNEXT = (0x8),
 FR_HIDEUPDOWN = (0x4000),
 FR_HIDEMATCHCASE = (0x8000),
 FR_HIDEWHOLEWORD = (0x10000),
 FR_MATCHCASE = (0x4),
 FR_NOMATCHCASE = (0x800),
 FR_NOUPDOWN = (0x400),
 FR_NOWHOLEWORD = (0x1000),
 FR_REPLACE = (0x10),
 FR_REPLACEALL = (0x20),
 FR_SHOWHELP = (0x80),
 FR_WHOLEWORD = (0x2),
 CF_APPLY = (0x200),
 CF_ANSIONLY = (0x400),
 CF_BOTH = (0x3),
 CF_TTONLY = (0x40000),
 CF_EFFECTS = (0x100),
 CF_ENABLEHOOK = (0x8),
 CF_ENABLETEMPLATE = (0x10),
 CF_ENABLETEMPLATEHANDLE = (0x20),
 CF_FIXEDPITCHONLY = (0x4000),
 CF_FORCEFONTEXIST = (0x10000),
 CF_INITTOLOGFONTSTRUCT = (0x40),
 CF_LIMITSIZE = (0x2000),
 CF_NOOEMFONTS = (0x800),
 CF_NOFACESEL = (0x80000),
 CF_NOSCRIPTSEL = (0x800000),
 CF_NOSTYLESEL = (0x100000),
 CF_NOSIZESEL = (0x200000),
 CF_NOSIMULATIONS = (0x1000),
 CF_NOVECTORFONTS = (0x800),
 CF_NOVERTFONTS = (0x1000000),
 CF_PRINTERFONTS = (0x2),
 CF_SCALABLEONLY = (0x20000),
 CF_SCREENFONTS = (0x1),
 CF_SCRIPTSONLY = (0x400),
 CF_SELECTSCRIPT = (0x400000),
 CF_SHOWHELP = (0x4),
 CF_USESTYLE = (0x80),
 CF_WYSIWYG = (0x8000),
 BOLD_FONTTYPE = (0x100),
 ITALIC_FONTTYPE = (0x200),
 PRINTER_FONTTYPE = (0x4000),
 REGULAR_FONTTYPE = (0x400),
 SCREEN_FONTTYPE = (0x2000),
 SIMULATED_FONTTYPE = (0x8000),
}

const 
{
char* COLOROKSTRINGW = ("commdlg_ColorOK");
char* FILEOKSTRINGW = ("commdlg_FileNameOK");
char* FINDMSGSTRINGW = ("commdlg_FindReplace");
char* HELPMSGSTRINGW = ("commdlg_help");
char* LBSELCHSTRINGW = ("commdlg_LBSelChangedNotify");
char* SETRGBSTRINGW = ("commdlg_SetRGBColor");
char* SHAREVISTRINGW = ("commdlg_ShareViolation");
char* COLOROKSTRINGA = ("commdlg_ColorOK");
char* FILEOKSTRINGA = ("commdlg_FileNameOK");
char* FINDMSGSTRINGA = ("commdlg_FindReplace");
char* HELPMSGSTRINGA = ("commdlg_help");
char* LBSELCHSTRINGA = ("commdlg_LBSelChangedNotify");
char* SETRGBSTRINGA = ("commdlg_SetRGBColor");
char* SHAREVISTRINGA = ("commdlg_ShareViolation");
char* COLOROKSTRING = (COLOROKSTRINGA);
char* FILEOKSTRING = (FILEOKSTRINGA);
char* FINDMSGSTRING = (FINDMSGSTRINGA);
char* HELPMSGSTRING = (HELPMSGSTRINGA);
char* LBSELCHSTRING = (LBSELCHSTRINGA);
char* SETRGBSTRING = (SETRGBSTRINGA);
char* SHAREVISTRING = (SHAREVISTRINGA);
}

const 
{
HWND HWND_DESKTOP = cast(HWND) 0;
HWND HWND_BOTTOM = cast(HWND) 1;
HWND HWND_NOTOPMOST = cast(HWND) -2;
HWND HWND_TOP = cast(HWND) 0;
HWND HWND_TOPMOST = cast(HWND) -1;
HWND HWND_BROADCAST = cast(HWND) 0xFFFF;
}

enum : DWORD 
{
 CD_LBSELCHANGE = (0),
 CD_LBSELADD = (2),
 CD_LBSELSUB = (1),
 CD_LBSELNOITEMS = -((1)),
 DN_DEFAULTPRN = (1),
 PD_ALLPAGES = (0),
 PD_COLLATE = (16),
 PD_DISABLEPRINTTOFILE = (524288),
 PD_ENABLEPRINTHOOK = (4096),
 PD_ENABLEPRINTTEMPLATE = (16384),
 PD_ENABLEPRINTTEMPLATEHANDLE = (65536),
 PD_ENABLESETUPHOOK = (8192),
 PD_ENABLESETUPTEMPLATE = (32768),
 PD_ENABLESETUPTEMPLATEHANDLE = (131072),
 PD_HIDEPRINTTOFILE = (1048576),
 PD_NOPAGENUMS = (8),
 PD_NOSELECTION = (4),
 PD_NOWARNING = (128),
 PD_PAGENUMS = (2),
 PD_PRINTSETUP = (64),
 PD_PRINTTOFILE = (32),
 PD_RETURNDC = (256),
 PD_RETURNDEFAULT = (1024),
 PD_RETURNIC = (512),
 PD_SELECTION = (1),
 PD_SHOWHELP = (2048),
 PD_USEDEVMODECOPIES = (262144),
 PD_USEDEVMODECOPIESANDCOLLATE = (262144),
 PSD_DEFAULTMINMARGINS = (0),
 PSD_DISABLEMARGINS = (16),
 PSD_DISABLEORIENTATION = (256),
 PSD_DISABLEPAGEPAINTING = (524288),
 PSD_DISABLEPAPER = (512),
 PSD_DISABLEPRINTER = (32),
 PSD_ENABLEPAGEPAINTHOOK = (262144),
 PSD_ENABLEPAGESETUPHOOK = (8192),
 PSD_ENABLEPAGESETUPTEMPLATE = (32768),
 PSD_ENABLEPAGESETUPTEMPLATEHANDLE = (131072),
 PSD_INHUNDREDTHSOFMILLIMETERS = (8),
 PSD_INTHOUSANDTHSOFINCHES = (4),
 PSD_INWININIINTLMEASURE = (0),
 PSD_MARGINS = (2),
 PSD_MINMARGINS = (1),
 PSD_NOWARNING = (128),
 PSD_RETURNDEFAULT = (1024),
 PSD_SHOWHELP = (2048),
 SW_OTHERUNZOOM = (4),
 SW_OTHERZOOM = (2),
 SW_PARENTCLOSING = (1),
 SW_PARENTOPENING = (3),
 VK_LBUTTON = (1),
 VK_RBUTTON = (2),
 VK_CANCEL = (3),
 VK_MBUTTON = (4),
 VK_BACK = (8),
 VK_TAB = (9),
 VK_CLEAR = (12),
 VK_RETURN = (13),
 VK_SHIFT = (16),
 VK_CONTROL = (17),
 VK_MENU = (18),
 VK_PAUSE = (19),
 VK_CAPITAL = (20),
 VK_ESCAPE = (27),
 VK_SPACE = (32),
 VK_PRIOR = (33),
 VK_NEXT = (34),
 VK_END = (35),
 VK_HOME = (36),
 VK_LEFT = (37),
 VK_UP = (38),
 VK_RIGHT = (39),
 VK_DOWN = (40),
 VK_SELECT = (41),
 VK_PRINT = (42),
 VK_EXECUTE = (43),
 VK_SNAPSHOT = (44),
 VK_INSERT = (45),
 VK_DELETE = (46),
 VK_HELP = (47),
 VK_0 = (48),
 VK_1 = (49),
 VK_2 = (50),
 VK_3 = (51),
 VK_4 = (52),
 VK_5 = (53),
 VK_6 = (54),
 VK_7 = (55),
 VK_8 = (56),
 VK_9 = (57),
 VK_A = (65),
 VK_B = (66),
 VK_C = (67),
 VK_D = (68),
 VK_E = (69),
 VK_F = (70),
 VK_G = (71),
 VK_H = (72),
 VK_I = (73),
 VK_J = (74),
 VK_K = (75),
 VK_L = (76),
 VK_M = (77),
 VK_N = (78),
 VK_O = (79),
 VK_P = (80),
 VK_Q = (81),
 VK_R = (82),
 VK_S = (83),
 VK_T = (84),
 VK_U = (85),
 VK_V = (86),
 VK_W = (87),
 VK_X = (88),
 VK_Y = (89),
 VK_Z = (90),
 VK_NUMPAD0 = (96),
 VK_NUMPAD1 = (97),
 VK_NUMPAD2 = (98),
 VK_NUMPAD3 = (99),
 VK_NUMPAD4 = (100),
 VK_NUMPAD5 = (101),
 VK_NUMPAD6 = (102),
 VK_NUMPAD7 = (103),
 VK_NUMPAD8 = (104),
 VK_NUMPAD9 = (105),
 VK_MULTIPLY = (106),
 VK_ADD = (107),
 VK_SEPARATOR = (108),
 VK_SUBTRACT = (109),
 VK_DECIMAL = (110),
 VK_DIVIDE = (111),
 VK_F1 = (112),
 VK_F2 = (113),
 VK_F3 = (114),
 VK_F4 = (115),
 VK_F5 = (116),
 VK_F6 = (117),
 VK_F7 = (118),
 VK_F8 = (119),
 VK_F9 = (120),
 VK_F10 = (121),
 VK_F11 = (122),
 VK_F12 = (123),
 VK_F13 = (124),
 VK_F14 = (125),
 VK_F15 = (126),
 VK_F16 = (127),
 VK_F17 = (128),
 VK_F18 = (129),
 VK_F19 = (130),
 VK_F20 = (131),
 VK_F21 = (132),
 VK_F22 = (133),
 VK_F23 = (134),
 VK_F24 = (135),
 VK_NUMLOCK = (144),
 VK_SCROLL = (145),
 VK_LSHIFT = (160),
 VK_LCONTROL = (162),
 VK_LMENU = (164),
 VK_RSHIFT = (161),
 VK_RCONTROL = (163),
 VK_RMENU = (165),
 VK_PROCESSKEY = (229),
 KF_ALTDOWN = (8192),
 KF_DLGMODE = (2048),
 KF_EXTENDED = (256),
 KF_MENUMODE = (4096),
 KF_REPEAT = (16384),
 KF_UP = (32768),
 KL_NAMELENGTH = (9),
 WA_ACTIVE = (1),
 WA_CLICKACTIVE = (2),
 WA_INACTIVE = (0),
 PWR_CRITICALRESUME = (3),
 PWR_SUSPENDREQUEST = (1),
 PWR_SUSPENDRESUME = (2),
 PWR_FAIL = -((1)),
 PWR_OK = (1),
 NF_QUERY = (3),
 NF_REQUERY = (4),
 NFR_ANSI = (1),
 NFR_UNICODE = (2),
 WMSZ_BOTTOM = (6),
 WMSZ_BOTTOMLEFT = (7),
 WMSZ_BOTTOMRIGHT = (8),
 WMSZ_LEFT = (1),
 WMSZ_RIGHT = (2),
 WMSZ_TOP = (3),
 WMSZ_TOPLEFT = (4),
 WMSZ_TOPRIGHT = (5),
 MA_ACTIVATE = (1),
 MA_ACTIVATEANDEAT = (2),
 MA_NOACTIVATE = (3),
 MA_NOACTIVATEANDEAT = (4),
 SIZE_MAXHIDE = (4),
 SIZE_MAXIMIZED = (2),
 SIZE_MAXSHOW = (3),
 SIZE_MINIMIZED = (1),
 SIZE_RESTORED = (0),
 WVR_ALIGNTOP = (16),
 WVR_ALIGNLEFT = (32),
 WVR_ALIGNBOTTOM = (64),
 WVR_ALIGNRIGHT = (128),
 WVR_HREDRAW = (256),
 WVR_VREDRAW = (512),
 WVR_REDRAW = (768),
 WVR_VALIDRECTS = (1024),
 HTBOTTOM = (15),
 HTBOTTOMLEFT = (16),
 HTBOTTOMRIGHT = (17),
 HTCAPTION = (2),
 HTCLIENT = (1),
 HTERROR = -((2)),
 HTGROWBOX = (4),
 HTHSCROLL = (6),
 HTLEFT = (10),
 HTMENU = (5),
 HTNOWHERE = (0),
 HTREDUCE = (8),
 HTRIGHT = (11),
 HTSIZE = (4),
 HTSYSMENU = (3),
 HTTOP = (12),
 HTTOPLEFT = (13),
 HTTOPRIGHT = (14),
 HTTRANSPARENT = -((1)),
 HTVSCROLL = (7),
 HTZOOM = (9),
 MK_CONTROL = (8),
 MK_LBUTTON = (1),
 MK_MBUTTON = (16),
 MK_RBUTTON = (2),
 MK_SHIFT = (4),
 CS_BYTEALIGNCLIENT = (4096),
 CS_BYTEALIGNWINDOW = (8192),
 CS_CLASSDC = (64),
 CS_DBLCLKS = (8),
 CS_GLOBALCLASS = (16384),
 CS_HREDRAW = (2),
 CS_KEYCVTWINDOW = (4),
 CS_NOCLOSE = (512),
 CS_NOKEYCVT = (256),
 CS_OWNDC = (32),
 CS_PARENTDC = (128),
 CS_SAVEBITS = (2048),
 CS_VREDRAW = (1),
 DLGWINDOWEXTRA = (30),
 FALT = (16),
 FCONTROL = (8),
 FNOINVERT = (2),
 FSHIFT = (4),
 FVIRTKEY = (1),
 MIIM_CHECKMARKS = (8),
 MIIM_DATA = (32),
 MIIM_ID = (2),
 MIIM_STATE = (1),
 MIIM_SUBMENU = (4),
 MIIM_TYPE = (16),
 MFT_BITMAP = (0x4),
 MFT_MENUBARBREAK = (0x20),
 MFT_MENUBREAK = (0x40),
 MFT_OWNERDRAW = (0x100),
 MFT_RADIOCHECK = (0x200),
 MFT_RIGHTJUSTIFY = (0x4000),
 MFT_SEPARATOR = (0x800),
 MFT_STRING = (0),
 MFS_CHECKED = (0x8),
 MFS_DEFAULT = (0x1000),
 MFS_DISABLED = (0x3),
 MFS_ENABLED = (0),
 MFS_GRAYED = (0x3),
 MFS_HILITE = (0x80),
 MFS_UNCHECKED = (0),
 MFS_UNHILITE = (0),
 SERKF_AVAILABLE = (2),
 SERKF_INDICATOR = (4),
 SERKF_SERIALKEYSON = (1),
 FKF_AVAILABLE = (2),
 FKF_CLICKON = (64),
 FKF_FILTERKEYSON = (1),
 FKF_HOTKEYACTIVE = (4),
 FKF_HOTKEYSOUND = (16),
 FKF_CONFIRMHOTKEY = (8),
 FKF_INDICATOR = (32),
 HELPINFO_MENUITEM = (2),
 HELPINFO_WINDOW = (1),
 PRF_CHECKVISIBLE = (0x1),
 PRF_CHILDREN = (0x10),
 PRF_CLIENT = (0x4),
 PRF_ERASEBKGND = (0x8),
 PRF_NONCLIENT = (0x2),
 PRF_OWNED = (0x20),
 SC_CLOSE = (61536),
 SC___FILE__HELP = (61824),
 SC_DEFAULT = (61792),
 SC_HOTKEY = (61776),
 SC_HSCROLL = (61568),
 SC_KEYMENU = (61696),
 SC_MAXIMIZE = (61488),
 SC_ZOOM = (61488),
 SC_MINIMIZE = (61472),
 SC_ICON = (61472),
 SC_MONITORPOWER = (61808),
 SC_MOUSEMENU = (61584),
 SC_MOVE = (61456),
 SC_NEXTWINDOW = (61504),
 SC_PREVWINDOW = (61520),
 SC_RESTORE = (61728),
 SC_SCREENSAVE = (61760),
 SC_SIZE = (61440),
 SC_TASKLIST = (61744),
 SC_VSCROLL = (61552),
 DC_HASDEFID = (21323),
 DLGC_BUTTON = (8192),
 DLGC_DEFPUSHBUTTON = (16),
 DLGC_HASSETSEL = (8),
 DLGC_RADIOBUTTON = (64),
 DLGC_STATIC = (256),
 DLGC_UNDEFPUSHBUTTON = (32),
 DLGC_WANTALLKEYS = (4),
 DLGC_WANTARROWS = (1),
 DLGC_WANTCHARS = (128),
 DLGC_WANTMESSAGE = (4),
 DLGC_WANTTAB = (2),
 EC_LEFTMARGIN = (1),
 EC_RIGHTMARGIN = (2),
 EC_USEFONTINFO = (65535),
 LB_ERR = -((1)),
 LB_ERRSPACE = -((2)),
 LB_OKAY = (0),
 CB_ERR = -((1)),
 CB_ERRSPACE = -((2)),
 IMC_GETCANDIDATEPOS = (7),
 IMC_GETCOMPOSITIONFONT = (9),
 IMC_GETCOMPOSITIONWINDOW = (11),
 IMC_GETSTATUSWINDOWPOS = (15),
 IMC_CLOSESTATUSWINDOW = (33),
 IMC_OPENSTATUSWINDOW = (34),
 IMC_SETCANDIDATEPOS = (8),
 IMC_SETCOMPOSITIONFONT = (10),
 IMC_SETCOMPOSITIONWINDOW = (12),
 IMC_SETSTATUSWINDOWPOS = (16),
 IMN_CHANGECANDIDATE = (3),
 IMN_CLOSECANDIDATE = (4),
 IMN_CLOSESTATUSWINDOW = (1),
 IMN_GUIDELINE = (13),
 IMN_OPENCANDIDATE = (5),
 IMN_OPENSTATUSWINDOW = (2),
 IMN_SETCANDIDATEPOS = (9),
 IMN_SETCOMPOSITIONFONT = (10),
 IMN_SETCOMPOSITIONWINDOW = (11),
 IMN_SETCONVERSIONMODE = (6),
 IMN_SETOPENSTATUS = (8),
 IMN_SETSENTENCEMODE = (7),
 IMN_SETSTATUSWINDOWPOS = (12),
 IMN_PRIVATE = (14),
 SKF_AUDIBLEFEEDBACK = (64),
 SKF_AVAILABLE = (2),
 SKF_CONFIRMHOTKEY = (8),
 SKF_HOTKEYACTIVE = (4),
 SKF_HOTKEYSOUND = (16),
 SKF_INDICATOR = (32),
 SKF_STICKYKEYSON = (1),
 SKF_TRISTATE = (128),
 SKF_TWOKEYSOFF = (256),
 MKF_AVAILABLE = (2),
 MKF_CONFIRMHOTKEY = (8),
 MKF_HOTKEYACTIVE = (4),
 MKF_HOTKEYSOUND = (16),
 MKF_INDICATOR = (32),
 MKF_MOUSEKEYSON = (1),
 MKF_MODIFIERS = (64),
 MKF_REPLACENUMBERS = (128),
 SSF_AVAILABLE = (2),
 SSF_SOUNDSENTRYON = (1),
 SSTF_BORDER = (2),
 SSTF_CHARS = (1),
 SSTF_DISPLAY = (3),
 SSTF_NONE = (0),
 SSGF_DISPLAY = (3),
 SSGF_NONE = (0),
 SSWF_CUSTOM = (4),
 SSWF_DISPLAY = (3),
 SSWF_NONE = (0),
 SSWF_TITLE = (1),
 SSWF_WINDOW = (2),
 ATF_ONOFFFEEDBACK = (2),
 ATF_TIMEOUTON = (1),
 HCF_AVAILABLE = (2),
 HCF_CONFIRMHOTKEY = (8),
 HCF_HIGHCONTRASTON = (1),
 HCF_HOTKEYACTIVE = (4),
 HCF_HOTKEYAVAILABLE = (64),
 HCF_HOTKEYSOUND = (16),
 HCF_INDICATOR = (32),
 TKF_AVAILABLE = (2),
 TKF_CONFIRMHOTKEY = (8),
 TKF_HOTKEYACTIVE = (4),
 TKF_HOTKEYSOUND = (16),
 TKF_TOGGLEKEYSON = (1),
 PP_DISPLAYERRORS = (1),
 RESOURCEDISPLAYTYPE_DOMAIN = (1),
 RESOURCEDISPLAYTYPE_FILE = (4),
 RESOURCEDISPLAYTYPE_GENERIC = (0),
 RESOURCEDISPLAYTYPE_GROUP = (5),
 RESOURCEDISPLAYTYPE_SERVER = (2),
 RESOURCEDISPLAYTYPE_SHARE = (3),
 CAPSLOCK_ON = (128),
 ENHANCED_KEY = (256),
 LEFT_ALT_PRESSED = (2),
 LEFT_CTRL_PRESSED = (8),
 NUMLOCK_ON = (32),
 RIGHT_ALT_PRESSED = (1),
 RIGHT_CTRL_PRESSED = (4),
 SCROLLLOCK_ON = (64),
 SHIFT_PRESSED = (16),
 FROM_LEFT_1ST_BUTTON_PRESSED = (1),
 RIGHTMOST_BUTTON_PRESSED = (2),
 FROM_LEFT_2ND_BUTTON_PRESSED = (4),
 FROM_LEFT_3RD_BUTTON_PRESSED = (8),
 FROM_LEFT_4TH_BUTTON_PRESSED = (16),
 DOUBLE_CLICK = (2),
 MOUSE_MOVED = (1),
 KEY_EVENT = (1),
 _MOUSE_EVENT = (2),
 cMOUSE_EVENT = (2),
 WINDOW_BUFFER_SIZE_EVENT = (4),
 MENU_EVENT = (8),
 FOCUS_EVENT = (16),
 BI_RGB = (0),
 BI_RLE8 = (1),
 BI_RLE4 = (2),
 BI_BITFIELDS = (3),
 PFD_DRAW_TO_WINDOW = (0x4),
 PFD_DRAW_TO_BITMAP = (0x8),
 PFD_SUPPORT_GDI = (0x10),
 PFD_SUPPORT_OPENGL = (0x20),
 PFD_DOUBLEBUFFER = (0x1),
 PFD_STEREO = (0x2),
 PFD_DOUBLEBUFFER_DONTCARE = (0x40000000),
 PFD_STEREO_DONTCARE = (0x80000000),
 PFD_TYPE_RGBA = (0),
 PFD_TYPE_COLORINDEX = (1),
 PFD_MAIN_PLANE = (0),
 PFD_OVERLAY_PLANE = (1),
 PFD_UNDERLAY_PLANE = -((1)),
 WGL_FONT_LINES = (0),
 WGL_FONT_POLYGONS = (1),
 PFD_GENERIC_FORMAT = (0x40),
 PFD_NEED_PALETTE = (0x80),
 PFD_NEED_SYSTEM_PALETTE = (0x100),
 PFD_SWAP_COPY = (0x400),
 PFD_SWAP_EXCHANGE = (0x200),
 TMPF_FIXED_PITCH = (0x1),
 TMPF_VECTOR = (0x2),
 TMPF_TRUETYPE = (0x4),
 TMPF_DEVICE = (0x8),
 SE_ERR_SHARE = (26),
 SE_ERR_ASSOCINCOMPLETE = (27),
 SE_ERR_DDETIMEOUT = (28),
 SE_ERR_DDEFAIL = (29),
 SE_ERR_DDEBUSY = (30),
 SE_ERR_NOASSOC = (31),
 XCLASS_BOOL = (0x1000),
 XCLASS_DATA = (0x2000),
 XCLASS_FLAGS = (0x4000),
 XCLASS_MASK = (0xfc00),
 XCLASS_NOTIFICATION = (0x8000),
 XTYPF_NOBLOCK = (0x0002),
 XTYP_ADVDATA = (0x4010),
 XTYP_ADVREQ = (0x2022),
 XTYP_ADVSTART = (0x1030),
 XTYP_ADVSTOP = (0x8040),
 XTYP_CONNECT = (0x1062),
 XTYP_CONNECT_CONFIRM = (0x8072),
 XTYP_DISCONNECT = (0x80c2),
 XTYP_EXECUTE = (0x4050),
 XTYP_POKE = (0x4090),
 XTYP_REQUEST = (0x20b0),
 XTYP_WILDCONNECT = (0x20E2),
 XTYP_REGISTER = (0x80A2),
 XTYP_ERROR = (0x8002),
 XTYP_XACT_COMPLETE = (0x8080),
 XTYP_UNREGISTER = (0x80D2),
 DMLERR_DLL_USAGE = (0x4004),
 DMLERR_INVALIDPARAMETER = (0x4006),
 DMLERR_NOTPROCESSED = (0x4009),
 DMLERR_POSTMSG_FAILED = (0x400c),
 DMLERR_SERVER_DIED = (0x400e),
 DMLERR_SYS_ERROR = (0x400f),
 DMLERR_BUSY = (0x4001),
 DMLERR_DATAACKTIMEOUT = (0x4002),
 DMLERR_ADVACKTIMEOUT = (0x4000),
 DMLERR_DLL_NOT_INITIALIZED = (0x4003),
 DMLERR_LOW_MEMORY = (0x4007),
 DMLERR_MEMORY_ERROR = (0x4008),
 DMLERR_POKEACKTIMEOUT = (0x400b),
 DMLERR_NO_CONV_ESTABLISHED = (0x400a),
 DMLERR_REENTRANCY = (0x400d),
 DMLERR_UNFOUND_QUEUE_ID = (0x4011),
 DMLERR_UNADVACKTIMEOUT = (0x4010),
 DMLERR_EXECACKTIMEOUT = (0x4005),
 DDE_FACK = (0x8000),
 DDE_FNOTPROCESSED = (0x0000),
 DNS_REGISTER = (0x0001),
 DNS_UNREGISTER = (0x0002),
 CP_WINANSI = (1004),
 CP_WINUNICODE = (1200),
 APPCLASS_STANDARD = (0x00000000),
 BKMODE_LAST = (2),
 CTLCOLOR_MSGBOX = (0),
 CTLCOLOR_EDIT = (1),
 CTLCOLOR_LISTBOX = (2),
 CTLCOLOR_BTN = (3),
 CTLCOLOR_DLG = (4),
 CTLCOLOR_SCROLLBAR = (5),
 CTLCOLOR_STATIC = (6),
 CTLCOLOR_MAX = (7),
 META_SETMAPMODE = (0x0103),
 META_SETWINDOWORG = (0x020B),
 META_SETWINDOWEXT = (0x020C),
 POLYFILL_LAST = (2),
 STATUS_WAIT_0 = (0x00000000),
 STATUS_ABANDONED_WAIT_0 = (0x00000080),
 STATUS_USER_APC = (0x000000C0),
 STATUS_TIMEOUT = (0x00000102),
 STATUS_PENDING = (0x00000103),
 STATUS_GUARD_PAGE_VIOLATION = (0x80000001),
 STATUS_DATATYPE_MISALIGNMENT = (0x80000002),
 STATUS_BREAKPOINT = (0x80000003),
 STATUS_SINGLE_STEP = (0x80000004),
 STATUS_IN_PAGE_ERROR = (0xC0000006),
 STATUS_INVALID_HANDLE = (0xC0000008),
 STATUS_ILLEGAL_INSTRUCTION = (0xC000001D),
 STATUS_NONCONTINUABLE_EXCEPTION = (0xC0000025),
 STATUS_INVALID_DISPOSITION = (0xC0000026),
 STATUS_ARRAY_BOUNDS_EXCEEDED = (0xC000008C),
 STATUS_FLOAT_DENORMAL_OPERAND = (0xC000008D),
 STATUS_FLOAT_DIVIDE_BY_ZERO = (0xC000008E),
 STATUS_FLOAT_INEXACT_RESULT = (0xC000008F),
 STATUS_FLOAT_INVALID_OPERATION = (0xC0000090),
 STATUS_FLOAT_OVERFLOW = (0xC0000091),
 STATUS_FLOAT_STACK_CHECK = (0xC0000092),
 STATUS_FLOAT_UNDERFLOW = (0xC0000093),
 STATUS_INTEGER_DIVIDE_BY_ZERO = (0xC0000094),
 STATUS_INTEGER_OVERFLOW = (0xC0000095),
 STATUS_PRIVILEGED_INSTRUCTION = (0xC0000096),
 STATUS_STACK_OVERFLOW = (0xC00000FD),
 STATUS_CONTROL_C_EXIT = (0xC000013A),
 PROCESSOR_ARCHITECTURE_INTEL = (0),
 PROCESSOR_ARCHITECTURE_MIPS = (1),
 PROCESSOR_ARCHITECTURE_ALPHA = (2),
 PROCESSOR_ARCHITECTURE_PPC = (3),
 SIZEFULLSCREEN = (SIZE_MAXIMIZED),
 SIZENORMAL = (SIZE_RESTORED),
 SIZEICONIC = (SIZE_MINIMIZED),
 SIZE_OF_80387_REGISTERS = (80),
 __FILE___i386 = (0x10000),
 __FILE___CONTROL = (__FILE___i386) | (1),
 __FILE___INTEGER = (__FILE___i386) | (2),
 __FILE___SEGMENTS = (__FILE___i386) | (4),
 __FILE___FLOATING_POINT = (__FILE___i386) | (8),
 __FILE___DEBUG_REGISTERS = (__FILE___i386) | (0x10),
 __FILE___FULL = ((__FILE___CONTROL) | (__FILE___INTEGER)) | (__FILE___SEGMENTS),
 FLAG_TRACE_BIT = (0x100),
 __FILE___DEBUGGER = (__FILE___FULL) | (__FILE___FLOATING_POINT),
 FILTER_TEMP_DUPLICATE_ACCOUNT = (0x0001),
 FILTER_NORMAL_ACCOUNT = (0x0002),
 FILTER_INTERDOMAIN_TRUST_ACCOUNT = (0x0008),
 FILTER_WORKSTATION_TRUST_ACCOUNT = (0x0010),
 FILTER_SERVER_TRUST_ACCOUNT = (0x0020),
 LOGON32_LOGON_INTERACTIVE = (0x02),
 LOGON32_LOGON_BATCH = (0x04),
 LOGON32_LOGON_SERVICE = (0x05),
 LOGON32_PROVIDER_DEFAULT = (0x00),
 LOGON32_PROVIDER_WINNT35 = (0x01),
 QID_SYNC = (0xFFFFFFFF),
 IMAGE_DOS_SIGNATURE = (0x5a4d),
 IMAGE_NT_SIGNATURE = (0x4550),
 SEVERITY_SUCCESS = (0),
 SEVERITY_ERROR = (1),
 VT_EMPTY = (0),
 VT_NULL = (1),
 VT_I2 = (2),
 VT_I4 = (3),
 VT_R4 = (4),
 VT_R8 = (5),
 VT_BSTR = (8),
 VT_ERROR = (10),
 VT_BOOL = (11),
 VT_UI1 = (17),
 VT_BYREF = (0x4000),
 VT_RESERVED = (0x8000),
 FACILITY_WINDOWS = (8),
 FACILITY_STORAGE = (3),
 FACILITY_RPC = (1),
 FACILITY_SSPI = (9),
 FACILITY_WIN32 = (7),
 FACILITY_CONTROL = (10),
 FACILITY_NULL = (0),
 FACILITY_INTERNET = (12),
 FACILITY_ITF = (4),
 FACILITY_DISPATCH = (2),
 FACILITY_CERT = (11),
 ACM_OPENW = (1127),
 ACM_OPENA = (1124),
 ACM_OPEN = (ACM_OPENA),
 ACM_PLAY = (1125),
 ACM_STOP = (1126),
 ACN_START = (1),
 ACN_STOP = (2),
 BM_CLICK = (245),
 BM_GETCHECK = (240),
 BM_GETIMAGE = (246),
 BM_GETSTATE = (242),
 BM_SETCHECK = (241),
 BM_SETIMAGE = (247),
 BM_SETSTATE = (243),
 BM_SETSTYLE = (244),
 BN_CLICKED = (0),
 BN_DBLCLK = (5),
 BN_DISABLE = (4),
 BN_DOUBLECLICKED = (5),
 BN_HILITE = (2),
 BN_KILLFOCUS = (7),
 BN_PAINT = (1),
 BN_PUSHED = (2),
 BN_SETFOCUS = (6),
 BN_UNHILITE = (3),
 BN_UNPUSHED = (3),
 CB_ADDSTRING = (323),
 CB_DELETESTRING = (324),
 CB_DIR = (325),
 CB_FINDSTRING = (332),
 CB_FINDSTRINGEXACT = (344),
 CB_GETCOUNT = (326),
 CB_GETCURSEL = (327),
 CB_GETDROPPEDCONTROLRECT = (338),
 CB_GETDROPPEDSTATE = (343),
 CB_GETDROPPEDWIDTH = (351),
 CB_GETEDITSEL = (320),
 CB_GETEXTENDEDUI = (342),
 CB_GETHORIZONTALEXTENT = (349),
 CB_GETITEMDATA = (336),
 CB_GETITEMHEIGHT = (340),
 CB_GETLBTEXT = (328),
 CB_GETLBTEXTLEN = (329),
 CB_GETLOCALE = (346),
 CB_GETTOPINDEX = (347),
 CB_INITSTORAGE = (353),
 CB_INSERTSTRING = (330),
 CB_LIMITTEXT = (321),
 CB_RESETCONTENT = (331),
 CB_SELECTSTRING = (333),
 CB_SETCURSEL = (334),
 CB_SETDROPPEDWIDTH = (352),
 CB_SETEDITSEL = (322),
 CB_SETEXTENDEDUI = (341),
 CB_SETHORIZONTALEXTENT = (350),
 CB_SETITEMDATA = (337),
 CB_SETITEMHEIGHT = (339),
 CB_SETLOCALE = (345),
 CB_SETTOPINDEX = (348),
 CB_SHOWDROPDOWN = (335),
 CBN_CLOSEUP = (8),
 CBN_DBLCLK = (2),
 CBN_DROPDOWN = (7),
 CBN_EDITCHANGE = (5),
 CBN_EDITUPDATE = (6),
 CBN_ERRSPACE = -((1)),
 CBN_KILLFOCUS = (4),
 CBN_SELCHANGE = (1),
 CBN_SELENDCANCEL = (10),
 CBN_SELENDOK = (9),
 CBN_SETFOCUS = (3),
 DL_BEGINDRAG = (1157),
 DL_CANCELDRAG = (1160),
 DL_DRAGGING = (1158),
 DL_DROPPED = (1159),
 DM_GETDEFID = (1024),
 DM_REPOSITION = (1026),
 DM_SETDEFID = (1025),
 EM_CANPASTE = (1074),
 EM_CANUNDO = (198),
 EM_CHARFROMPOS = (215),
 EM_DISPLAYBAND = (1075),
 EM_EMPTYUNDOBUFFER = (205),
 EM_EXGETSEL = (1076),
 EM_EXLIMITTEXT = (1077),
 EM_EXLINEFROMCHAR = (1078),
 EM_EXSETSEL = (1079),
 EM_FINDTEXT = (1080),
 EM_FINDTEXTEX = (1103),
 EM_FINDWORDBREAK = (1100),
 EM_FMTLINES = (200),
 EM_FORMATRANGE = (1081),
 EM_GETCHARFORMAT = (1082),
 EM_GETEVENTMASK = (1083),
 EM_GETFIRSTVISIBLELINE = (206),
 EM_GETHANDLE = (189),
 EM_GETLIMITTEXT = (213),
 EM_GETLINE = (196),
 EM_GETLINECOUNT = (186),
 EM_GETMARGINS = (212),
 EM_GETMODIFY = (184),
 EM_GETIMECOLOR = (1129),
 EM_GETIMEOPTIONS = (1131),
 EM_GETOPTIONS = (1102),
 EM_GETOLEINTERFACE = (1084),
 EM_GETPARAFORMAT = (1085),
 EM_GETPASSWORDCHAR = (210),
 EM_GETPUNCTUATION = (1125),
 EM_GETRECT = (178),
 EM_GETSEL = (176),
 EM_GETSELTEXT = (1086),
 EM_GETTEXTRANGE = (1099),
 EM_GETTHUMB = (190),
 EM_GETWORDBREAKPROC = (209),
 EM_GETWORDBREAKPROCEX = (1104),
 EM_GETWORDWRAPMODE = (1127),
 EM_HIDESELECTION = (1087),
 EM_LIMITTEXT = (197),
 EM_LINEFROMCHAR = (201),
 EM_LINEINDEX = (187),
 EM_LINELENGTH = (193),
 EM_LINESCROLL = (182),
 EM_PASTESPECIAL = (1088),
 EM_POSFROMCHAR = (214),
 EM_REPLACESEL = (194),
 EM_REQUESTRESIZE = (1089),
 EM_SCROLL = (181),
 EM_SCROLLCARET = (183),
 EM_SELECTIONTYPE = (1090),
 EM_SETBKGNDCOLOR = (1091),
 EM_SETCHARFORMAT = (1092),
 EM_SETEVENTMASK = (1093),
 EM_SETHANDLE = (188),
 EM_SETIMECOLOR = (1128),
 EM_SETIMEOPTIONS = (1130),
 EM_SETLIMITTEXT = (197),
 EM_SETMARGINS = (211),
 EM_SETMODIFY = (185),
 EM_SETOLECALLBACK = (1094),
 EM_SETOPTIONS = (1101),
 EM_SETPARAFORMAT = (1095),
 EM_SETPASSWORDCHAR = (204),
 EM_SETPUNCTUATION = (1124),
 EM_SETREADONLY = (207),
 EM_SETRECT = (179),
 EM_SETRECTNP = (180),
 EM_SETSEL = (177),
 EM_SETTABSTOPS = (203),
 EM_SETTARGETDEVICE = (1096),
 EM_SETWORDBREAKPROC = (208),
 EM_SETWORDBREAKPROCEX = (1105),
 EM_SETWORDWRAPMODE = (1126),
 EM_STREAMIN = (1097),
 EM_STREAMOUT = (1098),
 EM_UNDO = (199),
 EN_CHANGE = (768),
 EN_CORRECTTEXT = (1797),
 EN_DROPFILES = (1795),
 EN_ERRSPACE = (1280),
 EN_HSCROLL = (1537),
 EN_IMECHANGE = (1799),
 EN_KILLFOCUS = (512),
 EN_MAXTEXT = (1281),
 EN_MSGFILTER = (1792),
 EN_OLEOPFAILED = (1801),
 EN_PROTECTED = (1796),
 EN_REQUESTRESIZE = (1793),
 EN_SAVECLIPBOARD = (1800),
 EN_SELCHANGE = (1794),
 EN_SETFOCUS = (256),
 EN_STOPNOUNDO = (1798),
 EN_UPDATE = (1024),
 EN_VSCROLL = (1538),
 HDM_DELETEITEM = (4610),
 HDM_GETITEMW = (4619),
 HDM_INSERTITEMW = (4618),
 HDM_SETITEMW = (4620),
 HDM_GETITEMA = (4611),
 HDM_INSERTITEMA = (4609),
 HDM_SETITEMA = (4612),
 HDM_GETITEM = (HDM_GETITEMA),
 HDM_INSERTITEM = (HDM_INSERTITEMA),
 HDM_SETITEM = (HDM_SETITEMA),
 HDM_GETITEMCOUNT = (4608),
 HDM_HITTEST = (4614),
 HDM_LAYOUT = (4613),
 HDN_BEGINTRACKW = -((326)),
 HDN_DIVIDERDBLCLICKW = -((325)),
 HDN_ENDTRACKW = -((327)),
 HDN_ITEMCHANGEDW = -((321)),
 HDN_ITEMCHANGINGW = -((320)),
 HDN_ITEMCLICKW = -((322)),
 HDN_ITEMDBLCLICKW = -((323)),
 HDN_TRACKW = -((328)),
 HDN_BEGINTRACKA = -((306)),
 HDN_DIVIDERDBLCLICKA = -((305)),
 HDN_ENDTRACKA = -((307)),
 HDN_ITEMCHANGEDA = -((301)),
 HDN_ITEMCHANGINGA = -((300)),
 HDN_ITEMCLICKA = -((302)),
 HDN_ITEMDBLCLICKA = -((303)),
 HDN_TRACKA = -((308)),
 HDN_BEGINTRACK = (HDN_BEGINTRACKA),
 HDN_DIVIDERDBLCLICK = (HDN_DIVIDERDBLCLICKA),
 HDN_ENDTRACK = (HDN_ENDTRACKA),
 HDN_ITEMCHANGED = (HDN_ITEMCHANGEDA),
 HDN_ITEMCHANGING = (HDN_ITEMCHANGINGA),
 HDN_ITEMCLICK = (HDN_ITEMCLICKA),
 HDN_ITEMDBLCLICK = (HDN_ITEMDBLCLICKA),
 HDN_TRACK = (HDN_TRACKA),
 HKM_GETHOTKEY = (1026),
 HKM_SETHOTKEY = (1025),
 HKM_SETRULES = (1027),
 LB_ADDFILE = (406),
 LB_ADDSTRING = (384),
 LB_DELETESTRING = (386),
 LB_DIR = (397),
 LB_FINDSTRING = (399),
 LB_FINDSTRINGEXACT = (418),
 LB_GETANCHORINDEX = (413),
 LB_GETCARETINDEX = (415),
 LB_GETCOUNT = (395),
 LB_GETCURSEL = (392),
 LB_GETHORIZONTALEXTENT = (403),
 LB_GETITEMDATA = (409),
 LB_GETITEMHEIGHT = (417),
 LB_GETITEMRECT = (408),
 LB_GETLOCALE = (422),
 LB_GETSEL = (391),
 LB_GETSELCOUNT = (400),
 LB_GETSELITEMS = (401),
 LB_GETTEXT = (393),
 LB_GETTEXTLEN = (394),
 LB_GETTOPINDEX = (398),
 LB_INITSTORAGE = (424),
 LB_INSERTSTRING = (385),
 LB_ITEMFROMPOINT = (425),
 LB_RESETCONTENT = (388),
 LB_SELECTSTRING = (396),
 LB_SELITEMRANGE = (411),
 LB_SELITEMRANGEEX = (387),
 LB_SETANCHORINDEX = (412),
 LB_SETCARETINDEX = (414),
 LB_SETCOLUMNWIDTH = (405),
 LB_SETCOUNT = (423),
 LB_SETCURSEL = (390),
 LB_SETHORIZONTALEXTENT = (404),
 LB_SETITEMDATA = (410),
 LB_SETITEMHEIGHT = (416),
 LB_SETLOCALE = (421),
 LB_SETSEL = (389),
 LB_SETTABSTOPS = (402),
 LB_SETTOPINDEX = (407),
 LBN_DBLCLK = (2),
 LBN_ERRSPACE = -((2)),
 LBN_KILLFOCUS = (5),
 LBN_SELCANCEL = (3),
 LBN_SELCHANGE = (1),
 LBN_SETFOCUS = (4),
 LVM_ARRANGE = (4118),
 LVM_CREATEDRAGIMAGE = (4129),
 LVM_DELETEALLITEMS = (4105),
 LVM_DELETECOLUMN = (4124),
 LVM_DELETEITEM = (4104),
 LVM_ENSUREVISIBLE = (4115),
 LVM_GETBKCOLOR = (4096),
 LVM_GETCALLBACKMASK = (4106),
 LVM_GETCOLUMNWIDTH = (4125),
 LVM_GETCOUNTPERPAGE = (4136),
 LVM_GETEDITCONTROL = (4120),
 LVM_GETIMAGELIST = (4098),
 LVM_EDITLABELW = (4214),
 LVM_FINDITEMW = (4179),
 LVM_GETCOLUMNW = (4191),
 LVM_GETISEARCHSTRINGW = (4213),
 LVM_GETITEMW = (4171),
 LVM_GETITEMTEXTW = (4211),
 LVM_GETSTRINGWIDTHW = (4183),
 LVM_INSERTCOLUMNW = (4193),
 LVM_INSERTITEMW = (4173),
 LVM_SETCOLUMNW = (4192),
 LVM_SETITEMW = (4172),
 LVM_SETITEMTEXTW = (4212),
 LVM_EDITLABELA = (4119),
 LVM_FINDITEMA = (4109),
 LVM_GETCOLUMNA = (4121),
 LVM_GETISEARCHSTRINGA = (4148),
 LVM_GETITEMA = (4101),
 LVM_GETITEMTEXTA = (4141),
 LVM_GETSTRINGWIDTHA = (4113),
 LVM_INSERTCOLUMNA = (4123),
 LVM_INSERTITEMA = (4103),
 LVM_SETCOLUMNA = (4122),
 LVM_SETITEMA = (4102),
 LVM_SETITEMTEXTA = (4142),
 LVM_EDITLABEL = (LVM_EDITLABELA),
 LVM_FINDITEM = (LVM_FINDITEMA),
 LVM_GETCOLUMN = (LVM_GETCOLUMNA),
 LVM_GETISEARCHSTRING = (LVM_GETISEARCHSTRINGA),
 LVM_GETITEM = (LVM_GETITEMA),
 LVM_GETITEMTEXT = (LVM_GETITEMTEXTA),
 LVM_GETSTRINGWIDTH = (LVM_GETSTRINGWIDTHA),
 LVM_INSERTCOLUMN = (LVM_INSERTCOLUMNA),
 LVM_INSERTITEM = (LVM_INSERTITEMA),
 LVM_SETCOLUMN = (LVM_SETCOLUMNA),
 LVM_SETITEM = (LVM_SETITEMA),
 LVM_SETITEMTEXT = (LVM_SETITEMTEXTA),
 LVM_GETITEMCOUNT = (4100),
 LVM_GETITEMPOSITION = (4112),
 LVM_GETITEMRECT = (4110),
 LVM_GETITEMSPACING = (4147),
 LVM_GETITEMSTATE = (4140),
 LVM_GETNEXTITEM = (4108),
 LVM_GETORIGIN = (4137),
 LVM_GETSELECTEDCOUNT = (4146),
 LVM_GETTEXTBKCOLOR = (4133),
 LVM_GETTEXTCOLOR = (4131),
 LVM_GETTOPINDEX = (4135),
 LVM_GETVIEWRECT = (4130),
 LVM_HITTEST = (4114),
 LVM_REDRAWITEMS = (4117),
 LVM_SCROLL = (4116),
 LVM_SETBKCOLOR = (4097),
 LVM_SETCALLBACKMASK = (4107),
 LVM_SETCOLUMNWIDTH = (4126),
 LVM_SETIMAGELIST = (4099),
 LVM_SETITEMCOUNT = (4143),
 LVM_SETITEMPOSITION = (4111),
 LVM_SETITEMPOSITION32 = (4145),
 LVM_SETITEMSTATE = (4139),
 LVM_SETTEXTBKCOLOR = (4134),
 LVM_SETTEXTCOLOR = (4132),
 LVM_SORTITEMS = (4144),
 LVM_UPDATE = (4138),
 LVN_BEGINDRAG = -((109)),
 LVN_BEGINRDRAG = -((111)),
 LVN_COLUMNCLICK = -((108)),
 LVN_DELETEALLITEMS = -((104)),
 LVN_DELETEITEM = -((103)),
 LVN_BEGINLABELEDITW = -((175)),
 LVN_ENDLABELEDITW = -((176)),
 LVN_GETDISPINFOW = -((177)),
 LVN_SETDISPINFOW = -((178)),
 LVN_BEGINLABELEDITA = -((105)),
 LVN_ENDLABELEDITA = -((106)),
 LVN_GETDISPINFOA = -((150)),
 LVN_SETDISPINFOA = -((151)),
 LVN_BEGINLABELEDIT = (LVN_BEGINLABELEDITA),
 LVN_ENDLABELEDIT = (LVN_ENDLABELEDITA),
 LVN_GETDISPINFO = (LVN_GETDISPINFOA),
 LVN_SETDISPINFO = (LVN_SETDISPINFOA),
 LVN_INSERTITEM = -((102)),
 LVN_ITEMCHANGED = -((101)),
 LVN_ITEMCHANGING = -((100)),
 LVN_KEYDOWN = -((155)),
 NM_CLICK = -((2)),
 NM_DBLCLK = -((3)),
 NM_KILLFOCUS = -((8)),
 NM_OUTOFMEMORY = -((1)),
 NM_RCLICK = -((5)),
 NM_RDBLCLK = -((6)),
 NM_RETURN = -((4)),
 NM_SETFOCUS = -((7)),
 PBM_DELTAPOS = (1027),
 PBM_SETPOS = (1026),
 PBM_SETRANGE = (1025),
 PBM_SETSTEP = (1028),
 PBM_STEPIT = (1029),
 PSM_ADDPAGE = (1127),
 PSM_APPLY = (1134),
 PSM_CANCELTOCLOSE = (1131),
 PSM_CHANGED = (1128),
 PSM_GETTABCONTROL = (1140),
 PSM_GETCURRENTPAGEHWND = (1142),
 PSM_ISDIALOGMESSAGE = (1141),
 PSM_PRESSBUTTON = (1137),
 PSM_QUERYSIBLINGS = (1132),
 PSM_REBOOTSYSTEM = (1130),
 PSM_REMOVEPAGE = (1126),
 PSM_RESTARTWINDOWS = (1129),
 PSM_SETCURSEL = (1125),
 PSM_SETCURSELID = (1138),
 PSM_SETFINISHTEXTW = (1145),
 PSM_SETTITLEW = (1144),
 PSM_SETFINISHTEXTA = (1139),
 PSM_SETTITLEA = (1135),
 PSM_SETFINISHTEXT = (PSM_SETFINISHTEXTA),
 PSM_SETTITLE = (PSM_SETTITLEA),
 PSM_SETWIZBUTTONS = (1136),
 PSM_UNCHANGED = (1133),
 PSN_APPLY = -((202)),
 PSN_HELP = -((205)),
 PSN_KILLACTIVE = -((201)),
 PSN_QUERYCANCEL = -((209)),
 PSN_RESET = -((203)),
 PSN_SETACTIVE = -((200)),
 PSN_WIZBACK = -((206)),
 PSN_WIZFINISH = -((208)),
 PSN_WIZNEXT = -((207)),
 SB_GETBORDERS = (1031),
 SB_GETPARTS = (1030),
 SB_GETRECT = (1034),
 SB_GETTEXTW = (1037),
 SB_GETTEXTLENGTHW = (1036),
 SB_SETTEXTW = (1035),
 SB_GETTEXTA = (1026),
 SB_GETTEXTLENGTHA = (1027),
 SB_SETTEXTA = (1025),
 SB_GETTEXT = (SB_GETTEXTA),
 SB_GETTEXTLENGTH = (SB_GETTEXTLENGTHA),
 SB_SETTEXT = (SB_SETTEXTA),
 SB_SETMINHEIGHT = (1032),
 SB_SETPARTS = (1028),
 SB_SIMPLE = (1033),
 SBM_ENABLE_ARROWS = (228),
 SBM_GETPOS = (225),
 SBM_GETRANGE = (227),
 SBM_GETSCROLLINFO = (234),
 SBM_SETPOS = (224),
 SBM_SETRANGE = (226),
 SBM_SETRANGEREDRAW = (230),
 SBM_SETSCROLLINFO = (233),
 STM_GETICON = (369),
 STM_GETIMAGE = (371),
 STM_SETICON = (368),
 STM_SETIMAGE = (370),
 STN_CLICKED = (0),
 STN_DBLCLK = (1),
 STN_DISABLE = (3),
 STN_ENABLE = (2),
 TB_ADDBITMAP = (1043),
 TB_ADDBUTTONS = (1044),
 TB_AUTOSIZE = (1057),
 TB_BUTTONCOUNT = (1048),
 TB_BUTTONSTRUCTSIZE = (1054),
 TB_CHANGEBITMAP = (1067),
 TB_CHECKBUTTON = (1026),
 TB_COMMANDTOINDEX = (1049),
 TB_CUSTOMIZE = (1051),
 TB_DELETEBUTTON = (1046),
 TB_ENABLEBUTTON = (1025),
 TB_GETBITMAP = (1068),
 TB_GETBITMAPFLAGS = (1065),
 TB_GETBUTTON = (1047),
 TB_ADDSTRINGW = (1101),
 TB_GETBUTTONTEXTW = (1099),
 TB_SAVERESTOREW = (1100),
 TB_ADDSTRINGA = (1052),
 TB_GETBUTTONTEXTA = (1069),
 TB_SAVERESTOREA = (1050),
 TB_ADDSTRING = (TB_ADDSTRINGA),
 TB_GETBUTTONTEXT = (TB_GETBUTTONTEXTA),
 TB_SAVERESTORE = (TB_SAVERESTOREA),
 TB_GETITEMRECT = (1053),
 TB_GETROWS = (1064),
 TB_GETSTATE = (1042),
 TB_GETTOOLTIPS = (1059),
 TB_HIDEBUTTON = (1028),
 TB_INDETERMINATE = (1029),
 TB_INSERTBUTTON = (1045),
 TB_ISBUTTONCHECKED = (1034),
 TB_ISBUTTONENABLED = (1033),
 TB_ISBUTTONHIDDEN = (1036),
 TB_ISBUTTONINDETERMINATE = (1037),
 TB_ISBUTTONPRESSED = (1035),
 TB_PRESSBUTTON = (1027),
 TB_SETBITMAPSIZE = (1056),
 TB_SETBUTTONSIZE = (1055),
 TB_SETCMDID = (1066),
 TB_SETPARENT = (1061),
 TB_SETROWS = (1063),
 TB_SETSTATE = (1041),
 TB_SETTOOLTIPS = (1060),
 TBM_CLEARSEL = (1043),
 TBM_CLEARTICS = (1033),
 TBM_GETCHANNELRECT = (1050),
 TBM_GETLINESIZE = (1048),
 TBM_GETNUMTICS = (1040),
 TBM_GETPAGESIZE = (1046),
 TBM_GETPOS = (1024),
 TBM_GETPTICS = (1038),
 TBM_GETRANGEMAX = (1026),
 TBM_GETRANGEMIN = (1025),
 TBM_GETSELEND = (1042),
 TBM_GETSELSTART = (1041),
 TBM_GETTHUMBLENGTH = (1052),
 TBM_GETTHUMBRECT = (1049),
 TBM_GETTIC = (1027),
 TBM_GETTICPOS = (1039),
 TBM_SETLINESIZE = (1047),
 TBM_SETPAGESIZE = (1045),
 TBM_SETPOS = (1029),
 TBM_SETRANGE = (1030),
 TBM_SETRANGEMAX = (1032),
 TBM_SETRANGEMIN = (1031),
 TBM_SETSEL = (1034),
 TBM_SETSELEND = (1036),
 TBM_SETSELSTART = (1035),
 TBM_SETTHUMBLENGTH = (1051),
 TBM_SETTIC = (1028),
 TBM_SETTICFREQ = (1044),
 TBN_BEGINADJUST = -((703)),
 TBN_BEGINDRAG = -((701)),
 TBN_CUSTHELP = -((709)),
 TBN_ENDADJUST = -((704)),
 TBN_ENDDRAG = -((702)),
 TBN_GETBUTTONINFOW = -((720)),
 TBN_GETBUTTONINFOA = -((700)),
 TBN_GETBUTTONINFO = (TBN_GETBUTTONINFOA),
 TBN_QUERYDELETE = -((707)),
 TBN_QUERYINSERT = -((706)),
 TBN_RESET = -((705)),
 TBN_TOOLBARCHANGE = -((708)),
 TCM_ADJUSTRECT = (4904),
 TCM_DELETEALLITEMS = (4873),
 TCM_DELETEITEM = (4872),
 TCM_GETCURFOCUS = (4911),
 TCM_GETCURSEL = (4875),
 TCM_GETIMAGELIST = (4866),
 TCM_GETITEMW = (4924),
 TCM_INSERTITEMW = (4926),
 TCM_SETITEMW = (4925),
 TCM_GETITEMA = (4869),
 TCM_INSERTITEMA = (4871),
 TCM_SETITEMA = (4870),
 TCM_GETITEM = (TCM_GETITEMA),
 TCM_INSERTITEM = (TCM_INSERTITEMA),
 TCM_SETITEM = (TCM_SETITEMA),
 TCM_GETITEMCOUNT = (4868),
 TCM_GETITEMRECT = (4874),
 TCM_GETROWCOUNT = (4908),
 TCM_GETTOOLTIPS = (4909),
 TCM_HITTEST = (4877),
 TCM_REMOVEIMAGE = (4906),
 TCM_SETCURFOCUS = (4912),
 TCM_SETCURSEL = (4876),
 TCM_SETIMAGELIST = (4867),
 TCM_SETITEMEXTRA = (4878),
 TCM_SETITEMSIZE = (4905),
 TCM_SETPADDING = (4907),
 TCM_SETTOOLTIPS = (4910),
 TCN_KEYDOWN = -((550)),
 TCN_SELCHANGE = -((551)),
 TCN_SELCHANGING = -((552)),
 TTM_ACTIVATE = (1025),
 TTM_ADDTOOLW = (1074),
 TTM_DELTOOLW = (1075),
 TTM_ENUMTOOLSW = (1082),
 TTM_GETCURRENTTOOLW = (1083),
 TTM_GETTEXTW = (1080),
 TTM_GETTOOLINFOW = (1077),
 TTM_HITTESTW = (1079),
 TTM_NEWTOOLRECTW = (1076),
 TTM_SETTOOLINFOW = (1078),
 TTM_UPDATETIPTEXTW = (1081),
 TTM_ADDTOOLA = (1028),
 TTM_DELTOOLA = (1029),
 TTM_ENUMTOOLSA = (1038),
 TTM_GETCURRENTTOOLA = (1039),
 TTM_GETTEXTA = (1035),
 TTM_GETTOOLINFOA = (1032),
 TTM_HITTESTA = (1034),
 TTM_NEWTOOLRECTA = (1030),
 TTM_SETTOOLINFOA = (1033),
 TTM_UPDATETIPTEXTA = (1036),
 TTM_ADDTOOL = (TTM_ADDTOOLA),
 TTM_DELTOOL = (TTM_DELTOOLA),
 TTM_ENUMTOOLS = (TTM_ENUMTOOLSA),
 TTM_GETCURRENTTOOL = (TTM_GETCURRENTTOOLA),
 TTM_GETTEXT = (TTM_GETTEXTA),
 TTM_GETTOOLINFO = (TTM_GETTOOLINFOA),
 TTM_HITTEST = (TTM_HITTESTA),
 TTM_NEWTOOLRECT = (TTM_NEWTOOLRECTA),
 TTM_SETTOOLINFO = (TTM_SETTOOLINFOA),
 TTM_UPDATETIPTEXT = (TTM_UPDATETIPTEXTA),
 TTM_GETTOOLCOUNT = (1037),
 TTM_RELAYEVENT = (1031),
 TTM_SETDELAYTIME = (1027),
 TTM_WINDOWFROMPOINT = (1040),
 TTN_NEEDTEXTW = -((530)),
 TTN_NEEDTEXTA = -((520)),
 TTN_NEEDTEXT = (TTN_NEEDTEXTA),
 TTN_POP = -((522)),
 TTN_SHOW = -((521)),
 TVM_CREATEDRAGIMAGE = (4370),
 TVM_DELETEITEM = (4353),
 TVM_ENDEDITLABELNOW = (4374),
 TVM_ENSUREVISIBLE = (4372),
 TVM_EXPAND = (4354),
 TVM_GETCOUNT = (4357),
 TVM_GETEDITCONTROL = (4367),
 TVM_GETIMAGELIST = (4360),
 TVM_GETINDENT = (4358),
 TVM_GETITEMRECT = (4356),
 TVM_GETNEXTITEM = (4362),
 TVM_GETVISIBLECOUNT = (4368),
 TVM_HITTEST = (4369),
 TVM_EDITLABELW = (4417),
 TVM_GETISEARCHSTRINGW = (4416),
 TVM_GETITEMW = (4414),
 TVM_INSERTITEMW = (4402),
 TVM_SETITEMW = (4415),
 TVM_EDITLABELA = (4366),
 TVM_GETISEARCHSTRINGA = (4375),
 TVM_GETITEMA = (4364),
 TVM_INSERTITEMA = (4352),
 TVM_SETITEMA = (4365),
 TVM_EDITLABEL = (TVM_EDITLABELA),
 TVM_GETISEARCHSTRING = (TVM_GETISEARCHSTRINGA),
 TVM_GETITEM = (TVM_GETITEMA),
 TVM_INSERTITEM = (TVM_INSERTITEMA),
 TVM_SETITEM = (TVM_SETITEMA),
 TVM_SELECTITEM = (4363),
 TVM_SETIMAGELIST = (4361),
 TVM_SETINDENT = (4359),
 TVM_SORTCHILDREN = (4371),
 TVM_SORTCHILDRENCB = (4373),
 TVN_KEYDOWN = -((412)),
 TVN_BEGINDRAGW = -((456)),
 TVN_BEGINLABELEDITW = -((459)),
 TVN_BEGINRDRAGW = -((457)),
 TVN_DELETEITEMW = -((458)),
 TVN_ENDLABELEDITW = -((460)),
 TVN_GETDISPINFOW = -((452)),
 TVN_ITEMEXPANDEDW = -((455)),
 TVN_ITEMEXPANDINGW = -((454)),
 TVN_SELCHANGEDW = -((451)),
 TVN_SELCHANGINGW = -((450)),
 TVN_SETDISPINFOW = -((453)),
 TVN_BEGINDRAGA = -((407)),
 TVN_BEGINLABELEDITA = -((410)),
 TVN_BEGINRDRAGA = -((408)),
 TVN_DELETEITEMA = -((409)),
 TVN_ENDLABELEDITA = -((411)),
 TVN_GETDISPINFOA = -((403)),
 TVN_ITEMEXPANDEDA = -((406)),
 TVN_ITEMEXPANDINGA = -((405)),
 TVN_SELCHANGEDA = -((402)),
 TVN_SELCHANGINGA = -((401)),
 TVN_SETDISPINFOA = -((404)),
 TVN_BEGINDRAG = (TVN_BEGINDRAGA),
 TVN_BEGINLABELEDIT = (TVN_BEGINLABELEDITA),
 TVN_BEGINRDRAG = (TVN_BEGINRDRAGA),
 TVN_DELETEITEM = (TVN_DELETEITEMA),
 TVN_ENDLABELEDIT = (TVN_ENDLABELEDITA),
 TVN_GETDISPINFO = (TVN_GETDISPINFOA),
 TVN_ITEMEXPANDED = (TVN_ITEMEXPANDEDA),
 TVN_ITEMEXPANDING = (TVN_ITEMEXPANDINGA),
 TVN_SELCHANGED = (TVN_SELCHANGEDA),
 TVN_SELCHANGING = (TVN_SELCHANGINGA),
 TVN_SETDISPINFO = (TVN_SETDISPINFOA),
 UDM_GETACCEL = (1132),
 UDM_GETBASE = (1134),
 UDM_GETBUDDY = (1130),
 UDM_GETPOS = (1128),
 UDM_GETRANGE = (1126),
 UDM_SETACCEL = (1131),
 UDM_SETBASE = (1133),
 UDM_SETBUDDY = (1129),
 UDM_SETPOS = (1127),
 UDM_SETRANGE = (1125),
 UDN_DELTAPOS = -((722)),
 WM_ACTIVATE = (6),
 WM_ACTIVATEAPP = (28),
 WM_ASKCBFORMATNAME = (780),
 WM_CANCELJOURNAL = (75),
 WM_CANCELMODE = (31),
 WM_CAPTURECHANGED = (533),
 WM_CHANGECBCHAIN = (781),
 WM_CHAR = (258),
 WM_CHARTOITEM = (47),
 WM_CHILDACTIVATE = (34),
 WM_CHOOSEFONT_GETLOGFONT = (1025),
 WM_CHOOSEFONT_SETLOGFONT = (1125),
 WM_CHOOSEFONT_SETFLAGS = (1126),
 WM_CLEAR = (771),
 WM_CLOSE = (16),
 WM_COMMAND = (273),
 WM_COMPACTING = (65),
 WM_COMPAREITEM = (57),
 WM___FILE__MENU = (123),
 WM_COPY = (769),
 WM_COPYDATA = (74),
 WM_CREATE = (1),
 WM_CTLCOLORBTN = (309),
 WM_CTLCOLORDLG = (310),
 WM_CTLCOLOREDIT = (307),
 WM_CTLCOLORLISTBOX = (308),
 WM_CTLCOLORMSGBOX = (306),
 WM_CTLCOLORSCROLLBAR = (311),
 WM_CTLCOLORSTATIC = (312),
 WM_CUT = (768),
 WM_DEADCHAR = (259),
 WM_DELETEITEM = (45),
 WM_DESTROY = (2),
 WM_DESTROYCLIPBOARD = (775),
 WM_DEVICECHANGE = (537),
 WM_DEVMODECHANGE = (27),
 WM_DISPLAYCHANGE = (126),
 WM_DRAWCLIPBOARD = (776),
 WM_DRAWITEM = (43),
 WM_DROPFILES = (563),
 WM_ENABLE = (10),
 WM_ENDSESSION = (22),
 WM_ENTERIDLE = (289),
 WM_ENTERMENULOOP = (529),
 WM_ENTERSIZEMOVE = (561),
 WM_ERASEBKGND = (20),
 WM_EXITMENULOOP = (530),
 WM_EXITSIZEMOVE = (562),
 WM_FONTCHANGE = (29),
 WM_GETDLGCODE = (135),
 WM_GETFONT = (49),
 WM_GETHOTKEY = (51),
 WM_GETICON = (127),
 WM_GETMINMAXINFO = (36),
 WM_GETTEXT = (13),
 WM_GETTEXTLENGTH = (14),
 WM_HELP = (83),
 WM_HOTKEY = (786),
 WM_HSCROLL = (276),
 WM_HSCROLLCLIPBOARD = (782),
 WM_ICONERASEBKGND = (39),
 WM_IME_CHAR = (646),
 WM_IME_COMPOSITION = (271),
 WM_IME_COMPOSITIONFULL = (644),
 WM_IME_CONTROL = (643),
 WM_IME_ENDCOMPOSITION = (270),
 WM_IME_KEYDOWN = (656),
 WM_IME_KEYUP = (657),
 WM_IME_NOTIFY = (642),
 WM_IME_SELECT = (645),
 WM_IME_SET__FILE__ = (641),
 WM_IME_STARTCOMPOSITION = (269),
 WM_INITDIALOG = (272),
 WM_INITMENU = (278),
 WM_INITMENUPOPUP = (279),
 WM_INPUTLANGCHANGE = (81),
 WM_INPUTLANGCHANGEREQUEST = (80),
 WM_KEYDOWN = (256),
 WM_KEYUP = (257),
 WM_KILLFOCUS = (8),
 WM_LBUTTONDBLCLK = (515),
 WM_LBUTTONDOWN = (513),
 WM_LBUTTONUP = (514),
 WM_MBUTTONDBLCLK = (521),
 WM_MBUTTONDOWN = (519),
 WM_MBUTTONUP = (520),
 WM_MDIACTIVATE = (546),
 WM_MDICASCADE = (551),
 WM_MDICREATE = (544),
 WM_MDIDESTROY = (545),
 WM_MDIGETACTIVE = (553),
 WM_MDIICONARRANGE = (552),
 WM_MDIMAXIMIZE = (549),
 WM_MDINEXT = (548),
 WM_MDIREFRESHMENU = (564),
 WM_MDIRESTORE = (547),
 WM_MDISETMENU = (560),
 WM_MDITILE = (550),
 WM_MEASUREITEM = (44),
 WM_MENUCHAR = (288),
 WM_MENUSELECT = (287),
 WM_MOUSEACTIVATE = (33),
 WM_MOUSEMOVE = (512),
 WM_MOUSEWHEEL = 0x020A,
 WM_MOVE = (3),
 WM_MOVING = (534),
 WM_NCACTIVATE = (134),
 WM_NCCALCSIZE = (131),
 WM_NCCREATE = (129),
 WM_NCDESTROY = (130),
 WM_NCHITTEST = (132),
 WM_NCLBUTTONDBLCLK = (163),
 WM_NCLBUTTONDOWN = (161),
 WM_NCLBUTTONUP = (162),
 WM_NCMBUTTONDBLCLK = (169),
 WM_NCMBUTTONDOWN = (167),
 WM_NCMBUTTONUP = (168),
 WM_NCMOUSEMOVE = (160),
 WM_NCPAINT = (133),
 WM_NCRBUTTONDBLCLK = (166),
 WM_NCRBUTTONDOWN = (164),
 WM_NCRBUTTONUP = (165),
 WM_NEXTDLGCTL = (40),
 WM_NOTIFY = (78),
 WM_NOTIFYFORMAT = (85),
 WM_NULL = (0),
 WM_PAINT = (15),
 WM_PAINTCLIPBOARD = (777),
 WM_PAINTICON = (38),
 WM_PALETTECHANGED = (785),
 WM_PALETTEISCHANGING = (784),
 WM_PARENTNOTIFY = (528),
 WM_PASTE = (770),
 WM_PENWINFIRST = (896),
 WM_PENWINLAST = (911),
 WM_POWER = (72),
 WM_POWERBROADCAST = (536),
 WM_PRINT = (791),
 WM_PRINTCLIENT = (792),
 WM_PSD_ENVSTAMPRECT = (1029),
 WM_PSD_FULLPAGERECT = (1025),
 WM_PSD_GREEKTEXTRECT = (1028),
 WM_PSD_MARGINRECT = (1027),
 WM_PSD_MINMARGINRECT = (1026),
 WM_PSD_PAGESETUPDLG = (1024),
 WM_PSD_YAFULLPAGERECT = (1030),
 WM_QUERYDRAGICON = (55),
 WM_QUERYENDSESSION = (17),
 WM_QUERYNEWPALETTE = (783),
 WM_QUERYOPEN = (19),
 WM_QUEUESYNC = (35),
 WM_QUIT = (18),
 WM_RBUTTONDBLCLK = (518),
 WM_RBUTTONDOWN = (516),
 WM_RBUTTONUP = (517),
 WM_RENDERALLFORMATS = (774),
 WM_RENDERFORMAT = (773),
 WM_SETCURSOR = (32),
 WM_SETFOCUS = (7),
 WM_SETFONT = (48),
 WM_SETHOTKEY = (50),
 WM_SETICON = (128),
 WM_SETREDRAW = (11),
 WM_SETTEXT = (12),
 WM_SETTINGCHANGE = (26),
 WM_SHOWWINDOW = (24),
 WM_SIZE = (5),
 WM_SIZECLIPBOARD = (779),
 WM_SIZING = (532),
 WM_SPOOLERSTATUS = (42),
 WM_STYLECHANGED = (125),
 WM_STYLECHANGING = (124),
 WM_SYSCHAR = (262),
 WM_SYSCOLORCHANGE = (21),
 WM_SYSCOMMAND = (274),
 WM_SYSDEADCHAR = (263),
 WM_SYSKEYDOWN = (260),
 WM_SYSKEYUP = (261),
 WM_TCARD = (82),
 WM_TIMECHANGE = (30),
 WM_TIMER = (275),
 WM_UNDO = (772),
 WM_USER = (1024),
 WM_USERCHANGED = (84),
 WM_VKEYTOITEM = (46),
 WM_VSCROLL = (277),
 WM_VSCROLLCLIPBOARD = (778),
 WM_WINDOWPOSCHANGED = (71),
 WM_WINDOWPOSCHANGING = (70),
 WM_WININICHANGE = (26),
 WM_KEYFIRST = (256),
 WM_KEYLAST = (264),
 WM_MOUSEFIRST = (512),
 WM_MOUSELAST = (521),
}

struct VA_LIST
{
}


struct ABC
{
 int abcA;
 UINT abcB;
 int abcC;
}

alias ABC* LPABC;
alias ABC _ABC;
alias ABC TABC;
alias ABC* PABC;

struct ABCFLOAT
{
 FLOAT abcfA;
 FLOAT abcfB;
 FLOAT abcfC;
}

alias ABCFLOAT* LPABCFLOAT;
alias ABCFLOAT _ABCFLOAT;
alias ABCFLOAT TABCFLOAT;
alias ABCFLOAT* PABCFLOAT;

struct ACCEL
{
 ubyte fVirt;
 ushort key;
 ushort cmd;
}

alias ACCEL* LPACCEL;
alias ACCEL _ACCEL;
alias ACCEL TACCEL;
alias ACCEL* PACCEL;

struct ACE_HEADER
{
 ubyte AceType;
 ubyte AceFlags;
 ushort AceSize;
}

alias ACE_HEADER _ACE_HEADER;
alias ACE_HEADER TACE_HEADER;
alias ACE_HEADER* PACE_HEADER;
alias DWORD ACCESS_MASK;
alias ACCESS_MASK REGSAM;

struct ACCESS_ALLOWED_ACE
{
 ACE_HEADER Header;
 ACCESS_MASK Mask;
 DWORD SidStart;
}

alias ACCESS_ALLOWED_ACE _ACCESS_ALLOWED_ACE;
alias ACCESS_ALLOWED_ACE TACCESS_ALLOWED_ACE;
alias ACCESS_ALLOWED_ACE* PACCESS_ALLOWED_ACE;

struct ACCESS_DENIED_ACE
{
 ACE_HEADER Header;
 ACCESS_MASK Mask;
 DWORD SidStart;
}

alias ACCESS_DENIED_ACE _ACCESS_DENIED_ACE;
alias ACCESS_DENIED_ACE TACCESS_DENIED_ACE;

struct ACCESSTIMEOUT
{
 UINT cbSize;
 DWORD dwFlags;
 DWORD iTimeOutMSec;
}

alias ACCESSTIMEOUT _ACCESSTIMEOUT;
alias ACCESSTIMEOUT TACCESSTIMEOUT;
alias ACCESSTIMEOUT* PACCESSTIMEOUT;

struct ACL
{
 ubyte AclRevision;
 ubyte Sbz1;
 ushort AclSize;
 ushort AceCount;
 ushort Sbz2;
}

alias ACL* PACL;
alias ACL _ACL;
alias ACL TACL;

struct ACL_REVISION_INFORMATION
{
 DWORD AclRevision;
}

alias ACL_REVISION_INFORMATION _ACL_REVISION_INFORMATION;
alias ACL_REVISION_INFORMATION TACLREVISIONINFORMATION;
alias ACL_REVISION_INFORMATION* PACLREVISIONINFORMATION;

struct ACL_SIZE_INFORMATION
{
 DWORD AceCount;
 DWORD AclBytesInUse;
 DWORD AclBytesFree;
}

alias ACL_SIZE_INFORMATION _ACL_SIZE_INFORMATION;
alias ACL_SIZE_INFORMATION TACLSIZEINFORMATION;
alias ACL_SIZE_INFORMATION* PACLSIZEINFORMATION;

struct ACTION_HEADER
{
 ULONG transport_id;
 USHORT action_code;
 USHORT reserved;
}

alias ACTION_HEADER _ACTION_HEADER;
alias ACTION_HEADER TACTIONHEADER;
alias ACTION_HEADER* PACTIONHEADER;

struct ADAPTER_STATUS
{
 UCHAR[1 + 5] adapter_address;
 UCHAR rev_major;
 UCHAR reserved0;
 UCHAR adapter_type;
 UCHAR rev_minor;
 ushort duration;
 ushort frmr_recv;
 ushort frmr_xmit;
 ushort iframe_recv_err;
 ushort xmit_aborts;
 DWORD xmit_success;
 DWORD recv_success;
 ushort iframe_xmit_err;
 ushort recv_buff_unavail;
 ushort t1_timeouts;
 ushort ti_timeouts;
 DWORD reserved1;
 ushort free_ncbs;
 ushort max_cfg_ncbs;
 ushort max_ncbs;
 ushort xmit_buf_unavail;
 ushort max_dgram_size;
 ushort pending_sess;
 ushort max_cfg_sess;
 ushort max_sess;
 ushort max_sess_pkt_size;
 ushort name_count;
}

alias ADAPTER_STATUS _ADAPTER_STATUS;
alias ADAPTER_STATUS TADAPTERSTATUS;
alias ADAPTER_STATUS* PADAPTERSTATUS;

struct ADDJOB_INFO_1
{
 LPTSTR Path;
 DWORD JobId;
}

alias ADDJOB_INFO_1 _ADDJOB_INFO_1;
alias ADDJOB_INFO_1 TADDJOB_INFO_1;
alias ADDJOB_INFO_1* PADDJOB_INFO_1;

struct ANIMATIONINFO
{
 UINT cbSize;
 int iMinAnimate;
}

alias ANIMATIONINFO* LPANIMATIONINFO;
alias ANIMATIONINFO _ANIMATIONINFO;
alias ANIMATIONINFO TANIMATIONINFO;
alias ANIMATIONINFO* PANIMATIONINFO;

struct RECT
{
 LONG left;
 LONG top;
 LONG right;
 LONG bottom;
}

alias RECT* LPCRECT;
alias RECT* LPRECT;
alias RECT _RECT;
alias RECT TRECT;
alias RECT* PRECT;

struct RECTL
{
 LONG left;
 LONG top;
 LONG right;
 LONG bottom;
}

alias RECTL _RECTL;
alias RECTL TRECTL;
alias RECTL* PRECTL;
alias RECTL* LPRECTL;
alias RECTL* LPCRECTL;

struct APPBARDATA
{
 DWORD cbSize;
 HWND hWnd;
 UINT uCallbackMessage;
 UINT uEdge;
 RECT rc;
 LPARAM lParam;
}

alias APPBARDATA _APPBARDATA;
alias APPBARDATA TAPPBARDATA;
alias APPBARDATA* PAPPBARDATA;

struct BITMAP
{
 LONG bmType;
 LONG bmWidth;
 LONG bmHeight;
 LONG bmWidthBytes;
 ushort bmPlanes;
 ushort bmBitsPixel;
 LPVOID bmBits;
}

alias BITMAP* PBITMAP;
alias BITMAP* NPBITMAP;
alias BITMAP* LPBITMAP;
alias BITMAP TAGBITMAP;
alias BITMAP TBITMAP;

struct BITMAPCOREHEADER
{
 DWORD bcSize;
 ushort bcWidth;
 ushort bcHeight;
 ushort bcPlanes;
 ushort bcBitCount;
}

alias BITMAPCOREHEADER TAGBITMAPCOREHEADER;
alias BITMAPCOREHEADER TBITMAPCOREHEADER;
alias BITMAPCOREHEADER* PBITMAPCOREHEADER;

struct RGBTRIPLE
{
 ubyte rgbtBlue;
 ubyte rgbtGreen;
 ubyte rgbtRed;
}

alias RGBTRIPLE TAGRGBTRIPLE;
alias RGBTRIPLE TRGBTRIPLE;
alias RGBTRIPLE* PRGBTRIPLE;

struct BITMAPCOREINFO
{
 BITMAPCOREHEADER bmciHeader;
 RGBTRIPLE[1 + 0] bmciColors;
}

alias BITMAPCOREINFO* PBITMAPCOREINFO;
alias BITMAPCOREINFO* LPBITMAPCOREINFO;
alias BITMAPCOREINFO _BITMAPCOREINFO;
alias BITMAPCOREINFO TBITMAPCOREINFO;

align(1) struct BITMAPINFOHEADER
{
 DWORD biSize;
 LONG biWidth;
 LONG biHeight;
 ushort biPlanes;
 ushort biBitCount;
 DWORD biCompression;
 DWORD biSizeImage;
 LONG biXPelsPerMeter;
 LONG biYPelsPerMeter;
 DWORD biClrUsed;
 DWORD biClrImportant;
}

alias BITMAPINFOHEADER* LPBITMAPINFOHEADER;
alias BITMAPINFOHEADER TBITMAPINFOHEADER;
alias BITMAPINFOHEADER* PBITMAPINFOHEADER;

struct RGBQUAD
{
 ubyte rgbBlue;
 ubyte rgbGreen;
 ubyte rgbRed;
 ubyte rgbReserved;
}

alias RGBQUAD TAGRGBQUAD;
alias RGBQUAD TRGBQUAD;
alias RGBQUAD* PRGBQUAD;

struct BITMAPINFO
{
 BITMAPINFOHEADER bmiHeader;
 RGBQUAD[1 + 0] bmiColors;
}

alias BITMAPINFO* LPBITMAPINFO;
alias BITMAPINFO* PBITMAPINFO;
alias BITMAPINFO TBITMAPINFO;
alias int FXPT2DOT30;
alias FXPT2DOT30* LPFXPT2DOT30;
alias FXPT2DOT30 TPFXPT2DOT30;
alias FXPT2DOT30* PPFXPT2DOT30;

struct CIEXYZ
{
 FXPT2DOT30 ciexyzX;
 FXPT2DOT30 ciexyzY;
 FXPT2DOT30 ciexyzZ;
}

alias CIEXYZ TAGCIEXYZ;
alias CIEXYZ* LPCIEXYZ;
alias CIEXYZ TPCIEXYZ;
alias CIEXYZ* PCIEXYZ;

struct CIEXYZTRIPLE
{
 CIEXYZ ciexyzRed;
 CIEXYZ ciexyzGreen;
 CIEXYZ ciexyzBlue;
}

alias CIEXYZTRIPLE TAGCIEXYZTRIPLE;
alias CIEXYZTRIPLE* LPCIEXYZTRIPLE;
alias CIEXYZTRIPLE TCIEXYZTRIPLE;
alias CIEXYZTRIPLE* PCIEXYZTRIPLE;

struct BITMAPV4HEADER
{
 DWORD bV4Size;
 LONG bV4Width;
 LONG bV4Height;
 ushort bV4Planes;
 ushort bV4BitCount;
 DWORD bV4V4Compression;
 DWORD bV4SizeImage;
 LONG bV4XPelsPerMeter;
 LONG bV4YPelsPerMeter;
 DWORD bV4ClrUsed;
 DWORD bV4ClrImportant;
 DWORD bV4RedMask;
 DWORD bV4GreenMask;
 DWORD bV4BlueMask;
 DWORD bV4AlphaMask;
 DWORD bV4CSType;
 CIEXYZTRIPLE bV4Endpoints;
 DWORD bV4GammaRed;
 DWORD bV4GammaGreen;
 DWORD bV4GammaBlue;
}

alias BITMAPV4HEADER* LPBITMAPV4HEADER;
alias BITMAPV4HEADER TBITMAPV4HEADER;
alias BITMAPV4HEADER* PBITMAPV4HEADER;

align(1) struct BITMAPFILEHEADER
{
 ushort bfType;
 DWORD bfSize;
 ushort bfReserved1;
 ushort bfReserved2;
 DWORD bfOffBits;
}


struct BLOB
{
 ULONG cbSize;
 ubyte* pBlobData;
}

alias BLOB _BLOB;
alias BLOB TBLOB;
alias BLOB* PBLOB;

align(1) struct SHITEMID
{
 USHORT cb;
 ubyte[1 + 0] abID;
}

alias SHITEMID* LPSHITEMID;
alias SHITEMID* LPCSHITEMID;
alias SHITEMID _SHITEMID;
alias SHITEMID TSHITEMID;
alias SHITEMID* PSHITEMID;

struct ITEMIDLIST
{
 SHITEMID mkid;
}

alias ITEMIDLIST* LPITEMIDLIST;
alias ITEMIDLIST* LPCITEMIDLIST;
alias ITEMIDLIST _ITEMIDLIST;
alias ITEMIDLIST TITEMIDLIST;
alias ITEMIDLIST* PITEMIDLIST;

struct BROWSEINFOA
{
 HWND hwndOwner;
 LPCITEMIDLIST pidlRoot;
 LPSTR pszDisplayName;
 LPCSTR lpszTitle;
 UINT ulFlags;
 BFFCALLBACK lpfn;
 LPARAM lParam;
 int iImage;
}
struct BROWSEINFOW
{
 HWND hwndOwner;
 LPCITEMIDLIST pidlRoot;
 LPWSTR pszDisplayName;
 LPCWSTR lpszTitle;
 UINT ulFlags;
 BFFCALLBACK lpfn;
 LPARAM lParam;
 int iImage;
}
version( Win32SansUnicode )
{
 alias BROWSEINFOA BROWSEINFO;
}
else
{
 alias BROWSEINFOW BROWSEINFO;
}
alias BROWSEINFO* PBROWSEINFO, LPBROWSEINFO;

struct FILETIME
{
 DWORD dwLowDateTime;
 DWORD dwHighDateTime;
}

alias FILETIME* LPFILETIME;
alias FILETIME _FILETIME;
alias FILETIME TFILETIME;
alias FILETIME* PFILETIME;

struct BY_HANDLE_FILE_INFORMATION
{
 DWORD dwFileAttributes;
 FILETIME ftCreationTime;
 FILETIME ftLastAccessTime;
 FILETIME ftLastWriteTime;
 DWORD dwVolumeSerialNumber;
 DWORD nFileSizeHigh;
 DWORD nFileSizeLow;
 DWORD nNumberOfLinks;
 DWORD nFileIndexHigh;
 DWORD nFileIndexLow;
}

alias BY_HANDLE_FILE_INFORMATION* LPBY_HANDLE_FILE_INFORMATION;
alias BY_HANDLE_FILE_INFORMATION _BY_HANDLE_FILE_INFORMATION;
alias BY_HANDLE_FILE_INFORMATION TBYHANDLEFILEINFORMATION;
alias BY_HANDLE_FILE_INFORMATION* PBYHANDLEFILEINFORMATION;

struct FIXED
{
 ushort fract;
 short value;
}

alias FIXED _FIXED;
alias FIXED TFIXED;
alias FIXED* PFIXED;

struct POINT
{
 LONG x;
 LONG y;
}

alias POINT* LPPOINT;
alias POINT TAGPOINT;
alias POINT TPOINT;
alias POINT* PPOINT;

struct POINTFX
{
 FIXED x;
 FIXED y;
}

alias POINTFX TAGPOINTFX;
alias POINTFX TPOINTFX;
alias POINTFX* PPOINTFX;

struct POINTL
{
 LONG x;
 LONG y;
}

alias POINTL _POINTL;
alias POINTL TPOINTL;
alias POINTL* PPOINTL;

struct TSMALLPOINT
{
 byte X, Y;
}


struct POINTS
{
 SHORT x;
 SHORT y;
}

alias POINTS TAGPOINTS;
alias POINTS TPOINTS;
alias POINTS* PPOINTS;

struct CANDIDATEFORM
{
 DWORD dwIndex;
 DWORD dwStyle;
 POINT ptCurrentPos;
 RECT rcArea;
}

alias CANDIDATEFORM* LPCANDIDATEFORM;
alias CANDIDATEFORM _TAGCANDIDATEFORM;
alias CANDIDATEFORM TCANDIDATEFORM;
alias CANDIDATEFORM* PCANDIDATEFORM;

struct CANDIDATELIST
{
 DWORD dwSize;
 DWORD dwStyle;
 DWORD dwCount;
 DWORD dwSelection;
 DWORD dwPageStart;
 DWORD dwPageSize;
 DWORD[1 + 0] dwOffset;
}

alias CANDIDATELIST* LPCANDIDATELIST;
alias CANDIDATELIST _TAGCANDIDATELIST;
alias CANDIDATELIST TCANDIDATELIST;
alias CANDIDATELIST* PCANDIDATELIST;

struct CREATESTRUCT
{
 LPVOID lpCreateParams;
 HINST hInstance;
 HMENU hMenu;
 HWND hwndParent;
 int cy;
 int cx;
 int y;
 int x;
 LONG style;
 LPCTSTR lpszName;
 LPCTSTR lpszClass;
 DWORD dwExStyle;
}

alias CREATESTRUCT* LPCREATESTRUCT;
alias CREATESTRUCT TAGCREATESTRUCT;
alias CREATESTRUCT TCREATESTRUCT;
alias CREATESTRUCT* PCREATESTRUCT;

struct CBT_CREATEWND
{
 LPCREATESTRUCT lpcs;
 HWND hwndInsertAfter;
}

alias CBT_CREATEWND TAGCBT_CREATEWND;
alias CBT_CREATEWND TCBT_CREATEWND;
alias CBT_CREATEWND* PCBT_CREATEWND;

struct CBTACTIVATESTRUCT
{
 WINBOOL fMouse;
 HWND hWndActive;
}

alias CBTACTIVATESTRUCT TAGCBTACTIVATESTRUCT;
alias CBTACTIVATESTRUCT TCBTACTIVATESTRUCT;
alias CBTACTIVATESTRUCT* PCBTACTIVATESTRUCT;

struct CHAR_INFO
{

 union
 {
  struct
  {
   WCHAR UnicodeChar;
   ushort Attributes;
  }
  struct
  {
   char AsciiChar;
  }
 }
}

alias CHAR_INFO _CHAR_INFO;
alias CHAR_INFO TCHAR_INFO;
alias CHAR_INFO* PCHAR_INFO;

struct CHARFORMAT
{
 UINT cbSize;
 DWORD dwMask;
 DWORD dwEffects;
 LONG yHeight;
 LONG yOffset;
 COLORREF crTextColor;
 ubyte bCharSet;
 ubyte bPitchAndFamily;
 TCHAR[1 + LF_FACESIZE-1] szFaceName;
}

alias CHARFORMAT _CHARFORMAT;
alias CHARFORMAT TCHARFORMAT;
alias CHARFORMAT* PCHARFORMAT;

struct CHARRANGE
{
 LONG cpMin;
 LONG cpMax;
}

alias CHARRANGE _CHARRANGE;
alias CHARRANGE TCHARRANGE;
alias CHARRANGE* PCHARRANGE;

struct CHARSET
{
 DWORD[1 + 2] aflBlock;
 DWORD flLang;
}

alias CHARSET TAGCHARSET;
alias CHARSET TCHARSET;
alias CHARSET* PCHARSET;

struct FONTSIGNATURE
{
 DWORD[1 + 3] fsUsb;
 DWORD[1 + 1] fsCsb;
}

alias FONTSIGNATURE* LPFONTSIGNATURE;
alias FONTSIGNATURE TAGFONTSIGNATURE;
alias FONTSIGNATURE TFONTSIGNATURE;
alias FONTSIGNATURE* PFONTSIGNATURE;

struct CHARSETINFO
{
 UINT ciCharset;
 UINT ciACP;
 FONTSIGNATURE fs;
}

alias CHARSETINFO* LPCHARSETINFO;
alias CHARSETINFO TCHARSETINFO;
alias CHARSETINFO* PCHARSETINFO;

struct CHOOSECOLORA 
{
 DWORD  lStructSize;
 HWND   hwndOwner;
 HWND   hInstance;
 COLORREF  rgbResult;
 COLORREF* lpCustColors;
 DWORD  Flags;
 LPARAM    lCustData;
 LPCCHOOKPROC lpfnHook;
 LPCSTR   lpTemplateName;
}
alias CHOOSECOLORA* PCHOOSECOLORA, LPCHOOSECOLORA;
struct CHOOSECOLORW 
{
 DWORD  lStructSize;
 HWND   hwndOwner;
 HWND   hInstance;
 COLORREF  rgbResult;
 COLORREF* lpCustColors;
 DWORD  Flags;
 LPARAM    lCustData;
 LPCCHOOKPROC lpfnHook;
 LPCWSTR   lpTemplateName;
}
alias CHOOSECOLORW* PCHOOSECOLORW, LPCHOOSECOLORW;
version(Win32SansUnicode)
{
 alias CHOOSECOLORA CHOOSECOLOR;
}
else
{
 alias CHOOSECOLORW CHOOSECOLOR;
}
alias CHOOSECOLOR* PCHOOSECOLOR, LPCHOOSECOLOR;

struct LOGFONTA
{
 LONG lfHeight;
 LONG lfWidth;
 LONG lfEscapement;
 LONG lfOrientation;
 LONG lfWeight;
 ubyte lfItalic;
 ubyte lfUnderline;
 ubyte lfStrikeOut;
 ubyte lfCharSet;
 ubyte lfOutPrecision;
 ubyte lfClipPrecision;
 ubyte lfQuality;
 ubyte lfPitchAndFamily;
 ubyte[1 + LF_FACESIZE-1] lfFaceName;
}

alias LOGFONTA  TLOGFONTA;
alias LOGFONTA* PLOGFONTA;
alias LOGFONTA* LPLOGFONTA;

struct LOGFONTW
{
 LONG lfHeight;
 LONG lfWidth;
 LONG lfEscapement;
 LONG lfOrientation;
 LONG lfWeight;
 ubyte lfItalic;
 ubyte lfUnderline;
 ubyte lfStrikeOut;
 ubyte lfCharSet;
 ubyte lfOutPrecision;
 ubyte lfClipPrecision;
 ubyte lfQuality;
 ubyte lfPitchAndFamily;
 WCHAR lfFaceName[LF_FACESIZE] = 0;
};

alias LOGFONTW  TLOGFONTW;
alias LOGFONTW* LPLOGFONTW;
alias LOGFONTW* PLOGFONTW;

version( Win32SansUnicode ){
 alias LOGFONTA  LOGFONT;
 alias LOGFONTA  TLOGFONT;
 alias LOGFONTA* PLOGFONT;
 alias LOGFONTA* LPLOGFONT;
}
else{
 alias LOGFONTW  LOGFONT;
 alias LOGFONTW  TLOGFONT;
 alias LOGFONTW* PLOGFONT;
 alias LOGFONTW* LPLOGFONT;
}

struct CHOOSEFONTA 
{
 DWORD  lStructSize;
 HWND   hwndOwner;
 HDC    hDC;
 LPLOGFONTA   lpLogFont;
 INT    iPointSize;
 DWORD  Flags;
 DWORD  rgbColors;
 LPARAM    lCustData;
 LPCFHOOKPROC lpfnHook;
 LPCSTR    lpTemplateName;
 HINSTANCE hInstance;
 LPSTR  lpszStyle;
 WORD   nFontType;
 WORD   ___MISSING_ALIGNMENT__;
 INT    nSizeMin;
 INT    nSizeMax;
}
alias CHOOSEFONTA* PCHOOSEFONTA;
alias CHOOSEFONTA* LPCHOOSEFONTA;

struct CHOOSEFONTW 
{
 DWORD  lStructSize;
 HWND   hwndOwner;
 HDC    hDC;
 LOGFONTW* lpLogFont;
 INT    iPointSize;
 DWORD  Flags;
 DWORD  rgbColors;
 LPARAM    lCustData;
 LPCFHOOKPROC lpfnHook;
 LPCWSTR   lpTemplateName;
 HINSTANCE hInstance;
 LPWSTR    lpszStyle;
 WORD   nFontType;
 WORD   ___MISSING_ALIGNMENT__;
 INT    nSizeMin;
 INT    nSizeMax;
}
alias CHOOSEFONTW* PCHOOSEFONTW;
alias CHOOSEFONTW* LPCHOOSEFONTW;

version(Win32SansUnicode){
 alias CHOOSEFONTA CHOOSEFONT;
}else{
 alias CHOOSEFONTW CHOOSEFONT;
}

alias CHOOSEFONT* LPCHOOSEFONT;
alias CHOOSEFONT* PCHOOSEFONT;
alias CHOOSEFONT TCHOOSEFONT;

struct CIDA
{
 UINT cidl;
 UINT[1 + 0] aoffset;
}

alias CIDA* LPIDA;
alias CIDA _IDA;
alias CIDA TIDA;
alias CIDA* PIDA;

struct CLIENTCREATESTRUCT
{
 HANDLE hWindowMenu;
 UINT idFirstChild;
}

alias CLIENTCREATESTRUCT* LPCLIENTCREATESTRUCT;
alias CLIENTCREATESTRUCT TAGCLIENTCREATESTRUCT;
alias CLIENTCREATESTRUCT TCLIENTCREATESTRUCT;
alias CLIENTCREATESTRUCT* PCLIENTCREATESTRUCT;

struct CMINVOKECOMMANDINFO
{
 DWORD cbSize;
 DWORD fMask;
 HWND hwnd;
 LPCSTR lpVerb;
 LPCSTR lpParameters;
 LPCSTR lpDirectory;
 int nShow;
 DWORD dwHotKey;
 HANDLE hIcon;
}

alias CMINVOKECOMMANDINFO* LPCMINVOKECOMMANDINFO;
alias CMINVOKECOMMANDINFO _CMINVOKECOMMANDINFO;
alias CMINVOKECOMMANDINFO TCMINVOKECOMMANDINFO;
alias CMINVOKECOMMANDINFO* PCMINVOKECOMMANDINFO;

struct COLORADJUSTMENT
{
 ushort caSize;
 ushort caFlags;
 ushort caIlluminantIndex;
 ushort caRedGamma;
 ushort caGreenGamma;
 ushort caBlueGamma;
 ushort caReferenceBlack;
 ushort caReferenceWhite;
 SHORT caContrast;
 SHORT caBrightness;
 SHORT caColorfulness;
 SHORT caRedGreenTint;
}

alias COLORADJUSTMENT* LPCOLORADJUSTMENT;
alias COLORADJUSTMENT TAGCOLORADJUSTMENT;
alias COLORADJUSTMENT TCOLORADJUSTMENT;
alias COLORADJUSTMENT* PCOLORADJUSTMENT;

struct COLORMAP
{
 COLORREF from;
 COLORREF _to;
}

alias COLORMAP* LPCOLORMAP;
alias COLORMAP _COLORMAP;
alias COLORMAP TCOLORMAP;
alias COLORMAP* PCOLORMAP;

struct DCB
{
 DWORD DCBlength;
 DWORD BaudRate;
 int flag0;
 ushort wReserved;
 ushort XonLim;
 ushort XoffLim;
 ubyte ByteSize;
 ubyte Parity;
 ubyte StopBits;
 char XonChar;
 char XoffChar;
 char ErrorChar;
 char EofChar;
 char EvtChar;
 ushort wReserved1;
}

alias DCB* LPDCB;
alias DCB _DCB;
alias DCB TDCB;
alias DCB* PDCB;

enum : DWORD 
{
 bm_DCB_fBinary = (0x1),
 bp_DCB_fBinary = (0),
 bm_DCB_fParity = (0x2),
 bp_DCB_fParity = (1),
 bm_DCB_fOutxCtsFlow = (0x4),
 bp_DCB_fOutxCtsFlow = (2),
 bm_DCB_fOutxDsrFlow = (0x8),
 bp_DCB_fOutxDsrFlow = (3),
 bm_DCB_fDtrControl = (0x30),
 bp_DCB_fDtrControl = (4),
 bm_DCB_fDsrSensitivity = (0x40),
 bp_DCB_fDsrSensitivity = (6),
 bm_DCB_fTXContinueOnXoff = (0x80),
 bp_DCB_fTXContinueOnXoff = (7),
 bm_DCB_fOutX = (0x100),
 bp_DCB_fOutX = (8),
 bm_DCB_fInX = (0x200),
 bp_DCB_fInX = (9),
 bm_DCB_fErrorChar = (0x400),
 bp_DCB_fErrorChar = (10),
 bm_DCB_fNull = (0x800),
 bp_DCB_fNull = (11),
 bm_DCB_fRtsControl = (0x3000),
 bp_DCB_fRtsControl = (12),
 bm_DCB_fAbortOnError = (0x4000),
 bp_DCB_fAbortOnError = (14),
 bm_DCB_fDummy2 = (0xFFFF8000),
 bp_DCB_fDummy2 = (15),
}

struct COMMCONFIG
{
 DWORD dwSize;
 ushort wVersion;
 ushort wReserved;
 DCB dcb;
 DWORD dwProviderSubType;
 DWORD dwProviderOffset;
 DWORD dwProviderSize;
 WCHAR[1 + 0] wcProviderData;
}

alias COMMCONFIG* LPCOMMCONFIG;
alias COMMCONFIG _COMM_CONFIG;
alias COMMCONFIG TCOMMCONFIG;
alias COMMCONFIG* PCOMMCONFIG;

struct COMMPROP
{
 ushort wPacketLength;
 ushort wPacketVersion;
 DWORD dwServiceMask;
 DWORD dwReserved1;
 DWORD dwMaxTxQueue;
 DWORD dwMaxRxQueue;
 DWORD dwMaxBaud;
 DWORD dwProvSubType;
 DWORD dwProvCapabilities;
 DWORD dwSettableParams;
 DWORD dwSettableBaud;
 ushort wSettableData;
 ushort wSettableStopParity;
 DWORD dwCurrentTxQueue;
 DWORD dwCurrentRxQueue;
 DWORD dwProvSpec1;
 DWORD dwProvSpec2;
 WCHAR[1 + 0] wcProvChar;
}

alias COMMPROP* LPCOMMPROP;
alias COMMPROP _COMMPROP;
alias COMMPROP TCOMMPROP;
alias COMMPROP* PCOMMPROP;

struct COMMTIMEOUTS
{
 DWORD ReadIntervalTimeout;
 DWORD ReadTotalTimeoutMultiplier;
 DWORD ReadTotalTimeoutConstant;
 DWORD WriteTotalTimeoutMultiplier;
 DWORD WriteTotalTimeoutConstant;
}

alias COMMTIMEOUTS* LPCOMMTIMEOUTS;
alias COMMTIMEOUTS _COMMTIMEOUTS;
alias COMMTIMEOUTS TCOMMTIMEOUTS;
alias COMMTIMEOUTS* PCOMMTIMEOUTS;

struct COMPAREITEMSTRUCT
{
 UINT CtlType;
 UINT CtlID;
 HWND hwndItem;
 UINT itemID1;
 ULONG_PTR itemData1;
 UINT itemID2;
 ULONG_PTR itemData2;
 DWORD dwLocaleId;
}

alias COMPAREITEMSTRUCT TAGCOMPAREITEMSTRUCT;
alias COMPAREITEMSTRUCT TCOMPAREITEMSTRUCT;
alias COMPAREITEMSTRUCT* PCOMPAREITEMSTRUCT;

struct COMPCOLOR
{
 COLORREF crText;
 COLORREF crBackground;
 DWORD dwEffects;
}

alias COMPCOLOR TCOMPCOLOR;
alias COMPCOLOR* PCOMPCOLOR;

struct COMPOSITIONFORM
{
 DWORD dwStyle;
 POINT ptCurrentPos;
 RECT rcArea;
}

alias COMPOSITIONFORM* LPCOMPOSITIONFORM;
alias COMPOSITIONFORM _TAGCOMPOSITIONFORM;
alias COMPOSITIONFORM TCOMPOSITIONFORM;
alias COMPOSITIONFORM* PCOMPOSITIONFORM;

struct COMSTAT
{
 int flag0;
 DWORD cbInQue;
 DWORD cbOutQue;
}

alias COMSTAT* LPCOMSTAT;
alias COMSTAT _COMSTAT;
alias COMSTAT TCOMSTAT;
alias COMSTAT* PCOMSTAT;
enum : DWORD {
 bm_COMSTAT_fCtsHold = (0x1),
 bp_COMSTAT_fCtsHold = (0),
 bm_COMSTAT_fDsrHold = (0x2),
 bp_COMSTAT_fDsrHold = (1),
 bm_COMSTAT_fRlsdHold = (0x4),
 bp_COMSTAT_fRlsdHold = (2),
 bm_COMSTAT_fXoffHold = (0x8),
 bp_COMSTAT_fXoffHold = (3),
 bm_COMSTAT_fXoffSent = (0x10),
 bp_COMSTAT_fXoffSent = (4),
 bm_COMSTAT_fEof = (0x20),
 bp_COMSTAT_fEof = (5),
 bm_COMSTAT_fTxim = (0x40),
 bp_COMSTAT_fTxim = (6),
 bm_COMSTAT_fReserved = (0xFFFFFF80),
 bp_COMSTAT_fReserved = (7),
}
struct CONSOLE_CURSOR_INFO
{
 DWORD dwSize;
 WINBOOL bVisible;
}

alias CONSOLE_CURSOR_INFO* PCONSOLE_CURSOR_INFO;
alias CONSOLE_CURSOR_INFO _CONSOLE_CURSOR_INFO;
alias CONSOLE_CURSOR_INFO TCONSOLECURSORINFO;
alias CONSOLE_CURSOR_INFO* PCONSOLECURSORINFO;
alias CONSOLE_CURSOR_INFO TCURSORINFO;

struct COORD
{
 SHORT X;
 SHORT Y;
}

alias COORD _COORD;
alias COORD TCOORD;
alias COORD* PCOORD;

struct SMALL_RECT
{
 SHORT Left;
 SHORT Top;
 SHORT Right;
 SHORT Bottom;
}

alias SMALL_RECT _SMALL_RECT;
alias SMALL_RECT TSMALL_RECT;
alias SMALL_RECT* PSMALL_RECT;

align(1) struct CONSOLE_SCREEN_BUFFER_INFO
{
 COORD dwSize;
 COORD dwCursorPosition;
 ushort wAttributes;
 SMALL_RECT srWindow;
 COORD dwMaximumWindowSize;
}

alias CONSOLE_SCREEN_BUFFER_INFO* PCONSOLE_SCREEN_BUFFER_INFO;
alias CONSOLE_SCREEN_BUFFER_INFO _CONSOLE_SCREEN_BUFFER_INFO;
alias CONSOLE_SCREEN_BUFFER_INFO TCONSOLESCREENBUFFERINFO;
alias CONSOLE_SCREEN_BUFFER_INFO* PCONSOLESCREENBUFFERINFO;

struct FLOATING_SAVE_AREA
{
 DWORD ControlWord;
 DWORD StatusWord;
 DWORD TagWord;
 DWORD ErrorOffset;
 DWORD ErrorSelector;
 DWORD DataOffset;
 DWORD DataSelector;
 ubyte[1 + 79] RegisterArea;
 DWORD Cr0NpxState;
}

alias FLOATING_SAVE_AREA _FLOATING_SAVE_AREA;
alias FLOATING_SAVE_AREA TFLOATINGSAVEAREA;
alias FLOATING_SAVE_AREA* PFLOATINGSAVEAREA;

enum : DWORD
{
//
// The following flags control the contents of the CONTEXT structure.
//
 CONTEXT_i386 = 0x00010000, // this assumes that i386 and
 CONTEXT_i486 = 0x00010000, // i486 have identical context records

 CONTEXT_CONTROL =   (CONTEXT_i386 | 0x00000001), // SS:SP, CS:IP, FLAGS, BP
 CONTEXT_INTEGER =   (CONTEXT_i386 | 0x00000002), // AX, BX, CX, DX, SI, DI
 CONTEXT_SEGMENTS =  (CONTEXT_i386 | 0x00000004), // DS, ES, FS, GS
 CONTEXT_FLOATING_POINT =  (CONTEXT_i386 | 0x00000008), // 387 state
 CONTEXT_DEBUG_REGISTERS = (CONTEXT_i386 | 0x00000010), // DB 0-3,6,7

 CONTEXT_FULL = (CONTEXT_CONTROL | CONTEXT_INTEGER | CONTEXT_SEGMENTS),
}

struct CONTEXT
{
 DWORD ContextFlags;
 DWORD Dr0;
 DWORD Dr1;
 DWORD Dr2;
 DWORD Dr3;
 DWORD Dr6;
 DWORD Dr7;
 FLOATING_SAVE_AREA FloatSave;
 DWORD SegGs;
 DWORD SegFs;
 DWORD SegEs;
 DWORD SegDs;
 DWORD Edi;
 DWORD Esi;
 DWORD Ebx;
 DWORD Edx;
 DWORD Ecx;
 DWORD Eax;
 DWORD Ebp;
 DWORD Eip;
 DWORD SegCs;
 DWORD EFlags;
 DWORD Esp;
 DWORD SegSs;
}

alias CONTEXT* LPCONTEXT;
alias CONTEXT _CONTEXT;
alias CONTEXT TCONTEXT;
alias CONTEXT* PCONTEXT;

struct LIST_ENTRY
{
 _LIST_ENTRY* Flink;
 _LIST_ENTRY* Blink;
}

alias LIST_ENTRY _LIST_ENTRY;
alias LIST_ENTRY TLISTENTRY;
alias LIST_ENTRY* PLISTENTRY;

align(1) struct CRITICAL_SECTION_DEBUG
{
 WORD _Type;
 WORD CreatorBackTraceIndex;
 _CRITICAL_SECTION* CriticalSection;
 LIST_ENTRY ProcessLocksList;
 DWORD EntryCount;
 DWORD ContentionCount;
 DWORD Flags;
 WORD   CreatorBackTraceIndexHigh;
 WORD   SpareWORD  ;
}

alias CRITICAL_SECTION_DEBUG* LPCRITICAL_SECTION_DEBUG;
alias CRITICAL_SECTION_DEBUG* PCRITICAL_SECTION_DEBUG;
alias CRITICAL_SECTION_DEBUG _CRITICAL_SECTION_DEBUG;
alias CRITICAL_SECTION_DEBUG TCRITICALSECTIONDEBUG;
alias CRITICAL_SECTION_DEBUG* PCRITICALSECTIONDEBUG;

align(1) struct CRITICAL_SECTION
{
 PCRITICAL_SECTION_DEBUG DebugInfo;
 LONG LockCount;
 LONG RecursionCount;
 HANDLE OwningThread;
 HANDLE LockSemaphore;
 DWORD Reserved;
}

alias CRITICAL_SECTION* LPCRITICAL_SECTION;
alias CRITICAL_SECTION* PCRITICAL_SECTION;
alias CRITICAL_SECTION _CRITICAL_SECTION;
alias CRITICAL_SECTION TCRITICALSECTION;
alias CRITICAL_SECTION* PCRITICALSECTION;

alias ubyte SECURITY_CONTEXT_TRACKING_MODE;
struct SECURITY_QUALITY_OF_SERVICE
{
 DWORD Length;
 SECURITY_IMPERSONATION_LEVEL ImpersonationLevel;
 SECURITY_CONTEXT_TRACKING_MODE ContextTrackingMode;
 BOOLEAN EffectiveOnly;
}

alias SECURITY_QUALITY_OF_SERVICE* PSECURITY_QUALITY_OF_SERVICE;
alias SECURITY_QUALITY_OF_SERVICE _SECURITY_QUALITY_OF_SERVICE;
alias SECURITY_QUALITY_OF_SERVICE TSECURITYQUALITYOFSERVICE;
alias SECURITY_QUALITY_OF_SERVICE* PSECURITYQUALITYOFSERVICE;

struct CONVCONTEXT
{
 UINT cb;
 UINT wFlags;
 UINT wCountryID;
 int iCodePage;
 DWORD dwLangID;
 DWORD dwSecurity;
 SECURITY_QUALITY_OF_SERVICE qos;
}

alias CONVCONTEXT TAGCONVCONTEXT;
alias CONVCONTEXT TCONVCONTEXT;
alias CONVCONTEXT* PCONVCONTEXT;

struct CONVINFO
{
 DWORD cb;
 DWORD hUser;
 HCONV hConvPartner;
 HSZ hszSvcPartner;
 HSZ hszServiceReq;
 HSZ hszTopic;
 HSZ hszItem;
 UINT wFmt;
 UINT wType;
 UINT wStatus;
 UINT wConvst;
 UINT wLastError;
 HCONVLIST hConvList;
 CONVCONTEXT ConvCtxt;
 HWND _hwnd;
 HWND hwndPartner;
}

alias CONVINFO TAGCONVINFO;
alias CONVINFO TCONVINFO;
alias CONVINFO* PCONVINFO;

struct COPYDATASTRUCT
{
 DWORD dwData;
 DWORD cbData;
 PVOID lpData;
}

alias COPYDATASTRUCT TAGCOPYDATASTRUCT;
alias COPYDATASTRUCT TCOPYDATASTRUCT;
alias COPYDATASTRUCT* PCOPYDATASTRUCT;

struct CPINFO
{
 UINT MaxCharSize;
 ubyte[1 + MAX_DEFAULTCHAR-1] DefaultChar;
 ubyte[1 + MAX_LEADBYTES-1] LeadByte;
}

alias CPINFO* LPCPINFO;
alias CPINFO _CPINFO;
alias CPINFO TCPINFO;
alias CPINFO* PCPINFO;

struct CPLINFO
{
 int idIcon;
 int idName;
 int idInfo;
 LONG lData;
}

alias CPLINFO TAGCPLINFO;
alias CPLINFO TCPLINFO;
alias CPLINFO* PCPLINFO;

struct CREATE_PROCESS_DEBUG_INFO
{
 HANDLE hFile;
 HANDLE hProcess;
 HANDLE hThread;
 LPVOID lpBaseOfImage;
 DWORD dwDebugInfoFileOffset;
 DWORD nDebugInfoSize;
 LPVOID lpThreadLocalBase;
 LPTHREAD_START_ROUTINE lpStartAddress;
 LPVOID lpImageName;
 ushort fUnicode;
}

alias CREATE_PROCESS_DEBUG_INFO _CREATE_PROCESS_DEBUG_INFO;
alias CREATE_PROCESS_DEBUG_INFO TCREATEPROCESSDEBUGINFO;
alias CREATE_PROCESS_DEBUG_INFO* PCREATEPROCESSDEBUGINFO;

struct CREATE_THREAD_DEBUG_INFO
{
 HANDLE hThread;
 LPVOID lpThreadLocalBase;
 LPTHREAD_START_ROUTINE lpStartAddress;
}

alias CREATE_THREAD_DEBUG_INFO _CREATE_THREAD_DEBUG_INFO;
alias CREATE_THREAD_DEBUG_INFO TCREATETHREADDEBUGINFO;
alias CREATE_THREAD_DEBUG_INFO* PCREATETHREADDEBUGINFO;

struct CURRENCYFMT
{
 UINT NumDigits;
 UINT LeadingZero;
 UINT Grouping;
 LPTSTR lpDecimalSep;
 LPTSTR lpThousandSep;
 UINT NegativeOrder;
 UINT PositiveOrder;
 LPTSTR lpCurrencySymbol;
}

alias CURRENCYFMT _CURRENCYFMT;
alias CURRENCYFMT TCURRENCYFMT;
alias CURRENCYFMT* PCURRENCYFMT;

struct CURSORSHAPE
{
 int xHotSpot;
 int yHotSpot;
 int cx;
 int cy;
 int cbWidth;
 ubyte Planes;
 ubyte BitsPixel;
}

alias CURSORSHAPE* LPCURSORSHAPE;
alias CURSORSHAPE TAGCURSORSHAPE;
alias CURSORSHAPE TCURSORSHAPE;
alias CURSORSHAPE* PCURSORSHAPE;

struct CWPRETSTRUCT
{
 LRESULT lResult;
 LPARAM lParam;
 WPARAM wParam;
 DWORD message;
 HWND hwnd;
}

alias CWPRETSTRUCT TAGCWPRETSTRUCT;
alias CWPRETSTRUCT TCWPRETSTRUCT;
alias CWPRETSTRUCT* PCWPRETSTRUCT;

struct CWPSTRUCT
{
 LPARAM lParam;
 WPARAM wParam;
 UINT message;
 HWND hwnd;
}

alias CWPSTRUCT TAGCWPSTRUCT;
alias CWPSTRUCT TCWPSTRUCT;
alias CWPSTRUCT* PCWPSTRUCT;

struct DATATYPES_INFO_1
{
 LPTSTR pName;
}

alias DATATYPES_INFO_1 _DATATYPES_INFO_1;
alias DATATYPES_INFO_1 TDATATYPESINFO1;
alias DATATYPES_INFO_1* PDATATYPESINFO1;

struct DDEACK
{
 ushort flag0;
}

alias DDEACK TDDEACK;
alias DDEACK* PDDEACK;
enum : DWORD 
{
 bm_DDEACK_bAppReturnCode = (0xFF),
 bp_DDEACK_bAppReturnCode = (0),
 bm_DDEACK_reserved = (0x3F00),
 bp_DDEACK_reserved = (8),
 bm_DDEACK_fBusy = (0x4000),
 bp_DDEACK_fBusy = (14),
 bm_DDEACK_fAck = (0x8000),
 bp_DDEACK_fAck = (15),
}

struct DDEADVISE
{
 ushort flag0;
 short cfFormat;
}

alias DDEADVISE TDDEADVISE;
alias DDEADVISE* PDDEADVISE;
enum : DWORD {
 bm_DDEADVISE_reserved = (0x3FFF),
 bp_DDEADVISE_reserved = (0),
 bm_DDEADVISE_fDeferUpd = (0x4000),
 bp_DDEADVISE_fDeferUpd = (14),
 bm_DDEADVISE_fAckReq = (0x8000),
 bp_DDEADVISE_fAckReq = (15),
}

struct DDEDATA
{
 ushort flag0;
 short  cfFormat;
 ubyte[1 + 0] Value;
}

alias DDEDATA* PDDEDATA;
enum : DWORD 
{
 bm_DDEDATA_unused = (0xFFF),
 bp_DDEDATA_unused = (0),
 bm_DDEDATA_fResponse = (0x1000),
 bp_DDEDATA_fResponse = (12),
 bm_DDEDATA_fRelease = (0x2000),
 bp_DDEDATA_fRelease = (13),
 bm_DDEDATA_reserved = (0x4000),
 bp_DDEDATA_reserved = (14),
 bm_DDEDATA_fAckReq = (0x8000),
 bp_DDEDATA_fAckReq = (15),
}

struct DDELN
{
 ushort flag0;
 short cfFormat;
}

alias DDELN TDDELN;
alias DDELN* PDDELN;
enum : DWORD 
{
 bm_DDELN_unused = (0x1FFF),
 bp_DDELN_unused = (0),
 bm_DDELN_fRelease = (0x2000),
 bp_DDELN_fRelease = (13),
 bm_DDELN_fDeferUpd = (0x4000),
 bp_DDELN_fDeferUpd = (14),
 bm_DDELN_fAckReq = (0x8000),
 bp_DDELN_fAckReq = (15),
}

struct DDEML_MSG_HOOK_DATA
{
 UINT uiLo;
 UINT uiHi;
 DWORD cbData;
 DWORD[1 + 7] Data;
}

alias DDEML_MSG_HOOK_DATA TAGDDEML_MSG_HOOK_DATA;
alias DDEML_MSG_HOOK_DATA TDDEMLMSGHOOKDATA;
alias DDEML_MSG_HOOK_DATA* PDDEMLMSGHOOKDATA;

struct DDEPOKE
{
 ushort flag0;
 short cfFormat;
 ubyte[1 + 0] Value;
}

alias DDEPOKE TDDEPOKE;
alias DDEPOKE* PDDEPOKE;
enum : DWORD 
{
 bm_DDEPOKE_unused = (0x1FFF),
 bp_DDEPOKE_unused = (0),
 bm_DDEPOKE_fRelease = (0x2000),
 bp_DDEPOKE_fRelease = (13),
 bm_DDEPOKE_fReserved = (0xC000),
 bp_DDEPOKE_fReserved = (14),
}
struct DDEUP
{
 ushort flag0;
 short cfFormat;
 ubyte[1 + 0] rgb;
}

alias DDEUP TDDEUP;
alias DDEUP* PDDEUP;

enum : DWORD 
{
 bm_DDEUP_unused = (0xFFF),
 bp_DDEUP_unused = (0),
 bm_DDEUP_fAck = (0x1000),
 bp_DDEUP_fAck = (12),
 bm_DDEUP_fRelease = (0x2000),
 bp_DDEUP_fRelease = (13),
 bm_DDEUP_fReserved = (0x4000),
 bp_DDEUP_fReserved = (14),
 bm_DDEUP_fAckReq = (0x8000),
 bp_DDEUP_fAckReq = (15),
}

struct EXCEPTION_RECORD
{
 DWORD ExceptionCode;
 DWORD ExceptionFlags;
 _EXCEPTION_RECORD* ExceptionRecord;
 PVOID ExceptionAddress;
 DWORD NumberParameters;
 DWORD[1 + EXCEPTION_MAXIMUM_PARAMETERS-1] ExceptionInformation;
}

alias EXCEPTION_RECORD* PEXCEPTION_RECORD;
alias EXCEPTION_RECORD _EXCEPTION_RECORD;
alias EXCEPTION_RECORD TEXCEPTIONRECORD;
alias EXCEPTION_RECORD* PEXCEPTIONRECORD;

struct EXCEPTION_DEBUG_INFO
{
 EXCEPTION_RECORD ExceptionRecord;
 DWORD dwFirstChance;
}

alias EXCEPTION_DEBUG_INFO* PEXCEPTION_DEBUG_INFO;
alias EXCEPTION_DEBUG_INFO _EXCEPTION_DEBUG_INFO;
alias EXCEPTION_DEBUG_INFO TEXCEPTIONDEBUGINFO;
alias EXCEPTION_DEBUG_INFO* PEXCEPTIONDEBUGINFO;

struct EXIT_PROCESS_DEBUG_INFO
{
 DWORD dwExitCode;
}

alias EXIT_PROCESS_DEBUG_INFO _EXIT_PROCESS_DEBUG_INFO;
alias EXIT_PROCESS_DEBUG_INFO TEXITPROCESSDEBUGINFO;
alias EXIT_PROCESS_DEBUG_INFO* PEXITPROCESSDEBUGINFO;

struct EXIT_THREAD_DEBUG_INFO
{
 DWORD dwExitCode;
}

alias EXIT_THREAD_DEBUG_INFO _EXIT_THREAD_DEBUG_INFO;
alias EXIT_THREAD_DEBUG_INFO TEXITTHREADDEBUGINFO;
alias EXIT_THREAD_DEBUG_INFO* PEXITTHREADDEBUGINFO;

struct LOAD_DLL_DEBUG_INFO
{
 HANDLE hFile;
 LPVOID lpBaseOfDll;
 DWORD dwDebugInfoFileOffset;
 DWORD nDebugInfoSize;
 LPVOID lpImageName;
 ushort fUnicode;
}

alias LOAD_DLL_DEBUG_INFO _LOAD_DLL_DEBUG_INFO;
alias LOAD_DLL_DEBUG_INFO TLOADDLLDEBUGINFO;
alias LOAD_DLL_DEBUG_INFO* PLOADDLLDEBUGINFO;

struct UNLOAD_DLL_DEBUG_INFO
{
 LPVOID lpBaseOfDll;
}

alias UNLOAD_DLL_DEBUG_INFO _UNLOAD_DLL_DEBUG_INFO;
alias UNLOAD_DLL_DEBUG_INFO TUNLOADDLLDEBUGINFO;
alias UNLOAD_DLL_DEBUG_INFO* PUNLOADDLLDEBUGINFO;

struct OUTPUT_DEBUG_STRING_INFO
{
 LPSTR lpDebugStringData;
 ushort fUnicode;
 ushort nDebugStringLength;
}

alias OUTPUT_DEBUG_STRING_INFO _OUTPUT_DEBUG_STRING_INFO;
alias OUTPUT_DEBUG_STRING_INFO TOUTPUTDEBUGSTRINGINFO;
alias OUTPUT_DEBUG_STRING_INFO* POUTPUTDEBUGSTRINGINFO;

struct RIP_INFO
{
 DWORD dwError;
 DWORD dwType;
}

alias RIP_INFO _RIP_INFO;
alias RIP_INFO TRIPINFO;
alias RIP_INFO* PRIPINFO;

struct DEBUG_EVENT
{
 DWORD dwDebugEventCode;
 DWORD dwProcessId;
 DWORD dwThreadId;

 union
 {
  struct
  {
   EXCEPTION_DEBUG_INFO Exception;
  }
  struct
  {
   CREATE_THREAD_DEBUG_INFO CreateThread;
  }
  struct
  {
   CREATE_PROCESS_DEBUG_INFO CreateProcessInfo;
  }
  struct
  {
   EXIT_THREAD_DEBUG_INFO ExitThread;
  }
  struct
  {
   EXIT_PROCESS_DEBUG_INFO ExitProcess;
  }
  struct
  {
   LOAD_DLL_DEBUG_INFO LoadDll;
  }
  struct
  {
   UNLOAD_DLL_DEBUG_INFO UnloadDll;
  }
  struct
  {
   OUTPUT_DEBUG_STRING_INFO DebugString;
  }
  struct
  {
   RIP_INFO RipInfo;
  }
 }
}

alias DEBUG_EVENT* LPDEBUG_EVENT;
alias DEBUG_EVENT _DEBUG_EVENT;
alias DEBUG_EVENT TDEBUGEVENT;
alias DEBUG_EVENT* PDEBUGEVENT;

struct DEBUGHOOKINFO
{
 DWORD idThread;
 DWORD idThreadInstaller;
 LPARAM lParam;
 WPARAM wParam;
 int code;
}

alias DEBUGHOOKINFO TAGDEBUGHOOKINFO;
alias DEBUGHOOKINFO TDEBUGHOOKINFO;
alias DEBUGHOOKINFO* PDEBUGHOOKINFO;

struct DELETEITEMSTRUCT
{
 UINT CtlType;
 UINT CtlID;
 UINT itemID;
 HWND hwndItem;
 UINT itemData;
}

alias DELETEITEMSTRUCT TAGDELETEITEMSTRUCT;
alias DELETEITEMSTRUCT TDELETEITEMSTRUCT;
alias DELETEITEMSTRUCT* PDELETEITEMSTRUCT;

struct DEV_BROADCAST_HDR
{
 ULONG dbch_size;
 ULONG dbch_devicetype;
 ULONG dbch_reserved;
}

alias DEV_BROADCAST_HDR* PDEV_BROADCAST_HDR;
alias DEV_BROADCAST_HDR _DEV_BROADCAST_HDR;
alias DEV_BROADCAST_HDR TDEVBROADCASTHDR;
alias DEV_BROADCAST_HDR* PDEVBROADCASTHDR;

struct DEV_BROADCAST_OEM
{
 ULONG dbco_size;
 ULONG dbco_devicetype;
 ULONG dbco_reserved;
 ULONG dbco_identifier;
 ULONG dbco_suppfunc;
}

alias DEV_BROADCAST_OEM* PDEV_BROADCAST_OEM;
alias DEV_BROADCAST_OEM _DEV_BROADCAST_OEM;
alias DEV_BROADCAST_OEM TDEVBROADCASTOEM;
alias DEV_BROADCAST_OEM* PDEVBROADCASTOEM;

struct DEV_BROADCAST_PORT
{
 ULONG dbcp_size;
 ULONG dbcp_devicetype;
 ULONG dbcp_reserved;
 char[1 + 0] dbcp_name;
}

alias DEV_BROADCAST_PORT* PDEV_BROADCAST_PORT;
alias DEV_BROADCAST_PORT _DEV_BROADCAST_PORT;
alias DEV_BROADCAST_PORT TDEVBROADCASTPORT;
alias DEV_BROADCAST_PORT* PDEVBROADCASTPORT;

struct _DEV_BROADCAST_USERDEFINED
{
 _DEV_BROADCAST_HDR dbud_dbh;
 char[1 + 0] dbud_szName;
 ubyte[1 + 0] dbud_rgbUserDefined;
}

alias _DEV_BROADCAST_USERDEFINED TDEVBROADCASTUSERDEFINED;
alias _DEV_BROADCAST_USERDEFINED* PDEVBROADCASTUSERDEFINED;

struct DEV_BROADCAST_VOLUME
{
 ULONG dbcv_size;
 ULONG dbcv_devicetype;
 ULONG dbcv_reserved;
 ULONG dbcv_unitmask;
 USHORT dbcv_flags;
}

alias DEV_BROADCAST_VOLUME* PDEV_BROADCAST_VOLUME;
alias DEV_BROADCAST_VOLUME _DEV_BROADCAST_VOLUME;
alias DEV_BROADCAST_VOLUME TDEVBROADCASTVOLUME;
alias DEV_BROADCAST_VOLUME* PDEVBROADCASTVOLUME;

struct DEVMODE
{
 BCHAR[1 + CCHDEVICENAME-1] dmDeviceName;
 ushort dmSpecVersion;
 ushort dmDriverVersion;
 ushort dmSize;
 ushort dmDriverExtra;
 DWORD dmFields;
 int dmOrientation;
 int dmPaperSize;
 int dmPaperLength;
 int dmPaperWidth;
 int dmScale;
 int dmCopies;
 int dmDefaultSource;
 int dmPrintQuality;
 int dmColor;
 int dmDuplex;
 int dmYResolution;
 int dmTTOption;
 int dmCollate;
 BCHAR[1 + CCHFORMNAME-1] dmFormName;
 ushort dmLogPixels;
 DWORD dmBitsPerPel;
 DWORD dmPelsWidth;
 DWORD dmPelsHeight;
 DWORD dmDisplayFlags;
 DWORD dmDisplayFrequency;
 DWORD dmICMMethod;
 DWORD dmICMIntent;
 DWORD dmMediaType;
 DWORD dmDitherType;
 DWORD dmICCManufacturer;
 DWORD dmICCModel;
}

alias DEVMODE* LPDEVMODE;
alias DEVMODE _DEVICEMODE;
alias DEVMODE DEVICEMODE;
alias DEVMODE TDEVICEMODE;
alias DEVMODE TDEVICEMODEA;
alias DEVMODE TDEVMODE;
alias DEVMODE* PDEVMODE;

struct DEVNAMES
{
 ushort wDriverOffset;
 ushort wDeviceOffset;
 ushort wOutputOffset;
 ushort wDefault;
}

alias DEVNAMES* LPDEVNAMES;
alias DEVNAMES TAGDEVNAMES;
alias DEVNAMES TDEVNAMES;
alias DEVNAMES* PDEVNAMES;

struct DIBSECTION
{
 BITMAP dsBm;
 BITMAPINFOHEADER dsBmih;
 DWORD[1 + 2] dsBitfields;
 HANDLE dshSection;
 DWORD dsOffset;
}

alias DIBSECTION TAGDIBSECTION;
alias DIBSECTION TDIBSECTION;
alias DIBSECTION* PDIBSECTION;

union LARGE_INTEGER
{
 struct
 {
  DWORD LowPart;
  LONG HighPart;
 };
 struct u
 {
  DWORD LowPart;
  LONG HighPart;
 };
 LONGLONG QuadPart;
}

alias LARGE_INTEGER* PLARGE_INTEGER;
alias LARGE_INTEGER _LARGE_INTEGER;
alias LARGE_INTEGER TLARGEINTEGER;
alias LARGE_INTEGER* PLARGEINTEGER;

struct DISK_GEOMETRY
{
 LARGE_INTEGER Cylinders;
 MEDIA_TYPE MediaType;
 DWORD TracksPerCylinder;
 DWORD SectorsPerTrack;
 DWORD BytesPerSector;
}

alias DISK_GEOMETRY _DISK_GEOMETRY;
alias DISK_GEOMETRY TDISKGEOMETRY;
alias DISK_GEOMETRY* PDISKGEOMETRY;

struct DISK_PERFORMANCE
{
 LARGE_INTEGER BytesRead;
 LARGE_INTEGER BytesWritten;
 LARGE_INTEGER ReadTime;
 LARGE_INTEGER WriteTime;
 LARGE_INTEGER IdleTime;
 DWORD ReadCount;
 DWORD WriteCount;
 DWORD QueueDepth;
 DWORD SplitCount;
 LARGE_INTEGER QueryTime;
 DWORD StorageDeviceNumber;
 WCHAR StorageManagerName[8];
}

alias DISK_PERFORMANCE _DISK_PERFORMANCE;
alias DISK_PERFORMANCE TDISKPERFORMANCE;
alias DISK_PERFORMANCE* PDISKPERFORMANCE;

align(1) struct DLGITEMTEMPLATE
{
 DWORD style;
 DWORD dwExtendedStyle;
 short x;
 short y;
 short cx;
 short cy;
 WORD id;
}

alias DLGITEMTEMPLATE* LPDLGITEMTEMPLATE;
alias DLGITEMTEMPLATE TDLGITEMTEMPLATE;
alias DLGITEMTEMPLATE* PDLGITEMTEMPLATE;

align(1) struct DLGTEMPLATE
{
 DWORD style;
 DWORD dwExtendedStyle;
 WORD cdit;
 short x;
 short y;
 short cx;
 short cy;
}

alias DLGTEMPLATE* LPDLGTEMPLATE;
alias DLGTEMPLATE* LPCDLGTEMPLATE;
alias DLGTEMPLATE TDLGTEMPLATE;
alias DLGTEMPLATE* PDLGTEMPLATE;

struct DOC_INFO_1
{
 LPTSTR pDocName;
 LPTSTR pOutputFile;
 LPTSTR pDatatype;
}

alias DOC_INFO_1 _DOC_INFO_1;
alias DOC_INFO_1 TDOCINFO1;
alias DOC_INFO_1* PDOCINFO1;

struct DOC_INFO_2
{
 LPTSTR pDocName;
 LPTSTR pOutputFile;
 LPTSTR pDatatype;
 DWORD dwMode;
 DWORD JobId;
}

alias DOC_INFO_2 _DOC_INFO_2;
alias DOC_INFO_2 TDOCINFO2;
alias DOC_INFO_2* PDOCINFO2;

struct DOCINFOA
{
 int  cbSize;
 LPCSTR   lpszDocName;
 LPCSTR   lpszOutput;
 LPCSTR   lpszDatatype;
 DWORD fwType;
}
alias DOCINFOA TDOCINFOA;

struct DOCINFOW
{
 int  cbSize;
 LPCWSTR  lpszDocName;
 LPCWSTR  lpszOutput;
 LPCWSTR  lpszDatatype;
 DWORD fwType;
}
alias DOCINFOW TDOCINFOW;

version(Win32SansUnicode)
{
 alias DOCINFOA DOCINFO;
}
else
{
 alias DOCINFOW DOCINFO;
}
alias DOCINFO TDOCINFO;
alias DOCINFO* LPDOCINFO;
alias DOCINFO* PDOCINFO;


struct DRAGLISTINFO
{
 UINT uNotification;
 HWND hWnd;
 POINT ptCursor;
}

alias DRAGLISTINFO* LPDRAGLISTINFO;
alias DRAGLISTINFO TDRAGLISTINFO;
alias DRAGLISTINFO* PDRAGLISTINFO;

struct DRAWITEMSTRUCT
{
 UINT CtlType;
 UINT CtlID;
 UINT itemID;
 UINT itemAction;
 UINT itemState;
 HWND hwndItem;
 HDC hDC;
 RECT rcItem;
 DWORD itemData;
}

alias DRAWITEMSTRUCT* LPDRAWITEMSTRUCT;
alias DRAWITEMSTRUCT TAGDRAWITEMSTRUCT;
alias DRAWITEMSTRUCT TDRAWITEMSTRUCT;
alias DRAWITEMSTRUCT* PDRAWITEMSTRUCT;

struct DRAWTEXTPARAMS
{
 UINT cbSize;
 int iTabLength;
 int iLeftMargin;
 int iRightMargin;
 UINT uiLengthDrawn;
}

alias DRAWTEXTPARAMS* LPDRAWTEXTPARAMS;
alias DRAWTEXTPARAMS TDRAWTEXTPARAMS;
alias DRAWTEXTPARAMS* PDRAWTEXTPARAMS;

struct PARTITION_INFORMATION
{
 ubyte PartitionType;
 ubyte BootIndicator;
 ubyte RecognizedPartition;
 ubyte RewritePartition;
 LARGE_INTEGER StartingOffset;
 LARGE_INTEGER PartitionLength;
 LARGE_INTEGER HiddenSectors;
}

alias PARTITION_INFORMATION _PARTITION_INFORMATION;
alias PARTITION_INFORMATION TPARTITIONINFORMATION;
alias PARTITION_INFORMATION* PPARTITIONINFORMATION;

struct DRIVE_LAYOUT_INFORMATION
{
 DWORD PartitionCount;
 DWORD Signature;
 PARTITION_INFORMATION[1 + 0] PartitionEntry;
}

alias DRIVE_LAYOUT_INFORMATION _DRIVE_LAYOUT_INFORMATION;
alias DRIVE_LAYOUT_INFORMATION TDRIVELAYOUTINFORMATION;
alias DRIVE_LAYOUT_INFORMATION* PDRIVELAYOUTINFORMATION;

struct DRIVER_INFO_1
{
 LPTSTR pName;
}

alias DRIVER_INFO_1 _DRIVER_INFO_1;
alias DRIVER_INFO_1 TDRIVERINFO1;
alias DRIVER_INFO_1* PDRIVERINFO1;

struct DRIVER_INFO_2
{
 DWORD cVersion;
 LPTSTR pName;
 LPTSTR pEnvironment;
 LPTSTR pDriverPath;
 LPTSTR pDataFile;
 LPTSTR pConfigFile;
}

alias DRIVER_INFO_2 _DRIVER_INFO_2;
alias DRIVER_INFO_2 TDRIVERINFO2;
alias DRIVER_INFO_2* PDRIVERINFO2;

struct DRIVER_INFO_3
{
 DWORD cVersion;
 LPTSTR pName;
 LPTSTR pEnvironment;
 LPTSTR pDriverPath;
 LPTSTR pDataFile;
 LPTSTR pConfigFile;
 LPTSTR pHelpFile;
 LPTSTR pDependentFiles;
 LPTSTR pMonitorName;
 LPTSTR pDefaultDataType;
}

alias DRIVER_INFO_3 _DRIVER_INFO_3;
alias DRIVER_INFO_3 TDRIVERINFO3;
alias DRIVER_INFO_3* PDRIVERINFO3;

struct EDITSTREAM
{
 DWORD dwCookie;
 DWORD dwError;
 EDITSTREAMCALLBACK pfnCallback;
}

alias EDITSTREAM _EDITSTREAM;
alias EDITSTREAM TEDITSTREAM;
alias EDITSTREAM* PEDITSTREAM;

struct EMR
{
 DWORD iType;
 DWORD nSize;
}

alias EMR TAGEMR;
alias EMR TEMR;
alias EMR* PEMR;

struct EMRANGLEARC
{
 EMR emr;
 POINTL ptlCenter;
 DWORD nRadius;
 FLOAT eStartAngle;
 FLOAT eSweepAngle;
}

alias EMRANGLEARC TAGEMRANGLEARC;
alias EMRANGLEARC TEMRANGLEARC;
alias EMRANGLEARC* PEMRANGLEARC;

struct EMRARC
{
 EMR emr;
 RECTL rclBox;
 POINTL ptlStart;
 POINTL ptlEnd;
}

alias EMRARC TAGEMRARC;
alias EMRARC TEMRARC;
alias EMRARC* PEMRARC;
alias EMRARC EMRARCTO;
alias EMRARC TEMRARCTO;
alias EMRARC* PEMRARCTO;
alias EMRARC EMRCHORD;
alias EMRARC TEMRCHORD;
alias EMRARC* PEMRCHORD;
alias EMRARC EMRPIE;
alias EMRARC TEMRPIE;
alias EMRARC* PEMRPIE;

struct XFORM
{
 FLOAT eM11;
 FLOAT eM12;
 FLOAT eM21;
 FLOAT eM22;
 FLOAT eDx;
 FLOAT eDy;
}

alias XFORM* LPXFORM;
alias XFORM _XFORM;
alias XFORM TXFORM;
alias XFORM* PXFORM;

struct EMRBITBLT
{
 EMR emr;
 RECTL rclBounds;
 LONG xDest;
 LONG yDest;
 LONG cxDest;
 LONG cyDest;
 DWORD dwRop;
 LONG xSrc;
 LONG ySrc;
 XFORM xformSrc;
 COLORREF crBkColorSrc;
 DWORD iUsageSrc;
 DWORD offBmiSrc;
 DWORD cbBmiSrc;
 DWORD offBitsSrc;
 DWORD cbBitsSrc;
}

alias EMRBITBLT TAGEMRBITBLT;
alias EMRBITBLT TEMRBITBLT;
alias EMRBITBLT* PEMRBITBLT;

struct LOGBRUSH
{
 UINT lbStyle;
 COLORREF lbColor;
 LONG lbHatch;
}

alias LOGBRUSH TAGLOGBRUSH;
alias LOGBRUSH TLOGBRUSH;
alias LOGBRUSH* PLOGBRUSH;

struct EMRCREATEBRUSHINDIRECT
{
 EMR emr;
 DWORD ihBrush;
 LOGBRUSH lb;
}

alias EMRCREATEBRUSHINDIRECT TAGEMRCREATEBRUSHINDIRECT;
alias EMRCREATEBRUSHINDIRECT TEMRCREATEBRUSHINDIRECT;
alias EMRCREATEBRUSHINDIRECT* PEMRCREATEBRUSHINDIRECT;
alias LONG LCSCSTYPE;
alias LONG LCSGAMUTMATCH;

struct LOGCOLORSPACEA
{
 DWORD lcsSignature;
 DWORD lcsVersion;
 DWORD lcsSize;
 LCSCSTYPE lcsCSType;
 LCSGAMUTMATCH lcsIntent;
 CIEXYZTRIPLE lcsEndpoints;
 DWORD lcsGammaRed;
 DWORD lcsGammaGreen;
 DWORD lcsGammaBlue;
 CHAR[1 + MAX_PATH-1] lcsFilename;
}
struct LOGCOLORSPACEW
{
 DWORD lcsSignature;
 DWORD lcsVersion;
 DWORD lcsSize;
 LCSCSTYPE lcsCSType;
 LCSGAMUTMATCH lcsIntent;
 CIEXYZTRIPLE lcsEndpoints;
 DWORD lcsGammaRed;
 DWORD lcsGammaGreen;
 DWORD lcsGammaBlue;
 WCHAR[1 + MAX_PATH-1] lcsFilename;
}
version(Win32SansUnicode) {
 alias LOGCOLORSPACEA LOGCOLORSPACE;
}
else {
 alias LOGCOLORSPACEW LOGCOLORSPACE;
}

alias LOGCOLORSPACE* LPLOGCOLORSPACE;
alias LOGCOLORSPACE TAGLOGCOLORSPACE;
alias LOGCOLORSPACE TLOGCOLORSPACE;
alias LOGCOLORSPACE TLOGCOLORSPACEA;
alias LOGCOLORSPACE* PLOGCOLORSPACE;

struct EMRCREATECOLORSPACE 
{
 EMR   emr;
 DWORD    ihCS;
 LOGCOLORSPACEA lcs;
}

alias EMRCREATECOLORSPACE TAGEMRCREATECOLORSPACE;
alias EMRCREATECOLORSPACE TEMRCREATECOLORSPACE;
alias EMRCREATECOLORSPACE* PEMRCREATECOLORSPACE;

struct EMRCREATEDIBPATTERNBRUSHPT
{
 EMR emr;
 DWORD ihBrush;
 DWORD iUsage;
 DWORD offBmi;
 DWORD cbBmi;
 DWORD offBits;
 DWORD cbBits;
}

alias EMRCREATEDIBPATTERNBRUSHPT TAGEMRCREATEDIBPATTERNBRUSHPT;
alias EMRCREATEDIBPATTERNBRUSHPT TEMRCREATEDIBPATTERNBRUSHPT;
alias EMRCREATEDIBPATTERNBRUSHPT PEMRCREATEDIBPATTERNBRUSHPT;

struct EMRCREATEMONOBRUSH
{
 EMR emr;
 DWORD ihBrush;
 DWORD iUsage;
 DWORD offBmi;
 DWORD cbBmi;
 DWORD offBits;
 DWORD cbBits;
}

alias EMRCREATEMONOBRUSH TAGEMRCREATEMONOBRUSH;
alias EMRCREATEMONOBRUSH TEMRCREATEMONOBRUSH;
alias EMRCREATEMONOBRUSH* PEMRCREATEMONOBRUSH;

struct PALETTEENTRY
{
 ubyte peRed;
 ubyte peGreen;
 ubyte peBlue;
 ubyte peFlags;
}

alias PALETTEENTRY* LPPALETTEENTRY;
alias PALETTEENTRY TAGPALETTEENTRY;
alias PALETTEENTRY TPALETTEENTRY;
alias PALETTEENTRY* PPALETTEENTRY;

struct LOGPALETTE
{
 ushort palVersion;
 ushort palNumEntries;
 PALETTEENTRY[1 + 0] palPalEntry;
}

alias LOGPALETTE* LPLOGPALETTE;
alias LOGPALETTE TAGLOGPALETTE;
alias LOGPALETTE TLOGPALETTE;
alias LOGPALETTE* PLOGPALETTE;

struct EMRCREATEPALETTE
{
 EMR emr;
 DWORD ihPal;
 LOGPALETTE lgpl;
}

alias EMRCREATEPALETTE TAGEMRCREATEPALETTE;
alias EMRCREATEPALETTE TEMRCREATEPALETTE;
alias EMRCREATEPALETTE* PEMRCREATEPALETTE;

struct LOGPEN
{
 UINT lopnStyle;
 POINT lopnWidth;
 COLORREF lopnColor;
}

alias LOGPEN TAGLOGPEN;
alias LOGPEN TLOGPEN;
alias LOGPEN* PLOGPEN;

struct EMRCREATEPEN
{
 EMR emr;
 DWORD ihPen;
 LOGPEN lopn;
}

alias EMRCREATEPEN TAGEMRCREATEPEN;
alias EMRCREATEPEN TEMRCREATEPEN;
alias EMRCREATEPEN* PEMRCREATEPEN;

struct EMRELLIPSE
{
 EMR emr;
 RECTL rclBox;
}

alias EMRELLIPSE TAGEMRELLIPSE;
alias EMRELLIPSE TEMRELLIPSE;
alias EMRELLIPSE* PEMRELLIPSE;
alias EMRELLIPSE EMRRECTANGLE;
alias EMRELLIPSE TEMRRECTANGLE;
alias EMRELLIPSE* PEMRRECTANGLE;

struct EMREOF
{
 EMR emr;
 DWORD nPalEntries;
 DWORD offPalEntries;
 DWORD nSizeLast;
}

alias EMREOF TAGEMREOF;
alias EMREOF TEMREOF;
alias EMREOF* PEMREOF;

struct EMREXCLUDECLIPRECT
{
 EMR emr;
 RECTL rclClip;
}

alias EMREXCLUDECLIPRECT TAGEMREXCLUDECLIPRECT;
alias EMREXCLUDECLIPRECT TEMREXCLUDECLIPRECT;
alias EMREXCLUDECLIPRECT* PEMREXCLUDECLIPRECT;
alias EMREXCLUDECLIPRECT EMRINTERSECTCLIPRECT;
alias EMREXCLUDECLIPRECT TEMRINTERSECTCLIPRECT;
alias EMREXCLUDECLIPRECT* PEMRINTERSECTCLIPRECT;

struct PANOSE
{
 ubyte bFamilyType;
 ubyte bSerifStyle;
 ubyte bWeight;
 ubyte bProportion;
 ubyte bContrast;
 ubyte bStrokeVariation;
 ubyte bArmStyle;
 ubyte bLetterform;
 ubyte bMidline;
 ubyte bXHeight;
}

alias PANOSE TAGPANOSE;
alias PANOSE TPANOSE;
alias PANOSE* PPANOSE;

struct EXTLOGFONT
{
 LOGFONT elfLogFont;
 TCHAR[1 + LF_FULLFACESIZE-1] elfFullName = 0;
 TCHAR[1 + LF_FACESIZE-1] elfStyle = 0;
 DWORD elfVersion;
 DWORD elfStyleSize;
 DWORD elfMatch;
 DWORD elfReserved;
 ubyte[1 + ELF_VENDOR_SIZE-1] elfVendorId;
 DWORD elfCulture;
 PANOSE elfPanose;
}

alias EXTLOGFONT TAGEXTLOGFONT;
alias EXTLOGFONT TEXTLOGFONT;
alias EXTLOGFONT* PEXTLOGFONT;

struct EMREXTCREATEFONTINDIRECTW
{
 EMR emr;
 DWORD ihFont;
 EXTLOGFONT elfw;
}

alias EMREXTCREATEFONTINDIRECTW TAGEMREXTCREATEFONTINDIRECTW;
alias EMREXTCREATEFONTINDIRECTW TEMREXTCREATEFONTINDIRECTW;
alias EMREXTCREATEFONTINDIRECTW* PEMREXTCREATEFONTINDIRECTW;

struct EXTLOGPEN
{
 UINT elpPenStyle;
 UINT elpWidth;
 UINT elpBrushStyle;
 COLORREF elpColor;
 LONG elpHatch;
 DWORD elpNumEntries;
 DWORD[1 + 0] elpStyleEntry;
}

alias EXTLOGPEN TAGEXTLOGPEN;
alias EXTLOGPEN TEXTLOGPEN;
alias EXTLOGPEN* PEXTLOGPEN;

struct EMREXTCREATEPEN
{
 EMR emr;
 DWORD ihPen;
 DWORD offBmi;
 DWORD cbBmi;
 DWORD offBits;
 DWORD cbBits;
 EXTLOGPEN elp;
}

alias EMREXTCREATEPEN TAGEMREXTCREATEPEN;
alias EMREXTCREATEPEN TEMREXTCREATEPEN;
alias EMREXTCREATEPEN* PEMREXTCREATEPEN;

struct EMREXTFLOODFILL
{
 EMR emr;
 POINTL ptlStart;
 COLORREF crColor;
 DWORD iMode;
}

alias EMREXTFLOODFILL TAGEMREXTFLOODFILL;
alias EMREXTFLOODFILL TEMREXTFLOODFILL;
alias EMREXTFLOODFILL* PEMREXTFLOODFILL;

struct EMREXTSELECTCLIPRGN
{
 EMR emr;
 DWORD cbRgnData;
 DWORD iMode;
 ubyte[1 + 0] RgnData;
}

alias EMREXTSELECTCLIPRGN TAGEMREXTSELECTCLIPRGN;
alias EMREXTSELECTCLIPRGN TEMREXTSELECTCLIPRGN;
alias EMREXTSELECTCLIPRGN* PEMREXTSELECTCLIPRGN;

struct EMRTEXT
{
 POINTL ptlReference;
 DWORD nChars;
 DWORD offString;
 DWORD fOptions;
 RECTL rcl;
 DWORD offDx;
}

alias EMRTEXT TAGEMRTEXT;
alias EMRTEXT TEMRTEXT;
alias EMRTEXT* PEMRTEXT;

struct EMREXTTEXTOUTA
{
 EMR emr;
 RECTL rclBounds;
 DWORD iGraphicsMode;
 FLOAT exScale;
 FLOAT eyScale;
 EMRTEXT emrtext;
}

alias EMREXTTEXTOUTA TAGEMREXTTEXTOUTA;
alias EMREXTTEXTOUTA TEMREXTTEXTOUTA;
alias EMREXTTEXTOUTA* PEMREXTTEXTOUTA;
alias EMREXTTEXTOUTA EMREXTTEXTOUTW;
alias EMREXTTEXTOUTA TEMREXTTEXTOUTW;
alias EMREXTTEXTOUTA* PEMREXTTEXTOUTW;

struct EMRFILLPATH
{
 EMR emr;
 RECTL rclBounds;
}

alias EMRFILLPATH TAGEMRFILLPATH;
alias EMRFILLPATH TEMRFILLPATH;
alias EMRFILLPATH* PEMRFILLPATH;
alias EMRFILLPATH EMRSTROKEANDFILLPATH;
alias EMRFILLPATH TEMRSTROKEANDFILLPATH;
alias EMRFILLPATH* PEMRSTROKEANDFILLPATH;
alias EMRFILLPATH EMRSTROKEPATH;
alias EMRFILLPATH TEMRSTROKEPATH;
alias EMRFILLPATH* PEMRSTROKEPATH;

struct EMRFILLRGN
{
 EMR emr;
 RECTL rclBounds;
 DWORD cbRgnData;
 DWORD ihBrush;
 ubyte[1 + 0] RgnData;
}

alias EMRFILLRGN TAGEMRFILLRGN;
alias EMRFILLRGN TEMRFILLRGN;
alias EMRFILLRGN* PEMRFILLRGN;

struct EMRFORMAT
{
 DWORD dSignature;
 DWORD nVersion;
 DWORD cbData;
 DWORD offData;
}

alias EMRFORMAT TAGEMRFORMAT;
alias EMRFORMAT TEMRFORMAT;
alias EMRFORMAT* PEMRFORMAT;

struct SIZE
{
 LONG cx;
 LONG cy;
}

alias SIZE* LPSIZE;
alias SIZE TAGSIZE;
alias SIZE TSIZE;
alias SIZE* PSIZE;
alias SIZE SIZEL;
alias SIZE TSIZEL;
alias SIZE* PSIZEL;
alias SIZE* LPSIZEL;

struct EMRFRAMERGN
{
 EMR emr;
 RECTL rclBounds;
 DWORD cbRgnData;
 DWORD ihBrush;
 SIZEL szlStroke;
 ubyte[1 + 0] RgnData;
}

alias EMRFRAMERGN TAGEMRFRAMERGN;
alias EMRFRAMERGN TEMRFRAMERGN;
alias EMRFRAMERGN* PEMRFRAMERGN;

struct EMRGDICOMMENT
{
 EMR emr;
 DWORD cbData;
 ubyte[1 + 0] Data;
}

alias EMRGDICOMMENT TAGEMRGDICOMMENT;
alias EMRGDICOMMENT TEMRGDICOMMENT;
alias EMRGDICOMMENT* PEMRGDICOMMENT;

struct EMRINVERTRGN
{
 EMR emr;
 RECTL rclBounds;
 DWORD cbRgnData;
 ubyte[1 + 0] RgnData;
}

alias EMRINVERTRGN TAGEMRINVERTRGN;
alias EMRINVERTRGN TEMRINVERTRGN;
alias EMRINVERTRGN* PEMRINVERTRGN;
alias EMRINVERTRGN EMRPAINTRGN;
alias EMRINVERTRGN TEMRPAINTRGN;
alias EMRINVERTRGN* PEMRPAINTRGN;

struct EMRLINETO
{
 EMR emr;
 POINTL ptl;
}

alias EMRLINETO TAGEMRLINETO;
alias EMRLINETO TEMRLINETO;
alias EMRLINETO* PEMRLINETO;
alias EMRLINETO EMRMOVETOEX;
alias EMRLINETO TEMRMOVETOEX;
alias EMRLINETO* PEMRMOVETOEX;

struct EMRMASKBLT
{
 EMR emr;
 RECTL rclBounds;
 LONG xDest;
 LONG yDest;
 LONG cxDest;
 LONG cyDest;
 DWORD dwRop;
 LONG xSrc;
 LONG ySrc;
 XFORM xformSrc;
 COLORREF crBkColorSrc;
 DWORD iUsageSrc;
 DWORD offBmiSrc;
 DWORD cbBmiSrc;
 DWORD offBitsSrc;
 DWORD cbBitsSrc;
 LONG xMask;
 LONG yMask;
 DWORD iUsageMask;
 DWORD offBmiMask;
 DWORD cbBmiMask;
 DWORD offBitsMask;
 DWORD cbBitsMask;
}

alias EMRMASKBLT TAGEMRMASKBLT;
alias EMRMASKBLT TEMRMASKBLT;
alias EMRMASKBLT* PEMRMASKBLT;

struct EMRMODIFYWORLDTRANSFORM
{
 EMR emr;
 XFORM xform;
 DWORD iMode;
}

alias EMRMODIFYWORLDTRANSFORM TAGEMRMODIFYWORLDTRANSFORM;
alias EMRMODIFYWORLDTRANSFORM TEMRMODIFYWORLDTRANSFORM;
alias EMRMODIFYWORLDTRANSFORM PEMRMODIFYWORLDTRANSFORM;

struct EMROFFSETCLIPRGN
{
 EMR emr;
 POINTL ptlOffset;
}

alias EMROFFSETCLIPRGN TAGEMROFFSETCLIPRGN;
alias EMROFFSETCLIPRGN TEMROFFSETCLIPRGN;
alias EMROFFSETCLIPRGN* PEMROFFSETCLIPRGN;

struct EMRPLGBLT
{
 EMR emr;
 RECTL rclBounds;
 POINTL[1 + 2] aptlDest;
 LONG xSrc;
 LONG ySrc;
 LONG cxSrc;
 LONG cySrc;
 XFORM xformSrc;
 COLORREF crBkColorSrc;
 DWORD iUsageSrc;
 DWORD offBmiSrc;
 DWORD cbBmiSrc;
 DWORD offBitsSrc;
 DWORD cbBitsSrc;
 LONG xMask;
 LONG yMask;
 DWORD iUsageMask;
 DWORD offBmiMask;
 DWORD cbBmiMask;
 DWORD offBitsMask;
 DWORD cbBitsMask;
}

alias EMRPLGBLT TAGEMRPLGBLT;
alias EMRPLGBLT TEMRPLGBLT;
alias EMRPLGBLT* PEMRPLGBLT;

struct EMRPOLYDRAW
{
 EMR emr;
 RECTL rclBounds;
 DWORD cptl;
 POINTL[1 + 0] aptl;
 ubyte[1 + 0] abTypes;
}

alias EMRPOLYDRAW TAGEMRPOLYDRAW;
alias EMRPOLYDRAW TEMRPOLYDRAW;
alias EMRPOLYDRAW* PEMRPOLYDRAW;

struct EMRPOLYDRAW16
{
 EMR emr;
 RECTL rclBounds;
 DWORD cpts;
 POINTS[1 + 0] apts;
 ubyte[1 + 0] abTypes;
}

alias EMRPOLYDRAW16 TAGEMRPOLYDRAW16;
alias EMRPOLYDRAW16 TEMRPOLYDRAW16;
alias EMRPOLYDRAW16* PEMRPOLYDRAW16;

struct EMRPOLYLINE
{
 EMR emr;
 RECTL rclBounds;
 DWORD cptl;
 POINTL[1 + 0] aptl;
}

alias EMRPOLYLINE TAGEMRPOLYLINE;
alias EMRPOLYLINE TEMRPOLYLINE;
alias EMRPOLYLINE* PEMRPOLYLINE;
alias EMRPOLYLINE EMRPOLYBEZIER;
alias EMRPOLYLINE TEMRPOLYBEZIER;
alias EMRPOLYLINE* PEMRPOLYBEZIER;
alias EMRPOLYLINE EMRPOLYGON;
alias EMRPOLYLINE TEMRPOLYGON;
alias EMRPOLYLINE* PEMRPOLYGON;
alias EMRPOLYLINE EMRPOLYBEZIERTO;
alias EMRPOLYLINE TEMRPOLYBEZIERTO;
alias EMRPOLYLINE* PEMRPOLYBEZIERTO;
alias EMRPOLYLINE EMRPOLYLINETO;
alias EMRPOLYLINE TEMRPOLYLINETO;
alias EMRPOLYLINE* PEMRPOLYLINETO;

struct EMRPOLYLINE16
{
 EMR emr;
 RECTL rclBounds;
 DWORD cpts;
 POINTS[1 + 0] apts;
}

alias EMRPOLYLINE16 TAGEMRPOLYLINE16;
alias EMRPOLYLINE16 TEMRPOLYLINE16;
alias EMRPOLYLINE16* PEMRPOLYLINE16;
alias EMRPOLYLINE16 EMRPOLYBEZIER16;
alias EMRPOLYLINE16 TEMRPOLYBEZIER16;
alias EMRPOLYLINE16* PEMRPOLYBEZIER16;
alias EMRPOLYLINE16 EMRPOLYGON16;
alias EMRPOLYLINE16 TEMRPOLYGON16;
alias EMRPOLYLINE16* PEMRPOLYGON16;
alias EMRPOLYLINE16 EMRPOLYBEZIERTO16;
alias EMRPOLYLINE16 TEMRPOLYBEZIERTO16;
alias EMRPOLYLINE16* PEMRPOLYBEZIERTO16;
alias EMRPOLYLINE16 EMRPOLYLINETO16;
alias EMRPOLYLINE16 TEMRPOLYLINETO16;
alias EMRPOLYLINE16* PEMRPOLYLINETO16;

struct EMRPOLYPOLYLINE
{
 EMR emr;
 RECTL rclBounds;
 DWORD nPolys;
 DWORD cptl;
 DWORD[1 + 0] aPolyCounts;
 POINTL[1 + 0] aptl;
}

alias EMRPOLYPOLYLINE TAGEMRPOLYPOLYLINE;
alias EMRPOLYPOLYLINE TEMRPOLYPOLYLINE;
alias EMRPOLYPOLYLINE* PEMRPOLYPOLYLINE;
alias EMRPOLYPOLYLINE EMRPOLYPOLYGON;
alias EMRPOLYPOLYLINE TEMRPOLYPOLYGON;
alias EMRPOLYPOLYLINE* PEMRPOLYPOLYGON;

struct EMRPOLYPOLYLINE16
{
 EMR emr;
 RECTL rclBounds;
 DWORD nPolys;
 DWORD cpts;
 DWORD[1 + 0] aPolyCounts;
 POINTS[1 + 0] apts;
}

alias EMRPOLYPOLYLINE16 TAGEMRPOLYPOLYLINE16;
alias EMRPOLYPOLYLINE16 TEMRPOLYPOLYLINE16;
alias EMRPOLYPOLYLINE16* PEMRPOLYPOLYLINE16;
alias EMRPOLYPOLYLINE16 EMRPOLYPOLYGON16;
alias EMRPOLYPOLYLINE16 TEMRPOLYPOLYGON16;
alias EMRPOLYPOLYLINE16* PEMRPOLYPOLYGON16;

struct EMRPOLYTEXTOUTA
{
 EMR emr;
 RECTL rclBounds;
 DWORD iGraphicsMode;
 FLOAT exScale;
 FLOAT eyScale;
 LONG cStrings;
 EMRTEXT[1 + 0] aemrtext;
}

alias EMRPOLYTEXTOUTA TAGEMRPOLYTEXTOUTA;
alias EMRPOLYTEXTOUTA TEMRPOLYTEXTOUTA;
alias EMRPOLYTEXTOUTA* PEMRPOLYTEXTOUTA;
alias EMRPOLYTEXTOUTA EMRPOLYTEXTOUTW;
alias EMRPOLYTEXTOUTA TEMRPOLYTEXTOUTW;
alias EMRPOLYTEXTOUTA* PEMRPOLYTEXTOUTW;

struct EMRRESIZEPALETTE
{
 EMR emr;
 DWORD ihPal;
 DWORD cEntries;
}

alias EMRRESIZEPALETTE TAGEMRRESIZEPALETTE;
alias EMRRESIZEPALETTE TEMRRESIZEPALETTE;
alias EMRRESIZEPALETTE* PEMRRESIZEPALETTE;

struct EMRRESTOREDC
{
 EMR emr;
 LONG iRelative;
}

alias EMRRESTOREDC TAGEMRRESTOREDC;
alias EMRRESTOREDC TEMRRESTOREDC;
alias EMRRESTOREDC* PEMRRESTOREDC;

struct EMRROUNDRECT
{
 EMR emr;
 RECTL rclBox;
 SIZEL szlCorner;
}

alias EMRROUNDRECT TAGEMRROUNDRECT;
alias EMRROUNDRECT TEMRROUNDRECT;
alias EMRROUNDRECT* PEMRROUNDRECT;

struct EMRSCALEVIEWPORTEXTEX
{
 EMR emr;
 LONG xNum;
 LONG xDenom;
 LONG yNum;
 LONG yDenom;
}

alias EMRSCALEVIEWPORTEXTEX TAGEMRSCALEVIEWPORTEXTEX;
alias EMRSCALEVIEWPORTEXTEX TEMRSCALEVIEWPORTEXTEX;
alias EMRSCALEVIEWPORTEXTEX* PEMRSCALEVIEWPORTEXTEX;
alias EMRSCALEVIEWPORTEXTEX EMRSCALEWINDOWEXTEX;
alias EMRSCALEVIEWPORTEXTEX TEMRSCALEWINDOWEXTEX;
alias EMRSCALEVIEWPORTEXTEX* PEMRSCALEWINDOWEXTEX;

struct EMRSELECTCOLORSPACE
{
 EMR emr;
 DWORD ihCS;
}

alias EMRSELECTCOLORSPACE TAGEMRSELECTCOLORSPACE;
alias EMRSELECTCOLORSPACE TEMRSELECTCOLORSPACE;
alias EMRSELECTCOLORSPACE* PEMRSELECTCOLORSPACE;
alias EMRSELECTCOLORSPACE EMRDELETECOLORSPACE;
alias EMRSELECTCOLORSPACE TEMRDELETECOLORSPACE;
alias EMRSELECTCOLORSPACE* PEMRDELETECOLORSPACE;

struct EMRSELECTOBJECT
{
 EMR emr;
 DWORD ihObject;
}

alias EMRSELECTOBJECT TAGEMRSELECTOBJECT;
alias EMRSELECTOBJECT TEMRSELECTOBJECT;
alias EMRSELECTOBJECT* PEMRSELECTOBJECT;
alias EMRSELECTOBJECT EMRDELETEOBJECT;
alias EMRSELECTOBJECT TEMRDELETEOBJECT;
alias EMRSELECTOBJECT* PEMRDELETEOBJECT;

struct EMRSELECTPALETTE
{
 EMR emr;
 DWORD ihPal;
}

alias EMRSELECTPALETTE TAGEMRSELECTPALETTE;
alias EMRSELECTPALETTE TEMRSELECTPALETTE;
alias EMRSELECTPALETTE* PEMRSELECTPALETTE;

struct EMRSETARCDIRECTION
{
 EMR emr;
 DWORD iArcDirection;
}

alias EMRSETARCDIRECTION TAGEMRSETARCDIRECTION;
alias EMRSETARCDIRECTION TEMRSETARCDIRECTION;
alias EMRSETARCDIRECTION* PEMRSETARCDIRECTION;

struct EMRSETBKCOLOR
{
 EMR emr;
 COLORREF crColor;
}

alias EMRSETBKCOLOR TAGEMRSETTEXTCOLOR;
alias EMRSETBKCOLOR TEMRSETBKCOLOR;
alias EMRSETBKCOLOR* PEMRSETBKCOLOR;
alias EMRSETBKCOLOR EMRSETTEXTCOLOR;
alias EMRSETBKCOLOR TEMRSETTEXTCOLOR;
alias EMRSETBKCOLOR* PEMRSETTEXTCOLOR;

struct EMRSETCOLORADJUSTMENT
{
 EMR emr;
 COLORADJUSTMENT ColorAdjustment;
}

alias EMRSETCOLORADJUSTMENT TAGEMRSETCOLORADJUSTMENT;
alias EMRSETCOLORADJUSTMENT TEMRSETCOLORADJUSTMENT;
alias EMRSETCOLORADJUSTMENT* PEMRSETCOLORADJUSTMENT;

struct EMRSETDIBITSTODEVICE
{
 EMR emr;
 RECTL rclBounds;
 LONG xDest;
 LONG yDest;
 LONG xSrc;
 LONG ySrc;
 LONG cxSrc;
 LONG cySrc;
 DWORD offBmiSrc;
 DWORD cbBmiSrc;
 DWORD offBitsSrc;
 DWORD cbBitsSrc;
 DWORD iUsageSrc;
 DWORD iStartScan;
 DWORD cScans;
}

alias EMRSETDIBITSTODEVICE TAGEMRSETDIBITSTODEVICE;
alias EMRSETDIBITSTODEVICE TEMRSETDIBITSTODEVICE;
alias EMRSETDIBITSTODEVICE* PEMRSETDIBITSTODEVICE;

struct EMRSETMAPPERFLAGS
{
 EMR emr;
 DWORD dwFlags;
}

alias EMRSETMAPPERFLAGS TAGEMRSETMAPPERFLAGS;
alias EMRSETMAPPERFLAGS TEMRSETMAPPERFLAGS;
alias EMRSETMAPPERFLAGS* PEMRSETMAPPERFLAGS;

struct EMRSETMITERLIMIT
{
 EMR emr;
 FLOAT eMiterLimit;
}

alias EMRSETMITERLIMIT TAGEMRSETMITERLIMIT;
alias EMRSETMITERLIMIT TEMRSETMITERLIMIT;
alias EMRSETMITERLIMIT* PEMRSETMITERLIMIT;

struct EMRSETPALETTEENTRIES
{
 EMR emr;
 DWORD ihPal;
 DWORD iStart;
 DWORD cEntries;
 PALETTEENTRY[1 + 0] aPalEntries;
}

alias EMRSETPALETTEENTRIES TAGEMRSETPALETTEENTRIES;
alias EMRSETPALETTEENTRIES TEMRSETPALETTEENTRIES;
alias EMRSETPALETTEENTRIES* PEMRSETPALETTEENTRIES;

struct EMRSETPIXELV
{
 EMR emr;
 POINTL ptlPixel;
 COLORREF crColor;
}

alias EMRSETPIXELV TAGEMRSETPIXELV;
alias EMRSETPIXELV TEMRSETPIXELV;
alias EMRSETPIXELV* PEMRSETPIXELV;

struct EMRSETVIEWPORTEXTEX
{
 EMR emr;
 SIZEL szlExtent;
}

alias EMRSETVIEWPORTEXTEX TAGEMRSETVIEWPORTEXTEX;
alias EMRSETVIEWPORTEXTEX TEMRSETVIEWPORTEXTEX;
alias EMRSETVIEWPORTEXTEX* PEMRSETVIEWPORTEXTEX;
alias EMRSETVIEWPORTEXTEX EMRSETWINDOWEXTEX;
alias EMRSETVIEWPORTEXTEX TEMRSETWINDOWEXTEX;
alias EMRSETVIEWPORTEXTEX* PEMRSETWINDOWEXTEX;

struct EMRSETVIEWPORTORGEX
{
 EMR emr;
 POINTL ptlOrigin;
}

alias EMRSETVIEWPORTORGEX TAGEMRSETVIEWPORTORGEX;
alias EMRSETVIEWPORTORGEX TEMRSETVIEWPORTORGEX;
alias EMRSETVIEWPORTORGEX* PEMRSETVIEWPORTORGEX;
alias EMRSETVIEWPORTORGEX EMRSETWINDOWORGEX;
alias EMRSETVIEWPORTORGEX TEMRSETWINDOWORGEX;
alias EMRSETVIEWPORTORGEX* PEMRSETWINDOWORGEX;
alias EMRSETVIEWPORTORGEX EMRSETBRUSHORGEX;
alias EMRSETVIEWPORTORGEX TEMRSETBRUSHORGEX;
alias EMRSETVIEWPORTORGEX* PEMRSETBRUSHORGEX;

struct EMRSETWORLDTRANSFORM
{
 EMR emr;
 XFORM xform;
}

alias EMRSETWORLDTRANSFORM TAGEMRSETWORLDTRANSFORM;
alias EMRSETWORLDTRANSFORM TEMRSETWORLDTRANSFORM;
alias EMRSETWORLDTRANSFORM* PEMRSETWORLDTRANSFORM;

struct EMRSTRETCHBLT
{
 EMR emr;
 RECTL rclBounds;
 LONG xDest;
 LONG yDest;
 LONG cxDest;
 LONG cyDest;
 DWORD dwRop;
 LONG xSrc;
 LONG ySrc;
 XFORM xformSrc;
 COLORREF crBkColorSrc;
 DWORD iUsageSrc;
 DWORD offBmiSrc;
 DWORD cbBmiSrc;
 DWORD offBitsSrc;
 DWORD cbBitsSrc;
 LONG cxSrc;
 LONG cySrc;
}

alias EMRSTRETCHBLT TAGEMRSTRETCHBLT;
alias EMRSTRETCHBLT TEMRSTRETCHBLT;
alias EMRSTRETCHBLT* PEMRSTRETCHBLT;

struct EMRSTRETCHDIBITS
{
 EMR emr;
 RECTL rclBounds;
 LONG xDest;
 LONG yDest;
 LONG xSrc;
 LONG ySrc;
 LONG cxSrc;
 LONG cySrc;
 DWORD offBmiSrc;
 DWORD cbBmiSrc;
 DWORD offBitsSrc;
 DWORD cbBitsSrc;
 DWORD iUsageSrc;
 DWORD dwRop;
 LONG cxDest;
 LONG cyDest;
}

alias EMRSTRETCHDIBITS TAGEMRSTRETCHDIBITS;
alias EMRSTRETCHDIBITS TEMRSTRETCHDIBITS;
alias EMRSTRETCHDIBITS* PEMRSTRETCHDIBITS;

struct EMRABORTPATH
{
 EMR emr;
}

alias EMRABORTPATH TEMRABORTPATH;
alias EMRABORTPATH* PEMRABORTPATH;
alias EMRABORTPATH TAGABORTPATH;
alias EMRABORTPATH TABORTPATH;
alias EMRABORTPATH EMRBEGINPATH;
alias EMRABORTPATH TEMRBEGINPATH;
alias EMRABORTPATH* PEMRBEGINPATH;
alias EMRABORTPATH EMRENDPATH;
alias EMRABORTPATH TEMRENDPATH;
alias EMRABORTPATH* PEMRENDPATH;
alias EMRABORTPATH EMRCLOSEFIGURE;
alias EMRABORTPATH TEMRCLOSEFIGURE;
alias EMRABORTPATH* PEMRCLOSEFIGURE;
alias EMRABORTPATH EMRFLATTENPATH;
alias EMRABORTPATH TEMRFLATTENPATH;
alias EMRABORTPATH* PEMRFLATTENPATH;
alias EMRABORTPATH EMRWIDENPATH;
alias EMRABORTPATH TEMRWIDENPATH;
alias EMRABORTPATH* PEMRWIDENPATH;
alias EMRABORTPATH EMRSETMETARGN;
alias EMRABORTPATH TEMRSETMETARGN;
alias EMRABORTPATH* PEMRSETMETARGN;
alias EMRABORTPATH EMRSAVEDC;
alias EMRABORTPATH TEMRSAVEDC;
alias EMRABORTPATH* PEMRSAVEDC;
alias EMRABORTPATH EMRREALIZEPALETTE;
alias EMRABORTPATH TEMRREALIZEPALETTE;
alias EMRABORTPATH* PEMRREALIZEPALETTE;

struct EMRSELECTCLIPPATH
{
 EMR emr;
 DWORD iMode;
}

alias EMRSELECTCLIPPATH TAGEMRSELECTCLIPPATH;
alias EMRSELECTCLIPPATH TEMRSELECTCLIPPATH;
alias EMRSELECTCLIPPATH* PEMRSELECTCLIPPATH;
alias EMRSELECTCLIPPATH EMRSETBKMODE;
alias EMRSELECTCLIPPATH TEMRSETBKMODE;
alias EMRSELECTCLIPPATH* PEMRSETBKMODE;
alias EMRSELECTCLIPPATH EMRSETMAPMODE;
alias EMRSELECTCLIPPATH TEMRSETMAPMODE;
alias EMRSELECTCLIPPATH* PEMRSETMAPMODE;
alias EMRSELECTCLIPPATH EMRSETPOLYFILLMODE;
alias EMRSELECTCLIPPATH TEMRSETPOLYFILLMODE;
alias EMRSELECTCLIPPATH* PEMRSETPOLYFILLMODE;
alias EMRSELECTCLIPPATH EMRSETROP2;
alias EMRSELECTCLIPPATH TEMRSETROP2;
alias EMRSELECTCLIPPATH* PEMRSETROP2;
alias EMRSELECTCLIPPATH EMRSETSTRETCHBLTMODE;
alias EMRSELECTCLIPPATH TEMRSETSTRETCHBLTMODE;
alias EMRSELECTCLIPPATH* PEMRSETSTRETCHBLTMODE;
alias EMRSELECTCLIPPATH EMRSETTEXTALIGN;
alias EMRSELECTCLIPPATH TEMRSETTEXTALIGN;
alias EMRSELECTCLIPPATH* PEMRSETTEXTALIGN;
alias EMRSELECTCLIPPATH EMRENABLEICM;
alias EMRSELECTCLIPPATH TEMRENABLEICM;
alias EMRSELECTCLIPPATH* PEMRENABLEICM;

struct NMHDR
{
 HWND hwndFrom;
 UINT idFrom;
 UINT code;
}

alias NMHDR TAGNMHDR;
alias NMHDR TNMHDR;
alias NMHDR* PNMHDR;

struct ENCORRECTTEXT
{
 NMHDR nmhdr;
 CHARRANGE chrg;
 ushort seltyp;
}

alias ENCORRECTTEXT _ENCORRECTTEXT;
alias ENCORRECTTEXT TENCORRECTTEXT;
alias ENCORRECTTEXT* PENCORRECTTEXT;

struct ENDROPFILES
{
 NMHDR nmhdr;
 HANDLE hDrop;
 LONG cp;
 WINBOOL fProtected;
}

alias ENDROPFILES _ENDROPFILES;
alias ENDROPFILES TENDROPFILES;
alias ENDROPFILES* PENDROPFILES;

struct ENSAVECLIPBOARD
{
 NMHDR nmhdr;
 LONG cObjectCount;
 LONG cch;
}

alias ENSAVECLIPBOARD TENSAVECLIPBOARD;
alias ENSAVECLIPBOARD* PENSAVECLIPBOARD;

struct ENOLEOPFAILED
{
 NMHDR nmhdr;
 LONG iob;
 LONG lOper;
 HRESULT hr;
}

alias ENOLEOPFAILED TENOLEOPFAILED;
alias ENOLEOPFAILED* PENOLEOPFAILED;

align(2) struct ENHMETAHEADER
{
 DWORD iType;
 DWORD nSize;
 RECTL rclBounds;
 RECTL rclFrame;
 DWORD dSignature;
 DWORD nVersion;
 DWORD nBytes;
 DWORD nRecords;
 ushort nHandles;
 ushort sReserved;
 DWORD nDescription;
 DWORD offDescription;
 DWORD nPalEntries;
 SIZEL szlDevice;
 SIZEL szlMillimeters;
//#if (WINVER >= 0x0400)
 DWORD cbPixelFormat;
 DWORD offPixelFormat;
 DWORD bOpenGL;
//#endif /* WINVER >= 0x0400 */
//#if (WINVER >= 0x0500)
 SIZEL szlMicrometers;
//#endif /* WINVER >= 0x0500 */
}

alias ENHMETAHEADER* LPENHMETAHEADER;
alias ENHMETAHEADER TAGENHMETAHEADER;
alias ENHMETAHEADER TENHMETAHEADER;
alias ENHMETAHEADER* PENHMETAHEADER;

struct ENHMETARECORD
{
 DWORD iType;
 DWORD nSize;
 DWORD[1 + 0] dParm;
}

alias ENHMETARECORD* LPENHMETARECORD;
alias ENHMETARECORD TAGENHMETARECORD;
alias ENHMETARECORD TENHMETARECORD;
alias ENHMETARECORD* PENHMETARECORD;

struct ENPROTECTED
{
 NMHDR nmhdr;
 UINT msg;
 WPARAM wParam;
 LPARAM lParam;
 CHARRANGE chrg;
}

alias ENPROTECTED _ENPROTECTED;
alias ENPROTECTED TENPROTECTED;
alias ENPROTECTED* PENPROTECTED;

struct SERVICE_STATUS
{
 DWORD dwServiceType;
 DWORD dwCurrentState;
 DWORD dwControlsAccepted;
 DWORD dwWin32ExitCode;
 DWORD dwServiceSpecificExitCode;
 DWORD dwCheckPoint;
 DWORD dwWaitHint;
}

alias SERVICE_STATUS* LPSERVICE_STATUS;
alias SERVICE_STATUS _SERVICE_STATUS;
alias SERVICE_STATUS TSERVICESTATUS;
alias SERVICE_STATUS* PSERVICESTATUS;

struct ENUM_SERVICE_STATUS
{
 LPTSTR lpServiceName;
 LPTSTR lpDisplayName;
 SERVICE_STATUS ServiceStatus;
}

alias ENUM_SERVICE_STATUS* LPENUM_SERVICE_STATUS;
alias ENUM_SERVICE_STATUS _ENUM_SERVICE_STATUS;
alias ENUM_SERVICE_STATUS TENUMSERVICESTATUS;
alias ENUM_SERVICE_STATUS* PENUMSERVICESTATUS;

struct ENUMLOGFONTA {
  LOGFONTA elfLogFont;
  BYTE  elfFullName[LF_FULLFACESIZE];
  BYTE  elfStyle[LF_FACESIZE];
}
struct ENUMLOGFONTW {
  LOGFONTW elfLogFont;
  WCHAR elfFullName[LF_FULLFACESIZE];
  WCHAR elfStyle[LF_FACESIZE];
}
struct ENUMLOGFONTEXA {
 LOGFONTA  elfLogFont;
 BYTE   elfFullName[LF_FULLFACESIZE];
 BYTE   elfStyle[LF_FACESIZE];
 BYTE   elfScript[LF_FACESIZE];
}
struct ENUMLOGFONTEXW {
 LOGFONTW  elfLogFont;
 WCHAR  elfFullName[LF_FULLFACESIZE];
 WCHAR  elfStyle[LF_FACESIZE];
 WCHAR  elfScript[LF_FACESIZE];
}
version(Win32SansUnicode){
 alias ENUMLOGFONTA ENUMLOGFONT;
 alias ENUMLOGFONTEXA ENUMLOGFONTEX;
}else {
 alias ENUMLOGFONTW ENUMLOGFONT;
 alias ENUMLOGFONTEXW ENUMLOGFONTEX;
}
alias ENUMLOGFONT TAGENUMLOGFONT;
alias ENUMLOGFONT TENUMLOGFONT;
alias ENUMLOGFONT* PENUMLOGFONT;
alias ENUMLOGFONTEX TAGENUMLOGFONTEX;
alias ENUMLOGFONTEX TENUMLOGFONTEX;
alias ENUMLOGFONTEX* PENUMLOGFONTEX;

struct EVENTLOGRECORD
{
 DWORD Length;
 DWORD Reserved;
 DWORD RecordNumber;
 DWORD TimeGenerated;
 DWORD TimeWritten;
 DWORD EventID;
 ushort EventType;
 ushort NumStrings;
 ushort EventCategory;
 ushort ReservedFlags;
 DWORD ClosingRecordNumber;
 DWORD StringOffset;
 DWORD UserSidLength;
 DWORD UserSidOffset;
 DWORD DataLength;
 DWORD DataOffset;
}

alias EVENTLOGRECORD _EVENTLOGRECORD;
alias EVENTLOGRECORD TEVENTLOGRECORD;
alias EVENTLOGRECORD* PEVENTLOGRECORD;

struct EVENTMSG
{
 UINT message;
 UINT paramL;
 UINT paramH;
 DWORD time;
 HWND hwnd;
}

alias EVENTMSG TAGEVENTMSG;
alias EVENTMSG TEVENTMSG;
alias EVENTMSG* PEVENTMSG;

struct EXCEPTION_POINTERS
{
 PEXCEPTION_RECORD ExceptionRecord;
 PCONTEXT ContextRecord;
}

alias EXCEPTION_POINTERS* LPEXCEPTION_POINTERS;
alias EXCEPTION_POINTERS* PEXCEPTION_POINTERS;
alias EXCEPTION_POINTERS _EXCEPTION_POINTERS;
alias EXCEPTION_POINTERS TEXCEPTIONPOINTERS;
alias EXCEPTION_POINTERS* PEXCEPTIONPOINTERS;

struct EXT_BUTTON
{
 ushort idCommand;
 ushort idsHelp;
 ushort fsStyle;
}

alias EXT_BUTTON* LPEXT_BUTTON;
alias EXT_BUTTON _EXT_BUTTON;
alias EXT_BUTTON TEXTBUTTON;
alias EXT_BUTTON* PEXTBUTTON;

struct FILTERKEYS
{
 UINT cbSize;
 DWORD dwFlags;
 DWORD iWaitMSec;
 DWORD iDelayMSec;
 DWORD iRepeatMSec;
 DWORD iBounceMSec;
}

alias FILTERKEYS TAGFILTERKEYS;
alias FILTERKEYS TFILTERKEYS;
alias FILTERKEYS* PFILTERKEYS;

struct FIND_NAME_BUFFER
{
 UCHAR length;
 UCHAR access_control;
 UCHAR frame_control;
 UCHAR[1 + 5] destination_addr;
 UCHAR[1 + 5] source_addr;
 UCHAR[1 + 17] routing_info;
}

alias FIND_NAME_BUFFER _FIND_NAME_BUFFER;
alias FIND_NAME_BUFFER TFINDNAMEBUFFER;
alias FIND_NAME_BUFFER* PFINDNAMEBUFFER;

struct FIND_NAME_HEADER
{
 ushort node_count;
 UCHAR reserved;
 UCHAR unique_group;
}

alias FIND_NAME_HEADER _FIND_NAME_HEADER;
alias FIND_NAME_HEADER TFINDNAMEHEADER;
alias FIND_NAME_HEADER* PFINDNAMEHEADER;

struct FINDREPLACE
{
 DWORD lStructSize;
 HWND hwndOwner;
 HINST hInstance;
 DWORD Flags;
 LPTSTR lpstrFindWhat;
 LPTSTR lpstrReplaceWith;
 ushort wFindWhatLen;
 ushort wReplaceWithLen;
 LPARAM lCustData;
 LPFRHOOKPROC lpfnHook;
 LPCTSTR lpTemplateName;
}

alias FINDREPLACE* LPFINDREPLACE;
alias FINDREPLACE TFINDREPLACE;
alias FINDREPLACE* PFINDREPLACE;

struct TFINDTEXT
{
 CHARRANGE chrg;
 LPSTR lpstrText;
}

alias TFINDTEXT _FINDTEXT;
alias TFINDTEXT FINDTEXT;
alias TFINDTEXT* PFINDTEXT;

struct FINDTEXTEX
{
 CHARRANGE chrg;
 LPSTR lpstrText;
 CHARRANGE chrgText;
}

alias FINDTEXTEX _FINDTEXTEX;
alias FINDTEXTEX TFINDTEXTEX;
alias FINDTEXTEX* PFINDTEXTEX;

struct FMS_GETDRIVEINFO
{
 DWORD dwTotalSpace;
 DWORD dwFreeSpace;
 TCHAR[1 + 259] szPath;
 TCHAR[1 + 13] szVolume;
 TCHAR[1 + 127] szShare;
}

alias FMS_GETDRIVEINFO _FMS_GETDRIVEINFO;
alias FMS_GETDRIVEINFO TFMSGETDRIVEINFO;
alias FMS_GETDRIVEINFO* PFMSGETDRIVEINFO;

struct FMS_GETFILESEL
{
 FILETIME ftTime;
 DWORD dwSize;
 ubyte bAttr;
 TCHAR[1 + 259] szName;
}

alias FMS_GETFILESEL _FMS_GETFILESEL;
alias FMS_GETFILESEL TFMSGETFILESEL;
alias FMS_GETFILESEL* PFMSGETFILESEL;

struct FMS_LOAD
{
 DWORD dwSize;
 TCHAR[1 + MENU_TEXT_LEN-1] szMenuName;
 HMENU hMenu;
 UINT wMenuDelta;
}

alias FMS_LOAD _FMS_LOAD;
alias FMS_LOAD TFMSLOAD;
alias FMS_LOAD* PFMSLOAD;

struct FMS_TOOLBARLOAD
{
 DWORD dwSize;
 LPEXT_BUTTON lpButtons;
 ushort cButtons;
 ushort cBitmaps;
 ushort idBitmap;
 HBITMAP hBitmap;
}

alias FMS_TOOLBARLOAD _FMS_TOOLBARLOAD;
alias FMS_TOOLBARLOAD TFMSTOOLBARLOAD;
alias FMS_TOOLBARLOAD* PFMSTOOLBARLOAD;

struct FOCUS_EVENT_RECORD
{
 WINBOOL bSetFocus;
}

alias FOCUS_EVENT_RECORD _FOCUS_EVENT_RECORD;
alias FOCUS_EVENT_RECORD TFOCUSEVENTRECORD;
alias FOCUS_EVENT_RECORD* PFOCUSEVENTRECORD;

struct FORM_INFO_1
{
 DWORD Flags;
 LPTSTR pName;
 SIZEL Size;
 RECTL ImageableArea;
}

alias FORM_INFO_1 _FORM_INFO_1;
alias FORM_INFO_1 TFORMINFO1;
alias FORM_INFO_1* PFORMINFO1;

struct FORMAT_PARAMETERS
{
 MEDIA_TYPE MediaType;
 DWORD StartCylinderNumber;
 DWORD EndCylinderNumber;
 DWORD StartHeadNumber;
 DWORD EndHeadNumber;
}

alias FORMAT_PARAMETERS _FORMAT_PARAMETERS;
alias FORMAT_PARAMETERS TFORMATPARAMETERS;
alias FORMAT_PARAMETERS* PFORMATPARAMETERS;

struct FORMATRANGE
{
 HDC _hdc;
 HDC hdcTarget;
 RECT rc;
 RECT rcPage;
 CHARRANGE chrg;
}

alias FORMATRANGE _FORMATRANGE;
alias FORMATRANGE TFORMATRANGE;
alias FORMATRANGE* PFORMATRANGE;

struct GCP_RESULTSA
{
 DWORD   lStructSize;
 LPSTR   lpOutString;
 UINT  * lpOrder;
 int   * lpDx;
 int   * lpCaretPos;
 LPSTR   lpClass;
 LPWSTR  lpGlyphs;
 UINT nGlyphs;
 int  nMaxFit;
}

struct GCP_RESULTSW
{
 DWORD   lStructSize;
 LPWSTR  lpOutString;
 UINT  * lpOrder;
 int   * lpDx;
 int   * lpCaretPos;
 LPSTR   lpClass;
 LPWSTR  lpGlyphs;
 UINT nGlyphs;
 int  nMaxFit;
}
version(Win32SansUnicode)
{
 alias GCP_RESULTSA GCP_RESULTS;
}
else
{
 alias GCP_RESULTSW GCP_RESULTS;
}
alias GCP_RESULTS* LPGCP_RESULTS;
alias GCP_RESULTS TAGGCP_RESULTS;
alias GCP_RESULTS TGCPRESULTS;
alias GCP_RESULTS* PGCPRESULTS;

struct GENERIC_MAPPING
{
 ACCESS_MASK GenericRead;
 ACCESS_MASK GenericWrite;
 ACCESS_MASK GenericExecute;
 ACCESS_MASK GenericAll;
}

alias GENERIC_MAPPING* PGENERIC_MAPPING;
alias GENERIC_MAPPING _GENERIC_MAPPING;
alias GENERIC_MAPPING TGENERICMAPPING;
alias GENERIC_MAPPING* PGENERICMAPPING;

struct GLYPHMETRICS
{
 UINT gmBlackBoxX;
 UINT gmBlackBoxY;
 POINT gmptGlyphOrigin;
 short gmCellIncX;
 short gmCellIncY;
}

alias GLYPHMETRICS* LPGLYPHMETRICS;
alias GLYPHMETRICS _GLYPHMETRICS;
alias GLYPHMETRICS TGLYPHMETRICS;
alias GLYPHMETRICS* PGLYPHMETRICS;

struct HANDLETABLE
{
 HGDIOBJ[1 + 0] objectHandle;
}

alias HANDLETABLE TAGHANDLETABLE;
alias HANDLETABLE THANDLETABLE;
alias HANDLETABLE* LPHANDLETABLE;

struct HD_HITTESTINFO
{
 POINT pt;
 UINT flags;
 int iItem;
}

alias HD_HITTESTINFO _HD_HITTESTINFO;
alias HD_HITTESTINFO THDHITTESTINFO;
alias HD_HITTESTINFO  HDHITTESTINFO;
alias HD_HITTESTINFO* PHDHITTESTINFO;

struct HD_ITEM
{
 UINT mask;
 int cxy;
 LPTSTR pszText;
 HBITMAP hbm;
 int cchTextMax;
 int fmt;
 LPARAM lParam;
 // _WIN32_IE >= 0x300
 int iImage;
 int iOrder;
 // _WIN32_IE >= 0x500
 UINT type;
 void* pvFilter;
 // _WIN32_WINNT >= 0x600
 //UINT state;
}

alias HD_ITEM _HD_ITEM;
alias HD_ITEM THDITEM;
alias HD_ITEM* PHDITEM;

struct WINDOWPOS
{
 HWND _hwnd;
 HWND hwndInsertAfter;
 int x;
 int y;
 int cx;
 int cy;
 UINT flags;
}

alias WINDOWPOS* LPWINDOWPOS;
alias WINDOWPOS _WINDOWPOS;
alias WINDOWPOS TWINDOWPOS;
alias WINDOWPOS* PWINDOWPOS;

struct HD_LAYOUT
{
 RECT* prc;
 WINDOWPOS* pwpos;
}

alias HD_LAYOUT _HD_LAYOUT;
alias HD_LAYOUT THDLAYOUT;
alias HD_LAYOUT  HDLAYOUT;
alias HD_LAYOUT* PHDLAYOUT;

struct HD_NOTIFY
{
 NMHDR hdr;
 int iItem;
 int iButton;
 HD_ITEM* pitem;
}

alias HD_NOTIFY _HD_NOTIFY;
alias HD_NOTIFY THDNOTIFY;
alias HD_NOTIFY* PHDNOTIFY;

struct HELPINFO
{
 UINT cbSize;
 int iContextType;
 int iCtrlId;
 HANDLE hItemHandle;
 DWORD dwContextId;
 POINT MousePos;
}

alias HELPINFO* LPHELPINFO;
alias HELPINFO TAGHELPINFO;
alias HELPINFO THELPINFO;
alias HELPINFO* PHELPINFO;

struct HELPWININFO
{
 int wStructSize;
 int x;
 int y;
 int dx;
 int dy;
 int wMax;
 TCHAR[1 + 1] rgchMember;
}

alias HELPWININFO THELPWININFO;
alias HELPWININFO* PHELPWININFO;

struct HIGHCONTRASTA
{
 UINT    cbSize;
 DWORD   dwFlags;
 LPSTR   lpszDefaultScheme;
}
struct HIGHCONTRASTW
{
 UINT    cbSize;
 DWORD   dwFlags;
 LPWSTR     lpszDefaultScheme;
}
version(Win32SansUnicode)
{
 alias HIGHCONTRASTA HIGHCONTRAST;
}
else
{
 alias HIGHCONTRASTW HIGHCONTRAST;
}
alias HIGHCONTRAST* LPHIGHCONTRAST;
alias HIGHCONTRAST TAGHIGHCONTRAST;
alias HIGHCONTRAST THIGHCONTRAST;
alias HIGHCONTRAST* PHIGHCONTRAST;

struct HSZPAIR
{
 HSZ hszSvc;
 HSZ hszTopic;
}

alias HSZPAIR TAGHSZPAIR;
alias HSZPAIR THSZPAIR;
alias HSZPAIR* PHSZPAIR;

struct ICONINFO
{
 WINBOOL fIcon;
 DWORD xHotspot;
 DWORD yHotspot;
 HBITMAP hbmMask;
 HBITMAP hbmColor;
}

alias ICONINFO _ICONINFO;
alias ICONINFO TICONINFO;
alias ICONINFO* PICONINFO;

struct ICONMETRICS
{
 UINT cbSize;
 int iHorzSpacing;
 int iVertSpacing;
 int iTitleWrap;
 LOGFONT lfFont;
}

alias ICONMETRICS* LPICONMETRICS;
alias ICONMETRICS TAGICONMETRICS;
alias ICONMETRICS TICONMETRICS;
alias ICONMETRICS* PICONMETRICS;

struct IMAGEINFO
{
 HBITMAP hbmImage;
 HBITMAP hbmMask;
 int Unused1;
 int Unused2;
 RECT rcImage;
}

alias IMAGEINFO _IMAGEINFO;
alias IMAGEINFO TIMAGEINFO;
alias IMAGEINFO* PIMAGEINFO;

align(1) struct KEY_EVENT_RECORD
{
 WINBOOL bKeyDown;
 ushort wRepeatCount;
 ushort wVirtualKeyCode;
 ushort wVirtualScanCode;

 union
 {
  struct
  {
   WCHAR UnicodeChar;
   DWORD dwControlKeyState;
  }
  struct
  {
   char AsciiChar;
  }
 }
}

alias KEY_EVENT_RECORD _KEY_EVENT_RECORD;
alias KEY_EVENT_RECORD TKEYEVENTRECORD;
alias KEY_EVENT_RECORD* PKEYEVENTRECORD;

struct MOUSE_EVENT_RECORD
{
 COORD dwMousePosition;
 DWORD dwButtonState;
 DWORD dwControlKeyState;
 DWORD dwEventFlags;
}

alias MOUSE_EVENT_RECORD _MOUSE_EVENT_RECORD;
alias MOUSE_EVENT_RECORD TMOUSEEVENTRECORD;
alias MOUSE_EVENT_RECORD* PMOUSEEVENTRECORD;

struct WINDOW_BUFFER_SIZE_RECORD
{
 COORD dwSize;
}

alias WINDOW_BUFFER_SIZE_RECORD _WINDOW_BUFFER_SIZE_RECORD;
alias WINDOW_BUFFER_SIZE_RECORD TWINDOWBUFFERSIZERECORD;
alias WINDOW_BUFFER_SIZE_RECORD* PWINDOWBUFFERSIZERECORD;

struct MENU_EVENT_RECORD
{
 UINT dwCommandId;
}

alias MENU_EVENT_RECORD* PMENU_EVENT_RECORD;
alias MENU_EVENT_RECORD _MENU_EVENT_RECORD;
alias MENU_EVENT_RECORD TMENUEVENTRECORD;
alias MENU_EVENT_RECORD* PMENUEVENTRECORD;

struct INPUT_RECORD
{
 ushort EventType;

 union
 {
  struct
  {
   KEY_EVENT_RECORD KeyEvent;
  }
  struct
  {
   MOUSE_EVENT_RECORD MouseEvent;
  }
  struct
  {
   WINDOW_BUFFER_SIZE_RECORD WindowBufferSizeEvent;
  }
  struct
  {
   MENU_EVENT_RECORD MenuEvent;
  }
  struct
  {
   FOCUS_EVENT_RECORD FocusEvent;
  }
 }
}

alias INPUT_RECORD* PINPUT_RECORD;
alias INPUT_RECORD _INPUT_RECORD;
alias INPUT_RECORD TINPUTRECORD;
alias INPUT_RECORD* PINPUTRECORD;

struct SYSTEMTIME
{
 ushort wYear;
 ushort wMonth;
 ushort wDayOfWeek;
 ushort wDay;
 ushort wHour;
 ushort wMinute;
 ushort wSecond;
 ushort wMilliseconds;
}

alias SYSTEMTIME* LPSYSTEMTIME;
alias SYSTEMTIME _SYSTEMTIME;
alias SYSTEMTIME TSYSTEMTIME;
alias SYSTEMTIME* PSYSTEMTIME;

struct JOB_INFO_1
{
 DWORD JobId;
 LPTSTR pPrinterName;
 LPTSTR pMachineName;
 LPTSTR pUserName;
 LPTSTR pDocument;
 LPTSTR pDatatype;
 LPTSTR pStatus;
 DWORD Status;
 DWORD Priority;
 DWORD Position;
 DWORD TotalPages;
 DWORD PagesPrinted;
 SYSTEMTIME Submitted;
}

alias JOB_INFO_1 _JOB_INFO_1;
alias JOB_INFO_1 TJOBINFO1;
alias JOB_INFO_1* PJOBINFO1;

struct SID_IDENTIFIER_AUTHORITY
{
 ubyte[1 + 5] Value;
}

alias SID_IDENTIFIER_AUTHORITY* LPSID_IDENTIFIER_AUTHORITY;
alias SID_IDENTIFIER_AUTHORITY* PSID_IDENTIFIER_AUTHORITY;
alias SID_IDENTIFIER_AUTHORITY _SID_IDENTIFIER_AUTHORITY;
alias SID_IDENTIFIER_AUTHORITY TSIDIDENTIFIERAUTHORITY;
alias SID_IDENTIFIER_AUTHORITY* PSIDIDENTIFIERAUTHORITY;

struct SID
{
 ubyte Revision;
 ubyte SubAuthorityCount;
 SID_IDENTIFIER_AUTHORITY IdentifierAuthority;
 DWORD[1 + ANYSIZE_ARRAY-1] SubAuthority;
}

alias SID _SID;
alias SID TSID;
alias SID* PSID;
alias ushort SECURITY_DESCRIPTOR_CONTROL;
alias SECURITY_DESCRIPTOR_CONTROL* PSECURITY_DESCRIPTOR_CONTROL;
alias SECURITY_DESCRIPTOR_CONTROL TSECURITYDESCRIPTORCONTROL;
alias SECURITY_DESCRIPTOR_CONTROL* PSECURITYDESCRIPTORCONTROL;

struct SECURITY_DESCRIPTOR
{
 ubyte Revision;
 ubyte Sbz1;
 SECURITY_DESCRIPTOR_CONTROL Control;
 PSID Owner;
 PSID Group;
 PACL Sacl;
 PACL Dacl;
}

alias SECURITY_DESCRIPTOR* PSECURITY_DESCRIPTOR;
alias SECURITY_DESCRIPTOR _SECURITY_DESCRIPTOR;
alias SECURITY_DESCRIPTOR TSECURITYDESCRIPTOR;
alias SECURITY_DESCRIPTOR* PSECURITYDESCRIPTOR;

struct JOB_INFO_2
{
 DWORD JobId;
 LPTSTR pPrinterName;
 LPTSTR pMachineName;
 LPTSTR pUserName;
 LPTSTR pDocument;
 LPTSTR pNotifyName;
 LPTSTR pDatatype;
 LPTSTR pPrintProcessor;
 LPTSTR pParameters;
 LPTSTR pDriverName;
 LPDEVMODE pDevMode;
 LPTSTR pStatus;
 PSECURITY_DESCRIPTOR pSecurityDescriptor;
 DWORD Status;
 DWORD Priority;
 DWORD Position;
 DWORD StartTime;
 DWORD UntilTime;
 DWORD TotalPages;
 DWORD Size;
 SYSTEMTIME Submitted;
 DWORD Time;
 DWORD PagesPrinted;
}

alias JOB_INFO_2 _JOB_INFO_2;
alias JOB_INFO_2 TJOBINFO2;
alias JOB_INFO_2* PJOBINFO2;

struct KERNINGPAIR
{
 ushort wFirst;
 ushort wSecond;
 int iKernAmount;
}

alias KERNINGPAIR* LPKERNINGPAIR;
alias KERNINGPAIR TAGKERNINGPAIR;
alias KERNINGPAIR TKERNINGPAIR;
alias KERNINGPAIR* PKERNINGPAIR;

struct LANA_ENUM
{
 UCHAR length;
 UCHAR[1 + MAX_LANA] lana;
}

alias LANA_ENUM _LANA_ENUM;
alias LANA_ENUM TLANAENUM;
alias LANA_ENUM* PLANAENUM;

struct LDT_ENTRY
{
 ushort LimitLow;
 ushort BaseLow;

 union
 {
  struct
  {
   ubyte BaseMid;
   ubyte Flags1;
   ubyte Flags2;
   ubyte BaseHi;
  }
  struct
  {
   int flag0;
  }
 }
}

alias LDT_ENTRY* LPLDT_ENTRY;
alias LDT_ENTRY* PLDT_ENTRY;
alias LDT_ENTRY _LDT_ENTRY;
alias LDT_ENTRY TLDTENTRY;
alias LDT_ENTRY* PLDTENTRY;
enum : DWORD 
{
 bm_LDT_ENTRY_BaseMid = (0xFF),
 bp_LDT_ENTRY_BaseMid = (0),
 bm_LDT_ENTRY_Type = (0x1F00),
 bp_LDT_ENTRY_Type = (8),
 bm_LDT_ENTRY_Dpl = (0x6000),
 bp_LDT_ENTRY_Dpl = (13),
 bm_LDT_ENTRY_Pres = (0x8000),
 bp_LDT_ENTRY_Pres = (15),
 bm_LDT_ENTRY_LimitHi = (0xF0000),
 bp_LDT_ENTRY_LimitHi = (16),
 bm_LDT_ENTRY_Sys = (0x100000),
 bp_LDT_ENTRY_Sys = (20),
 bm_LDT_ENTRY_Reserved_0 = (0x200000),
 bp_LDT_ENTRY_Reserved_0 = (21),
 bm_LDT_ENTRY_Default_Big = (0x400000),
 bp_LDT_ENTRY_Default_Big = (22),
 bm_LDT_ENTRY_Granularity = (0x800000),
 bp_LDT_ENTRY_Granularity = (23),
 bm_LDT_ENTRY_BaseHi = (0xFF000000),
 bp_LDT_ENTRY_BaseHi = (24),
}

struct LOCALESIGNATURE
{
 DWORD[1 + 3] lsUsb;
 DWORD[1 + 1] lsCsbDefault;
 DWORD[1 + 1] lsCsbSupported;
}

alias LOCALESIGNATURE TAGLOCALESIGNATURE;
alias LOCALESIGNATURE TLOCALESIGNATURE;
alias LOCALESIGNATURE* PLOCALESIGNATURE;

struct LOCALGROUP_MEMBERS_INFO_0
{
 PSID lgrmi0_sid;
}

alias LOCALGROUP_MEMBERS_INFO_0 _LOCALGROUP_MEMBERS_INFO_0;
alias LOCALGROUP_MEMBERS_INFO_0 TLOCALGROUPMEMBERSINFO0;
alias LOCALGROUP_MEMBERS_INFO_0* PLOCALGROUPMEMBERSINFO0;

struct LOCALGROUP_MEMBERS_INFO_3
{
 LPWSTR lgrmi3_domainandname;
}

alias LOCALGROUP_MEMBERS_INFO_3 _LOCALGROUP_MEMBERS_INFO_3;
alias LOCALGROUP_MEMBERS_INFO_3 TLOCALGROUPMEMBERSINFO3;
alias LOCALGROUP_MEMBERS_INFO_3* PLOCALGROUPMEMBERSINFO3;
alias int FXPT16DOT16;
alias FXPT16DOT16* LPFXPT16DOT16;
alias FXPT16DOT16 TFXPT16DOT16;
alias FXPT16DOT16* PFXPT16DOT16;
struct LUID {
 DWORD LowPart;
 LONG  HighPart;
}
alias LUID TLUID;
alias LUID* PLUID;

struct LUID_AND_ATTRIBUTES
{
 LUID Luid;
 DWORD Attributes;
}

alias LUID_AND_ATTRIBUTES _LUID_AND_ATTRIBUTES;
alias LUID_AND_ATTRIBUTES TLUIDANDATTRIBUTES;
alias LUID_AND_ATTRIBUTES* PLUIDANDATTRIBUTES;
alias LUID_AND_ATTRIBUTES[1 + ANYSIZE_ARRAY-1] LUID_AND_ATTRIBUTES_ARRAY;
alias LUID_AND_ATTRIBUTES_ARRAY* PLUID_AND_ATTRIBUTES_ARRAY;
alias LUID_AND_ATTRIBUTES_ARRAY TLUIDANDATTRIBUTESARRAY;
alias LUID_AND_ATTRIBUTES_ARRAY* PLUIDANDATTRIBUTESARRAY;

struct LVCOLUMNA 
{
 UINT mask;
 int fmt;
 int cx;
 LPSTR pszText;
 int cchTextMax;
 int iSubItem;
 int iImage;
 //if (_WIN32_IE >= 0x0300)
 int iOrder;
 //endif
 //if (_WIN32_WINNT >= 0x0600)
 //int cxMin;
 //int cxDefault;
 //int cxIdeal;
 //endif
}
struct LVCOLUMNW 
{
 UINT mask;
 int fmt;
 int cx;
 LPWSTR pszText;
 int cchTextMax;
 int iSubItem;
 int iImage;
 //if (_WIN32_IE >= 0x0300)
 int iOrder;
 //endif
 //if (_WIN32_WINNT >= 0x0600)
 //int cxMin;
 //int cxDefault;
 //int cxIdeal;
 //endif
}
version(Win32SansUnicode){
 alias LVCOLUMNA LVCOLUMN;
}else{
 alias LVCOLUMNW LVCOLUMN;
}
alias LVCOLUMN* LPLVCOLUMN;
alias LVCOLUMN LV_COLUMN;
alias LV_COLUMN _LV_COLUMN;
alias LV_COLUMN TLVCOLUMN;
alias LV_COLUMN* PLVCOLUMN;

struct LVITEMA 
{
 UINT   mask;
 int iItem;
 int iSubItem;
 UINT   state;
 UINT   stateMask;
 LPSTR  pszText;
 int cchTextMax;
 int iImage;
 LPARAM lParam;
//if (_WIN32_IE >= 0x0300)
 int iIndent;
//endif
//if (_WIN32_WINNT >= 0x560)
 int iGroupId;
 UINT cColumns; // tile view columns
 PUINT puColumns;
//endif
//if (_WIN32_WINNT >= 0x0600)
// int* piColFmt;
// int iGroup;
//endif
}
struct LVITEMW 
{
 UINT   mask;
 int iItem;
 int iSubItem;
 UINT   state;
 UINT   stateMask;
 LPWSTR  pszText;
 int cchTextMax;
 int iImage;
 LPARAM lParam;
//if (_WIN32_IE >= 0x0300)
 int iIndent;
//endif
//if (_WIN32_WINNT >= 0x560)
 int iGroupId;
 UINT cColumns; // tile view columns
 PUINT puColumns;
//endif
//if (_WIN32_WINNT >= 0x0600)
// int* piColFmt;
// int iGroup;
//endif
}
version(Win32SansUnicode){
 alias LVITEMA LVITEM;
}else{
 alias LVITEMW LVITEM;
}
alias LVITEM* LPLVITEM;
alias LVITEM LV_ITEM;

alias LV_ITEM _LV_ITEM;
alias LV_ITEM TLVITEM;
alias LV_ITEM* PLVITEM;

struct LV_DISPINFO
{
 NMHDR hdr;
 LV_ITEM item;
}

alias LV_DISPINFO TAGLV_DISPINFO;
alias LV_DISPINFO TLVDISPINFO;
alias LV_DISPINFO* PLVDISPINFO;

struct LV_FINDINFO
{
 UINT flags;
 LPCTSTR psz;
 LPARAM lParam;
 POINT pt;
 UINT vkDirection;
}

alias LV_FINDINFO _LV_FINDINFO;
alias LV_FINDINFO TLVFINDINFO;
alias LV_FINDINFO* PLVFINDINFO;

struct LVHITTESTINFO
{
 POINT pt;
 UINT flags;
 int iItem;
 int iSubItem;
//#if _WIN32_WINNT >= 0x0600
// int iGroup;
//#endif
}

alias LVHITTESTINFO LV_HITTESTINFO;

alias LV_HITTESTINFO _LV_HITTESTINFO;
alias LV_HITTESTINFO TLVHITTESTINFO;
alias LV_HITTESTINFO* PLVHITTESTINFO;

align(2) struct LV_KEYDOWN
{
 NMHDR hdr;
 ushort wVKey;
 UINT flags;
}

alias LV_KEYDOWN TAGLV_KEYDOWN;
alias LV_KEYDOWN TLVKEYDOWN;
alias LV_KEYDOWN* PLVKEYDOWN;

struct MAT2
{
 FIXED eM11;
 FIXED eM12;
 FIXED eM21;
 FIXED eM22;
}

alias MAT2 _MAT2;
alias MAT2 TMAT2;
alias MAT2* PMAT2;

struct MDICREATESTRUCT
{
 LPCTSTR szClass;
 LPCTSTR szTitle;
 HANDLE hOwner;
 int x;
 int y;
 int cx;
 int cy;
 DWORD style;
 LPARAM lParam;
}

alias MDICREATESTRUCT* LPMDICREATESTRUCT;
alias MDICREATESTRUCT TAGMDICREATESTRUCT;
alias MDICREATESTRUCT TMDICREATESTRUCT;
alias MDICREATESTRUCT* PMDICREATESTRUCT;

struct MEASUREITEMSTRUCT
{
 UINT CtlType;
 UINT CtlID;
 UINT itemID;
 UINT itemWidth;
 UINT itemHeight;
 DWORD itemData;
}

alias MEASUREITEMSTRUCT* LPMEASUREITEMSTRUCT;
alias MEASUREITEMSTRUCT TAGMEASUREITEMSTRUCT;
alias MEASUREITEMSTRUCT TMEASUREITEMSTRUCT;
alias MEASUREITEMSTRUCT* PMEASUREITEMSTRUCT;

struct MEMORY_BASIC_INFORMATION
{
 PVOID BaseAddress;
 PVOID AllocationBase;
 DWORD AllocationProtect;
 DWORD RegionSize;
 DWORD State;
 DWORD Protect;
 DWORD _Type;
}

alias MEMORY_BASIC_INFORMATION* PMEMORY_BASIC_INFORMATION;
alias MEMORY_BASIC_INFORMATION _MEMORY_BASIC_INFORMATION;
alias MEMORY_BASIC_INFORMATION TMEMORYBASICINFORMATION;
alias MEMORY_BASIC_INFORMATION* PMEMORYBASICINFORMATION;

struct MEMORYSTATUS
{
 DWORD dwLength;
 DWORD dwMemoryLoad;
 DWORD dwTotalPhys;
 DWORD dwAvailPhys;
 DWORD dwTotalPageFile;
 DWORD dwAvailPageFile;
 DWORD dwTotalVirtual;
 DWORD dwAvailVirtual;
}

alias MEMORYSTATUS* LPMEMORYSTATUS;
alias MEMORYSTATUS _MEMORYSTATUS;
alias MEMORYSTATUS TMEMORYSTATUS;
alias MEMORYSTATUS* PMEMORYSTATUS;

struct MENUEX_TEMPLATE_HEADER
{
 ushort wVersion;
 ushort wOffset;
 DWORD dwHelpId;
}

alias MENUEX_TEMPLATE_HEADER TMENUXTEMPLATEHEADER;
alias MENUEX_TEMPLATE_HEADER* PMENUXTEMPLATEHEADER;

struct MENUEX_TEMPLATE_ITEM
{
 DWORD dwType;
 DWORD dwState;
 UINT uId;
 ubyte bResInfo;
 WCHAR[1 + 0] szText;
 DWORD dwHelpId;
}

alias MENUEX_TEMPLATE_ITEM TMENUEXTEMPLATEITEM;
alias MENUEX_TEMPLATE_ITEM* PMENUEXTEMPLATEITEM;

/*
* Feature in Windows.  The hbmpItem field requires Windows 4.10
* or greater.  On Windows NT 4.0, passing in a larger struct size
* in the cbSize field does nothing.  On Windows 95, the MENUITEMINFO
* calls fail when the struct size is too large.  The fix is to ensure
* that the correct struct size is used for the Windows platform.
*/
struct MENUITEMINFOA
{
 UINT cbSize;
 UINT fMask;
 UINT fType;    // used if MIIM_TYPE
 UINT fState;   // used if MIIM_STATE
 UINT wID;   // used if MIIM_ID
 HMENU   hSubMenu;    // used if MIIM_SUBMENU
 HBITMAP hbmpChecked; // used if MIIM_CHECKMARKS
 HBITMAP hbmpUnchecked;  // used if MIIM_CHECKMARKS
 DWORD   dwItemData;  // used if MIIM_DATA
 LPSTR   dwTypeData;  // used if MIIM_TYPE
 UINT cch;   // used if MIIM_TYPE
 HBITMAP hbmpItem;
}
alias MENUITEMINFOA* PMENUITEMINFOA, LPMENUITEMINFOA;
struct MENUITEMINFOW
{
 UINT cbSize;
 UINT fMask;
 UINT fType;    // used if MIIM_TYPE
 UINT fState;   // used if MIIM_STATE
 UINT wID;   // used if MIIM_ID
 HMENU   hSubMenu;    // used if MIIM_SUBMENU
 HBITMAP hbmpChecked; // used if MIIM_CHECKMARKS
 HBITMAP hbmpUnchecked;  // used if MIIM_CHECKMARKS
 DWORD   dwItemData;  // used if MIIM_DATA
 LPWSTR  dwTypeData;  // used if MIIM_TYPE
 UINT cch;   // used if MIIM_TYPE
 HBITMAP hbmpItem;
}   alias MENUITEMINFOW* PMENUITEMINFOW, LPMENUITEMINFOW;
version(Win32SansUnicode)
{
 alias MENUITEMINFOA MENUITEMINFO;
}
else
{
 alias MENUITEMINFOW MENUITEMINFO;
}
alias MENUITEMINFO * LPMENUITEMINFO;
alias MENUITEMINFO * LPCMENUITEMINFO;
alias MENUITEMINFO TAGMENUITEMINFO;
alias MENUITEMINFO TMENUITEMINFO;
alias MENUITEMINFO TMENUITEMINFOA;
alias MENUITEMINFO* PMENUITEMINFO;

struct MENUITEMTEMPLATE
{
 ushort mtOption;
 ushort mtID;
 WCHAR[1 + 0] mtString;
}

alias MENUITEMTEMPLATE TMENUITEMTEMPLATE;
alias MENUITEMTEMPLATE* PMENUITEMTEMPLATE;

struct MENUITEMTEMPLATEHEADER
{
 ushort versionNumber;
 ushort offset;
}

alias MENUITEMTEMPLATEHEADER TMENUITEMTEMPLATEHEADER;
alias MENUITEMTEMPLATEHEADER* PMENUITEMTEMPLATEHEADER;

struct MENUTEMPLATE
{
}

alias MENUTEMPLATE* LPMENUTEMPLATE;
alias MENUTEMPLATE TMENUTEMPLATE;
alias MENUTEMPLATE* PMENUTEMPLATE;

struct METAFILEPICT
{
 LONG mm;
 LONG xExt;
 LONG yExt;
 HMETAFILE hMF;
}

alias METAFILEPICT* LPMETAFILEPICT;
alias METAFILEPICT TAGMETAFILEPICT;
alias METAFILEPICT TMETAFILEPICT;
alias METAFILEPICT* PMETAFILEPICT;

align(1) struct METAHEADER
{
 ushort mtType;
 ushort mtHeaderSize;
 ushort mtVersion;
 DWORD mtSize;
 ushort mtNoObjects;
 DWORD mtMaxRecord;
 ushort mtNoParameters;
}

alias METAHEADER TAGMETAHEADER;
alias METAHEADER TMETAHEADER;
alias METAHEADER* PMETAHEADER;

struct METARECORD
{
 DWORD rdSize;
 ushort rdFunction;
 ushort[1 + 0] rdParm;
}

alias METARECORD* LPMETARECORD;
alias METARECORD TAGMETARECORD;
alias METARECORD TMETARECORD;
alias METARECORD* PMETARECORD;

struct MINIMIZEDMETRICS
{
 UINT cbSize;
 int iWidth;
 int iHorzGap;
 int iVertGap;
 int iArrange;
}

alias MINIMIZEDMETRICS* LPMINIMIZEDMETRICS;
alias MINIMIZEDMETRICS TAGMINIMIZEDMETRICS;
alias MINIMIZEDMETRICS TMINIMIZEDMETRICS;
alias MINIMIZEDMETRICS* PMINIMIZEDMETRICS;

struct MINMAXINFO
{
 POINT ptReserved;
 POINT ptMaxSize;
 POINT ptMaxPosition;
 POINT ptMinTrackSize;
 POINT ptMaxTrackSize;
}

alias MINMAXINFO TAGMINMAXINFO;
alias MINMAXINFO TMINMAXINFO;
alias MINMAXINFO* PMINMAXINFO;

struct MODEMDEVCAPS
{
 DWORD dwActualSize;
 DWORD dwRequiredSize;
 DWORD dwDevSpecificOffset;
 DWORD dwDevSpecificSize;
 DWORD dwModemProviderVersion;
 DWORD dwModemManufacturerOffset;
 DWORD dwModemManufacturerSize;
 DWORD dwModemModelOffset;
 DWORD dwModemModelSize;
 DWORD dwModemVersionOffset;
 DWORD dwModemVersionSize;
 DWORD dwDialOptions;
 DWORD dwCallSetupFailTimer;
 DWORD dwInactivityTimeout;
 DWORD dwSpeakerVolume;
 DWORD dwSpeakerMode;
 DWORD dwModemOptions;
 DWORD dwMaxDTERate;
 DWORD dwMaxDCERate;
 ubyte[1 + 0] abVariablePortion;
}

alias MODEMDEVCAPS* LPMODEMDEVCAPS;
alias MODEMDEVCAPS TMODEMDEVCAPS;
alias MODEMDEVCAPS* PMODEMDEVCAPS;
alias MODEMDEVCAPS MODEMDEVCAPS_TAG;

struct MODEMSETTINGS
{
 DWORD dwActualSize;
 DWORD dwRequiredSize;
 DWORD dwDevSpecificOffset;
 DWORD dwDevSpecificSize;
 DWORD dwCallSetupFailTimer;
 DWORD dwInactivityTimeout;
 DWORD dwSpeakerVolume;
 DWORD dwSpeakerMode;
 DWORD dwPreferredModemOptions;
 DWORD dwNegotiatedModemOptions;
 DWORD dwNegotiatedDCERate;
 ubyte[1 + 0] abVariablePortion;
}

alias MODEMSETTINGS* LPMODEMSETTINGS;
alias MODEMSETTINGS TMODEMSETTINGS;
alias MODEMSETTINGS* PMODEMSETTINGS;
alias MODEMSETTINGS MODEMSETTINGS_TAG;

struct MONCBSTRUCT
{
 UINT cb;
 DWORD dwTime;
 HANDLE hTask;
 DWORD dwRet;
 UINT wType;
 UINT wFmt;
 HCONV hConv;
 HSZ hsz1;
 HSZ hsz2;
 HDDEDATA hData;
 DWORD dwData1;
 DWORD dwData2;
 CONVCONTEXT cc;
 DWORD cbData;
 DWORD[1 + 7] Data;
}

alias MONCBSTRUCT TAGMONCBSTRUCT;
alias MONCBSTRUCT TMONCBSTRUCT;
alias MONCBSTRUCT* PMONCBSTRUCT;

struct MONCONVSTRUCT
{
 UINT cb;
 WINBOOL fConnect;
 DWORD dwTime;
 HANDLE hTask;
 HSZ hszSvc;
 HSZ hszTopic;
 HCONV hConvClient;
 HCONV hConvServer;
}

alias MONCONVSTRUCT TAGMONCONVSTRUCT;
alias MONCONVSTRUCT TMONCONVSTRUCT;
alias MONCONVSTRUCT* PMONCONVSTRUCT;

struct MONERRSTRUCT
{
 UINT cb;
 UINT wLastError;
 DWORD dwTime;
 HANDLE hTask;
}

alias MONERRSTRUCT TAGMONERRSTRUCT;
alias MONERRSTRUCT TMONERRSTRUCT;
alias MONERRSTRUCT* PMONERRSTRUCT;

struct MONHSZSTRUCT
{
 UINT cb;
 WINBOOL fsAction;
 DWORD dwTime;
 HSZ hsz;
 HANDLE hTask;
 TCHAR[1 + 0] str;
}

alias MONHSZSTRUCT TAGMONHSZSTRUCT;
alias MONHSZSTRUCT TMONHSZSTRUCT;
alias MONHSZSTRUCT* PMONHSZSTRUCT;

struct MONITOR_INFO_1
{
 LPTSTR pName;
}

alias MONITOR_INFO_1 _MONITOR_INFO_1;
alias MONITOR_INFO_1 TMONITORINFO1;
alias MONITOR_INFO_1* PMONITORINFO1;

struct MONITOR_INFO_2
{
 LPTSTR pName;
 LPTSTR pEnvironment;
 LPTSTR pDLLName;
}

alias MONITOR_INFO_2 _MONITOR_INFO_2;
alias MONITOR_INFO_2 TMONITORINFO2;
alias MONITOR_INFO_2* PMONITORINFO2;

struct MONLINKSTRUCT
{
 UINT cb;
 DWORD dwTime;
 HANDLE hTask;
 WINBOOL fEstablished;
 WINBOOL fNoData;
 HSZ hszSvc;
 HSZ hszTopic;
 HSZ hszItem;
 UINT wFmt;
 WINBOOL fServer;
 HCONV hConvServer;
 HCONV hConvClient;
}

alias MONLINKSTRUCT TAGMONLINKSTRUCT;
alias MONLINKSTRUCT TMONLINKSTRUCT;
alias MONLINKSTRUCT* PMONLINKSTRUCT;

struct MONMSGSTRUCT
{
 UINT cb;
 HWND hwndTo;
 DWORD dwTime;
 HANDLE hTask;
 UINT wMsg;
 WPARAM wParam;
 LPARAM lParam;
 DDEML_MSG_HOOK_DATA dmhd;
}

alias MONMSGSTRUCT TAGMONMSGSTRUCT;
alias MONMSGSTRUCT TMONMSGSTRUCT;
alias MONMSGSTRUCT* PMONMSGSTRUCT;

struct MOUSEHOOKSTRUCT
{
 POINT pt;
 HWND hwnd;
 UINT wHitTestCode;
 DWORD dwExtraInfo;
}

alias MOUSEHOOKSTRUCT* LPMOUSEHOOKSTRUCT;
alias MOUSEHOOKSTRUCT TAGMOUSEHOOKSTRUCT;
alias MOUSEHOOKSTRUCT TMOUSEHOOKSTRUCT;
alias MOUSEHOOKSTRUCT* PMOUSEHOOKSTRUCT;

struct MOUSEKEYS
{
 DWORD cbSize;
 DWORD dwFlags;
 DWORD iMaxSpeed;
 DWORD iTimeToMaxSpeed;
 DWORD iCtrlSpeed;
 DWORD dwReserved1;
 DWORD dwReserved2;
}

alias MOUSEKEYS TMOUSEKEYS;
alias MOUSEKEYS* PMOUSEKEYS;

struct MSG
{
 HWND hwnd;
 UINT message;
 WPARAM wParam;
 LPARAM lParam;
 DWORD time;
 POINT pt;
}

alias MSG* LPMSG;
alias MSG TAGMSG;
alias MSG TMSG;
alias MSG* PMSG;
extern(Windows){
alias void (*MSGBOXCALLBACK)(LPHELPINFO);
}
alias MSGBOXCALLBACK TMSGBOXCALLBACK;

struct MSGBOXPARAMS
{
 UINT cbSize;
 HWND hwndOwner;
 HINST hInstance;
 LPCSTR lpszText;
 LPCSTR lpszCaption;
 DWORD dwStyle;
 LPCSTR lpszIcon;
 DWORD dwContextHelpId;
 MSGBOXCALLBACK lpfnMsgBoxCallback;
 DWORD dwLanguageId;
}

alias MSGBOXPARAMS* LPMSGBOXPARAMS;
alias MSGBOXPARAMS TMSGBOXPARAMS;
alias MSGBOXPARAMS TMSGBOXPARAMSA;
alias MSGBOXPARAMS* PMSGBOXPARAMS;

struct MSGFILTER
{
 NMHDR nmhdr;
 UINT msg;
 WPARAM wParam;
 LPARAM lParam;
}

alias MSGFILTER _MSGFILTER;
alias MSGFILTER TMSGFILTER;
alias MSGFILTER* PMSGFILTER;

struct MULTIKEYHELP
{
 DWORD mkSize;
 TCHAR mkKeylist;
 TCHAR[1 + 0] szKeyphrase;
}

alias MULTIKEYHELP TAGMULTIKEYHELP;
alias MULTIKEYHELP TMULTIKEYHELP;
alias MULTIKEYHELP* PMULTIKEYHELP;

struct NAME_BUFFER
{
 UCHAR[1 + NCBNAMSZ-1] name;
 UCHAR name_num;
 UCHAR name_flags;
}

alias NAME_BUFFER _NAME_BUFFER;
alias NAME_BUFFER TNAMEBUFFER;
alias NAME_BUFFER* PNAMEBUFFER;
alias _NCB* P_NCB;

struct NCB
{
 UCHAR ncb_command;
 UCHAR ncb_retcode;
 UCHAR ncb_lsn;
 UCHAR ncb_num;
 PUCHAR ncb_buffer;
 ushort ncb_length;
 UCHAR[1 + NCBNAMSZ-1] ncb_callname;
 UCHAR[1 + NCBNAMSZ-1] ncb_name;
 UCHAR ncb_rto;
 UCHAR ncb_sto;
 POINTER ncb_post;
 UCHAR ncb_lana_num;
 UCHAR ncb_cmd_cplt;
 UCHAR[1 + 9] ncb_reserve;
 HANDLE ncb_event;
}

alias NCB _NCB;
alias NCB TNCB;
alias NCB* PNCB;

struct NCCALCSIZE_PARAMS
{
 RECT[1 + 2] rgrc;
 PWINDOWPOS lppos;
}

alias NCCALCSIZE_PARAMS _NCCALCSIZE_PARAMS;
alias NCCALCSIZE_PARAMS TNCCALCSIZEPARAMS;
alias NCCALCSIZE_PARAMS* PNCCALCSIZEPARAMS;

struct NDDESHAREINFO
{
 LONG lRevision;
 LPTSTR lpszShareName;
 LONG lShareType;
 LPTSTR lpszAppTopicList;
 LONG fSharedFlag;
 LONG fService;
 LONG fStartAppFlag;
 LONG nCmdShow;
 LONG[1 + 1] qModifyId;
 LONG cNumItems;
 LPTSTR lpszItemList;
}

alias NDDESHAREINFO _NDDESHAREINFO;
alias NDDESHAREINFO TNDDESHAREINFO;
alias NDDESHAREINFO* PNDDESHAREINFO;

struct NETRESOURCE
{
 DWORD dwScope;
 DWORD dwType;
 DWORD dwDisplayType;
 DWORD dwUsage;
 LPTSTR lpLocalName;
 LPTSTR lpRemoteName;
 LPTSTR lpComment;
 LPTSTR lpProvider;
}

alias NETRESOURCE* LPNETRESOURCE;
alias NETRESOURCE _NETRESOURCE;
alias NETRESOURCE TNETRESOURCE;
alias NETRESOURCE TNETRESOURCEA;
alias NETRESOURCE* PNETRESOURCE;
alias NETRESOURCE* PNETRESOURCEA;

struct NEWCPLINFO
{
 DWORD dwSize;
 DWORD dwFlags;
 DWORD dwHelpContext;
 LONG lData;
 HICON hIcon;
 TCHAR[1 + 31] szName;
 TCHAR[1 + 63] szInfo;
 TCHAR[1 + 127] szHelpFile;
}

alias NEWCPLINFO TAGNEWCPLINFO;
alias NEWCPLINFO TNEWCPLINFO;
alias NEWCPLINFO* PNEWCPLINFO;

struct NEWTEXTMETRICA 
{
 LONG   tmHeight;
 LONG   tmAscent;
 LONG   tmDescent;
 LONG   tmInternalLeading;
 LONG   tmExternalLeading;
 LONG   tmAveCharWidth;
 LONG   tmMaxCharWidth;
 LONG   tmWeight;
 LONG   tmOverhang;
 LONG   tmDigitizedAspectX;
 LONG   tmDigitizedAspectY;
 BYTE  tmFirstChar;
 BYTE  tmLastChar;
 BYTE  tmDefaultChar;
 BYTE  tmBreakChar;
 BYTE   tmItalic;
 BYTE   tmUnderlined;
 BYTE   tmStruckOut;
 BYTE   tmPitchAndFamily;
 BYTE   tmCharSet;
 DWORD  ntmFlags;
 UINT   ntmSizeEM;
 UINT   ntmCellHeight;
 UINT   ntmAvgWidth;
}
struct NEWTEXTMETRICW 
{
 LONG   tmHeight;
 LONG   tmAscent;
 LONG   tmDescent;
 LONG   tmInternalLeading;
 LONG   tmExternalLeading;
 LONG   tmAveCharWidth;
 LONG   tmMaxCharWidth;
 LONG   tmWeight;
 LONG   tmOverhang;
 LONG   tmDigitizedAspectX;
 LONG   tmDigitizedAspectY;
 WCHAR  tmFirstChar;
 WCHAR  tmLastChar;
 WCHAR  tmDefaultChar;
 WCHAR  tmBreakChar;
 BYTE   tmItalic;
 BYTE   tmUnderlined;
 BYTE   tmStruckOut;
 BYTE   tmPitchAndFamily;
 BYTE   tmCharSet;
 DWORD  ntmFlags;
 UINT   ntmSizeEM;
 UINT   ntmCellHeight;
 UINT   ntmAvgWidth;
}

struct NEWTEXTMETRICEXA
{
 NEWTEXTMETRICA  ntmentm;
 FONTSIGNATURE  ntmeFontSignature;
}
struct NEWTEXTMETRICEXW
{
 NEWTEXTMETRICW  ntmentm;
 FONTSIGNATURE  ntmeFontSignature;
}


version(Win32SansUnicode)
{
 alias NEWTEXTMETRICA NEWTEXTMETRIC;
 alias NEWTEXTMETRICEXA NEWTEXTMETRICEX;
}
else
{
 alias NEWTEXTMETRICW NEWTEXTMETRIC;
 alias NEWTEXTMETRICEXW NEWTEXTMETRICEX;
}

alias NEWTEXTMETRIC TNEWTEXTMETRIC;
alias NEWTEXTMETRIC* PNEWTEXTMETRIC;
alias NEWTEXTMETRIC* LPNEWTEXTMETRIC;
alias NEWTEXTMETRIC TAGNEWTEXTMETRIC;
alias NEWTEXTMETRICEX TAGNEWTEXTMETRICEX;
alias NEWTEXTMETRICEX TNEWTEXTMETRICEX;
alias NEWTEXTMETRICEX* PNEWTEXTMETRICEX;

struct NM_LISTVIEW
{
 NMHDR hdr;
 int iItem;
 int iSubItem;
 UINT uNewState;
 UINT uOldState;
 UINT uChanged;
 POINT ptAction;
 LPARAM lParam;
}

alias NM_LISTVIEW TAGNM_LISTVIEW;
alias NM_LISTVIEW TNMLISTVIEW;
alias NM_LISTVIEW* PNMLISTVIEW;

struct TVITEMA
{
 UINT   mask;
 HTREEITEM hItem;
 UINT   state;
 UINT   stateMask;
 LPSTR  pszText;
 int    cchTextMax;
 int    iImage;
 int    iSelectedImage;
 int    cChildren;
 LPARAM lParam;
}
struct TVITEMW
{
 UINT   mask;
 HTREEITEM hItem;
 UINT   state;
 UINT   stateMask;
 LPWSTR pszText;
 int    cchTextMax;
 int    iImage;
 int    iSelectedImage;
 int    cChildren;
 LPARAM lParam;
}
version(Win32SansUnicode)
{
 alias TVITEMA TVITEM;
}
else
{
 alias TVITEMW TVITEM;
}
alias TVITEM* LPTVITEM;
alias TVITEM* LPTV_ITEM;
alias TVITEM _TV_ITEM;
alias TVITEM TTVITEM;
alias TVITEM TV_ITEM;
alias TVITEM* PTVITEM;

struct TVITEMEXA {
 UINT   mask;
 HTREEITEM hItem;
 UINT   state;
 UINT   stateMask;
 LPSTR  pszText;
 int    cchTextMax;
 int    iImage;
 int    iSelectedImage;
 int    cChildren;
 LPARAM lParam;
 int    iIntegral;
//#if (_WIN32_IE >= 0x0600)
// UINT   uStateEx;
// HWND   hwnd;
// int    iExpandedImage;
//#endif
}
struct TVITEMEXW {
 UINT   mask;
 HTREEITEM hItem;
 UINT   state;
 UINT   stateMask;
 LPWSTR pszText;
 int    cchTextMax;
 int    iImage;
 int    iSelectedImage;
 int    cChildren;
 LPARAM lParam;
 int    iIntegral;
//#if (_WIN32_IE >= 0x0600)
// UINT   uStateEx;
// HWND   hwnd;
// int    iExpandedImage;
//#endif
}
version(Win32SansUnicode)
{
 alias TVITEMEXA TVITEMEX;
}
else
{
 alias TVITEMEXW TVITEMEX;
}
alias TVITEMEX * LPTVITEMEX;

struct NMTREEVIEW
{
 NMHDR hdr;
 UINT action;
 TVITEM itemOld;
 TVITEM itemNew;
 POINT ptDrag;
}
alias NMTREEVIEW* PNMTREEVIEW;
alias NMTREEVIEW* LPNMTREEVIEW;
alias NMTREEVIEW  NM_TREEVIEW;
alias NM_TREEVIEW* LPNM_TREEVIEW;
alias NM_TREEVIEW _NM_TREEVIEW;
alias NM_TREEVIEW TNMTREEVIEW;

struct NM_UPDOWNW
{
 NMHDR hdr;
 int iPos;
 int iDelta;
}

alias NM_UPDOWNW _NM_UPDOWN;
alias NM_UPDOWNW TNMUPDOWN;
alias NM_UPDOWNW* PNMUPDOWN;
alias NM_UPDOWNW NMUPDOWN;

struct NONCLIENTMETRICSA 
{
 int cbSize;
 int iBorderWidth;
 int iScrollWidth;
 int iScrollHeight;
 int iCaptionWidth;
 int iCaptionHeight;
 LOGFONTA lfCaptionFont;
 int iSmCaptionWidth;
 int iSmCaptionHeight;
 LOGFONTA lfSmCaptionFont;
 int iMenuWidth;
 int iMenuHeight;
 LOGFONTA lfMenuFont;
 LOGFONTA lfStatusFont;
 LOGFONTA lfMessageFont;
//if (WINVER >= 0x0600)
//  int iPaddedBorderWidth;
//endif 

}
struct NONCLIENTMETRICSW 
{
 int cbSize;
 int iBorderWidth;
 int iScrollWidth;
 int iScrollHeight;
 int iCaptionWidth;
 int iCaptionHeight;
 LOGFONTW lfCaptionFont;
 int iSmCaptionWidth;
 int iSmCaptionHeight;
 LOGFONTW lfSmCaptionFont;
 int iMenuWidth;
 int iMenuHeight;
 LOGFONTW lfMenuFont;
 LOGFONTW lfStatusFont;
 LOGFONTW lfMessageFont;
//if (WINVER >= 0x0600)
//  int iPaddedBorderWidth;
//endif 
}
version(Win32SansUnicode)
{
 alias NONCLIENTMETRICSA NONCLIENTMETRICS;
}
else
{
 alias NONCLIENTMETRICSW NONCLIENTMETRICS;
}
alias NONCLIENTMETRICS* LPNONCLIENTMETRICS;
alias NONCLIENTMETRICS TAGNONCLIENTMETRICS;
alias NONCLIENTMETRICS TNONCLIENTMETRICS;
alias NONCLIENTMETRICS* PNONCLIENTMETRICS;

struct SERVICE_ADDRESS
{
 DWORD dwAddressType;
 DWORD dwAddressFlags;
 DWORD dwAddressLength;
 DWORD dwPrincipalLength;
 ubyte* lpAddress;
 ubyte* lpPrincipal;
}

alias SERVICE_ADDRESS _SERVICE_ADDRESS;
alias SERVICE_ADDRESS TSERVICEADDRESS;
alias SERVICE_ADDRESS* PSERVICEADDRESS;

struct SERVICE_ADDRESSES
{
 DWORD dwAddressCount;
 SERVICE_ADDRESS[1 + 0] Addresses;
}

alias SERVICE_ADDRESSES* LPSERVICE_ADDRESSES;
alias SERVICE_ADDRESSES _SERVICE_ADDRESSES;
alias SERVICE_ADDRESSES TSERVICEADDRESSES;
alias SERVICE_ADDRESSES* PSERVICEADDRESSES;

align(1) struct __GUID
{

 union
 {
  struct
  {
   uint Data1;
   ushort Data2;
   ushort Data3;
   ubyte[1 + 7] Data4;
  }
  struct
  {
   uint D1;
   ushort D2;
   ushort D3;
   ubyte[1 + 7] D4;
  }
 }
}

alias __GUID* LPGUID;
alias __GUID _GUID;
alias __GUID GUID;
alias __GUID TGUID;
alias __GUID* PGUID;
alias __GUID __CLSID;
alias __CLSID* LPCLSID;
alias __CLSID TCLSID;
alias __CLSID* PCLSID;

struct SERVICE_INFO
{
 LPGUID lpServiceType;
 LPTSTR lpServiceName;
 LPTSTR lpComment;
 LPTSTR lpLocale;
 DWORD dwDisplayHint;
 DWORD dwVersion;
 DWORD dwTime;
 LPTSTR lpMachineName;
 LPSERVICE_ADDRESSES lpServiceAddress;
 BLOB ServiceSpecificInfo;
}

alias SERVICE_INFO _SERVICE_INFO;
alias SERVICE_INFO TSERVICEINFO;
alias SERVICE_INFO* PSERVICEINFO;

struct NS_SERVICE_INFO
{
 DWORD dwNameSpace;
 SERVICE_INFO ServiceInfo;
}

alias NS_SERVICE_INFO _NS_SERVICE_INFO;
alias NS_SERVICE_INFO TNSSERVICEINFO;
alias NS_SERVICE_INFO* PNSSERVICEINFO;

struct NUMBERFMT
{
 UINT NumDigits;
 UINT LeadingZero;
 UINT Grouping;
 LPTSTR lpDecimalSep;
 LPTSTR lpThousandSep;
 UINT NegativeOrder;
}

alias NUMBERFMT _NUMBERFMT;
alias NUMBERFMT TNUMBERFMT;
alias NUMBERFMT* PNUMBERFMT;

struct OFSTRUCT
{
 ubyte cBytes;
 ubyte fFixedDisk;
 ushort nErrCode;
 ushort Reserved1;
 ushort Reserved2;
 char[1 + OFS_MAXPATHNAME-1] szPathName;
}

alias OFSTRUCT* LPOFSTRUCT;
alias OFSTRUCT _OFSTRUCT;
alias OFSTRUCT TOFSTRUCT;
alias OFSTRUCT* POFSTRUCT;

struct OPENFILENAME
{
 DWORD lStructSize;
 HWND hwndOwner;
 HINST hInstance;
 LPCTSTR lpstrFilter;
 LPTSTR lpstrCustomFilter;
 DWORD nMaxCustFilter;
 DWORD nFilterIndex;
 LPTSTR lpstrFile;
 DWORD nMaxFile;
 LPTSTR lpstrFileTitle;
 DWORD nMaxFileTitle;
 LPCTSTR lpstrInitialDir;
 LPCTSTR lpstrTitle;
 DWORD Flags;
 ushort nFileOffset;
 ushort nFileExtension;
 LPCTSTR lpstrDefExt;
 DWORD lCustData;
 LPOFNHOOKPROC lpfnHook;
 LPCTSTR lpTemplateName;
//if (_WIN32_WINNT >= 0x0500)
  void *  pvReserved;
  DWORD   dwReserved;
  DWORD   FlagsEx;
//endif // (_WIN32_WINNT >= 0x0500)
}

alias OPENFILENAME* LPOPENFILENAME;
alias OPENFILENAME TOPENFILENAME;
alias OPENFILENAME* POPENFILENAME;
alias OPENFILENAME TAGOFN;
alias OPENFILENAME TOFN;
alias OPENFILENAME* POFN;

struct OFNOTIFY
{
 NMHDR hdr;
 LPOPENFILENAME lpOFN;
 LPTSTR pszFile;
}

alias OFNOTIFY* LPOFNOTIFY;
alias OFNOTIFY _OFNOTIFY;
alias OFNOTIFY TOFNOTIFY;
alias OFNOTIFY* POFNOTIFY;

struct OSVERSIONINFOA
{
 DWORD dwOSVersionInfoSize;
 DWORD dwMajorVersion;
 DWORD dwMinorVersion;
 DWORD dwBuildNumber;
 DWORD dwPlatformId;
 CHAR szCSDVersion[ 128 ];
}
alias OSVERSIONINFOA* POSVERSIONINFOA, LPOSVERSIONINFOA;

struct OSVERSIONINFOW
{
 DWORD dwOSVersionInfoSize;
 DWORD dwMajorVersion;
 DWORD dwMinorVersion;
 DWORD dwBuildNumber;
 DWORD dwPlatformId;
 WCHAR szCSDVersion[ 128 ];
}
alias OSVERSIONINFOW* POSVERSIONINFOW, LPOSVERSIONINFOW;
version(Win32SansUnicode)
{
 alias OSVERSIONINFOA OSVERSIONINFO;
}
else
{
 alias OSVERSIONINFOW OSVERSIONINFO;
}
alias OSVERSIONINFO* LPOSVERSIONINFO;
alias OSVERSIONINFO _OSVERSIONINFO;
alias OSVERSIONINFO TOSVERSIONINFO;
alias OSVERSIONINFO* POSVERSIONINFO;

struct TEXTMETRICA 
{
 LONG tmHeight;
 LONG tmAscent;
 LONG tmDescent;
 LONG tmInternalLeading;
 LONG tmExternalLeading;
 LONG tmAveCharWidth;
 LONG tmMaxCharWidth;
 LONG tmWeight;
 LONG tmOverhang;
 LONG tmDigitizedAspectX;
 LONG tmDigitizedAspectY;

 BYTE tmFirstChar;
 BYTE tmLastChar;
 BYTE tmDefaultChar;
 BYTE tmBreakChar;

 BYTE tmItalic;
 BYTE tmUnderlined;
 BYTE tmStruckOut;
 BYTE tmPitchAndFamily;
 BYTE tmCharSet;
}
struct TEXTMETRICW {
 LONG tmHeight;
 LONG tmAscent;
 LONG tmDescent;
 LONG tmInternalLeading;
 LONG tmExternalLeading;
 LONG tmAveCharWidth;
 LONG tmMaxCharWidth;
 LONG tmWeight;
 LONG tmOverhang;
 LONG tmDigitizedAspectX;
 LONG tmDigitizedAspectY;

 WCHAR tmFirstChar;
 WCHAR tmLastChar;
 WCHAR tmDefaultChar;
 WCHAR tmBreakChar;

 BYTE tmItalic;
 BYTE tmUnderlined;
 BYTE tmStruckOut;
 BYTE tmPitchAndFamily;
 BYTE tmCharSet;
}
version(Win32SansUnicode)
{
 alias TEXTMETRICA TEXTMETRIC;
}
else
{
 alias TEXTMETRICW TEXTMETRIC;
}
alias TEXTMETRIC* LPTEXTMETRIC;
alias TEXTMETRIC TAGTEXTMETRIC;
alias TEXTMETRIC TTEXTMETRIC;
alias TEXTMETRIC* PTEXTMETRIC;

struct OUTLINETEXTMETRICA
{
 UINT    otmSize;
 TEXTMETRICA otmTextMetrics;
 BYTE    otmFiller;
 PANOSE  otmPanoseNumber;
 UINT    otmfsSelection;
 UINT    otmfsType;
 int  otmsCharSlopeRise;
 int  otmsCharSlopeRun;
 int  otmItalicAngle;
 UINT    otmEMSquare;
 int  otmAscent;
 int  otmDescent;
 UINT    otmLineGap;
 UINT    otmsCapEmHeight;
 UINT    otmsXHeight;
 RECT    otmrcFontBox;
 int  otmMacAscent;
 int  otmMacDescent;
 UINT    otmMacLineGap;
 UINT    otmusMinimumPPEM;
 POINT   otmptSubscriptSize;
 POINT   otmptSubscriptOffset;
 POINT   otmptSuperscriptSize;
 POINT   otmptSuperscriptOffset;
 UINT    otmsStrikeoutSize;
 int  otmsStrikeoutPosition;
 int  otmsUnderscoreSize;
 int  otmsUnderscorePosition;
 PSTR    otmpFamilyName;
 PSTR    otmpFaceName;
 PSTR    otmpStyleName;
 PSTR    otmpFullName;
}

struct OUTLINETEXTMETRICW
{
 UINT    otmSize;
 TEXTMETRICW otmTextMetrics;
 BYTE    otmFiller;
 PANOSE  otmPanoseNumber;
 UINT    otmfsSelection;
 UINT    otmfsType;
 int  otmsCharSlopeRise;
 int  otmsCharSlopeRun;
 int  otmItalicAngle;
 UINT    otmEMSquare;
 int  otmAscent;
 int  otmDescent;
 UINT    otmLineGap;
 UINT    otmsCapEmHeight;
 UINT    otmsXHeight;
 RECT    otmrcFontBox;
 int  otmMacAscent;
 int  otmMacDescent;
 UINT    otmMacLineGap;
 UINT    otmusMinimumPPEM;
 POINT   otmptSubscriptSize;
 POINT   otmptSubscriptOffset;
 POINT   otmptSuperscriptSize;
 POINT   otmptSuperscriptOffset;
 UINT    otmsStrikeoutSize;
 int  otmsStrikeoutPosition;
 int  otmsUnderscoreSize;
 int  otmsUnderscorePosition;
 PSTR    otmpFamilyName;
 PSTR    otmpFaceName;
 PSTR    otmpStyleName;
 PSTR    otmpFullName;
}

alias OUTLINETEXTMETRIC* LPOUTLINETEXTMETRIC;
alias OUTLINETEXTMETRIC _OUTLINETEXTMETRIC;
alias OUTLINETEXTMETRIC TOUTLINETEXTMETRIC;
alias OUTLINETEXTMETRIC* POUTLINETEXTMETRIC;
version(Win32SansUnicode)
{
 alias OUTLINETEXTMETRICA OUTLINETEXTMETRIC;
 alias OUTLINETEXTMETRICA* LPOUTLINETEXTMETRICA;
}
else
{
 alias OUTLINETEXTMETRICW OUTLINETEXTMETRIC;
 alias OUTLINETEXTMETRICW* LPOUTLINETEXTMETRICW;
}

struct OVERLAPPED
{
 DWORD Internal;
 DWORD InternalHigh;
 DWORD Offset;
 DWORD OffsetHigh;
 HANDLE hEvent;
}

alias OVERLAPPED* LPOVERLAPPED;
alias OVERLAPPED _OVERLAPPED;
alias OVERLAPPED TOVERLAPPED;
alias OVERLAPPED* POVERLAPPED;

struct OVERLAPPED_ENTRY
{
 ULONG_PTR lpCompletionKey;
 LPOVERLAPPED lpOverlapped;
 ULONG_PTR Internal;
 DWORD  dwNumberofBytesTransferred;
}

struct TPAGESETUPDLG
{
 DWORD lStructSize;
 HWND hwndOwner;
 HGLOBAL hDevMode;
 HGLOBAL hDevNames;
 DWORD Flags;
 POINT ptPaperSize;
 RECT rtMinMargin;
 RECT rtMargin;
 HINST hInstance;
 LPARAM lCustData;
 LPPAGESETUPHOOK lpfnPageSetupHook;
 LPPAGEPAINTHOOK lpfnPagePaintHook;
 LPCTSTR lpPageSetupTemplateName;
 HGLOBAL hPageSetupTemplate;
}

alias TPAGESETUPDLG PAGESETUPDLG;
alias TPAGESETUPDLG* LPPAGESETUPDLG;
alias TPAGESETUPDLG* PPAGESETUPDLG;
alias TPAGESETUPDLG TAGPSD;
alias TPAGESETUPDLG TPSD;
alias TPAGESETUPDLG* PPSD;

struct PAINTSTRUCT
{
 HDC hdc;
 WINBOOL fErase;
 RECT rcPaint;
 WINBOOL fRestore;
 WINBOOL fIncUpdate;
 ubyte[1 + 31] rgbReserved;
}

alias PAINTSTRUCT* LPPAINTSTRUCT;
alias PAINTSTRUCT TAGPAINTSTRUCT;
alias PAINTSTRUCT TPAINTSTRUCT;
alias PAINTSTRUCT* PPAINTSTRUCT;

struct PARAFORMAT
{
 UINT cbSize;
 DWORD dwMask;
 ushort wNumbering;
 ushort wReserved;
 LONG dxStartIndent;
 LONG dxRightIndent;
 LONG dxOffset;
 ushort wAlignment;
 SHORT cTabCount;
 LONG[1 + MAX_TAB_STOPS-1] rgxTabs;
}

alias PARAFORMAT _PARAFORMAT;
alias PARAFORMAT TPARAFORMAT;
alias PARAFORMAT* PPARAFORMAT;

struct PERF_COUNTER_BLOCK
{
 DWORD ByteLength;
}

alias PERF_COUNTER_BLOCK _PERF_COUNTER_BLOCK;
alias PERF_COUNTER_BLOCK TPERFCOUNTERBLOCK;
alias PERF_COUNTER_BLOCK* PPERFCOUNTERBLOCK;

struct PERF_COUNTER_DEFINITION
{
 DWORD ByteLength;
 DWORD CounterNameTitleIndex;
 LPWSTR CounterNameTitle;
 DWORD CounterHelpTitleIndex;
 LPWSTR CounterHelpTitle;
 DWORD DefaultScale;
 DWORD DetailLevel;
 DWORD CounterType;
 DWORD CounterSize;
 DWORD CounterOffset;
}

alias PERF_COUNTER_DEFINITION _PERF_COUNTER_DEFINITION;
alias PERF_COUNTER_DEFINITION TPERFCOUNTERDEFINITION;
alias PERF_COUNTER_DEFINITION* PPERFCOUNTERDEFINITION;

struct PERF_DATA_BLOCK
{
 WCHAR[1 + 3] Signature;
 DWORD LittleEndian;
 DWORD Version;
 DWORD Revision;
 DWORD TotalByteLength;
 DWORD HeaderLength;
 DWORD NumObjectTypes;
 DWORD DefaultObject;
 SYSTEMTIME SystemTime;
 LARGE_INTEGER PerfTime;
 LARGE_INTEGER PerfFreq;
 LARGE_INTEGER PerfTime100nSec;
 DWORD SystemNameLength;
 DWORD SystemNameOffset;
}

alias PERF_DATA_BLOCK _PERF_DATA_BLOCK;
alias PERF_DATA_BLOCK TPERFDATABLOCK;
alias PERF_DATA_BLOCK* PPERFDATABLOCK;

struct PERF_INSTANCE_DEFINITION
{
 DWORD ByteLength;
 DWORD ParentObjectTitleIndex;
 DWORD ParentObjectInstance;
 DWORD UniqueID;
 DWORD NameOffset;
 DWORD NameLength;
}

alias PERF_INSTANCE_DEFINITION _PERF_INSTANCE_DEFINITION;
alias PERF_INSTANCE_DEFINITION TPERFINSTANCEDEFINITION;
alias PERF_INSTANCE_DEFINITION PPERFINSTANCEDEFINITION;

struct PERF_OBJECT_TYPE
{
 DWORD TotalByteLength;
 DWORD DefinitionLength;
 DWORD HeaderLength;
 DWORD ObjectNameTitleIndex;
 LPWSTR ObjectNameTitle;
 DWORD ObjectHelpTitleIndex;
 LPWSTR ObjectHelpTitle;
 DWORD DetailLevel;
 DWORD NumCounters;
 DWORD DefaultCounter;
 DWORD NumInstances;
 DWORD CodePage;
 LARGE_INTEGER PerfTime;
 LARGE_INTEGER PerfFreq;
}

alias PERF_OBJECT_TYPE _PERF_OBJECT_TYPE;
alias PERF_OBJECT_TYPE TPERFOBJECTTYPE;
alias PERF_OBJECT_TYPE* PPERFOBJECTTYPE;

struct POLYTEXT
{
 int x;
 int y;
 UINT n;
 LPCTSTR lpstr;
 UINT uiFlags;
 RECT rcl;
 int* pdx;
}

alias POLYTEXT _POLYTEXT;
alias POLYTEXT TPOLYTEXT;
alias POLYTEXT* PPOLYTEXT;

struct PORT_INFO_1
{
 LPTSTR pName;
}

alias PORT_INFO_1 _PORT_INFO_1;
alias PORT_INFO_1 TPORTINFO1;
alias PORT_INFO_1* PPORTINFO1;

struct PORT_INFO_2
{
 LPSTR pPortName;
 LPSTR pMonitorName;
 LPSTR pDescription;
 DWORD fPortType;
 DWORD Reserved;
}

alias PORT_INFO_2 _PORT_INFO_2;
alias PORT_INFO_2 TPORTINFO2;
alias PORT_INFO_2* PPORTINFO2;

struct PREVENT_MEDIA_REMOVAL
{
 ubyte PreventMediaRemoval;
}

alias PREVENT_MEDIA_REMOVAL _PREVENT_MEDIA_REMOVAL;
alias PREVENT_MEDIA_REMOVAL TPREVENTMEDIAREMOVAL;
alias PREVENT_MEDIA_REMOVAL* PPREVENTMEDIAREMOVAL;

align(2) struct PRINTDLGA 
{  // pd
 DWORD  lStructSize;
 HWND   hwndOwner;
 HANDLE hDevMode;
 HANDLE hDevNames;
 HDC    hDC;
 DWORD  Flags;
 WORD   nFromPage;
 WORD   nToPage;
 WORD   nMinPage;
 WORD   nMaxPage;
 WORD   nCopies;
 HINSTANCE hInstance;
 DWORD  lCustData;
 LPPRINTHOOKPROC lpfnPrintHook;
 LPSETUPHOOKPROC lpfnSetupHook;
 LPCSTR lpPrintTemplateName;
 LPCSTR lpSetupTemplateName;
 HANDLE hPrintTemplate;
 HANDLE hSetupTemplate;
}

alias PRINTDLGA* PPRINTDLGA;
alias PRINTDLGA* LPPRINTDLGA;
align(2) struct PRINTDLGW 
{  // pd
 DWORD  lStructSize;
 HWND   hwndOwner;
 HANDLE hDevMode;
 HANDLE hDevNames;
 HDC    hDC;
 DWORD  Flags;
 WORD   nFromPage;
 WORD   nToPage;
 WORD   nMinPage;
 WORD   nMaxPage;
 WORD   nCopies;
 HINSTANCE hInstance;
 DWORD  lCustData;
 LPPRINTHOOKPROC lpfnPrintHook;
 LPSETUPHOOKPROC lpfnSetupHook;
 LPCWSTR lpPrintTemplateName;
 LPCWSTR lpSetupTemplateName;
 HANDLE hPrintTemplate;
 HANDLE hSetupTemplate;
}
alias PRINTDLGW* PPRINTDLGW;
alias PRINTDLGW* LPPRINTDLGW;

version(Win32SansUnicode){
 alias PRINTDLGA PRINTDLG;
}else{
 alias PRINTDLGW PRINTDLG;
}


alias PRINTDLG* LPPRINTDLG;
alias PRINTDLG* PPRINTDLG;
alias PRINTDLG TAGPD;
alias PRINTDLG TPD;
alias PRINTDLG* PPD;

struct PRINTER_DEFAULTS
{
 LPTSTR pDatatype;
 LPDEVMODE pDevMode;
 ACCESS_MASK DesiredAccess;
}

alias PRINTER_DEFAULTS _PRINTER_DEFAULTS;
alias PRINTER_DEFAULTS TPRINTERDEFAULTS;
alias PRINTER_DEFAULTS* PPRINTERDEFAULTS;

struct PRINTER_INFO_1
{
 DWORD Flags;
 LPTSTR pDescription;
 LPTSTR pName;
 LPTSTR pComment;
}

alias PRINTER_INFO_1* LPPRINTER_INFO_1;
alias PRINTER_INFO_1* PPRINTER_INFO_1;
alias PRINTER_INFO_1 _PRINTER_INFO_1;
alias PRINTER_INFO_1 TPRINTERINFO1;
alias PRINTER_INFO_1* PPRINTERINFO1;

struct PRINTER_INFO_2
{
 LPTSTR pServerName;
 LPTSTR pPrinterName;
 LPTSTR pShareName;
 LPTSTR pPortName;
 LPTSTR pDriverName;
 LPTSTR pComment;
 LPTSTR pLocation;
 LPDEVMODE pDevMode;
 LPTSTR pSepFile;
 LPTSTR pPrintProcessor;
 LPTSTR pDatatype;
 LPTSTR pParameters;
 PSECURITY_DESCRIPTOR pSecurityDescriptor;
 DWORD Attributes;
 DWORD Priority;
 DWORD DefaultPriority;
 DWORD StartTime;
 DWORD UntilTime;
 DWORD Status;
 DWORD cJobs;
 DWORD AveragePPM;
}

alias PRINTER_INFO_2 _PRINTER_INFO_2;
alias PRINTER_INFO_2 TPRINTERINFO2;
alias PRINTER_INFO_2* PPRINTERINFO2;

struct PRINTER_INFO_3
{
 PSECURITY_DESCRIPTOR pSecurityDescriptor;
}

alias PRINTER_INFO_3 _PRINTER_INFO_3;
alias PRINTER_INFO_3 TPRINTERINFO3;
alias PRINTER_INFO_3* PPRINTERINFO3;

struct PRINTER_INFO_4
{
 LPTSTR pPrinterName;
 LPTSTR pServerName;
 DWORD Attributes;
}

alias PRINTER_INFO_4 _PRINTER_INFO_4;
alias PRINTER_INFO_4 TPRINTERINFO4;
alias PRINTER_INFO_4* PPRINTERINFO4;

struct PRINTER_INFO_5
{
 LPTSTR pPrinterName;
 LPTSTR pPortName;
 DWORD Attributes;
 DWORD DeviceNotSelectedTimeout;
 DWORD TransmissionRetryTimeout;
}

alias PRINTER_INFO_5 _PRINTER_INFO_5;
alias PRINTER_INFO_5 TPRINTERINFO5;
alias PRINTER_INFO_5* PPRINTERINFO5;

struct PRINTER_NOTIFY_INFO_DATA
{
 ushort _Type;
 ushort Field;
 DWORD Reserved;
 DWORD Id;

 union
 {
  struct
  {
   DWORD[1 + 1] adwData;
  }
  struct
  {
   DWORD cbBuf;
   LPVOID pBuf;
  }
 }
}

alias PRINTER_NOTIFY_INFO_DATA _PRINTER_NOTIFY_INFO_DATA;
alias PRINTER_NOTIFY_INFO_DATA TPRINTERNOTIFYINFODATA;
alias PRINTER_NOTIFY_INFO_DATA* PPRINTERNOTIFYINFODATA;

struct PRINTER_NOTIFY_INFO
{
 DWORD Version;
 DWORD Flags;
 DWORD Count;
 PRINTER_NOTIFY_INFO_DATA[1 + 0] aData;
}

alias PRINTER_NOTIFY_INFO _PRINTER_NOTIFY_INFO;
alias PRINTER_NOTIFY_INFO TPRINTERNOTIFYINFO;
alias PRINTER_NOTIFY_INFO* PPRINTERNOTIFYINFO;

struct PRINTER_NOTIFY_OPTIONS_TYPE
{
 ushort _Type;
 ushort Reserved0;
 DWORD Reserved1;
 DWORD Reserved2;
 DWORD Count;
 PWORD pFields;
}

alias PRINTER_NOTIFY_OPTIONS_TYPE* PPRINTER_NOTIFY_OPTIONS_TYPE;
alias PRINTER_NOTIFY_OPTIONS_TYPE _PRINTER_NOTIFY_OPTIONS_TYPE;
alias PRINTER_NOTIFY_OPTIONS_TYPE TPRINTERNOTIFYOPTIONSTYPE;
alias PRINTER_NOTIFY_OPTIONS_TYPE* PPRINTERNOTIFYOPTIONSTYPE;

struct PRINTER_NOTIFY_OPTIONS
{
 DWORD Version;
 DWORD Flags;
 DWORD Count;
 PPRINTER_NOTIFY_OPTIONS_TYPE pTypes;
}

alias PRINTER_NOTIFY_OPTIONS _PRINTER_NOTIFY_OPTIONS;
alias PRINTER_NOTIFY_OPTIONS TPRINTERNOTIFYOPTIONS;
alias PRINTER_NOTIFY_OPTIONS* PPRINTERNOTIFYOPTIONS;

struct PRINTPROCESSOR_INFO_1
{
 LPTSTR pName;
}

alias PRINTPROCESSOR_INFO_1 _PRINTPROCESSOR_INFO_1;
alias PRINTPROCESSOR_INFO_1 TPRINTPROCESSORINFO1;
alias PRINTPROCESSOR_INFO_1* PPRINTPROCESSORINFO1;

struct PRIVILEGE_SET
{
 DWORD PrivilegeCount;
 DWORD Control;
 LUID_AND_ATTRIBUTES[1 + ANYSIZE_ARRAY-1] Privilege;
}

alias PRIVILEGE_SET* LPPRIVILEGE_SET;
alias PRIVILEGE_SET* PPRIVILEGE_SET;
alias PRIVILEGE_SET _PRIVILEGE_SET;
alias PRIVILEGE_SET TPRIVILEGESET;
alias PRIVILEGE_SET* PPRIVILEGESET;

struct PROCESS_HEAPENTRY
{
 PVOID lpData;
 DWORD cbData;
 ubyte cbOverhead;
 ubyte iRegionIndex;
 ushort wFlags;
 DWORD dwCommittedSize;
 DWORD dwUnCommittedSize;
 LPVOID lpFirstBlock;
 LPVOID lpLastBlock;
 HANDLE hMem;
}

alias PROCESS_HEAPENTRY* LPPROCESS_HEAP_ENTRY;
alias PROCESS_HEAPENTRY _PROCESS_HEAP_ENTRY;
alias PROCESS_HEAPENTRY TPROCESSHEAPENTRY;
alias PROCESS_HEAPENTRY* PPROCESSHEAPENTRY;

struct PROCESS_INFORMATION
{
 HANDLE hProcess;
 HANDLE hThread;
 DWORD dwProcessId;
 DWORD dwThreadId;
}

alias PROCESS_INFORMATION* LPPROCESS_INFORMATION;
alias PROCESS_INFORMATION _PROCESS_INFORMATION;
alias PROCESS_INFORMATION TPROCESSINFORMATION;
alias PROCESS_INFORMATION* PPROCESSINFORMATION;
extern(Windows){alias UINT (*LPFNPSPCALLBACK)(HWND, UINT, LPVOID);}
alias LPFNPSPCALLBACK TFNPSPCALLBACK;


struct PROPSHEETPAGE
{
 DWORD dwSize;
 DWORD dwFlags;
 HINST hInstance;
 union {
  LPCTSTR pszTemplate;
  LPCDLGTEMPLATE pResource;
 }
 union {
  HICON hIcon;
  LPCTSTR pszIcon;
 }
 LPCTSTR pszTitle;
 DLGPROC pfnDlgProc;
 LPARAM lParam;
 LPFNPSPCALLBACK pfnCallback;
 UINT* pcRefParent;
//if (_WIN32_IE >= 0x0500)
 LPCTSTR pszHeaderTitle;
 LPCTSTR pszHeaderSubTitle;
//endif
//if (_WIN32_WINNT >= 0x0501)
 HANDLE hActCtx;
//endif
}

alias PROPSHEETPAGE* LPPROPSHEETPAGE;
alias PROPSHEETPAGE* LPCPROPSHEETPAGE;
alias PROPSHEETPAGE _PROPSHEETPAGE;
alias PROPSHEETPAGE TPROPSHEETPAGE;
alias PROPSHEETPAGE* PPROPSHEETPAGE;

struct EMPTYRECORD
{
}

alias EMPTYRECORD* HPROPSHEETPAGE;

struct PROPSHEETHEADER_U1
{

 union
 {
  struct
  {
   HICON hIcon;
  }
  struct
  {
   LPCTSTR pszIcon;
  }
 }
}


struct PROPSHEETHEADER_U2
{

 union
 {
  struct
  {
   UINT nStartPage;
  }
  struct
  {
   LPCTSTR pStartPage;
  }
 }
}


struct PROPSHEETHEADER_U3
{

 union
 {
  struct
  {
   LPCPROPSHEETPAGE ppsp;
  }
  struct
  {
   HPROPSHEETPAGE* phpage;
  }
 }
}


struct PROPSHEETHEADER
{
 DWORD dwSize;
 DWORD dwFlags;
 HWND hwndParent;
 HINST hInstance;
 PROPSHEETHEADER_U1 u1;
 LPCTSTR pszCaption;
 UINT nPages;
 PROPSHEETHEADER_U2 u2;
 PROPSHEETHEADER_U3 u3;
 PFNPROPSHEETCALLBACK pfnCallback;
//if (_WIN32_IE >= 0x0400)
 union {
  HBITMAP hbmWatermark;
  LPCTSTR pszbmWatermark;
 }
 HPALETTE hplWatermark;
 union {
  HBITMAP hbmHeader; 
  LPCSTR pszbmHeader;
 }
//endif
}

alias PROPSHEETHEADER* LPPROPSHEETHEADER;
alias PROPSHEETHEADER* LPCPROPSHEETHEADER;
alias PROPSHEETHEADER _PROPSHEETHEADER;
alias PROPSHEETHEADER TPROPSHEETHEADER;
alias PROPSHEETHEADER* PPROPSHEETHEADER;
extern(Windows){
alias WINBOOL (*LPFNADDPROPSHEETPAGE)(HPROPSHEETPAGE, LPARAM);
alias WINBOOL (*LPFNADDPROPSHEETPAGES)(LPVOID, LPFNADDPROPSHEETPAGE, LPARAM);
}
alias LPFNADDPROPSHEETPAGE TFNADDPROPSHEETPAGE;
alias LPFNADDPROPSHEETPAGES TFNADDPROPSHEETPAGES;

struct PROTOCOL_INFO
{
 DWORD dwServiceFlags;
 INT iAddressFamily;
 INT iMaxSockAddr;
 INT iMinSockAddr;
 INT iSocketType;
 INT iProtocol;
 DWORD dwMessageSize;
 LPTSTR lpProtocol;
}

alias PROTOCOL_INFO _PROTOCOL_INFO;
alias PROTOCOL_INFO TPROTOCOLINFO;
alias PROTOCOL_INFO* PPROTOCOLINFO;

struct PROVIDOR_INFO_1
{
 LPTSTR pName;
 LPTSTR pEnvironment;
 LPTSTR pDLLName;
}

alias PROVIDOR_INFO_1 _PROVIDOR_INFO_1;
alias PROVIDOR_INFO_1 TPROVIDORINFO1;
alias PROVIDOR_INFO_1* PPROVIDORINFO1;

struct PSHNOTIFY
{
 NMHDR hdr;
 LPARAM lParam;
}

alias PSHNOTIFY* LPPSHNOTIFY;
alias PSHNOTIFY _PSHNOTIFY;
alias PSHNOTIFY TPSHNOTIFY;
alias PSHNOTIFY* PPSHNOTIFY;

struct PUNCTUATION
{
 UINT iSize;
 LPSTR szPunctuation;
}

alias PUNCTUATION _PUNCTUATION;
alias PUNCTUATION TPUNCTUATION;
alias PUNCTUATION* PPUNCTUATION;

struct QUERY_SERVICE_CONFIG
{
 DWORD dwServiceType;
 DWORD dwStartType;
 DWORD dwErrorControl;
 LPTSTR lpBinaryPathName;
 LPTSTR lpLoadOrderGroup;
 DWORD dwTagId;
 LPTSTR lpDependencies;
 LPTSTR lpServiceStartName;
 LPTSTR lpDisplayName;
}

alias QUERY_SERVICE_CONFIG* LPQUERY_SERVICE_CONFIG;
alias QUERY_SERVICE_CONFIG _QUERY_SERVICE_CONFIG;
alias QUERY_SERVICE_CONFIG TQUERYSERVICECONFIG;
alias QUERY_SERVICE_CONFIG* PQUERYSERVICECONFIG;

struct QUERY_SERVICE_LOCK_STATUS
{
 DWORD fIsLocked;
 LPTSTR lpLockOwner;
 DWORD dwLockDuration;
}

alias QUERY_SERVICE_LOCK_STATUS* LPQUERY_SERVICE_LOCK_STATUS;
alias QUERY_SERVICE_LOCK_STATUS _QUERY_SERVICE_LOCK_STATUS;
alias QUERY_SERVICE_LOCK_STATUS TQUERYSERVICELOCKSTATUS;
alias QUERY_SERVICE_LOCK_STATUS* PQUERYSERVICELOCKSTATUS;

struct RASAMB
{
 DWORD dwSize;
 DWORD dwError;
 TCHAR[1 + NETBIOS_NAME_LEN+1-1] szNetBiosError;
 ubyte bLana;
}

alias RASAMB _RASAMB;
alias RASAMB TRASAMB;
alias RASAMB* PRASAMB;

struct RASCONN
{
 DWORD dwSize;
 HRASCONN hrasconn;
 TCHAR[1 + RAS_MaxEntryName+1-1] szEntryName;
 char[1 + RAS_MaxDeviceType+1-1] szDeviceType;
 char[1 + RAS_MaxDeviceName+1-1] szDeviceName;
}

alias RASCONN _RASCONN;
alias RASCONN TRASCONN;
alias RASCONN* PRASCONN;

struct RASCONNSTATUS
{
 DWORD dwSize;
 RASCONNSTATE rasconnstate;
 DWORD dwError;
 TCHAR[1 + RAS_MaxDeviceType+1-1] szDeviceType;
 TCHAR[1 + RAS_MaxDeviceName+1-1] szDeviceName;
}

alias RASCONNSTATUS _RASCONNSTATUS;
alias RASCONNSTATUS TRASCONNSTATUS;
alias RASCONNSTATUS* PRASCONNSTATUS;

struct RASDIALEXTENSIONS
{
 DWORD dwSize;
 DWORD dwfOptions;
 HWND hwndParent;
 DWORD reserved;
}

alias RASDIALEXTENSIONS _RASDIALEXTENSIONS;
alias RASDIALEXTENSIONS TRASDIALEXTENSIONS;
alias RASDIALEXTENSIONS* PRASDIALEXTENSIONS;

struct RASDIALPARAMS
{
 DWORD dwSize;
 TCHAR[1 + RAS_MaxEntryName+1-1] szEntryName;
 TCHAR[1 + RAS_MaxPhoneNumber+1-1] szPhoneNumber;
 TCHAR[1 + (RAS_MaxCallbackNumber+1)-1] szCallbackNumber;
 TCHAR[1 + (UNLEN+1)-1] szUserName;
 TCHAR[1 + (PWLEN+1)-1] szPassword;
 TCHAR[1 + (DNLEN+1)-1] szDomain;
}

alias RASDIALPARAMS _RASDIALPARAMS;
alias RASDIALPARAMS TRASDIALPARAMS;
alias RASDIALPARAMS* PRASDIALPARAMS;

struct RASENTRYNAME
{
 DWORD dwSize;
 TCHAR[1 + (RAS_MaxEntryName+1)-1] szEntryName;
}

alias RASENTRYNAME _RASENTRYNAME;
alias RASENTRYNAME TRASENTRYNAME;
alias RASENTRYNAME* PRASENTRYNAME;

struct RASPPPIP
{
 DWORD dwSize;
 DWORD dwError;
 TCHAR[RAS_MaxIpAddress+1] szIpAddress;
}

alias RASPPPIP _RASPPPIP;
alias RASPPPIP TRASPPPIP;
alias RASPPPIP* PRASPPPIP;

struct RASPPPIPX
{
 DWORD dwSize;
 DWORD dwError;
 TCHAR[1 + (RAS_MaxIpxAddress+1)-1] szIpxAddress;
}

alias RASPPPIPX _RASPPPIPX;
alias RASPPPIPX TRASPPPIPX;
alias RASPPPIPX* PRASPPPIPX;

struct RASPPPNBF
{
 DWORD dwSize;
 DWORD dwError;
 DWORD dwNetBiosError;
 TCHAR[1 + (NETBIOS_NAME_LEN+1)-1] szNetBiosError;
 TCHAR[1 + (NETBIOS_NAME_LEN+1)-1] szWorkstationName;
 ubyte bLana;
}

alias RASPPPNBF _RASPPPNBF;
alias RASPPPNBF TRASPPPNBF;
alias RASPPPNBF* PRASPPPNBF;

struct RASTERIZER_STATUS
{
 short nSize;
 short wFlags;
 short nLanguageID;
}

alias RASTERIZER_STATUS* LPRASTERIZER_STATUS;
alias RASTERIZER_STATUS _RASTERIZER_STATUS;
alias RASTERIZER_STATUS TRASTERIZERSTATUS;
alias RASTERIZER_STATUS* PRASTERIZERSTATUS;

struct REASSIGN_BLOCKS
{
 ushort Reserved;
 ushort Count;
 DWORD[1 + 0] BlockNumber;
}

alias REASSIGN_BLOCKS _REASSIGN_BLOCKS;
alias REASSIGN_BLOCKS TREASSIGNBLOCKS;
alias REASSIGN_BLOCKS* PREASSIGNBLOCKS;

struct REMOTE_NAME_INFO
{
 LPTSTR lpUniversalName;
 LPTSTR lpConnectionName;
 LPTSTR lpRemainingPath;
}

alias REMOTE_NAME_INFO _REMOTE_NAME_INFO;
alias REMOTE_NAME_INFO TREMOTENAMEINFO;
alias REMOTE_NAME_INFO* PREMOTENAMEINFO;

struct REPASTESPECIAL
{
 DWORD dwAspect;
 DWORD dwParam;
}

alias REPASTESPECIAL _REPASTESPECIAL;
alias REPASTESPECIAL TREPASTESPECIAL;
alias REPASTESPECIAL* PREPASTESPECIAL;

struct REQRESIZE
{
 NMHDR nmhdr;
 RECT rc;
}

alias REQRESIZE _REQRESIZE;
alias REQRESIZE TREQRESIZE;
alias REQRESIZE* PREQRESIZE;

struct RGNDATAHEADER
{
 DWORD dwSize;
 DWORD iType;
 DWORD nCount;
 DWORD nRgnSize;
 RECT rcBound;
}

alias RGNDATAHEADER _RGNDATAHEADER;
alias RGNDATAHEADER TRGNDATAHEADER;
alias RGNDATAHEADER* PRGNDATAHEADER;
alias RGNDATAHEADER* LPRGNDATAHEADER;

struct RGNDATA
{
 RGNDATAHEADER rdh;
 char[1 + 0] Buffer;
}

alias RGNDATA* LPRGNDATA;
alias RGNDATA _RGNDATA;
alias RGNDATA TRGNDATA;
alias RGNDATA* PRGNDATA;

struct SCROLLINFO
{
 UINT cbSize;
 UINT fMask;
 int nMin;
 int nMax;
 UINT nPage;
 int nPos;
 int nTrackPos;
}

alias SCROLLINFO* LPSCROLLINFO;
alias SCROLLINFO* LPCSCROLLINFO;
alias SCROLLINFO TAGSCROLLINFO;
alias SCROLLINFO TSCROLLINFO;
alias SCROLLINFO* PSCROLLINFO;

struct SECURITY_ATTRIBUTES
{
 DWORD nLength;
 LPVOID lpSecurityDescriptor;
 WINBOOL bInheritHandle;
}

alias SECURITY_ATTRIBUTES* LPSECURITY_ATTRIBUTES;
alias SECURITY_ATTRIBUTES _SECURITY_ATTRIBUTES;
alias SECURITY_ATTRIBUTES TSECURITYATTRIBUTES;
alias SECURITY_ATTRIBUTES* PSECURITYATTRIBUTES;
alias DWORD SECURITY_INFORMATION;
alias SECURITY_INFORMATION* PSECURITY_INFORMATION;
alias SECURITY_INFORMATION TSECURITYINFORMATION;
alias SECURITY_INFORMATION* PSECURITYINFORMATION;

struct SELCHANGE
{
 NMHDR nmhdr;
 CHARRANGE chrg;
 ushort seltyp;
}

alias SELCHANGE _SELCHANGE;
alias SELCHANGE TSELCHANGE;
alias SELCHANGE* PSELCHANGE;

struct SERIALKEYS
{
 DWORD cbSize;
 DWORD dwFlags;
 LPSTR lpszActivePort;
 LPSTR lpszPort;
 DWORD iBaudRate;
 DWORD iPortState;
 UINT  iActive;
}

alias SERIALKEYS* LPSERIALKEYS;
alias SERIALKEYS TAGSERIALKEYS;
alias SERIALKEYS TSERIALKEYS;
alias SERIALKEYS* PSERIALKEYS;

struct SERVICE_TABLE_ENTRY
{
 LPTSTR lpServiceName;
 LPSERVICE_MAIN_FUNCTION lpServiceProc;
}

alias SERVICE_TABLE_ENTRY* LPSERVICE_TABLE_ENTRY;
alias SERVICE_TABLE_ENTRY _SERVICE_TABLE_ENTRY;
alias SERVICE_TABLE_ENTRY TSERVICETABLEENTRY;
alias SERVICE_TABLE_ENTRY* PSERVICETABLEENTRY;

struct SERVICE_TYPE_VALUE_ABS
{
 DWORD dwNameSpace;
 DWORD dwValueType;
 DWORD dwValueSize;
 LPTSTR lpValueName;
 PVOID lpValue;
}

alias SERVICE_TYPE_VALUE_ABS _SERVICE_TYPE_VALUE_ABS;
alias SERVICE_TYPE_VALUE_ABS TSERVICETYPEVALUEABS;
alias SERVICE_TYPE_VALUE_ABS* PSERVICETYPEVALUEABS;

struct SERVICE_TYPE_INFO_ABS
{
 LPTSTR lpTypeName;
 DWORD dwValueCount;
 SERVICE_TYPE_VALUE_ABS[1 + 0] Values;
}

alias SERVICE_TYPE_INFO_ABS _SERVICE_TYPE_INFO_ABS;
alias SERVICE_TYPE_INFO_ABS TSERVICETYPEINFOABS;
alias SERVICE_TYPE_INFO_ABS* PSERVICETYPEINFOABS;

struct SESSION_BUFFER
{
 UCHAR lsn;
 UCHAR state;
 UCHAR[1 + NCBNAMSZ-1] local_name;
 UCHAR[1 + NCBNAMSZ-1] remote_name;
 UCHAR rcvs_outstanding;
 UCHAR sends_outstanding;
}

alias SESSION_BUFFER _SESSION_BUFFER;
alias SESSION_BUFFER TSESSIONBUFFER;
alias SESSION_BUFFER* PSESSIONBUFFER;

struct SESSION_HEADER
{
 UCHAR sess_name;
 UCHAR num_sess;
 UCHAR rcv_dg_outstanding;
 UCHAR rcv_any_outstanding;
}

alias SESSION_HEADER _SESSION_HEADER;
alias SESSION_HEADER TSESSIONHEADER;
alias SESSION_HEADER* PSESSIONHEADER;

struct SET_PARTITION_INFORMATION
{
 ubyte PartitionType;
}

alias SET_PARTITION_INFORMATION _SET_PARTITION_INFORMATION;
alias SET_PARTITION_INFORMATION TSETPARTITIONINFORMATION;
alias SET_PARTITION_INFORMATION* PSETPARTITIONINFORMATION;
alias int SHCONTF;
enum { SHCONTF_FOLDERS = 32, SHCONTF_NONFOLDERS = 64, SHCONTF_INCLUDEHIDDEN = 128,  };
alias SHCONTF TAGSHCONTF;
alias SHCONTF TSHCONTF;

struct SHFILEINFOA
{
 HICON hIcon;
 int iIcon;
 DWORD dwAttributes;
 CHAR[MAX_PATH] szDisplayName;
 CHAR[80] szTypeName;
}
struct SHFILEINFOW
{
 HICON hIcon;
 int iIcon;
 DWORD dwAttributes;
 WCHAR[MAX_PATH] szDisplayName;
 WCHAR[80] szTypeName;
}
version(Win32SansUnicode)
{
 alias SHFILEINFOA SHFILEINFO;
}
else
{
 alias SHFILEINFOW SHFILEINFO;
}

alias SHFILEINFO _SHFILEINFO;
alias SHFILEINFO TSHFILEINFO;
alias SHFILEINFO* PSHFILEINFO;

alias ushort FILEOP_FLAGS;
alias FILEOP_FLAGS TFILEOPFLAGS;
alias FILEOP_FLAGS* PFILEOPFLAGS;

const FILEOP_FLAGS
 FOF_MULTIDESTFILES  = 0x0001,
 FOF_CONFIRMMOUSE    = 0x0002,
 FOF_SILENT    = 0x0004,
 FOF_RENAMEONCOLLISION  = 0x0008,
 FOF_NOCONFIRMATION  = 0x0010,
 FOF_WANTMAPPINGHANDLE  = 0x0020,
 FOF_ALLOWUNDO    = 0x0040,
 FOF_FILESONLY    = 0x0080,
 FOF_SIMPLEPROGRESS  = 0x0100,
 FOF_NOCONFIRMMKDIR  = 0x0200,
 FOF_NOERRORUI    = 0x0400,
 FOF_NOCOPYSECURITYATTRIBS = 0x0800;

enum : UINT 
{
 FO_MOVE = 1,
 FO_COPY,
 FO_DELETE,
 FO_RENAME
}

align(2) struct SHFILEOPSTRUCTA 
{
 HWND   hwnd;
 UINT   wFunc;
 LPCSTR    pFrom;
 LPCSTR    pTo;
 FILEOP_FLAGS fFlags;
 BOOL   fAnyOperationsAborted;
 PVOID  hNameMappings;
 LPCSTR    lpszProgressTitle;
}
alias SHFILEOPSTRUCTA* LPSHFILEOPSTRUCTA;

align(2) struct SHFILEOPSTRUCTW 
{
 HWND   hwnd;
 UINT   wFunc;
 LPCWSTR   pFrom;
 LPCWSTR   pTo;
 FILEOP_FLAGS fFlags;
 BOOL   fAnyOperationsAborted;
 PVOID  hNameMappings;
 LPCWSTR   lpszProgressTitle;
}
alias SHFILEOPSTRUCTW* LPSHFILEOPSTRUCTW;

version(Win32SansUnicode) {
 alias SHFILEOPSTRUCTA* LPSHFILEOPSTRUCT;
 alias SHFILEOPSTRUCTA _SHFILEOPSTRUCT;
 alias SHFILEOPSTRUCTA TSHFILEOPSTRUCT;
 alias SHFILEOPSTRUCTA* PSHFILEOPSTRUCT;
 alias SHFILEOPSTRUCTA SHFILEOPSTRUCT;
}
else {
 alias SHFILEOPSTRUCTW* LPSHFILEOPSTRUCT;
 alias SHFILEOPSTRUCTW _SHFILEOPSTRUCT;
 alias SHFILEOPSTRUCTW TSHFILEOPSTRUCT;
 alias SHFILEOPSTRUCTW* PSHFILEOPSTRUCT;
 alias SHFILEOPSTRUCTW SHFILEOPSTRUCT;
}

alias int SHGNO;
enum { SHGDN_NORMAL = 0, SHGDN_INFOLDER = 1, SHGDN_FORPARSING = 0x8000,  };
alias SHGNO TAGSHGDN;
alias SHGNO TSHGDN;

struct SHNAMEMAPPING
{
 LPSTR pszOldPath;
 LPSTR pszNewPath;
 int cchOldPath;
 int cchNewPath;
}

alias SHNAMEMAPPING* LPSHNAMEMAPPING;
alias SHNAMEMAPPING _SHNAMEMAPPING;
alias SHNAMEMAPPING TSHNAMEMAPPING;
alias SHNAMEMAPPING* PSHNAMEMAPPING;

struct SID_AND_ATTRIBUTES
{
 PSID Sid;
 DWORD Attributes;
}

alias SID_AND_ATTRIBUTES _SID_AND_ATTRIBUTES;
alias SID_AND_ATTRIBUTES TSIDANDATTRIBUTES;
alias SID_AND_ATTRIBUTES* PSIDANDATTRIBUTES;
alias SID_AND_ATTRIBUTES[1 + ANYSIZE_ARRAY-1] SID_AND_ATTRIBUTES_ARRAY;
alias SID_AND_ATTRIBUTES_ARRAY* PSID_AND_ATTRIBUTES_ARRAY;
alias SID_AND_ATTRIBUTES_ARRAY TSIDANDATTRIBUTESARRAY;
alias SID_AND_ATTRIBUTES_ARRAY* PSIDANDATTRIBUTESARRAY;

struct SINGLE_LIST_ENTRY
{
 _SINGLE_LIST_ENTRY* Next;
}

alias SINGLE_LIST_ENTRY _SINGLE_LIST_ENTRY;
alias SINGLE_LIST_ENTRY TSINGLELISTENTRY;
alias SINGLE_LIST_ENTRY* PSINGLELISTENTRY;

struct SOUNDSENTRY
{
 UINT cbSize;
 DWORD dwFlags;
 DWORD iFSTextEffect;
 DWORD iFSTextEffectMSec;
 DWORD iFSTextEffectColorBits;
 DWORD iFSGrafEffect;
 DWORD iFSGrafEffectMSec;
 DWORD iFSGrafEffectColor;
 DWORD iWindowsEffect;
 DWORD iWindowsEffectMSec;
 LPTSTR lpszWindowsEffectDLL;
 DWORD iWindowsEffectOrdinal;
}

alias SOUNDSENTRY* LPSOUNDSENTRY;
alias SOUNDSENTRY TAGSOUNDSENTRY;
alias SOUNDSENTRY TSOUNDSENTRY;
alias SOUNDSENTRY* PSOUNDSENTRY;

struct STARTUPINFO
{
 DWORD cb;
 LPTSTR lpReserved;
 LPTSTR lpDesktop;
 LPTSTR lpTitle;
 DWORD dwX;
 DWORD dwY;
 DWORD dwXSize;
 DWORD dwYSize;
 DWORD dwXCountChars;
 DWORD dwYCountChars;
 DWORD dwFillAttribute;
 DWORD dwFlags;
 ushort wShowWindow;
 ushort cbReserved2;
 LPBYTE lpReserved2;
 HANDLE hStdInput;
 HANDLE hStdOutput;
 HANDLE hStdError;
}

alias STARTUPINFO* LPSTARTUPINFO;
alias STARTUPINFO _STARTUPINFO;
alias STARTUPINFO TSTARTUPINFO;
alias STARTUPINFO* PSTARTUPINFO;

struct STICKYKEYS
{
 DWORD cbSize;
 DWORD dwFlags;
}

alias STICKYKEYS* LPSTICKYKEYS;
alias STICKYKEYS TAGSTICKYKEYS;
alias STICKYKEYS TSTICKYKEYS;
alias STICKYKEYS* PSTICKYKEYS;

struct STRRET
{
 UINT uType;

 union
 {
  struct
  {
   LPWSTR pOleStr;
  }
  struct
  {
   UINT uOffset;
  }
  struct
  {
   char[1 + MAX_PATH-1] cStr;
  }
 }
}

alias STRRET* LPSTRRET;
alias STRRET _STRRET;
alias STRRET TSTRRET;
alias STRRET* PSTRRET;

struct STYLEBUF
{
 DWORD dwStyle;
 TCHAR[1 + 31] szDescription;
}

alias STYLEBUF* LPSTYLEBUF;
alias STYLEBUF _TAGSTYLEBUF;
alias STYLEBUF TSTYLEBUF;
alias STYLEBUF* PSTYLEBUF;

struct STYLESTRUCT
{
 DWORD styleOld;
 DWORD styleNew;
}

alias STYLESTRUCT* LPSTYLESTRUCT;
alias STYLESTRUCT TAGSTYLESTRUCT;
alias STYLESTRUCT TSTYLESTRUCT;
alias STYLESTRUCT* PSTYLESTRUCT;

struct SYSTEM_AUDIT_ACE
{
 ACE_HEADER Header;
 ACCESS_MASK Mask;
 DWORD SidStart;
}

alias SYSTEM_AUDIT_ACE _SYSTEM_AUDIT_ACE;
alias SYSTEM_AUDIT_ACE TSYSTEMAUDITACE;
alias SYSTEM_AUDIT_ACE* PSYSTEMAUDITACE;

struct SYSTEM_INFO 
{
 union {
  DWORD dwOemId;
  struct {
   WORD wProcessorArchitecture;
   WORD wReserved;
  }
 }
 DWORD dwPageSize;
 LPVOID lpMinimumApplicationAddress;
 LPVOID lpMaximumApplicationAddress;
 DWORD_PTR dwActiveProcessorMask;
 DWORD dwNumberOfProcessors;
 DWORD dwProcessorType;
 DWORD dwAllocationGranularity;
 WORD wProcessorLevel;
 WORD wProcessorRevision;
}

alias SYSTEM_INFO* LPSYSTEM_INFO;
alias SYSTEM_INFO _SYSTEM_INFO;
alias SYSTEM_INFO TSYSTEMINFO;
alias SYSTEM_INFO* PSYSTEMINFO;

struct SYSTEM_POWER_STATUS
{
 ubyte ACLineStatus;
 ubyte BatteryFlag;
 ubyte BatteryLifePercent;
 ubyte Reserved1;
 DWORD BatteryLifeTime;
 DWORD BatteryFullLifeTime;
}

alias SYSTEM_POWER_STATUS _SYSTEM_POWER_STATUS;
alias SYSTEM_POWER_STATUS TSYSTEMPOWERSTATUS;
alias SYSTEM_POWER_STATUS* PSYSTEMPOWERSTATUS;
alias EMPTYRECORD* LPSYSTEM_POWER_STATUS;

struct TAPE_ERASE
{
 DWORD Type;
 BOOLEAN Immediate;
}

alias TAPE_ERASE _TAPE_ERASE;
alias TAPE_ERASE TTAPEERASE;
alias TAPE_ERASE* PTAPEERASE;

struct TAPE_GET_DRIVE_PARAMETERS
{
 ubyte ECC;
 ubyte Compression;
 ubyte DataPadding;
 ubyte ReportSetmarks;
 ULONG DefaultBlockSize;
 ULONG MaximumBlockSize;
 ULONG MinimumBlockSize;
 ULONG MaximumPartitionCount;
 ULONG FeaturesLow;
 ULONG FeaturesHigh;
 ULONG EOTWarningZoneSize;
}

alias TAPE_GET_DRIVE_PARAMETERS _TAPE_GET_DRIVE_PARAMETERS;
alias TAPE_GET_DRIVE_PARAMETERS TTAPEGETDRIVEPARAMETERS;
alias TAPE_GET_DRIVE_PARAMETERS* PTAPEGETDRIVEPARAMETERS;

struct TAPE_GET_MEDIA_PARAMETERS
{
 LARGE_INTEGER Capacity;
 LARGE_INTEGER Remaining;
 DWORD BlockSize;
 DWORD PartitionCount;
 ubyte WriteProtected;
}

alias TAPE_GET_MEDIA_PARAMETERS _TAPE_GET_MEDIA_PARAMETERS;
alias TAPE_GET_MEDIA_PARAMETERS TTAPEGETMEDIAPARAMETERS;
alias TAPE_GET_MEDIA_PARAMETERS* PTAPEGETMEDIAPARAMETERS;

struct TAPE_GET_POSITION
{
 ULONG _Type;
 ULONG Partition;
 ULONG OffsetLow;
 ULONG OffsetHigh;
}

alias TAPE_GET_POSITION _TAPE_GET_POSITION;
alias TAPE_GET_POSITION TTAPEGETPOSITION;
alias TAPE_GET_POSITION* PTAPEGETPOSITION;

struct TAPE_PREPARE
{
 DWORD Operation;
 BOOLEAN  Immediate;
}

alias TAPE_PREPARE _TAPE_PREPARE;
alias TAPE_PREPARE TTAPEPREPARE;
alias TAPE_PREPARE* PTAPEPREPARE;

struct TAPE_SET_DRIVE_PARAMETERS
{
 ubyte ECC;
 ubyte Compression;
 ubyte DataPadding;
 ubyte ReportSetmarks;
 ULONG EOTWarningZoneSize;
}

alias TAPE_SET_DRIVE_PARAMETERS _TAPE_SET_DRIVE_PARAMETERS;
alias TAPE_SET_DRIVE_PARAMETERS TTAPESETDRIVEPARAMETERS;
alias TAPE_SET_DRIVE_PARAMETERS* PTAPESETDRIVEPARAMETERS;

struct TAPE_SET_MEDIA_PARAMETERS
{
 ULONG BlockSize;
}

alias TAPE_SET_MEDIA_PARAMETERS _TAPE_SET_MEDIA_PARAMETERS;
alias TAPE_SET_MEDIA_PARAMETERS TTAPESETMEDIAPARAMETERS;
alias TAPE_SET_MEDIA_PARAMETERS* PTAPESETMEDIAPARAMETERS;

struct TAPE_SET_POSITION
{
 ULONG Method;
 ULONG Partition;
 LARGE_INTEGER Offset;
 BOOLEAN Immediate;
}

alias TAPE_SET_POSITION _TAPE_SET_POSITION;
alias TAPE_SET_POSITION TTAPESETPOSITION;
alias TAPE_SET_POSITION* PTAPESETPOSITION;

struct TAPE_WRITE_MARKS
{
 ULONG _Type;
 ULONG Count;
 BOOLEAN Immediate;
}

alias TAPE_WRITE_MARKS _TAPE_WRITE_MARKS;
alias TAPE_WRITE_MARKS TTAPEWRITEMARKS;
alias TAPE_WRITE_MARKS* PTAPEWRITEMARKS;

struct TBADDBITMAP
{
 HINST hInst;
 UINT nID;
}

alias TBADDBITMAP* LPTBADDBITMAP;
alias TBADDBITMAP TTBADDBITMAP;
alias TBADDBITMAP* PTBADDBITMAP;

struct TBBUTTON 
{
 align(2):
 int  iBitmap;
 int  idCommand;
 BYTE fsState;
 BYTE fsStyle;
//#ifdef _WIN64
// BYTE  bReserved[6];  // padding for alignment
//#elif defined(_WIN32)
 BYTE  bReserved[2];  // padding for alignment
//#endif
 DWORD_PTR   dwData;
 INT_PTR  iString;
}

alias TBBUTTON* LPTBBUTTON;
alias TBBUTTON* LPCTBBUTTON;
alias TBBUTTON _TBBUTTON;
alias TBBUTTON TTBBUTTON;
alias TBBUTTON* PTBBUTTON;

struct NMTOOLBARA 
{
 align(2):
 NMHDR hdr;
 int   iItem;
 TBBUTTON tbButton;
 int   cchText;
 LPSTR   pszText;
 RECT  rcButton;
}
struct NMTOOLBARW 
{
 align(2):
 NMHDR hdr;
 int   iItem;
 TBBUTTON tbButton;
 int   cchText;
 LPWSTR   pszText;
 RECT  rcButton;
}
version(Win32SansUnicode){
 alias NMTOOLBARA NMTOOLBAR;
}else{
 alias NMTOOLBARW NMTOOLBAR;
}
alias NMTOOLBAR* LPNMTOOLBAR;

alias NMTOOLBAR TBNOTIFY;

alias TBNOTIFY* LPTBNOTIFY;
alias TBNOTIFY TTBNOTIFY;
alias TBNOTIFY* PTBNOTIFY;

struct TBSAVEPARAMS
{
 HKEY hkr;
 LPCTSTR pszSubKey;
 LPCTSTR pszValueName;
}

alias TBSAVEPARAMS TTBSAVEPARAMS;
alias TBSAVEPARAMS* PTBSAVEPARAMS;

struct TC_HITTESTINFO
{
 POINT pt;
 UINT flags;
}

alias TC_HITTESTINFO TCHITTESTINFO;
alias TC_HITTESTINFO _TC_HITTESTINFO;
alias TC_HITTESTINFO TTCHITTESTINFO;
alias TC_HITTESTINFO* PTCHITTESTINFO;

struct TC_ITEM
{
 UINT mask;
 UINT lpReserved1;
 UINT lpReserved2;
 LPTSTR pszText;
 int cchTextMax;
 int iImage;
 LPARAM lParam;
}

alias TC_ITEM _TC_ITEM;
alias TC_ITEM TTCITEM;
alias TC_ITEM* PTCITEM;

struct TC_ITEMHEADER
{
 UINT mask;
 UINT lpReserved1;
 UINT lpReserved2;
 LPTSTR pszText;
 int cchTextMax;
 int iImage;
}

alias TC_ITEMHEADER _TC_ITEMHEADER;
alias TC_ITEMHEADER TTCITEMHEADER;
alias TC_ITEMHEADER* PTCITEMHEADER;

align(1) struct NMTCKEYDOWN
{
 NMHDR hdr;
 WORD wVKey;
 UINT flags;
}

alias NMTCKEYDOWN TC_KEYDOWN;
alias TC_KEYDOWN _TC_KEYDOWN;
alias TC_KEYDOWN TTCKEYDOWN;
alias TC_KEYDOWN* PTCKEYDOWN;

struct TEXTRANGE
{
 CHARRANGE chrg;
 LPSTR lpstrText;
}

alias TEXTRANGE _TEXTRANGE;
alias TEXTRANGE TTEXTRANGE;
alias TEXTRANGE* PTEXTRANGE;

struct TIME_ZONE_INFORMATION
{
 LONG Bias;
 WCHAR[1 + 31] StandardName;
 SYSTEMTIME StandardDate;
 LONG StandardBias;
 WCHAR[1 + 31] DaylightName;
 SYSTEMTIME DaylightDate;
 LONG DaylightBias;
}

alias TIME_ZONE_INFORMATION* LPTIME_ZONE_INFORMATION;
alias TIME_ZONE_INFORMATION _TIME_ZONE_INFORMATION;
alias TIME_ZONE_INFORMATION TTIMEZONEINFORMATION;
alias TIME_ZONE_INFORMATION* PTIMEZONEINFORMATION;

struct TOGGLEKEYS
{
 DWORD cbSize;
 DWORD dwFlags;
}

alias TOGGLEKEYS TAGTOGGLEKEYS;
alias TOGGLEKEYS TTOGGLEKEYS;
alias TOGGLEKEYS* PTOGGLEKEYS;

struct TOKEN_SOURCE
{
 char[1 + 7] SourceName;
 LUID SourceIdentifier;
}

alias TOKEN_SOURCE _TOKEN_SOURCE;
alias TOKEN_SOURCE TTOKENSOURCE;
alias TOKEN_SOURCE* PTOKENSOURCE;

struct TOKEN_CONTROL
{
 LUID TokenId;
 LUID AuthenticationId;
 LUID ModifiedId;
 TOKEN_SOURCE TokenSource;
}

alias TOKEN_CONTROL _TOKEN_CONTROL;
alias TOKEN_CONTROL TTOKENCONTROL;
alias TOKEN_CONTROL* PTOKENCONTROL;

struct TOKEN_DEFAULT_DACL
{
 PACL DefaultDacl;
}

alias TOKEN_DEFAULT_DACL _TOKEN_DEFAULT_DACL;
alias TOKEN_DEFAULT_DACL TTOKENDEFAULTDACL;
alias TOKEN_DEFAULT_DACL* PTOKENDEFAULTDACL;

struct TOKEN_GROUPS
{
 DWORD GroupCount;
 SID_AND_ATTRIBUTES[1 + ANYSIZE_ARRAY-1] Groups;
}

alias TOKEN_GROUPS* PTOKEN_GROUPS;
alias TOKEN_GROUPS* LPTOKEN_GROUPS;
alias TOKEN_GROUPS _TOKEN_GROUPS;
alias TOKEN_GROUPS TTOKENGROUPS;
alias TOKEN_GROUPS* PTOKENGROUPS;

struct TOKEN_OWNER
{
 PSID Owner;
}

alias TOKEN_OWNER _TOKEN_OWNER;
alias TOKEN_OWNER TTOKENOWNER;
alias TOKEN_OWNER* PTOKENOWNER;

struct TOKEN_PRIMARY_GROUP
{
 PSID PrimaryGroup;
}

alias TOKEN_PRIMARY_GROUP _TOKEN_PRIMARY_GROUP;
alias TOKEN_PRIMARY_GROUP TTOKENPRIMARYGROUP;
alias TOKEN_PRIMARY_GROUP* PTOKENPRIMARYGROUP;

struct TOKEN_PRIVILEGES
{
 DWORD PrivilegeCount;
 LUID_AND_ATTRIBUTES[ANYSIZE_ARRAY] Privileges;
}

alias TOKEN_PRIVILEGES* PTOKEN_PRIVILEGES;
alias TOKEN_PRIVILEGES* LPTOKEN_PRIVILEGES;
alias TOKEN_PRIVILEGES _TOKEN_PRIVILEGES;
alias TOKEN_PRIVILEGES TTOKENPRIVILEGES;
alias TOKEN_PRIVILEGES* PTOKENPRIVILEGES;

struct TOKEN_STATISTICS
{
 LUID TokenId;
 LUID AuthenticationId;
 LARGE_INTEGER ExpirationTime;
 TOKEN_TYPE TokenType;
 SECURITY_IMPERSONATION_LEVEL ImpersonationLevel;
 DWORD DynamicCharged;
 DWORD DynamicAvailable;
 DWORD GroupCount;
 DWORD PrivilegeCount;
 LUID ModifiedId;
}

alias TOKEN_STATISTICS _TOKEN_STATISTICS;
alias TOKEN_STATISTICS TTOKENSTATISTICS;
alias TOKEN_STATISTICS* PTOKENSTATISTICS;

struct TOKEN_USER
{
 SID_AND_ATTRIBUTES User;
}

alias TOKEN_USER _TOKEN_USER;
alias TOKEN_USER TTOKENUSER;
alias TOKEN_USER* PTOKENUSER;

struct TOOLINFOA
{
 UINT cbSize;
 UINT uFlags;
 HWND hwnd;
 UINT uId;
 RECT rect;
 HINST hinst;
 LPSTR lpszText;
//if (_WIN32_IE >= 0x0300)
 LPARAM lParam;
//endif
//if (_WIN32_WINNT >= 0x0501)
 void *lpReserved;
//endif
}
struct TOOLINFOW
{
 UINT cbSize;
 UINT uFlags;
 HWND hwnd;
 UINT uId;
 RECT rect;
 HINST hinst;
 LPWSTR lpszText;
//if (_WIN32_IE >= 0x0300)
 LPARAM lParam;
//endif
//if (_WIN32_WINNT >= 0x0501)
 void *lpReserved;
//endif

}
version(Win32SansUnicode)
{
 alias TOOLINFOA TOOLINFO;
}
else
{
 alias TOOLINFOW TOOLINFO;
}
alias TOOLINFO* LPTOOLINFO;
alias TOOLINFO TTOOLINFO;
alias TOOLINFO* PTOOLINFO;

struct NMTTDISPINFOA 
{
 NMHDR hdr;
 LPSTR lpszText;
 char szText[80];
 HINSTANCE hinst;
 UINT uFlags;
 LPARAM lParam;
}

struct NMTTDISPINFOW 
{
 NMHDR hdr;
 LPWSTR lpszText;
 WCHAR szText[80];
 HINSTANCE hinst;
 UINT uFlags;
 LPARAM lParam;
}
version(Win32SansUnicode){
 alias NMTTDISPINFOA NMTTDISPINFO;
} else {
 alias NMTTDISPINFOW NMTTDISPINFO;
}


alias NMTTDISPINFOA TOOLTIPTEXTA;
alias NMTTDISPINFOW TOOLTIPTEXTW;
version(Win32SansUnicode)
{
 alias TOOLTIPTEXTA TOOLTIPTEXT;
}
else
{
 alias TOOLTIPTEXTW TOOLTIPTEXT;
}
alias TOOLTIPTEXT* LPTOOLTIPTEXT;
alias TOOLTIPTEXT TTOOLTIPTEXT;
alias TOOLTIPTEXT* PTOOLTIPTEXT;

struct TPMPARAMS
{
 UINT cbSize;
 RECT rcExclude;
}

alias TPMPARAMS* LPTPMPARAMS;
alias TPMPARAMS TAGTPMPARAMS;
alias TPMPARAMS TTPMPARAMS;
alias TPMPARAMS* PTPMPARAMS;

struct TRANSMIT_FILE_BUFFERS
{
 PVOID Head;
 DWORD HeadLength;
 PVOID Tail;
 DWORD TailLength;
}

alias TRANSMIT_FILE_BUFFERS _TRANSMIT_FILE_BUFFERS;
alias TRANSMIT_FILE_BUFFERS TTRANSMITFILEBUFFERS;
alias TRANSMIT_FILE_BUFFERS* PTRANSMITFILEBUFFERS;

struct TTHITTESTINFO
{
 HWND hwnd;
 POINT pt;
 TOOLINFO ti;
}

alias TTHITTESTINFO* LPHITTESTINFO;
alias TTHITTESTINFO _TT_HITTESTINFO;
alias TTHITTESTINFO TTTHITTESTINFO;
alias TTHITTESTINFO* PTTHITTESTINFO;

struct TTPOLYCURVE
{
 ushort wType;
 ushort cpfx;
 POINTFX[1 + 0] apfx;
}

alias TTPOLYCURVE* LPTTPOLYCURVE;
alias TTPOLYCURVE TAGTTPOLYCURVE;
alias TTPOLYCURVE TTTPOLYCURVE;
alias TTPOLYCURVE* PTTPOLYCURVE;

struct TTPOLYGONHEADER
{
 DWORD cb;
 DWORD dwType;
 POINTFX pfxStart;
}

alias TTPOLYGONHEADER* LPTTPOLYGONHEADER;
alias TTPOLYGONHEADER _TTPOLYGONHEADER;
alias TTPOLYGONHEADER TTTPOLYGONHEADER;
alias TTPOLYGONHEADER* PTTPOLYGONHEADER;

struct TV_DISPINFO
{
 NMHDR hdr;
 TV_ITEM item;
}

alias TV_DISPINFO _TV_DISPINFO;
alias TV_DISPINFO TTVDISPINFO;
alias TV_DISPINFO* PTVDISPINFO;

struct TV_HITTESTINFO
{
 POINT pt;
 UINT flags;
 HTREEITEM hItem;
}

alias TV_HITTESTINFO* LPTV_HITTESTINFO;
alias TV_HITTESTINFO _TVHITTESTINFO;
alias TV_HITTESTINFO TTVHITTESTINFO;
alias TV_HITTESTINFO* PTVHITTESTINFO;

struct TVINSERTSTRUCTA
{
 HTREEITEM hParent;
 HTREEITEM hInsertAfter;
 union {
  TVITEMEXA itemex;
  TVITEMA item;
 }
}
struct TVINSERTSTRUCTW
{
 HTREEITEM hParent;
 HTREEITEM hInsertAfter;
 union {
  TVITEMEXW itemex;
  TVITEMW item;
 }
}
version(Win32SansUnicode)
{
 alias TVINSERTSTRUCTA TVINSERTSTRUCT;
}
else
{
 alias TVINSERTSTRUCTW TVINSERTSTRUCT;
}

alias TVINSERTSTRUCT  TV_INSERTSTRUCT;
alias TVINSERTSTRUCT* LPTV_INSERTSTRUCT;
alias TVINSERTSTRUCT _TV_INSERTSTRUCT;
alias TVINSERTSTRUCT TTVINSERTSTRUCT;
alias TVINSERTSTRUCT* PTVINSERTSTRUCT;

align(2) struct TV_KEYDOWN
{
 NMHDR hdr;
 ushort wVKey;
 UINT flags;
}

alias TV_KEYDOWN _TV_KEYDOWN;
alias TV_KEYDOWN TTVKEYDOWN;
alias TV_KEYDOWN* PTVKEYDOWN;

struct TV_SORTCB
{
 HTREEITEM hParent;
 PFNTVCOMPARE lpfnCompare;
 LPARAM lParam;
}

alias TV_SORTCB* LPTV_SORTCB;
alias TV_SORTCB _TV_SORTCB;
alias TV_SORTCB TTVSORTCB;
alias TV_SORTCB* PTVSORTCB;

struct UDACCEL
{
 UINT nSec;
 UINT nInc;
}

alias UDACCEL TUDACCEL;
alias UDACCEL* PUDACCEL;

union ULARGE_INTEGER
{
 struct
 {
  DWORD LowPart;
  DWORD HighPart;
 };
 struct u
 {
  DWORD LowPart;
  DWORD HighPart;
 };
 DWORDLONG QuadPart;
}
alias ULARGE_INTEGER* PULARGE_INTEGER;
alias ULARGE_INTEGER _ULARGE_INTEGER;
alias ULARGE_INTEGER TULARGEINTEGER;
alias ULARGE_INTEGER* PULARGEINTEGER;

struct UNIVERSAL_NAME_INFO
{
 LPTSTR lpUniversalName;
}

alias UNIVERSAL_NAME_INFO _UNIVERSAL_NAME_INFO;
alias UNIVERSAL_NAME_INFO TUNIVERSALNAMEINFO;
alias UNIVERSAL_NAME_INFO* PUNIVERSALNAMEINFO;

struct USEROBJECTFLAGS
{
 WINBOOL fInherit;
 WINBOOL fReserved;
 DWORD dwFlags;
}

alias USEROBJECTFLAGS TAGUSEROBJECTFLAGS;
alias USEROBJECTFLAGS TUSEROBJECTFLAGS;
alias USEROBJECTFLAGS* PUSEROBJECTFLAGS;

struct VALENT
{
 LPTSTR ve_valuename;
 DWORD ve_valuelen;
 DWORD ve_valueptr;
 DWORD ve_type;
}

alias VALENT TVALENT;
alias VALENT* PVALENT;
alias VALENT VALUE_ENT;
alias VALENT TVALUE_ENT;
alias VALENT* PVALUE_ENT;

struct VERIFY_INFORMATION
{
 LARGE_INTEGER StartingOffset;
 DWORD Length;
}

alias VERIFY_INFORMATION _VERIFY_INFORMATION;
alias VERIFY_INFORMATION TVERIFYINFORMATION;
alias VERIFY_INFORMATION* PVERIFYINFORMATION;

struct VS_FIXEDFILEINFO
{
 DWORD dwSignature;
 DWORD dwStrucVersion;
 DWORD dwFileVersionMS;
 DWORD dwFileVersionLS;
 DWORD dwProductVersionMS;
 DWORD dwProductVersionLS;
 DWORD dwFileFlagsMask;
 DWORD dwFileFlags;
 DWORD dwFileOS;
 DWORD dwFileType;
 DWORD dwFileSubtype;
 DWORD dwFileDateMS;
 DWORD dwFileDateLS;
}

alias VS_FIXEDFILEINFO _VS_FIXEDFILEINFO;
alias VS_FIXEDFILEINFO TVSFIXEDFILEINFO;
alias VS_FIXEDFILEINFO* PVSFIXEDFILEINFO;

struct WIN32_FIND_DATA
{
 DWORD dwFileAttributes;
 FILETIME ftCreationTime;
 FILETIME ftLastAccessTime;
 FILETIME ftLastWriteTime;
 DWORD nFileSizeHigh;
 DWORD nFileSizeLow;
 DWORD dwReserved0;
 DWORD dwReserved1;
 TCHAR[1 + MAX_PATH-1] cFileName;
 TCHAR[1 + 13] cAlternateFileName;
}

alias WIN32_FIND_DATA* LPWIN32_FIND_DATA;
alias WIN32_FIND_DATA* PWIN32_FIND_DATA;
alias WIN32_FIND_DATA _WIN32_FIND_DATA;
alias WIN32_FIND_DATA TWIN32FINDDATA;
alias WIN32_FIND_DATA TWIN32FINDDATAA;
alias WIN32_FIND_DATA* PWIN32FINDDATA;

struct WIN32_FIND_DATAW 
{
 DWORD dwFileAttributes;
 FILETIME ftCreationTime;
 FILETIME ftLastAccessTime;
 FILETIME ftLastWriteTime;
 DWORD nFileSizeHigh;
 DWORD nFileSizeLow;
 DWORD dwReserved0;
 DWORD dwReserved1;
 WCHAR  cFileName[MAX_PATH];
 WCHAR  cAlternateFileName[14];
}

alias WIN32_FIND_DATAW* LPWIN32_FIND_DATAW;
alias WIN32_FIND_DATAW* PWIN32_FIND_DATAW;

struct WIN32_FILE_ATTRIBUTE_DATA 
{
  DWORD dwFileAttributes;
  FILETIME ftCreationTime;
  FILETIME ftLastAccessTime;
  FILETIME ftLastWriteTime;
  DWORD nFileSizeHigh;
  DWORD nFileSizeLow;
}

enum {
 GetFileInfoLevelStandard,
 GetFileInfoLevelMax
}

struct WIN32_STREAM_ID
{
 DWORD dwStreamId;
 DWORD dwStreamAttributes;
 LARGE_INTEGER Size;
 DWORD dwStreamNameSize;
 WCHAR* cStreamName;
}

alias WIN32_STREAM_ID _WIN32_STREAM_ID;
alias WIN32_STREAM_ID TWIN32STREAMID;
alias WIN32_STREAM_ID* PWIN32STREAMID;

struct WINDOWPLACEMENT
{
 UINT length;
 UINT flags;
 UINT showCmd;
 POINT ptMinPosition;
 POINT ptMaxPosition;
 RECT rcNormalPosition;
}

alias WINDOWPLACEMENT _WINDOWPLACEMENT;
alias WINDOWPLACEMENT TWINDOWPLACEMENT;
alias WINDOWPLACEMENT* PWINDOWPLACEMENT;

struct WNDCLASSA
{
 UINT style;
 WNDPROC lpfnWndProc;
 int cbClsExtra;
 int cbWndExtra;
 HANDLE hInstance;
 HICON hIcon;
 HCURSOR hCursor;
 HBRUSH hbrBackground;
 LPCSTR lpszMenuName;
 LPCSTR lpszClassName;
}

alias WNDCLASSA* PWNDCLASSA, LPWNDCLASSA;

struct WNDCLASSW
{
 UINT  style;
 WNDPROC  lpfnWndProc;
 int   cbClsExtra;
 int   cbWndExtra;
 HINSTANCE   hInstance;
 HICON    hIcon;
 HCURSOR  hCursor;
 HBRUSH   hbrBackground;
 LPCWSTR  lpszMenuName;
 LPCWSTR  lpszClassName;
}

alias WNDCLASSW* PWNDCLASSW, LPWNDCLASSW;

version(Win32SansUnicode)
{
 alias WNDCLASSA WNDCLASS;
}
else
{
 alias WNDCLASSW WNDCLASS;
}
alias WNDCLASS* LPWNDCLASS;
alias WNDCLASS _WNDCLASS;
alias WNDCLASS TWNDCLASS;
alias WNDCLASS WNDCLASS_T;
alias WNDCLASS* PWNDCLASS;

struct WNDCLASSEX
{
 UINT cbSize;
 UINT style;
 WNDPROC lpfnWndProc;
 int cbClsExtra;
 int cbWndExtra;
 HANDLE hInstance;
 HICON hIcon;
 HCURSOR hCursor;
 HBRUSH hbrBackground;
 LPCTSTR lpszMenuName;
 LPCTSTR lpszClassName;
 HANDLE hIconSm;
}

alias WNDCLASSEX* LPWNDCLASSEX;
alias WNDCLASSEX _WNDCLASSEX;
alias WNDCLASSEX TWNDCLASSEX;
alias WNDCLASSEX TWNDCLASSEXA;
alias WNDCLASSEX* PWNDCLASSEX;

struct CONNECTDLGSTRUCT
{
 DWORD cbStructure;
 HWND hwndOwner;
 LPNETRESOURCE lpConnRes;
 DWORD dwFlags;
 DWORD dwDevNum;
}

alias CONNECTDLGSTRUCT* LPCONNECTDLGSTRUCT;
alias CONNECTDLGSTRUCT _CONNECTDLGSTRUCT;
alias CONNECTDLGSTRUCT TCONNECTDLGSTRUCT;
alias CONNECTDLGSTRUCT* PCONNECTDLGSTRUCT;

struct DISCDLGSTRUCT
{
 DWORD cbStructure;
 HWND hwndOwner;
 LPTSTR lpLocalName;
 LPTSTR lpRemoteName;
 DWORD dwFlags;
}

alias DISCDLGSTRUCT* LPDISCDLGSTRUCT;
alias DISCDLGSTRUCT _DISCDLGSTRUCT;
alias DISCDLGSTRUCT TDISCDLGSTRUCT;
alias DISCDLGSTRUCT TDISCDLGSTRUCTA;
alias DISCDLGSTRUCT* PDISCDLGSTRUCT;

struct NETINFOSTRUCT
{
 DWORD cbStructure;
 DWORD dwProviderVersion;
 DWORD dwStatus;
 DWORD dwCharacteristics;
 DWORD dwHandle;
 ushort wNetType;
 DWORD dwPrinters;
 DWORD dwDrives;
}

alias NETINFOSTRUCT* LPNETINFOSTRUCT;
alias NETINFOSTRUCT _NETINFOSTRUCT;
alias NETINFOSTRUCT TNETINFOSTRUCT;
alias NETINFOSTRUCT* PNETINFOSTRUCT;

struct NETCONNECTINFOSTRUCT
{
 DWORD cbStructure;
 DWORD dwFlags;
 DWORD dwSpeed;
 DWORD dwDelay;
 DWORD dwOptDataSize;
}

alias NETCONNECTINFOSTRUCT* LPNETCONNECTINFOSTRUCT;
alias NETCONNECTINFOSTRUCT _NETCONNECTINFOSTRUCT;
alias NETCONNECTINFOSTRUCT TNETCONNECTINFOSTRUCT;
alias NETCONNECTINFOSTRUCT* PNETCONNECTINFOSTRUCT;
extern(Windows){
alias int (*ENUMMETAFILEPROC)(HDC, HANDLETABLE*, METARECORD*, int, LPARAM);
alias int (*ENHMETAFILEPROC)(HDC, HANDLETABLE*, ENHMETARECORD*, int, LPARAM);
alias int (*ENUMFONTSPROC)(LPLOGFONT, LPTEXTMETRIC, DWORD, LPARAM);
alias int (*FONTENUMPROC)(ENUMLOGFONT*, NEWTEXTMETRIC*, int, LPARAM);
alias int (*FONTENUMEXPROC)(ENUMLOGFONTEX*, NEWTEXTMETRICEX*, int, LPARAM);
alias void (*LPOVERLAPPED_COMPLETION_ROUTINE)(DWORD, DWORD);
}

struct POINTFLOAT
{
 FLOAT x;
 FLOAT y;
}

alias POINTFLOAT _POINTFLOAT;
alias POINTFLOAT TPOINTFLOAT;
alias POINTFLOAT* PPOINTFLOAT;

struct GLYPHMETRICSFLOAT
{
 FLOAT gmfBlackBoxX;
 FLOAT gmfBlackBoxY;
 POINTFLOAT gmfptGlyphOrigin;
 FLOAT gmfCellIncX;
 FLOAT gmfCellIncY;
}

alias GLYPHMETRICSFLOAT* LPGLYPHMETRICSFLOAT;
alias GLYPHMETRICSFLOAT _GLYPHMETRICSFLOAT;
alias GLYPHMETRICSFLOAT TGLYPHMETRICSFLOAT;
alias GLYPHMETRICSFLOAT* PGLYPHMETRICSFLOAT;

struct LAYERPLANEDESCRIPTOR
{
 ushort nSize;
 ushort nVersion;
 DWORD dwFlags;
 ubyte iPixelType;
 ubyte cColorBits;
 ubyte cRedBits;
 ubyte cRedShift;
 ubyte cGreenBits;
 ubyte cGreenShift;
 ubyte cBlueBits;
 ubyte cBlueShift;
 ubyte cAlphaBits;
 ubyte cAlphaShift;
 ubyte cAccumBits;
 ubyte cAccumRedBits;
 ubyte cAccumGreenBits;
 ubyte cAccumBlueBits;
 ubyte cAccumAlphaBits;
 ubyte cDepthBits;
 ubyte cStencilBits;
 ubyte cAuxBuffers;
 ubyte iLayerPlane;
 ubyte bReserved;
 COLORREF crTransparent;
}

alias LAYERPLANEDESCRIPTOR* LPLAYERPLANEDESCRIPTOR;
alias LAYERPLANEDESCRIPTOR TAGLAYERPLANEDESCRIPTOR;
alias LAYERPLANEDESCRIPTOR TLAYERPLANEDESCRIPTOR;
alias LAYERPLANEDESCRIPTOR* PLAYERPLANEDESCRIPTOR;

struct PIXELFORMATDESCRIPTOR
{
 ushort nSize;
 ushort nVersion;
 DWORD dwFlags;
 ubyte iPixelType;
 ubyte cColorBits;
 ubyte cRedBits;
 ubyte cRedShift;
 ubyte cGreenBits;
 ubyte cGreenShift;
 ubyte cBlueBits;
 ubyte cBlueShift;
 ubyte cAlphaBits;
 ubyte cAlphaShift;
 ubyte cAccumBits;
 ubyte cAccumRedBits;
 ubyte cAccumGreenBits;
 ubyte cAccumBlueBits;
 ubyte cAccumAlphaBits;
 ubyte cDepthBits;
 ubyte cStencilBits;
 ubyte cAuxBuffers;
 ubyte iLayerType;
 ubyte bReserved;
 DWORD dwLayerMask;
 DWORD dwVisibleMask;
 DWORD dwDamageMask;
}

alias PIXELFORMATDESCRIPTOR* LPPIXELFORMATDESCRIPTOR;
alias PIXELFORMATDESCRIPTOR TAGPIXELFORMATDESCRIPTOR;
alias PIXELFORMATDESCRIPTOR TPIXELFORMATDESCRIPTOR;
alias PIXELFORMATDESCRIPTOR* PPIXELFORMATDESCRIPTOR;

struct USER_INFO_2
{
 LPWSTR usri2_name;
 LPWSTR usri2_password;
 DWORD usri2_password_age;
 DWORD usri2_priv;
 LPWSTR usri2_home_dir;
 LPWSTR usri2_comment;
 DWORD usri2_flags;
 LPWSTR usri2_script_path;
 DWORD usri2_auth_flags;
 LPWSTR usri2_full_name;
 LPWSTR usri2_usr_comment;
 LPWSTR usri2_parms;
 LPWSTR usri2_workstations;
 DWORD usri2_last_logon;
 DWORD usri2_last_logoff;
 DWORD usri2_acct_expires;
 DWORD usri2_max_storage;
 DWORD usri2_units_per_week;
 PBYTE usri2_logon_hours;
 DWORD usri2_bad_pw_count;
 DWORD usri2_num_logons;
 LPWSTR usri2_logon_server;
 DWORD usri2_country_code;
 DWORD usri2_code_page;
}

alias USER_INFO_2* PUSER_INFO_2;
alias USER_INFO_2* LPUSER_INFO_2;
alias USER_INFO_2 TUSERINFO2;
alias USER_INFO_2* PUSERINFO2;

struct USER_INFO_0
{
 LPWSTR usri0_name;
}

alias USER_INFO_0* PUSER_INFO_0;
alias USER_INFO_0* LPUSER_INFO_0;
alias USER_INFO_0 TUSERINFO0;
alias USER_INFO_0* PUSERINFO0;

struct USER_INFO_3
{
 LPWSTR usri3_name;
 LPWSTR usri3_password;
 DWORD usri3_password_age;
 DWORD usri3_priv;
 LPWSTR usri3_home_dir;
 LPWSTR usri3_comment;
 DWORD usri3_flags;
 LPWSTR usri3_script_path;
 DWORD usri3_auth_flags;
 LPWSTR usri3_full_name;
 LPWSTR usri3_usr_comment;
 LPWSTR usri3_parms;
 LPWSTR usri3_workstations;
 DWORD usri3_last_logon;
 DWORD usri3_last_logoff;
 DWORD usri3_acct_expires;
 DWORD usri3_max_storage;
 DWORD usri3_units_per_week;
 PBYTE usri3_logon_hours;
 DWORD usri3_bad_pw_count;
 DWORD usri3_num_logons;
 LPWSTR usri3_logon_server;
 DWORD usri3_country_code;
 DWORD usri3_code_page;
 DWORD usri3_user_id;
 DWORD usri3_primary_group_id;
 LPWSTR usri3_profile;
 LPWSTR usri3_home_dir_drive;
 DWORD usri3_password_expired;
}

alias USER_INFO_3* PUSER_INFO_3;
alias USER_INFO_3* LPUSER_INFO_3;
alias USER_INFO_3 TUSERINFO3;
alias USER_INFO_3* PUSERINFO3;

struct GROUP_INFO_2
{
 LPWSTR grpi2_name;
 LPWSTR grpi2_comment;
 DWORD grpi2_group_id;
 DWORD grpi2_attributes;
}

alias GROUP_INFO_2* PGROUP_INFO_2;
alias GROUP_INFO_2 TGROUPINFO2;
alias GROUP_INFO_2* PGROUPINFO2;

struct LOCALGROUP_INFO_0
{
 LPWSTR lgrpi0_name;
}

alias LOCALGROUP_INFO_0* PLOCALGROUP_INFO_0;
alias LOCALGROUP_INFO_0* LPLOCALGROUP_INFO_0;
alias LOCALGROUP_INFO_0 TLOCALGROUPINFO0;
alias LOCALGROUP_INFO_0* PLOCALGROUPINFO0;

struct IMAGE_DOS_HEADER
{
 ushort e_magic;
 ushort e_cblp;
 ushort e_cp;
 ushort e_crlc;
 ushort e_cparhdr;
 ushort e_minalloc;
 ushort e_maxalloc;
 ushort e_ss;
 ushort e_sp;
 ushort e_csum;
 ushort e_ip;
 ushort e_cs;
 ushort e_lfarlc;
 ushort e_ovno;
 ushort[1 + 3] e_res;
 ushort e_oemid;
 ushort e_oeminfo;
 ushort[1 + 9] e_res2;
 LONG e_lfanew;
}

alias IMAGE_DOS_HEADER* PIMAGE_DOS_HEADER;
alias IMAGE_DOS_HEADER TIMAGEDOSHEADER;
alias IMAGE_DOS_HEADER* PIMAGEDOSHEADER;
alias ushort TVARTYPE;
alias TVARIANT* PVARIANT;

struct TVARIANT
{
 TVARTYPE vt;
 ushort wReserved1;
 ushort wReserved2;
 ushort wReserved3;

 union
 {
  struct
  {
   ubyte bVal;
  }
  struct
  {
   byte iVal;
  }
  struct
  {
   int lVal;
  }
  struct
  {
   float fltVal;
  }
  struct
  {
   double dblVal;
  }
  struct
  {
   ushort vbool;
  }
  struct
  {
   HRESULT scode;
  }
  struct
  {
   ubyte* pbVal;
  }
  struct
  {
   byte* piVal;
  }
  struct
  {
   int* plVal;
  }
  struct
  {
   float* pfltVal;
  }
  struct
  {
   double* pdblVal;
  }
  struct
  {
   ushort* pbool;
  }
  struct
  {
   HRESULT* pscode;
  }
  struct
  {
   POINTER byRef;
  }
 }
}

alias TVARIANT VARIANT;
alias int MMRESULT;
alias TWAVEFORMATEX* PWAVEFORMATEX;
alias TWAVEFORMATEX WAVEFORMATEX;

align(1) struct TWAVEFORMATEX
{
 ushort wFormatTag;
 ushort nChannels;
 DWORD nSamplesPerSec;
 DWORD nAvgBytesPerSec;
 ushort nBlockAlign;
 ushort wBitsPerSample;
 ushort cbSize;
}

alias CRITICAL_SECTION TRTLCRITICALSECTION;
alias PCRITICAL_SECTION PRTLCRITICALSECTION;
alias PGUID PIID;
alias TGUID TIID;
alias HANDLE THANDLE;
alias TSMALLRECT* PSMALLRECT;
alias SMALL_RECT TSMALLRECT;
alias TCHARINFO* PCHARINFO;
alias _CHAR_INFO TCHARINFO;
alias POINTER TFARPROC;
alias POINTER TFNDLGPROC;
alias POINTER TFNTHREADSTARTROUTINE;

struct _OBJECT_TYPE_LIST
{
 ushort Level;
 ushort Sbz;
 PGUID ObjectType;
}

alias _OBJECT_TYPE_LIST TOBJECTTYPELIST;
alias TOBJECTTYPELIST* POBJECTTYPELIST;
alias _OBJECT_TYPE_LIST OBJECT_TYPE_LIST;
alias DWORD AUDIT_EVENT_TYPE;

align(1) struct _BLENDFUNCTION
{
 ubyte BlendOp;
 ubyte BlendFlags;
 ubyte SourceConstantAlpha;
 ubyte AlphaFormat;
}

alias _BLENDFUNCTION TBLENDFUNCTION;
alias TBLENDFUNCTION* PBLENDFUNCTION;
alias _BLENDFUNCTION BLENDFUNCTION;

alias HANDLE HMONITOR;

struct MONITORINFOEX
{
 DWORD  cbSize;
 RECT   rcMonitor;
 RECT   rcWork;
 DWORD  dwFlags;
 TCHAR  szDevice[CCHDEVICENAME];
}
alias MONITORINFOEX* LPMONITORINFOEX;

struct MONITORINFO
{
 DWORD  cbSize;
 RECT   rcMonitor;
 RECT   rcWork;
 DWORD  dwFlags;
}
alias MONITORINFO* LPMONITORINFO;

struct WINDOWINFO
{
 DWORD cbSize;
 RECT rcWindow;
 RECT rcClient;
 DWORD dwStyle;
 DWORD dwExStyle;
 DWORD dwWindowStatus;
 UINT cxWindowBorders;
 UINT cyWindowBorders;
 ATOM atomWindowType;
 short wCreatorVersion;
};
alias WINDOWINFO* PWINDOWINFO;
alias WINDOWINFO* LPWINDOWINFO;

enum : HRESULT
{
 S_OK   = 0x00000000,
 S_FALSE   = 0x00000001,
 E_UNEXPECTED = 0x8000FFFF,
 E_NOTIMPL    = 0x80004001,
 E_OUTOFMEMORY   = 0x8007000E,
 E_INVALIDARG = 0x80070057,
 E_NOINTERFACE   = 0x80004002,
 E_POINTER    = 0x80004003,
 E_HANDLE  = 0x80070006,
 E_ABORT   = 0x80004004,
 E_FAIL    = 0x80004005,
 E_ACCESSDENIED  = 0x80070005,
 E_PENDING    = 0x8000000A,
}

/*
int CO_E_INIT_TLS = (DWORD)((0x80004006));
int CO_E_INIT_MEMORY_ALLOCATOR = (DWORD)((0x80004008));
int CO_E_INIT_CLASS_CACHE = (DWORD)((0x80004009));
int CO_E_INIT_RPC_CHANNEL = (DWORD)((0x8000400A));
int CO_E_INIT_TLS_SET_CHANNEL_CONTROL = (DWORD)((0x8000400B));
int CO_E_INIT_TLS_CHANNEL_CONTROL = (DWORD)((0x8000400C));
int CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = (DWORD)((0x8000400D));
int CO_E_INIT_SCM_MUTEX_EXISTS = (DWORD)((0x8000400E));
int CO_E_INIT_SCM_FILE_MAPPING_EXISTS = (DWORD)((0x8000400F));
int CO_E_INIT_SCM_MAP_VIEW_OF_FILE = (DWORD)((0x80004010));
int CO_E_INIT_SCM_EXEC_FAILURE = (DWORD)((0x80004011));
int CO_E_INIT_ONLY_SINGLE_THREADED = (DWORD)((0x80004012));
int CO_E_CANT_REMOTE = (DWORD)((0x80004013));
int CO_E_BAD_SERVER_NAME = (DWORD)((0x80004014));
int CO_E_WRONG_SERVER_IDENTITY = (DWORD)((0x80004015));
int CO_E_OLE1DDE_DISABLED = (DWORD)((0x80004016));
int CO_E_RUNAS_SYNTAX = (DWORD)((0x80004017));
int CO_E_CREATEPROCESS_FAILURE = (DWORD)((0x80004018));
int CO_E_RUNAS_CREATEPROCESS_FAILURE = (DWORD)((0x80004019));
int CO_E_RUNAS_LOGON_FAILURE = (DWORD)((0x8000401A));
int CO_E_LAUNCH_PERMSSION_DENIED = (DWORD)((0x8000401B));
int CO_E_START_SERVICE_FAILURE = (DWORD)((0x8000401C));
int CO_E_REMOTE_COMMUNICATION_FAILURE = (DWORD)((0x8000401D));
int CO_E_SERVER_START_TIMEOUT = (DWORD)((0x8000401E));
int CO_E_CLSREG_INCONSISTENT = (DWORD)((0x8000401F));
int CO_E_IIDREG_INCONSISTENT = (DWORD)((0x80004020));
int CO_E_NOT_SUPPORTED = (DWORD)((0x80004021));
int CO_E_FIRST = (DWORD)((0x800401F0));
int CO_E_LAST = (DWORD)((0x800401FF));
int CO_S_FIRST = (0x401F0);
int CO_E_NOTINITIALIZED = (DWORD)((0x800401F0));
int CO_E_ALREADYINITIALIZED = (DWORD)((0x800401F1));
int CO_E_CANTDETERMINECLASS = (DWORD)((0x800401F2));
int CO_E_CLASSSTRING = (DWORD)((0x800401F3));
int CO_E_IIDSTRING = (DWORD)((0x800401F4));
int CO_E_APPNOTFOUND = (DWORD)((0x800401F5));
int CO_E_APPSINGLEUSE = (DWORD)((0x800401F6));
int CO_E_ERRORINAPP = (DWORD)((0x800401F7));
int CO_E_DLLNOTFOUND = (DWORD)((0x800401F8));
int CO_E_ERRORINDLL = (DWORD)((0x800401F9));
int CO_E_WRONGOSFORAPP = (DWORD)((0x800401FA));
int CO_E_OBJNOTREG = (DWORD)((0x800401FB));
int CO_E_OBJISREG = (DWORD)((0x800401FC));
int CO_E_OBJNOTCONNECTED = (DWORD)((0x800401FD));
int CO_E_APPDIDNTREG = (DWORD)((0x800401FE));
int CO_E_RELEASED = (DWORD)((0x800401FF));
*/
