/*
  Kakasi.xs

  Copyright (C) 1998, 1999, 2000 NOKUBI Takatsugu <knok@daionet.gr.jp>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

$Id: Kakasi.xs,v 1.11 2001/04/11 07:58:38 knok Exp $
*/

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

/* for old version of perl (< 5.004_04?) */
#if !defined(PL_na) && defined(na)
#define PL_na na
#endif

#include "libkakasi.h"

static int dic_closed = 1;

MODULE = Text::Kakasi		PACKAGE = Text::Kakasi

PROTOTYPES: DISABLE

int
getopt_argv(sv,...)
    SV* sv

    PREINIT:
	int i;
	char **cargv, **argv;
	int argc;

    CODE:
	RETVAL = 0;
	if (!dic_closed)
		kakasi_close_kanwadict();
	argc = items;
	cargv = (char **) malloc(sizeof(char *) * items + 1);
	for (i = 0; i <= items; i ++) {
	    cargv[i] = SvPV(ST(i), PL_na);
	}
	cargv[items] = NULL;
	argv = cargv;
	RETVAL = kakasi_getopt_argv(argc, argv);

    OUTPUT:
	RETVAL

SV*
do_kakasi(sv)
	SV *sv

    PREINIT:
	char *tmp, *ret, *rtmp;
	STRLEN slen, cur, rcur, tlen, rlen;

    CODE:
	tmp = SvPV(sv, slen);
	rlen = 0;
	cur = 0;
	rcur = 0;
	ret = NULL;
        while (tmp[0] == '\0') {
                tmp ++;
                cur ++;
                if (cur > slen) {
                        RETVAL = newSVpv("", 0);
                        return;
                }
        }
	do {
		rtmp = kakasi_do(tmp);
		tlen = strlen(rtmp);
		if (ret == NULL) {
			ret = malloc(tlen + 1);
			strncpy(ret, rtmp, tlen + 1);
			rcur = tlen + 1;
		} else {
			ret = realloc(ret, rcur + tlen + 1);
			strncpy((ret + rcur), rtmp, tlen + 1);
			rcur += tlen + 1;
		}
		while (*tmp != '\0') {
			tmp ++;
			cur ++;
		}
		while (*tmp == '\0' && cur < slen) {
			tmp ++;
			cur ++;
		}
		free(rtmp);
	} while (cur < slen);
	if (ret != NULL) {
		RETVAL = newSVpv(ret, rcur - 1);
		free(ret);
	} else {
		RETVAL = newSVpv("", 0);
	}

    OUTPUT:
	RETVAL

int
close_kanwadict()

    CODE:
	RETVAL = kakasi_close_kanwadict();

    OUTPUT:
	RETVAL
