/* Copyright (C) 2001-2002 Bart Massey and Jamey Sharp.
 * All Rights Reserved.
 * Portions Copyright 1986, 1998  The Open Group
 * Portions Copyright 1987 by Digital Equipment Corporation,
 * Maynard, Massachusetts.
 * 
 * See the file COPYING for licensing information. */
#include "xclint.h"
#include <X11/Xutil.h>
// #include "Xatomtype.h"
#include <X11/Xatom.h>
// #include <X11/Xos.h>

#define safestrlen(s) ((s) ? strlen(s) : 0)

#if 0 /* not needed yet */
int
XSetSizeHints(dpy, w, hints, property)		/* old routine */
	Display *dpy;
	Window w;
	XSizeHints *hints;
        Atom property;
{
        xPropSizeHints prop;
	prop.flags = (hints->flags & (USPosition|USSize|PAllHints));
	prop.x = hints->x;
	prop.y = hints->y;
	prop.width = hints->width;
	prop.height = hints->height;
	prop.minWidth = hints->min_width;
	prop.minHeight = hints->min_height;
	prop.maxWidth  = hints->max_width;
	prop.maxHeight = hints->max_height;
	prop.widthInc = hints->width_inc;
	prop.heightInc = hints->height_inc;
	prop.minAspectX = hints->min_aspect.x;
	prop.minAspectY = hints->min_aspect.y;
	prop.maxAspectX = hints->max_aspect.x;
	prop.maxAspectY = hints->max_aspect.y;
	return XChangeProperty (dpy, w, property, XA_WM_SIZE_HINTS, 32,
				PropModeReplace, (unsigned char *) &prop, 
				OldNumPropSizeElements);
}
#endif

/* 
 * XSetWMHints sets the property 
 *	WM_HINTS 	type: WM_HINTS	format:32
 */

int XSetWMHints(Display *dpy, Window w, XWMHints *wmhints)
{
	XCBChangeProperty(XCBConnectionOfDisplay(dpy), PropModeReplace, XCLWINDOW(w), XCLATOM(XA_WM_HINTS), XCLATOM(XA_WM_HINTS), 32, sizeof(*wmhints) >> 2, wmhints);
	return 1;
}


#if 0 /* not needed yet */
/* 
 * XSetZoomHints sets the property 
 *	WM_ZOOM_HINTS 	type: WM_SIZE_HINTS format: 32
 */

int
XSetZoomHints (dpy, w, zhints)
	Display *dpy;
	Window w;
	XSizeHints *zhints;
{
	return XSetSizeHints (dpy, w, zhints, XA_WM_ZOOM_HINTS);
}


/* 
 * XSetNormalHints sets the property 
 *	WM_NORMAL_HINTS 	type: WM_SIZE_HINTS format: 32
 */

int
XSetNormalHints (dpy, w, hints)			/* old routine */
	Display *dpy;
	Window w;
	XSizeHints *hints;
{
	return XSetSizeHints (dpy, w, hints, XA_WM_NORMAL_HINTS);
}



/*
 * Note, the following is one of the few cases were we really do want sizeof
 * when examining a protocol structure.  This is because the XChangeProperty
 * routine will take care of converting to host to network data structures.
 */

int
XSetIconSizes (dpy, w, list, count)
	Display *dpy;
	Window w;	/* typically, root */
	XIconSize *list;
	int count; 	/* number of items on the list */
{
	register int i;
	xPropIconSize *pp, *prop;
#define size_of_the_real_thing sizeof	/* avoid grepping screwups */
	unsigned nbytes = count * size_of_the_real_thing(xPropIconSize);
#undef size_of_the_real_thing
	if ((prop = pp = (xPropIconSize *) Xmalloc (nbytes))) {
	    for (i = 0; i < count; i++) {
		pp->minWidth  = list->min_width;
		pp->minHeight = list->min_height;
		pp->maxWidth  = list->max_width;
		pp->maxHeight = list->max_height;
		pp->widthInc  = list->width_inc;
		pp->heightInc = list->height_inc;
		pp += 1;
		list += 1;
	    }
	    XChangeProperty (dpy, w, XA_WM_ICON_SIZE, XA_WM_ICON_SIZE, 32, 
			     PropModeReplace, (unsigned char *) prop, 
			     count * NumPropIconSizeElements);
	    Xfree ((char *)prop);
	}
	return 1;
}
#endif

int XSetCommand(Display *dpy, Window w, char **argv, int argc)
{
	register int i;
	register int nbytes;
	register char *buf, *bp;
	for (i = 0, nbytes = 0; i < argc; i++) {
		nbytes += safestrlen(argv[i]) + 1;
	}
	if ((bp = buf = Xmalloc((unsigned) nbytes))) { 
	    /* copy arguments into single buffer */
	    for (i = 0; i < argc; i++) {
		if (argv[i]) { 
		    (void) strcpy(bp, argv[i]);
		    bp += strlen(argv[i]) + 1;
		}
		else
		    *bp++ = '\0';
	    }
	    XCBChangeProperty(XCBConnectionOfDisplay(dpy), PropModeReplace, XCLWINDOW(w), XCLATOM(XA_WM_COMMAND), XCLATOM(XA_STRING), 8, nbytes, buf);
	    Xfree(buf);		
	}
	return 1;
}

#if 0 /* not needed yet */
/* 
 * XSetStandardProperties sets the following properties:
 *	WM_NAME		  type: STRING		format: 8
 *	WM_ICON_NAME	  type: STRING		format: 8
 *	WM_HINTS	  type: WM_HINTS	format: 32
 *	WM_COMMAND	  type: STRING
 *	WM_NORMAL_HINTS	  type: WM_SIZE_HINTS 	format: 32
 */

int
#if NeedFunctionPrototypes
XSetStandardProperties (
    	Display *dpy,
    	Window w,		/* window to decorate */
    	_Xconst char *name,	/* name of application */
    	_Xconst char *icon_string,/* name string for icon */
	Pixmap icon_pixmap,	/* pixmap to use as icon, or None */
    	char **argv,		/* command to be used to restart application */
    	int argc,		/* count of arguments */
    	XSizeHints *hints)	/* size hints for window in its normal state */
#else
XSetStandardProperties (dpy, w, name, icon_string, icon_pixmap, argv, argc, hints)
    	Display *dpy;
    	Window w;		/* window to decorate */
    	char *name;		/* name of application */
    	char *icon_string;	/* name string for icon */
	Pixmap icon_pixmap;	/* pixmap to use as icon, or None */
    	char **argv;		/* command to be used to restart application */
    	int argc;		/* count of arguments */
    	XSizeHints *hints;	/* size hints for window in its normal state */
#endif
{
	XWMHints phints;
	phints.flags = 0;

	if (name != NULL) XStoreName (dpy, w, name);

	if (icon_string != NULL) {
	    XChangeProperty (dpy, w, XA_WM_ICON_NAME, XA_STRING, 8,
		PropModeReplace, (unsigned char *)icon_string, safestrlen(icon_string));
		}

	if (icon_pixmap != None) {
		phints.icon_pixmap = icon_pixmap;
		phints.flags |= IconPixmapHint;
		}
	if (argv != NULL) XSetCommand(dpy, w, argv, argc);
	
	if (hints != NULL) XSetNormalHints(dpy, w, hints);

	if (phints.flags != 0) XSetWMHints(dpy, w, &phints);

	return 1;
}

int
XSetTransientForHint(dpy, w, propWindow)
	Display *dpy;
	Window w;
	Window propWindow;
{
	return XChangeProperty(dpy, w, XA_WM_TRANSIENT_FOR, XA_WINDOW, 32,
			       PropModeReplace, (unsigned char *) &propWindow, 1);
}
#endif

int XSetClassHint(Display *dpy, Window w, XClassHint *classhint)
{
	char *class_string;
	char *s;
	int len_nm, len_cl;

	len_nm = safestrlen(classhint->res_name);
	len_cl = safestrlen(classhint->res_class);
	if ((class_string = s = Xmalloc((unsigned) (len_nm + len_cl + 2)))) { 
	    if (len_nm) {
		strcpy(s, classhint->res_name);
		s += len_nm + 1;
	    }
	    else
		*s++ = '\0';
	    if (len_cl)
		strcpy(s, classhint->res_class);
	    else
		*s = '\0';
	    XCBChangeProperty(XCBConnectionOfDisplay(dpy), PropModeReplace, XCLWINDOW(w), XCLATOM(XA_WM_CLASS), XCLATOM(XA_STRING), 8, len_nm+len_cl+2, class_string);
	    Xfree(class_string);
	}
	return 1;
}
