/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.wsee;

import java.io.Serializable;
import java.util.List;

import xdoclet.DocletTask;

/**
 * This task executes various wsee specific tasks
 *
 * @author        Christoph G. Jung (christoph.jung@infor.de)
 * @created       23.12.03
 * @ant.element   name="wseedoclet" display-name="Web Services for Java 2 Enterprise Edition Task"
 * @version       $Revision: 1.1 $
 */

public class WseeDocletTask extends DocletTask
{
    /**
     * constants
     */
    public final static String DEFAULT_SPEC = "1.1";

    /**
     * state
     */
    protected String wseeSpec = DEFAULT_SPEC;
    protected String wsdlFile;
    protected String jaxrpcMappingFile;

    protected List  packageNamespaceMappings = new java.util.ArrayList();

    /**
     * @return   specification version
     */
    public String getWseeSpec()
    {
        return wseeSpec;
    }

    /**
     * @return   location of the jaxrpc file
     */
    public String getJaxrpcMappingFile()
    {
        return jaxrpcMappingFile;
    }

    /**
     * @return   location of the wsdl file
     */
    public String getWsdlFile()
    {
        return wsdlFile;
    }

    /**
     * @return
     */
    public List getPackageNamespaceMappings()
    {
        return packageNamespaceMappings;
    }

    /**
     * set specification version
     *
     * @param ver  string specifier
     */
    public void setWseeSpec(String ver)
    {
        wseeSpec = ver;
    }

    /**
     * set location of jaxrpc mapping file
     *
     * @param location  the file location
     */
    public void setJaxrpcMappingFile(String location)
    {
        jaxrpcMappingFile = location;
    }

    /**
     * set location of the wsdl file
     *
     * @param location  the file location
     */
    public void setWsdlFile(String location)
    {
        wsdlFile = location;
    }

    /**
     * @param list
     */
    public void setPackageNamespaceMappings(List list)
    {
        packageNamespaceMappings = list;
    }

    /**
     * adds a package-namespace mapping
     *
     * @param mapping  The feature to be added to the PackageNamespaceMapping attribute
     */
    public void addPackageNamespaceMapping(PackageNamespaceMapping mapping)
    {
        packageNamespaceMappings.add(mapping);
    }

    /**
     * Inner class designed after package substitutions
     *
     * @created   23. Februar 2004
     */
    public static class PackageNamespaceMapping implements Serializable
    {
        private String packages = null;
        private String namespace = null;

        /**
         * Gets the Packages attribute of the PackageSubstitution object
         *
         * @return   The Packages value
         */
        public String getPackages()
        {
            return packages;
        }

        /**
         * Gets the SubstituteWith attribute of the PackageSubstitution object
         *
         * @return   The SubstituteWith value
         */
        public String getNamespace()
        {
            return namespace;
        }

        /**
         * Sets the Packages attribute of the PackageSubstitution object
         *
         * @param packages  The new Packages value
         */
        public void setPackages(String packages)
        {
            this.packages = packages;
        }

        /**
         * Sets the SubstituteWith attribute of the PackageSubstitution object
         *
         * @param ns
         */
        public void setNamespace(String ns)
        {
            this.namespace = ns;
        }
    }

}
