
/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define __MENU_C__


#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <pwd.h>
#include <ctype.h>
#include <glob.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"
#include "primary.h"
#include "gui.h"
#include "tubo.h"

#include "actions_lib.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#include "menu.i"

/****************/


extern char **environ;




/***************/



/* gui_autofunction for directories works different: 
 * directories: the path argument is relative, so we must do a chdir
 * 		to the path directory.
 * 		The output specified will carry along the fullpath for 
 * 		output. The workdir will be that where the directory 
 * 		resides. We must do a chdir here.
 * files:	the path argument is absolute. So we just do a chdir to
 * 		the specified workdir before execution.
 *
 * 		*/
G_MODULE_EXPORT
void
gui_autofunction  (widgets_t *widgets_p, record_entry_t *en,
		const gchar **arguments,gboolean queued) 
{

  show_text(widgets_p);
  print_diagnostics(widgets_p,NULL, _("processing"),"...\n",NULL);
  print_status(widgets_p,"xffm/info", _("processing")," ",arguments[0],"...",NULL);
	
  if (en && en->path) RECENT_add2history(widgets_p, en->path);
   /* (queued functionality now dropped...) */
  
    xffm_runvwd(widgets_p,widgets_p->workdir,arguments);

  return;
}

    

G_MODULE_EXPORT
void gui_on_close_activate(GtkMenuItem * menuitem, gpointer data)
{
    widgets_t *widgets_p = (widgets_t *)data;
    if (!widgets_p) exit (1);
    gtk_widget_hide(widgets_p->window);
    while (gtk_events_pending()) gtk_main_iteration();
    disable_diagnostics();
    if (strstr(xffm_details->argv[0],"xffstab") && xffm_details->argv[1]) {
	/* if argv[1] was already mounted, this will unmount it too
	 * (if not busy, of course).*/
	chdir(GETWD);
	if (fork()){
	   if (FSTAB_is_mounted((const gchar *)xffm_details->argv[1])){
	     char *arguments[3];
#ifdef DEBUG
	     printf("TRACE:umount %s\n",xffm_details->argv[1]);
#endif
     	     arguments[0]="umount";
	     arguments[1]=xffm_details->argv[1];	     
	     arguments[2]=0;
	     execvp(arguments[0],arguments);
	     _exit(123);
	   }
#ifdef DEBUG
	   else printf("TRACE:not mounted %s\n",xffm_details->argv[1]);
#endif
	} 
	
    }

    cleanup_tmpfiles();
     _exit(123);
    return;
}

/* keybindings... accel group will not work if menus is not around. This is a
 * gtk feature, so we have to do our own keybinding. 
 **/

/* function to add a keybind */

G_MODULE_EXPORT 
void 
gui_add_to_keylist(guint in_key, guint mask, gpointer callback){
    GList *tmp;
    keybind_t *keybind_p;
    guint key;

    if (in_key < 128) {
	TRACE("key=toupper(in_key)");
	key=toupper(in_key);
    }
    else key=in_key;
    
    for (tmp=key_list; tmp; tmp=tmp->next){
	keybind_p = (keybind_t *)tmp->data;
	if (!keybind_p) continue;
	if (key == keybind_p->key && mask == keybind_p->mask) return;
    }
    TRACE("adding to keylist=%u callback=0x%x",key,(unsigned)callback);
    keybind_p = (keybind_t *)malloc(sizeof(keybind_t));
    memset(keybind_p,0,sizeof(keybind_t));
    keybind_p->key = key;
    keybind_p->mask = mask;
    keybind_p->callback = callback;
    key_list=g_list_append(key_list, keybind_p);
    return;
}

/* function to run callback with keybind values */
typedef void (*keybind_f)(GtkMenuItem *, gpointer);

G_MODULE_EXPORT 
int 
gui_keybind_exec(guint in_key, guint mask, void *data){
    GList *tmp;
    void (*callback)(GtkMenuItem *menuitem, gpointer data);
    guint key;

    if (in_key < 128) key=toupper(in_key);
    else key=in_key;
    
    for (tmp=key_list; tmp; tmp=tmp->next){
	keybind_t *keybind_p = (keybind_t *)tmp->data;
	if (!keybind_p) continue;
	TRACE("key: %u=%u?",(char)keybind_p->key,key);
	if (key == keybind_p->key && mask == keybind_p->mask) {
	    callback = (keybind_f)keybind_p->callback;
	    TRACE("callback=0x%x, data=0x%x",
		    (unsigned)callback,(unsigned)data);
	    (*callback)(NULL,  data);
	    return TRUE;
	}
    }
    TRACE("no keybinding...");
    return FALSE; 
}


G_MODULE_EXPORT
gboolean gui_common_mask_key(GdkEventKey *event, void *data){
    if (!event->state&(GDK_SHIFT_MASK|GDK_CONTROL_MASK|GDK_MOD1_MASK)) {
	TRACE("no mask");
	return FALSE;
    }
    if (event->state&GDK_SHIFT_MASK) 
	return gui_keybind_exec(event->keyval, GDK_SHIFT_MASK, data);
    else if (event->state&GDK_CONTROL_MASK) 
	return gui_keybind_exec(event->keyval, GDK_CONTROL_MASK, data);
    else if (event->state&GDK_MOD1_MASK) 
	return gui_keybind_exec(event->keyval, GDK_MOD1_MASK, data);
    return FALSE;
}


G_MODULE_EXPORT
GtkWidget * 
gui_add_menu_separator(	GtkWidget *parent)
{
    GtkWidget *w = gtk_menu_item_new ();
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (parent), w);
    gtk_widget_set_sensitive (w, FALSE);
    return w;
}

/* function valid for only one radio group: */
G_MODULE_EXPORT
GtkWidget *gui_mk_radio_button(widgets_t *widgets_p, const gchar *label, const gchar *name,GtkWidget *parent,GSList **radiogroup)
{
  GtkWidget *w=gtk_radio_menu_item_new_with_mnemonic (*radiogroup,label);

  /*w = gtk_radio_menu_item_new_with_mnemonic (*radiogroup,label);*/
  *radiogroup = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (w));
  gtk_widget_show (w);
  gtk_container_add (GTK_CONTAINER (parent), w);
  //gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (w), TRUE);
  GLADE_HOOKUP_OBJECT (widgets_p->window, w, name);
  return w;
}

G_MODULE_EXPORT
GtkWidget *
gui_mk_menu(		widgets_t *widgets_p,
			const gchar * label,
			const gchar *name, 
			GtkWidget *parent, 
			gpointer callback, 
			const gchar *iconfile)
{
    GtkWidget *menu_menu = gtk_menu_new ();
    GtkWidget *v;
    GtkWidget *w = gtk_image_menu_item_new_with_mnemonic (label);
    /*GtkWidget *w=gtk_menu_item_new_with_mnemonic (label);*/
    if (name) GLADE_HOOKUP_OBJECT (widgets_p->window, w, name);
    gtk_widget_show (w);
    if (parent) gtk_container_add (GTK_CONTAINER (parent), w);
    if (name){
	gchar *g=g_strconcat(name,"_menu",NULL);
	GLADE_HOOKUP_OBJECT (widgets_p->window, menu_menu, g);
    }
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (w), menu_menu);
    v = gtk_menu_item_new_with_mnemonic (label);
    gtk_widget_show (v);
    gtk_container_add (GTK_CONTAINER (menu_menu), v);
    gtk_widget_set_sensitive (v, FALSE);
    gui_add_menu_separator(menu_menu);
    if (callback){
	g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (callback),
                    NULL);
    }
    /* invalid cast from `GtkMenuItem' to `GtkImageMenuItem'
     * (just one item, so maybe not worth using... )
     * if (iconfile) gui_mk_pixmap_menu(window, iconfile,w,MENU_PIXMAP);*/

    return menu_menu;
}


G_MODULE_EXPORT
void 
gui_mk_module_popup_menu (widgets_t *widgets_p, const gchar *module_name,gpointer gui_data, record_entry_t *en)
{
    const gchar *txt;
    if (!module_name) return;
    txt=function_natural("plugins",module_name,en,"module_label");
    
    /* set the submenu label */
    if (txt) {
        GtkWidget *label,*a=lookup_widget(widgets_p->window,"module1");
        label = gtk_bin_get_child(GTK_BIN(a));
        gtk_label_set_text((GtkLabel *)label,my_utf_string(txt));
    }
    /* remove anything left over */
    gtk_container_foreach ((GtkContainer *)lookup_widget(widgets_p->window,"module1_menu"),
	    remove_menu_item,NULL);

    /* add new stuff to submenu */
    function_rational("plugins",module_name,(void *)(lookup_widget(widgets_p->window,"module1_menu")),widgets_p,"extend_popup");
    
}

G_MODULE_EXPORT 
void
gui_add_menu_item(	widgets_t *widgets_p,
			GtkWidget *parent,
			const gchar *label,
			const gchar *icon_id,
			const gchar *name,
			gpointer callback,
			gpointer callback_data,
			GtkAccelGroup *accel_group,
			guint accel_key,
			guint accel_mask
			)
{
    GtkWidget *w = gtk_image_menu_item_new_with_mnemonic (label);
    gui_mk_pixmap_menu(widgets_p, icon_id, w,MENU_PIXMAP);
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (parent), w);
    GLADE_HOOKUP_OBJECT (widgets_p->window, w, name);
    if (callback) g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (callback),
                    callback_data);
    if (accel_key){
	gui_add_to_keylist(accel_key, accel_mask,  callback);
    }
#ifdef USE_ACCEL_LABELS
    if (accel_group) gtk_widget_add_accelerator (w, "activate", accel_group,
                              accel_key, accel_mask,
                              GTK_ACCEL_VISIBLE);
#endif
}



G_MODULE_EXPORT 
GtkWidget *
gui_mk_pixmap_menu(	widgets_t *widgets_p, 
			const gchar *file,
			GtkWidget *parent,
			int caso) 
{
    
    GtkWidget *w;
    GdkPixbuf *pb=NULL;
    
      TRACE(" gui_mk_pixmap_menu, file: %s",file);
    switch (caso) {
	case MENU_PIXMAP:
	    pb=icon_tell(widgets_p,SMALL,file);
	break;
	case BUTTON_PIXMAP:
	    pb=icon_tell(widgets_p,SMALL,file);
	break;
	case BIGGER_MENU_PIXMAP:
	case BIGGER_BUTTON_PIXMAP:
	    pb=icon_tell(widgets_p,MEDIUM,file);
	break;
	case OTHER_PIXMAP:
	    pb=icon_tell(widgets_p,SMALL,file);
	break;
    }
    if (!pb) {
	g_warning("pb=NULL in gui_mk_pixmap_menu()");
	return NULL;
    }
      TRACE(" gui_mk_pixmap_menu ok, file: %s",file);
    
    w=gtk_image_new_from_pixbuf (pb);
    g_object_unref(pb);
    gtk_widget_show (w);

    switch (caso) {
	case BIGGER_MENU_PIXMAP:
	case MENU_PIXMAP:
	    gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (parent), w);
	break;
	case BIGGER_BUTTON_PIXMAP:
	case BUTTON_PIXMAP:
	    gtk_container_add (GTK_CONTAINER (parent), w);
	break;
	case OTHER_PIXMAP:
	    gtk_box_pack_start (GTK_BOX (parent), w, FALSE, TRUE, 0);
	    gtk_misc_set_padding (GTK_MISC (w), 4, 0);
	break;
    }	
    return w;
}


G_MODULE_EXPORT
GtkWidget *
gui_mk_input_box(	widgets_t *widgets_p,
			GtkWidget *parent,
			gpointer user_data)
{
  GtkWidget *input_label;
  GtkWidget *input_combo;
  GtkWidget *input_entry;
  GtkWidget *checkbutton3;
  GtkWidget *checkbutton2;
  GtkWidget *checkbutton1;
  GtkWidget *button200 = gtk_button_new ();
  GtkWidget *input_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (input_box);
  gtk_box_pack_start (GTK_BOX (parent), input_box, FALSE, FALSE, 0);

  gtk_widget_show (button200);
  gtk_box_pack_end (GTK_BOX (input_box), button200, FALSE, FALSE, 0);
  gtk_button_set_relief (GTK_BUTTON (button200), GTK_RELIEF_NONE);
  gui_mk_pixmap_menu(widgets_p, "xffm/stock_apply",button200,BUTTON_PIXMAP);
  

  checkbutton3 = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (checkbutton3);
  gtk_box_pack_end (GTK_BOX (input_box), checkbutton3, FALSE, FALSE, 0);

  checkbutton2 = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (checkbutton2);
  gtk_box_pack_end (GTK_BOX (input_box), checkbutton2, FALSE, FALSE, 0);

  checkbutton1 = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (checkbutton1);
  gtk_box_pack_end (GTK_BOX (input_box), checkbutton1, FALSE, FALSE, 0);


  input_label = gtk_label_new ("");
  gtk_widget_show (input_label);
  gtk_box_pack_start (GTK_BOX (input_box), input_label, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (input_label), 5, 0);

  input_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (input_combo)->popwin),
                     "GladeParentKey", input_combo);
  gtk_widget_show (input_combo);
  gtk_box_pack_start (GTK_BOX (input_box), input_combo, TRUE, TRUE, 0);
  gtk_combo_set_case_sensitive (GTK_COMBO (input_combo), TRUE);

  input_entry = GTK_COMBO (input_combo)->entry;
  gtk_widget_show (input_entry);
  
  /*gui_mk_pixmap_menu(window, "xffm/question",input_box,OTHER_PIXMAP);*/
  /*g_signal_connect ((gpointer) button200, "clicked",
                    G_CALLBACK (on_input_ok),
                    user_data);*/
  GLADE_HOOKUP_OBJECT (widgets_p->window, input_box, "input_box");
  GLADE_HOOKUP_OBJECT (widgets_p->window, button200, "input_ok");
  GLADE_HOOKUP_OBJECT (widgets_p->window, checkbutton3, "checkbutton3");
  GLADE_HOOKUP_OBJECT (widgets_p->window, checkbutton2, "checkbutton2");
  GLADE_HOOKUP_OBJECT (widgets_p->window, checkbutton1, "checkbutton1");
  GLADE_HOOKUP_OBJECT (widgets_p->window, input_label, "input_label");
  GLADE_HOOKUP_OBJECT (widgets_p->window, input_combo, "input_combo");
  GLADE_HOOKUP_OBJECT (widgets_p->window, input_entry, "input_entry");

  
  return input_box;
}

static void
activate_entry(GtkEntry *entry, gpointer data){
    gtk_dialog_response  ((GtkDialog *)data,GTK_RESPONSE_YES);
}
static void
cancel_entry(GtkEntry *entry, gpointer data){
    gtk_dialog_response  ((GtkDialog *)data,GTK_RESPONSE_CANCEL);
}


G_MODULE_EXPORT
const gchar *
gui_get_response_history(	widgets_t *widgets_p, 
				const gchar *title_txt, 
				const gchar *label_txt,
				gchar *history_file,
				const gchar *path,
				const gchar *entry_text){
    static gchar *response_txt=NULL;
    int response = GTK_RESPONSE_NONE;
    GtkWidget *hbox,*label,*button,*dialog ;
    static GtkCombo *combo=NULL;
    xfc_combo_info_t *combo_info=NULL;

    dialog = gtk_dialog_new();

    g_free(response_txt);
    response_txt=NULL;
    if (widgets_p){
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (widgets_p->window));
	TRACE("placing gui_get_response_history"); 
	place_dialog(widgets_p->window, dialog);
    }
    gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
    gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
    gtk_container_set_border_width(GTK_CONTAINER (dialog), 6);

	
    if (label_txt) label=gtk_label_new(label_txt);
    else label=gtk_label_new(_("Input requested"));
    
    
    combo=(GtkCombo *)gtk_combo_new();
    hbox=gtk_hbox_new(FALSE, 6);
    gtk_box_pack_start (GTK_BOX ((GTK_DIALOG (dialog))->vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), (GtkWidget *)combo, FALSE, FALSE, 0); 
    gtk_widget_show_all (hbox); 
     if (combo_info==NULL){
	TRACE("signal widgets_p is 0x%x",(unsigned)widgets_p);
	combo_info = COMBO_init_combo(combo);
    } else {
	COMBO_clear_history(combo_info);
    }
    
    combo_info->activate_func = activate_entry;
    combo_info->activate_user_data=dialog;
    combo_info->cancel_func = cancel_entry;
    combo_info->cancel_user_data=dialog;
    COMBO_set_combo(combo_info,NULL);
    COMBO_read_history(combo_info,history_file);

    if (path) {
	const gchar *p=MIME_command(path);
    	if (p) combo_info->list = g_list_prepend(combo_info->list,g_strdup(p) );
    }
    COMBO_set_combo(combo_info,NULL);
    COMBO_set_entry(combo_info,(char *)entry_text);
	    	    
    button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_from_stock (GTK_STOCK_OK);
    gtk_widget_show (button);

    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_YES);
    gtk_widget_realize(dialog);

    if (title_txt) 
	gtk_window_set_title (GTK_WINDOW (dialog), title_txt);
    else 
	gdk_window_set_decorations (dialog->window,GDK_DECOR_BORDER);

    /* show dialog and return */
    response = gtk_dialog_run (GTK_DIALOG (dialog));
    if (response == GTK_RESPONSE_YES){
	const gchar *et=COMBO_get_entry(combo_info);
	if (et && strlen(et)){
		  response_txt=g_strdup(et);      
	}		      
    }
    gtk_widget_hide (dialog);
    gtk_widget_destroy (dialog); 

    /* use slocate_string to select... */
    return (const gchar *)(response_txt);
}

G_MODULE_EXPORT
const gchar *
gui_get_response(		widgets_t *widgets_p, 
				const gchar *title_txt, 
				const gchar *label_txt)
{
    static gchar *response_txt=NULL;
    int response = GTK_RESPONSE_NONE;
    GtkWidget *hbox,*label,*entry,*button,*dialog ;

    dialog = gtk_dialog_new();

    g_free(response_txt);
    response_txt=NULL;
    if (widgets_p){
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (widgets_p->window));
    
	place_dialog(widgets_p->window, dialog);
    }
    gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
    gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
    gtk_container_set_border_width(GTK_CONTAINER (dialog), 6);

	
    if (label_txt) label=gtk_label_new(label_txt);
    else label=gtk_label_new(_("Input requested"));
    
    entry=gtk_entry_new();
    hbox=gtk_hbox_new(FALSE, 6);
    gtk_box_pack_start (GTK_BOX ((GTK_DIALOG (dialog))->vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0); 
    gtk_widget_show_all (hbox); 
    g_signal_connect(G_OBJECT(entry),"activate",G_CALLBACK(activate_entry),dialog);

    button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_from_stock (GTK_STOCK_OK);
    gtk_widget_show (button);

    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_YES);
    gtk_widget_realize(dialog);

    if (title_txt) 
	gtk_window_set_title (GTK_WINDOW (dialog), title_txt);
    else 
	gdk_window_set_decorations (dialog->window,GDK_DECOR_BORDER);

    /* show dialog and return */
    response = gtk_dialog_run (GTK_DIALOG (dialog));
    if (response == GTK_RESPONSE_YES){
	      const gchar *et=gtk_entry_get_text(GTK_ENTRY(entry));
	      if (et && strlen(et)){
		  response_txt=g_strdup(et);
	      }		      
    }
    gtk_widget_hide (dialog);
    gtk_widget_destroy (dialog); 

    /* use slocate_string to select... */
    return (const gchar *)(response_txt);
}



G_MODULE_EXPORT
void 
gui_add_autotype_C_widgets(	widgets_t *widgets_p,
			void *gui_data,
			GtkWidget *popup,
			gpointer callback, 
			gpointer on_mount,
			gpointer on_unmount){
  int i;
  GtkWidget *w;

  /* check for optional fstab plugin... */
  if (function_void("plugins","xffm_fstab","module_name"))
  if (on_mount) {
    w = lookup_widget(widgets_p->window,"mountP");
    if (w) g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_mount),gui_data);
  }
  if (on_unmount) {
    w = lookup_widget(widgets_p->window,"unmountP");
    if (w) g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_unmount),gui_data);

  }
	  
  
 if (callback) for (i=0;auto_C_name[i];i++){
    GtkWidget *w;
    w=create_menu_entry(widgets_p,auto_C_name[i]," ",popup,callback,NULL,i+6);
    g_object_set_data(G_OBJECT(w),"gui_data",gui_data);
 }

}


G_MODULE_EXPORT
void gui_autostuff(		widgets_t *widgets_p, 
			void *gui_data, 
			GtkWidget *popup,
			record_entry_t *en, 
			gpointer callback,
			gpointer on_mount,
			gpointer on_unmount){
    gchar **text_editors;
    int j=0;
    
    if (!lookup_widget(widgets_p->window, auto_C_name[0]))
    {
	TRACE("creating auto menu elements from gui_autostuff");
	gui_add_autotype_C_widgets(widgets_p,gui_data, popup, callback, on_mount, on_unmount);
    }
    if (IS_EXE(en->type) && !IS_DIR(en->type)) {
      gchar *cmd;		
      GtkWidget *label,*a=lookup_widget(widgets_p->window,"autotype_Prun");
      label = gtk_bin_get_child(GTK_BIN(a));
      cmd=g_strdup_printf(_("Execute %s"),FILENAME(en));
      gtk_label_set_text((GtkLabel *)label,my_utf_string(cmd));
      g_free(cmd);
      showit(widgets_p->window,"autotype_Prun");
    }
    if(IS_DIR(en->type))
    {/* all directory commands which query for directory 
	must have output specified on command line...*/	      
       int i;
       for (i=0;auto_C_name[j]&&autotype_dir[i].label;i++){
	   gchar *alt_label;	
	   if (!autotype_dir[i].command) continue;
	   alt_label=alt_menu_label(_(autotype_dir[i].label),en->path,autotype_dir[i].extension);	
	   j=set_auto_command(widgets_p,j,popup,auto_C_name[j],alt_label,autotype_dir[i].command,en->path,autotype_dir[i].querypath,&(autotype_dir[i].queued),FILENAME(en),autotype_dir[i].extension);
	   g_free(alt_label);
       }
    }
    
    {/* autotypes */	      
       gchar *loc;
       int i;
       gboolean in_term;
       const gchar *p=xffm_get_from_open_history(en->path, &in_term);
	/* XXX: allow in term to be processed too (later...) */
       if (p && !in_term) {
	   j=set_auto_command(widgets_p,j,popup,auto_C_name[j],NULL,p,en->path,NULL,NULL,NULL,NULL);
       }

       for (i=0;auto_C_name[j]&&autotype[i].extension;i++){
	   if (!auto_C_name[j]) continue;
           loc=strstr(en->path,autotype[i].extension);
           if ((loc)&&(strcmp(loc,autotype[i].extension)==0)){
	       gchar *alt_label;	
	       if (autotype[i].command == NULL) continue;
	       alt_label=alt_menu_label(_(autotype[i].label),en->path,NULL);	
	       
	       j=set_auto_command(widgets_p,j,popup,auto_C_name[j],alt_label,autotype[i].command,en->path,autotype[i].querypath,&(autotype[i].queued),NULL,NULL);
	       g_free(alt_label);
	   }
       }
    }

	    
    /* duplicate mime types */
    if (IS_FILE(en->type)||IS_NETFILE(en->subtype)){
      int i=0;
      const gchar **apps=MIME_apps(en->path);
      if (apps && apps[i]) for (;apps && apps[i]; i++){
	  if (!auto_C_name[j]) continue;
	  j=set_auto_command(widgets_p,j,popup,auto_C_name[j],NULL,apps[i],en->path,NULL,NULL,NULL,NULL);
      }	
      
    }
    if ((text_editors=text_type_OK(en->path))!=NULL){  
	  /* OK to apply an editor */
	int k;
	TRACE("text_editors != NULL");
	for (k=0;text_editors[k];k++){
	    j=set_auto_command(widgets_p,j,popup,auto_C_name[j],NULL,text_editors[k],en->path,NULL,NULL,NULL,NULL);
	}
    }

   	
    if (g_file_test(en->path,G_FILE_TEST_EXISTS)||IS_NETFILE(en->subtype)) {
	showit(widgets_p->window, "open_with_menuitem");		
    }

    
    return;
}




