/*
 *
 * Copyright (C) 1999 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * Olivier Fourdan (fourdan@xfce.org)
 * Heavily modified as part of the Xfce project (http://www.xfce.org)
 *
 * Edscott Wilson Garcia Copyright 2001-2006
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static xfprop_functions *xfprop_fun=NULL;
static dlg dl;
static mode_t new_u_m,new_g_m,new_o_m;
static uid_t new_owner,new_group;
static GList *select_list=NULL;



static GtkWidget *label_new(char *text, GtkJustification j_type)
{
    GtkWidget *label;
    label = gtk_label_new(text);
    gtk_label_set_justify(GTK_LABEL(label), j_type);
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    /* j_type == GTK_JUSTIFY_RIGHT? 1.0 : 0.0, 0.5); */
    return (label);
}

static row_t u_row,g_row,o_row,row_chown,row_chgrp;
static void on_off(GtkWidget * toggle, void *data)
{
    int i;
    row_t *row = (row_t *)data;
    if (row->flag) row->flag=FALSE;
    else row->flag=TRUE;
    for (i=0;i<5;i++) gtk_widget_set_sensitive(row->w[i],row->flag);
}
static void on_off2(GtkWidget * toggle, void *data)
{
    int i;
    row_t *row = (row_t *)data;
    if (row->flag) row->flag=FALSE;
    else row->flag=TRUE;
    for (i=0;i<2;i++) gtk_widget_set_sensitive(row->w[i],row->flag);
}

static void on_cancel(GtkWidget * btn, gpointer * data)
{
    if((int)((long)data) != DLG_RC_DESTROY)
    {
	dl.result = (int)((long)data);
	gtk_widget_destroy(dl.top);
    }
    gtk_main_quit();
}

static void on_ok(GtkWidget * ok, gpointer * data)
{
    char *val;
    struct passwd *pw;
    struct group *gr;

    val = (char *)gtk_entry_get_text(GTK_ENTRY(dl.user));
    if(val)
    {
	pw = getpwnam(val);
	if(pw)
	{
	    if (dl.st) new_owner=dl.st->st_uid = pw->pw_uid;
	    else new_owner = pw->pw_uid;
	}
    }
    val = (char *)gtk_entry_get_text(GTK_ENTRY(dl.group));
    if(val)
    {
	gr = getgrnam(val);
	if(gr)
	{
	    if (dl.st) new_group=dl.st->st_gid = gr->gr_gid;
	    else new_group = gr->gr_gid;
	}
    }
    gtk_widget_destroy(dl.top);

    dl.result = (int)((long)data);
    gtk_main_quit();
}

static void cb_perm(GtkWidget * toggle, void *data)
{
    int bit = (int)((long)data);
    if(GTK_TOGGLE_BUTTON(toggle)->active){
	if (dl.st) dl.st->st_mode |= (mode_t) bit;
	if ((mode_t) bit & S_IRWXU) new_u_m |= (mode_t) bit;
	if ((mode_t) bit & S_IRWXG) new_g_m |= (mode_t) bit;
	if ((mode_t) bit & S_IRWXO) new_o_m |= (mode_t) bit;
	if ((mode_t) bit & 07000) {
		new_u_m |= (mode_t) bit;
		new_g_m |= (mode_t) bit;
		new_o_m |= (mode_t) bit;
	}
    }
    else {
	if (dl.st) dl.st->st_mode &= (mode_t) ~ bit;
 	if ((mode_t) bit & S_IRWXU) new_u_m &= (mode_t) ~ bit;
	if ((mode_t) bit & S_IRWXG) new_g_m &= (mode_t) ~ bit;
	if ((mode_t) bit & S_IRWXO) new_o_m &= (mode_t) ~ bit;
	if ((mode_t) bit & 07000) {
		new_u_m &= (mode_t) ~ bit;
		new_g_m &= (mode_t) ~ bit;
		new_o_m &= (mode_t) ~ bit;
	}
   }

}

static gint on_key_press(GtkWidget * w, GdkEventKey * event, void *data)
{
    if(event->keyval == GDK_Escape)
    {
	on_cancel((GtkWidget *) data, (gpointer) ((long)DLG_RC_CANCEL));
	return (TRUE);
    }
    return (FALSE);
}


static GtkWidget *create_text(GtkWidget * parent, char *text)
{
    GtkWidget *scroll, *helpText;
    scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_container_set_border_width(GTK_CONTAINER(scroll), 2);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(parent), scroll, TRUE, TRUE, 0);
    helpText = gtk_label_new(text);
    gtk_label_set_justify(GTK_LABEL(helpText), GTK_JUSTIFY_LEFT);
    gtk_scrolled_window_add_with_viewport((GtkScrolledWindow *) scroll, helpText);
    return scroll;
}

static gint xf_dlg_prop(widgets_t *widgets_p, record_entry_t * en, struct stat *st)
{
    GtkWidget *ok = NULL, *cancel = NULL, *label, *notebook, *table, *owner[4], *perm[18], *info[14],*vbox,*hbox;
    
#ifdef RECURSIVE_BUTTON   
    GtkWidget *recursive_b=NULL;
#endif

#ifdef HAVE_LOCALTIME_R
    struct tm t_r;
#endif
    struct tm *t;
    struct passwd *pw;
    struct group *gr;
    char buf[1024];
    char cmd[1024];
    GList *g_user = NULL;
    GList *g_group = NULL, *g_tmp;
    int n, len;
    FILE *pipe;
    char *path;
#ifndef LINE_MAX
#define LINE_MAX	1024
#endif
    char line[LINE_MAX + 1];
    int o=0;

    if (en) path=en->path; else path=NULL;
    dl.result = 0;
    u_row.flag=g_row.flag=o_row.flag=row_chown.flag=row_chgrp.flag=FALSE;
    dl.st = st;
    dl.top = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    /*gtk_dialog_new();*/

    gtk_window_set_title(GTK_WINDOW(dl.top), _("Properties"));
    g_signal_connect(G_OBJECT(dl.top), "destroy", G_CALLBACK(on_cancel), (gpointer) ((long)DLG_RC_DESTROY));

    if (widgets_p){
      gtk_window_set_modal(GTK_WINDOW(dl.top), TRUE);
      gtk_window_set_transient_for(GTK_WINDOW(dl.top), GTK_WINDOW(widgets_p->window));
    }


    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER (dl.top), vbox);
    notebook = gtk_notebook_new();
    gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
    gtk_widget_show(hbox);

    /* ok and cancel buttons */
    ok = gtk_button_new_with_label(_("Ok"));
    cancel = gtk_button_new_with_label(_("Cancel"));
#ifdef RECURSIVE_BUTTON   
    recursive_b = gtk_button_new_with_label(_("Recursive"));
    GTK_WIDGET_SET_FLAGS(recursive_b, GTK_CAN_DEFAULT);
#endif

    GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);

    gtk_box_pack_start(GTK_BOX(hbox), ok, TRUE, FALSE, 0);
    
#ifdef RECURSIVE_BUTTON   
    gtk_box_pack_start(GTK_BOX(hbox), recursive_b, TRUE, FALSE, 0);
    g_signal_connect(G_OBJECT(recursive_b), "clicked", G_CALLBACK(on_ok), (gpointer) ((long)DLG_RC_RECURSIVE));
#endif
    
    gtk_box_pack_start(GTK_BOX(hbox), cancel, TRUE, FALSE, 0);

    g_signal_connect(G_OBJECT(ok), "clicked", G_CALLBACK(on_ok), (gpointer) ((long)DLG_RC_OK));
    g_signal_connect(G_OBJECT(cancel), "clicked", G_CALLBACK(on_cancel), (gpointer) ((long)DLG_RC_CANCEL));
    gtk_widget_grab_default(cancel);


    /* date and size page */
  if (st && en){
    /*gchar *filename=g_path_get_basename(en->path);*/
    label = gtk_label_new(_("Info"));
    table = gtk_table_new(7, 2, FALSE);
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, label);

    n = 0;
    info[n] = label_new(_("Name :"), GTK_JUSTIFY_RIGHT);
    gtk_table_attach(GTK_TABLE(table), info[n], 0, 1, n, n + 1, TBL_XOPT, 0, X_PAD, Y_PAD);
    info[n + 1] = label_new((gchar *)my_valid_utf_pathstring(en->path), GTK_JUSTIFY_LEFT);

    gtk_table_attach(GTK_TABLE(table), info[n + 1], 1, 2, n, n + 1, TBL_XOPT, 0, 0, 0);
    n += 2;
    
    

    sprintf(cmd, "file \"%s\"", path);
    pipe = popen(cmd, "r");
    if(pipe)
    {
	char *p;
	fgets(line, LINE_MAX, pipe);
	len = strlen(line);
	line[len - 1] = '\0';
	pclose(pipe);
	if((p = strstr(line, ": ")) != NULL)
	{
	    p += 2;
	    info[n + 1] = label_new(p, GTK_JUSTIFY_LEFT);
	    info[n] = label_new(_("Type :"), GTK_JUSTIFY_RIGHT);
	    gtk_table_attach(GTK_TABLE(table), info[n], 0, 1, n, n + 1, TBL_XOPT, 0, X_PAD, Y_PAD);
	    gtk_table_attach(GTK_TABLE(table), info[n + 1], 1, 2, n, n + 1, TBL_XOPT, 0, 0, 0);
	    n += 2;
	}
    }
    
    {
	gchar *g=g_strdup_printf("%s (mime)",_("Type :"));
	info[n] = label_new(g, GTK_JUSTIFY_RIGHT);
	g_free(g);
	g = (gchar *)MIME_get_type(en->path,TRUE);
	if (!g) g="";
	gtk_table_attach(GTK_TABLE(table), info[n], 0, 1, n, n + 1, TBL_XOPT, 0, X_PAD, Y_PAD);
	info[n + 1] = label_new(g, GTK_JUSTIFY_LEFT);
    }
    gtk_table_attach(GTK_TABLE(table), info[n + 1], 1, 2, n, n + 1, TBL_XOPT, 0, 0, 0);
    n += 2;

    {
	char *tag = "bytes";
	 off_t tama;
	tama = st->st_size;
	if(tama >= (off_t)1024 * 1024 * 1024 * 10)
	{
	    tama /= (off_t)1024 *1024 * 1024;
	    tag = "Gbytes";
	}
	else if(tama >= 1024 * 1024 * 10)
	{
	    tama /= 1024 * 1024;
	    tag = "Mbytes";
	}
	else if(tama >= 1024 * 10)
	{
	    tama /= 1024;
	    tag = "Kbytes";
	}
	sprintf(buf, " %d %s", (int)tama, tag);
    }
    info[n + 1] = label_new(buf, GTK_JUSTIFY_LEFT);
    info[n] = label_new(_("Size :"), GTK_JUSTIFY_RIGHT);
    gtk_table_attach(GTK_TABLE(table), info[n], 0, 1, n, n + 1, TBL_XOPT, 0, X_PAD, Y_PAD);
    gtk_table_attach(GTK_TABLE(table), info[n + 1], 1, 2, n, n + 1, TBL_XOPT, 0, 0, 0);
    n += 2;

#ifdef HAVE_LOCALTIME_R
    t = localtime_r(&st->st_ctime, &t_r);
#else
    t = localtime(&st->st_ctime);
#endif
    sprintf(buf, "%04d/%02d/%02d  %02d:%02d", t->tm_year + 1900, t->tm_mon + 1, t->tm_mday, t->tm_hour, t->tm_min);
    info[n + 1] = gtk_label_new(buf);
    info[n] = gtk_label_new(_("Creation Time :"));
    gtk_table_attach(GTK_TABLE(table), info[n], 0, 1, n, n + 1, TBL_XOPT, 0, X_PAD, Y_PAD);
    gtk_table_attach(GTK_TABLE(table), info[n + 1], 1, 2, n, n + 1, TBL_XOPT, 0, 0, 0);
    n += 2;

#ifdef HAVE_LOCALTIME_R
    t = localtime_r(&st->st_mtime, &t_r);
#else
    t = localtime(&st->st_mtime);
#endif
    sprintf(buf, "%02d/%02d/%02d  %02d:%02d", t->tm_year + 1900, t->tm_mon + 1, t->tm_mday, t->tm_hour, t->tm_min);
    info[n + 1] = gtk_label_new(buf);
    info[n] = gtk_label_new(_("Modification Time :"));
    gtk_table_attach(GTK_TABLE(table), info[n], 0, 1, n, n + 1, TBL_XOPT, 0, X_PAD, Y_PAD);
    gtk_table_attach(GTK_TABLE(table), info[n + 1], 1, 2, n, n + 1, TBL_XOPT, 0, 0, 0);
    n += 2;

#ifdef HAVE_LOCALTIME_R
    t = localtime_r(&st->st_atime, &t_r);
#else
    t = localtime(&st->st_atime);
#endif
    sprintf(buf, "%04d/%02d/%02d  %02d:%02d", t->tm_year + 1900, t->tm_mon + 1, t->tm_mday, t->tm_hour, t->tm_min);
    info[n + 1] = gtk_label_new(buf);
    info[n] = gtk_label_new(_("Access Time :"));
    gtk_table_attach(GTK_TABLE(table), info[n], 0, 1, n, n + 1, TBL_XOPT, 0, X_PAD, Y_PAD);
    gtk_table_attach(GTK_TABLE(table), info[n + 1], 1, 2, n, n + 1, TBL_XOPT, 0, 0, 0);
    n += 2;
  }
    /* permissions page */
    /* if (!(flags & IS_STALE_LINK)) */
    {
	label = gtk_label_new(_("Permissions"));
	if (st) table = gtk_table_new(3, 5, FALSE);
	else table = gtk_table_new(3, 6, FALSE);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, label);

	if (!st) { 
	    o=1;	
	    perm[15] = gtk_check_button_new_with_label(_("Change"));
	    perm[16] = gtk_check_button_new_with_label(_("Change"));
	    perm[17] = gtk_check_button_new_with_label(_("Change"));
	}else {
		perm[15]=perm[16]=perm[17]=NULL;
	}
	/*} else if (en && IS_DIR(en->type)){
	    perm[15] = gtk_check_button_new_with_label(_("Recursive"));
	}else perm[15]=NULL;*/
	u_row.w[0]=perm[0] = gtk_label_new(_("Owner :"));
	u_row.w[1]=perm[1] = gtk_check_button_new_with_label(_("Read"));
	if(st && st->st_mode & S_IRUSR)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[1]), 1);
	g_signal_connect(G_OBJECT(perm[1]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IRUSR));
	u_row.w[2]=perm[2] = gtk_check_button_new_with_label(_("Write"));
	if(st && st->st_mode & S_IWUSR)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[2]), 1);
	g_signal_connect(G_OBJECT(perm[2]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IWUSR));
	u_row.w[3]=perm[3] = gtk_check_button_new_with_label(_("Execute"));
	if(st && st->st_mode & S_IXUSR)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[3]), 1);
	g_signal_connect(G_OBJECT(perm[3]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IXUSR));
	u_row.w[4]=perm[4] = gtk_check_button_new_with_label(_("Set UID"));
	if(st && st->st_mode & S_ISUID)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[4]), 1);
	g_signal_connect(G_OBJECT(perm[4]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_ISUID));
	
	gtk_table_attach(GTK_TABLE(table), perm[0], 0+o, 1+o, 0, 1, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[1], 1+o, 2+o, 0, 1, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[2], 2+o, 3+o, 0, 1, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[3], 3+o, 4+o, 0, 1, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[4], 4+o, 5+o, 0, 1, 0, 0, X_PAD, 0);

	g_row.w[0]=perm[5] = gtk_label_new(_("Group :"));
	g_row.w[1]=perm[6] = gtk_check_button_new_with_label(_("Read"));
	if(st && st->st_mode & S_IRGRP)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[6]), 1);
	g_signal_connect(G_OBJECT(perm[6]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IRGRP));
	g_row.w[2]=perm[7] = gtk_check_button_new_with_label(_("Write"));
	if(st && st->st_mode & S_IWGRP)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[7]), 1);
	g_signal_connect(G_OBJECT(perm[7]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IWGRP));
	g_row.w[3]=perm[8] = gtk_check_button_new_with_label(_("Execute"));
	if(st && st->st_mode & S_IXGRP)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[8]), 1);
	g_signal_connect(G_OBJECT(perm[8]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IXGRP));
	g_row.w[4]=perm[9] = gtk_check_button_new_with_label(_("Set GID"));
	if(st && st->st_mode & S_ISGID)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[9]), 1);
	g_signal_connect(G_OBJECT(perm[9]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_ISGID));
	gtk_table_attach(GTK_TABLE(table), perm[5], 0+o, 1+o, 1, 2, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[6], 1+o, 2+o, 1, 2, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[7], 2+o, 3+o, 1, 2, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[8], 3+o, 4+o, 1, 2, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[9], 4+o, 5+o, 1, 2, 0, 0, X_PAD, 0);

	o_row.w[0]=perm[10] = gtk_label_new(_("Other :"));
	o_row.w[1]=perm[11] = gtk_check_button_new_with_label(_("Read"));
	if(st && st->st_mode & S_IROTH)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[11]), 1);
	g_signal_connect(G_OBJECT(perm[11]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IROTH));
	o_row.w[2]=perm[12] = gtk_check_button_new_with_label(_("Write"));
	if(st && st->st_mode & S_IWOTH)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[12]), 1);
	g_signal_connect(G_OBJECT(perm[12]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IWOTH));
	o_row.w[3]=perm[13] = gtk_check_button_new_with_label(_("Execute"));
	if(st && st->st_mode & S_IXOTH)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[13]), 1);
	g_signal_connect(G_OBJECT(perm[13]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_IXOTH));
	o_row.w[4]=perm[14] = gtk_check_button_new_with_label(_("Sticky"));
	if(st && st->st_mode & S_ISVTX)
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(perm[14]), 1);
	g_signal_connect(G_OBJECT(perm[14]), "clicked", G_CALLBACK(cb_perm), (gpointer) ((long)S_ISVTX));
	if (perm[15]) {
		gtk_table_attach(GTK_TABLE(table), perm[15], 0, 1, 0, 1, 0, 0, X_PAD, 0);
		g_signal_connect(G_OBJECT(perm[15]), "clicked", G_CALLBACK(on_off), (gpointer) (&u_row));
	}
	if (perm[16]) {
		gtk_table_attach(GTK_TABLE(table), perm[16], 0, 1, 1, 2, 0, 0, X_PAD, 0);
		g_signal_connect(G_OBJECT(perm[16]), "clicked", G_CALLBACK(on_off), (gpointer) (&g_row));
	}
	if (perm[17]) {
		gtk_table_attach(GTK_TABLE(table), perm[17], 0, 1, 2, 3, 0, 0, X_PAD, 0);
		g_signal_connect(G_OBJECT(perm[17]), "clicked", G_CALLBACK(on_off), (gpointer) (&o_row));
	}

	gtk_table_attach(GTK_TABLE(table), perm[10], 0+o, 1+o, 2, 3, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[11], 1+o, 2+o, 2, 3, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[12], 2+o, 3+o, 2, 3, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[13], 3+o, 4+o, 2, 3, 0, 0, X_PAD, 0);
	gtk_table_attach(GTK_TABLE(table), perm[14], 4+o, 5+o, 2, 3, 0, 0, X_PAD, 0);

	if (perm[15]) {
	    for (o=0;o<15;o++) gtk_widget_set_sensitive(perm[o], FALSE);
	}
    }

    /* owner/group page */
    if (st) o=0; else o=1;
    while((pw = getpwent()) != NULL)
    {
	g_user = g_list_append(g_user, g_strdup(pw->pw_name));
    }
    g_user = g_list_sort(g_user, (GCompareFunc) strcmp);
    endpwent();

    while((gr = getgrent()) != NULL)
    {
	g_group = g_list_append(g_group, g_strdup(gr->gr_name));
    }
    endgrent();
    g_group = g_list_sort(g_group, (GCompareFunc) strcmp);

    label = gtk_label_new(_("Owner"));
    if (st) table = gtk_table_new(2, 2, FALSE);
    else table = gtk_table_new(2, 3, FALSE);
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, label);

    if (!st){
      perm[15] = gtk_check_button_new_with_label(_("Change"));
      perm[16] = gtk_check_button_new_with_label(_("Change"));
    }

    if (st) pw = getpwuid(st->st_uid);
    else pw=getpwuid(geteuid());
    sprintf(buf, "%s", pw ? pw->pw_name : _("unknown"));
    g_user=g_list_prepend(g_user,g_strdup(buf));
    row_chown.w[1]=owner[1] = gtk_combo_new();
    dl.user = GTK_WIDGET(GTK_COMBO(owner[1])->entry);
    gtk_combo_set_popdown_strings(GTK_COMBO(owner[1]), g_user);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(owner[1])->entry), buf);
    row_chown.w[0]=owner[0] = label_new(_("Owner :"), GTK_JUSTIFY_RIGHT);
    gtk_table_attach(GTK_TABLE(table), owner[0], 0+o, 1+o, 0, 1, 0, 0, X_PAD, Y_PAD);
    gtk_table_attach(GTK_TABLE(table), owner[1], 1+o, 2+o, 0, 1, 0, 0, X_PAD, 0);

    if(st && geteuid()){
	gchar *g=g_find_program_in_path("sudo");
	if (!g) gtk_widget_set_sensitive(owner[1], FALSE);
	g_free(g);
    }

    if (st) gr = getgrgid(st->st_gid);
    else gr = getgrgid(geteuid());
    sprintf(buf, "%s", gr ? gr->gr_name : _("unknown"));
    g_group=g_list_prepend(g_group,g_strdup(buf));
    row_chgrp.w[1]=owner[3] = gtk_combo_new();
    dl.group = GTK_WIDGET(GTK_COMBO(owner[3])->entry);
    gtk_combo_set_popdown_strings(GTK_COMBO(owner[3]), g_group);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(owner[3])->entry), buf);
    row_chgrp.w[0]=owner[2] = label_new(_("Group :"), GTK_JUSTIFY_RIGHT);
    gtk_table_attach(GTK_TABLE(table), owner[2], 0+o, 1+o, 1, 2, 0, 0, X_PAD, Y_PAD);
    gtk_table_attach(GTK_TABLE(table), owner[3], 1+o, 2+o, 1, 2, 0, 0, X_PAD, 0);

    if(st && geteuid()){
	gchar *g=g_find_program_in_path("sudo");
	if (!g) gtk_widget_set_sensitive(owner[3], FALSE);
	g_free(g);
    }
    if (!st){
	for (o=0;o<4;o++) gtk_widget_set_sensitive(owner[o], FALSE);
	g_signal_connect(G_OBJECT(perm[15]), "clicked", G_CALLBACK(on_off2), (gpointer) (&row_chown));
	g_signal_connect(G_OBJECT(perm[16]), "clicked", G_CALLBACK(on_off2), (gpointer) (&row_chgrp));	
    	gtk_table_attach(GTK_TABLE(table), perm[15], 0, 1, 0, 1, 0, 0, X_PAD, 0);
    	gtk_table_attach(GTK_TABLE(table), perm[16], 0, 1, 1, 2, 0, 0, X_PAD, 0);
    } 
	
/* for rpm files and only if rpm can be execd */
    if (st && en) {
	char *loc = NULL;
	loc = strrchr(path, '.');
	if((loc) && (strcmp(loc, ".rpm") == 0))
	{
	    sprintf(cmd, "rpm -qip \"%s\"", path);
	    pipe = popen(cmd, "r");
	    if(pipe)
	    {
		char *p;
		p = (char *)malloc(1);
		p[0] = 0;
		while(fgets(line, LINE_MAX - 1, pipe))
		{
		    line[LINE_MAX - 1] = 0;
		    p = (char *)realloc((void *)p, strlen(line) + strlen(p) + 1);
		    strcat(p, line);
		}
		if(strlen(p))
		{
		    label = gtk_label_new(_("RPM info"));
		    table = gtk_vbox_new(FALSE, 0);
		    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, label);
		    create_text(table, p);
		}
		pclose(pipe);
		if(p)
		    free(p);
	    }
	}
    }



    g_signal_connect(G_OBJECT(dl.top), "key_press_event", G_CALLBACK(on_key_press), (gpointer) cancel);
    gtk_window_set_position (GTK_WINDOW ( dl.top), GTK_WIN_POS_MOUSE);
    gtk_widget_realize(dl.top);
    
    gtk_widget_show_all(dl.top);
    
#ifdef RECURSIVE_BUTTON   
    if (!st)gtk_widget_hide(recursive_b);
    else if (en && !IS_DIR(en->type))gtk_widget_hide(recursive_b);
#endif

    gtk_main();

    /* free the lists */
    g_tmp = g_user;
    while(g_tmp)
    {
	g_free(g_tmp->data);
	g_tmp->data=NULL;
	g_tmp = g_tmp->next;
    }
    g_list_free(g_user); 
    g_tmp = g_group;
    while(g_tmp)
    {
	g_free(g_tmp->data);
	g_tmp->data=NULL;
	g_tmp = g_tmp->next;
    }
    g_list_free(g_group);
    return (dl.result);
}



