/*
 * Copyright 2006 The Apache Software Foundation.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.math.BigInteger;
import java.util.*;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.Security;
import javax.xml.crypto.dsig.keyinfo.*;
import javax.xml.crypto.*;
import javax.xml.crypto.dsig.*;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dom.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import junit.framework.*;

/**
 * Unit test for javax.xml.crypto.dsig.XMLSignatureFactory
 *
 * @version $Id$
 * @author Valerie Peng
 */
public class XMLSignatureFactoryTest extends TestCase {

    XMLSignatureFactory factory;

    static {
        Security.insertProviderAt
            (new org.jcp.xml.dsig.internal.dom.XMLDSigRI(), 1);
    }

    public XMLSignatureFactoryTest(String name) {
	super(name);
    }

    public void setUp() throws Exception { 
	factory = XMLSignatureFactory.getInstance
            ("DOM", new org.jcp.xml.dsig.internal.dom.XMLDSigRI());
    }

    public void tearDown() { }

    public void testgetInstance() {
	try {
	    XMLSignatureFactory fac = 
		XMLSignatureFactory.getInstance("non-existent");
	    fail("Should throw NoSuchMechanismException if no impl found");
	} catch (NoSuchMechanismException ex) {}

	try {
	    XMLSignatureFactory fac = XMLSignatureFactory.getInstance(null);
	    fail("Should raise a NPE for null mechanismType"); 
	} catch (NullPointerException npe) {}

	try {
	    XMLSignatureFactory fac = 
		XMLSignatureFactory.getInstance("DOM", "non-existent");
	    fail("Should throw NoSuchProviderException if specified " +
		 "provider is not found");
	} catch (NoSuchProviderException nspe) {
	} catch (NoSuchMechanismException nse) {
	    fail("Should raise a NoSuchProviderException instead of " + nse +
		 " if specified provider is not found"); 
	}

	try {
	    XMLSignatureFactory fac = XMLSignatureFactory.getInstance(null);
	    fail("Should raise a NPE for null mechanismType"); 
	} catch (NullPointerException npe) {}

	try {
	    XMLSignatureFactory fac = 
		XMLSignatureFactory.getInstance("DOM", (Provider) null);
	    fail("Should raise a NPE for null provider"); 
	} catch (NullPointerException npe) {}
    }

    public void testgetMechanismType() {
	assertNotNull(factory);
	assertEquals("DOM", factory.getMechanismType());
    }

    public void testisFeatureSupported() {
	try {
	    factory.isFeatureSupported(null); 
	    fail("Should raise a NPE for null feature"); 
	} catch (NullPointerException npe) {}

	assertTrue(!factory.isFeatureSupported("not supported"));
    }

    public void testgetKeyInfoFactory() throws Exception {
	KeyInfoFactory kifac = factory.getKeyInfoFactory();
	assertEquals(kifac.getMechanismType(), factory.getMechanismType());
	assertEquals(kifac.getProvider(), factory.getProvider());
    }

    public void testunmarshalXMLSignature() throws Exception {
	XMLSignature stuff;
	try {
	    stuff = factory.unmarshalXMLSignature((XMLValidateContext) null);
	    fail("Should raise an NPE for null inputs"); 
	} catch (NullPointerException ex) {
	} catch (Exception ex) {
	    fail("Should throw an NPE instead of " + ex +
		 " for null inputs");
	}

	try {
	    stuff = factory.unmarshalXMLSignature(
		new XMLValidateContext() {
		    public Object getProperty(String name) { return null; }
		    public Object setProperty(String name, Object property) {
			return null;
		    }
		    public String getBaseURI()	{ return null; }
		    public void setBaseURI(String uri)	{ return; }
		    public KeySelector getKeySelector() { return null; }
		    public void setKeySelector(KeySelector ks) { return; }
		    public URIDereferencer getURIDereferencer() { return null; }
		    public void setURIDereferencer(URIDereferencer ud) {return;}
		    public Object get(Object key) {return null;}
		    public Object put(Object key, Object value) {return null;}
                    public void setDefaultNamespacePrefix(String defPrefix) {}
                    public String getDefaultNamespacePrefix() {return null;}
                    public String putNamespacePrefix
                        (String nsURI, String prefix) {return null;}
                    public String getNamespacePrefix
                        (String nsURI, String defPrefix) {return null;}
		    });
	    fail("Should throw a CCE for input of wrong type"); 
	} catch (ClassCastException ex) {
	} catch (Exception ex) {
	    fail("Should raise a CCE instead of " + ex +
		 " for wrong inputs"); 
	}

        DocumentBuilderFactory docFactory =
            DocumentBuilderFactory.newInstance();
	docFactory.setNamespaceAware(true);
	DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
	String fs = System.getProperty("file.separator");
	File dir = new File(System.getProperty("basedir") + fs +
	    "data" + fs + "ie" + fs + "baltimore" + fs + "merlin-examples",
	    "merlin-xmldsig-twenty-three");
	Document doc = docBuilder.parse(new File(dir, "signature.xml"));
	NodeList nl = doc.getElementsByTagName("KeyInfo");
	try {
	    stuff = factory.unmarshalXMLSignature
	    (new DOMValidateContext(TestUtils.getPublicKey("RSA"), nl.item(0)));
	    fail("Should throw a MarshalException for non-XMLSignature inputs"); 
	} catch (MarshalException ex) {}
	
	nl = doc.getElementsByTagName("Signature");
	try {
	    stuff = factory.unmarshalXMLSignature
	    (new DOMValidateContext(TestUtils.getPublicKey("DSA"), nl.item(0)));
	    assertNotNull(stuff);
	} catch (MarshalException ex) {
	    fail("Unmarshal failed: " + ex.getMessage());
	    ex.printStackTrace();
	}
    }

    // for debugging purposes
    public static void main(String[] args) throws Exception {
	XMLSignatureFactoryTest test = 
	    new XMLSignatureFactoryTest("XMLSignatureFactoryTest");
	test.setUp();
	test.testunmarshalXMLSignature();
    }
}
