/*
 * Copyright 2002,2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.25
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* 
   SWIGTEMPLATEDISAMBIGUATOR is needed when wrapping template calls
   (cwrap.c:Swig_cfunction_call/Swig_cmethod_call), as in

     result = nspace::template function<int >(arg1);
     result = arg1->template method<int >(arg2);

    SWIGTEMPLATEDISAMBIGUATOR is compiler dependent (common.swg),
      - SUN Studio requires 'template', 
      - gcc-3.4 forbids the use of 'template'.
      - gcc-3.2.3 produces internal errors if you use 'template'
*/
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) 
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attritbute passed for some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* how we export a method such that it can go in to a shared or dll library */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(_MSC_VER) || defined(__GNUC__)
#     if defined(STATIC_LINKED)
#       define SWIGEXPORT(a) a
#     else
#       define SWIGEXPORT(a) __declspec(dllexport) a
#     endif
#   else
#     if defined(__BORLANDC__)
#       define SWIGEXPORT(a) a _export
#     else
#       define SWIGEXPORT(a) a
#     endif
#   endif
# else
#   define SWIGEXPORT(a) a
# endif
#endif

/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  if (!ti->clientdata) {
    swig_cast_info *cast = ti->cast;
    /* if (ti->clientdata == clientdata) return; */
    ti->clientdata = clientdata;
    
    while (cast) {
      if (!cast->converter)
	SWIG_TypeClientData(cast->type, clientdata);
      cast = cast->next;
    }
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* ---------------------------------------------------------------------- -*- c -*-
 * perl5.swg
 *
 * Perl5 runtime library
 * $Header: /cvsroot/swig/SWIG/Lib/perl5/perlrun.swg,v 1.21 2005/02/01 00:08:17 wuzzeb Exp $
 * ----------------------------------------------------------------------------- */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#ifndef pTHX_
#define pTHX_
#endif

#include <string.h>
#ifdef __cplusplus
}
#endif

/* Macro to call an XS function */

#ifdef PERL_OBJECT 
#  define SWIG_CALLXS(_name) _name(cv,pPerl) 
#else 
#  ifndef MULTIPLICITY 
#    define SWIG_CALLXS(_name) _name(cv) 
#  else 
#    define SWIG_CALLXS(_name) _name(PERL_GET_THX, cv) 
#  endif 
#endif 

/* Contract support */

#define SWIG_contract_assert(expr,msg) if (!(expr)) { SWIG_croak(msg); } else

/* Note: SwigMagicFuncHack is a typedef used to get the C++ compiler to just shut up already */

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
typedef int (CPerlObj::*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (CPerlObj::*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
#define SWIGCLASS_STATIC
#else
#define MAGIC_PPERL
#define SWIGCLASS_STATIC static
#ifndef MULTIPLICITY
#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif


#else
#define SWIG_MAGIC(a,b) (struct interpreter *interp, SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#endif
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#  ifndef PL_sv_yes
#    define PL_sv_yes sv_yes
#  endif
#  ifndef PL_sv_undef
#    define PL_sv_undef sv_undef
#  endif
#  ifndef PL_na
#    define PL_na na
#  endif
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_OWNER 1
#define SWIG_SHADOW 2

/* Common SWIG API */

#ifdef PERL_OBJECT
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(pPerl, obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(pPerl, p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(pPerl, sv, p, s, type)
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(pPerl, obj, p, s, type, flags)

#else
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(sv, p, s, type )
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(obj, p, s, type, flags)
#endif

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_Perl_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Perl_SetModule(pointer)

/* Perl-specific API */
#ifdef PERL_OBJECT
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(pPerl, sv, ptr, type, flags)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(pPerl, str)
#else
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(sv, ptr, type, flags)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(str)
#  define SWIG_SetErrorSV(str) \
     SWIG_Perl_SetErrorSV(str)
#endif

#define SWIG_SetErrorf SWIG_Perl_SetErrorf


#ifdef PERL_OBJECT
#  define SWIG_MAYBE_PERL_OBJECT CPerlObj *pPerl,
#else
#  define SWIG_MAYBE_PERL_OBJECT
#endif

static swig_cast_info *
SWIG_Perl_TypeCheckRV(SWIG_MAYBE_PERL_OBJECT SV *rv, swig_type_info *ty) {
  SWIG_TypeCheck_Template(sv_derived_from(rv, (char *) iter->type->name), ty);
}

/* Function for getting a pointer value */

static int
SWIG_Perl_ConvertPtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void **ptr, swig_type_info *_t, int flags) {
  swig_cast_info *tc;
  void *voidptr = (void *)0;
  int FAIL = -1;
  int SUCCEED = 0;
  
  
  /* If magical, apply more magic */
  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    IV tmp = 0;
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
        mg = mg_find(tsv,'P');
        if (mg) {
          sv = mg->mg_obj;
          if (sv_isobject(sv)) {
            tmp = SvIV((SV*)SvRV(sv));
          }
        }
      } else {
        return FAIL;
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    voidptr = (void *)tmp;
    if (!_t) {
      *(ptr) = voidptr;
      return SUCCEED;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return SUCCEED;
  } else if (SvTYPE(sv) == SVt_RV) {  /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv))
      return SUCCEED;
    else
      return FAIL;
  } else {                            /* Don't know what it is */
    *(ptr) = (void *) 0;
    return FAIL;
  }
  if (_t) {
    /* Now see if the types match */
    char *_c = HvNAME(SvSTASH(SvRV(sv)));
    tc = SWIG_TypeCheck(_c,_t);
    if (!tc) {
      *ptr = voidptr;
      return FAIL;
    }
    *ptr = SWIG_TypeCast(tc,voidptr);
    return SUCCEED;
  }
  *ptr = voidptr;
  return SUCCEED;
}

static void
SWIG_Perl_MakePtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, swig_type_info *t, int flags) {
  if (ptr && (flags & SWIG_SHADOW)) {
    SV *self;
    SV *obj=newSV(0);
    HV *hash=newHV();
    HV *stash;
    sv_setref_pv(obj, (char *) t->name, ptr);
    stash=SvSTASH(SvRV(obj));
    if (flags & SWIG_OWNER) {
      HV *hv;
      GV *gv=*(GV**)hv_fetch(stash, "OWNER", 5, TRUE);
      if (!isGV(gv))
        gv_init(gv, stash, "OWNER", 5, FALSE);
      hv=GvHVn(gv);
      hv_store_ent(hv, obj, newSViv(1), 0);
    }
    sv_magic((SV *)hash, (SV *)obj, 'P', Nullch, 0);
    SvREFCNT_dec(obj);
    self=newRV_noinc((SV *)hash);
    sv_setsv(sv, self);
    SvREFCNT_dec((SV *)self);
    sv_bless(sv, stash);
  }
  else {
    sv_setref_pv(sv, (char *) t->name, ptr);
  }
}

static SWIGINLINE SV *
SWIG_Perl_NewPointerObj(SWIG_MAYBE_PERL_OBJECT void *ptr, swig_type_info *t, int flags) {
  SV *result = sv_newmortal();
  SWIG_MakePtr(result, ptr, t, flags);
  return result;
}

static void
  SWIG_Perl_MakePackedObj(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  sv_setpv(sv, result);
}

/* Convert a packed value value */
static int
SWIG_Perl_ConvertPacked(SWIG_MAYBE_PERL_OBJECT SV *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char  *c = 0;

  if ((!obj) || (!SvOK(obj))) return -1;
  c = SvPV(obj, PL_na);
  /* Pointer values must start with leading underscore */
  if (*c != '_') return -1;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) return -1;
  }
  return 0;
}

static SWIGINLINE void
SWIG_Perl_SetError(SWIG_MAYBE_PERL_OBJECT const char *error) {
  if (error) sv_setpv(perl_get_sv("@", TRUE), error);
}

static SWIGINLINE void
SWIG_Perl_SetErrorSV(SWIG_MAYBE_PERL_OBJECT SV *error) {
  if (error) sv_setsv(perl_get_sv("@", TRUE), error);
}

static void
SWIG_Perl_SetErrorf(const char *fmt, ...) {
  va_list args;
  va_start(args, fmt);
  sv_vsetpvfn(perl_get_sv("@", TRUE), fmt, strlen(fmt), &args, Null(SV**), 0, Null(bool*));
  va_end(args);
}

static void
SWIG_Disown(SV *sv) {
  
  /* If magical, apply more magic */
    if (SvGMAGICAL(sv))
    {
        mg_get(sv);
            // fprintf(stderr,"Found initial magic\n");
    }
    

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
        mg = mg_find(tsv,'P');
        if (mg) {
          sv = mg->mg_obj;
          if (sv_isobject(sv)) {
              fprintf(stderr,"Found object for disown\n");

	      HV *stash;
	      stash=SvSTASH(SvRV(sv));

	      if (stash != 0)
              {
                  fprintf(stderr,"Found stash: %x\n",stash);
                  HV *hv;
                  GV *gv=*(GV**)hv_fetch(stash, "OWNER", 5, TRUE);
                  if (isGV(gv))
                  {
                      fprintf(stderr,"Found OWNER glob: %x\n",gv);
                      fprintf(stderr,"Found object: %x\n",sv);
                      fprintf(stderr,"Found ref object: %x\n",SvRV(sv));
                      hv=GvHVn(gv);

                      HE *entry;
                      char *key;
                      I32 klen;
                      SV *hval;
	    
                      (void)hv_iterinit(hv);
                      while ((entry = hv_iternext(hv)))  {
                          key = hv_iterkey(entry, &klen);
                          fprintf(stderr,"Found hash entry: %s\n",key);
                      }
            
		      if (hv_exists_ent(hv, sv, 0))
                      {
                          fprintf(stderr,"Found key in OWNER hash!\n");
                          if (hv_delete_ent(hv,sv,0,0))
                          {
                              fprintf(stderr,"Deleted key in OWNER hash!\n");
                          }
                          else 
                          {
                              SWIG_SetError("Couldn't delete key from OWNER hash :-<\n");
                          }
                      }
                      else
                      {
                          SWIG_SetError("no key in OWNER hash :-<\n");
                      }
                  }
                  else
                  {
                      SWIG_SetError("no GV\n");
                  }
              }
              else
              {
                  SWIG_SetError("no stash found\n");
              }
          } else {
              SWIG_SetError("SWIG_Disown: mg is not object");
          }
        } else {
            SWIG_SetError("SWIG_Disown: no mg");
        }
      } else {
          SWIG_SetError("SWIG_Disown: not magical");
      }
    } else {
      SWIG_SetError("SWIG_Disown: not PVHV");
    }
  } else {            /* not an object */
      SWIG_SetError("SWIG_Disown: not an object");
  }
}

/* Macros for low-level exception handling */
#define SWIG_fail       goto fail
#define SWIG_croak(x)   { SWIG_SetError(x); goto fail; }
#define SWIG_croakSV(x) { SWIG_SetErrorSV(x); goto fail; }
/* most preprocessors do not support vararg macros :-( */
/* #define SWIG_croakf(x...) { SWIG_SetErrorf(x); goto fail; } */


typedef XS(SwigPerlWrapper);
typedef SwigPerlWrapper *SwigPerlWrapperPtr;

/* Structure for command table */
typedef struct {
  const char         *name;
  SwigPerlWrapperPtr  wrapper;
} swig_command_info;

/* Information for constant table */

#define SWIG_INT     1
#define SWIG_FLOAT   2
#define SWIG_STRING  3
#define SWIG_POINTER 4
#define SWIG_BINARY  5

/* Constant information structure */
typedef struct swig_constant_info {
    int              type;
    const char      *name;
    long             lvalue;
    double           dvalue;
    void            *pvalue;
    swig_type_info **ptype;
} swig_constant_info;

#ifdef __cplusplus
}
#endif

/* Structure for variable table */
typedef struct {
  const char   *name;
  SwigMagicFunc   set;
  SwigMagicFunc   get;
  swig_type_info  **type;
} swig_variable_info;

/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
  #ifndef MULTIPLICITY
     static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int (*get)(SV *,MAGIC *)) {
  #else
     static void _swig_create_magic(SV *sv, char *name, int (*set)(struct interpreter*, SV *, MAGIC *), int (*get)(struct interpreter*, SV *,MAGIC *)) {
  #endif
#else
#  define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, const char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',(char *) name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = (SwigMagicFuncHack) get;
  mg->mg_virtual->svt_set = (SwigMagicFuncHack) set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}


static swig_module_info *
SWIG_Perl_GetModule() {
  static void *type_pointer = (void *)0;
  SV *pointer;

  /* first check if pointer already created */
  if (!type_pointer) {
    pointer = get_sv("swig_runtime_data::type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, FALSE);
    if (pointer && SvOK(pointer)) {
      type_pointer = INT2PTR(swig_type_info **, SvIV(pointer));
    }
  }

  return (swig_module_info *) type_pointer;
}

static void
SWIG_Perl_SetModule(swig_module_info *module) {
  SV *pointer;

  /* create a new pointer */
  pointer = get_sv("swig_runtime_data::type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, TRUE);
  sv_setiv(pointer, PTR2IV(module));
}

#ifdef do_open
  #undef do_open
#endif
#ifdef do_close
  #undef do_close
#endif
#ifdef scalar
  #undef scalar
#endif
#ifdef list
  #undef list
#endif
#ifdef apply
  #undef apply
#endif
#ifdef convert
  #undef convert
#endif
#ifdef Error
  #undef Error
#endif
#ifdef form
  #undef form
#endif
#ifdef vform
  #undef vform
#endif
#ifdef LABEL
  #undef LABEL
#endif
#ifdef METHOD
  #undef METHOD
#endif
#ifdef Move
  #undef Move
#endif
#ifdef yylex
  #undef yylex
#endif
#ifdef yyparse
  #undef yyparse
#endif
#ifdef yyerror
  #undef yyerror
#endif
#ifdef invert
  #undef invert
#endif
#ifdef ref
  #undef ref
#endif
#if 0
#ifdef ENTER
  #undef ENTER
#endif
#endif
#ifdef read
  #undef read
#endif
#ifdef write
  #undef write
#endif
#ifdef eof
  #undef eof
#endif


SWIGRUNTIMEINLINE void
SWIG_Perl_NullRef(const char *type, int argnum, const char *symname)
{
  if (type) {
    SWIG_Perl_SetErrorf("null reference of type: '%s' was received as argumnent: %d of %s",type,argnum,symname);
  } else {
    SWIG_Perl_SetErrorf("null reference was received");
  }
}

SWIGRUNTIME void
SWIG_Perl_TypeError(const char *type, int argnum, const char *symname)
{
  if (type) {
    SWIG_Perl_SetErrorf("Type error in argument %d of %s. Expected %s", argnum, symname, type);
  } else {
    SWIG_Perl_SetErrorf("Type error in argument $argnum of $symname", argnum, symname);
  }
}


/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_DatatypeValidatorFactory swig_types[0]
#define SWIGTYPE_p_IdentityConstraint swig_types[1]
#define SWIGTYPE_p_PSVIAttributeList swig_types[2]
#define SWIGTYPE_p_PSVIDefs__Complexity swig_types[3]
#define SWIGTYPE_p_PSVIDefs__PSVIScope swig_types[4]
#define SWIGTYPE_p_PSVIDefs__Validation swig_types[5]
#define SWIGTYPE_p_PSVIDefs__Validity swig_types[6]
#define SWIGTYPE_p_PSVIElement swig_types[7]
#define SWIGTYPE_p_PanicHandler__PanicReasons swig_types[8]
#define SWIGTYPE_p_PerlCallbackHandler swig_types[9]
#define SWIGTYPE_p_PerlContentCallbackHandler swig_types[10]
#define SWIGTYPE_p_PerlDocumentCallbackHandler swig_types[11]
#define SWIGTYPE_p_PerlEntityResolverHandler swig_types[12]
#define SWIGTYPE_p_PerlErrorCallbackHandler swig_types[13]
#define SWIGTYPE_p_PerlNodeFilterCallbackHandler swig_types[14]
#define SWIGTYPE_p_RefArrayVectorOfTunsigned_short_t swig_types[15]
#define SWIGTYPE_p_RefHash2KeysTableOfTValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t_t swig_types[16]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__ComplexTypeInfo_t swig_types[17]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XMLAttDef_t swig_types[18]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XSAnnotation_t swig_types[19]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesAttGroupInfo_t swig_types[20]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesGroupInfo_t swig_types[21]
#define SWIGTYPE_p_RefHashTableOfTXMLRefInfo_t swig_types[22]
#define SWIGTYPE_p_SV swig_types[23]
#define SWIGTYPE_p_SecurityManager swig_types[24]
#define SWIGTYPE_p_ValidationContext swig_types[25]
#define SWIGTYPE_p_ValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t swig_types[26]
#define SWIGTYPE_p_ValueVectorOfTunsigned_int_t swig_types[27]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__AbstractDOMParser swig_types[28]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__AttributeList swig_types[29]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Attributes swig_types[30]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream swig_types[31]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo swig_types[32]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentHandler swig_types[33]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode swig_types[34]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr swig_types[35]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMBuilder swig_types[36]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMBuilderFilter swig_types[37]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCDATASection swig_types[38]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCharacterData swig_types[39]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMComment swig_types[40]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMConfiguration swig_types[41]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocument swig_types[42]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentFragment swig_types[43]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentRange swig_types[44]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentTraversal swig_types[45]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentType swig_types[46]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement swig_types[47]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntity swig_types[48]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntityReference swig_types[49]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntityResolver swig_types[50]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMError swig_types[51]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMErrorHandler swig_types[52]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException swig_types[53]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMImplementation swig_types[54]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMImplementationLS swig_types[55]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMImplementationRegistry swig_types[56]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMImplementationSource swig_types[57]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMInputSource swig_types[58]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMLocator swig_types[59]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNamedNodeMap swig_types[60]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode swig_types[61]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeFilter swig_types[62]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeIterator swig_types[63]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeList swig_types[64]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNotation swig_types[65]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMProcessingInstruction swig_types[66]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMRange swig_types[67]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMRangeException swig_types[68]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMText swig_types[69]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMTreeWalker swig_types[70]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMTypeInfo swig_types[71]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMUserDataHandler swig_types[72]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMWriter swig_types[73]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMWriterFilter swig_types[74]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef swig_types[75]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList swig_types[76]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl swig_types[77]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl swig_types[78]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar swig_types[79]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDHandler swig_types[80]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator swig_types[81]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator swig_types[82]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DeclHandler swig_types[83]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DefaultHandler swig_types[84]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DocumentHandler swig_types[85]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__EntityResolver swig_types[86]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__ErrorHandler swig_types[87]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar swig_types[88]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__GrammarResolver swig_types[89]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__HandlerBase swig_types[90]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource swig_types[91]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__LexicalHandler swig_types[92]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileFormatTarget swig_types[93]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource swig_types[94]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Locator swig_types[95]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufFormatTarget swig_types[96]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource swig_types[97]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager swig_types[98]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t swig_types[99]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t swig_types[100]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__XMLNotationDecl_t swig_types[101]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t swig_types[102]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t swig_types[103]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NamespaceScope swig_types[104]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__PSVIHandler swig_types[105]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Parser swig_types[106]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName swig_types[107]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t swig_types[108]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t swig_types[109]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAX2XMLReader swig_types[110]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXException swig_types[111]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXNotRecognizedException swig_types[112]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXNotSupportedException swig_types[113]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXParseException swig_types[114]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXParser swig_types[115]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef swig_types[116]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList swig_types[117]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl swig_types[118]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar swig_types[119]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator swig_types[120]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdInInputSource swig_types[121]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdOutFormatTarget swig_types[122]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource swig_types[123]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Wrapper4DOMInputSource swig_types[124]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Wrapper4InputSource swig_types[125]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef swig_types[126]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList swig_types[127]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel swig_types[128]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription swig_types[129]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDeleter swig_types[130]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDocumentHandler swig_types[131]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl swig_types[132]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl swig_types[133]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityResolver swig_types[134]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t swig_types[135]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t swig_types[136]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t swig_types[137]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException swig_types[138]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLExcepts swig_types[139]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLFormatTarget swig_types[140]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLFormatter swig_types[141]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription swig_types[142]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarPool swig_types[143]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl swig_types[144]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLPScanToken swig_types[145]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLPlatformUtils swig_types[146]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLReaderFactory swig_types[147]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription swig_types[148]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL swig_types[149]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUni swig_types[150]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri swig_types[151]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLValidator swig_types[152]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMemory swig_types[153]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysTableBucketElemTXERCES_CPP_NAMESPACE__SchemaElementDecl_t swig_types[154]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation swig_types[155]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XercesDOMParser swig_types[156]
#define SWIGTYPE_p_XMLBuffer swig_types[157]
#define SWIGTYPE_p_XMLErrorReporter swig_types[158]
#define SWIGTYPE_p_XMLErrorReporter__ErrTypes swig_types[159]
#define SWIGTYPE_p_XSerializeEngine swig_types[160]
#define SWIGTYPE_p_a_32__unsigned_short swig_types[161]
#define SWIGTYPE_p_bool swig_types[162]
#define SWIGTYPE_p_int swig_types[163]
#define SWIGTYPE_p_long swig_types[164]
#define SWIGTYPE_p_p_void swig_types[165]
#define SWIGTYPE_p_size_t swig_types[166]
#define SWIGTYPE_p_unsigned_char swig_types[167]
#define SWIGTYPE_p_unsigned_int swig_types[168]
#define SWIGTYPE_p_unsigned_long swig_types[169]
#define SWIGTYPE_p_unsigned_short swig_types[170]
#define SWIGTYPE_p_void swig_types[171]
static swig_type_info *swig_types[172];
static swig_module_info swig_module = {swig_types, 172, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    boot_XML__Xerces

#define SWIG_name   "XML::Xercesc::boot_XML__Xerces"
#define SWIG_prefix "XML::Xercesc::"

#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
#ifndef MULTIPLICITY
SWIGEXPORT(void) SWIG_init (CV* cv);
#else
SWIGEXPORT(void) SWIG_init (pTHXo_ CV* cv);
#endif
#else
SWIGEXPORT(void) SWIG_init (CV *cv, CPerlObj *);
#endif


#include "xercesc/sax/InputSource.hpp"
#include "xercesc/sax/SAXException.hpp"
#include "xercesc/sax/SAXParseException.hpp"
#include "xercesc/sax/Locator.hpp"
#include "xercesc/sax/HandlerBase.hpp"
#include "xercesc/sax2/Attributes.hpp"
#include "xercesc/sax2/ContentHandler.hpp"
#include "xercesc/sax2/LexicalHandler.hpp"
#include "xercesc/sax2/DefaultHandler.hpp"
#include "xercesc/sax2/SAX2XMLReader.hpp"
#include "xercesc/sax2/XMLReaderFactory.hpp"
#include "xercesc/util/PlatformUtils.hpp"
#include "xercesc/util/TransService.hpp"
#include "xercesc/util/XMLString.hpp"
#include "xercesc/util/XMLUri.hpp"
#include "xercesc/util/QName.hpp"
#include "xercesc/util/HexBin.hpp"
#include "xercesc/util/Base64.hpp"
#include "xercesc/parsers/AbstractDOMParser.hpp"
#include "xercesc/parsers/XercesDOMParser.hpp"
#include "xercesc/parsers/SAXParser.hpp"
#include "xercesc/dom/DOM.hpp"
#include "xercesc/framework/LocalFileInputSource.hpp"
#include "xercesc/framework/MemBufInputSource.hpp"
#include "xercesc/framework/StdInInputSource.hpp"
#include "xercesc/framework/URLInputSource.hpp"
#include "xercesc/framework/XMLGrammarDescription.hpp"
#include "xercesc/framework/XMLDTDDescription.hpp"
#include "xercesc/framework/XMLSchemaDescription.hpp"
#include "xercesc/util/NameIdPool.hpp"
#include "xercesc/util/XMLEnumerator.hpp"
#include "xercesc/framework/XMLValidator.hpp"
#include "xercesc/validators/common/Grammar.hpp"
#include "xercesc/validators/DTD/DTDAttDef.hpp"
#include "xercesc/validators/DTD/DTDAttDefList.hpp"
#include "xercesc/validators/DTD/DTDGrammar.hpp"
#include "xercesc/validators/DTD/DTDValidator.hpp"
#include "xercesc/validators/schema/SchemaGrammar.hpp"
#include "xercesc/validators/schema/SchemaValidator.hpp"
#include "xercesc/validators/schema/SchemaAttDefList.hpp"
#include "xercesc/validators/schema/SchemaAttDef.hpp"
#include "xercesc/framework/XMLFormatter.hpp"
#include "xercesc/framework/MemBufFormatTarget.hpp"
#include "xercesc/framework/LocalFileFormatTarget.hpp"
#include "xercesc/framework/StdOutFormatTarget.hpp"
#include "xercesc/framework/Wrapper4InputSource.hpp"
#include "xercesc/framework/Wrapper4DOMInputSource.hpp"
#include "xercesc/framework/psvi/PSVIHandler.hpp"

// for resolving XMLExceptions
#include "xercesc/util/ArrayIndexOutOfBoundsException.hpp"
#include "xercesc/util/EmptyStackException.hpp"
#include "xercesc/util/IllegalArgumentException.hpp"
#include "xercesc/util/InvalidCastException.hpp"
#include "xercesc/util/IOException.hpp"
#include "xercesc/util/NoSuchElementException.hpp"
#include "xercesc/util/NullPointerException.hpp"
#include "xercesc/util/NumberFormatException.hpp"
#include "xercesc/util/ParseException.hpp"
#include "xercesc/util/RuntimeException.hpp"
#include "xercesc/util/SchemaDateTimeException.hpp"
#include "xercesc/util/TranscodingException.hpp"
#include "xercesc/util/UnexpectedEOFException.hpp"
#include "xercesc/util/UnsupportedEncodingException.hpp"
#include "xercesc/util/UTFDataFormatException.hpp"
#include "xercesc/util/XMLNetAccessor.hpp"
#include "xercesc/internal/XSerializationException.hpp"
#include "xercesc/validators/datatype/InvalidDatatypeFacetException.hpp"
#include "xercesc/validators/datatype/InvalidDatatypeValueException.hpp"
#include "xercesc/validators/schema/identity/XPathException.hpp"

#include "PerlCallbackHandler.hpp"
#include "PerlErrorCallbackHandler.hpp"
#include "PerlDocumentCallbackHandler.hpp"
#include "PerlContentCallbackHandler.hpp"
#include "PerlEntityResolverHandler.i"
#include "PerlNodeFilterCallbackHandler.i"

XERCES_CPP_NAMESPACE_USE

// we initialize the static UTF-8 transcoding info
// these are used by the typemaps to convert between
// Xerces internal UTF-16 and Perl's internal UTF-8
static XMLCh* UTF8_ENCODING = NULL; 
static XMLTranscoder* UTF8_TRANSCODER  = NULL;

static bool DEBUG_UTF8_OUT = 0;
static bool DEBUG_UTF8_IN = 0;

SV*
XMLString2Perl(const XMLCh* input) {
    SV *output;
  unsigned int charsEaten = 0;
  int length  = XMLString::stringLen(input);            // string length
  // use +1 to make room for the '\0' at the end of the string
  // in the pathological case when each character of the string 
  // is UTF8_MAXLEN bytes long
  XMLByte* res = new XMLByte[(length * UTF8_MAXLEN) + 1]; // output string

  unsigned int total_chars =
    UTF8_TRANSCODER->transcodeTo((const XMLCh*) input, 
				   (unsigned int) length,
				   (XMLByte*) res,
				   (unsigned int) (length*UTF8_MAXLEN),
				   charsEaten,
				   XMLTranscoder::UnRep_Throw
				   );
  res[total_chars] = '\0';

#if (0) 
  if (DEBUG_UTF8_OUT) {
      printf("Xerces out length = %d: ",total_chars);
      for (int i=0;i<length;i++){
	  printf("<0x%.4X>",res[i]);
      }
      printf("\n");
  }
#endif

  output = sv_newmortal();
  sv_setpv((SV*)output, (char *)res );
  SvUTF8_on((SV*)output);
  delete[] res;
  return output;
}

XMLCh* 
Perl2XMLString(SV* input){
    XMLCh* output;

    STRLEN length;
    char *ptr = (char *)SvPVutf8(input,length);

#if (0) 
    if (DEBUG_UTF8_IN) {
	printf("Perl in length = %d: ",length);
	for (unsigned int i=0;i<length;i++){
	    printf("<0x%.4X>",ptr[i]);
	}
	printf("\n");
    }
#endif

    if (SvUTF8(input)) {
	unsigned int charsEaten = 0;
        unsigned char* sizes = new unsigned char[length+1];
        output = new XMLCh[length+1];
	unsigned int chars_stored = 
	    UTF8_TRANSCODER->transcodeFrom((const XMLByte*) ptr,
					   (unsigned int) length,
					   (XMLCh*) output, 
					   (unsigned int) length,
					   charsEaten,
					   (unsigned char*)sizes
					   );
	delete [] sizes;

#if (0) 
	if (DEBUG_UTF8_IN) {
	    printf("Xerces in length = %d: ",chars_stored);
	    for (unsigned int i=0;i<chars_stored;i++){
		printf("<0x%.4X>",output[i]);
	    }
	    printf("\n");
	}
#endif

	// indicate the end of the string
	output[chars_stored] = '\0';
    } else {
	output = XMLString::transcode(ptr);

#if (0) 
	if (DEBUG_UTF8_IN) {
	    printf("Xerces: ");
	    for (int i=0;output[i];i++){
		printf("<0x%.4X>",output[i]);
	    }
	    printf("\n");
	}
#endif

    }
    return(output);
}

XMLException*
copyXMLException(const XMLException& e)
{
    if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgArrayIndexOutOfBoundsException_Name)
    {
        return (XMLException*)((ArrayIndexOutOfBoundsException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgEmptyStackException_Name)
    {
        return (XMLException*)((EmptyStackException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgIllegalArgumentException_Name)
    {
        return (XMLException*)((IllegalArgumentException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgInvalidCastException_Name)
    {
        return (XMLException*)((InvalidCastException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgIOException_Name)
    {
        return (XMLException*)((IOException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgNoSuchElementException_Name)
    {
        return (XMLException*)((NoSuchElementException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgNullPointerException_Name)
    {
        return (XMLException*)((NullPointerException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgNumberFormatException_Name)
    {
        return (XMLException*)((NumberFormatException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgParseException_Name)
    {
        return (XMLException*)((ParseException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgXMLPlatformUtilsException_Name)
    {
        return (XMLException*)((XMLPlatformUtilsException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgRuntimeException_Name)
    {
        return (XMLException*)((RuntimeException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgSchemaDateTimeException_Name)
    {
        return (XMLException*)((SchemaDateTimeException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgTranscodingException_Name)
    {
        return (XMLException*)((TranscodingException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgUnexpectedEOFException_Name)
    {
        return (XMLException*)((UnexpectedEOFException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgUnsupportedEncodingException_Name)
    {
        return (XMLException*)((UnsupportedEncodingException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgUTFDataFormatException_Name)
    {
        return (XMLException*)((UTFDataFormatException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgNetAccessorException_Name)
    {
        return (XMLException*)((NetAccessorException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgMalformedURLException_Name)
    {
        return (XMLException*)((MalformedURLException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgXSerializationException_Name)
    {
        return (XMLException*)((XSerializationException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgInvalidDatatypeFacetException_Name)
    {
        return (XMLException*)((InvalidDatatypeFacetException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgInvalidDatatypeValueException_Name)
    {
        return (XMLException*)((InvalidDatatypeValueException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgXPathException_Name)
    {
        return (XMLException*)((XPathException*)&e)->duplicate();
    }
}

// These exception creation methods make the Xerces.cpp code *much* smaller
void
makeXMLException(const XMLException& e){
    SV *error = ERRSV;
    SWIG_MakePtr(error, (void *) copyXMLException(e), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, SWIG_SHADOW|0);
}

void
makeDOMException(const DOMException& e){
    SV *error = ERRSV;
    SWIG_MakePtr(error, (void *) new DOMException(e), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException, SWIG_SHADOW|0);
}

void
makeSAXNotRecognizedException(const SAXNotRecognizedException& e){
    SV *error = ERRSV;
    SWIG_MakePtr(error, (void *) new SAXNotRecognizedException(e), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXNotRecognizedException, SWIG_SHADOW|0);
}

void
makeSAXNotSupportedException(const SAXNotSupportedException& e){
    SV *error = ERRSV;
    SWIG_MakePtr(error, (void *) new SAXNotSupportedException(e), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXNotSupportedException, SWIG_SHADOW|0);
}



static swig_type_info *
Grammar_dynamic_cast(void **ptr) {
   Grammar **nptr = (Grammar **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->getGrammarType();
   if (type == Grammar::DTDGrammarType) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar;
   }
   if (type == Grammar::SchemaGrammarType) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar;
   }
   return NULL;
}


static swig_type_info *
PerlCallbackHandler_dynamic_cast(void **ptr) {
   PerlCallbackHandler **nptr = (PerlCallbackHandler **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->type();
   if (type == PERLCALLBACKHANDLER_BASE_TYPE) {
      die("Can't cast a PerlCallbackHandler base type node\n");
   }
   if (type == PERLCALLBACKHANDLER_ERROR_TYPE) {
      return SWIGTYPE_p_PerlErrorCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_ENTITY_TYPE) {
      return SWIGTYPE_p_PerlEntityResolverHandler;
   }
   if (type == PERLCALLBACKHANDLER_CONTENT_TYPE) {
      return SWIGTYPE_p_PerlContentCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_DOCUMENT_TYPE) {
      return SWIGTYPE_p_PerlDocumentCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_NODE_TYPE) {
      return SWIGTYPE_p_PerlNodeFilterCallbackHandler;
   }
   return NULL;
}


static swig_type_info *
DOMNode_dynamic_cast(void **ptr) {
   DOMNode **nptr = (DOMNode **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->getNodeType();
   if (type == DOMNode::TEXT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMText;
   }
   if (type == DOMNode::PROCESSING_INSTRUCTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMProcessingInstruction;
   }
   if (type == DOMNode::DOCUMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocument;
   }
   if (type == DOMNode::ELEMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement;
   }
   if (type == DOMNode::ENTITY_REFERENCE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntityReference;
   }
   if (type == DOMNode::CDATA_SECTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCDATASection;
   }
   if (type == DOMNode::CDATA_SECTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCDATASection;
   }
   if (type == DOMNode::COMMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMComment;
   }
   if (type == DOMNode::DOCUMENT_TYPE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentType;
   }
   if (type == DOMNode::ENTITY_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntity;
   }
   if (type == DOMNode::ATTRIBUTE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr;
   }
   if (type == DOMNode::NOTATION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNotation;
   }
   return NULL;
}

static bool XERCES_CPP_NAMESPACE_DOMNode_operator_Se__Se_(XERCES_CPP_NAMESPACE::DOMNode *self,XERCES_CPP_NAMESPACE::DOMNode const *other){
       return self->isSameNode(other);
   }
static bool XERCES_CPP_NAMESPACE_DOMNode_operator_SN__Se_(XERCES_CPP_NAMESPACE::DOMNode *self,XERCES_CPP_NAMESPACE::DOMNode const *other){
       return !self->isSameNode(other);
   }
#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_XML::Xerces_var::
class _wrap_XML::Xerces_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}
SWIGCLASS_STATIC int _wrap_set_DEBUG_UTF8_OUT(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    DEBUG_UTF8_OUT = (bool) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_DEBUG_UTF8_OUT(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) DEBUG_UTF8_OUT);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_DEBUG_UTF8_IN(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    DEBUG_UTF8_IN = (bool) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_DEBUG_UTF8_IN(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) DEBUG_UTF8_IN);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgAnyString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgAnyString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgAttListString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgAttListString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgCommentString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgCommentString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgCDATAString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgCDATAString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDefaultString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDefaultString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDocTypeString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDocTypeString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEBCDICEncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEBCDICEncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgElemString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgElemString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEmptyString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEmptyString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEntitString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEntitString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEntityString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEntityString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEntitiesString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEntitiesString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEnumerationString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEnumerationString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgExceptDomain(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgExceptDomain));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgFixedString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgFixedString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIBM037EncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM037EncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIBM037EncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM037EncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIBM1047EncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1047EncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIBM1047EncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1047EncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIBM1140EncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1140EncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIBM1140EncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1140EncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIBM1140EncodingString3(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1140EncodingString3));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIBM1140EncodingString4(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1140EncodingString4));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIESString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIESString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIDString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIDString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIDRefString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIDRefString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIDRefsString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIDRefsString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgImpliedString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgImpliedString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIgnoreString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIgnoreString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIncludeString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIncludeString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString3(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString3));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString4(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString4));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString5(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString5));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString6(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString6));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString7(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString7));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString8(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString8));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString9(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString9));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString10(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString10));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString11(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString11));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgISO88591EncodingString12(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString12));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgLocalHostString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLocalHostString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNoString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNoString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNotationString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNotationString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNDATAString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNDATAString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNmTokenString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNmTokenString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNmTokensString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNmTokensString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgPCDATAString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPCDATAString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgPIString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPIString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgPubIDString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPubIDString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgRefString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgRefString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgRequiredString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgRequiredString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgStandaloneString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgStandaloneString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgVersion1_0(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgVersion1_0));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgVersion1_1(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgVersion1_1));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgSysIDString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSysIDString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUnknownURIName(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUnknownURIName));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUCS4EncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4EncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUCS4EncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4EncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUCS4EncodingString3(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4EncodingString3));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUCS4BEncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4BEncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUCS4BEncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4BEncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUCS4LEncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4LEncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUCS4LEncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4LEncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUSASCIIEncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUSASCIIEncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUSASCIIEncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUSASCIIEncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUSASCIIEncodingString3(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUSASCIIEncodingString3));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUSASCIIEncodingString4(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUSASCIIEncodingString4));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF8EncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF8EncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF8EncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF8EncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16EncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16EncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16EncodingString3(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString3));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16EncodingString4(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString4));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16EncodingString5(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString5));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16BEncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16BEncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16BEncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16BEncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16LEncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16LEncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTF16LEncodingString2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16LEncodingString2));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgVersionString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgVersionString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgValidityDomain(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgValidityDomain));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgWin1252EncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgWin1252EncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLChEncodingString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLChEncodingString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDOMMsgDomain(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDOMMsgDomain));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLStringSpace(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringSpace));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLStringHTab(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringHTab));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLStringCR(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringCR));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLStringLF(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringLF));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLStringSpaceU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringSpaceU));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLStringHTabU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringHTabU));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLStringCRU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringCRU));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLStringLFU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringLFU));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclStringSpace(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringSpace));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclStringHTab(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringHTab));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclStringLF(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringLF));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclStringCR(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringCR));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclStringSpaceU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringSpaceU));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclStringHTabU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringHTabU));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclStringLFU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringLFU));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLDeclStringCRU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringCRU));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLNSString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLNSString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLNSColonString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLNSColonString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLNSURIName(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLNSURIName));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLErrDomain(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLErrDomain));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLURIName(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLURIName));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgInfosetURIName(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgInfosetURIName));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgYesString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgYesString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgZeroLenString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgZeroLenString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDTDEntityString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDTDEntityString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgAmp(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgAmp));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgLT(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLT));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgGT(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgGT));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgQuot(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgQuot));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgApos(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgApos));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgWFXMLScanner(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgWFXMLScanner));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIGXMLScanner(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIGXMLScanner));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgSGXMLScanner(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSGXMLScanner));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDGXMLScanner(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDGXMLScanner));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXSAXMLScanner(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXSAXMLScanner));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgCDataStart(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgCDataStart));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgCDataEnd(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgCDataEnd));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgArrayIndexOutOfBoundsException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgArrayIndexOutOfBoundsException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEmptyStackException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEmptyStackException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIllegalArgumentException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIllegalArgumentException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgInvalidCastException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgInvalidCastException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIOException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIOException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNoSuchElementException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNoSuchElementException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNullPointerException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNullPointerException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXMLPlatformUtilsException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLPlatformUtilsException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgRuntimeException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgRuntimeException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgTranscodingException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgTranscodingException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUnexpectedEOFException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUnexpectedEOFException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUnsupportedEncodingException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUnsupportedEncodingException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUTFDataFormatException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTFDataFormatException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNetAccessorException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNetAccessorException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgMalformedURLException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgMalformedURLException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNumberFormatException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNumberFormatException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgParseException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgParseException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgInvalidDatatypeFacetException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgInvalidDatatypeFacetException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgInvalidDatatypeValueException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgInvalidDatatypeValueException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgSchemaDateTimeException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSchemaDateTimeException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXPathException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXPathException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXSerializationException_Name(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXSerializationException_Name));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNegINFString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNegINFString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNegZeroString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNegZeroString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgPosZeroString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPosZeroString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgPosINFString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPosINFString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNaNString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNaNString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgEString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgZeroString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgZeroString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNullString(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNullString));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesDynamic(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesDynamic));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesSchema(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSchema));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesSchemaFullChecking(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSchemaFullChecking));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesIdentityConstraintChecking(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesIdentityConstraintChecking));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesSchemaExternalSchemaLocation(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSchemaExternalSchemaLocation));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesSchemaExternalNoNameSpaceSchemaLocation(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSchemaExternalNoNameSpaceSchemaLocation));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesSecurityManager(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSecurityManager));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesLoadExternalDTD(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesLoadExternalDTD));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesContinueAfterFatalError(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesContinueAfterFatalError));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesValidationErrorAsFatal(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesValidationErrorAsFatal));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesUserAdoptsDOMDocument(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesUserAdoptsDOMDocument));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesCacheGrammarFromParse(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesCacheGrammarFromParse));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesUseCachedGrammarInParse(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesUseCachedGrammarInParse));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesScannerName(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesScannerName));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesParserUseDocumentFromImplementation(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesParserUseDocumentFromImplementation));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesCalculateSrcOfs(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesCalculateSrcOfs));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesStandardUriConformant(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesStandardUriConformant));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesDOMHasPSVIInfo(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesDOMHasPSVIInfo));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesGenerateSyntheticAnnotations(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesGenerateSyntheticAnnotations));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercesValidateAnnotations(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesValidateAnnotations));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgSAX2CoreValidation(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSAX2CoreValidation));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgSAX2CoreNameSpaces(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSAX2CoreNameSpaces));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgSAX2CoreNameSpacePrefixes(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSAX2CoreNameSpacePrefixes));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMCanonicalForm(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMCanonicalForm));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMCDATASections(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMCDATASections));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMComments(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMComments));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMCharsetOverridesXMLEncoding(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMCharsetOverridesXMLEncoding));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMDatatypeNormalization(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMDatatypeNormalization));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMEntities(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMEntities));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMInfoset(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMInfoset));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMNamespaces(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMNamespaces));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMNamespaceDeclarations(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMNamespaceDeclarations));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMSupportedMediatypesOnly(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMSupportedMediatypesOnly));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMValidateIfSchema(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMValidateIfSchema));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMValidation(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMValidation));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWhitespaceInElementContent(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWhitespaceInElementContent));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTCanonicalForm(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTCanonicalForm));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTDiscardDefaultContent(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTDiscardDefaultContent));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTEntities(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTEntities));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTFormatPrettyPrint(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTFormatPrettyPrint));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTNormalizeCharacters(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTNormalizeCharacters));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTSplitCdataSections(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTSplitCdataSections));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTValidation(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTValidation));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTWhitespaceInElementContent(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTWhitespaceInElementContent));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMWRTBOM(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTBOM));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDOMXMLDeclaration(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMXMLDeclaration));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercescInterfacePSVITypeInfo(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercescInterfacePSVITypeInfo));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgXercescDefaultLocale(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (XERCES_CPP_NAMESPACE::XMLUni::fgXercescDefaultLocale) {
        sv_setpv((SV*)sv, (char *) XERCES_CPP_NAMESPACE::XMLUni::fgXercescDefaultLocale);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgDefErrMsg(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDefErrMsg));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgValueZero(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgValueZero));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgNegOne(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNegOne));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgValueOne(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgValueOne));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgLongMaxInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLongMaxInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgLongMinInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLongMinInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIntMaxInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIntMaxInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgIntMinInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIntMinInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgShortMaxInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgShortMaxInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgShortMinInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgShortMinInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgByteMaxInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgByteMaxInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgByteMinInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgByteMinInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgULongMaxInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgULongMaxInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUIntMaxInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUIntMaxInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUShortMaxInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUShortMaxInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgUByteMaxInc(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUByteMaxInc));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgLangPattern(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLangPattern));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgBooleanValueSpace(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) XERCES_CPP_NAMESPACE::XMLUni::fgBooleanValueSpace);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLUni_fgBooleanValueSpaceArraySize(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) XERCES_CPP_NAMESPACE::XMLUni::fgBooleanValueSpaceArraySize);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLElementDecl_fgInvalidElemId(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) XERCES_CPP_NAMESPACE::XMLElementDecl::fgInvalidElemId);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLElementDecl_fgPCDataElemId(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) XERCES_CPP_NAMESPACE::XMLElementDecl::fgPCDataElemId);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLElementDecl_fgPCDataElemName(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    
    sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLElementDecl::fgPCDataElemName));
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_XMLAttDef_fgInvalidAttrId(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) XERCES_CPP_NAMESPACE::XMLAttDef::fgInvalidAttrId);
    return 1;
}




#ifdef PERL_OBJECT
};
#endif

#ifdef __cplusplus
extern "C" {
#endif
XS(_wrap_delete_XMLDeleter) {
    {
        XERCES_CPP_NAMESPACE::XMLDeleter *arg1 = (XERCES_CPP_NAMESPACE::XMLDeleter *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLDeleter(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDeleter,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLDeleter",1,"delete_XMLDeleter"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLPlatformUtils_Initialize__SWIG_0) {
    {
        char *arg1 = (char *) (char *)0 ;
        char *arg2 = (char *) (char *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLPlatformUtils_Initialize(locale,nlsHome);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLPlatformUtils::Initialize((char const *)arg1,(char const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLPlatformUtils_Initialize__SWIG_1) {
    {
        char *arg1 = (char *) (char *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLPlatformUtils_Initialize(locale);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLPlatformUtils::Initialize((char const *)arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLPlatformUtils_Initialize__SWIG_2) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: XMLPlatformUtils_Initialize();");
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLPlatformUtils::Initialize();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLPlatformUtils_Initialize) {
    dXSARGS;
    
    if (items == 0) {
        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLPlatformUtils_Initialize__SWIG_2); return;
    }
    if (items == 1) {
        int _v;
        {
            _v = SvPOK(ST(0)) ? 1 : 0;
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLPlatformUtils_Initialize__SWIG_1); return;
        }
    }
    if (items == 2) {
        int _v;
        {
            _v = SvPOK(ST(0)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = SvPOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLPlatformUtils_Initialize__SWIG_0); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'XMLPlatformUtils_Initialize'");
    XSRETURN(0);
}


XS(_wrap_XMLPlatformUtils_Terminate) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: XMLPlatformUtils_Terminate();");
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLPlatformUtils::Terminate();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLPlatformUtils_panic) {
    {
        PanicHandler::PanicReasons arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLPlatformUtils_panic(reason);");
        }
        {
            PanicHandler::PanicReasons * argp;
            if (SWIG_ConvertPtr(ST(0),(void **) &argp, SWIGTYPE_p_PanicHandler__PanicReasons,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_PanicHandler__PanicReasons",1,"XMLPlatformUtils_panic"); goto fail; 
                }
            }
            arg1 = *argp;
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLPlatformUtils::panic(arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLPlatformUtils) {
    {
        XERCES_CPP_NAMESPACE::XMLPlatformUtils *arg1 = (XERCES_CPP_NAMESPACE::XMLPlatformUtils *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLPlatformUtils(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLPlatformUtils,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLPlatformUtils",1,"delete_XMLPlatformUtils"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_lookupByName) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLURL::Protocols result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_lookupByName(protoName);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"XMLURL_lookupByName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLURL::Protocols)XERCES_CPP_NAMESPACE::XMLURL::lookupByName((unsigned short const *)arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        
        delete[] arg1;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_parse) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLURL_parse(urlText,xmlURL);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"XMLURL_parse");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",2,"XMLURL_parse"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)XERCES_CPP_NAMESPACE::XMLURL::parse((unsigned short const *)arg1,*arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        
        delete[] arg1;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLURL__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_XMLURL();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLURL__SWIG_1) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLURL *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_XMLURL(baseURL,relativeURL);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_XMLURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_XMLURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL((XMLCh const *)arg1,(XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLURL__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLURL *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_XMLURL(baseURL,relativeURL);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"new_XMLURL"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_XMLURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL((XERCES_CPP_NAMESPACE::XMLURL const &)*arg1,(XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLURL__SWIG_3) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLURL *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_XMLURL(urlText);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_XMLURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL((XMLCh const *)arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLURL__SWIG_4) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::XMLURL *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_XMLURL(toCopy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"new_XMLURL"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL((XERCES_CPP_NAMESPACE::XMLURL const &)*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLURL) {
    dXSARGS;
    
    if (items == 0) {
        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_0); return;
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_4); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_3); return;
        }
    }
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_2); return;
            }
        }
    }
    if (items == 2) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_1); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'new_XMLURL'");
    XSRETURN(0);
}


XS(_wrap_delete_XMLURL) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLURL(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"delete_XMLURL"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_operator_equal_to) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLURL_operator_equal_to(self,toCompare);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_operator_equal_to"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",2,"XMLURL_operator_equal_to"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->operator ==((XERCES_CPP_NAMESPACE::XMLURL const &)*arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_operator_not_equal_to) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLURL_operator_not_equal_to(self,toCompare);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_operator_not_equal_to"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",2,"XMLURL_operator_not_equal_to"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->operator !=((XERCES_CPP_NAMESPACE::XMLURL const &)*arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getFragment) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getFragment(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getFragment"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getFragment();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getHost) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getHost(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getHost"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getHost();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getPassword) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getPassword(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getPassword"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getPassword();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getPath) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getPath(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getPath"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getPath();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getPortNum) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getPortNum(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getPortNum"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getPortNum();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getProtocol) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XERCES_CPP_NAMESPACE::XMLURL::Protocols result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getProtocol(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getProtocol"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLURL::Protocols)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getProtocol();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getProtocolName) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getProtocolName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getProtocolName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getProtocolName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getQuery) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getQuery(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getQuery"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getQuery();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getURLText) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getURLText(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getURLText"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getURLText();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getUser) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getUser(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getUser"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getUser();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_setURL__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLURL_setURL(self,urlText);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_setURL"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLURL_setURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setURL((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_setURL__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: XMLURL_setURL(self,baseURL,relativeURL);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_setURL"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLURL_setURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"XMLURL_setURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                (arg1)->setURL((XMLCh const *)arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_setURL__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: XMLURL_setURL(self,baseURL,relativeURL);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_setURL"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",2,"XMLURL_setURL"); goto fail; 
                }
            }
        }
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"XMLURL_setURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                (arg1)->setURL((XERCES_CPP_NAMESPACE::XMLURL const &)*arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_setURL__SWIG_3) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLURL *arg4 = 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: XMLURL_setURL(self,baseURL,relativeURL,xmlURL);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_setURL"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLURL_setURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"XMLURL_setURL");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",4,"XMLURL_setURL"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)(arg1)->setURL((XMLCh const *)arg2,(XMLCh const *)arg3,*arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_setURL) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_setURL__SWIG_0); return;
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_setURL__SWIG_2); return;
                }
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_setURL__SWIG_1); return;
                }
            }
        }
    }
    if (items == 4) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        void *tmp;
                        if (SWIG_ConvertPtr(ST(3), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_setURL__SWIG_3); return;
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'XMLURL_setURL'");
    XSRETURN(0);
}


XS(_wrap_XMLURL_isRelative) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_isRelative(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_isRelative"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->isRelative();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_hasInvalidChar) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_hasInvalidChar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_hasInvalidChar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->hasInvalidChar();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_makeNewStream) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XERCES_CPP_NAMESPACE::BinInputStream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLURL_makeNewStream(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_makeNewStream"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->makeNewStream();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_makeRelativeTo__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLURL_makeRelativeTo(self,baseURLText);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_makeRelativeTo"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLURL_makeRelativeTo");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->makeRelativeTo((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_makeRelativeTo__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
        XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLURL_makeRelativeTo(self,baseURL);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"XMLURL_makeRelativeTo"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",2,"XMLURL_makeRelativeTo"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->makeRelativeTo((XERCES_CPP_NAMESPACE::XMLURL const &)*arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLURL_makeRelativeTo) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_makeRelativeTo__SWIG_1); return;
            }
        }
    }
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_makeRelativeTo__SWIG_0); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'XMLURL_makeRelativeTo'");
    XSRETURN(0);
}


XS(_wrap_new_XMLUri__SWIG_0) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLUri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_XMLUri(uriSpec);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_XMLUri");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLUri *)new XERCES_CPP_NAMESPACE::XMLUri((XMLCh const *)arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLUri__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) (XERCES_CPP_NAMESPACE::XMLUri *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLUri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_XMLUri(baseURI,uriSpec);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"new_XMLUri"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_XMLUri");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLUri *)new XERCES_CPP_NAMESPACE::XMLUri((XERCES_CPP_NAMESPACE::XMLUri const *)arg1,(XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLUri__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::XMLUri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_XMLUri(toCopy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"new_XMLUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLUri *)new XERCES_CPP_NAMESPACE::XMLUri((XERCES_CPP_NAMESPACE::XMLUri const &)*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLUri) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"delete_XMLUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getUriText) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getUriText(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getUriText"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getUriText();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getScheme) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getScheme(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getScheme"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getScheme();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getUserInfo) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getUserInfo(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getUserInfo"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getUserInfo();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getHost) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getHost(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getHost"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getHost();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getPort) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getPort(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getPort"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (int)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getPort();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getRegBasedAuthority) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getRegBasedAuthority(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getRegBasedAuthority"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getRegBasedAuthority();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getPath) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getPath(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getPath"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getPath();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getQueryString) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getQueryString(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getQueryString"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getQueryString();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_getFragment) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_getFragment(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_getFragment"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getFragment();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_setScheme) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_setScheme(self,newScheme);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_setScheme"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_setScheme");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setScheme((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_setUserInfo) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_setUserInfo(self,newUserInfo);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_setUserInfo"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_setUserInfo");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setUserInfo((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_setHost) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_setHost(self,newHost);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_setHost"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_setHost");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setHost((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_setPort) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_setPort(self,newPort);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_setPort"); goto fail; 
                }
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setPort(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_setRegBasedAuthority) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_setRegBasedAuthority(self,newRegAuth);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_setRegBasedAuthority"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_setRegBasedAuthority");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setRegBasedAuthority((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_setPath) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_setPath(self,newPath);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_setPath"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_setPath");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setPath((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_setQueryString) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_setQueryString(self,newQueryString);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_setQueryString"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_setQueryString");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setQueryString((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_setFragment) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_setFragment(self,newFragment);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_setFragment"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_setFragment");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setFragment((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_isURIString) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLUri_isURIString(uric);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"XMLUri_isURIString");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        {
            try 
            {
                result = (bool)XERCES_CPP_NAMESPACE::XMLUri::isURIString((unsigned short const *)arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        
        delete[] arg1;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_isValidURI__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) (XERCES_CPP_NAMESPACE::XMLUri *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_isValidURI(baseURI,uriStr);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUri",1,"XMLUri_isValidURI"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_isValidURI");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (bool)XERCES_CPP_NAMESPACE::XMLUri::isValidURI((XERCES_CPP_NAMESPACE::XMLUri const *)arg1,(unsigned short const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_isValidURI__SWIG_1) {
    {
        bool arg1 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_isValidURI(haveBaseURI,uriStr);");
        }
        arg1 = (bool) SvIV(ST(0));
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLUri_isValidURI");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (bool)XERCES_CPP_NAMESPACE::XMLUri::isValidURI(arg1,(unsigned short const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLUri_isValidURI) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLUri_isValidURI__SWIG_0); return;
            }
        }
    }
    if (items == 2) {
        int _v;
        {
            _v = SvIOK(ST(0)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLUri_isValidURI__SWIG_1); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'XMLUri_isValidURI'");
    XSRETURN(0);
}


XS(_wrap_XMLUri_normalizeURI) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XMLBuffer *arg2 = 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLUri_normalizeURI(systemURI,normalizedURI);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"XMLUri_normalizeURI");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XMLBuffer,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XMLBuffer",2,"XMLUri_normalizeURI"); goto fail; 
                }
            }
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLUri::normalizeURI((unsigned short const *)arg1,*arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg1;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLUri__SWIG_3) {
    {
        XERCES_CPP_NAMESPACE::XMLUri *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_XMLUri();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLUri *)new XERCES_CPP_NAMESPACE::XMLUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLUri) {
    dXSARGS;
    
    if (items == 0) {
        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLUri__SWIG_3); return;
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLUri__SWIG_2); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLUri__SWIG_0); return;
        }
    }
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLUri__SWIG_1); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'new_XMLUri'");
    XSRETURN(0);
}


XS(_wrap_delete_XMLExcepts) {
    {
        XERCES_CPP_NAMESPACE::XMLExcepts *arg1 = (XERCES_CPP_NAMESPACE::XMLExcepts *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLExcepts(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLExcepts,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLExcepts",1,"delete_XMLExcepts"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLException) {
    {
        XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLException(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLException",1,"delete_XMLException"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_getType) {
    {
        XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLException_getType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLException",1,"XMLException_getType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_getCode) {
    {
        XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
        XERCES_CPP_NAMESPACE::XMLExcepts::Codes result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLException_getCode(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLException",1,"XMLException_getCode"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLExcepts::Codes)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getCode();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_getMessage) {
    {
        XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLException_getMessage(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLException",1,"XMLException_getMessage"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getMessage();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_getSrcFile) {
    {
        XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLException_getSrcFile(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLException",1,"XMLException_getSrcFile"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (char *)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getSrcFile();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_getSrcLine) {
    {
        XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLException_getSrcLine(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLException",1,"XMLException_getSrcLine"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getSrcLine();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_getErrorType) {
    {
        XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
        XMLErrorReporter::ErrTypes result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLException_getErrorType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLException",1,"XMLException_getErrorType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getErrorType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            XMLErrorReporter::ErrTypes * resultobj = new XMLErrorReporter::ErrTypes((XMLErrorReporter::ErrTypes &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_XMLErrorReporter__ErrTypes, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_setPosition) {
    {
        XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
        char *arg2 = (char *) (char *)0 ;
        unsigned int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: XMLException_setPosition(self,file,line);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLException",1,"XMLException_setPosition"); goto fail; 
                }
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        arg3 = (unsigned int) SvUV(ST(2));
        {
            try 
            {
                (arg1)->setPosition((char const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_reinitMsgMutex) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: XMLException_reinitMsgMutex();");
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLException::reinitMsgMutex();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLException_reinitMsgLoader) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: XMLException_reinitMsgLoader();");
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLException::reinitMsgLoader();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLUni) {
    {
        XERCES_CPP_NAMESPACE::XMLUni *arg1 = (XERCES_CPP_NAMESPACE::XMLUni *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLUni(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUni,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLUni",1,"delete_XMLUni"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_QName__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::QName *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_QName();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::QName *)new XERCES_CPP_NAMESPACE::QName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_QName__SWIG_1) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg3 ;
        XERCES_CPP_NAMESPACE::QName *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: new_QName(prefix,localPart,uriId);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_QName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_QName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (unsigned int) SvUV(ST(2));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::QName *)new XERCES_CPP_NAMESPACE::QName((XMLCh const *)arg1,(XMLCh const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_QName__SWIG_2) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg2 ;
        XERCES_CPP_NAMESPACE::QName *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_QName(rawName,uriId);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_QName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::QName *)new XERCES_CPP_NAMESPACE::QName((XMLCh const *)arg1,arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_QName__SWIG_3) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::QName *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_QName(qname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"new_QName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::QName *)new XERCES_CPP_NAMESPACE::QName((XERCES_CPP_NAMESPACE::QName const &)*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_QName) {
    dXSARGS;
    
    if (items == 0) {
        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_QName__SWIG_0); return;
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_QName__SWIG_3); return;
        }
    }
    if (items == 2) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_QName__SWIG_2); return;
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvIOK(ST(2)) ? 1 : 0;
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_QName__SWIG_1); return;
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'new_QName'");
    XSRETURN(0);
}


XS(_wrap_delete_QName) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_QName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"delete_QName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_getPrefix) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: QName_getPrefix(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_getPrefix"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)(arg1)->getPrefix();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_getLocalPart) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: QName_getLocalPart(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_getLocalPart"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)(arg1)->getLocalPart();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_getURI) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: QName_getURI(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_getURI"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::QName const *)arg1)->getURI();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_getRawName) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: QName_getRawName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_getRawName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)(arg1)->getRawName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: QName_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::QName const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_setName__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg4 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: QName_setName(self,prefix,localPart,uriId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_setName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"QName_setName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"QName_setName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        arg4 = (unsigned int) SvUV(ST(3));
        {
            try 
            {
                (arg1)->setName((XMLCh const *)arg2,(XMLCh const *)arg3,arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_setName__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: QName_setName(self,rawName,uriId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_setName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"QName_setName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (unsigned int) SvUV(ST(2));
        {
            try 
            {
                (arg1)->setName((XMLCh const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_setName) {
    dXSARGS;
    
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvIOK(ST(2)) ? 1 : 0;
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_QName_setName__SWIG_1); return;
                }
            }
        }
    }
    if (items == 4) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvIOK(ST(3)) ? 1 : 0;
                    }
                    if (_v) {
                        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_QName_setName__SWIG_0); return;
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'QName_setName'");
    XSRETURN(0);
}


XS(_wrap_QName_setPrefix) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: QName_setPrefix(self,XMLCh const *);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_setPrefix"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"QName_setPrefix");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setPrefix((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_setLocalPart) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: QName_setLocalPart(self,XMLCh const *);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_setLocalPart"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"QName_setLocalPart");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setLocalPart((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_setNPrefix) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        unsigned int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: QName_setNPrefix(self,XMLCh const *,unsigned int const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_setNPrefix"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"QName_setNPrefix");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (unsigned int) SvUV(ST(2));
        {
            try 
            {
                (arg1)->setNPrefix((XMLCh const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_setNLocalPart) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        unsigned int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: QName_setNLocalPart(self,XMLCh const *,unsigned int const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_setNLocalPart"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"QName_setNLocalPart");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (unsigned int) SvUV(ST(2));
        {
            try 
            {
                (arg1)->setNLocalPart((XMLCh const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_setURI) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: QName_setURI(self,unsigned int const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_setURI"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setURI(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_setValues) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XERCES_CPP_NAMESPACE::QName *arg2 = 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: QName_setValues(self,qname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_setValues"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",2,"QName_setValues"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setValues((XERCES_CPP_NAMESPACE::QName const &)*arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_operator_equal_to) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        XERCES_CPP_NAMESPACE::QName *arg2 = 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: QName_operator_equal_to(self,XERCES_CPP_NAMESPACE::QName const &);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_operator_equal_to"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",2,"QName_operator_equal_to"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::QName const *)arg1)->operator ==((XERCES_CPP_NAMESPACE::QName const &)*arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_QName_cleanUp) {
    {
        XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: QName_cleanUp(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",1,"QName_cleanUp"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->cleanUp();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLElementDecl) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLElementDecl(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"delete_XMLElementDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_findAttr) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg3 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts arg6 ;
        bool *arg7 = 0 ;
        XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: XMLElementDecl_findAttr(self,qName,uriId,baseName,prefix,options,wasAdded);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_findAttr"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (unsigned int) SvUV(ST(2));
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"XMLElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"XMLElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts) SvIV(ST(5));
        {
            if (SWIG_ConvertPtr(ST(6), (void **) &arg7, SWIGTYPE_p_bool,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_bool",7,"XMLElementDecl_findAttr"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLAttDef *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->findAttr((XMLCh const *)arg2,arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getAttDefList) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLAttDefList *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getAttDefList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getAttDefList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XMLAttDefList &_result_ref = ((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getAttDefList();
                    result = (XMLAttDefList *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getCharDataOpts) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getCharDataOpts(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getCharDataOpts"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getCharDataOpts();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_hasAttDefs) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_hasAttDefs(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_hasAttDefs"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->hasAttDefs();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_resetDefs) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_resetDefs(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_resetDefs"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)(arg1)->resetDefs();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getContentSpec) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::ContentSpecNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getContentSpec(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getContentSpec"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::ContentSpecNode *)(arg1)->getContentSpec();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_setContentSpec) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::ContentSpecNode *arg2 = (XERCES_CPP_NAMESPACE::ContentSpecNode *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLElementDecl_setContentSpec(self,toAdopt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_setContentSpec"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__ContentSpecNode",2,"XMLElementDecl_setContentSpec"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setContentSpec(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getContentModel) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLContentModel *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getContentModel(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLContentModel *)(arg1)->getContentModel();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_setContentModel) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLContentModel *arg2 = (XERCES_CPP_NAMESPACE::XMLContentModel *) (XERCES_CPP_NAMESPACE::XMLContentModel *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLElementDecl_setContentModel(self,newModelToAdopt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_setContentModel"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLContentModel",2,"XMLElementDecl_setContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setContentModel(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getFormattedContentModel) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getFormattedContentModel(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getFormattedContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getFormattedContentModel();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getBaseName) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getBaseName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getBaseName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)(arg1)->getBaseName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getURI) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getURI(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getURI"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getURI();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getElementName) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::QName *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getElementName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getElementName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::QName *)(arg1)->getElementName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getFullName) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getFullName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getFullName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getFullName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getCreateReason) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getCreateReason(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getCreateReason"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getCreateReason();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getId) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getDOMTypeInfoUri) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getDOMTypeInfoUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getDOMTypeInfoUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getDOMTypeInfoUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getDOMTypeInfoName) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getDOMTypeInfoName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getDOMTypeInfoName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getDOMTypeInfoName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_isDeclared) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_isDeclared(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_isDeclared"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->isDeclared();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_isExternal) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_isExternal(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_isExternal"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->isExternal();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_setElementName__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        int arg4 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: XMLElementDecl_setElementName(self,prefix,localPart,uriId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_setElementName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLElementDecl_setElementName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"XMLElementDecl_setElementName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        arg4 = (int) SvIV(ST(3));
        {
            try 
            {
                (arg1)->setElementName((XMLCh const *)arg2,(XMLCh const *)arg3,arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_setElementName__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: XMLElementDecl_setElementName(self,rawName,uriId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_setElementName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLElementDecl_setElementName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (int) SvIV(ST(2));
        {
            try 
            {
                (arg1)->setElementName((XMLCh const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_setElementName__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::QName *arg2 = (XERCES_CPP_NAMESPACE::QName *) (XERCES_CPP_NAMESPACE::QName *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLElementDecl_setElementName(self,elementName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_setElementName"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",2,"XMLElementDecl_setElementName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setElementName((XERCES_CPP_NAMESPACE::QName const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_setElementName) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLElementDecl_setElementName__SWIG_2); return;
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvIOK(ST(2)) ? 1 : 0;
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLElementDecl_setElementName__SWIG_1); return;
                }
            }
        }
    }
    if (items == 4) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvIOK(ST(3)) ? 1 : 0;
                    }
                    if (_v) {
                        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLElementDecl_setElementName__SWIG_0); return;
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'XMLElementDecl_setElementName'");
    XSRETURN(0);
}


XS(_wrap_XMLElementDecl_setCreateReason) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLElementDecl_setCreateReason(self,newReason);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_setCreateReason"); goto fail; 
                }
            }
        }
        arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setCreateReason(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_setId) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLElementDecl_setId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_setId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_setExternalElemDeclaration) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLElementDecl_setExternalElemDeclaration(self,aValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_setExternalElemDeclaration"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setExternalElemDeclaration(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_getObjectType) {
    {
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::objectType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_getObjectType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",1,"XMLElementDecl_getObjectType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl::objectType)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getObjectType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_storeElementDecl) {
    {
        XSerializeEngine *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLElementDecl_storeElementDecl(serEng,element);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XSerializeEngine,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XSerializeEngine",1,"XMLElementDecl_storeElementDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"XMLElementDecl_storeElementDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::XMLElementDecl::storeElementDecl(*arg1,arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLElementDecl_loadElementDecl) {
    {
        XSerializeEngine *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLElementDecl_loadElementDecl(serEng);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XSerializeEngine,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XSerializeEngine",1,"XMLElementDecl_loadElementDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)XERCES_CPP_NAMESPACE::XMLElementDecl::loadElementDecl(*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLEntityDecl) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLEntityDecl(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"delete_XMLEntityDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getDeclaredInIntSubset) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getDeclaredInIntSubset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getDeclaredInIntSubset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getDeclaredInIntSubset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getIsParameter) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getIsParameter(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getIsParameter"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getIsParameter();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getIsSpecialChar) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getIsSpecialChar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getIsSpecialChar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getIsSpecialChar();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getId) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getName) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getNotationName) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getNotationName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getNotationName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getNotationName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getPublicId) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getPublicId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getPublicId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getPublicId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getSystemId) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getSystemId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getSystemId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getSystemId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getBaseURI) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getBaseURI(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getBaseURI"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getBaseURI();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getValue) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getValue(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getValue"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getValue();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getValueLen) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getValueLen(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getValueLen"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getValueLen();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_isExternal) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_isExternal(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_isExternal"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->isExternal();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_isUnparsed) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_isUnparsed(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_isUnparsed"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->isUnparsed();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_setName) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLEntityDecl_setName(self,entName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_setName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setName((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_setNotationName) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLEntityDecl_setNotationName(self,newName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_setNotationName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setNotationName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setNotationName((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_setPublicId) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLEntityDecl_setPublicId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_setPublicId"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setPublicId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setPublicId((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_setSystemId) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLEntityDecl_setSystemId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_setSystemId"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setSystemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setSystemId((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_setBaseURI) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLEntityDecl_setBaseURI(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_setBaseURI"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setBaseURI");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setBaseURI((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_setValue) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLEntityDecl_setValue(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_setValue"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setValue");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setValue((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_setId) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLEntityDecl_setId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_setId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLEntityDecl_getKey) {
    {
        XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLEntityDecl_getKey(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLEntityDecl",1,"XMLEntityDecl_getKey"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getKey();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLNotationDecl__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_XMLNotationDecl();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)new XERCES_CPP_NAMESPACE::XMLNotationDecl();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLNotationDecl__SWIG_1) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLNotationDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: new_XMLNotationDecl(notName,pubId,sysId,baseURI);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_XMLNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_XMLNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"new_XMLNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"new_XMLNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)new XERCES_CPP_NAMESPACE::XMLNotationDecl((XMLCh const *)arg1,(XMLCh const *)arg2,(XMLCh const *)arg3,(XMLCh const *)arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLNotationDecl__SWIG_2) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLNotationDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: new_XMLNotationDecl(notName,pubId,sysId);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_XMLNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_XMLNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"new_XMLNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)new XERCES_CPP_NAMESPACE::XMLNotationDecl((XMLCh const *)arg1,(XMLCh const *)arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_XMLNotationDecl) {
    dXSARGS;
    
    if (items == 0) {
        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLNotationDecl__SWIG_0); return;
    }
    if (items == 3) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLNotationDecl__SWIG_2); return;
                }
            }
        }
    }
    if (items == 4) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLNotationDecl__SWIG_1); return;
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'new_XMLNotationDecl'");
    XSRETURN(0);
}


XS(_wrap_delete_XMLNotationDecl) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLNotationDecl(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"delete_XMLNotationDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_getId) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLNotationDecl_getId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_getId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_getName) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLNotationDecl_getName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_getName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_getPublicId) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLNotationDecl_getPublicId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_getPublicId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getPublicId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_getSystemId) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLNotationDecl_getSystemId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_getSystemId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getSystemId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_getBaseURI) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLNotationDecl_getBaseURI(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_getBaseURI"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getBaseURI();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_getNameSpaceId) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLNotationDecl_getNameSpaceId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_getNameSpaceId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getNameSpaceId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLNotationDecl_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_setId) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLNotationDecl_setId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_setId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_setName) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLNotationDecl_setName(self,notName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_setName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLNotationDecl_setName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setName((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_setPublicId) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLNotationDecl_setPublicId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_setPublicId"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLNotationDecl_setPublicId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setPublicId((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_setSystemId) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLNotationDecl_setSystemId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_setSystemId"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLNotationDecl_setSystemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setSystemId((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_setBaseURI) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLNotationDecl_setBaseURI(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_setBaseURI"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLNotationDecl_setBaseURI");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setBaseURI((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_setNameSpaceId) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLNotationDecl_setNameSpaceId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_setNameSpaceId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setNameSpaceId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLNotationDecl_getKey) {
    {
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLNotationDecl_getKey(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",1,"XMLNotationDecl_getKey"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getKey();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLAttDefList) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLAttDefList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"delete_XMLAttDefList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_hasMoreElements) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDefList_hasMoreElements(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_hasMoreElements"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLAttDefList const *)arg1)->hasMoreElements();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_isEmpty) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDefList_isEmpty(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_isEmpty"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLAttDefList const *)arg1)->isEmpty();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_findAttDef__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        unsigned long arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: XMLAttDefList_findAttDef(self,uriID,attName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_findAttDef"); goto fail; 
                }
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"XMLAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef(arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_findAttDef__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: XMLAttDefList_findAttDef(self,attURI,attName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_findAttDef"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"XMLAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef((XMLCh const *)arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_findAttDef) {
    dXSARGS;
    
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLAttDefList_findAttDef__SWIG_0); return;
                }
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLAttDefList_findAttDef__SWIG_1); return;
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'XMLAttDefList_findAttDef'");
    XSRETURN(0);
}


XS(_wrap_XMLAttDefList_nextElement) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDefList_nextElement(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_nextElement"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->nextElement();
                    result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_Reset) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDefList_Reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_Reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->Reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_getAttDefCount) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDefList_getAttDefCount(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_getAttDefCount"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLAttDefList const *)arg1)->getAttDefCount();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_getAttDef) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        unsigned int arg2 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDefList_getAttDef(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_getAttDef"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->getAttDef(arg2);
                    result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDefList_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDefList_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDefList",1,"XMLAttDefList_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLAttDefList const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getAttTypeString) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes arg1 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getAttTypeString(attrType);");
        }
        arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes) SvIV(ST(0));
        {
            try 
            {
                result = (XMLCh *)XERCES_CPP_NAMESPACE::XMLAttDef::getAttTypeString(arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getDefAttTypeString) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes arg1 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getDefAttTypeString(attrType);");
        }
        arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes) SvIV(ST(0));
        {
            try 
            {
                result = (XMLCh *)XERCES_CPP_NAMESPACE::XMLAttDef::getDefAttTypeString(arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLAttDef) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLAttDef(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"delete_XMLAttDef"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getFullName) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getFullName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getFullName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getFullName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_reset) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getDefaultType) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getDefaultType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getDefaultType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getDefaultType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getEnumeration) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getEnumeration(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getEnumeration"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getEnumeration();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getId) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getProvided) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getProvided(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getProvided"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getProvided();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getType) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getValue) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getValue(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getValue"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getValue();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getCreateReason) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getCreateReason(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getCreateReason"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getCreateReason();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_isExternal) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_isExternal(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_isExternal"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->isExternal();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getDOMTypeInfoUri) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getDOMTypeInfoUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getDOMTypeInfoUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getDOMTypeInfoUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_getDOMTypeInfoName) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLAttDef_getDOMTypeInfoName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_getDOMTypeInfoName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getDOMTypeInfoName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_setDefaultType) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDef_setDefaultType(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_setDefaultType"); goto fail; 
                }
            }
        }
        arg2 = (XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setDefaultType(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_setId) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDef_setId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_setId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_setProvided) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDef_setProvided(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_setProvided"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setProvided(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_setType) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDef_setType(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_setType"); goto fail; 
                }
            }
        }
        arg2 = (XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setType(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_setValue) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDef_setValue(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_setValue"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLAttDef_setValue");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setValue((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_setEnumeration) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDef_setEnumeration(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_setEnumeration"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLAttDef_setEnumeration");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setEnumeration((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_setCreateReason) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDef_setCreateReason(self,newReason);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_setCreateReason"); goto fail; 
                }
            }
        }
        arg2 = (XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setCreateReason(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLAttDef_setExternalAttDeclaration) {
    {
        XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLAttDef_setExternalAttDeclaration(self,aValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",1,"XMLAttDef_setExternalAttDeclaration"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setExternalAttDeclaration(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLValidator) {
    {
        XERCES_CPP_NAMESPACE::XMLValidator *arg1 = (XERCES_CPP_NAMESPACE::XMLValidator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLValidator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLValidator",1,"delete_XMLValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLValidator_getGrammar) {
    {
        XERCES_CPP_NAMESPACE::XMLValidator *arg1 = (XERCES_CPP_NAMESPACE::XMLValidator *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLValidator_getGrammar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLValidator",1,"XMLValidator_getGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar *)((XERCES_CPP_NAMESPACE::XMLValidator const *)arg1)->getGrammar();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLValidator_setGrammar) {
    {
        XERCES_CPP_NAMESPACE::XMLValidator *arg1 = (XERCES_CPP_NAMESPACE::XMLValidator *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar *arg2 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLValidator_setGrammar(self,aGrammar);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLValidator",1,"XMLValidator_setGrammar"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",2,"XMLValidator_setGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setGrammar(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_Grammar) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_Grammar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"delete_Grammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_getGrammarType) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Grammar_getGrammarType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_getGrammarType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getGrammarType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_getTargetNamespace) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Grammar_getTargetNamespace(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_getTargetNamespace"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getTargetNamespace();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_getValidated) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Grammar_getValidated(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_getValidated"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getValidated();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_findOrAddElemDecl) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        bool *arg7 = 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: Grammar_findOrAddElemDecl(self,uriId,baseName,prefixName,qName,scope,wasAdded);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_findOrAddElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"Grammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"Grammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"Grammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        {
            if (SWIG_ConvertPtr(ST(6), (void **) &arg7, SWIGTYPE_p_bool,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_bool",7,"Grammar_findOrAddElemDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->findOrAddElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_getElemId) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg5 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: Grammar_getElemId(self,uriId,baseName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_getElemId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"Grammar_getElemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"Grammar_getElemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        arg5 = (unsigned int) SvUV(ST(4));
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getElemId(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_getElemDecl__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg5 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: Grammar_getElemDecl(self,uriId,baseName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_getElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"Grammar_getElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"Grammar_getElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        arg5 = (unsigned int) SvUV(ST(4));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_getElemDecl__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        unsigned int arg2 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Grammar_getElemDecl(self,elemId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_getElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_getElemDecl) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_getElemDecl__SWIG_1); return;
            }
        }
    }
    if (items == 5) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvIOK(ST(4)) ? 1 : 0;
                        }
                        if (_v) {
                            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_getElemDecl__SWIG_0); return;
                        }
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'Grammar_getElemDecl'");
    XSRETURN(0);
}


XS(_wrap_Grammar_getNotationDecl) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLNotationDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Grammar_getNotationDecl(self,notName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_getNotationDecl"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"Grammar_getNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)(arg1)->getNotationDecl((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_putElemDecl__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        bool arg7 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: Grammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope,notDeclared);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"Grammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"Grammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"Grammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        arg7 = (bool) SvIV(ST(6));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_putElemDecl__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: Grammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"Grammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"Grammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"Grammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_putElemDecl__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
        bool arg3 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: Grammar_putElemDecl(self,elemDecl,notDeclared);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"Grammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg3 = (bool) SvIV(ST(2));
        {
            try 
            {
                result = (unsigned int)(arg1)->putElemDecl(arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_putElemDecl__SWIG_3) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Grammar_putElemDecl(self,elemDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"Grammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)(arg1)->putElemDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_putElemDecl) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_putElemDecl__SWIG_3); return;
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = SvIOK(ST(2)) ? 1 : 0;
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_putElemDecl__SWIG_2); return;
                }
            }
        }
    }
    if (items == 6) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvOK(ST(4)) ? 1 : 0; 
                        }
                        if (_v) {
                            {
                                _v = SvIOK(ST(5)) ? 1 : 0;
                            }
                            if (_v) {
                                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_putElemDecl__SWIG_1); return;
                            }
                        }
                    }
                }
            }
        }
    }
    if (items == 7) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvOK(ST(4)) ? 1 : 0; 
                        }
                        if (_v) {
                            {
                                _v = SvIOK(ST(5)) ? 1 : 0;
                            }
                            if (_v) {
                                {
                                    _v = SvIOK(ST(6)) ? 1 : 0;
                                }
                                if (_v) {
                                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_putElemDecl__SWIG_0); return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'Grammar_putElemDecl'");
    XSRETURN(0);
}


XS(_wrap_Grammar_putNotationDecl) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) (XERCES_CPP_NAMESPACE::XMLNotationDecl *)0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Grammar_putNotationDecl(self,notationDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_putNotationDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",2,"Grammar_putNotationDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->putNotationDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_setValidated) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Grammar_setValidated(self,newState);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_setValidated"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setValidated(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_reset) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Grammar_reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_setGrammarDescription) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg2 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Grammar_setGrammarDescription(self,XERCES_CPP_NAMESPACE::XMLGrammarDescription *);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_setGrammarDescription"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription",2,"Grammar_setGrammarDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setGrammarDescription(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_getGrammarDescription) {
    {
        XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Grammar_getGrammarDescription(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",1,"Grammar_getGrammarDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getGrammarDescription();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_storeGrammar) {
    {
        XSerializeEngine *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::Grammar *arg2 = (XERCES_CPP_NAMESPACE::Grammar *) (XERCES_CPP_NAMESPACE::Grammar *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: Grammar_storeGrammar(serEng,grammar);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XSerializeEngine,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XSerializeEngine",1,"Grammar_storeGrammar"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",2,"Grammar_storeGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::Grammar::storeGrammar(*arg1,arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_Grammar_loadGrammar) {
    {
        XSerializeEngine *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::Grammar *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Grammar_loadGrammar(serEng);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XSerializeEngine,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XSerializeEngine",1,"Grammar_loadGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar *)XERCES_CPP_NAMESPACE::Grammar::loadGrammar(*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLGrammarDescription) {
    {
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLGrammarDescription(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription",1,"delete_XMLGrammarDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLGrammarDescription_getGrammarType) {
    {
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLGrammarDescription_getGrammarType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription",1,"XMLGrammarDescription_getGrammarType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::XMLGrammarDescription const *)arg1)->getGrammarType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLGrammarDescription_getGrammarKey) {
    {
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLGrammarDescription_getGrammarKey(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription",1,"XMLGrammarDescription_getGrammarKey"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLGrammarDescription const *)arg1)->getGrammarKey();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLGrammarDescription_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLGrammarDescription_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription",1,"XMLGrammarDescription_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLGrammarDescription const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLDTDDescription) {
    {
        XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLDTDDescription(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLDTDDescription",1,"delete_XMLDTDDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLDTDDescription_getGrammarType) {
    {
        XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLDTDDescription_getGrammarType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLDTDDescription",1,"XMLDTDDescription_getGrammarType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::XMLDTDDescription const *)arg1)->getGrammarType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLDTDDescription_getRootName) {
    {
        XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLDTDDescription_getRootName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLDTDDescription",1,"XMLDTDDescription_getRootName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLDTDDescription const *)arg1)->getRootName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLDTDDescription_getSystemId) {
    {
        XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLDTDDescription_getSystemId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLDTDDescription",1,"XMLDTDDescription_getSystemId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLDTDDescription const *)arg1)->getSystemId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLDTDDescription_setRootName) {
    {
        XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLDTDDescription_setRootName(self,XMLCh const *const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLDTDDescription",1,"XMLDTDDescription_setRootName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLDTDDescription_setRootName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setRootName((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLDTDDescription_setSystemId) {
    {
        XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLDTDDescription_setSystemId(self,XMLCh const *const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLDTDDescription",1,"XMLDTDDescription_setSystemId"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLDTDDescription_setSystemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setSystemId((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_XMLSchemaDescription) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_XMLSchemaDescription(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"delete_XMLSchemaDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_getGrammarType) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLSchemaDescription_getGrammarType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_getGrammarType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getGrammarType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_getContextType) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLSchemaDescription_getContextType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_getContextType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getContextType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_getTargetNamespace) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLSchemaDescription_getTargetNamespace(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_getTargetNamespace"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getTargetNamespace();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_getLocationHints) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        RefArrayVectorOf<XMLCh > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLSchemaDescription_getLocationHints(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_getLocationHints"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (RefArrayVectorOf<XMLCh > *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getLocationHints();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_RefArrayVectorOfTunsigned_short_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_getTriggeringComponent) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::QName *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLSchemaDescription_getTriggeringComponent(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_getTriggeringComponent"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::QName *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getTriggeringComponent();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_getEnclosingElementName) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::QName *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLSchemaDescription_getEnclosingElementName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_getEnclosingElementName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::QName *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getEnclosingElementName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_getAttributes) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: XMLSchemaDescription_getAttributes(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_getAttributes"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getAttributes();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_setContextType) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLSchemaDescription_setContextType(self,XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_setContextType"); goto fail; 
                }
            }
        }
        arg2 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setContextType(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_setTargetNamespace) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLSchemaDescription_setTargetNamespace(self,XMLCh const *const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_setTargetNamespace"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLSchemaDescription_setTargetNamespace");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setTargetNamespace((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_setLocationHints) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLSchemaDescription_setLocationHints(self,XMLCh const *const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_setLocationHints"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"XMLSchemaDescription_setLocationHints");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setLocationHints((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_setTriggeringComponent) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::QName *arg2 = (XERCES_CPP_NAMESPACE::QName *) (XERCES_CPP_NAMESPACE::QName *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLSchemaDescription_setTriggeringComponent(self,XERCES_CPP_NAMESPACE::QName *const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_setTriggeringComponent"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",2,"XMLSchemaDescription_setTriggeringComponent"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setTriggeringComponent(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_setEnclosingElementName) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::QName *arg2 = (XERCES_CPP_NAMESPACE::QName *) (XERCES_CPP_NAMESPACE::QName *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLSchemaDescription_setEnclosingElementName(self,XERCES_CPP_NAMESPACE::QName *const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_setEnclosingElementName"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__QName",2,"XMLSchemaDescription_setEnclosingElementName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setEnclosingElementName(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_XMLSchemaDescription_setAttributes) {
    {
        XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *arg2 = (XERCES_CPP_NAMESPACE::XMLAttDef *) (XERCES_CPP_NAMESPACE::XMLAttDef *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: XMLSchemaDescription_setAttributes(self,XERCES_CPP_NAMESPACE::XMLAttDef *const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription",1,"XMLSchemaDescription_setAttributes"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLAttDef",2,"XMLSchemaDescription_setAttributes"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setAttributes(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_DTDElementDecl) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DTDElementDecl(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"delete_DTDElementDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_findAttr) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg3 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts arg6 ;
        bool *arg7 = 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: DTDElementDecl_findAttr(self,qName,uriId,baseName,prefix,options,wasAdded);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_findAttr"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DTDElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (unsigned int) SvUV(ST(2));
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"DTDElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"DTDElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts) SvIV(ST(5));
        {
            if (SWIG_ConvertPtr(ST(6), (void **) &arg7, SWIGTYPE_p_bool,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_bool",7,"DTDElementDecl_findAttr"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->findAttr((XMLCh const *)arg2,arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getAttDefList) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDefList *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getAttDefList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getAttDefList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLAttDefList &_result_ref = ((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getAttDefList();
                    result = (XERCES_CPP_NAMESPACE::XMLAttDefList *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getCharDataOpts) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getCharDataOpts(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getCharDataOpts"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getCharDataOpts();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_hasAttDefs) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_hasAttDefs(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_hasAttDefs"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->hasAttDefs();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_resetDefs) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_resetDefs(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_resetDefs"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)(arg1)->resetDefs();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getContentSpec) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::ContentSpecNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getContentSpec(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getContentSpec"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::ContentSpecNode *)(arg1)->getContentSpec();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_setContentSpec) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::ContentSpecNode *arg2 = (XERCES_CPP_NAMESPACE::ContentSpecNode *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDElementDecl_setContentSpec(self,toAdopt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_setContentSpec"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__ContentSpecNode",2,"DTDElementDecl_setContentSpec"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setContentSpec(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getContentModel) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLContentModel *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getContentModel(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLContentModel *)(arg1)->getContentModel();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_setContentModel) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLContentModel *arg2 = (XERCES_CPP_NAMESPACE::XMLContentModel *) (XERCES_CPP_NAMESPACE::XMLContentModel *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDElementDecl_setContentModel(self,newModelToAdopt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_setContentModel"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLContentModel",2,"DTDElementDecl_setContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setContentModel(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getFormattedContentModel) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getFormattedContentModel(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getFormattedContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getFormattedContentModel();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getKey) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getKey(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getKey"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getKey();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getAttDef) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        DTDAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDElementDecl_getAttDef(self,attName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getAttDef"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DTDElementDecl_getAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (DTDAttDef *)(arg1)->getAttDef((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getModelType) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getModelType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getModelType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getModelType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getDOMTypeInfoName) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getDOMTypeInfoName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getDOMTypeInfoName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getDOMTypeInfoName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getDOMTypeInfoUri) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getDOMTypeInfoUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getDOMTypeInfoUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getDOMTypeInfoUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_addAttDef) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        DTDAttDef *arg2 = (DTDAttDef *) (DTDAttDef *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDElementDecl_addAttDef(self,toAdd);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_addAttDef"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",2,"DTDElementDecl_addAttDef"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->addAttDef(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_setModelType) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDElementDecl_setModelType(self,toSet);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_setModelType"); goto fail; 
                }
            }
        }
        arg2 = (XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setModelType(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDecl_getObjectType) {
    {
        XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::objectType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDecl_getObjectType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDElementDecl",1,"DTDElementDecl_getObjectType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl::objectType)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getObjectType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDElementDeclEnumerator__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *) (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *)0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *arg2 = (XERCES_CPP_NAMESPACE::MemoryManager *) (XERCES_CPP_NAMESPACE::MemoryManager *)0 ;
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        arg2 = XERCES_CPP_NAMESPACE::XMLPlatformUtils::fgMemoryManager;
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_DTDElementDeclEnumerator(toEnum);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t",1,"new_DTDElementDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >(arg1,arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDElementDeclEnumerator__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *) (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *)0 ;
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_DTDElementDeclEnumerator(toEnum);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t",1,"new_DTDElementDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >(arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDElementDeclEnumerator__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_DTDElementDeclEnumerator(toCopy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t",1,"new_DTDElementDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const &)*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDElementDeclEnumerator) {
    dXSARGS;
    
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDElementDeclEnumerator__SWIG_0); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDElementDeclEnumerator__SWIG_1); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDElementDeclEnumerator__SWIG_2); return;
        }
    }
    
    croak("No matching function for overloaded 'new_DTDElementDeclEnumerator'");
    XSRETURN(0);
}


XS(_wrap_delete_DTDElementDeclEnumerator) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DTDElementDeclEnumerator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t",1,"delete_DTDElementDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDeclEnumerator_hasMoreElements) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDeclEnumerator_hasMoreElements(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t",1,"DTDElementDeclEnumerator_hasMoreElements"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const *)arg1)->hasMoreElements();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDeclEnumerator_nextElement) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
        XERCES_CPP_NAMESPACE::DTDElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDeclEnumerator_nextElement(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t",1,"DTDElementDeclEnumerator_nextElement"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::DTDElementDecl &_result_ref = (arg1)->nextElement();
                    result = (XERCES_CPP_NAMESPACE::DTDElementDecl *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDeclEnumerator_Reset) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDeclEnumerator_Reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t",1,"DTDElementDeclEnumerator_Reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->Reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDElementDeclEnumerator_size) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDElementDeclEnumerator_size(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t",1,"DTDElementDeclEnumerator_size"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (int)((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const *)arg1)->size();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_DTDEntityDecl) {
    {
        XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DTDEntityDecl(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDEntityDecl",1,"delete_DTDEntityDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDecl_getDeclaredInIntSubset) {
    {
        XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDEntityDecl_getDeclaredInIntSubset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDEntityDecl",1,"DTDEntityDecl_getDeclaredInIntSubset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DTDEntityDecl const *)arg1)->getDeclaredInIntSubset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDecl_getIsParameter) {
    {
        XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDEntityDecl_getIsParameter(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDEntityDecl",1,"DTDEntityDecl_getIsParameter"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DTDEntityDecl const *)arg1)->getIsParameter();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDecl_getIsSpecialChar) {
    {
        XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDEntityDecl_getIsSpecialChar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDEntityDecl",1,"DTDEntityDecl_getIsSpecialChar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DTDEntityDecl const *)arg1)->getIsSpecialChar();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDecl_setDeclaredInIntSubset) {
    {
        XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDEntityDecl_setDeclaredInIntSubset(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDEntityDecl",1,"DTDEntityDecl_setDeclaredInIntSubset"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setDeclaredInIntSubset(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDecl_setIsParameter) {
    {
        XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDEntityDecl_setIsParameter(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDEntityDecl",1,"DTDEntityDecl_setIsParameter"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setIsParameter(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDecl_setIsSpecialChar) {
    {
        XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDEntityDecl_setIsSpecialChar(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDEntityDecl",1,"DTDEntityDecl_setIsSpecialChar"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setIsSpecialChar(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDEntityDeclEnumerator__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *arg2 = (XERCES_CPP_NAMESPACE::MemoryManager *) (XERCES_CPP_NAMESPACE::MemoryManager *)0 ;
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        arg2 = XERCES_CPP_NAMESPACE::XMLPlatformUtils::fgMemoryManager;
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_DTDEntityDeclEnumerator(toEnum);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t",1,"new_DTDEntityDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >(arg1,arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDEntityDeclEnumerator__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)0 ;
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_DTDEntityDeclEnumerator(toEnum);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t",1,"new_DTDEntityDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >(arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDEntityDeclEnumerator__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_DTDEntityDeclEnumerator(toCopy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t",1,"new_DTDEntityDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const &)*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDEntityDeclEnumerator) {
    dXSARGS;
    
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDEntityDeclEnumerator__SWIG_0); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDEntityDeclEnumerator__SWIG_1); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDEntityDeclEnumerator__SWIG_2); return;
        }
    }
    
    croak("No matching function for overloaded 'new_DTDEntityDeclEnumerator'");
    XSRETURN(0);
}


XS(_wrap_delete_DTDEntityDeclEnumerator) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DTDEntityDeclEnumerator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t",1,"delete_DTDEntityDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDeclEnumerator_hasMoreElements) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDEntityDeclEnumerator_hasMoreElements(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t",1,"DTDEntityDeclEnumerator_hasMoreElements"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const *)arg1)->hasMoreElements();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDeclEnumerator_nextElement) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
        XERCES_CPP_NAMESPACE::DTDEntityDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDEntityDeclEnumerator_nextElement(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t",1,"DTDEntityDeclEnumerator_nextElement"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::DTDEntityDecl &_result_ref = (arg1)->nextElement();
                    result = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDeclEnumerator_Reset) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDEntityDeclEnumerator_Reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t",1,"DTDEntityDeclEnumerator_Reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->Reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDEntityDeclEnumerator_size) {
    {
        XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDEntityDeclEnumerator_size(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t",1,"DTDEntityDeclEnumerator_size"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (int)((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const *)arg1)->size();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_DTDAttDefList) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DTDAttDefList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"delete_DTDAttDefList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDefList_hasMoreElements) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDefList_hasMoreElements(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"DTDAttDefList_hasMoreElements"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DTDAttDefList const *)arg1)->hasMoreElements();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDefList_isEmpty) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDefList_isEmpty(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"DTDAttDefList_isEmpty"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DTDAttDefList const *)arg1)->isEmpty();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDefList_findAttDef__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        unsigned long arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: DTDAttDefList_findAttDef(self,uriID,attName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"DTDAttDefList_findAttDef"); goto fail; 
                }
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"DTDAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef(arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDefList_findAttDef__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: DTDAttDefList_findAttDef(self,attURI,attName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"DTDAttDefList_findAttDef"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DTDAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"DTDAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef((XMLCh const *)arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDefList_findAttDef) {
    dXSARGS;
    
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDAttDefList_findAttDef__SWIG_0); return;
                }
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDAttDefList_findAttDef__SWIG_1); return;
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'DTDAttDefList_findAttDef'");
    XSRETURN(0);
}


XS(_wrap_DTDAttDefList_nextElement) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDefList_nextElement(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"DTDAttDefList_nextElement"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->nextElement();
                    result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDefList_Reset) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDefList_Reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"DTDAttDefList_Reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->Reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDefList_getAttDefCount) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDefList_getAttDefCount(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"DTDAttDefList_getAttDefCount"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDAttDefList const *)arg1)->getAttDefCount();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDefList_getAttDef) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
        unsigned int arg2 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDAttDefList_getAttDef(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDefList",1,"DTDAttDefList_getAttDef"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->getAttDef(arg2);
                    result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_DTDAttDef) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DTDAttDef(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",1,"delete_DTDAttDef"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDef_getFullName) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDef_getFullName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",1,"DTDAttDef_getFullName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDAttDef const *)arg1)->getFullName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDef_reset) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDef_reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",1,"DTDAttDef_reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDef_getElemId) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDef_getElemId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",1,"DTDAttDef_getElemId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDAttDef const *)arg1)->getElemId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDef_getDOMTypeInfoName) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDef_getDOMTypeInfoName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",1,"DTDAttDef_getDOMTypeInfoName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDAttDef const *)arg1)->getDOMTypeInfoName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDef_getDOMTypeInfoUri) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDAttDef_getDOMTypeInfoUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",1,"DTDAttDef_getDOMTypeInfoUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDAttDef const *)arg1)->getDOMTypeInfoUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDef_setElemId) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDAttDef_setElemId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",1,"DTDAttDef_setElemId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setElemId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDAttDef_setName) {
    {
        XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDAttDef_setName(self,newName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDAttDef",1,"DTDAttDef_setName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DTDAttDef_setName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setName((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDGrammar) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_DTDGrammar();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DTDGrammar *)new XERCES_CPP_NAMESPACE::DTDGrammar();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_DTDGrammar) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DTDGrammar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"delete_DTDGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getGrammarType) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getGrammarType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getGrammarType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getGrammarType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getTargetNamespace) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getTargetNamespace(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getTargetNamespace"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getTargetNamespace();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_findOrAddElemDecl) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        bool *arg7 = 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: DTDGrammar_findOrAddElemDecl(self,uriId,baseName,prefixName,qName,scope,wasAdded);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_findOrAddElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"DTDGrammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        {
            if (SWIG_ConvertPtr(ST(6), (void **) &arg7, SWIGTYPE_p_bool,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_bool",7,"DTDGrammar_findOrAddElemDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->findOrAddElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getElemId) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg5 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: DTDGrammar_getElemId(self,uriId,baseName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getElemId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_getElemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_getElemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        arg5 = (unsigned int) SvUV(ST(4));
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getElemId(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getElemDecl__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg5 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: DTDGrammar_getElemDecl(self,uriId,baseName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_getElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_getElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        arg5 = (unsigned int) SvUV(ST(4));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getElemDecl__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        unsigned int arg2 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_getElemDecl(self,elemId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getElemDecl) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_getElemDecl__SWIG_1); return;
            }
        }
    }
    if (items == 5) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvIOK(ST(4)) ? 1 : 0;
                        }
                        if (_v) {
                            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_getElemDecl__SWIG_0); return;
                        }
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'DTDGrammar_getElemDecl'");
    XSRETURN(0);
}


XS(_wrap_DTDGrammar_getNotationDecl) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLNotationDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_getNotationDecl(self,notName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getNotationDecl"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DTDGrammar_getNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)(arg1)->getNotationDecl((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getValidated) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getValidated(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getValidated"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getValidated();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_putElemDecl__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        bool arg7 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: DTDGrammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope,notDeclared);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"DTDGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        arg7 = (bool) SvIV(ST(6));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_putElemDecl__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: DTDGrammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"DTDGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_putElemDecl__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
        bool arg3 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: DTDGrammar_putElemDecl(self,elemDecl,notDeclared);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"DTDGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg3 = (bool) SvIV(ST(2));
        {
            try 
            {
                result = (unsigned int)(arg1)->putElemDecl(arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_putElemDecl__SWIG_3) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_putElemDecl(self,elemDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"DTDGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)(arg1)->putElemDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_putElemDecl) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_putElemDecl__SWIG_3); return;
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = SvIOK(ST(2)) ? 1 : 0;
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_putElemDecl__SWIG_2); return;
                }
            }
        }
    }
    if (items == 6) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvOK(ST(4)) ? 1 : 0; 
                        }
                        if (_v) {
                            {
                                _v = SvIOK(ST(5)) ? 1 : 0;
                            }
                            if (_v) {
                                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_putElemDecl__SWIG_1); return;
                            }
                        }
                    }
                }
            }
        }
    }
    if (items == 7) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvOK(ST(4)) ? 1 : 0; 
                        }
                        if (_v) {
                            {
                                _v = SvIOK(ST(5)) ? 1 : 0;
                            }
                            if (_v) {
                                {
                                    _v = SvIOK(ST(6)) ? 1 : 0;
                                }
                                if (_v) {
                                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_putElemDecl__SWIG_0); return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'DTDGrammar_putElemDecl'");
    XSRETURN(0);
}


XS(_wrap_DTDGrammar_putNotationDecl) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) (XERCES_CPP_NAMESPACE::XMLNotationDecl *)0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_putNotationDecl(self,notationDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_putNotationDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",2,"DTDGrammar_putNotationDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->putNotationDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_setValidated) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_setValidated(self,newState);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_setValidated"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setValidated(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_reset) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getRootElemId) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getRootElemId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getRootElemId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getRootElemId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getEntityDecl) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::DTDEntityDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_getEntityDecl(self,entName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getEntityDecl"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DTDGrammar_getEntityDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DTDEntityDecl *)(arg1)->getEntityDecl((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getEntityDeclPool) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getEntityDeclPool(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getEntityDeclPool"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)(arg1)->getEntityDeclPool();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getElemEnumerator) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        SwigValueWrapper<XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > > result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getElemEnumerator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getElemEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getElemEnumerator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > * resultobj = new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getEntityEnumerator) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        SwigValueWrapper<XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > > result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getEntityEnumerator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getEntityEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getEntityEnumerator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > * resultobj = new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_SHADOW|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getNotationEnumerator) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        SwigValueWrapper<XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl > > result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getNotationEnumerator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getNotationEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getNotationEnumerator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl > * resultobj = new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl >((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl > &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__XMLNotationDecl_t, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_setRootElemId) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_setRootElemId(self,rootElemId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_setRootElemId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setRootElemId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_setGrammarDescription) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg2 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_setGrammarDescription(self,XERCES_CPP_NAMESPACE::XMLGrammarDescription *);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_setGrammarDescription"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription",2,"DTDGrammar_setGrammarDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setGrammarDescription(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_getGrammarDescription) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDGrammar_getGrammarDescription(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_getGrammarDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getGrammarDescription();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_putEntityDecl) {
    {
        XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::DTDEntityDecl *arg2 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) (XERCES_CPP_NAMESPACE::DTDEntityDecl *)0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDGrammar_putEntityDecl(self,entityDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDGrammar",1,"DTDGrammar_putEntityDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDEntityDecl",2,"DTDGrammar_putEntityDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->putEntityDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDGrammar_reinitDfltEntities) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: DTDGrammar_reinitDfltEntities();");
        }
        {
            try 
            {
                XERCES_CPP_NAMESPACE::DTDGrammar::reinitDfltEntities();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDValidator__SWIG_0) {
    {
        XMLErrorReporter *arg1 = (XMLErrorReporter *) (XMLErrorReporter *)0 ;
        XERCES_CPP_NAMESPACE::DTDValidator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_DTDValidator(errReporter);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XMLErrorReporter,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XMLErrorReporter",1,"new_DTDValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DTDValidator *)new XERCES_CPP_NAMESPACE::DTDValidator(arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDValidator__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::DTDValidator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_DTDValidator();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DTDValidator *)new XERCES_CPP_NAMESPACE::DTDValidator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DTDValidator) {
    dXSARGS;
    
    if (items == 0) {
        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDValidator__SWIG_1); return;
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XMLErrorReporter, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDValidator__SWIG_0); return;
        }
    }
    
    croak("No matching function for overloaded 'new_DTDValidator'");
    XSRETURN(0);
}


XS(_wrap_delete_DTDValidator) {
    {
        XERCES_CPP_NAMESPACE::DTDValidator *arg1 = (XERCES_CPP_NAMESPACE::DTDValidator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DTDValidator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDValidator",1,"delete_DTDValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDValidator_getGrammar) {
    {
        XERCES_CPP_NAMESPACE::DTDValidator *arg1 = (XERCES_CPP_NAMESPACE::DTDValidator *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DTDValidator_getGrammar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDValidator",1,"DTDValidator_getGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar *)((XERCES_CPP_NAMESPACE::DTDValidator const *)arg1)->getGrammar();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DTDValidator_setGrammar) {
    {
        XERCES_CPP_NAMESPACE::DTDValidator *arg1 = (XERCES_CPP_NAMESPACE::DTDValidator *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar *arg2 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DTDValidator_setGrammar(self,aGrammar);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DTDValidator",1,"DTDValidator_setGrammar"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",2,"DTDValidator_setGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setGrammar(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_SchemaElementDecl) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_SchemaElementDecl(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"delete_SchemaElementDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_findAttr) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg3 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts arg6 ;
        bool *arg7 = 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: SchemaElementDecl_findAttr(self,qName,uriId,baseName,prefix,options,wasAdded);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_findAttr"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (unsigned int) SvUV(ST(2));
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"SchemaElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"SchemaElementDecl_findAttr");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts) SvIV(ST(5));
        {
            if (SWIG_ConvertPtr(ST(6), (void **) &arg7, SWIGTYPE_p_bool,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_bool",7,"SchemaElementDecl_findAttr"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->findAttr((XMLCh const *)arg2,arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getAttDefList) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDefList *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getAttDefList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getAttDefList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLAttDefList &_result_ref = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getAttDefList();
                    result = (XERCES_CPP_NAMESPACE::XMLAttDefList *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getCharDataOpts) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getCharDataOpts(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getCharDataOpts"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getCharDataOpts();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_hasAttDefs) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_hasAttDefs(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_hasAttDefs"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->hasAttDefs();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_resetDefs) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_resetDefs(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_resetDefs"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)(arg1)->resetDefs();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getContentSpec) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::ContentSpecNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getContentSpec(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getContentSpec"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::ContentSpecNode *)(arg1)->getContentSpec();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setContentSpec) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::ContentSpecNode *arg2 = (XERCES_CPP_NAMESPACE::ContentSpecNode *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setContentSpec(self,toAdopt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setContentSpec"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__ContentSpecNode",2,"SchemaElementDecl_setContentSpec"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setContentSpec(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getContentModel) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLContentModel *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getContentModel(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLContentModel *)(arg1)->getContentModel();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setContentModel) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLContentModel *arg2 = (XERCES_CPP_NAMESPACE::XMLContentModel *) (XERCES_CPP_NAMESPACE::XMLContentModel *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setContentModel(self,newModelToAdopt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setContentModel"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLContentModel",2,"SchemaElementDecl_setContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setContentModel(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getFormattedContentModel) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getFormattedContentModel(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getFormattedContentModel"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getFormattedContentModel();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getAttDef) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int arg3 ;
        SchemaAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: SchemaElementDecl_getAttDef(self,baseName,uriId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getAttDef"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaElementDecl_getAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (int) SvIV(ST(2));
        {
            try 
            {
                result = (SchemaAttDef *)(arg1)->getAttDef((XMLCh const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getAttWildCard) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        SchemaAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getAttWildCard(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getAttWildCard"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (SchemaAttDef *)(arg1)->getAttWildCard();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getModelType) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getModelType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getModelType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getModelType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getPSVIScope) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        PSVIDefs::PSVIScope result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getPSVIScope(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getPSVIScope"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getPSVIScope();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            PSVIDefs::PSVIScope * resultobj = new PSVIDefs::PSVIScope((PSVIDefs::PSVIScope &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_PSVIDefs__PSVIScope, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getDatatypeValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        DatatypeValidator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getDatatypeValidator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (DatatypeValidator *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getDatatypeValidator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getEnclosingScope) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getEnclosingScope(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getEnclosingScope"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getEnclosingScope();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getFinalSet) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getFinalSet(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getFinalSet"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getFinalSet();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getBlockSet) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getBlockSet(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getBlockSet"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getBlockSet();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getMiscFlags) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getMiscFlags(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getMiscFlags"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getMiscFlags();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getDefaultValue) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getDefaultValue(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getDefaultValue"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getDefaultValue();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getComplexTypeInfo) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        ComplexTypeInfo *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getComplexTypeInfo(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getComplexTypeInfo"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (ComplexTypeInfo *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getComplexTypeInfo();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_isGlobalDecl) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_isGlobalDecl(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_isGlobalDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->isGlobalDecl();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getSubstitutionGroupElem) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::SchemaElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getSubstitutionGroupElem(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getSubstitutionGroupElem"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::SchemaElementDecl *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getSubstitutionGroupElem();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getValidity) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        PSVIDefs::Validity result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getValidity(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getValidity"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getValidity();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            PSVIDefs::Validity * resultobj = new PSVIDefs::Validity((PSVIDefs::Validity &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_PSVIDefs__Validity, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getValidationAttempted) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        PSVIDefs::Validation result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getValidationAttempted(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getValidationAttempted"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getValidationAttempted();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            PSVIDefs::Validation * resultobj = new PSVIDefs::Validation((PSVIDefs::Validation &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_PSVIDefs__Validation, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getTypeType) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        PSVIDefs::Complexity result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getTypeType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getTypeType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getTypeType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            PSVIDefs::Complexity * resultobj = new PSVIDefs::Complexity((PSVIDefs::Complexity &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_PSVIDefs__Complexity, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getTypeUri) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getTypeUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getTypeUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getTypeUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getTypeName) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getTypeName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getTypeName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getTypeName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getTypeAnonymous) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getTypeAnonymous(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getTypeAnonymous"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getTypeAnonymous();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_isTypeDefinitionUnion) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_isTypeDefinitionUnion(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_isTypeDefinitionUnion"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->isTypeDefinitionUnion();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getMemberTypeUri) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getMemberTypeUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getMemberTypeUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getMemberTypeUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getMemberTypeAnonymous) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getMemberTypeAnonymous(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getMemberTypeAnonymous"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getMemberTypeAnonymous();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getMemberTypeName) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getMemberTypeName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getMemberTypeName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getMemberTypeName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getDOMTypeInfoUri) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getDOMTypeInfoUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getDOMTypeInfoUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getDOMTypeInfoUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getDOMTypeInfoName) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getDOMTypeInfoName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getDOMTypeInfoName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getDOMTypeInfoName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setElemId) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setElemId(self,elemId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setElemId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setElemId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setModelType) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setModelType(self,toSet);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setModelType"); goto fail; 
                }
            }
        }
        arg2 = (XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setModelType(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setPSVIScope) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        PSVIDefs::PSVIScope arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setPSVIScope(self,toSet);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setPSVIScope"); goto fail; 
                }
            }
        }
        {
            PSVIDefs::PSVIScope * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_PSVIDefs__PSVIScope,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_PSVIDefs__PSVIScope",2,"SchemaElementDecl_setPSVIScope"); goto fail; 
                }
            }
            arg2 = *argp;
        }
        {
            try 
            {
                (arg1)->setPSVIScope(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setDatatypeValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        DatatypeValidator *arg2 = (DatatypeValidator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setDatatypeValidator(self,newDatatypeValidator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DatatypeValidator",2,"SchemaElementDecl_setDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setDatatypeValidator(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setEnclosingScope) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setEnclosingScope(self,enclosingScope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setEnclosingScope"); goto fail; 
                }
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setEnclosingScope(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setFinalSet) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setFinalSet(self,finalSet);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setFinalSet"); goto fail; 
                }
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setFinalSet(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setBlockSet) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setBlockSet(self,blockSet);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setBlockSet"); goto fail; 
                }
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setBlockSet(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setMiscFlags) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setMiscFlags(self,flags);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setMiscFlags"); goto fail; 
                }
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setMiscFlags(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setDefaultValue) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setDefaultValue(self,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setDefaultValue"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaElementDecl_setDefaultValue");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setDefaultValue((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setComplexTypeInfo) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        ComplexTypeInfo *arg2 = (ComplexTypeInfo *) (ComplexTypeInfo *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setComplexTypeInfo(self,typeInfo);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setComplexTypeInfo"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo",2,"SchemaElementDecl_setComplexTypeInfo"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setComplexTypeInfo(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setXsiComplexTypeInfo) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        ComplexTypeInfo *arg2 = (ComplexTypeInfo *) (ComplexTypeInfo *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setXsiComplexTypeInfo(self,typeInfo);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setXsiComplexTypeInfo"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo",2,"SchemaElementDecl_setXsiComplexTypeInfo"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setXsiComplexTypeInfo(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setXsiSimpleTypeInfo) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        DatatypeValidator *arg2 = (DatatypeValidator *) (DatatypeValidator *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setXsiSimpleTypeInfo(self,dtv);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setXsiSimpleTypeInfo"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DatatypeValidator",2,"SchemaElementDecl_setXsiSimpleTypeInfo"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setXsiSimpleTypeInfo((DatatypeValidator const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setAttWildCard) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        SchemaAttDef *arg2 = (SchemaAttDef *) (SchemaAttDef *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setAttWildCard(self,attWildCard);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setAttWildCard"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",2,"SchemaElementDecl_setAttWildCard"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setAttWildCard(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setSubstitutionGroupElem) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg2 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) (XERCES_CPP_NAMESPACE::SchemaElementDecl *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setSubstitutionGroupElem(self,elemDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setSubstitutionGroupElem"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",2,"SchemaElementDecl_setSubstitutionGroupElem"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setSubstitutionGroupElem(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setValidity) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        PSVIDefs::Validity arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setValidity(self,valid);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setValidity"); goto fail; 
                }
            }
        }
        {
            PSVIDefs::Validity * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_PSVIDefs__Validity,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_PSVIDefs__Validity",2,"SchemaElementDecl_setValidity"); goto fail; 
                }
            }
            arg2 = *argp;
        }
        {
            try 
            {
                (arg1)->setValidity(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_setValidationAttempted) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        PSVIDefs::Validation arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_setValidationAttempted(self,validation);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_setValidationAttempted"); goto fail; 
                }
            }
        }
        {
            PSVIDefs::Validation * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_PSVIDefs__Validation,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_PSVIDefs__Validation",2,"SchemaElementDecl_setValidationAttempted"); goto fail; 
                }
            }
            arg2 = *argp;
        }
        {
            try 
            {
                (arg1)->setValidationAttempted(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_updateValidityFromElement) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar::GrammarType arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: SchemaElementDecl_updateValidityFromElement(self,decl,eleGrammar);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_updateValidityFromElement"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"SchemaElementDecl_updateValidityFromElement"); goto fail; 
                }
            }
        }
        arg3 = (XERCES_CPP_NAMESPACE::Grammar::GrammarType) SvIV(ST(2));
        {
            try 
            {
                (arg1)->updateValidityFromElement((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_updateValidityFromAttribute) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        SchemaAttDef *arg2 = (SchemaAttDef *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_updateValidityFromAttribute(self,def);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_updateValidityFromAttribute"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",2,"SchemaElementDecl_updateValidityFromAttribute"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->updateValidityFromAttribute((SchemaAttDef const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_reset) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_addIdentityConstraint) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        IdentityConstraint *arg2 = (IdentityConstraint *) (IdentityConstraint *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_addIdentityConstraint(self,ic);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_addIdentityConstraint"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_IdentityConstraint,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_IdentityConstraint",2,"SchemaElementDecl_addIdentityConstraint"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->addIdentityConstraint(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getIdentityConstraintCount) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getIdentityConstraintCount(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getIdentityConstraintCount"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getIdentityConstraintCount();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getIdentityConstraintAt) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        unsigned int arg2 ;
        IdentityConstraint *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaElementDecl_getIdentityConstraintAt(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getIdentityConstraintAt"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                result = (IdentityConstraint *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getIdentityConstraintAt(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_IdentityConstraint, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDecl_getObjectType) {
    {
        XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl::objectType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDecl_getObjectType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaElementDecl",1,"SchemaElementDecl_getObjectType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl::objectType)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getObjectType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaElementDeclEnumerator__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)0 ;
        bool arg2 ;
        XERCES_CPP_NAMESPACE::MemoryManager *arg3 = (XERCES_CPP_NAMESPACE::MemoryManager *) (XERCES_CPP_NAMESPACE::MemoryManager *)0 ;
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        arg3 = XERCES_CPP_NAMESPACE::XMLPlatformUtils::fgMemoryManager;
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_SchemaElementDeclEnumerator(toEnum,adopt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"new_SchemaElementDeclEnumerator"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >(arg1,arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaElementDeclEnumerator__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)0 ;
        bool arg2 ;
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_SchemaElementDeclEnumerator(toEnum,adopt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"new_SchemaElementDeclEnumerator"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >(arg1,arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaElementDeclEnumerator__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)0 ;
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_SchemaElementDeclEnumerator(toEnum);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"new_SchemaElementDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >(arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_SchemaElementDeclEnumerator) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_SchemaElementDeclEnumerator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"delete_SchemaElementDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaElementDeclEnumerator__SWIG_3) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_SchemaElementDeclEnumerator(XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const &);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"new_SchemaElementDeclEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const &)*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaElementDeclEnumerator) {
    dXSARGS;
    
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaElementDeclEnumerator__SWIG_2); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaElementDeclEnumerator__SWIG_3); return;
        }
    }
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaElementDeclEnumerator__SWIG_0); return;
            }
        }
    }
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaElementDeclEnumerator__SWIG_1); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'new_SchemaElementDeclEnumerator'");
    XSRETURN(0);
}


XS(_wrap_SchemaElementDeclEnumerator_hasMoreElements) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDeclEnumerator_hasMoreElements(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"SchemaElementDeclEnumerator_hasMoreElements"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *)arg1)->hasMoreElements();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDeclEnumerator_nextElement) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
        XERCES_CPP_NAMESPACE::SchemaElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDeclEnumerator_nextElement(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"SchemaElementDeclEnumerator_nextElement"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::SchemaElementDecl &_result_ref = (arg1)->nextElement();
                    result = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDeclEnumerator_Reset) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDeclEnumerator_Reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"SchemaElementDeclEnumerator_Reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->Reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDeclEnumerator_size) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDeclEnumerator_size(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"SchemaElementDeclEnumerator_size"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (int)((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *)arg1)->size();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDeclEnumerator_resetKey) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDeclEnumerator_resetKey(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"SchemaElementDeclEnumerator_resetKey"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->resetKey();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDeclEnumerator_nextElementKey) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
        void **arg2 = 0 ;
        int *arg3 = 0 ;
        int *arg4 = 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: SchemaElementDeclEnumerator_nextElementKey(self,void *&,int &,int &);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"SchemaElementDeclEnumerator_nextElementKey"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_p_void,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_p_void",2,"SchemaElementDeclEnumerator_nextElementKey"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_int,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_int",3,"SchemaElementDeclEnumerator_nextElementKey"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_int,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_int",4,"SchemaElementDeclEnumerator_nextElementKey"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->nextElementKey(*arg2,*arg3,*arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaElementDeclEnumerator_hasMoreKeys) {
    {
        XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaElementDeclEnumerator_hasMoreKeys(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t",1,"SchemaElementDeclEnumerator_hasMoreKeys"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *)arg1)->hasMoreKeys();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaGrammar) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_SchemaGrammar();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::SchemaGrammar *)new XERCES_CPP_NAMESPACE::SchemaGrammar();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_SchemaGrammar) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_SchemaGrammar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"delete_SchemaGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getGrammarType) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getGrammarType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getGrammarType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getGrammarType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getTargetNamespace) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getTargetNamespace(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getTargetNamespace"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getTargetNamespace();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_findOrAddElemDecl) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        bool *arg7 = 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: SchemaGrammar_findOrAddElemDecl(self,uriId,baseName,prefixName,qName,scope,wasAdded);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_findOrAddElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"SchemaGrammar_findOrAddElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        {
            if (SWIG_ConvertPtr(ST(6), (void **) &arg7, SWIGTYPE_p_bool,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_bool",7,"SchemaGrammar_findOrAddElemDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->findOrAddElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getElemId) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg5 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: SchemaGrammar_getElemId(self,uriId,baseName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getElemId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_getElemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_getElemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        arg5 = (unsigned int) SvUV(ST(4));
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getElemId(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getElemDecl__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg5 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: SchemaGrammar_getElemDecl(self,uriId,baseName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_getElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_getElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        arg5 = (unsigned int) SvUV(ST(4));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getElemDecl__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        unsigned int arg2 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_getElemDecl(self,elemId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getElemDecl) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_getElemDecl__SWIG_1); return;
            }
        }
    }
    if (items == 5) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvIOK(ST(4)) ? 1 : 0;
                        }
                        if (_v) {
                            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_getElemDecl__SWIG_0); return;
                        }
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'SchemaGrammar_getElemDecl'");
    XSRETURN(0);
}


XS(_wrap_SchemaGrammar_getNotationDecl) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLNotationDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_getNotationDecl(self,notName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getNotationDecl"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaGrammar_getNotationDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)(arg1)->getNotationDecl((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getValidated) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getValidated(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getValidated"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getValidated();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_putElemDecl__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        bool arg7 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: SchemaGrammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope,notDeclared);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"SchemaGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        arg7 = (bool) SvIV(ST(6));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,arg7);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_putElemDecl__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg6 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: SchemaGrammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        
        if (ST(3) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg4 = Perl2XMLString(ST(3));
        }
        
        
        if (ST(4) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",5,"SchemaGrammar_putElemDecl");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg5 = Perl2XMLString(ST(4));
        }
        
        arg6 = (unsigned int) SvUV(ST(5));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        
        delete[] arg4;
        
        
        delete[] arg5;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_putElemDecl__SWIG_2) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
        bool arg3 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: SchemaGrammar_putElemDecl(self,elemDecl,notDeclared);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"SchemaGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        arg3 = (bool) SvIV(ST(2));
        {
            try 
            {
                result = (unsigned int)(arg1)->putElemDecl(arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_putElemDecl__SWIG_3) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_putElemDecl(self,elemDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"SchemaGrammar_putElemDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)(arg1)->putElemDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_putElemDecl) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_putElemDecl__SWIG_3); return;
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = SvIOK(ST(2)) ? 1 : 0;
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_putElemDecl__SWIG_2); return;
                }
            }
        }
    }
    if (items == 6) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvOK(ST(4)) ? 1 : 0; 
                        }
                        if (_v) {
                            {
                                _v = SvIOK(ST(5)) ? 1 : 0;
                            }
                            if (_v) {
                                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_putElemDecl__SWIG_1); return;
                            }
                        }
                    }
                }
            }
        }
    }
    if (items == 7) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvOK(ST(3)) ? 1 : 0; 
                    }
                    if (_v) {
                        {
                            _v = SvOK(ST(4)) ? 1 : 0; 
                        }
                        if (_v) {
                            {
                                _v = SvIOK(ST(5)) ? 1 : 0;
                            }
                            if (_v) {
                                {
                                    _v = SvIOK(ST(6)) ? 1 : 0;
                                }
                                if (_v) {
                                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_putElemDecl__SWIG_0); return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'SchemaGrammar_putElemDecl'");
    XSRETURN(0);
}


XS(_wrap_SchemaGrammar_putNotationDecl) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLNotationDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) (XERCES_CPP_NAMESPACE::XMLNotationDecl *)0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_putNotationDecl(self,notationDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_putNotationDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLNotationDecl",2,"SchemaGrammar_putNotationDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->putNotationDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setValidated) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setValidated(self,newState);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setValidated"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setValidated(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_reset) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getElemEnumerator) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        SwigValueWrapper<XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > > result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getElemEnumerator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getElemEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getElemEnumerator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * resultobj = new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_SHADOW|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getNotationEnumerator) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        SwigValueWrapper<XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl > > result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getNotationEnumerator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getNotationEnumerator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getNotationEnumerator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl > * resultobj = new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl >((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl > &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__XMLNotationDecl_t, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getAttributeDeclRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getAttributeDeclRegistry(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getAttributeDeclRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getAttributeDeclRegistry();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XMLAttDef_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getComplexTypeRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getComplexTypeRegistry(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getComplexTypeRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getComplexTypeRegistry();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__ComplexTypeInfo_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getGroupInfoRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getGroupInfoRegistry(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getGroupInfoRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getGroupInfoRegistry();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesGroupInfo_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getAttGroupInfoRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getAttGroupInfoRegistry(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getAttGroupInfoRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getAttGroupInfoRegistry();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesAttGroupInfo_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getDatatypeRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        DatatypeValidatorFactory *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getDatatypeRegistry(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getDatatypeRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (DatatypeValidatorFactory *)(arg1)->getDatatypeRegistry();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_DatatypeValidatorFactory, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getNamespaceScope) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::NamespaceScope *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getNamespaceScope(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getNamespaceScope"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::NamespaceScope *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getNamespaceScope();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NamespaceScope, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getValidSubstitutionGroups) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getValidSubstitutionGroups(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getValidSubstitutionGroups"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getValidSubstitutionGroups();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_RefHash2KeysTableOfTValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getIDRefList) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XMLRefInfo > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getIDRefList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getIDRefList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (RefHashTableOf<XMLRefInfo > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getIDRefList();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_RefHashTableOfTXMLRefInfo_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getValidationContext) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        ValidationContext *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getValidationContext(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getValidationContext"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (ValidationContext *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getValidationContext();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_ValidationContext, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setTargetNamespace) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setTargetNamespace(self,targetNamespace);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setTargetNamespace"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaGrammar_setTargetNamespace");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setTargetNamespace((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setAttributeDeclRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *arg2 = (RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *) (RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setAttributeDeclRegistry(self,attReg);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setAttributeDeclRegistry"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XMLAttDef_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XMLAttDef_t",2,"SchemaGrammar_setAttributeDeclRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setAttributeDeclRegistry(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setComplexTypeRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *arg2 = (RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *) (RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setComplexTypeRegistry(self,other);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setComplexTypeRegistry"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__ComplexTypeInfo_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_RefHashTableOfTXERCES_CPP_NAMESPACE__ComplexTypeInfo_t",2,"SchemaGrammar_setComplexTypeRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setComplexTypeRegistry(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setGroupInfoRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *arg2 = (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *) (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setGroupInfoRegistry(self,other);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setGroupInfoRegistry"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesGroupInfo_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesGroupInfo_t",2,"SchemaGrammar_setGroupInfoRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setGroupInfoRegistry(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setAttGroupInfoRegistry) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *arg2 = (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *) (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setAttGroupInfoRegistry(self,other);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setAttGroupInfoRegistry"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesAttGroupInfo_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesAttGroupInfo_t",2,"SchemaGrammar_setAttGroupInfoRegistry"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setAttGroupInfoRegistry(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setNamespaceScope) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::NamespaceScope *arg2 = (XERCES_CPP_NAMESPACE::NamespaceScope *) (XERCES_CPP_NAMESPACE::NamespaceScope *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setNamespaceScope(self,nsScope);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setNamespaceScope"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NamespaceScope,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__NamespaceScope",2,"SchemaGrammar_setNamespaceScope"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setNamespaceScope(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setValidSubstitutionGroups) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *arg2 = (RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *) (RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setValidSubstitutionGroups(self,RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *const);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setValidSubstitutionGroups"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_RefHash2KeysTableOfTValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_RefHash2KeysTableOfTValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t_t",2,"SchemaGrammar_setValidSubstitutionGroups"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setValidSubstitutionGroups(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_setGrammarDescription) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg2 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_setGrammarDescription(self,XERCES_CPP_NAMESPACE::XMLGrammarDescription *);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_setGrammarDescription"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription",2,"SchemaGrammar_setGrammarDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setGrammarDescription(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getGrammarDescription) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLGrammarDescription *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getGrammarDescription(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getGrammarDescription"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getGrammarDescription();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_putGroupElemDecl) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_putGroupElemDecl(self,elemDecl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_putGroupElemDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLElementDecl",2,"SchemaGrammar_putGroupElemDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->putGroupElemDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_putAnnotation) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        void *arg2 = (void *) 0 ;
        XERCES_CPP_NAMESPACE::XSAnnotation *arg3 = (XERCES_CPP_NAMESPACE::XSAnnotation *) (XERCES_CPP_NAMESPACE::XSAnnotation *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: SchemaGrammar_putAnnotation(self,key,annotation);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_putAnnotation"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, 0,0) < 0) {
                SWIG_croak("Type error in argument 2 of SchemaGrammar_putAnnotation. Expected _p_void");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XSAnnotation",3,"SchemaGrammar_putAnnotation"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->putAnnotation(arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_addAnnotation) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XSAnnotation *arg2 = (XERCES_CPP_NAMESPACE::XSAnnotation *) (XERCES_CPP_NAMESPACE::XSAnnotation *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_addAnnotation(self,annotation);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_addAnnotation"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XSAnnotation",2,"SchemaGrammar_addAnnotation"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->addAnnotation(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getAnnotation__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        void *arg2 = (void *) (void *)0 ;
        XERCES_CPP_NAMESPACE::XSAnnotation *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaGrammar_getAnnotation(self,key);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getAnnotation"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, 0,0) < 0) {
                SWIG_croak("Type error in argument 2 of SchemaGrammar_getAnnotation. Expected _p_void");
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XSAnnotation *)(arg1)->getAnnotation((void const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getAnnotation__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        XERCES_CPP_NAMESPACE::XSAnnotation *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getAnnotation(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getAnnotation"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XSAnnotation *)(arg1)->getAnnotation();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaGrammar_getAnnotation) {
    dXSARGS;
    
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_getAnnotation__SWIG_1); return;
        }
    }
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, 0, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_getAnnotation__SWIG_0); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'SchemaGrammar_getAnnotation'");
    XSRETURN(0);
}


XS(_wrap_SchemaGrammar_getAnnotations) {
    {
        XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
        RefHashTableOf<XERCES_CPP_NAMESPACE::XSAnnotation > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaGrammar_getAnnotations(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaGrammar",1,"SchemaGrammar_getAnnotations"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (RefHashTableOf<XERCES_CPP_NAMESPACE::XSAnnotation > *)(arg1)->getAnnotations();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XSAnnotation_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaValidator__SWIG_0) {
    {
        XMLErrorReporter *arg1 = (XMLErrorReporter *) (XMLErrorReporter *)0 ;
        XERCES_CPP_NAMESPACE::SchemaValidator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_SchemaValidator(errReporter);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XMLErrorReporter,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XMLErrorReporter",1,"new_SchemaValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::SchemaValidator *)new XERCES_CPP_NAMESPACE::SchemaValidator(arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaValidator__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_SchemaValidator();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::SchemaValidator *)new XERCES_CPP_NAMESPACE::SchemaValidator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_SchemaValidator) {
    dXSARGS;
    
    if (items == 0) {
        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaValidator__SWIG_1); return;
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XMLErrorReporter, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaValidator__SWIG_0); return;
        }
    }
    
    croak("No matching function for overloaded 'new_SchemaValidator'");
    XSRETURN(0);
}


XS(_wrap_delete_SchemaValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_SchemaValidator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"delete_SchemaValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_getGrammar) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaValidator_getGrammar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_getGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::Grammar *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getGrammar();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_setGrammar) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XERCES_CPP_NAMESPACE::Grammar *arg2 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaValidator_setGrammar(self,aGrammar);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_setGrammar"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__Grammar",2,"SchemaValidator_setGrammar"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setGrammar(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_normalizeWhiteSpace) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XERCES_CPP_NAMESPACE::DatatypeValidator *arg2 = (XERCES_CPP_NAMESPACE::DatatypeValidator *) 0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XMLBuffer *arg4 = 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: SchemaValidator_normalizeWhiteSpace(self,dV,value,toFill);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_normalizeWhiteSpace"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DatatypeValidator",2,"SchemaValidator_normalizeWhiteSpace"); goto fail; 
                }
            }
        }
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaValidator_normalizeWhiteSpace");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_XMLBuffer,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XMLBuffer",4,"SchemaValidator_normalizeWhiteSpace"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->normalizeWhiteSpace(arg2,(XMLCh const *)arg3,*arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_setGrammarResolver) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XERCES_CPP_NAMESPACE::GrammarResolver *arg2 = (XERCES_CPP_NAMESPACE::GrammarResolver *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaValidator_setGrammarResolver(self,grammarResolver);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_setGrammarResolver"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__GrammarResolver,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__GrammarResolver",2,"SchemaValidator_setGrammarResolver"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setGrammarResolver(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_setXsiType) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        unsigned int arg4 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: SchemaValidator_setXsiType(self,prefix,localPart,uriId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_setXsiType"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaValidator_setXsiType");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaValidator_setXsiType");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        arg4 = (unsigned int) SvUV(ST(3));
        {
            try 
            {
                (arg1)->setXsiType((XMLCh const *)arg2,(XMLCh const *)arg3,arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_setNillable) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaValidator_setNillable(self,isNil);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_setNillable"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setNillable(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_setExitOnFirstFatal) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaValidator_setExitOnFirstFatal(self,newValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_setExitOnFirstFatal"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setExitOnFirstFatal(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_setDatatypeBuffer) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaValidator_setDatatypeBuffer(self,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_setDatatypeBuffer"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaValidator_setDatatypeBuffer");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setDatatypeBuffer((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_clearDatatypeBuffer) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaValidator_clearDatatypeBuffer(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_clearDatatypeBuffer"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->clearDatatypeBuffer();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_getCurrentTypeInfo) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XERCES_CPP_NAMESPACE::ComplexTypeInfo *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaValidator_getCurrentTypeInfo(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_getCurrentTypeInfo"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::ComplexTypeInfo *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getCurrentTypeInfo();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_getCurrentDatatypeValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XERCES_CPP_NAMESPACE::DatatypeValidator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaValidator_getCurrentDatatypeValidator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_getCurrentDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DatatypeValidator *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getCurrentDatatypeValidator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_getMostRecentAttrValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XERCES_CPP_NAMESPACE::DatatypeValidator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaValidator_getMostRecentAttrValidator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_getMostRecentAttrValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DatatypeValidator *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getMostRecentAttrValidator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_getErrorOccurred) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaValidator_getErrorOccurred(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_getErrorOccurred"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getErrorOccurred();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_getIsElemSpecified) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaValidator_getIsElemSpecified(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_getIsElemSpecified"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getIsElemSpecified();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaValidator_getNormalizedValue) {
    {
        XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaValidator_getNormalizedValue(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaValidator",1,"SchemaValidator_getNormalizedValue"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getNormalizedValue();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_SchemaAttDefList) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_SchemaAttDefList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"delete_SchemaAttDefList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_hasMoreElements) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDefList_hasMoreElements(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_hasMoreElements"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDefList const *)arg1)->hasMoreElements();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_isEmpty) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDefList_isEmpty(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_isEmpty"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDefList const *)arg1)->isEmpty();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_findAttDef__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        unsigned long arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: SchemaAttDefList_findAttDef(self,uriID,attName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_findAttDef"); goto fail; 
                }
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef(arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_findAttDef__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: SchemaAttDefList_findAttDef(self,attURI,attName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_findAttDef"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaAttDefList_findAttDef");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef((XMLCh const *)arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_findAttDef) {
    dXSARGS;
    
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvIOK(ST(1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaAttDefList_findAttDef__SWIG_0); return;
                }
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaAttDefList_findAttDef__SWIG_1); return;
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'SchemaAttDefList_findAttDef'");
    XSRETURN(0);
}


XS(_wrap_SchemaAttDefList_findAttDefLocalPart) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        unsigned long arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: SchemaAttDefList_findAttDefLocalPart(self,uriID,attLocalPart);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_findAttDefLocalPart"); goto fail; 
                }
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaAttDefList_findAttDefLocalPart");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDefLocalPart(arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_nextElement) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDefList_nextElement(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_nextElement"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->nextElement();
                    result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_Reset) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDefList_Reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_Reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->Reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_getAttDefCount) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDefList_getAttDefCount(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_getAttDefCount"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaAttDefList const *)arg1)->getAttDefCount();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDefList_getAttDef) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
        unsigned int arg2 ;
        XERCES_CPP_NAMESPACE::XMLAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDefList_getAttDef(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDefList",1,"SchemaAttDefList_getAttDef"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->getAttDef(arg2);
                    result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_SchemaAttDef) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_SchemaAttDef(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"delete_SchemaAttDef"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getFullName) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getFullName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getFullName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getFullName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_reset) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_reset(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_reset"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->reset();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getValidity) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        PSVIDefs::Validity result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getValidity(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getValidity"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getValidity();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            PSVIDefs::Validity * resultobj = new PSVIDefs::Validity((PSVIDefs::Validity &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_PSVIDefs__Validity, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getValidationAttempted) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        PSVIDefs::Validation result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getValidationAttempted(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getValidationAttempted"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getValidationAttempted();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            PSVIDefs::Validation * resultobj = new PSVIDefs::Validation((PSVIDefs::Validation &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_PSVIDefs__Validation, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getTypeType) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        PSVIDefs::Complexity result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getTypeType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getTypeType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getTypeType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            PSVIDefs::Complexity * resultobj = new PSVIDefs::Complexity((PSVIDefs::Complexity &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_PSVIDefs__Complexity, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getTypeUri) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getTypeUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getTypeUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getTypeUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getTypeName) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getTypeName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getTypeName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getTypeName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getTypeAnonymous) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getTypeAnonymous(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getTypeAnonymous"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getTypeAnonymous();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_isTypeDefinitionUnion) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_isTypeDefinitionUnion(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_isTypeDefinitionUnion"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->isTypeDefinitionUnion();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getMemberTypeUri) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getMemberTypeUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getMemberTypeUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getMemberTypeUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getMemberTypeAnonymous) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getMemberTypeAnonymous(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getMemberTypeAnonymous"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getMemberTypeAnonymous();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getMemberTypeName) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getMemberTypeName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getMemberTypeName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getMemberTypeName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getDOMTypeInfoUri) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getDOMTypeInfoUri(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getDOMTypeInfoUri"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getDOMTypeInfoUri();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getDOMTypeInfoName) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getDOMTypeInfoName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getDOMTypeInfoName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getDOMTypeInfoName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getElemId) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getElemId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getElemId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getElemId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getAttName) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::QName *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getAttName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getAttName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::QName *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getAttName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getDatatypeValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::DatatypeValidator *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getDatatypeValidator(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DatatypeValidator *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getDatatypeValidator();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getNamespaceList) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        ValueVectorOf<unsigned int > *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getNamespaceList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getNamespaceList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (ValueVectorOf<unsigned int > *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getNamespaceList();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_ValueVectorOfTunsigned_int_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getBaseAttDecl) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::SchemaAttDef *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getBaseAttDecl(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getBaseAttDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::SchemaAttDef *)(arg1)->getBaseAttDecl();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getPSVIScope) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        PSVIDefs::PSVIScope result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getPSVIScope(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getPSVIScope"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = ((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getPSVIScope();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        {
            PSVIDefs::PSVIScope * resultobj = new PSVIDefs::PSVIScope((PSVIDefs::PSVIScope &)result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_PSVIDefs__PSVIScope, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_getEnclosingCT) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::ComplexTypeInfo *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_getEnclosingCT(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_getEnclosingCT"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::ComplexTypeInfo *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getEnclosingCT();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setElemId) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        unsigned int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setElemId(self,newId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setElemId"); goto fail; 
                }
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        {
            try 
            {
                (arg1)->setElemId(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setAttName__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        int arg4 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: SchemaAttDef_setAttName(self,prefix,localPart,uriId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setAttName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaAttDef_setAttName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaAttDef_setAttName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        arg4 = (int) SvIV(ST(3));
        {
            try 
            {
                (arg1)->setAttName((XMLCh const *)arg2,(XMLCh const *)arg3,arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setAttName__SWIG_1) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: SchemaAttDef_setAttName(self,prefix,localPart);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setAttName"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"SchemaAttDef_setAttName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"SchemaAttDef_setAttName");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                (arg1)->setAttName((XMLCh const *)arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setAttName) {
    dXSARGS;
    
    if (items == 3) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaAttDef_setAttName__SWIG_1); return;
                }
            }
        }
    }
    if (items == 4) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    {
                        _v = SvIOK(ST(3)) ? 1 : 0;
                    }
                    if (_v) {
                        (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaAttDef_setAttName__SWIG_0); return;
                    }
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'SchemaAttDef_setAttName'");
    XSRETURN(0);
}


XS(_wrap_SchemaAttDef_setDatatypeValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::DatatypeValidator *arg2 = (XERCES_CPP_NAMESPACE::DatatypeValidator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setDatatypeValidator(self,newDatatypeValidator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DatatypeValidator",2,"SchemaAttDef_setDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setDatatypeValidator(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setAnyDatatypeValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::DatatypeValidator *arg2 = (XERCES_CPP_NAMESPACE::DatatypeValidator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setAnyDatatypeValidator(self,newDatatypeValidator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setAnyDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DatatypeValidator",2,"SchemaAttDef_setAnyDatatypeValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setAnyDatatypeValidator(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setBaseAttDecl) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg2 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) (XERCES_CPP_NAMESPACE::SchemaAttDef *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setBaseAttDecl(self,attDef);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setBaseAttDecl"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",2,"SchemaAttDef_setBaseAttDecl"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setBaseAttDecl(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setPSVIScope) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        PSVIDefs::PSVIScope arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setPSVIScope(self,toSet);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setPSVIScope"); goto fail; 
                }
            }
        }
        {
            PSVIDefs::PSVIScope * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_PSVIDefs__PSVIScope,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_PSVIDefs__PSVIScope",2,"SchemaAttDef_setPSVIScope"); goto fail; 
                }
            }
            arg2 = *argp;
        }
        {
            try 
            {
                (arg1)->setPSVIScope(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setMembertypeValidator) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::DatatypeValidator *arg2 = (XERCES_CPP_NAMESPACE::DatatypeValidator *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setMembertypeValidator(self,newDatatypeValidator);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setMembertypeValidator"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DatatypeValidator",2,"SchemaAttDef_setMembertypeValidator"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setMembertypeValidator((XERCES_CPP_NAMESPACE::DatatypeValidator const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setNamespaceList) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        ValueVectorOf<unsigned int > *arg2 = (ValueVectorOf<unsigned int > *) (ValueVectorOf<unsigned int > *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setNamespaceList(self,toSet);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setNamespaceList"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_ValueVectorOfTunsigned_int_t,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_ValueVectorOfTunsigned_int_t",2,"SchemaAttDef_setNamespaceList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setNamespaceList((ValueVectorOf<unsigned int > const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_resetNamespaceList) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SchemaAttDef_resetNamespaceList(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_resetNamespaceList"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->resetNamespaceList();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setValidity) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        PSVIDefs::Validity arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setValidity(self,valid);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setValidity"); goto fail; 
                }
            }
        }
        {
            PSVIDefs::Validity * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_PSVIDefs__Validity,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_PSVIDefs__Validity",2,"SchemaAttDef_setValidity"); goto fail; 
                }
            }
            arg2 = *argp;
        }
        {
            try 
            {
                (arg1)->setValidity(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setValidationAttempted) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        PSVIDefs::Validation arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setValidationAttempted(self,validation);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setValidationAttempted"); goto fail; 
                }
            }
        }
        {
            PSVIDefs::Validation * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_PSVIDefs__Validation,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_PSVIDefs__Validation",2,"SchemaAttDef_setValidationAttempted"); goto fail; 
                }
            }
            arg2 = *argp;
        }
        {
            try 
            {
                (arg1)->setValidationAttempted(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_SchemaAttDef_setEnclosingCT) {
    {
        XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
        XERCES_CPP_NAMESPACE::ComplexTypeInfo *arg2 = (XERCES_CPP_NAMESPACE::ComplexTypeInfo *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SchemaAttDef_setEnclosingCT(self,complexTypeInfo);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__SchemaAttDef",1,"SchemaAttDef_setEnclosingCT"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo",2,"SchemaAttDef_setEnclosingCT"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->setEnclosingCT(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_InputSource) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_InputSource(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"delete_InputSource"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_makeStream) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        XERCES_CPP_NAMESPACE::BinInputStream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: InputSource_makeStream(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_makeStream"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->makeStream();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_getEncoding) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: InputSource_getEncoding(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_getEncoding"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getEncoding();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_getPublicId) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: InputSource_getPublicId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_getPublicId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getPublicId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_getSystemId) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: InputSource_getSystemId(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_getSystemId"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getSystemId();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_getIssueFatalErrorIfNotFound) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: InputSource_getIssueFatalErrorIfNotFound(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_getIssueFatalErrorIfNotFound"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getIssueFatalErrorIfNotFound();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_getMemoryManager) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        XERCES_CPP_NAMESPACE::MemoryManager *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: InputSource_getMemoryManager(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_getMemoryManager"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getMemoryManager();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_setEncoding) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: InputSource_setEncoding(self,encodingStr);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_setEncoding"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"InputSource_setEncoding");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setEncoding((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_setPublicId) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: InputSource_setPublicId(self,publicId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_setPublicId"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"InputSource_setPublicId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setPublicId((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_setSystemId) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: InputSource_setSystemId(self,systemId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_setSystemId"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"InputSource_setSystemId");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setSystemId((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_InputSource_setIssueFatalErrorIfNotFound) {
    {
        XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: InputSource_setIssueFatalErrorIfNotFound(self,flag);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__InputSource",1,"InputSource_setIssueFatalErrorIfNotFound"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setIssueFatalErrorIfNotFound(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_LocalFileInputSource__SWIG_0) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::LocalFileInputSource *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_LocalFileInputSource(basePath,relativePath);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_LocalFileInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_LocalFileInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::LocalFileInputSource *)new XERCES_CPP_NAMESPACE::LocalFileInputSource((XMLCh const *)arg1,(XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_LocalFileInputSource__SWIG_1) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::LocalFileInputSource *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_LocalFileInputSource(filePath);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_LocalFileInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::LocalFileInputSource *)new XERCES_CPP_NAMESPACE::LocalFileInputSource((XMLCh const *)arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_LocalFileInputSource) {
    dXSARGS;
    
    if (items == 1) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_LocalFileInputSource__SWIG_1); return;
        }
    }
    if (items == 2) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_LocalFileInputSource__SWIG_0); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'new_LocalFileInputSource'");
    XSRETURN(0);
}


XS(_wrap_delete_LocalFileInputSource) {
    {
        XERCES_CPP_NAMESPACE::LocalFileInputSource *arg1 = (XERCES_CPP_NAMESPACE::LocalFileInputSource *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_LocalFileInputSource(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__LocalFileInputSource",1,"delete_LocalFileInputSource"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_LocalFileInputSource_makeStream) {
    {
        XERCES_CPP_NAMESPACE::LocalFileInputSource *arg1 = (XERCES_CPP_NAMESPACE::LocalFileInputSource *) 0 ;
        XERCES_CPP_NAMESPACE::BinInputStream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: LocalFileInputSource_makeStream(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__LocalFileInputSource",1,"LocalFileInputSource_makeStream"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::LocalFileInputSource const *)arg1)->makeStream();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_StdInInputSource) {
    {
        XERCES_CPP_NAMESPACE::StdInInputSource *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_StdInInputSource();");
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::StdInInputSource *)new XERCES_CPP_NAMESPACE::StdInInputSource();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdInInputSource, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_StdInInputSource) {
    {
        XERCES_CPP_NAMESPACE::StdInInputSource *arg1 = (XERCES_CPP_NAMESPACE::StdInInputSource *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_StdInInputSource(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdInInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__StdInInputSource",1,"delete_StdInInputSource"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_StdInInputSource_makeStream) {
    {
        XERCES_CPP_NAMESPACE::StdInInputSource *arg1 = (XERCES_CPP_NAMESPACE::StdInInputSource *) 0 ;
        XERCES_CPP_NAMESPACE::BinInputStream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: StdInInputSource_makeStream(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdInInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__StdInInputSource",1,"StdInInputSource_makeStream"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::StdInInputSource const *)arg1)->makeStream();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_URLInputSource__SWIG_0) {
    {
        XERCES_CPP_NAMESPACE::XMLURL *arg1 = 0 ;
        XERCES_CPP_NAMESPACE::URLInputSource *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_URLInputSource(urlId);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__XMLURL",1,"new_URLInputSource"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::URLInputSource *)new XERCES_CPP_NAMESPACE::URLInputSource((XERCES_CPP_NAMESPACE::XMLURL const &)*arg1);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_URLInputSource__SWIG_1) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::URLInputSource *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_URLInputSource(baseId,systemId);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_URLInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_URLInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::URLInputSource *)new XERCES_CPP_NAMESPACE::URLInputSource((XMLCh const *)arg1,(XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_URLInputSource__SWIG_2) {
    {
        XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        XERCES_CPP_NAMESPACE::URLInputSource *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: new_URLInputSource(baseId,systemId,publicId);");
        }
        
        if (ST(0) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",1,"new_URLInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg1 = Perl2XMLString(ST(0));
        }
        
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"new_URLInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"new_URLInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::URLInputSource *)new XERCES_CPP_NAMESPACE::URLInputSource((XMLCh const *)arg1,(XMLCh const *)arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg1;
        
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_URLInputSource) {
    dXSARGS;
    
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_URLInputSource__SWIG_0); return;
        }
    }
    if (items == 2) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_URLInputSource__SWIG_1); return;
            }
        }
    }
    if (items == 3) {
        int _v;
        {
            _v = SvOK(ST(0)) ? 1 : 0; 
        }
        if (_v) {
            {
                _v = SvOK(ST(1)) ? 1 : 0; 
            }
            if (_v) {
                {
                    _v = SvOK(ST(2)) ? 1 : 0; 
                }
                if (_v) {
                    (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_URLInputSource__SWIG_2); return;
                }
            }
        }
    }
    
    croak("No matching function for overloaded 'new_URLInputSource'");
    XSRETURN(0);
}


XS(_wrap_delete_URLInputSource) {
    {
        XERCES_CPP_NAMESPACE::URLInputSource *arg1 = (XERCES_CPP_NAMESPACE::URLInputSource *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_URLInputSource(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__URLInputSource",1,"delete_URLInputSource"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_URLInputSource_makeStream) {
    {
        XERCES_CPP_NAMESPACE::URLInputSource *arg1 = (XERCES_CPP_NAMESPACE::URLInputSource *) 0 ;
        XERCES_CPP_NAMESPACE::BinInputStream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: URLInputSource_makeStream(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__URLInputSource",1,"URLInputSource_makeStream"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::URLInputSource const *)arg1)->makeStream();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_URLInputSource_urlSrc) {
    {
        XERCES_CPP_NAMESPACE::URLInputSource *arg1 = (XERCES_CPP_NAMESPACE::URLInputSource *) 0 ;
        XERCES_CPP_NAMESPACE::XMLURL *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: URLInputSource_urlSrc(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__URLInputSource",1,"URLInputSource_urlSrc"); goto fail; 
                }
            }
        }
        {
            try 
            {
                {
                    XERCES_CPP_NAMESPACE::XMLURL const &_result_ref = ((XERCES_CPP_NAMESPACE::URLInputSource const *)arg1)->urlSrc();
                    result = (XERCES_CPP_NAMESPACE::XMLURL *) &_result_ref;
                }
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_MemBufInputSource) {
    {
        XMLByte *arg1 = (XMLByte *) (XMLByte *)0 ;
        unsigned int arg2 ;
        XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
        bool arg4 ;
        XERCES_CPP_NAMESPACE::MemBufInputSource *result;
        int argvi = 0;
        dXSARGS;
        
        arg4 = true;
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: new_MemBufInputSource(srcDocBytes,byteCount,bufId);");
        }
        {
            if (SvPOK(ST(0))||SvIOK(ST(0))||SvNOK(ST(0))) {
                STRLEN len;
                XMLByte *xmlbytes = (XMLByte *)SvPV(ST(0), len);
                arg2 = len;
                arg1 = new XMLByte[len];
                memcpy(arg1, xmlbytes, len);
            } else {
                SWIG_croak("Type error in argument 2 of new_MemBufInputSource, Expected perl-string.");
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"new_MemBufInputSource");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::MemBufInputSource *)new XERCES_CPP_NAMESPACE::MemBufInputSource((XMLByte const *)arg1,arg2,(XMLCh const *)arg3,arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource, SWIG_SHADOW|SWIG_OWNER);
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_MemBufInputSource) {
    {
        XERCES_CPP_NAMESPACE::MemBufInputSource *arg1 = (XERCES_CPP_NAMESPACE::MemBufInputSource *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_MemBufInputSource(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__MemBufInputSource",1,"delete_MemBufInputSource"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_MemBufInputSource_makeStream) {
    {
        XERCES_CPP_NAMESPACE::MemBufInputSource *arg1 = (XERCES_CPP_NAMESPACE::MemBufInputSource *) 0 ;
        XERCES_CPP_NAMESPACE::BinInputStream *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: MemBufInputSource_makeStream(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__MemBufInputSource",1,"MemBufInputSource_makeStream"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::MemBufInputSource const *)arg1)->makeStream();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_MemBufInputSource_setCopyBufToStream) {
    {
        XERCES_CPP_NAMESPACE::MemBufInputSource *arg1 = (XERCES_CPP_NAMESPACE::MemBufInputSource *) 0 ;
        bool arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: MemBufInputSource_setCopyBufToStream(self,newState);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__MemBufInputSource",1,"MemBufInputSource_setCopyBufToStream"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                (arg1)->setCopyBufToStream(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_MemBufInputSource_resetMemBufInputSource) {
    {
        XERCES_CPP_NAMESPACE::MemBufInputSource *arg1 = (XERCES_CPP_NAMESPACE::MemBufInputSource *) 0 ;
        XMLByte *arg2 = (XMLByte *) (XMLByte *)0 ;
        unsigned int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: MemBufInputSource_resetMemBufInputSource(self,srcDocBytes,byteCount);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__MemBufInputSource",1,"MemBufInputSource_resetMemBufInputSource"); goto fail; 
                }
            }
        }
        {
            if (SvPOK(ST(1))||SvIOK(ST(1))||SvNOK(ST(1))) {
                STRLEN len;
                XMLByte *xmlbytes = (XMLByte *)SvPV(ST(1), len);
                arg3 = len;
                arg2 = new XMLByte[len];
                memcpy(arg2, xmlbytes, len);
            } else {
                SWIG_croak("Type error in argument 2 of MemBufInputSource_resetMemBufInputSource, Expected perl-string.");
            }
        }
        {
            try 
            {
                (arg1)->resetMemBufInputSource((XMLByte const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_DOMException) {
    {
        XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DOMException(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMException",1,"delete_DOMException"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMException_getMessage) {
    {
        XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMException_getMessage(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMException",1,"DOMException_getMessage"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMException const *)arg1)->getMessage();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMException_code_set) {
    {
        XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
        XERCES_CPP_NAMESPACE::DOMException::ExceptionCode arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMException_code_set(self,code);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMException",1,"DOMException_code_set"); goto fail; 
                }
            }
        }
        arg2 = (XERCES_CPP_NAMESPACE::DOMException::ExceptionCode) SvIV(ST(1));
        if (arg1) (arg1)->code = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMException_code_get) {
    {
        XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
        XERCES_CPP_NAMESPACE::DOMException::ExceptionCode result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMException_code_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMException",1,"DOMException_code_get"); goto fail; 
                }
            }
        }
        result = (XERCES_CPP_NAMESPACE::DOMException::ExceptionCode) ((arg1)->code);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMException_msg_set) {
    {
        XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMException_msg_set(self,msg);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMException",1,"DOMException_msg_set"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMException_msg_set");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        if (arg1) (arg1)->msg = (XMLCh const *)arg2;
        
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMException_msg_get) {
    {
        XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMException_msg_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMException",1,"DOMException_msg_get"); goto fail; 
                }
            }
        }
        result = (XMLCh *) ((arg1)->msg);
        
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_DOMNode) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DOMNode(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"delete_DOMNode"); goto fail; 
                }
            }
        }
        {
            try 
            {
                delete arg1;
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getNodeName) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getNodeName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getNodeName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNodeName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getNodeValue) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getNodeValue(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getNodeValue"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNodeValue();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getNodeType) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        short result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getNodeType(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getNodeType"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (short)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNodeType();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getParentNode) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getParentNode(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getParentNode"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getParentNode();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getChildNodes) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNodeList *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getChildNodes(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getChildNodes"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNodeList *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getChildNodes();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeList, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getFirstChild) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getFirstChild(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getFirstChild"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getFirstChild();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getLastChild) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getLastChild(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getLastChild"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getLastChild();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getPreviousSibling) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getPreviousSibling(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getPreviousSibling"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getPreviousSibling();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getNextSibling) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getNextSibling(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getNextSibling"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNextSibling();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getAttributes) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNamedNodeMap *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getAttributes(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getAttributes"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNamedNodeMap *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getAttributes();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNamedNodeMap, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getOwnerDocument) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMDocument *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getOwnerDocument(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getOwnerDocument"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMDocument *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getOwnerDocument();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocument, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_cloneNode) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        bool arg2 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_cloneNode(self,deep);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_cloneNode"); goto fail; 
                }
            }
        }
        arg2 = (bool) SvIV(ST(1));
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->cloneNode(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_insertBefore) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg3 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: DOMNode_insertBefore(self,newChild,refChild);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_insertBefore"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",2,"DOMNode_insertBefore"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",3,"DOMNode_insertBefore"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->insertBefore(arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_replaceChild) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg3 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: DOMNode_replaceChild(self,newChild,oldChild);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_replaceChild"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",2,"DOMNode_replaceChild"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",3,"DOMNode_replaceChild"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->replaceChild(arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_removeChild) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_removeChild(self,oldChild);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_removeChild"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",2,"DOMNode_removeChild"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->removeChild(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_appendChild) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_appendChild(self,newChild);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_appendChild"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",2,"DOMNode_appendChild"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->appendChild(arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_hasChildNodes) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_hasChildNodes(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_hasChildNodes"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->hasChildNodes();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_setNodeValue) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_setNodeValue(self,nodeValue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_setNodeValue"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_setNodeValue");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setNodeValue((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_normalize) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_normalize(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_normalize"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->normalize();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_isSupported) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        XMLCh *arg3 = (XMLCh *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: DOMNode_isSupported(self,feature,version);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_isSupported"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_isSupported");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        
        if (ST(2) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",3,"DOMNode_isSupported");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg3 = Perl2XMLString(ST(2));
        }
        
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->isSupported((XMLCh const *)arg2,(XMLCh const *)arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        
        delete[] arg3;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getNamespaceURI) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getNamespaceURI(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getNamespaceURI"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNamespaceURI();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getLocalName) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getLocalName(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getLocalName"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getLocalName();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_setPrefix) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_setPrefix(self,prefix);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_setPrefix"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_setPrefix");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setPrefix((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_hasAttributes) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_hasAttributes(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_hasAttributes"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->hasAttributes();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_isSameNode) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_isSameNode(self,other);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_isSameNode"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",2,"DOMNode_isSameNode"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->isSameNode((XERCES_CPP_NAMESPACE::DOMNode const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_isEqualNode) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_isEqualNode(self,arg);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_isEqualNode"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",2,"DOMNode_isEqualNode"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->isEqualNode((XERCES_CPP_NAMESPACE::DOMNode const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_setUserData) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        void *arg3 = (void *) 0 ;
        XERCES_CPP_NAMESPACE::DOMUserDataHandler *arg4 = (XERCES_CPP_NAMESPACE::DOMUserDataHandler *) 0 ;
        void *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: DOMNode_setUserData(self,key,data,handler);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_setUserData"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_setUserData");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, 0,0) < 0) {
                SWIG_croak("Type error in argument 3 of DOMNode_setUserData. Expected _p_void");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMUserDataHandler,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMUserDataHandler",4,"DOMNode_setUserData"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (void *)(arg1)->setUserData((XMLCh const *)arg2,arg3,arg4);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_void, 0|0);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getUserData) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        void *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_getUserData(self,key);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getUserData"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_getUserData");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (void *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getUserData((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_void, 0|0);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getBaseURI) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getBaseURI(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getBaseURI"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getBaseURI();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_compareTreePosition) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        short result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_compareTreePosition(self,other);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_compareTreePosition"); goto fail; 
                }
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",2,"DOMNode_compareTreePosition"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (short)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->compareTreePosition((XERCES_CPP_NAMESPACE::DOMNode const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getTextContent) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_getTextContent(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getTextContent"); goto fail; 
                }
            }
        }
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getTextContent();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_setTextContent) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_setTextContent(self,textContent);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_setTextContent"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_setTextContent");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                (arg1)->setTextContent((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_lookupNamespacePrefix) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        bool arg3 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: DOMNode_lookupNamespacePrefix(self,namespaceURI,useDefault);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_lookupNamespacePrefix"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_lookupNamespacePrefix");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        arg3 = (bool) SvIV(ST(2));
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->lookupNamespacePrefix((XMLCh const *)arg2,arg3);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_isDefaultNamespace) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_isDefaultNamespace(self,namespaceURI);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_isDefaultNamespace"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_isDefaultNamespace");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->isDefaultNamespace((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_lookupNamespaceURI) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        XMLCh *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_lookupNamespaceURI(self,prefix);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_lookupNamespaceURI"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_lookupNamespaceURI");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->lookupNamespaceURI((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        ST(argvi) = XMLString2Perl(result);
        ++argvi;
        
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_getInterface) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XMLCh *arg2 = (XMLCh *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DOMNode_getInterface(self,feature);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_getInterface"); goto fail; 
                }
            }
        }
        
        if (ST(1) == &PL_sv_undef) {
            SWIG_Perl_NullRef("perl-string",2,"DOMNode_getInterface");
            goto fail;
        } else {
            // we convert *everything* into a string that isn't undef
            arg2 = Perl2XMLString(ST(1));
        }
        
        {
            try 
            {
                result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->getInterface((XMLCh const *)arg2);
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        {
            swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, (void **) &result);
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) result, ty, SWIG_SHADOW|0);
        }
        
        delete[] arg2;
        
        XSRETURN(argvi);
        fail:
        
        delete[] arg2;
        
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_release) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DOMNode_release(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode,0) < 0) {
                {
                    SWIG_Perl_TypeError("_p_XERCES_CPP_NAMESPACE__DOMNode",1,"DOMNode_release"); goto fail; 
                }
            }
        }
        {
            try 
            {
                (arg1)->release();
                
            } 
            catch (const XMLException& e)
            {
                makeXMLException(e);
                goto fail;
            }
            catch (const DOMException& e)
            {
                makeDOMException(e);
                goto fail;
            }
            catch (...)
            {
                SWIG_croak("Handling Unknown exception");
                goto fail;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DOMNode_operator_equal_to) {
    {
        XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
        XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 