#!/bin/sh
# xmlada-config.  Generated from xmlada-config.in by configure modified by hand for debian purpose

XMLADA_VERSION=@SOVERSION@
DEB_HOST_MULTIARCH="@DEB_HOST_MULTIARCH@"

prefix=/usr/
lib_dir=/usr/lib/${DEB_HOST_MULTIARCH}
cflags="-aI/usr/share/ada/adainclude/xmlada -aO${lib_dir}/ada/adalib/xmlada"
libs="-L${lib_dir} -lxmlada"
static_libs="${lib_dir}/libxmlada.a"
full_libs="-lxmlada"
static_full_libs="${lib_dir}/libxmlada.a"

usage()
{
   cat <<EOF
Usage: xmlada-config [OPTIONS]
Options:
        No option:
            Output all the flags (compiler and linker) required
            to compiler your program
        [--prefix]
            Output the directory in which XML/Ada is installed
        [--version|-v]
            Output the version of XML/Ada
        [--libs]
            Output the linker flags to use for XML/Ada
        [--cflags]
            Output the compiler flags to use for XML/Ada
        [--sax]
            Output all the flags to use for XML/Ada, provided
            you are not using the DOM module.
        [--static]
            Output all the flags (compiler and linker) required to
            compile a static version of your program
        [--static-sax]
            Output all the flags (compiler and linker) required to
            compile a static version of your program, omitting the
            DOM module.
EOF
}

# Can have the following values:
#   0 = none
#   1 = cflags
#   2 = libs
#   3 = sax
#   4 = full
#   5 = static
output_type=full
while test $# -gt 0; do
  case "$1" in
  -*=*) optarg=`echo "$1" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
  *) optarg= ;;
  esac

  case $1 in
    --help|-h)
      usage 1>&2
      exit 1
      ;;
    --prefix)
      echo $prefix
      output_type=none
      ;;
    --version|-v)
      echo XmlAda ${XMLADA_VERSION}
      exit 0
      ;;
    --libs)
      output_type=libs
      ;;
    --sax)
      output_type=sax
      ;;
    --cflags)
      output_type=cflags
      ;;
    --static)
      output_type=static
      ;;
    --static-sax)
      output_type=static_sax
      ;;
    *)
      usage 1>&2
      exit 1
      ;;
  esac
  shift
done

case $output_type in
   cflags) echo $cflags ;;
   libs)   echo $libs $full_libs;;
   sax)    echo $cflags -largs $libs ;;
   full)   echo $cflags -largs $libs $full_libs;;
   static) echo $cflags -largs $static_libs $static_full_libs;;
   static_sax)  echo $cflags -largs $static_libs ;;
esac
