#!/usr/bin/perl -w

use Xray::FluorescenceEXAFS;
BEGIN { $| = 1; print "1..5$/"; }
END {print "not ok 1$/" unless $loaded;}
$loaded = 1;
$i = 0;
print "ok ", ++$i, $/;

my $contents = {Y=>1, Ba=>2, Cu=>3, O=>7};

if (abs(0.000463 - Xray::FluorescenceEXAFS->mcmaster("Cu", "K")) < .00001) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};

if (abs(0.0006166 - Xray::FluorescenceEXAFS->i0("Cu", "K", {nitrogen=>0.5})) < 0.000001) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};

my @list = Xray::FluorescenceEXAFS->self("Cu", "K", $contents);
if (abs(1.28 - $list[0]) < 0.01) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
if (abs(0.0000573 - $list[1]) < 0.00001) {
  print "ok ", ++$i, $/
} else {
  print "not ok ", ++$i, $/
};
