# -*- ruby -*-
#
# tag text nodes.
#

require 'xtemplate'

data = {
  'members1' => ["name1", "name2", "name3"],
  'members2' => [
    {"name" => "name1", "uid" => 1},
    {"name" => "name2", "uid" => 2},
    {"name" => "name3", "uid" => 3},
  ]
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<members>
  <uids>
    <uid id="members2{untag(uid);text()}" />
  </uids>
  <member id="members1{tag(name)}">
     <name id="name" />
  </member>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
