# -*- ruby -*-
#
# An explicit iteration using the attribute 'each'
#

require 'xtemplate'

class MyEnumerable
  include Enumerable

  def each
    [
     {'url' => "url1", 'name' => "anchor1"},
     {'url' => "url2", 'name' => "anchor2"},
     {'url' => "url3", 'name' => "anchor3"},
    ].each{|link| yield(link)}
  end
end

data ={
  'links' => MyEnumerable.new()
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<html xmlns:xt="#{XTemplate::BIND_URI}">
<body>
  <ul>
    <li xt:each="/links">
       <a><xt:select id="url{@href}" /><xt:select id="name" /></a>
    </li>
  </ul>
</body>
</html>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
